<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_pending_list = new payment_plan_pending_list();

// Run the page
$payment_plan_pending_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_pending_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_plan_pending->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_plan_pendinglist = currentForm = new ew.Form("fpayment_plan_pendinglist", "list");
fpayment_plan_pendinglist.formKeyCountName = '<?php echo $payment_plan_pending_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_plan_pendinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_pendinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_pendinglist.lists["x_location"] = <?php echo $payment_plan_pending_list->location->Lookup->toClientList() ?>;
fpayment_plan_pendinglist.lists["x_location"].options = <?php echo JsonEncode($payment_plan_pending_list->location->lookupOptions()) ?>;
fpayment_plan_pendinglist.lists["x_process[]"] = <?php echo $payment_plan_pending_list->process->Lookup->toClientList() ?>;
fpayment_plan_pendinglist.lists["x_process[]"].options = <?php echo JsonEncode($payment_plan_pending_list->process->lookupOptions()) ?>;
fpayment_plan_pendinglist.lists["x_design_id"] = <?php echo $payment_plan_pending_list->design_id->Lookup->toClientList() ?>;
fpayment_plan_pendinglist.lists["x_design_id"].options = <?php echo JsonEncode($payment_plan_pending_list->design_id->lookupOptions()) ?>;
fpayment_plan_pendinglist.lists["x_product_type"] = <?php echo $payment_plan_pending_list->product_type->Lookup->toClientList() ?>;
fpayment_plan_pendinglist.lists["x_product_type"].options = <?php echo JsonEncode($payment_plan_pending_list->product_type->lookupOptions()) ?>;
fpayment_plan_pendinglist.lists["x_shape"] = <?php echo $payment_plan_pending_list->shape->Lookup->toClientList() ?>;
fpayment_plan_pendinglist.lists["x_shape"].options = <?php echo JsonEncode($payment_plan_pending_list->shape->lookupOptions()) ?>;
fpayment_plan_pendinglist.lists["x_cs"] = <?php echo $payment_plan_pending_list->cs->Lookup->toClientList() ?>;
fpayment_plan_pendinglist.lists["x_cs"].options = <?php echo JsonEncode($payment_plan_pending_list->cs->options(FALSE, TRUE)) ?>;

// Form object for search
var fpayment_plan_pendinglistsrch = currentSearchForm = new ew.Form("fpayment_plan_pendinglistsrch");

// Validate function for search
fpayment_plan_pendinglistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpayment_plan_pendinglistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_pendinglistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_pendinglistsrch.lists["x_location"] = <?php echo $payment_plan_pending_list->location->Lookup->toClientList() ?>;
fpayment_plan_pendinglistsrch.lists["x_location"].options = <?php echo JsonEncode($payment_plan_pending_list->location->lookupOptions()) ?>;
fpayment_plan_pendinglistsrch.lists["x_process[]"] = <?php echo $payment_plan_pending_list->process->Lookup->toClientList() ?>;
fpayment_plan_pendinglistsrch.lists["x_process[]"].options = <?php echo JsonEncode($payment_plan_pending_list->process->lookupOptions()) ?>;
fpayment_plan_pendinglistsrch.lists["x_design_id"] = <?php echo $payment_plan_pending_list->design_id->Lookup->toClientList() ?>;
fpayment_plan_pendinglistsrch.lists["x_design_id"].options = <?php echo JsonEncode($payment_plan_pending_list->design_id->lookupOptions()) ?>;
fpayment_plan_pendinglistsrch.lists["x_product_type"] = <?php echo $payment_plan_pending_list->product_type->Lookup->toClientList() ?>;
fpayment_plan_pendinglistsrch.lists["x_product_type"].options = <?php echo JsonEncode($payment_plan_pending_list->product_type->lookupOptions()) ?>;
fpayment_plan_pendinglistsrch.lists["x_shape"] = <?php echo $payment_plan_pending_list->shape->Lookup->toClientList() ?>;
fpayment_plan_pendinglistsrch.lists["x_shape"].options = <?php echo JsonEncode($payment_plan_pending_list->shape->lookupOptions()) ?>;
fpayment_plan_pendinglistsrch.lists["x_cs"] = <?php echo $payment_plan_pending_list->cs->Lookup->toClientList() ?>;
fpayment_plan_pendinglistsrch.lists["x_cs"].options = <?php echo JsonEncode($payment_plan_pending_list->cs->options(FALSE, TRUE)) ?>;

// Filters
fpayment_plan_pendinglistsrch.filterList = <?php echo $payment_plan_pending_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_plan_pendinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_plan_pending->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_plan_pending_list->TotalRecs > 0 && $payment_plan_pending_list->ExportOptions->visible()) { ?>
<?php $payment_plan_pending_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_pending_list->ImportOptions->visible()) { ?>
<?php $payment_plan_pending_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_pending_list->SearchOptions->visible()) { ?>
<?php $payment_plan_pending_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_pending_list->FilterOptions->visible()) { ?>
<?php $payment_plan_pending_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_plan_pending_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_plan_pending->isExport() && !$payment_plan_pending->CurrentAction) { ?>
<form name="fpayment_plan_pendinglistsrch" id="fpayment_plan_pendinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_plan_pending_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_plan_pendinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_plan_pending">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$payment_plan_pending_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$payment_plan_pending->RowType = ROWTYPE_SEARCH;

// Render row
$payment_plan_pending->resetAttributes();
$payment_plan_pending_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($payment_plan_pending->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $payment_plan_pending->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_pending" data-field="x_location" data-value-separator="<?php echo $payment_plan_pending->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $payment_plan_pending->location->editAttributes() ?>>
		<?php echo $payment_plan_pending->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $payment_plan_pending->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_pending->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $payment_plan_pending->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		<span class="ew-search-field">
<div id="tp_x_process" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan_pending" data-field="x_process" data-value-separator="<?php echo $payment_plan_pending->process->displayValueSeparatorAttribute() ?>" name="x_process[]" id="x_process[]" value="{value}"<?php echo $payment_plan_pending->process->editAttributes() ?>></div>
<div id="dsl_x_process" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payment_plan_pending->process->checkBoxListHtml(FALSE, "x_process[]") ?>
</div></div>
<?php echo $payment_plan_pending->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_pending->design_id->Visible) { // design_id ?>
	<div id="xsc_design_id" class="ew-cell form-group">
		<label for="x_design_id" class="ew-search-caption ew-label"><?php echo $payment_plan_pending->design_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="payment_plan_pending" data-field="x_design_id" name="x_design_id" id="x_design_id" size="30" placeholder="<?php echo HtmlEncode($payment_plan_pending->design_id->getPlaceHolder()) ?>" value="<?php echo $payment_plan_pending->design_id->EditValue ?>"<?php echo $payment_plan_pending->design_id->editAttributes() ?>>
<?php echo $payment_plan_pending->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($payment_plan_pending->product_type->Visible) { // product_type ?>
	<div id="xsc_product_type" class="ew-cell form-group">
		<label for="x_product_type" class="ew-search-caption ew-label"><?php echo $payment_plan_pending->product_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_pending" data-field="x_product_type" data-value-separator="<?php echo $payment_plan_pending->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $payment_plan_pending->product_type->editAttributes() ?>>
		<?php echo $payment_plan_pending->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $payment_plan_pending->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_pending->shape->Visible) { // shape ?>
	<div id="xsc_shape" class="ew-cell form-group">
		<label for="x_shape" class="ew-search-caption ew-label"><?php echo $payment_plan_pending->shape->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_pending" data-field="x_shape" data-value-separator="<?php echo $payment_plan_pending->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $payment_plan_pending->shape->editAttributes() ?>>
		<?php echo $payment_plan_pending->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $payment_plan_pending->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan_pending->cs->Visible) { // cs ?>
	<div id="xsc_cs" class="ew-cell form-group">
		<label for="x_cs" class="ew-search-caption ew-label"><?php echo $payment_plan_pending->cs->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cs" id="z_cs" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_pending" data-field="x_cs" data-value-separator="<?php echo $payment_plan_pending->cs->displayValueSeparatorAttribute() ?>" id="x_cs" name="x_cs"<?php echo $payment_plan_pending->cs->editAttributes() ?>>
		<?php echo $payment_plan_pending->cs->selectOptionListHtml("x_cs") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_plan_pending_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_plan_pending_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_plan_pending_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_plan_pending_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_pending_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_pending_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_pending_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_plan_pending_list->showPageHeader(); ?>
<?php
$payment_plan_pending_list->showMessage();
?>
<?php if ($payment_plan_pending_list->TotalRecs > 0 || $payment_plan_pending->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_plan_pending_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_plan_pending">
<?php if (!$payment_plan_pending->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_plan_pending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_pending_list->Pager)) $payment_plan_pending_list->Pager = new PrevNextPager($payment_plan_pending_list->StartRec, $payment_plan_pending_list->DisplayRecs, $payment_plan_pending_list->TotalRecs, $payment_plan_pending_list->AutoHidePager) ?>
<?php if ($payment_plan_pending_list->Pager->RecordCount > 0 && $payment_plan_pending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_pending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_pending_list->pageUrl() ?>start=<?php echo $payment_plan_pending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_pending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_pending_list->pageUrl() ?>start=<?php echo $payment_plan_pending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_pending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_pending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_pending_list->pageUrl() ?>start=<?php echo $payment_plan_pending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_pending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_pending_list->pageUrl() ?>start=<?php echo $payment_plan_pending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_pending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_pending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_pending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_pending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_pending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_pending_list->TotalRecs > 0 && (!$payment_plan_pending_list->AutoHidePageSizeSelector || $payment_plan_pending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan_pending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_pending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_pending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_pending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_pending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_pending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan_pending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_pending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_plan_pendinglist" id="fpayment_plan_pendinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_pending_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_pending_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan_pending">
<div id="gmp_payment_plan_pending" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_plan_pending_list->TotalRecs > 0 || $payment_plan_pending->isGridEdit()) { ?>
<table id="tbl_payment_plan_pendinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_plan_pending_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_plan_pending_list->renderListOptions();

// Render list options (header, left)
$payment_plan_pending_list->ListOptions->render("header", "left");
?>
<?php if ($payment_plan_pending->location->Visible) { // location ?>
	<?php if ($payment_plan_pending->sortUrl($payment_plan_pending->location) == "") { ?>
		<th data-name="location" class="<?php echo $payment_plan_pending->location->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_payment_plan_pending_location" class="payment_plan_pending_location"><div class="ew-table-header-caption"><?php echo $payment_plan_pending->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $payment_plan_pending->location->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_pending->SortUrl($payment_plan_pending->location) ?>',2);"><div id="elh_payment_plan_pending_location" class="payment_plan_pending_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_pending->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_pending->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_pending->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_pending->process->Visible) { // process ?>
	<?php if ($payment_plan_pending->sortUrl($payment_plan_pending->process) == "") { ?>
		<th data-name="process" class="<?php echo $payment_plan_pending->process->headerCellClass() ?>"><div id="elh_payment_plan_pending_process" class="payment_plan_pending_process"><div class="ew-table-header-caption"><?php echo $payment_plan_pending->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $payment_plan_pending->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_pending->SortUrl($payment_plan_pending->process) ?>',2);"><div id="elh_payment_plan_pending_process" class="payment_plan_pending_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_pending->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_pending->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_pending->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_pending->design_id->Visible) { // design_id ?>
	<?php if ($payment_plan_pending->sortUrl($payment_plan_pending->design_id) == "") { ?>
		<th data-name="design_id" class="<?php echo $payment_plan_pending->design_id->headerCellClass() ?>"><div id="elh_payment_plan_pending_design_id" class="payment_plan_pending_design_id"><div class="ew-table-header-caption"><?php echo $payment_plan_pending->design_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_id" class="<?php echo $payment_plan_pending->design_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_pending->SortUrl($payment_plan_pending->design_id) ?>',2);"><div id="elh_payment_plan_pending_design_id" class="payment_plan_pending_design_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_pending->design_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_pending->design_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_pending->design_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_pending->product_type->Visible) { // product_type ?>
	<?php if ($payment_plan_pending->sortUrl($payment_plan_pending->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $payment_plan_pending->product_type->headerCellClass() ?>"><div id="elh_payment_plan_pending_product_type" class="payment_plan_pending_product_type"><div class="ew-table-header-caption"><?php echo $payment_plan_pending->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $payment_plan_pending->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_pending->SortUrl($payment_plan_pending->product_type) ?>',2);"><div id="elh_payment_plan_pending_product_type" class="payment_plan_pending_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_pending->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_pending->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_pending->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_pending->shape->Visible) { // shape ?>
	<?php if ($payment_plan_pending->sortUrl($payment_plan_pending->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $payment_plan_pending->shape->headerCellClass() ?>"><div id="elh_payment_plan_pending_shape" class="payment_plan_pending_shape"><div class="ew-table-header-caption"><?php echo $payment_plan_pending->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $payment_plan_pending->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_pending->SortUrl($payment_plan_pending->shape) ?>',2);"><div id="elh_payment_plan_pending_shape" class="payment_plan_pending_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_pending->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_pending->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_pending->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan_pending->cs->Visible) { // cs ?>
	<?php if ($payment_plan_pending->sortUrl($payment_plan_pending->cs) == "") { ?>
		<th data-name="cs" class="<?php echo $payment_plan_pending->cs->headerCellClass() ?>"><div id="elh_payment_plan_pending_cs" class="payment_plan_pending_cs"><div class="ew-table-header-caption"><?php echo $payment_plan_pending->cs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cs" class="<?php echo $payment_plan_pending->cs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan_pending->SortUrl($payment_plan_pending->cs) ?>',2);"><div id="elh_payment_plan_pending_cs" class="payment_plan_pending_cs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan_pending->cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan_pending->cs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan_pending->cs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_plan_pending_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_plan_pending->ExportAll && $payment_plan_pending->isExport()) {
	$payment_plan_pending_list->StopRec = $payment_plan_pending_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_plan_pending_list->TotalRecs > $payment_plan_pending_list->StartRec + $payment_plan_pending_list->DisplayRecs - 1)
		$payment_plan_pending_list->StopRec = $payment_plan_pending_list->StartRec + $payment_plan_pending_list->DisplayRecs - 1;
	else
		$payment_plan_pending_list->StopRec = $payment_plan_pending_list->TotalRecs;
}
$payment_plan_pending_list->RecCnt = $payment_plan_pending_list->StartRec - 1;
if ($payment_plan_pending_list->Recordset && !$payment_plan_pending_list->Recordset->EOF) {
	$payment_plan_pending_list->Recordset->moveFirst();
	$selectLimit = $payment_plan_pending_list->UseSelectLimit;
	if (!$selectLimit && $payment_plan_pending_list->StartRec > 1)
		$payment_plan_pending_list->Recordset->move($payment_plan_pending_list->StartRec - 1);
} elseif (!$payment_plan_pending->AllowAddDeleteRow && $payment_plan_pending_list->StopRec == 0) {
	$payment_plan_pending_list->StopRec = $payment_plan_pending->GridAddRowCount;
}

// Initialize aggregate
$payment_plan_pending->RowType = ROWTYPE_AGGREGATEINIT;
$payment_plan_pending->resetAttributes();
$payment_plan_pending_list->renderRow();
while ($payment_plan_pending_list->RecCnt < $payment_plan_pending_list->StopRec) {
	$payment_plan_pending_list->RecCnt++;
	if ($payment_plan_pending_list->RecCnt >= $payment_plan_pending_list->StartRec) {
		$payment_plan_pending_list->RowCnt++;

		// Set up key count
		$payment_plan_pending_list->KeyCount = $payment_plan_pending_list->RowIndex;

		// Init row class and style
		$payment_plan_pending->resetAttributes();
		$payment_plan_pending->CssClass = "";
		if ($payment_plan_pending->isGridAdd()) {
		} else {
			$payment_plan_pending_list->loadRowValues($payment_plan_pending_list->Recordset); // Load row values
		}
		$payment_plan_pending->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_plan_pending->RowAttrs = array_merge($payment_plan_pending->RowAttrs, array('data-rowindex'=>$payment_plan_pending_list->RowCnt, 'id'=>'r' . $payment_plan_pending_list->RowCnt . '_payment_plan_pending', 'data-rowtype'=>$payment_plan_pending->RowType));

		// Render row
		$payment_plan_pending_list->renderRow();

		// Render list options
		$payment_plan_pending_list->renderListOptions();
?>
	<tr<?php echo $payment_plan_pending->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_plan_pending_list->ListOptions->render("body", "left", $payment_plan_pending_list->RowCnt);
?>
	<?php if ($payment_plan_pending->location->Visible) { // location ?>
		<td data-name="location"<?php echo $payment_plan_pending->location->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_pending_list->RowCnt ?>_payment_plan_pending_location" class="payment_plan_pending_location">
<span<?php echo $payment_plan_pending->location->viewAttributes() ?>>
<?php echo $payment_plan_pending->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_pending->process->Visible) { // process ?>
		<td data-name="process"<?php echo $payment_plan_pending->process->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_pending_list->RowCnt ?>_payment_plan_pending_process" class="payment_plan_pending_process">
<span<?php echo $payment_plan_pending->process->viewAttributes() ?>>
<?php echo $payment_plan_pending->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_pending->design_id->Visible) { // design_id ?>
		<td data-name="design_id"<?php echo $payment_plan_pending->design_id->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_pending_list->RowCnt ?>_payment_plan_pending_design_id" class="payment_plan_pending_design_id">
<span<?php echo $payment_plan_pending->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($payment_plan_pending->design_id->getViewValue())) && $payment_plan_pending->design_id->linkAttributes() <> "") { ?>
<a<?php echo $payment_plan_pending->design_id->linkAttributes() ?>><?php echo $payment_plan_pending->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_plan_pending->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_pending->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $payment_plan_pending->product_type->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_pending_list->RowCnt ?>_payment_plan_pending_product_type" class="payment_plan_pending_product_type">
<span<?php echo $payment_plan_pending->product_type->viewAttributes() ?>>
<?php echo $payment_plan_pending->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_pending->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $payment_plan_pending->shape->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_pending_list->RowCnt ?>_payment_plan_pending_shape" class="payment_plan_pending_shape">
<span<?php echo $payment_plan_pending->shape->viewAttributes() ?>>
<?php echo $payment_plan_pending->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan_pending->cs->Visible) { // cs ?>
		<td data-name="cs"<?php echo $payment_plan_pending->cs->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_pending_list->RowCnt ?>_payment_plan_pending_cs" class="payment_plan_pending_cs">
<span<?php echo $payment_plan_pending->cs->viewAttributes() ?>>
<?php echo $payment_plan_pending->cs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_plan_pending_list->ListOptions->render("body", "right", $payment_plan_pending_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_plan_pending->isGridAdd())
		$payment_plan_pending_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_plan_pending->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_plan_pending_list->Recordset)
	$payment_plan_pending_list->Recordset->Close();
?>
<?php if (!$payment_plan_pending->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_plan_pending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_pending_list->Pager)) $payment_plan_pending_list->Pager = new PrevNextPager($payment_plan_pending_list->StartRec, $payment_plan_pending_list->DisplayRecs, $payment_plan_pending_list->TotalRecs, $payment_plan_pending_list->AutoHidePager) ?>
<?php if ($payment_plan_pending_list->Pager->RecordCount > 0 && $payment_plan_pending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_pending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_pending_list->pageUrl() ?>start=<?php echo $payment_plan_pending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_pending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_pending_list->pageUrl() ?>start=<?php echo $payment_plan_pending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_pending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_pending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_pending_list->pageUrl() ?>start=<?php echo $payment_plan_pending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_pending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_pending_list->pageUrl() ?>start=<?php echo $payment_plan_pending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_pending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_pending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_pending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_pending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_pending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_pending_list->TotalRecs > 0 && (!$payment_plan_pending_list->AutoHidePageSizeSelector || $payment_plan_pending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan_pending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_pending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_pending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_pending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_pending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_pending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan_pending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_pending_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_plan_pending_list->TotalRecs == 0 && !$payment_plan_pending->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_plan_pending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_plan_pending_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_plan_pending->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_plan_pending->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_plan_pending", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_plan_pending_list->terminate();
?>