<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_pending_search = new payment_plan_pending_search();

// Run the page
$payment_plan_pending_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_pending_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($payment_plan_pending_search->IsModal) { ?>
var fpayment_plan_pendingsearch = currentAdvancedSearchForm = new ew.Form("fpayment_plan_pendingsearch", "search");
<?php } else { ?>
var fpayment_plan_pendingsearch = currentForm = new ew.Form("fpayment_plan_pendingsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpayment_plan_pendingsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plan_pendingsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plan_pendingsearch.lists["x_location"] = <?php echo $payment_plan_pending_search->location->Lookup->toClientList() ?>;
fpayment_plan_pendingsearch.lists["x_location"].options = <?php echo JsonEncode($payment_plan_pending_search->location->lookupOptions()) ?>;
fpayment_plan_pendingsearch.lists["x_design_id"] = <?php echo $payment_plan_pending_search->design_id->Lookup->toClientList() ?>;
fpayment_plan_pendingsearch.lists["x_design_id"].options = <?php echo JsonEncode($payment_plan_pending_search->design_id->lookupOptions()) ?>;
fpayment_plan_pendingsearch.lists["x_product_type"] = <?php echo $payment_plan_pending_search->product_type->Lookup->toClientList() ?>;
fpayment_plan_pendingsearch.lists["x_product_type"].options = <?php echo JsonEncode($payment_plan_pending_search->product_type->lookupOptions()) ?>;
fpayment_plan_pendingsearch.lists["x_shape"] = <?php echo $payment_plan_pending_search->shape->Lookup->toClientList() ?>;
fpayment_plan_pendingsearch.lists["x_shape"].options = <?php echo JsonEncode($payment_plan_pending_search->shape->lookupOptions()) ?>;
fpayment_plan_pendingsearch.lists["x_cs"] = <?php echo $payment_plan_pending_search->cs->Lookup->toClientList() ?>;
fpayment_plan_pendingsearch.lists["x_cs"].options = <?php echo JsonEncode($payment_plan_pending_search->cs->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fpayment_plan_pendingsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_plan_pending_search->showPageHeader(); ?>
<?php
$payment_plan_pending_search->showMessage();
?>
<form name="fpayment_plan_pendingsearch" id="fpayment_plan_pendingsearch" class="<?php echo $payment_plan_pending_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_pending_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_pending_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan_pending">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$payment_plan_pending_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($payment_plan_pending->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $payment_plan_pending_search->LeftColumnClass ?>"><span id="elh_payment_plan_pending_location"><?php echo $payment_plan_pending->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_pending_search->RightColumnClass ?>"><div<?php echo $payment_plan_pending->location->cellAttributes() ?>>
			<span id="el_payment_plan_pending_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_pending" data-field="x_location" data-value-separator="<?php echo $payment_plan_pending->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $payment_plan_pending->location->editAttributes() ?>>
		<?php echo $payment_plan_pending->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $payment_plan_pending->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_pending->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $payment_plan_pending_search->LeftColumnClass ?>"><span id="elh_payment_plan_pending_design_id"><?php echo $payment_plan_pending->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_design_id" id="z_design_id" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_pending_search->RightColumnClass ?>"><div<?php echo $payment_plan_pending->design_id->cellAttributes() ?>>
			<span id="el_payment_plan_pending_design_id">
<input type="text" data-table="payment_plan_pending" data-field="x_design_id" name="x_design_id" id="x_design_id" size="30" placeholder="<?php echo HtmlEncode($payment_plan_pending->design_id->getPlaceHolder()) ?>" value="<?php echo $payment_plan_pending->design_id->EditValue ?>"<?php echo $payment_plan_pending->design_id->editAttributes() ?>>
<?php echo $payment_plan_pending->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_pending->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label for="x_product_type" class="<?php echo $payment_plan_pending_search->LeftColumnClass ?>"><span id="elh_payment_plan_pending_product_type"><?php echo $payment_plan_pending->product_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_type" id="z_product_type" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_pending_search->RightColumnClass ?>"><div<?php echo $payment_plan_pending->product_type->cellAttributes() ?>>
			<span id="el_payment_plan_pending_product_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_pending" data-field="x_product_type" data-value-separator="<?php echo $payment_plan_pending->product_type->displayValueSeparatorAttribute() ?>" id="x_product_type" name="x_product_type"<?php echo $payment_plan_pending->product_type->editAttributes() ?>>
		<?php echo $payment_plan_pending->product_type->selectOptionListHtml("x_product_type") ?>
	</select>
</div>
<?php echo $payment_plan_pending->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_pending->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label for="x_shape" class="<?php echo $payment_plan_pending_search->LeftColumnClass ?>"><span id="elh_payment_plan_pending_shape"><?php echo $payment_plan_pending->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_shape" id="z_shape" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_pending_search->RightColumnClass ?>"><div<?php echo $payment_plan_pending->shape->cellAttributes() ?>>
			<span id="el_payment_plan_pending_shape">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_pending" data-field="x_shape" data-value-separator="<?php echo $payment_plan_pending->shape->displayValueSeparatorAttribute() ?>" id="x_shape" name="x_shape"<?php echo $payment_plan_pending->shape->editAttributes() ?>>
		<?php echo $payment_plan_pending->shape->selectOptionListHtml("x_shape") ?>
	</select>
</div>
<?php echo $payment_plan_pending->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan_pending->cs->Visible) { // cs ?>
	<div id="r_cs" class="form-group row">
		<label for="x_cs" class="<?php echo $payment_plan_pending_search->LeftColumnClass ?>"><span id="elh_payment_plan_pending_cs"><?php echo $payment_plan_pending->cs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cs" id="z_cs" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_pending_search->RightColumnClass ?>"><div<?php echo $payment_plan_pending->cs->cellAttributes() ?>>
			<span id="el_payment_plan_pending_cs">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan_pending" data-field="x_cs" data-value-separator="<?php echo $payment_plan_pending->cs->displayValueSeparatorAttribute() ?>" id="x_cs" name="x_cs"<?php echo $payment_plan_pending->cs->editAttributes() ?>>
		<?php echo $payment_plan_pending->cs->selectOptionListHtml("x_cs") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_plan_pending_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_plan_pending_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_plan_pending_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_plan_pending_search->terminate();
?>