<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_edit = new payment_plan_edit();

// Run the page
$payment_plan_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpayment_planedit = currentForm = new ew.Form("fpayment_planedit", "edit");

// Validate form
fpayment_planedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($payment_plan_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->id->caption(), $payment_plan->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->plan_type->Required) { ?>
			elm = this.getElements("x" + infix + "_plan_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->plan_type->caption(), $payment_plan->plan_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->location->caption(), $payment_plan->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->from_date->Required) { ?>
			elm = this.getElements("x" + infix + "_from_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->from_date->caption(), $payment_plan->from_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_from_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan->from_date->errorMessage()) ?>");
		<?php if ($payment_plan_edit->to_date->Required) { ?>
			elm = this.getElements("x" + infix + "_to_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->to_date->caption(), $payment_plan->to_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_to_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan->to_date->errorMessage()) ?>");
		<?php if ($payment_plan_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->grp->caption(), $payment_plan->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->s_grp->caption(), $payment_plan->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->process->Required) { ?>
			elm = this.getElements("x" + infix + "_process");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->process->caption(), $payment_plan->process->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->product_type->Required) { ?>
			elm = this.getElements("x" + infix + "_product_type[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->product_type->caption(), $payment_plan->product_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->shape->Required) { ?>
			elm = this.getElements("x" + infix + "_shape[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->shape->caption(), $payment_plan->shape->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->selection->Required) { ?>
			elm = this.getElements("x" + infix + "_selection");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->selection->caption(), $payment_plan->selection->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->gcode->Required) { ?>
			elm = this.getElements("x" + infix + "_gcode[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->gcode->caption(), $payment_plan->gcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->ref->Required) { ?>
			elm = this.getElements("x" + infix + "_ref[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->ref->caption(), $payment_plan->ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->description->caption(), $payment_plan->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->yes_no->Required) { ?>
			elm = this.getElements("x" + infix + "_yes_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->yes_no->caption(), $payment_plan->yes_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->packing_payment_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_payment_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->packing_payment_type->caption(), $payment_plan->packing_payment_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->fix->Required) { ?>
			elm = this.getElements("x" + infix + "_fix");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->fix->caption(), $payment_plan->fix->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->method->Required) { ?>
			elm = this.getElements("x" + infix + "_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->method->caption(), $payment_plan->method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->sqm_method->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->sqm_method->caption(), $payment_plan->sqm_method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->unit->Required) { ?>
			elm = this.getElements("x" + infix + "_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->unit->caption(), $payment_plan->unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->_40_unit->Required) { ?>
			elm = this.getElements("x" + infix + "__40_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->_40_unit->caption(), $payment_plan->_40_unit->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40_unit");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan->_40_unit->errorMessage()) ?>");
		<?php if ($payment_plan_edit->_40->Required) { ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->_40->caption(), $payment_plan->_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan->_40->errorMessage()) ?>");
		<?php if ($payment_plan_edit->extra_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_extra_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->extra_plan->caption(), $payment_plan->extra_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->custom_size->Required) { ?>
			elm = this.getElements("x" + infix + "_custom_size");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->custom_size->caption(), $payment_plan->custom_size->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_custom_size");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan->custom_size->errorMessage()) ?>");
		<?php if ($payment_plan_edit->custom_size_below_st->Required) { ?>
			elm = this.getElements("x" + infix + "_custom_size_below_st");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->custom_size_below_st->caption(), $payment_plan->custom_size_below_st->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_custom_size_below_st");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment_plan->custom_size_below_st->errorMessage()) ?>");
		<?php if ($payment_plan_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->status->caption(), $payment_plan->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->operator->caption(), $payment_plan->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->datetime->caption(), $payment_plan->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_plan_edit->uploads->Required) { ?>
			elm = this.getElements("x" + infix + "_uploads");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment_plan->uploads->caption(), $payment_plan->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpayment_planedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_planedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_planedit.lists["x_plan_type"] = <?php echo $payment_plan_edit->plan_type->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_plan_type"].options = <?php echo JsonEncode($payment_plan_edit->plan_type->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_location[]"] = <?php echo $payment_plan_edit->location->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_location[]"].options = <?php echo JsonEncode($payment_plan_edit->location->lookupOptions()) ?>;
fpayment_planedit.lists["x_grp"] = <?php echo $payment_plan_edit->grp->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_grp"].options = <?php echo JsonEncode($payment_plan_edit->grp->lookupOptions()) ?>;
fpayment_planedit.lists["x_s_grp"] = <?php echo $payment_plan_edit->s_grp->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_s_grp"].options = <?php echo JsonEncode($payment_plan_edit->s_grp->lookupOptions()) ?>;
fpayment_planedit.lists["x_process"] = <?php echo $payment_plan_edit->process->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_process"].options = <?php echo JsonEncode($payment_plan_edit->process->lookupOptions()) ?>;
fpayment_planedit.lists["x_product_type[]"] = <?php echo $payment_plan_edit->product_type->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_product_type[]"].options = <?php echo JsonEncode($payment_plan_edit->product_type->lookupOptions()) ?>;
fpayment_planedit.lists["x_shape[]"] = <?php echo $payment_plan_edit->shape->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_shape[]"].options = <?php echo JsonEncode($payment_plan_edit->shape->lookupOptions()) ?>;
fpayment_planedit.lists["x_selection"] = <?php echo $payment_plan_edit->selection->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_selection"].options = <?php echo JsonEncode($payment_plan_edit->selection->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_gcode[]"] = <?php echo $payment_plan_edit->gcode->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_gcode[]"].options = <?php echo JsonEncode($payment_plan_edit->gcode->lookupOptions()) ?>;
fpayment_planedit.lists["x_ref[]"] = <?php echo $payment_plan_edit->ref->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_ref[]"].options = <?php echo JsonEncode($payment_plan_edit->ref->lookupOptions()) ?>;
fpayment_planedit.lists["x_yes_no"] = <?php echo $payment_plan_edit->yes_no->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_yes_no"].options = <?php echo JsonEncode($payment_plan_edit->yes_no->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_packing_payment_type"] = <?php echo $payment_plan_edit->packing_payment_type->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_packing_payment_type"].options = <?php echo JsonEncode($payment_plan_edit->packing_payment_type->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_fix"] = <?php echo $payment_plan_edit->fix->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_fix"].options = <?php echo JsonEncode($payment_plan_edit->fix->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_method"] = <?php echo $payment_plan_edit->method->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_method"].options = <?php echo JsonEncode($payment_plan_edit->method->lookupOptions()) ?>;
fpayment_planedit.lists["x_sqm_method"] = <?php echo $payment_plan_edit->sqm_method->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_sqm_method"].options = <?php echo JsonEncode($payment_plan_edit->sqm_method->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_unit"] = <?php echo $payment_plan_edit->unit->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_unit"].options = <?php echo JsonEncode($payment_plan_edit->unit->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_extra_plan"] = <?php echo $payment_plan_edit->extra_plan->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_extra_plan"].options = <?php echo JsonEncode($payment_plan_edit->extra_plan->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_status"] = <?php echo $payment_plan_edit->status->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_status"].options = <?php echo JsonEncode($payment_plan_edit->status->options(FALSE, TRUE)) ?>;
fpayment_planedit.lists["x_operator"] = <?php echo $payment_plan_edit->operator->Lookup->toClientList() ?>;
fpayment_planedit.lists["x_operator"].options = <?php echo JsonEncode($payment_plan_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
			var sel = $("#x_selection").val();
				if (sel == 0)
				{
				$("#r_gcode").hide();
				$("#r_ref").hide();
				$('#dsl_x_gcode input[type=checkbox]').prop('checked', false);
				$('#dsl_x_ref input[type=checkbox]').prop('checked', false);
				} else {
				$("#r_gcode").show();
				$("#r_ref").show();
				}		
</script>
<?php $payment_plan_edit->showPageHeader(); ?>
<?php
$payment_plan_edit->showMessage();
?>
<form name="fpayment_planedit" id="fpayment_planedit" class="<?php echo $payment_plan_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$payment_plan_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($payment_plan->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_payment_plan_id" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->id->caption() ?><?php echo ($payment_plan->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->id->cellAttributes() ?>>
<span id="el_payment_plan_id">
<span<?php echo $payment_plan->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($payment_plan->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="payment_plan" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($payment_plan->id->CurrentValue) ?>">
<?php echo $payment_plan->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->plan_type->Visible) { // plan_type ?>
	<div id="r_plan_type" class="form-group row">
		<label id="elh_payment_plan_plan_type" for="x_plan_type" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->plan_type->caption() ?><?php echo ($payment_plan->plan_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->plan_type->cellAttributes() ?>>
<span id="el_payment_plan_plan_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_plan_type" data-value-separator="<?php echo $payment_plan->plan_type->displayValueSeparatorAttribute() ?>" id="x_plan_type" name="x_plan_type"<?php echo $payment_plan->plan_type->editAttributes() ?>>
		<?php echo $payment_plan->plan_type->selectOptionListHtml("x_plan_type") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->plan_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_payment_plan_location" for="x_location" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->location->caption() ?><?php echo ($payment_plan->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->location->cellAttributes() ?>>
<span id="el_payment_plan_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_location" data-value-separator="<?php echo $payment_plan->location->displayValueSeparatorAttribute() ?>" id="x_location[]" name="x_location[]" multiple="multiple"<?php echo $payment_plan->location->editAttributes() ?>>
		<?php echo $payment_plan->location->selectOptionListHtml("x_location[]") ?>
	</select>
</div>
<?php echo $payment_plan->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $payment_plan->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->from_date->Visible) { // from_date ?>
	<div id="r_from_date" class="form-group row">
		<label id="elh_payment_plan_from_date" for="x_from_date" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->from_date->caption() ?><?php echo ($payment_plan->from_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->from_date->cellAttributes() ?>>
<span id="el_payment_plan_from_date">
<input type="text" data-table="payment_plan" data-field="x_from_date" name="x_from_date" id="x_from_date" placeholder="<?php echo HtmlEncode($payment_plan->from_date->getPlaceHolder()) ?>" value="<?php echo $payment_plan->from_date->EditValue ?>"<?php echo $payment_plan->from_date->editAttributes() ?>>
<?php if (!$payment_plan->from_date->ReadOnly && !$payment_plan->from_date->Disabled && !isset($payment_plan->from_date->EditAttrs["readonly"]) && !isset($payment_plan->from_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_planedit", "x_from_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $payment_plan->from_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->to_date->Visible) { // to_date ?>
	<div id="r_to_date" class="form-group row">
		<label id="elh_payment_plan_to_date" for="x_to_date" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->to_date->caption() ?><?php echo ($payment_plan->to_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->to_date->cellAttributes() ?>>
<span id="el_payment_plan_to_date">
<input type="text" data-table="payment_plan" data-field="x_to_date" name="x_to_date" id="x_to_date" placeholder="<?php echo HtmlEncode($payment_plan->to_date->getPlaceHolder()) ?>" value="<?php echo $payment_plan->to_date->EditValue ?>"<?php echo $payment_plan->to_date->editAttributes() ?>>
<?php if (!$payment_plan->to_date->ReadOnly && !$payment_plan->to_date->Disabled && !isset($payment_plan->to_date->EditAttrs["readonly"]) && !isset($payment_plan->to_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_planedit", "x_to_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $payment_plan->to_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_payment_plan_grp" for="x_grp" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->grp->caption() ?><?php echo ($payment_plan->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->grp->cellAttributes() ?>>
<span id="el_payment_plan_grp">
<span<?php echo $payment_plan->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($payment_plan->grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="payment_plan" data-field="x_grp" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($payment_plan->grp->CurrentValue) ?>">
<?php echo $payment_plan->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_payment_plan_s_grp" for="x_s_grp" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->s_grp->caption() ?><?php echo ($payment_plan->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->s_grp->cellAttributes() ?>>
<span id="el_payment_plan_s_grp">
<?php $payment_plan->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$payment_plan->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_s_grp" data-value-separator="<?php echo $payment_plan->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $payment_plan->s_grp->editAttributes() ?>>
		<?php echo $payment_plan->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $payment_plan->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $payment_plan->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label id="elh_payment_plan_process" for="x_process" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->process->caption() ?><?php echo ($payment_plan->process->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->process->cellAttributes() ?>>
<span id="el_payment_plan_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_process" data-value-separator="<?php echo $payment_plan->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $payment_plan->process->editAttributes() ?>>
		<?php echo $payment_plan->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $payment_plan->process->Lookup->getParamTag("p_x_process") ?>
</span>
<?php echo $payment_plan->process->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label id="elh_payment_plan_product_type" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->product_type->caption() ?><?php echo ($payment_plan->product_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->product_type->cellAttributes() ?>>
<span id="el_payment_plan_product_type">
<div id="tp_x_product_type" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_product_type" data-value-separator="<?php echo $payment_plan->product_type->displayValueSeparatorAttribute() ?>" name="x_product_type[]" id="x_product_type[]" value="{value}"<?php echo $payment_plan->product_type->editAttributes() ?>></div>
<div id="dsl_x_product_type" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $payment_plan->product_type->checkBoxListHtml(FALSE, "x_product_type[]") ?>
</div></div>
<?php echo $payment_plan->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
<?php echo $payment_plan->product_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label id="elh_payment_plan_shape" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->shape->caption() ?><?php echo ($payment_plan->shape->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->shape->cellAttributes() ?>>
<span id="el_payment_plan_shape">
<div id="tp_x_shape" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_shape" data-value-separator="<?php echo $payment_plan->shape->displayValueSeparatorAttribute() ?>" name="x_shape[]" id="x_shape[]" value="{value}"<?php echo $payment_plan->shape->editAttributes() ?>></div>
<div id="dsl_x_shape" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $payment_plan->shape->checkBoxListHtml(FALSE, "x_shape[]") ?>
</div></div>
<?php echo $payment_plan->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
<?php echo $payment_plan->shape->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->selection->Visible) { // selection ?>
	<div id="r_selection" class="form-group row">
		<label id="elh_payment_plan_selection" for="x_selection" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->selection->caption() ?><?php echo ($payment_plan->selection->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->selection->cellAttributes() ?>>
<span id="el_payment_plan_selection">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_selection" data-value-separator="<?php echo $payment_plan->selection->displayValueSeparatorAttribute() ?>" id="x_selection" name="x_selection"<?php echo $payment_plan->selection->editAttributes() ?>>
		<?php echo $payment_plan->selection->selectOptionListHtml("x_selection") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->selection->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->gcode->Visible) { // gcode ?>
	<div id="r_gcode" class="form-group row">
		<label id="elh_payment_plan_gcode" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->gcode->caption() ?><?php echo ($payment_plan->gcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->gcode->cellAttributes() ?>>
<span id="el_payment_plan_gcode">
<?php $payment_plan->gcode->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$payment_plan->gcode->EditAttrs["onclick"]; ?>
<div id="tp_x_gcode" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_gcode" data-value-separator="<?php echo $payment_plan->gcode->displayValueSeparatorAttribute() ?>" name="x_gcode[]" id="x_gcode[]" value="{value}"<?php echo $payment_plan->gcode->editAttributes() ?>></div>
<div id="dsl_x_gcode" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $payment_plan->gcode->checkBoxListHtml(FALSE, "x_gcode[]") ?>
</div></div>
<?php echo $payment_plan->gcode->Lookup->getParamTag("p_x_gcode") ?>
</span>
<?php echo $payment_plan->gcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label id="elh_payment_plan_ref" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->ref->caption() ?><?php echo ($payment_plan->ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->ref->cellAttributes() ?>>
<span id="el_payment_plan_ref">
<div id="tp_x_ref" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_ref" data-value-separator="<?php echo $payment_plan->ref->displayValueSeparatorAttribute() ?>" name="x_ref[]" id="x_ref[]" value="{value}"<?php echo $payment_plan->ref->editAttributes() ?>></div>
<div id="dsl_x_ref" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $payment_plan->ref->checkBoxListHtml(FALSE, "x_ref[]") ?>
</div></div>
<?php echo $payment_plan->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
<?php echo $payment_plan->ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_payment_plan_description" for="x_description" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->description->caption() ?><?php echo ($payment_plan->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->description->cellAttributes() ?>>
<span id="el_payment_plan_description">
<input type="text" data-table="payment_plan" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($payment_plan->description->getPlaceHolder()) ?>" value="<?php echo $payment_plan->description->EditValue ?>"<?php echo $payment_plan->description->editAttributes() ?>>
</span>
<?php echo $payment_plan->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->yes_no->Visible) { // yes_no ?>
	<div id="r_yes_no" class="form-group row">
		<label id="elh_payment_plan_yes_no" for="x_yes_no" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->yes_no->caption() ?><?php echo ($payment_plan->yes_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->yes_no->cellAttributes() ?>>
<span id="el_payment_plan_yes_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_yes_no" data-value-separator="<?php echo $payment_plan->yes_no->displayValueSeparatorAttribute() ?>" id="x_yes_no" name="x_yes_no"<?php echo $payment_plan->yes_no->editAttributes() ?>>
		<?php echo $payment_plan->yes_no->selectOptionListHtml("x_yes_no") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->yes_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->packing_payment_type->Visible) { // packing_payment_type ?>
	<div id="r_packing_payment_type" class="form-group row">
		<label id="elh_payment_plan_packing_payment_type" for="x_packing_payment_type" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->packing_payment_type->caption() ?><?php echo ($payment_plan->packing_payment_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->packing_payment_type->cellAttributes() ?>>
<span id="el_payment_plan_packing_payment_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_packing_payment_type" data-value-separator="<?php echo $payment_plan->packing_payment_type->displayValueSeparatorAttribute() ?>" id="x_packing_payment_type" name="x_packing_payment_type"<?php echo $payment_plan->packing_payment_type->editAttributes() ?>>
		<?php echo $payment_plan->packing_payment_type->selectOptionListHtml("x_packing_payment_type") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->packing_payment_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->fix->Visible) { // fix ?>
	<div id="r_fix" class="form-group row">
		<label id="elh_payment_plan_fix" for="x_fix" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->fix->caption() ?><?php echo ($payment_plan->fix->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->fix->cellAttributes() ?>>
<span id="el_payment_plan_fix">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_fix" data-value-separator="<?php echo $payment_plan->fix->displayValueSeparatorAttribute() ?>" id="x_fix" name="x_fix"<?php echo $payment_plan->fix->editAttributes() ?>>
		<?php echo $payment_plan->fix->selectOptionListHtml("x_fix") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->fix->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label id="elh_payment_plan_method" for="x_method" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->method->caption() ?><?php echo ($payment_plan->method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->method->cellAttributes() ?>>
<span id="el_payment_plan_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_method" data-value-separator="<?php echo $payment_plan->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $payment_plan->method->editAttributes() ?>>
		<?php echo $payment_plan->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $payment_plan->method->Lookup->getParamTag("p_x_method") ?>
</span>
<?php echo $payment_plan->method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->sqm_method->Visible) { // sqm_method ?>
	<div id="r_sqm_method" class="form-group row">
		<label id="elh_payment_plan_sqm_method" for="x_sqm_method" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->sqm_method->caption() ?><?php echo ($payment_plan->sqm_method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->sqm_method->cellAttributes() ?>>
<span id="el_payment_plan_sqm_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_sqm_method" data-value-separator="<?php echo $payment_plan->sqm_method->displayValueSeparatorAttribute() ?>" id="x_sqm_method" name="x_sqm_method"<?php echo $payment_plan->sqm_method->editAttributes() ?>>
		<?php echo $payment_plan->sqm_method->selectOptionListHtml("x_sqm_method") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->sqm_method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label id="elh_payment_plan_unit" for="x_unit" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->unit->caption() ?><?php echo ($payment_plan->unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->unit->cellAttributes() ?>>
<span id="el_payment_plan_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_unit" data-value-separator="<?php echo $payment_plan->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $payment_plan->unit->editAttributes() ?>>
		<?php echo $payment_plan->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->_40_unit->Visible) { // @_unit ?>
	<div id="r__40_unit" class="form-group row">
		<label id="elh_payment_plan__40_unit" for="x__40_unit" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->_40_unit->caption() ?><?php echo ($payment_plan->_40_unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->_40_unit->cellAttributes() ?>>
<span id="el_payment_plan__40_unit">
<input type="text" data-table="payment_plan" data-field="x__40_unit" name="x__40_unit" id="x__40_unit" size="30" placeholder="<?php echo HtmlEncode($payment_plan->_40_unit->getPlaceHolder()) ?>" value="<?php echo $payment_plan->_40_unit->EditValue ?>"<?php echo $payment_plan->_40_unit->editAttributes() ?>>
</span>
<?php echo $payment_plan->_40_unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label id="elh_payment_plan__40" for="x__40" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->_40->caption() ?><?php echo ($payment_plan->_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->_40->cellAttributes() ?>>
<span id="el_payment_plan__40">
<input type="text" data-table="payment_plan" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($payment_plan->_40->getPlaceHolder()) ?>" value="<?php echo $payment_plan->_40->EditValue ?>"<?php echo $payment_plan->_40->editAttributes() ?>>
</span>
<?php echo $payment_plan->_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->extra_plan->Visible) { // extra_plan ?>
	<div id="r_extra_plan" class="form-group row">
		<label id="elh_payment_plan_extra_plan" for="x_extra_plan" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->extra_plan->caption() ?><?php echo ($payment_plan->extra_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->extra_plan->cellAttributes() ?>>
<span id="el_payment_plan_extra_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_extra_plan" data-value-separator="<?php echo $payment_plan->extra_plan->displayValueSeparatorAttribute() ?>" id="x_extra_plan" name="x_extra_plan"<?php echo $payment_plan->extra_plan->editAttributes() ?>>
		<?php echo $payment_plan->extra_plan->selectOptionListHtml("x_extra_plan") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->extra_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->custom_size->Visible) { // custom_size ?>
	<div id="r_custom_size" class="form-group row">
		<label id="elh_payment_plan_custom_size" for="x_custom_size" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->custom_size->caption() ?><?php echo ($payment_plan->custom_size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->custom_size->cellAttributes() ?>>
<span id="el_payment_plan_custom_size">
<input type="text" data-table="payment_plan" data-field="x_custom_size" name="x_custom_size" id="x_custom_size" size="30" placeholder="<?php echo HtmlEncode($payment_plan->custom_size->getPlaceHolder()) ?>" value="<?php echo $payment_plan->custom_size->EditValue ?>"<?php echo $payment_plan->custom_size->editAttributes() ?>>
</span>
<?php echo $payment_plan->custom_size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->custom_size_below_st->Visible) { // custom_size_below_st ?>
	<div id="r_custom_size_below_st" class="form-group row">
		<label id="elh_payment_plan_custom_size_below_st" for="x_custom_size_below_st" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->custom_size_below_st->caption() ?><?php echo ($payment_plan->custom_size_below_st->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->custom_size_below_st->cellAttributes() ?>>
<span id="el_payment_plan_custom_size_below_st">
<input type="text" data-table="payment_plan" data-field="x_custom_size_below_st" name="x_custom_size_below_st" id="x_custom_size_below_st" size="30" placeholder="<?php echo HtmlEncode($payment_plan->custom_size_below_st->getPlaceHolder()) ?>" value="<?php echo $payment_plan->custom_size_below_st->EditValue ?>"<?php echo $payment_plan->custom_size_below_st->editAttributes() ?>>
</span>
<?php echo $payment_plan->custom_size_below_st->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_payment_plan_status" for="x_status" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->status->caption() ?><?php echo ($payment_plan->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->status->cellAttributes() ?>>
<span id="el_payment_plan_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_status" data-value-separator="<?php echo $payment_plan->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $payment_plan->status->editAttributes() ?>>
		<?php echo $payment_plan->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $payment_plan->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_payment_plan_uploads" for="x_uploads" class="<?php echo $payment_plan_edit->LeftColumnClass ?>"><?php echo $payment_plan->uploads->caption() ?><?php echo ($payment_plan->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_plan_edit->RightColumnClass ?>"><div<?php echo $payment_plan->uploads->cellAttributes() ?>>
<span id="el_payment_plan_uploads">
<textarea data-table="payment_plan" data-field="x_uploads" name="x_uploads" id="x_uploads" cols="35" rows="4" placeholder="<?php echo HtmlEncode($payment_plan->uploads->getPlaceHolder()) ?>"<?php echo $payment_plan->uploads->editAttributes() ?>><?php echo $payment_plan->uploads->EditValue ?></textarea>
</span>
<?php echo $payment_plan->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_plan_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_plan_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payment_plan_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_plan_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$("#elh_payment_plan_ref").append('<div id="1" class="input-group-append"><h6 style="color:blue" onclick="javascript:SelectAll(\'ref\',\'1\')"><i class="fa fa-check-square-o"></i> Select All</h6></div>');
$("#elh_payment_plan_ref").append('<div id="2" class="input-group-append"><h6 style="color:blue" onclick="javascript:SelectAll(\'ref\',\'2\')"><i class="fa fa-times"></i> Unselect All</h6></div>');
</script>
<?php include_once "footer.php" ?>
<?php
$payment_plan_edit->terminate();
?>