<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_list = new payment_plan_list();

// Run the page
$payment_plan_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_plan->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_planlist = currentForm = new ew.Form("fpayment_planlist", "list");
fpayment_planlist.formKeyCountName = '<?php echo $payment_plan_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_planlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_planlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_planlist.lists["x_plan_type"] = <?php echo $payment_plan_list->plan_type->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_plan_type"].options = <?php echo JsonEncode($payment_plan_list->plan_type->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_location[]"] = <?php echo $payment_plan_list->location->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_location[]"].options = <?php echo JsonEncode($payment_plan_list->location->lookupOptions()) ?>;
fpayment_planlist.lists["x_process"] = <?php echo $payment_plan_list->process->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_process"].options = <?php echo JsonEncode($payment_plan_list->process->lookupOptions()) ?>;
fpayment_planlist.lists["x_product_type[]"] = <?php echo $payment_plan_list->product_type->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_product_type[]"].options = <?php echo JsonEncode($payment_plan_list->product_type->lookupOptions()) ?>;
fpayment_planlist.lists["x_shape[]"] = <?php echo $payment_plan_list->shape->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_shape[]"].options = <?php echo JsonEncode($payment_plan_list->shape->lookupOptions()) ?>;
fpayment_planlist.lists["x_selection"] = <?php echo $payment_plan_list->selection->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_selection"].options = <?php echo JsonEncode($payment_plan_list->selection->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_gcode[]"] = <?php echo $payment_plan_list->gcode->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_gcode[]"].options = <?php echo JsonEncode($payment_plan_list->gcode->lookupOptions()) ?>;
fpayment_planlist.lists["x_ref[]"] = <?php echo $payment_plan_list->ref->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_ref[]"].options = <?php echo JsonEncode($payment_plan_list->ref->lookupOptions()) ?>;
fpayment_planlist.lists["x_yes_no"] = <?php echo $payment_plan_list->yes_no->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_yes_no"].options = <?php echo JsonEncode($payment_plan_list->yes_no->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_packing_payment_type"] = <?php echo $payment_plan_list->packing_payment_type->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_packing_payment_type"].options = <?php echo JsonEncode($payment_plan_list->packing_payment_type->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_fix"] = <?php echo $payment_plan_list->fix->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_fix"].options = <?php echo JsonEncode($payment_plan_list->fix->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_method"] = <?php echo $payment_plan_list->method->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_method"].options = <?php echo JsonEncode($payment_plan_list->method->lookupOptions()) ?>;
fpayment_planlist.lists["x_sqm_method"] = <?php echo $payment_plan_list->sqm_method->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_sqm_method"].options = <?php echo JsonEncode($payment_plan_list->sqm_method->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_unit"] = <?php echo $payment_plan_list->unit->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_unit"].options = <?php echo JsonEncode($payment_plan_list->unit->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_extra_plan"] = <?php echo $payment_plan_list->extra_plan->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_extra_plan"].options = <?php echo JsonEncode($payment_plan_list->extra_plan->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_status"] = <?php echo $payment_plan_list->status->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_status"].options = <?php echo JsonEncode($payment_plan_list->status->options(FALSE, TRUE)) ?>;
fpayment_planlist.lists["x_operator"] = <?php echo $payment_plan_list->operator->Lookup->toClientList() ?>;
fpayment_planlist.lists["x_operator"].options = <?php echo JsonEncode($payment_plan_list->operator->lookupOptions()) ?>;

// Form object for search
var fpayment_planlistsrch = currentSearchForm = new ew.Form("fpayment_planlistsrch");

// Validate function for search
fpayment_planlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->_40->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpayment_planlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_planlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_planlistsrch.lists["x_location[]"] = <?php echo $payment_plan_list->location->Lookup->toClientList() ?>;
fpayment_planlistsrch.lists["x_location[]"].options = <?php echo JsonEncode($payment_plan_list->location->lookupOptions()) ?>;
fpayment_planlistsrch.lists["x_process"] = <?php echo $payment_plan_list->process->Lookup->toClientList() ?>;
fpayment_planlistsrch.lists["x_process"].options = <?php echo JsonEncode($payment_plan_list->process->lookupOptions()) ?>;
fpayment_planlistsrch.lists["x_status"] = <?php echo $payment_plan_list->status->Lookup->toClientList() ?>;
fpayment_planlistsrch.lists["x_status"].options = <?php echo JsonEncode($payment_plan_list->status->options(FALSE, TRUE)) ?>;

// Filters
fpayment_planlistsrch.filterList = <?php echo $payment_plan_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_planlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
			var sel = $("#x_selection").val();
				if (sel == 0)
				{
				$("#r_gcode").hide();
				$("#r_ref").hide();
				$('#dsl_x_gcode input[type=checkbox]').prop('checked', false);
				$('#dsl_x_ref input[type=checkbox]').prop('checked', false);
				} else {
				$("#r_gcode").show();
				$("#r_ref").show();
				}		
</script>
<?php } ?>
<?php if (!$payment_plan->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_plan_list->TotalRecs > 0 && $payment_plan_list->ExportOptions->visible()) { ?>
<?php $payment_plan_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_list->ImportOptions->visible()) { ?>
<?php $payment_plan_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_list->SearchOptions->visible()) { ?>
<?php $payment_plan_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_plan_list->FilterOptions->visible()) { ?>
<?php $payment_plan_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_plan_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_plan->isExport() && !$payment_plan->CurrentAction) { ?>
<form name="fpayment_planlistsrch" id="fpayment_planlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_plan_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_planlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_plan">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$payment_plan_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$payment_plan->RowType = ROWTYPE_SEARCH;

// Render row
$payment_plan->resetAttributes();
$payment_plan_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($payment_plan->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $payment_plan->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_location" id="z_location" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_location" data-value-separator="<?php echo $payment_plan->location->displayValueSeparatorAttribute() ?>" id="x_location[]" name="x_location[]" multiple="multiple"<?php echo $payment_plan->location->editAttributes() ?>>
		<?php echo $payment_plan->location->selectOptionListHtml("x_location[]") ?>
	</select>
</div>
<?php echo $payment_plan->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $payment_plan->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="payment_plan" data-field="x_process" name="x_process" id="x_process" size="30" placeholder="<?php echo HtmlEncode($payment_plan->process->getPlaceHolder()) ?>" value="<?php echo $payment_plan->process->EditValue ?>"<?php echo $payment_plan->process->editAttributes() ?>>
<?php echo $payment_plan->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_plan->_40->Visible) { // @ ?>
	<div id="xsc__40" class="ew-cell form-group">
		<label for="x__40" class="ew-search-caption ew-label"><?php echo $payment_plan->_40->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="payment_plan" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($payment_plan->_40->getPlaceHolder()) ?>" value="<?php echo $payment_plan->_40->EditValue ?>"<?php echo $payment_plan->_40->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($payment_plan->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $payment_plan->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_status" data-value-separator="<?php echo $payment_plan->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $payment_plan->status->editAttributes() ?>>
		<?php echo $payment_plan->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_plan_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_plan_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_plan_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_plan_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_plan_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_plan_list->showPageHeader(); ?>
<?php
$payment_plan_list->showMessage();
?>
<?php if ($payment_plan_list->TotalRecs > 0 || $payment_plan->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_plan_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_plan">
<?php if (!$payment_plan->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_plan->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_list->Pager)) $payment_plan_list->Pager = new PrevNextPager($payment_plan_list->StartRec, $payment_plan_list->DisplayRecs, $payment_plan_list->TotalRecs, $payment_plan_list->AutoHidePager) ?>
<?php if ($payment_plan_list->Pager->RecordCount > 0 && $payment_plan_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_list->pageUrl() ?>start=<?php echo $payment_plan_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_list->pageUrl() ?>start=<?php echo $payment_plan_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_list->pageUrl() ?>start=<?php echo $payment_plan_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_list->pageUrl() ?>start=<?php echo $payment_plan_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_list->TotalRecs > 0 && (!$payment_plan_list->AutoHidePageSizeSelector || $payment_plan_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_planlist" id="fpayment_planlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan">
<div id="gmp_payment_plan" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_plan_list->TotalRecs > 0 || $payment_plan->isGridEdit()) { ?>
<table id="tbl_payment_planlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_plan_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_plan_list->renderListOptions();

// Render list options (header, left)
$payment_plan_list->ListOptions->render("header", "left");
?>
<?php if ($payment_plan->id->Visible) { // id ?>
	<?php if ($payment_plan->sortUrl($payment_plan->id) == "") { ?>
		<th data-name="id" class="<?php echo $payment_plan->id->headerCellClass() ?>"><div id="elh_payment_plan_id" class="payment_plan_id"><div class="ew-table-header-caption"><?php echo $payment_plan->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payment_plan->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->id) ?>',2);"><div id="elh_payment_plan_id" class="payment_plan_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->plan_type->Visible) { // plan_type ?>
	<?php if ($payment_plan->sortUrl($payment_plan->plan_type) == "") { ?>
		<th data-name="plan_type" class="<?php echo $payment_plan->plan_type->headerCellClass() ?>"><div id="elh_payment_plan_plan_type" class="payment_plan_plan_type"><div class="ew-table-header-caption"><?php echo $payment_plan->plan_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="plan_type" class="<?php echo $payment_plan->plan_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->plan_type) ?>',2);"><div id="elh_payment_plan_plan_type" class="payment_plan_plan_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->plan_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->plan_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->plan_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->location->Visible) { // location ?>
	<?php if ($payment_plan->sortUrl($payment_plan->location) == "") { ?>
		<th data-name="location" class="<?php echo $payment_plan->location->headerCellClass() ?>"><div id="elh_payment_plan_location" class="payment_plan_location"><div class="ew-table-header-caption"><?php echo $payment_plan->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $payment_plan->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->location) ?>',2);"><div id="elh_payment_plan_location" class="payment_plan_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->process->Visible) { // process ?>
	<?php if ($payment_plan->sortUrl($payment_plan->process) == "") { ?>
		<th data-name="process" class="<?php echo $payment_plan->process->headerCellClass() ?>"><div id="elh_payment_plan_process" class="payment_plan_process"><div class="ew-table-header-caption"><?php echo $payment_plan->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $payment_plan->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->process) ?>',2);"><div id="elh_payment_plan_process" class="payment_plan_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->product_type->Visible) { // product_type ?>
	<?php if ($payment_plan->sortUrl($payment_plan->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $payment_plan->product_type->headerCellClass() ?>"><div id="elh_payment_plan_product_type" class="payment_plan_product_type"><div class="ew-table-header-caption"><?php echo $payment_plan->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $payment_plan->product_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->product_type) ?>',2);"><div id="elh_payment_plan_product_type" class="payment_plan_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->shape->Visible) { // shape ?>
	<?php if ($payment_plan->sortUrl($payment_plan->shape) == "") { ?>
		<th data-name="shape" class="<?php echo $payment_plan->shape->headerCellClass() ?>"><div id="elh_payment_plan_shape" class="payment_plan_shape"><div class="ew-table-header-caption"><?php echo $payment_plan->shape->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shape" class="<?php echo $payment_plan->shape->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->shape) ?>',2);"><div id="elh_payment_plan_shape" class="payment_plan_shape">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->shape->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->shape->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->shape->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->selection->Visible) { // selection ?>
	<?php if ($payment_plan->sortUrl($payment_plan->selection) == "") { ?>
		<th data-name="selection" class="<?php echo $payment_plan->selection->headerCellClass() ?>"><div id="elh_payment_plan_selection" class="payment_plan_selection"><div class="ew-table-header-caption"><?php echo $payment_plan->selection->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="selection" class="<?php echo $payment_plan->selection->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->selection) ?>',2);"><div id="elh_payment_plan_selection" class="payment_plan_selection">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->selection->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->selection->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->selection->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->gcode->Visible) { // gcode ?>
	<?php if ($payment_plan->sortUrl($payment_plan->gcode) == "") { ?>
		<th data-name="gcode" class="<?php echo $payment_plan->gcode->headerCellClass() ?>"><div id="elh_payment_plan_gcode" class="payment_plan_gcode"><div class="ew-table-header-caption"><?php echo $payment_plan->gcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gcode" class="<?php echo $payment_plan->gcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->gcode) ?>',2);"><div id="elh_payment_plan_gcode" class="payment_plan_gcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->gcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->gcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->gcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->ref->Visible) { // ref ?>
	<?php if ($payment_plan->sortUrl($payment_plan->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $payment_plan->ref->headerCellClass() ?>"><div id="elh_payment_plan_ref" class="payment_plan_ref"><div class="ew-table-header-caption"><?php echo $payment_plan->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $payment_plan->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->ref) ?>',2);"><div id="elh_payment_plan_ref" class="payment_plan_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->description->Visible) { // description ?>
	<?php if ($payment_plan->sortUrl($payment_plan->description) == "") { ?>
		<th data-name="description" class="<?php echo $payment_plan->description->headerCellClass() ?>"><div id="elh_payment_plan_description" class="payment_plan_description"><div class="ew-table-header-caption"><?php echo $payment_plan->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $payment_plan->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->description) ?>',2);"><div id="elh_payment_plan_description" class="payment_plan_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->yes_no->Visible) { // yes_no ?>
	<?php if ($payment_plan->sortUrl($payment_plan->yes_no) == "") { ?>
		<th data-name="yes_no" class="<?php echo $payment_plan->yes_no->headerCellClass() ?>"><div id="elh_payment_plan_yes_no" class="payment_plan_yes_no"><div class="ew-table-header-caption"><?php echo $payment_plan->yes_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="yes_no" class="<?php echo $payment_plan->yes_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->yes_no) ?>',2);"><div id="elh_payment_plan_yes_no" class="payment_plan_yes_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->yes_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->yes_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->yes_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->packing_payment_type->Visible) { // packing_payment_type ?>
	<?php if ($payment_plan->sortUrl($payment_plan->packing_payment_type) == "") { ?>
		<th data-name="packing_payment_type" class="<?php echo $payment_plan->packing_payment_type->headerCellClass() ?>"><div id="elh_payment_plan_packing_payment_type" class="payment_plan_packing_payment_type"><div class="ew-table-header-caption"><?php echo $payment_plan->packing_payment_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_payment_type" class="<?php echo $payment_plan->packing_payment_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->packing_payment_type) ?>',2);"><div id="elh_payment_plan_packing_payment_type" class="payment_plan_packing_payment_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->packing_payment_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->packing_payment_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->packing_payment_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->fix->Visible) { // fix ?>
	<?php if ($payment_plan->sortUrl($payment_plan->fix) == "") { ?>
		<th data-name="fix" class="<?php echo $payment_plan->fix->headerCellClass() ?>"><div id="elh_payment_plan_fix" class="payment_plan_fix"><div class="ew-table-header-caption"><?php echo $payment_plan->fix->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fix" class="<?php echo $payment_plan->fix->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->fix) ?>',2);"><div id="elh_payment_plan_fix" class="payment_plan_fix">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->fix->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->fix->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->fix->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->method->Visible) { // method ?>
	<?php if ($payment_plan->sortUrl($payment_plan->method) == "") { ?>
		<th data-name="method" class="<?php echo $payment_plan->method->headerCellClass() ?>"><div id="elh_payment_plan_method" class="payment_plan_method"><div class="ew-table-header-caption"><?php echo $payment_plan->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $payment_plan->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->method) ?>',2);"><div id="elh_payment_plan_method" class="payment_plan_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->sqm_method->Visible) { // sqm_method ?>
	<?php if ($payment_plan->sortUrl($payment_plan->sqm_method) == "") { ?>
		<th data-name="sqm_method" class="<?php echo $payment_plan->sqm_method->headerCellClass() ?>"><div id="elh_payment_plan_sqm_method" class="payment_plan_sqm_method"><div class="ew-table-header-caption"><?php echo $payment_plan->sqm_method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_method" class="<?php echo $payment_plan->sqm_method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->sqm_method) ?>',2);"><div id="elh_payment_plan_sqm_method" class="payment_plan_sqm_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->sqm_method->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->sqm_method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->sqm_method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->unit->Visible) { // unit ?>
	<?php if ($payment_plan->sortUrl($payment_plan->unit) == "") { ?>
		<th data-name="unit" class="<?php echo $payment_plan->unit->headerCellClass() ?>"><div id="elh_payment_plan_unit" class="payment_plan_unit"><div class="ew-table-header-caption"><?php echo $payment_plan->unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unit" class="<?php echo $payment_plan->unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->unit) ?>',2);"><div id="elh_payment_plan_unit" class="payment_plan_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->_40_unit->Visible) { // @_unit ?>
	<?php if ($payment_plan->sortUrl($payment_plan->_40_unit) == "") { ?>
		<th data-name="_40_unit" class="<?php echo $payment_plan->_40_unit->headerCellClass() ?>"><div id="elh_payment_plan__40_unit" class="payment_plan__40_unit"><div class="ew-table-header-caption"><?php echo $payment_plan->_40_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40_unit" class="<?php echo $payment_plan->_40_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->_40_unit) ?>',2);"><div id="elh_payment_plan__40_unit" class="payment_plan__40_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->_40_unit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->_40_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->_40_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->_40->Visible) { // @ ?>
	<?php if ($payment_plan->sortUrl($payment_plan->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $payment_plan->_40->headerCellClass() ?>"><div id="elh_payment_plan__40" class="payment_plan__40"><div class="ew-table-header-caption"><?php echo $payment_plan->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $payment_plan->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->_40) ?>',2);"><div id="elh_payment_plan__40" class="payment_plan__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->_40->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->extra_plan->Visible) { // extra_plan ?>
	<?php if ($payment_plan->sortUrl($payment_plan->extra_plan) == "") { ?>
		<th data-name="extra_plan" class="<?php echo $payment_plan->extra_plan->headerCellClass() ?>"><div id="elh_payment_plan_extra_plan" class="payment_plan_extra_plan"><div class="ew-table-header-caption"><?php echo $payment_plan->extra_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="extra_plan" class="<?php echo $payment_plan->extra_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->extra_plan) ?>',2);"><div id="elh_payment_plan_extra_plan" class="payment_plan_extra_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->extra_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->extra_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->extra_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->custom_size->Visible) { // custom_size ?>
	<?php if ($payment_plan->sortUrl($payment_plan->custom_size) == "") { ?>
		<th data-name="custom_size" class="<?php echo $payment_plan->custom_size->headerCellClass() ?>"><div id="elh_payment_plan_custom_size" class="payment_plan_custom_size"><div class="ew-table-header-caption"><?php echo $payment_plan->custom_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="custom_size" class="<?php echo $payment_plan->custom_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->custom_size) ?>',2);"><div id="elh_payment_plan_custom_size" class="payment_plan_custom_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->custom_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->custom_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->custom_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->custom_size_below_st->Visible) { // custom_size_below_st ?>
	<?php if ($payment_plan->sortUrl($payment_plan->custom_size_below_st) == "") { ?>
		<th data-name="custom_size_below_st" class="<?php echo $payment_plan->custom_size_below_st->headerCellClass() ?>"><div id="elh_payment_plan_custom_size_below_st" class="payment_plan_custom_size_below_st"><div class="ew-table-header-caption"><?php echo $payment_plan->custom_size_below_st->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="custom_size_below_st" class="<?php echo $payment_plan->custom_size_below_st->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->custom_size_below_st) ?>',2);"><div id="elh_payment_plan_custom_size_below_st" class="payment_plan_custom_size_below_st">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->custom_size_below_st->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->custom_size_below_st->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->custom_size_below_st->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->status->Visible) { // status ?>
	<?php if ($payment_plan->sortUrl($payment_plan->status) == "") { ?>
		<th data-name="status" class="<?php echo $payment_plan->status->headerCellClass() ?>"><div id="elh_payment_plan_status" class="payment_plan_status"><div class="ew-table-header-caption"><?php echo $payment_plan->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $payment_plan->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->status) ?>',2);"><div id="elh_payment_plan_status" class="payment_plan_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->operator->Visible) { // operator ?>
	<?php if ($payment_plan->sortUrl($payment_plan->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $payment_plan->operator->headerCellClass() ?>"><div id="elh_payment_plan_operator" class="payment_plan_operator"><div class="ew-table-header-caption"><?php echo $payment_plan->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $payment_plan->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->operator) ?>',2);"><div id="elh_payment_plan_operator" class="payment_plan_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_plan->datetime->Visible) { // datetime ?>
	<?php if ($payment_plan->sortUrl($payment_plan->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payment_plan->datetime->headerCellClass() ?>"><div id="elh_payment_plan_datetime" class="payment_plan_datetime"><div class="ew-table-header-caption"><?php echo $payment_plan->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payment_plan->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_plan->SortUrl($payment_plan->datetime) ?>',2);"><div id="elh_payment_plan_datetime" class="payment_plan_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_plan->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_plan->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_plan->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_plan_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_plan->ExportAll && $payment_plan->isExport()) {
	$payment_plan_list->StopRec = $payment_plan_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_plan_list->TotalRecs > $payment_plan_list->StartRec + $payment_plan_list->DisplayRecs - 1)
		$payment_plan_list->StopRec = $payment_plan_list->StartRec + $payment_plan_list->DisplayRecs - 1;
	else
		$payment_plan_list->StopRec = $payment_plan_list->TotalRecs;
}
$payment_plan_list->RecCnt = $payment_plan_list->StartRec - 1;
if ($payment_plan_list->Recordset && !$payment_plan_list->Recordset->EOF) {
	$payment_plan_list->Recordset->moveFirst();
	$selectLimit = $payment_plan_list->UseSelectLimit;
	if (!$selectLimit && $payment_plan_list->StartRec > 1)
		$payment_plan_list->Recordset->move($payment_plan_list->StartRec - 1);
} elseif (!$payment_plan->AllowAddDeleteRow && $payment_plan_list->StopRec == 0) {
	$payment_plan_list->StopRec = $payment_plan->GridAddRowCount;
}

// Initialize aggregate
$payment_plan->RowType = ROWTYPE_AGGREGATEINIT;
$payment_plan->resetAttributes();
$payment_plan_list->renderRow();
while ($payment_plan_list->RecCnt < $payment_plan_list->StopRec) {
	$payment_plan_list->RecCnt++;
	if ($payment_plan_list->RecCnt >= $payment_plan_list->StartRec) {
		$payment_plan_list->RowCnt++;

		// Set up key count
		$payment_plan_list->KeyCount = $payment_plan_list->RowIndex;

		// Init row class and style
		$payment_plan->resetAttributes();
		$payment_plan->CssClass = "";
		if ($payment_plan->isGridAdd()) {
		} else {
			$payment_plan_list->loadRowValues($payment_plan_list->Recordset); // Load row values
		}
		$payment_plan->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_plan->RowAttrs = array_merge($payment_plan->RowAttrs, array('data-rowindex'=>$payment_plan_list->RowCnt, 'id'=>'r' . $payment_plan_list->RowCnt . '_payment_plan', 'data-rowtype'=>$payment_plan->RowType));

		// Render row
		$payment_plan_list->renderRow();

		// Render list options
		$payment_plan_list->renderListOptions();
?>
	<tr<?php echo $payment_plan->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_plan_list->ListOptions->render("body", "left", $payment_plan_list->RowCnt);
?>
	<?php if ($payment_plan->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payment_plan->id->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_id" class="payment_plan_id">
<span<?php echo $payment_plan->id->viewAttributes() ?>>
<?php echo $payment_plan->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->plan_type->Visible) { // plan_type ?>
		<td data-name="plan_type"<?php echo $payment_plan->plan_type->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_plan_type" class="payment_plan_plan_type">
<span<?php echo $payment_plan->plan_type->viewAttributes() ?>>
<?php if ((!EmptyString($payment_plan->plan_type->getViewValue())) && $payment_plan->plan_type->linkAttributes() <> "") { ?>
<a<?php echo $payment_plan->plan_type->linkAttributes() ?>><?php echo $payment_plan->plan_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_plan->plan_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->location->Visible) { // location ?>
		<td data-name="location"<?php echo $payment_plan->location->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_location" class="payment_plan_location">
<span<?php echo $payment_plan->location->viewAttributes() ?>>
<?php if ((!EmptyString($payment_plan->location->getViewValue())) && $payment_plan->location->linkAttributes() <> "") { ?>
<a<?php echo $payment_plan->location->linkAttributes() ?>><?php echo $payment_plan->location->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_plan->location->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->process->Visible) { // process ?>
		<td data-name="process"<?php echo $payment_plan->process->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_process" class="payment_plan_process">
<span<?php echo $payment_plan->process->viewAttributes() ?>>
<?php if ((!EmptyString($payment_plan->process->getViewValue())) && $payment_plan->process->linkAttributes() <> "") { ?>
<a<?php echo $payment_plan->process->linkAttributes() ?>><?php echo $payment_plan->process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_plan->process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $payment_plan->product_type->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_product_type" class="payment_plan_product_type">
<span<?php echo $payment_plan->product_type->viewAttributes() ?>>
<?php echo $payment_plan->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->shape->Visible) { // shape ?>
		<td data-name="shape"<?php echo $payment_plan->shape->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_shape" class="payment_plan_shape">
<span<?php echo $payment_plan->shape->viewAttributes() ?>>
<?php echo $payment_plan->shape->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->selection->Visible) { // selection ?>
		<td data-name="selection"<?php echo $payment_plan->selection->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_selection" class="payment_plan_selection">
<span<?php echo $payment_plan->selection->viewAttributes() ?>>
<?php echo $payment_plan->selection->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->gcode->Visible) { // gcode ?>
		<td data-name="gcode"<?php echo $payment_plan->gcode->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_gcode" class="payment_plan_gcode">
<span<?php echo $payment_plan->gcode->viewAttributes() ?>>
<?php if ((!EmptyString($payment_plan->gcode->getViewValue())) && $payment_plan->gcode->linkAttributes() <> "") { ?>
<a<?php echo $payment_plan->gcode->linkAttributes() ?>><?php echo $payment_plan->gcode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_plan->gcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $payment_plan->ref->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_ref" class="payment_plan_ref">
<span<?php echo $payment_plan->ref->viewAttributes() ?>>
<?php if ((!EmptyString($payment_plan->ref->getViewValue())) && $payment_plan->ref->linkAttributes() <> "") { ?>
<a<?php echo $payment_plan->ref->linkAttributes() ?>><?php echo $payment_plan->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_plan->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->description->Visible) { // description ?>
		<td data-name="description"<?php echo $payment_plan->description->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_description" class="payment_plan_description">
<span<?php echo $payment_plan->description->viewAttributes() ?>>
<?php echo $payment_plan->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->yes_no->Visible) { // yes_no ?>
		<td data-name="yes_no"<?php echo $payment_plan->yes_no->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_yes_no" class="payment_plan_yes_no">
<span<?php echo $payment_plan->yes_no->viewAttributes() ?>>
<?php echo $payment_plan->yes_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->packing_payment_type->Visible) { // packing_payment_type ?>
		<td data-name="packing_payment_type"<?php echo $payment_plan->packing_payment_type->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_packing_payment_type" class="payment_plan_packing_payment_type">
<span<?php echo $payment_plan->packing_payment_type->viewAttributes() ?>>
<?php echo $payment_plan->packing_payment_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->fix->Visible) { // fix ?>
		<td data-name="fix"<?php echo $payment_plan->fix->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_fix" class="payment_plan_fix">
<span<?php echo $payment_plan->fix->viewAttributes() ?>>
<?php echo $payment_plan->fix->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->method->Visible) { // method ?>
		<td data-name="method"<?php echo $payment_plan->method->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_method" class="payment_plan_method">
<span<?php echo $payment_plan->method->viewAttributes() ?>>
<?php echo $payment_plan->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->sqm_method->Visible) { // sqm_method ?>
		<td data-name="sqm_method"<?php echo $payment_plan->sqm_method->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_sqm_method" class="payment_plan_sqm_method">
<span<?php echo $payment_plan->sqm_method->viewAttributes() ?>>
<?php echo $payment_plan->sqm_method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->unit->Visible) { // unit ?>
		<td data-name="unit"<?php echo $payment_plan->unit->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_unit" class="payment_plan_unit">
<span<?php echo $payment_plan->unit->viewAttributes() ?>>
<?php echo $payment_plan->unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->_40_unit->Visible) { // @_unit ?>
		<td data-name="_40_unit"<?php echo $payment_plan->_40_unit->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan__40_unit" class="payment_plan__40_unit">
<span<?php echo $payment_plan->_40_unit->viewAttributes() ?>>
<?php echo $payment_plan->_40_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $payment_plan->_40->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan__40" class="payment_plan__40">
<span<?php echo $payment_plan->_40->viewAttributes() ?>>
<?php echo $payment_plan->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->extra_plan->Visible) { // extra_plan ?>
		<td data-name="extra_plan"<?php echo $payment_plan->extra_plan->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_extra_plan" class="payment_plan_extra_plan">
<span<?php echo $payment_plan->extra_plan->viewAttributes() ?>>
<?php echo $payment_plan->extra_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->custom_size->Visible) { // custom_size ?>
		<td data-name="custom_size"<?php echo $payment_plan->custom_size->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_custom_size" class="payment_plan_custom_size">
<span<?php echo $payment_plan->custom_size->viewAttributes() ?>>
<?php echo $payment_plan->custom_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->custom_size_below_st->Visible) { // custom_size_below_st ?>
		<td data-name="custom_size_below_st"<?php echo $payment_plan->custom_size_below_st->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_custom_size_below_st" class="payment_plan_custom_size_below_st">
<span<?php echo $payment_plan->custom_size_below_st->viewAttributes() ?>>
<?php echo $payment_plan->custom_size_below_st->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->status->Visible) { // status ?>
		<td data-name="status"<?php echo $payment_plan->status->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_status" class="payment_plan_status">
<span<?php echo $payment_plan->status->viewAttributes() ?>>
<?php echo $payment_plan->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $payment_plan->operator->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_operator" class="payment_plan_operator">
<span<?php echo $payment_plan->operator->viewAttributes() ?>>
<?php echo $payment_plan->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_plan->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payment_plan->datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_plan_list->RowCnt ?>_payment_plan_datetime" class="payment_plan_datetime">
<span<?php echo $payment_plan->datetime->viewAttributes() ?>>
<?php echo $payment_plan->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_plan_list->ListOptions->render("body", "right", $payment_plan_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_plan->isGridAdd())
		$payment_plan_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_plan->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_plan_list->Recordset)
	$payment_plan_list->Recordset->Close();
?>
<?php if (!$payment_plan->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_plan->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_plan_list->Pager)) $payment_plan_list->Pager = new PrevNextPager($payment_plan_list->StartRec, $payment_plan_list->DisplayRecs, $payment_plan_list->TotalRecs, $payment_plan_list->AutoHidePager) ?>
<?php if ($payment_plan_list->Pager->RecordCount > 0 && $payment_plan_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_plan_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_plan_list->pageUrl() ?>start=<?php echo $payment_plan_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_plan_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_plan_list->pageUrl() ?>start=<?php echo $payment_plan_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_plan_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_plan_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_plan_list->pageUrl() ?>start=<?php echo $payment_plan_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_plan_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_plan_list->pageUrl() ?>start=<?php echo $payment_plan_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_plan_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_plan_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_plan_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_plan_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_plan_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_plan_list->TotalRecs > 0 && (!$payment_plan_list->AutoHidePageSizeSelector || $payment_plan_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_plan">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_plan_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_plan_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_plan_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_plan_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_plan_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_plan->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_plan_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_plan_list->TotalRecs == 0 && !$payment_plan->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_plan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_plan_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_plan->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_plan->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_plan", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_plan_list->terminate();
?>