<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_plan_search = new payment_plan_search();

// Run the page
$payment_plan_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_plan_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($payment_plan_search->IsModal) { ?>
var fpayment_plansearch = currentAdvancedSearchForm = new ew.Form("fpayment_plansearch", "search");
<?php } else { ?>
var fpayment_plansearch = currentForm = new ew.Form("fpayment_plansearch", "search");
<?php } ?>

// Form_CustomValidate event
fpayment_plansearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_plansearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_plansearch.lists["x_plan_type"] = <?php echo $payment_plan_search->plan_type->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_plan_type"].options = <?php echo JsonEncode($payment_plan_search->plan_type->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_location[]"] = <?php echo $payment_plan_search->location->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_location[]"].options = <?php echo JsonEncode($payment_plan_search->location->lookupOptions()) ?>;
fpayment_plansearch.lists["x_grp"] = <?php echo $payment_plan_search->grp->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_grp"].options = <?php echo JsonEncode($payment_plan_search->grp->lookupOptions()) ?>;
fpayment_plansearch.lists["x_s_grp"] = <?php echo $payment_plan_search->s_grp->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_s_grp"].options = <?php echo JsonEncode($payment_plan_search->s_grp->lookupOptions()) ?>;
fpayment_plansearch.lists["x_process"] = <?php echo $payment_plan_search->process->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_process"].options = <?php echo JsonEncode($payment_plan_search->process->lookupOptions()) ?>;
fpayment_plansearch.lists["x_product_type[]"] = <?php echo $payment_plan_search->product_type->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_product_type[]"].options = <?php echo JsonEncode($payment_plan_search->product_type->lookupOptions()) ?>;
fpayment_plansearch.lists["x_shape[]"] = <?php echo $payment_plan_search->shape->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_shape[]"].options = <?php echo JsonEncode($payment_plan_search->shape->lookupOptions()) ?>;
fpayment_plansearch.lists["x_selection"] = <?php echo $payment_plan_search->selection->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_selection"].options = <?php echo JsonEncode($payment_plan_search->selection->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_gcode[]"] = <?php echo $payment_plan_search->gcode->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_gcode[]"].options = <?php echo JsonEncode($payment_plan_search->gcode->lookupOptions()) ?>;
fpayment_plansearch.lists["x_ref[]"] = <?php echo $payment_plan_search->ref->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_ref[]"].options = <?php echo JsonEncode($payment_plan_search->ref->lookupOptions()) ?>;
fpayment_plansearch.lists["x_yes_no"] = <?php echo $payment_plan_search->yes_no->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_yes_no"].options = <?php echo JsonEncode($payment_plan_search->yes_no->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_packing_payment_type"] = <?php echo $payment_plan_search->packing_payment_type->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_packing_payment_type"].options = <?php echo JsonEncode($payment_plan_search->packing_payment_type->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_fix"] = <?php echo $payment_plan_search->fix->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_fix"].options = <?php echo JsonEncode($payment_plan_search->fix->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_method"] = <?php echo $payment_plan_search->method->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_method"].options = <?php echo JsonEncode($payment_plan_search->method->lookupOptions()) ?>;
fpayment_plansearch.lists["x_sqm_method"] = <?php echo $payment_plan_search->sqm_method->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_sqm_method"].options = <?php echo JsonEncode($payment_plan_search->sqm_method->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_unit"] = <?php echo $payment_plan_search->unit->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_unit"].options = <?php echo JsonEncode($payment_plan_search->unit->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_extra_plan"] = <?php echo $payment_plan_search->extra_plan->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_extra_plan"].options = <?php echo JsonEncode($payment_plan_search->extra_plan->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_status"] = <?php echo $payment_plan_search->status->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_status"].options = <?php echo JsonEncode($payment_plan_search->status->options(FALSE, TRUE)) ?>;
fpayment_plansearch.lists["x_operator"] = <?php echo $payment_plan_search->operator->Lookup->toClientList() ?>;
fpayment_plansearch.lists["x_operator"].options = <?php echo JsonEncode($payment_plan_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpayment_plansearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->from_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_to_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->to_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40_unit");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->_40_unit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_custom_size");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->custom_size->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_custom_size_below_st");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->custom_size_below_st->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_plan->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_plan_search->showPageHeader(); ?>
<?php
$payment_plan_search->showMessage();
?>
<form name="fpayment_plansearch" id="fpayment_plansearch" class="<?php echo $payment_plan_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_plan_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_plan_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_plan">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$payment_plan_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($payment_plan->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_id"><?php echo $payment_plan->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->id->cellAttributes() ?>>
			<span id="el_payment_plan_id">
<input type="text" data-table="payment_plan" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($payment_plan->id->getPlaceHolder()) ?>" value="<?php echo $payment_plan->id->EditValue ?>"<?php echo $payment_plan->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->plan_type->Visible) { // plan_type ?>
	<div id="r_plan_type" class="form-group row">
		<label for="x_plan_type" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_plan_type"><?php echo $payment_plan->plan_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_plan_type" id="z_plan_type" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->plan_type->cellAttributes() ?>>
			<span id="el_payment_plan_plan_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_plan_type" data-value-separator="<?php echo $payment_plan->plan_type->displayValueSeparatorAttribute() ?>" id="x_plan_type" name="x_plan_type"<?php echo $payment_plan->plan_type->editAttributes() ?>>
		<?php echo $payment_plan->plan_type->selectOptionListHtml("x_plan_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_location"><?php echo $payment_plan->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_location" id="z_location" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->location->cellAttributes() ?>>
			<span id="el_payment_plan_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_location" data-value-separator="<?php echo $payment_plan->location->displayValueSeparatorAttribute() ?>" id="x_location[]" name="x_location[]" multiple="multiple"<?php echo $payment_plan->location->editAttributes() ?>>
		<?php echo $payment_plan->location->selectOptionListHtml("x_location[]") ?>
	</select>
</div>
<?php echo $payment_plan->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->from_date->Visible) { // from_date ?>
	<div id="r_from_date" class="form-group row">
		<label for="x_from_date" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_from_date"><?php echo $payment_plan->from_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_date" id="z_from_date" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->from_date->cellAttributes() ?>>
			<span id="el_payment_plan_from_date">
<input type="text" data-table="payment_plan" data-field="x_from_date" name="x_from_date" id="x_from_date" placeholder="<?php echo HtmlEncode($payment_plan->from_date->getPlaceHolder()) ?>" value="<?php echo $payment_plan->from_date->EditValue ?>"<?php echo $payment_plan->from_date->editAttributes() ?>>
<?php if (!$payment_plan->from_date->ReadOnly && !$payment_plan->from_date->Disabled && !isset($payment_plan->from_date->EditAttrs["readonly"]) && !isset($payment_plan->from_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_plansearch", "x_from_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->to_date->Visible) { // to_date ?>
	<div id="r_to_date" class="form-group row">
		<label for="x_to_date" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_to_date"><?php echo $payment_plan->to_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_date" id="z_to_date" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->to_date->cellAttributes() ?>>
			<span id="el_payment_plan_to_date">
<input type="text" data-table="payment_plan" data-field="x_to_date" name="x_to_date" id="x_to_date" placeholder="<?php echo HtmlEncode($payment_plan->to_date->getPlaceHolder()) ?>" value="<?php echo $payment_plan->to_date->EditValue ?>"<?php echo $payment_plan->to_date->editAttributes() ?>>
<?php if (!$payment_plan->to_date->ReadOnly && !$payment_plan->to_date->Disabled && !isset($payment_plan->to_date->EditAttrs["readonly"]) && !isset($payment_plan->to_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_plansearch", "x_to_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_grp"><?php echo $payment_plan->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->grp->cellAttributes() ?>>
			<span id="el_payment_plan_grp">
<?php $payment_plan->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$payment_plan->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_grp" data-value-separator="<?php echo $payment_plan->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $payment_plan->grp->editAttributes() ?>>
		<?php echo $payment_plan->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $payment_plan->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_s_grp"><?php echo $payment_plan->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->s_grp->cellAttributes() ?>>
			<span id="el_payment_plan_s_grp">
<?php $payment_plan->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$payment_plan->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_s_grp" data-value-separator="<?php echo $payment_plan->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $payment_plan->s_grp->editAttributes() ?>>
		<?php echo $payment_plan->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $payment_plan->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_process"><?php echo $payment_plan->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->process->cellAttributes() ?>>
			<span id="el_payment_plan_process">
<input type="text" data-table="payment_plan" data-field="x_process" name="x_process" id="x_process" size="30" placeholder="<?php echo HtmlEncode($payment_plan->process->getPlaceHolder()) ?>" value="<?php echo $payment_plan->process->EditValue ?>"<?php echo $payment_plan->process->editAttributes() ?>>
<?php echo $payment_plan->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->product_type->Visible) { // product_type ?>
	<div id="r_product_type" class="form-group row">
		<label class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_product_type"><?php echo $payment_plan->product_type->caption() ?></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->product_type->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_product_type" id="z_product_type" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($payment_plan->product_type->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_payment_plan_product_type">
<div id="tp_x_product_type" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_product_type" data-value-separator="<?php echo $payment_plan->product_type->displayValueSeparatorAttribute() ?>" name="x_product_type[]" id="x_product_type[]" value="{value}"<?php echo $payment_plan->product_type->editAttributes() ?>></div>
<div id="dsl_x_product_type" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $payment_plan->product_type->checkBoxListHtml(FALSE, "x_product_type[]") ?>
</div></div>
<?php echo $payment_plan->product_type->Lookup->getParamTag("p_x_product_type") ?>
</span>
			<span class="ew-search-cond btw1_product_type d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_payment_plan_product_type" class="btw1_product_type d-none">
<div id="tp_y_product_type" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_product_type" data-value-separator="<?php echo $payment_plan->product_type->displayValueSeparatorAttribute() ?>" name="y_product_type[]" id="y_product_type[]" value="{value}"<?php echo $payment_plan->product_type->editAttributes() ?>></div>
<div id="dsl_y_product_type" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $payment_plan->product_type->checkBoxListHtml(FALSE, "y_product_type[]") ?>
</div></div>
<?php echo $payment_plan->product_type->Lookup->getParamTag("p_y_product_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->shape->Visible) { // shape ?>
	<div id="r_shape" class="form-group row">
		<label class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_shape"><?php echo $payment_plan->shape->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shape" id="z_shape" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->shape->cellAttributes() ?>>
			<span id="el_payment_plan_shape">
<div id="tp_x_shape" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_shape" data-value-separator="<?php echo $payment_plan->shape->displayValueSeparatorAttribute() ?>" name="x_shape[]" id="x_shape[]" value="{value}"<?php echo $payment_plan->shape->editAttributes() ?>></div>
<div id="dsl_x_shape" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $payment_plan->shape->checkBoxListHtml(FALSE, "x_shape[]") ?>
</div></div>
<?php echo $payment_plan->shape->Lookup->getParamTag("p_x_shape") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->selection->Visible) { // selection ?>
	<div id="r_selection" class="form-group row">
		<label for="x_selection" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_selection"><?php echo $payment_plan->selection->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_selection" id="z_selection" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->selection->cellAttributes() ?>>
			<span id="el_payment_plan_selection">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_selection" data-value-separator="<?php echo $payment_plan->selection->displayValueSeparatorAttribute() ?>" id="x_selection" name="x_selection"<?php echo $payment_plan->selection->editAttributes() ?>>
		<?php echo $payment_plan->selection->selectOptionListHtml("x_selection") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->gcode->Visible) { // gcode ?>
	<div id="r_gcode" class="form-group row">
		<label class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_gcode"><?php echo $payment_plan->gcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gcode" id="z_gcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->gcode->cellAttributes() ?>>
			<span id="el_payment_plan_gcode">
<?php $payment_plan->gcode->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$payment_plan->gcode->EditAttrs["onclick"]; ?>
<div id="tp_x_gcode" class="ew-template"><input type="checkbox" class="form-check-input" data-table="payment_plan" data-field="x_gcode" data-value-separator="<?php echo $payment_plan->gcode->displayValueSeparatorAttribute() ?>" name="x_gcode[]" id="x_gcode[]" value="{value}"<?php echo $payment_plan->gcode->editAttributes() ?>></div>
<div id="dsl_x_gcode" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $payment_plan->gcode->checkBoxListHtml(FALSE, "x_gcode[]") ?>
</div></div>
<?php echo $payment_plan->gcode->Lookup->getParamTag("p_x_gcode") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_ref"><?php echo $payment_plan->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->ref->cellAttributes() ?>>
			<span id="el_payment_plan_ref">
<input type="text" data-table="payment_plan" data-field="x_ref" name="x_ref" id="x_ref" size="30" placeholder="<?php echo HtmlEncode($payment_plan->ref->getPlaceHolder()) ?>" value="<?php echo $payment_plan->ref->EditValue ?>"<?php echo $payment_plan->ref->editAttributes() ?>>
<?php echo $payment_plan->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_description"><?php echo $payment_plan->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->description->cellAttributes() ?>>
			<span id="el_payment_plan_description">
<input type="text" data-table="payment_plan" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($payment_plan->description->getPlaceHolder()) ?>" value="<?php echo $payment_plan->description->EditValue ?>"<?php echo $payment_plan->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->yes_no->Visible) { // yes_no ?>
	<div id="r_yes_no" class="form-group row">
		<label for="x_yes_no" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_yes_no"><?php echo $payment_plan->yes_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_yes_no" id="z_yes_no" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->yes_no->cellAttributes() ?>>
			<span id="el_payment_plan_yes_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_yes_no" data-value-separator="<?php echo $payment_plan->yes_no->displayValueSeparatorAttribute() ?>" id="x_yes_no" name="x_yes_no"<?php echo $payment_plan->yes_no->editAttributes() ?>>
		<?php echo $payment_plan->yes_no->selectOptionListHtml("x_yes_no") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->packing_payment_type->Visible) { // packing_payment_type ?>
	<div id="r_packing_payment_type" class="form-group row">
		<label for="x_packing_payment_type" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_packing_payment_type"><?php echo $payment_plan->packing_payment_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_payment_type" id="z_packing_payment_type" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->packing_payment_type->cellAttributes() ?>>
			<span id="el_payment_plan_packing_payment_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_packing_payment_type" data-value-separator="<?php echo $payment_plan->packing_payment_type->displayValueSeparatorAttribute() ?>" id="x_packing_payment_type" name="x_packing_payment_type"<?php echo $payment_plan->packing_payment_type->editAttributes() ?>>
		<?php echo $payment_plan->packing_payment_type->selectOptionListHtml("x_packing_payment_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->fix->Visible) { // fix ?>
	<div id="r_fix" class="form-group row">
		<label for="x_fix" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_fix"><?php echo $payment_plan->fix->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_fix" id="z_fix" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->fix->cellAttributes() ?>>
			<span id="el_payment_plan_fix">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_fix" data-value-separator="<?php echo $payment_plan->fix->displayValueSeparatorAttribute() ?>" id="x_fix" name="x_fix"<?php echo $payment_plan->fix->editAttributes() ?>>
		<?php echo $payment_plan->fix->selectOptionListHtml("x_fix") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_method"><?php echo $payment_plan->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_method" id="z_method" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->method->cellAttributes() ?>>
			<span id="el_payment_plan_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_method" data-value-separator="<?php echo $payment_plan->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $payment_plan->method->editAttributes() ?>>
		<?php echo $payment_plan->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
<?php echo $payment_plan->method->Lookup->getParamTag("p_x_method") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->sqm_method->Visible) { // sqm_method ?>
	<div id="r_sqm_method" class="form-group row">
		<label for="x_sqm_method" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_sqm_method"><?php echo $payment_plan->sqm_method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm_method" id="z_sqm_method" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->sqm_method->cellAttributes() ?>>
			<span id="el_payment_plan_sqm_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_sqm_method" data-value-separator="<?php echo $payment_plan->sqm_method->displayValueSeparatorAttribute() ?>" id="x_sqm_method" name="x_sqm_method"<?php echo $payment_plan->sqm_method->editAttributes() ?>>
		<?php echo $payment_plan->sqm_method->selectOptionListHtml("x_sqm_method") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->unit->Visible) { // unit ?>
	<div id="r_unit" class="form-group row">
		<label for="x_unit" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_unit"><?php echo $payment_plan->unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unit" id="z_unit" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->unit->cellAttributes() ?>>
			<span id="el_payment_plan_unit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_unit" data-value-separator="<?php echo $payment_plan->unit->displayValueSeparatorAttribute() ?>" id="x_unit" name="x_unit"<?php echo $payment_plan->unit->editAttributes() ?>>
		<?php echo $payment_plan->unit->selectOptionListHtml("x_unit") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->_40_unit->Visible) { // @_unit ?>
	<div id="r__40_unit" class="form-group row">
		<label for="x__40_unit" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan__40_unit"><?php echo $payment_plan->_40_unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40_unit" id="z__40_unit" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->_40_unit->cellAttributes() ?>>
			<span id="el_payment_plan__40_unit">
<input type="text" data-table="payment_plan" data-field="x__40_unit" name="x__40_unit" id="x__40_unit" size="30" placeholder="<?php echo HtmlEncode($payment_plan->_40_unit->getPlaceHolder()) ?>" value="<?php echo $payment_plan->_40_unit->EditValue ?>"<?php echo $payment_plan->_40_unit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan__40"><?php echo $payment_plan->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->_40->cellAttributes() ?>>
			<span id="el_payment_plan__40">
<input type="text" data-table="payment_plan" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($payment_plan->_40->getPlaceHolder()) ?>" value="<?php echo $payment_plan->_40->EditValue ?>"<?php echo $payment_plan->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->extra_plan->Visible) { // extra_plan ?>
	<div id="r_extra_plan" class="form-group row">
		<label for="x_extra_plan" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_extra_plan"><?php echo $payment_plan->extra_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_extra_plan" id="z_extra_plan" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->extra_plan->cellAttributes() ?>>
			<span id="el_payment_plan_extra_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_extra_plan" data-value-separator="<?php echo $payment_plan->extra_plan->displayValueSeparatorAttribute() ?>" id="x_extra_plan" name="x_extra_plan"<?php echo $payment_plan->extra_plan->editAttributes() ?>>
		<?php echo $payment_plan->extra_plan->selectOptionListHtml("x_extra_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->custom_size->Visible) { // custom_size ?>
	<div id="r_custom_size" class="form-group row">
		<label for="x_custom_size" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_custom_size"><?php echo $payment_plan->custom_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_custom_size" id="z_custom_size" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->custom_size->cellAttributes() ?>>
			<span id="el_payment_plan_custom_size">
<input type="text" data-table="payment_plan" data-field="x_custom_size" name="x_custom_size" id="x_custom_size" size="30" placeholder="<?php echo HtmlEncode($payment_plan->custom_size->getPlaceHolder()) ?>" value="<?php echo $payment_plan->custom_size->EditValue ?>"<?php echo $payment_plan->custom_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->custom_size_below_st->Visible) { // custom_size_below_st ?>
	<div id="r_custom_size_below_st" class="form-group row">
		<label for="x_custom_size_below_st" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_custom_size_below_st"><?php echo $payment_plan->custom_size_below_st->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_custom_size_below_st" id="z_custom_size_below_st" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->custom_size_below_st->cellAttributes() ?>>
			<span id="el_payment_plan_custom_size_below_st">
<input type="text" data-table="payment_plan" data-field="x_custom_size_below_st" name="x_custom_size_below_st" id="x_custom_size_below_st" size="30" placeholder="<?php echo HtmlEncode($payment_plan->custom_size_below_st->getPlaceHolder()) ?>" value="<?php echo $payment_plan->custom_size_below_st->EditValue ?>"<?php echo $payment_plan->custom_size_below_st->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_status"><?php echo $payment_plan->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->status->cellAttributes() ?>>
			<span id="el_payment_plan_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_status" data-value-separator="<?php echo $payment_plan->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $payment_plan->status->editAttributes() ?>>
		<?php echo $payment_plan->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_operator"><?php echo $payment_plan->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->operator->cellAttributes() ?>>
			<span id="el_payment_plan_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_plan" data-field="x_operator" data-value-separator="<?php echo $payment_plan->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $payment_plan->operator->editAttributes() ?>>
		<?php echo $payment_plan->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $payment_plan->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_datetime"><?php echo $payment_plan->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->datetime->cellAttributes() ?>>
			<span id="el_payment_plan_datetime">
<input type="text" data-table="payment_plan" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($payment_plan->datetime->getPlaceHolder()) ?>" value="<?php echo $payment_plan->datetime->EditValue ?>"<?php echo $payment_plan->datetime->editAttributes() ?>>
<?php if (!$payment_plan->datetime->ReadOnly && !$payment_plan->datetime->Disabled && !isset($payment_plan->datetime->EditAttrs["readonly"]) && !isset($payment_plan->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_plansearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_plan->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label for="x_uploads" class="<?php echo $payment_plan_search->LeftColumnClass ?>"><span id="elh_payment_plan_uploads"><?php echo $payment_plan->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_plan_search->RightColumnClass ?>"><div<?php echo $payment_plan->uploads->cellAttributes() ?>>
			<span id="el_payment_plan_uploads">
<input type="text" data-table="payment_plan" data-field="x_uploads" name="x_uploads" id="x_uploads" size="35" placeholder="<?php echo HtmlEncode($payment_plan->uploads->getPlaceHolder()) ?>" value="<?php echo $payment_plan->uploads->EditValue ?>"<?php echo $payment_plan->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_plan_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_plan_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_plan_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_plan_search->terminate();
?>