<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_response_list = new payment_response_list();

// Run the page
$payment_response_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_response_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_response->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_responselist = currentForm = new ew.Form("fpayment_responselist", "list");
fpayment_responselist.formKeyCountName = '<?php echo $payment_response_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_responselist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_responselist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_responselist.lists["x_status"] = <?php echo $payment_response_list->status->Lookup->toClientList() ?>;
fpayment_responselist.lists["x_status"].options = <?php echo JsonEncode($payment_response_list->status->options(FALSE, TRUE)) ?>;
fpayment_responselist.lists["x__userid"] = <?php echo $payment_response_list->_userid->Lookup->toClientList() ?>;
fpayment_responselist.lists["x__userid"].options = <?php echo JsonEncode($payment_response_list->_userid->lookupOptions()) ?>;
fpayment_responselist.autoSuggests["x__userid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpayment_responselist.lists["x_currency_id"] = <?php echo $payment_response_list->currency_id->Lookup->toClientList() ?>;
fpayment_responselist.lists["x_currency_id"].options = <?php echo JsonEncode($payment_response_list->currency_id->lookupOptions()) ?>;

// Form object for search
var fpayment_responselistsrch = currentSearchForm = new ew.Form("fpayment_responselistsrch");

// Validate function for search
fpayment_responselistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__userid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_response->_userid->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpayment_responselistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_responselistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_responselistsrch.lists["x_status"] = <?php echo $payment_response_list->status->Lookup->toClientList() ?>;
fpayment_responselistsrch.lists["x_status"].options = <?php echo JsonEncode($payment_response_list->status->options(FALSE, TRUE)) ?>;
fpayment_responselistsrch.lists["x__userid"] = <?php echo $payment_response_list->_userid->Lookup->toClientList() ?>;
fpayment_responselistsrch.lists["x__userid"].options = <?php echo JsonEncode($payment_response_list->_userid->lookupOptions()) ?>;
fpayment_responselistsrch.autoSuggests["x__userid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpayment_responselistsrch.filterList = <?php echo $payment_response_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_responselistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_response->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_response_list->TotalRecs > 0 && $payment_response_list->ExportOptions->visible()) { ?>
<?php $payment_response_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_response_list->ImportOptions->visible()) { ?>
<?php $payment_response_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_response_list->SearchOptions->visible()) { ?>
<?php $payment_response_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_response_list->FilterOptions->visible()) { ?>
<?php $payment_response_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_response_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_response->isExport() && !$payment_response->CurrentAction) { ?>
<form name="fpayment_responselistsrch" id="fpayment_responselistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_response_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_responselistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_response">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$payment_response_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$payment_response->RowType = ROWTYPE_SEARCH;

// Render row
$payment_response->resetAttributes();
$payment_response_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($payment_response->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $payment_response->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_response" data-field="x_status" data-value-separator="<?php echo $payment_response->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $payment_response->status->editAttributes() ?>>
		<?php echo $payment_response->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($payment_response->_userid->Visible) { // userid ?>
	<div id="xsc__userid" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $payment_response->_userid->caption() ?></label>
		<span class="ew-search-operator"><select name="z__userid" id="z__userid" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$payment_response->_userid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment_response->_userid->EditAttrs["onchange"] = "";
?>
<span id="as_x__userid" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x__userid" id="sv_x__userid" value="<?php echo RemoveHtml($payment_response->_userid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($payment_response->_userid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment_response->_userid->getPlaceHolder()) ?>"<?php echo $payment_response->_userid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_response->_userid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x__userid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($payment_response->_userid->ReadOnly || $payment_response->_userid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment_response" data-field="x__userid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment_response->_userid->displayValueSeparatorAttribute() ?>" name="x__userid" id="x__userid" value="<?php echo HtmlEncode($payment_response->_userid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpayment_responselistsrch.createAutoSuggest({"id":"x__userid","forceSelect":false});
</script>
<?php echo $payment_response->_userid->Lookup->getParamTag("p_x__userid") ?>
</span>
		<span class="ew-search-cond btw1__userid style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__userid style="d-none"">
<?php
$wrkonchange = "" . trim(@$payment_response->_userid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment_response->_userid->EditAttrs["onchange"] = "";
?>
<span id="as_y__userid" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_y__userid" id="sv_y__userid" value="<?php echo RemoveHtml($payment_response->_userid->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($payment_response->_userid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment_response->_userid->getPlaceHolder()) ?>"<?php echo $payment_response->_userid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_response->_userid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'y__userid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($payment_response->_userid->ReadOnly || $payment_response->_userid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment_response" data-field="x__userid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment_response->_userid->displayValueSeparatorAttribute() ?>" name="y__userid" id="y__userid" value="<?php echo HtmlEncode($payment_response->_userid->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fpayment_responselistsrch.createAutoSuggest({"id":"y__userid","forceSelect":false});
</script>
<?php echo $payment_response->_userid->Lookup->getParamTag("p_y__userid") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_response->pg_order_number->Visible) { // pg_order_number ?>
	<div id="xsc_pg_order_number" class="ew-cell form-group">
		<label for="x_pg_order_number" class="ew-search-caption ew-label"><?php echo $payment_response->pg_order_number->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pg_order_number" id="z_pg_order_number" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="payment_response" data-field="x_pg_order_number" name="x_pg_order_number" id="x_pg_order_number" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($payment_response->pg_order_number->getPlaceHolder()) ?>" value="<?php echo $payment_response->pg_order_number->EditValue ?>"<?php echo $payment_response->pg_order_number->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_response_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_response_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_response_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_response_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_response_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_response_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_response_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_response_list->showPageHeader(); ?>
<?php
$payment_response_list->showMessage();
?>
<?php if ($payment_response_list->TotalRecs > 0 || $payment_response->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_response_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_response">
<?php if (!$payment_response->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_response->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_response_list->Pager)) $payment_response_list->Pager = new PrevNextPager($payment_response_list->StartRec, $payment_response_list->DisplayRecs, $payment_response_list->TotalRecs, $payment_response_list->AutoHidePager) ?>
<?php if ($payment_response_list->Pager->RecordCount > 0 && $payment_response_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_response_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_response_list->pageUrl() ?>start=<?php echo $payment_response_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_response_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_response_list->pageUrl() ?>start=<?php echo $payment_response_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_response_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_response_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_response_list->pageUrl() ?>start=<?php echo $payment_response_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_response_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_response_list->pageUrl() ?>start=<?php echo $payment_response_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_response_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_response_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_response_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_response_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_response_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_response_list->TotalRecs > 0 && (!$payment_response_list->AutoHidePageSizeSelector || $payment_response_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_response">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_response_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_response_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_response_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_response_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_response_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_response->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_response_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_responselist" id="fpayment_responselist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_response_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_response_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_response">
<div id="gmp_payment_response" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_response_list->TotalRecs > 0 || $payment_response->isGridEdit()) { ?>
<table id="tbl_payment_responselist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_response_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_response_list->renderListOptions();

// Render list options (header, left)
$payment_response_list->ListOptions->render("header", "left");
?>
<?php if ($payment_response->id->Visible) { // id ?>
	<?php if ($payment_response->sortUrl($payment_response->id) == "") { ?>
		<th data-name="id" class="<?php echo $payment_response->id->headerCellClass() ?>"><div id="elh_payment_response_id" class="payment_response_id"><div class="ew-table-header-caption"><?php echo $payment_response->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payment_response->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->id) ?>',2);"><div id="elh_payment_response_id" class="payment_response_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_response->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->type->Visible) { // type ?>
	<?php if ($payment_response->sortUrl($payment_response->type) == "") { ?>
		<th data-name="type" class="<?php echo $payment_response->type->headerCellClass() ?>"><div id="elh_payment_response_type" class="payment_response_type"><div class="ew-table-header-caption"><?php echo $payment_response->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $payment_response->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->type) ?>',2);"><div id="elh_payment_response_type" class="payment_response_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_response->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->status->Visible) { // status ?>
	<?php if ($payment_response->sortUrl($payment_response->status) == "") { ?>
		<th data-name="status" class="<?php echo $payment_response->status->headerCellClass() ?>"><div id="elh_payment_response_status" class="payment_response_status"><div class="ew-table-header-caption"><?php echo $payment_response->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $payment_response->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->status) ?>',2);"><div id="elh_payment_response_status" class="payment_response_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_response->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->_userid->Visible) { // userid ?>
	<?php if ($payment_response->sortUrl($payment_response->_userid) == "") { ?>
		<th data-name="_userid" class="<?php echo $payment_response->_userid->headerCellClass() ?>"><div id="elh_payment_response__userid" class="payment_response__userid"><div class="ew-table-header-caption"><?php echo $payment_response->_userid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_userid" class="<?php echo $payment_response->_userid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->_userid) ?>',2);"><div id="elh_payment_response__userid" class="payment_response__userid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->_userid->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_response->_userid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->_userid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->pg_order_number->Visible) { // pg_order_number ?>
	<?php if ($payment_response->sortUrl($payment_response->pg_order_number) == "") { ?>
		<th data-name="pg_order_number" class="<?php echo $payment_response->pg_order_number->headerCellClass() ?>"><div id="elh_payment_response_pg_order_number" class="payment_response_pg_order_number"><div class="ew-table-header-caption"><?php echo $payment_response->pg_order_number->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pg_order_number" class="<?php echo $payment_response->pg_order_number->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->pg_order_number) ?>',2);"><div id="elh_payment_response_pg_order_number" class="payment_response_pg_order_number">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->pg_order_number->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->pg_order_number->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->pg_order_number->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->remarks->Visible) { // remarks ?>
	<?php if ($payment_response->sortUrl($payment_response->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $payment_response->remarks->headerCellClass() ?>"><div id="elh_payment_response_remarks" class="payment_response_remarks"><div class="ew-table-header-caption"><?php echo $payment_response->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $payment_response->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->remarks) ?>',2);"><div id="elh_payment_response_remarks" class="payment_response_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->order_id->Visible) { // order_id ?>
	<?php if ($payment_response->sortUrl($payment_response->order_id) == "") { ?>
		<th data-name="order_id" class="<?php echo $payment_response->order_id->headerCellClass() ?>"><div id="elh_payment_response_order_id" class="payment_response_order_id"><div class="ew-table-header-caption"><?php echo $payment_response->order_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_id" class="<?php echo $payment_response->order_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->order_id) ?>',2);"><div id="elh_payment_response_order_id" class="payment_response_order_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->order_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_response->order_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->order_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->tracking_id->Visible) { // tracking_id ?>
	<?php if ($payment_response->sortUrl($payment_response->tracking_id) == "") { ?>
		<th data-name="tracking_id" class="<?php echo $payment_response->tracking_id->headerCellClass() ?>"><div id="elh_payment_response_tracking_id" class="payment_response_tracking_id"><div class="ew-table-header-caption"><?php echo $payment_response->tracking_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tracking_id" class="<?php echo $payment_response->tracking_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->tracking_id) ?>',2);"><div id="elh_payment_response_tracking_id" class="payment_response_tracking_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->tracking_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->tracking_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->tracking_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->bank_ref_no->Visible) { // bank_ref_no ?>
	<?php if ($payment_response->sortUrl($payment_response->bank_ref_no) == "") { ?>
		<th data-name="bank_ref_no" class="<?php echo $payment_response->bank_ref_no->headerCellClass() ?>"><div id="elh_payment_response_bank_ref_no" class="payment_response_bank_ref_no"><div class="ew-table-header-caption"><?php echo $payment_response->bank_ref_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_ref_no" class="<?php echo $payment_response->bank_ref_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->bank_ref_no) ?>',2);"><div id="elh_payment_response_bank_ref_no" class="payment_response_bank_ref_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->bank_ref_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->bank_ref_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->bank_ref_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->order_status->Visible) { // order_status ?>
	<?php if ($payment_response->sortUrl($payment_response->order_status) == "") { ?>
		<th data-name="order_status" class="<?php echo $payment_response->order_status->headerCellClass() ?>"><div id="elh_payment_response_order_status" class="payment_response_order_status"><div class="ew-table-header-caption"><?php echo $payment_response->order_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_status" class="<?php echo $payment_response->order_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->order_status) ?>',2);"><div id="elh_payment_response_order_status" class="payment_response_order_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->order_status->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->order_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->order_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->failure_message->Visible) { // failure_message ?>
	<?php if ($payment_response->sortUrl($payment_response->failure_message) == "") { ?>
		<th data-name="failure_message" class="<?php echo $payment_response->failure_message->headerCellClass() ?>"><div id="elh_payment_response_failure_message" class="payment_response_failure_message"><div class="ew-table-header-caption"><?php echo $payment_response->failure_message->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="failure_message" class="<?php echo $payment_response->failure_message->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->failure_message) ?>',2);"><div id="elh_payment_response_failure_message" class="payment_response_failure_message">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->failure_message->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->failure_message->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->failure_message->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->payment_mode->Visible) { // payment_mode ?>
	<?php if ($payment_response->sortUrl($payment_response->payment_mode) == "") { ?>
		<th data-name="payment_mode" class="<?php echo $payment_response->payment_mode->headerCellClass() ?>"><div id="elh_payment_response_payment_mode" class="payment_response_payment_mode"><div class="ew-table-header-caption"><?php echo $payment_response->payment_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_mode" class="<?php echo $payment_response->payment_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->payment_mode) ?>',2);"><div id="elh_payment_response_payment_mode" class="payment_response_payment_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->payment_mode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->payment_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->payment_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->card_name->Visible) { // card_name ?>
	<?php if ($payment_response->sortUrl($payment_response->card_name) == "") { ?>
		<th data-name="card_name" class="<?php echo $payment_response->card_name->headerCellClass() ?>"><div id="elh_payment_response_card_name" class="payment_response_card_name"><div class="ew-table-header-caption"><?php echo $payment_response->card_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="card_name" class="<?php echo $payment_response->card_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->card_name) ?>',2);"><div id="elh_payment_response_card_name" class="payment_response_card_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->card_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->card_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->card_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->status_code->Visible) { // status_code ?>
	<?php if ($payment_response->sortUrl($payment_response->status_code) == "") { ?>
		<th data-name="status_code" class="<?php echo $payment_response->status_code->headerCellClass() ?>"><div id="elh_payment_response_status_code" class="payment_response_status_code"><div class="ew-table-header-caption"><?php echo $payment_response->status_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_code" class="<?php echo $payment_response->status_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->status_code) ?>',2);"><div id="elh_payment_response_status_code" class="payment_response_status_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->status_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->status_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->status_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->status_message->Visible) { // status_message ?>
	<?php if ($payment_response->sortUrl($payment_response->status_message) == "") { ?>
		<th data-name="status_message" class="<?php echo $payment_response->status_message->headerCellClass() ?>"><div id="elh_payment_response_status_message" class="payment_response_status_message"><div class="ew-table-header-caption"><?php echo $payment_response->status_message->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status_message" class="<?php echo $payment_response->status_message->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->status_message) ?>',2);"><div id="elh_payment_response_status_message" class="payment_response_status_message">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->status_message->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->status_message->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->status_message->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->amount->Visible) { // amount ?>
	<?php if ($payment_response->sortUrl($payment_response->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $payment_response->amount->headerCellClass() ?>"><div id="elh_payment_response_amount" class="payment_response_amount"><div class="ew-table-header-caption"><?php echo $payment_response->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $payment_response->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->amount) ?>',2);"><div id="elh_payment_response_amount" class="payment_response_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_response->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->trans_date->Visible) { // trans_date ?>
	<?php if ($payment_response->sortUrl($payment_response->trans_date) == "") { ?>
		<th data-name="trans_date" class="<?php echo $payment_response->trans_date->headerCellClass() ?>"><div id="elh_payment_response_trans_date" class="payment_response_trans_date"><div class="ew-table-header-caption"><?php echo $payment_response->trans_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="trans_date" class="<?php echo $payment_response->trans_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->trans_date) ?>',2);"><div id="elh_payment_response_trans_date" class="payment_response_trans_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->trans_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->trans_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->trans_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->datetime->Visible) { // datetime ?>
	<?php if ($payment_response->sortUrl($payment_response->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payment_response->datetime->headerCellClass() ?>"><div id="elh_payment_response_datetime" class="payment_response_datetime"><div class="ew-table-header-caption"><?php echo $payment_response->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payment_response->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->datetime) ?>',2);"><div id="elh_payment_response_datetime" class="payment_response_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_response->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->payment_gateway->Visible) { // payment_gateway ?>
	<?php if ($payment_response->sortUrl($payment_response->payment_gateway) == "") { ?>
		<th data-name="payment_gateway" class="<?php echo $payment_response->payment_gateway->headerCellClass() ?>"><div id="elh_payment_response_payment_gateway" class="payment_response_payment_gateway"><div class="ew-table-header-caption"><?php echo $payment_response->payment_gateway->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_gateway" class="<?php echo $payment_response->payment_gateway->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->payment_gateway) ?>',2);"><div id="elh_payment_response_payment_gateway" class="payment_response_payment_gateway">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->payment_gateway->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment_response->payment_gateway->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->payment_gateway->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_response->currency_id->Visible) { // currency_id ?>
	<?php if ($payment_response->sortUrl($payment_response->currency_id) == "") { ?>
		<th data-name="currency_id" class="<?php echo $payment_response->currency_id->headerCellClass() ?>"><div id="elh_payment_response_currency_id" class="payment_response_currency_id"><div class="ew-table-header-caption"><?php echo $payment_response->currency_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency_id" class="<?php echo $payment_response->currency_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_response->SortUrl($payment_response->currency_id) ?>',2);"><div id="elh_payment_response_currency_id" class="payment_response_currency_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_response->currency_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_response->currency_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_response->currency_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_response_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_response->ExportAll && $payment_response->isExport()) {
	$payment_response_list->StopRec = $payment_response_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_response_list->TotalRecs > $payment_response_list->StartRec + $payment_response_list->DisplayRecs - 1)
		$payment_response_list->StopRec = $payment_response_list->StartRec + $payment_response_list->DisplayRecs - 1;
	else
		$payment_response_list->StopRec = $payment_response_list->TotalRecs;
}
$payment_response_list->RecCnt = $payment_response_list->StartRec - 1;
if ($payment_response_list->Recordset && !$payment_response_list->Recordset->EOF) {
	$payment_response_list->Recordset->moveFirst();
	$selectLimit = $payment_response_list->UseSelectLimit;
	if (!$selectLimit && $payment_response_list->StartRec > 1)
		$payment_response_list->Recordset->move($payment_response_list->StartRec - 1);
} elseif (!$payment_response->AllowAddDeleteRow && $payment_response_list->StopRec == 0) {
	$payment_response_list->StopRec = $payment_response->GridAddRowCount;
}

// Initialize aggregate
$payment_response->RowType = ROWTYPE_AGGREGATEINIT;
$payment_response->resetAttributes();
$payment_response_list->renderRow();
while ($payment_response_list->RecCnt < $payment_response_list->StopRec) {
	$payment_response_list->RecCnt++;
	if ($payment_response_list->RecCnt >= $payment_response_list->StartRec) {
		$payment_response_list->RowCnt++;

		// Set up key count
		$payment_response_list->KeyCount = $payment_response_list->RowIndex;

		// Init row class and style
		$payment_response->resetAttributes();
		$payment_response->CssClass = "";
		if ($payment_response->isGridAdd()) {
		} else {
			$payment_response_list->loadRowValues($payment_response_list->Recordset); // Load row values
		}
		$payment_response->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_response->RowAttrs = array_merge($payment_response->RowAttrs, array('data-rowindex'=>$payment_response_list->RowCnt, 'id'=>'r' . $payment_response_list->RowCnt . '_payment_response', 'data-rowtype'=>$payment_response->RowType));

		// Render row
		$payment_response_list->renderRow();

		// Render list options
		$payment_response_list->renderListOptions();
?>
	<tr<?php echo $payment_response->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_response_list->ListOptions->render("body", "left", $payment_response_list->RowCnt);
?>
	<?php if ($payment_response->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payment_response->id->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_id" class="payment_response_id">
<span<?php echo $payment_response->id->viewAttributes() ?>>
<?php echo $payment_response->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->type->Visible) { // type ?>
		<td data-name="type"<?php echo $payment_response->type->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_type" class="payment_response_type">
<span<?php echo $payment_response->type->viewAttributes() ?>>
<?php if ((!EmptyString($payment_response->type->getViewValue())) && $payment_response->type->linkAttributes() <> "") { ?>
<a<?php echo $payment_response->type->linkAttributes() ?>><?php echo $payment_response->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_response->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->status->Visible) { // status ?>
		<td data-name="status"<?php echo $payment_response->status->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_status" class="payment_response_status">
<span<?php echo $payment_response->status->viewAttributes() ?>>
<?php if ((!EmptyString($payment_response->status->getViewValue())) && $payment_response->status->linkAttributes() <> "") { ?>
<a<?php echo $payment_response->status->linkAttributes() ?>><?php echo $payment_response->status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_response->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->_userid->Visible) { // userid ?>
		<td data-name="_userid"<?php echo $payment_response->_userid->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response__userid" class="payment_response__userid">
<span<?php echo $payment_response->_userid->viewAttributes() ?>>
<?php if ((!EmptyString($payment_response->_userid->getViewValue())) && $payment_response->_userid->linkAttributes() <> "") { ?>
<a<?php echo $payment_response->_userid->linkAttributes() ?>><?php echo $payment_response->_userid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_response->_userid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->pg_order_number->Visible) { // pg_order_number ?>
		<td data-name="pg_order_number"<?php echo $payment_response->pg_order_number->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_pg_order_number" class="payment_response_pg_order_number">
<span<?php echo $payment_response->pg_order_number->viewAttributes() ?>>
<?php echo $payment_response->pg_order_number->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $payment_response->remarks->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_remarks" class="payment_response_remarks">
<span<?php echo $payment_response->remarks->viewAttributes() ?>>
<?php echo $payment_response->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->order_id->Visible) { // order_id ?>
		<td data-name="order_id"<?php echo $payment_response->order_id->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_order_id" class="payment_response_order_id">
<span<?php echo $payment_response->order_id->viewAttributes() ?>>
<?php echo $payment_response->order_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->tracking_id->Visible) { // tracking_id ?>
		<td data-name="tracking_id"<?php echo $payment_response->tracking_id->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_tracking_id" class="payment_response_tracking_id">
<span<?php echo $payment_response->tracking_id->viewAttributes() ?>>
<?php echo $payment_response->tracking_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->bank_ref_no->Visible) { // bank_ref_no ?>
		<td data-name="bank_ref_no"<?php echo $payment_response->bank_ref_no->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_bank_ref_no" class="payment_response_bank_ref_no">
<span<?php echo $payment_response->bank_ref_no->viewAttributes() ?>>
<?php echo $payment_response->bank_ref_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->order_status->Visible) { // order_status ?>
		<td data-name="order_status"<?php echo $payment_response->order_status->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_order_status" class="payment_response_order_status">
<span<?php echo $payment_response->order_status->viewAttributes() ?>>
<?php echo $payment_response->order_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->failure_message->Visible) { // failure_message ?>
		<td data-name="failure_message"<?php echo $payment_response->failure_message->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_failure_message" class="payment_response_failure_message">
<span<?php echo $payment_response->failure_message->viewAttributes() ?>>
<?php echo $payment_response->failure_message->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->payment_mode->Visible) { // payment_mode ?>
		<td data-name="payment_mode"<?php echo $payment_response->payment_mode->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_payment_mode" class="payment_response_payment_mode">
<span<?php echo $payment_response->payment_mode->viewAttributes() ?>>
<?php echo $payment_response->payment_mode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->card_name->Visible) { // card_name ?>
		<td data-name="card_name"<?php echo $payment_response->card_name->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_card_name" class="payment_response_card_name">
<span<?php echo $payment_response->card_name->viewAttributes() ?>>
<?php echo $payment_response->card_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->status_code->Visible) { // status_code ?>
		<td data-name="status_code"<?php echo $payment_response->status_code->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_status_code" class="payment_response_status_code">
<span<?php echo $payment_response->status_code->viewAttributes() ?>>
<?php echo $payment_response->status_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->status_message->Visible) { // status_message ?>
		<td data-name="status_message"<?php echo $payment_response->status_message->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_status_message" class="payment_response_status_message">
<span<?php echo $payment_response->status_message->viewAttributes() ?>>
<?php echo $payment_response->status_message->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $payment_response->amount->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_amount" class="payment_response_amount">
<span<?php echo $payment_response->amount->viewAttributes() ?>>
<?php echo $payment_response->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->trans_date->Visible) { // trans_date ?>
		<td data-name="trans_date"<?php echo $payment_response->trans_date->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_trans_date" class="payment_response_trans_date">
<span<?php echo $payment_response->trans_date->viewAttributes() ?>>
<?php echo $payment_response->trans_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payment_response->datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_datetime" class="payment_response_datetime">
<span<?php echo $payment_response->datetime->viewAttributes() ?>>
<?php echo $payment_response->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->payment_gateway->Visible) { // payment_gateway ?>
		<td data-name="payment_gateway"<?php echo $payment_response->payment_gateway->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_payment_gateway" class="payment_response_payment_gateway">
<span<?php echo $payment_response->payment_gateway->viewAttributes() ?>>
<?php echo $payment_response->payment_gateway->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_response->currency_id->Visible) { // currency_id ?>
		<td data-name="currency_id"<?php echo $payment_response->currency_id->cellAttributes() ?>>
<span id="el<?php echo $payment_response_list->RowCnt ?>_payment_response_currency_id" class="payment_response_currency_id">
<span<?php echo $payment_response->currency_id->viewAttributes() ?>>
<?php echo $payment_response->currency_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_response_list->ListOptions->render("body", "right", $payment_response_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_response->isGridAdd())
		$payment_response_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_response->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_response_list->Recordset)
	$payment_response_list->Recordset->Close();
?>
<?php if (!$payment_response->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_response->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_response_list->Pager)) $payment_response_list->Pager = new PrevNextPager($payment_response_list->StartRec, $payment_response_list->DisplayRecs, $payment_response_list->TotalRecs, $payment_response_list->AutoHidePager) ?>
<?php if ($payment_response_list->Pager->RecordCount > 0 && $payment_response_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_response_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_response_list->pageUrl() ?>start=<?php echo $payment_response_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_response_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_response_list->pageUrl() ?>start=<?php echo $payment_response_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_response_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_response_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_response_list->pageUrl() ?>start=<?php echo $payment_response_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_response_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_response_list->pageUrl() ?>start=<?php echo $payment_response_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_response_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_response_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_response_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_response_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_response_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_response_list->TotalRecs > 0 && (!$payment_response_list->AutoHidePageSizeSelector || $payment_response_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_response">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_response_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_response_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_response_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_response_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_response_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_response->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_response_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_response_list->TotalRecs == 0 && !$payment_response->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_response_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_response_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_response->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_response->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_response", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_response_list->terminate();
?>