<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_response_search = new payment_response_search();

// Run the page
$payment_response_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_response_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($payment_response_search->IsModal) { ?>
var fpayment_responsesearch = currentAdvancedSearchForm = new ew.Form("fpayment_responsesearch", "search");
<?php } else { ?>
var fpayment_responsesearch = currentForm = new ew.Form("fpayment_responsesearch", "search");
<?php } ?>

// Form_CustomValidate event
fpayment_responsesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_responsesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_responsesearch.lists["x_status"] = <?php echo $payment_response_search->status->Lookup->toClientList() ?>;
fpayment_responsesearch.lists["x_status"].options = <?php echo JsonEncode($payment_response_search->status->options(FALSE, TRUE)) ?>;
fpayment_responsesearch.lists["x__userid"] = <?php echo $payment_response_search->_userid->Lookup->toClientList() ?>;
fpayment_responsesearch.lists["x__userid"].options = <?php echo JsonEncode($payment_response_search->_userid->lookupOptions()) ?>;
fpayment_responsesearch.autoSuggests["x__userid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpayment_responsesearch.lists["x_currency_id"] = <?php echo $payment_response_search->currency_id->Lookup->toClientList() ?>;
fpayment_responsesearch.lists["x_currency_id"].options = <?php echo JsonEncode($payment_response_search->currency_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpayment_responsesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_response->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_type");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_response->type->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__userid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_response->_userid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cart_number");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_response->cart_number->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_response->order_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_response->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_response->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_response_search->showPageHeader(); ?>
<?php
$payment_response_search->showMessage();
?>
<form name="fpayment_responsesearch" id="fpayment_responsesearch" class="<?php echo $payment_response_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_response_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_response_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_response">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$payment_response_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($payment_response->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_id"><?php echo $payment_response->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->id->cellAttributes() ?>>
			<span id="el_payment_response_id">
<input type="text" data-table="payment_response" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($payment_response->id->getPlaceHolder()) ?>" value="<?php echo $payment_response->id->EditValue ?>"<?php echo $payment_response->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_type"><?php echo $payment_response->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->type->cellAttributes() ?>>
			<span id="el_payment_response_type">
<input type="text" data-table="payment_response" data-field="x_type" name="x_type" id="x_type" size="30" placeholder="<?php echo HtmlEncode($payment_response->type->getPlaceHolder()) ?>" value="<?php echo $payment_response->type->EditValue ?>"<?php echo $payment_response->type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_status"><?php echo $payment_response->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->status->cellAttributes() ?>>
			<span id="el_payment_response_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_response" data-field="x_status" data-value-separator="<?php echo $payment_response->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $payment_response->status->editAttributes() ?>>
		<?php echo $payment_response->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->_userid->Visible) { // userid ?>
	<div id="r__userid" class="form-group row">
		<label class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response__userid"><?php echo $payment_response->_userid->caption() ?></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->_userid->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__userid" id="z__userid" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($payment_response->_userid->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_payment_response__userid">
<?php
$wrkonchange = "" . trim(@$payment_response->_userid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment_response->_userid->EditAttrs["onchange"] = "";
?>
<span id="as_x__userid" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x__userid" id="sv_x__userid" value="<?php echo RemoveHtml($payment_response->_userid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($payment_response->_userid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment_response->_userid->getPlaceHolder()) ?>"<?php echo $payment_response->_userid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_response->_userid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x__userid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($payment_response->_userid->ReadOnly || $payment_response->_userid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment_response" data-field="x__userid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment_response->_userid->displayValueSeparatorAttribute() ?>" name="x__userid" id="x__userid" value="<?php echo HtmlEncode($payment_response->_userid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpayment_responsesearch.createAutoSuggest({"id":"x__userid","forceSelect":false});
</script>
<?php echo $payment_response->_userid->Lookup->getParamTag("p_x__userid") ?>
</span>
			<span class="ew-search-cond btw1__userid d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_payment_response__userid" class="btw1__userid d-none">
<?php
$wrkonchange = "" . trim(@$payment_response->_userid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment_response->_userid->EditAttrs["onchange"] = "";
?>
<span id="as_y__userid" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_y__userid" id="sv_y__userid" value="<?php echo RemoveHtml($payment_response->_userid->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($payment_response->_userid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment_response->_userid->getPlaceHolder()) ?>"<?php echo $payment_response->_userid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_response->_userid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'y__userid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($payment_response->_userid->ReadOnly || $payment_response->_userid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment_response" data-field="x__userid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment_response->_userid->displayValueSeparatorAttribute() ?>" name="y__userid" id="y__userid" value="<?php echo HtmlEncode($payment_response->_userid->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fpayment_responsesearch.createAutoSuggest({"id":"y__userid","forceSelect":false});
</script>
<?php echo $payment_response->_userid->Lookup->getParamTag("p_y__userid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->pg_order_number->Visible) { // pg_order_number ?>
	<div id="r_pg_order_number" class="form-group row">
		<label for="x_pg_order_number" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_pg_order_number"><?php echo $payment_response->pg_order_number->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pg_order_number" id="z_pg_order_number" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->pg_order_number->cellAttributes() ?>>
			<span id="el_payment_response_pg_order_number">
<input type="text" data-table="payment_response" data-field="x_pg_order_number" name="x_pg_order_number" id="x_pg_order_number" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($payment_response->pg_order_number->getPlaceHolder()) ?>" value="<?php echo $payment_response->pg_order_number->EditValue ?>"<?php echo $payment_response->pg_order_number->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_remarks"><?php echo $payment_response->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->remarks->cellAttributes() ?>>
			<span id="el_payment_response_remarks">
<input type="text" data-table="payment_response" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($payment_response->remarks->getPlaceHolder()) ?>" value="<?php echo $payment_response->remarks->EditValue ?>"<?php echo $payment_response->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->cart_number->Visible) { // cart_number ?>
	<div id="r_cart_number" class="form-group row">
		<label for="x_cart_number" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_cart_number"><?php echo $payment_response->cart_number->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cart_number" id="z_cart_number" value="="></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->cart_number->cellAttributes() ?>>
			<span id="el_payment_response_cart_number">
<input type="text" data-table="payment_response" data-field="x_cart_number" name="x_cart_number" id="x_cart_number" size="30" placeholder="<?php echo HtmlEncode($payment_response->cart_number->getPlaceHolder()) ?>" value="<?php echo $payment_response->cart_number->EditValue ?>"<?php echo $payment_response->cart_number->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->order_id->Visible) { // order_id ?>
	<div id="r_order_id" class="form-group row">
		<label for="x_order_id" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_order_id"><?php echo $payment_response->order_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_id" id="z_order_id" value="="></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->order_id->cellAttributes() ?>>
			<span id="el_payment_response_order_id">
<input type="text" data-table="payment_response" data-field="x_order_id" name="x_order_id" id="x_order_id" size="30" placeholder="<?php echo HtmlEncode($payment_response->order_id->getPlaceHolder()) ?>" value="<?php echo $payment_response->order_id->EditValue ?>"<?php echo $payment_response->order_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->tracking_id->Visible) { // tracking_id ?>
	<div id="r_tracking_id" class="form-group row">
		<label for="x_tracking_id" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_tracking_id"><?php echo $payment_response->tracking_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_tracking_id" id="z_tracking_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->tracking_id->cellAttributes() ?>>
			<span id="el_payment_response_tracking_id">
<input type="text" data-table="payment_response" data-field="x_tracking_id" name="x_tracking_id" id="x_tracking_id" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($payment_response->tracking_id->getPlaceHolder()) ?>" value="<?php echo $payment_response->tracking_id->EditValue ?>"<?php echo $payment_response->tracking_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->bank_ref_no->Visible) { // bank_ref_no ?>
	<div id="r_bank_ref_no" class="form-group row">
		<label for="x_bank_ref_no" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_bank_ref_no"><?php echo $payment_response->bank_ref_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bank_ref_no" id="z_bank_ref_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->bank_ref_no->cellAttributes() ?>>
			<span id="el_payment_response_bank_ref_no">
<input type="text" data-table="payment_response" data-field="x_bank_ref_no" name="x_bank_ref_no" id="x_bank_ref_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($payment_response->bank_ref_no->getPlaceHolder()) ?>" value="<?php echo $payment_response->bank_ref_no->EditValue ?>"<?php echo $payment_response->bank_ref_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->order_status->Visible) { // order_status ?>
	<div id="r_order_status" class="form-group row">
		<label for="x_order_status" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_order_status"><?php echo $payment_response->order_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_order_status" id="z_order_status" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->order_status->cellAttributes() ?>>
			<span id="el_payment_response_order_status">
<input type="text" data-table="payment_response" data-field="x_order_status" name="x_order_status" id="x_order_status" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($payment_response->order_status->getPlaceHolder()) ?>" value="<?php echo $payment_response->order_status->EditValue ?>"<?php echo $payment_response->order_status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->failure_message->Visible) { // failure_message ?>
	<div id="r_failure_message" class="form-group row">
		<label for="x_failure_message" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_failure_message"><?php echo $payment_response->failure_message->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_failure_message" id="z_failure_message" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->failure_message->cellAttributes() ?>>
			<span id="el_payment_response_failure_message">
<input type="text" data-table="payment_response" data-field="x_failure_message" name="x_failure_message" id="x_failure_message" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($payment_response->failure_message->getPlaceHolder()) ?>" value="<?php echo $payment_response->failure_message->EditValue ?>"<?php echo $payment_response->failure_message->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->payment_mode->Visible) { // payment_mode ?>
	<div id="r_payment_mode" class="form-group row">
		<label for="x_payment_mode" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_payment_mode"><?php echo $payment_response->payment_mode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_payment_mode" id="z_payment_mode" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->payment_mode->cellAttributes() ?>>
			<span id="el_payment_response_payment_mode">
<input type="text" data-table="payment_response" data-field="x_payment_mode" name="x_payment_mode" id="x_payment_mode" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($payment_response->payment_mode->getPlaceHolder()) ?>" value="<?php echo $payment_response->payment_mode->EditValue ?>"<?php echo $payment_response->payment_mode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->card_name->Visible) { // card_name ?>
	<div id="r_card_name" class="form-group row">
		<label for="x_card_name" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_card_name"><?php echo $payment_response->card_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_card_name" id="z_card_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->card_name->cellAttributes() ?>>
			<span id="el_payment_response_card_name">
<input type="text" data-table="payment_response" data-field="x_card_name" name="x_card_name" id="x_card_name" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($payment_response->card_name->getPlaceHolder()) ?>" value="<?php echo $payment_response->card_name->EditValue ?>"<?php echo $payment_response->card_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->status_code->Visible) { // status_code ?>
	<div id="r_status_code" class="form-group row">
		<label for="x_status_code" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_status_code"><?php echo $payment_response->status_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_status_code" id="z_status_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->status_code->cellAttributes() ?>>
			<span id="el_payment_response_status_code">
<input type="text" data-table="payment_response" data-field="x_status_code" name="x_status_code" id="x_status_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($payment_response->status_code->getPlaceHolder()) ?>" value="<?php echo $payment_response->status_code->EditValue ?>"<?php echo $payment_response->status_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->status_message->Visible) { // status_message ?>
	<div id="r_status_message" class="form-group row">
		<label for="x_status_message" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_status_message"><?php echo $payment_response->status_message->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_status_message" id="z_status_message" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->status_message->cellAttributes() ?>>
			<span id="el_payment_response_status_message">
<input type="text" data-table="payment_response" data-field="x_status_message" name="x_status_message" id="x_status_message" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($payment_response->status_message->getPlaceHolder()) ?>" value="<?php echo $payment_response->status_message->EditValue ?>"<?php echo $payment_response->status_message->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_amount"><?php echo $payment_response->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->amount->cellAttributes() ?>>
			<span id="el_payment_response_amount">
<input type="text" data-table="payment_response" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($payment_response->amount->getPlaceHolder()) ?>" value="<?php echo $payment_response->amount->EditValue ?>"<?php echo $payment_response->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->trans_date->Visible) { // trans_date ?>
	<div id="r_trans_date" class="form-group row">
		<label for="x_trans_date" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_trans_date"><?php echo $payment_response->trans_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_trans_date" id="z_trans_date" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->trans_date->cellAttributes() ?>>
			<span id="el_payment_response_trans_date">
<input type="text" data-table="payment_response" data-field="x_trans_date" name="x_trans_date" id="x_trans_date" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($payment_response->trans_date->getPlaceHolder()) ?>" value="<?php echo $payment_response->trans_date->EditValue ?>"<?php echo $payment_response->trans_date->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_datetime"><?php echo $payment_response->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->datetime->cellAttributes() ?>>
			<span id="el_payment_response_datetime">
<input type="text" data-table="payment_response" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($payment_response->datetime->getPlaceHolder()) ?>" value="<?php echo $payment_response->datetime->EditValue ?>"<?php echo $payment_response->datetime->editAttributes() ?>>
<?php if (!$payment_response->datetime->ReadOnly && !$payment_response->datetime->Disabled && !isset($payment_response->datetime->EditAttrs["readonly"]) && !isset($payment_response->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpayment_responsesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->payment_gateway->Visible) { // payment_gateway ?>
	<div id="r_payment_gateway" class="form-group row">
		<label for="x_payment_gateway" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_payment_gateway"><?php echo $payment_response->payment_gateway->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_payment_gateway" id="z_payment_gateway" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->payment_gateway->cellAttributes() ?>>
			<span id="el_payment_response_payment_gateway">
<input type="text" data-table="payment_response" data-field="x_payment_gateway" name="x_payment_gateway" id="x_payment_gateway" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($payment_response->payment_gateway->getPlaceHolder()) ?>" value="<?php echo $payment_response->payment_gateway->EditValue ?>"<?php echo $payment_response->payment_gateway->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->payment_signature->Visible) { // payment_signature ?>
	<div id="r_payment_signature" class="form-group row">
		<label for="x_payment_signature" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_payment_signature"><?php echo $payment_response->payment_signature->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_payment_signature" id="z_payment_signature" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->payment_signature->cellAttributes() ?>>
			<span id="el_payment_response_payment_signature">
<input type="text" data-table="payment_response" data-field="x_payment_signature" name="x_payment_signature" id="x_payment_signature" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($payment_response->payment_signature->getPlaceHolder()) ?>" value="<?php echo $payment_response->payment_signature->EditValue ?>"<?php echo $payment_response->payment_signature->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_response->currency_id->Visible) { // currency_id ?>
	<div id="r_currency_id" class="form-group row">
		<label for="x_currency_id" class="<?php echo $payment_response_search->LeftColumnClass ?>"><span id="elh_payment_response_currency_id"><?php echo $payment_response->currency_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency_id" id="z_currency_id" value="="></span>
		</label>
		<div class="<?php echo $payment_response_search->RightColumnClass ?>"><div<?php echo $payment_response->currency_id->cellAttributes() ?>>
			<span id="el_payment_response_currency_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_response" data-field="x_currency_id" data-value-separator="<?php echo $payment_response->currency_id->displayValueSeparatorAttribute() ?>" id="x_currency_id" name="x_currency_id"<?php echo $payment_response->currency_id->editAttributes() ?>>
		<?php echo $payment_response->currency_id->selectOptionListHtml("x_currency_id") ?>
	</select>
</div>
<?php echo $payment_response->currency_id->Lookup->getParamTag("p_x_currency_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_response_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_response_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_response_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_response_search->terminate();
?>