<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_response_view = new payment_response_view();

// Run the page
$payment_response_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_response_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_response->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpayment_responseview = currentForm = new ew.Form("fpayment_responseview", "view");

// Form_CustomValidate event
fpayment_responseview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_responseview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_responseview.lists["x_status"] = <?php echo $payment_response_view->status->Lookup->toClientList() ?>;
fpayment_responseview.lists["x_status"].options = <?php echo JsonEncode($payment_response_view->status->options(FALSE, TRUE)) ?>;
fpayment_responseview.lists["x__userid"] = <?php echo $payment_response_view->_userid->Lookup->toClientList() ?>;
fpayment_responseview.lists["x__userid"].options = <?php echo JsonEncode($payment_response_view->_userid->lookupOptions()) ?>;
fpayment_responseview.autoSuggests["x__userid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpayment_responseview.lists["x_currency_id"] = <?php echo $payment_response_view->currency_id->Lookup->toClientList() ?>;
fpayment_responseview.lists["x_currency_id"].options = <?php echo JsonEncode($payment_response_view->currency_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_response->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $payment_response_view->ExportOptions->render("body") ?>
<?php $payment_response_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $payment_response_view->showPageHeader(); ?>
<?php
$payment_response_view->showMessage();
?>
<form name="fpayment_responseview" id="fpayment_responseview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_response_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_response_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_response">
<input type="hidden" name="modal" value="<?php echo (int)$payment_response_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($payment_response->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_id"><?php echo $payment_response->id->caption() ?></span></td>
		<td data-name="id"<?php echo $payment_response->id->cellAttributes() ?>>
<span id="el_payment_response_id">
<span<?php echo $payment_response->id->viewAttributes() ?>>
<?php echo $payment_response->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_type"><?php echo $payment_response->type->caption() ?></span></td>
		<td data-name="type"<?php echo $payment_response->type->cellAttributes() ?>>
<span id="el_payment_response_type">
<span<?php echo $payment_response->type->viewAttributes() ?>>
<?php if ((!EmptyString($payment_response->type->getViewValue())) && $payment_response->type->linkAttributes() <> "") { ?>
<a<?php echo $payment_response->type->linkAttributes() ?>><?php echo $payment_response->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_response->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_status"><?php echo $payment_response->status->caption() ?></span></td>
		<td data-name="status"<?php echo $payment_response->status->cellAttributes() ?>>
<span id="el_payment_response_status">
<span<?php echo $payment_response->status->viewAttributes() ?>>
<?php if ((!EmptyString($payment_response->status->getViewValue())) && $payment_response->status->linkAttributes() <> "") { ?>
<a<?php echo $payment_response->status->linkAttributes() ?>><?php echo $payment_response->status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_response->status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->_userid->Visible) { // userid ?>
	<tr id="r__userid">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response__userid"><?php echo $payment_response->_userid->caption() ?></span></td>
		<td data-name="_userid"<?php echo $payment_response->_userid->cellAttributes() ?>>
<span id="el_payment_response__userid">
<span<?php echo $payment_response->_userid->viewAttributes() ?>>
<?php if ((!EmptyString($payment_response->_userid->getViewValue())) && $payment_response->_userid->linkAttributes() <> "") { ?>
<a<?php echo $payment_response->_userid->linkAttributes() ?>><?php echo $payment_response->_userid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $payment_response->_userid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->pg_order_number->Visible) { // pg_order_number ?>
	<tr id="r_pg_order_number">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_pg_order_number"><?php echo $payment_response->pg_order_number->caption() ?></span></td>
		<td data-name="pg_order_number"<?php echo $payment_response->pg_order_number->cellAttributes() ?>>
<span id="el_payment_response_pg_order_number">
<span<?php echo $payment_response->pg_order_number->viewAttributes() ?>>
<?php echo $payment_response->pg_order_number->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_remarks"><?php echo $payment_response->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $payment_response->remarks->cellAttributes() ?>>
<span id="el_payment_response_remarks">
<span<?php echo $payment_response->remarks->viewAttributes() ?>>
<?php echo $payment_response->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->cart_number->Visible) { // cart_number ?>
	<tr id="r_cart_number">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_cart_number"><?php echo $payment_response->cart_number->caption() ?></span></td>
		<td data-name="cart_number"<?php echo $payment_response->cart_number->cellAttributes() ?>>
<span id="el_payment_response_cart_number">
<span<?php echo $payment_response->cart_number->viewAttributes() ?>>
<?php echo $payment_response->cart_number->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->order_id->Visible) { // order_id ?>
	<tr id="r_order_id">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_order_id"><?php echo $payment_response->order_id->caption() ?></span></td>
		<td data-name="order_id"<?php echo $payment_response->order_id->cellAttributes() ?>>
<span id="el_payment_response_order_id">
<span<?php echo $payment_response->order_id->viewAttributes() ?>>
<?php echo $payment_response->order_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->tracking_id->Visible) { // tracking_id ?>
	<tr id="r_tracking_id">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_tracking_id"><?php echo $payment_response->tracking_id->caption() ?></span></td>
		<td data-name="tracking_id"<?php echo $payment_response->tracking_id->cellAttributes() ?>>
<span id="el_payment_response_tracking_id">
<span<?php echo $payment_response->tracking_id->viewAttributes() ?>>
<?php echo $payment_response->tracking_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->bank_ref_no->Visible) { // bank_ref_no ?>
	<tr id="r_bank_ref_no">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_bank_ref_no"><?php echo $payment_response->bank_ref_no->caption() ?></span></td>
		<td data-name="bank_ref_no"<?php echo $payment_response->bank_ref_no->cellAttributes() ?>>
<span id="el_payment_response_bank_ref_no">
<span<?php echo $payment_response->bank_ref_no->viewAttributes() ?>>
<?php echo $payment_response->bank_ref_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->order_status->Visible) { // order_status ?>
	<tr id="r_order_status">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_order_status"><?php echo $payment_response->order_status->caption() ?></span></td>
		<td data-name="order_status"<?php echo $payment_response->order_status->cellAttributes() ?>>
<span id="el_payment_response_order_status">
<span<?php echo $payment_response->order_status->viewAttributes() ?>>
<?php echo $payment_response->order_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->failure_message->Visible) { // failure_message ?>
	<tr id="r_failure_message">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_failure_message"><?php echo $payment_response->failure_message->caption() ?></span></td>
		<td data-name="failure_message"<?php echo $payment_response->failure_message->cellAttributes() ?>>
<span id="el_payment_response_failure_message">
<span<?php echo $payment_response->failure_message->viewAttributes() ?>>
<?php echo $payment_response->failure_message->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->payment_mode->Visible) { // payment_mode ?>
	<tr id="r_payment_mode">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_payment_mode"><?php echo $payment_response->payment_mode->caption() ?></span></td>
		<td data-name="payment_mode"<?php echo $payment_response->payment_mode->cellAttributes() ?>>
<span id="el_payment_response_payment_mode">
<span<?php echo $payment_response->payment_mode->viewAttributes() ?>>
<?php echo $payment_response->payment_mode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->card_name->Visible) { // card_name ?>
	<tr id="r_card_name">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_card_name"><?php echo $payment_response->card_name->caption() ?></span></td>
		<td data-name="card_name"<?php echo $payment_response->card_name->cellAttributes() ?>>
<span id="el_payment_response_card_name">
<span<?php echo $payment_response->card_name->viewAttributes() ?>>
<?php echo $payment_response->card_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->status_code->Visible) { // status_code ?>
	<tr id="r_status_code">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_status_code"><?php echo $payment_response->status_code->caption() ?></span></td>
		<td data-name="status_code"<?php echo $payment_response->status_code->cellAttributes() ?>>
<span id="el_payment_response_status_code">
<span<?php echo $payment_response->status_code->viewAttributes() ?>>
<?php echo $payment_response->status_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->status_message->Visible) { // status_message ?>
	<tr id="r_status_message">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_status_message"><?php echo $payment_response->status_message->caption() ?></span></td>
		<td data-name="status_message"<?php echo $payment_response->status_message->cellAttributes() ?>>
<span id="el_payment_response_status_message">
<span<?php echo $payment_response->status_message->viewAttributes() ?>>
<?php echo $payment_response->status_message->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_amount"><?php echo $payment_response->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $payment_response->amount->cellAttributes() ?>>
<span id="el_payment_response_amount">
<span<?php echo $payment_response->amount->viewAttributes() ?>>
<?php echo $payment_response->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->trans_date->Visible) { // trans_date ?>
	<tr id="r_trans_date">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_trans_date"><?php echo $payment_response->trans_date->caption() ?></span></td>
		<td data-name="trans_date"<?php echo $payment_response->trans_date->cellAttributes() ?>>
<span id="el_payment_response_trans_date">
<span<?php echo $payment_response->trans_date->viewAttributes() ?>>
<?php echo $payment_response->trans_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_datetime"><?php echo $payment_response->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $payment_response->datetime->cellAttributes() ?>>
<span id="el_payment_response_datetime">
<span<?php echo $payment_response->datetime->viewAttributes() ?>>
<?php echo $payment_response->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->payment_gateway->Visible) { // payment_gateway ?>
	<tr id="r_payment_gateway">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_payment_gateway"><?php echo $payment_response->payment_gateway->caption() ?></span></td>
		<td data-name="payment_gateway"<?php echo $payment_response->payment_gateway->cellAttributes() ?>>
<span id="el_payment_response_payment_gateway">
<span<?php echo $payment_response->payment_gateway->viewAttributes() ?>>
<?php echo $payment_response->payment_gateway->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->payment_signature->Visible) { // payment_signature ?>
	<tr id="r_payment_signature">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_payment_signature"><?php echo $payment_response->payment_signature->caption() ?></span></td>
		<td data-name="payment_signature"<?php echo $payment_response->payment_signature->cellAttributes() ?>>
<span id="el_payment_response_payment_signature">
<span<?php echo $payment_response->payment_signature->viewAttributes() ?>>
<?php echo $payment_response->payment_signature->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment_response->currency_id->Visible) { // currency_id ?>
	<tr id="r_currency_id">
		<td class="<?php echo $payment_response_view->TableLeftColumnClass ?>"><span id="elh_payment_response_currency_id"><?php echo $payment_response->currency_id->caption() ?></span></td>
		<td data-name="currency_id"<?php echo $payment_response->currency_id->cellAttributes() ?>>
<span id="el_payment_response_currency_id">
<span<?php echo $payment_response->currency_id->viewAttributes() ?>>
<?php echo $payment_response->currency_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$payment_response_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_response->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_response_view->terminate();
?>