<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_summary_list = new payment_summary_list();

// Run the page
$payment_summary_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_summary_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment_summary->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayment_summarylist = currentForm = new ew.Form("fpayment_summarylist", "list");
fpayment_summarylist.formKeyCountName = '<?php echo $payment_summary_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayment_summarylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_summarylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_summarylist.lists["x_emp_id"] = <?php echo $payment_summary_list->emp_id->Lookup->toClientList() ?>;
fpayment_summarylist.lists["x_emp_id"].options = <?php echo JsonEncode($payment_summary_list->emp_id->lookupOptions()) ?>;
fpayment_summarylist.lists["x_ref"] = <?php echo $payment_summary_list->ref->Lookup->toClientList() ?>;
fpayment_summarylist.lists["x_ref"].options = <?php echo JsonEncode($payment_summary_list->ref->lookupOptions()) ?>;
fpayment_summarylist.lists["x_location"] = <?php echo $payment_summary_list->location->Lookup->toClientList() ?>;
fpayment_summarylist.lists["x_location"].options = <?php echo JsonEncode($payment_summary_list->location->lookupOptions()) ?>;
fpayment_summarylist.lists["x_process"] = <?php echo $payment_summary_list->process->Lookup->toClientList() ?>;
fpayment_summarylist.lists["x_process"].options = <?php echo JsonEncode($payment_summary_list->process->lookupOptions()) ?>;
fpayment_summarylist.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpayment_summarylist.lists["x_payment"] = <?php echo $payment_summary_list->payment->Lookup->toClientList() ?>;
fpayment_summarylist.lists["x_payment"].options = <?php echo JsonEncode($payment_summary_list->payment->lookupOptions()) ?>;

// Form object for search
var fpayment_summarylistsrch = currentSearchForm = new ew.Form("fpayment_summarylistsrch");

// Validate function for search
fpayment_summarylistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpayment_summarylistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_summarylistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_summarylistsrch.lists["x_location"] = <?php echo $payment_summary_list->location->Lookup->toClientList() ?>;
fpayment_summarylistsrch.lists["x_location"].options = <?php echo JsonEncode($payment_summary_list->location->lookupOptions()) ?>;
fpayment_summarylistsrch.lists["x_process"] = <?php echo $payment_summary_list->process->Lookup->toClientList() ?>;
fpayment_summarylistsrch.lists["x_process"].options = <?php echo JsonEncode($payment_summary_list->process->lookupOptions()) ?>;
fpayment_summarylistsrch.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpayment_summarylistsrch.lists["x_payment"] = <?php echo $payment_summary_list->payment->Lookup->toClientList() ?>;
fpayment_summarylistsrch.lists["x_payment"].options = <?php echo JsonEncode($payment_summary_list->payment->lookupOptions()) ?>;

// Filters
fpayment_summarylistsrch.filterList = <?php echo $payment_summary_list->getFilterList() ?>;

// Init search panel as collapsed
fpayment_summarylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment_summary->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_summary_list->TotalRecs > 0 && $payment_summary_list->ExportOptions->visible()) { ?>
<?php $payment_summary_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_summary_list->ImportOptions->visible()) { ?>
<?php $payment_summary_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_summary_list->SearchOptions->visible()) { ?>
<?php $payment_summary_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_summary_list->FilterOptions->visible()) { ?>
<?php $payment_summary_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_summary_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment_summary->isExport() && !$payment_summary->CurrentAction) { ?>
<form name="fpayment_summarylistsrch" id="fpayment_summarylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_summary_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayment_summarylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment_summary">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$payment_summary_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$payment_summary->RowType = ROWTYPE_SEARCH;

// Render row
$payment_summary->resetAttributes();
$payment_summary_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($payment_summary->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $payment_summary->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_summary" data-field="x_location" data-value-separator="<?php echo $payment_summary->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $payment_summary->location->editAttributes() ?>>
		<?php echo $payment_summary->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $payment_summary->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_summary->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $payment_summary->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$payment_summary->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment_summary->process->EditAttrs["onchange"] = "";
?>
<span id="as_x_process" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_process" id="sv_x_process" value="<?php echo RemoveHtml($payment_summary->process->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($payment_summary->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment_summary->process->getPlaceHolder()) ?>"<?php echo $payment_summary->process->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_summary->process->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_process',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($payment_summary->process->ReadOnly || $payment_summary->process->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment_summary" data-field="x_process" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment_summary->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?php echo HtmlEncode($payment_summary->process->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpayment_summarylistsrch.createAutoSuggest({"id":"x_process","forceSelect":false});
</script>
<?php echo $payment_summary->process->Lookup->getParamTag("p_x_process") ?>
</span>
		<span class="ew-search-cond btw0_process"><div class="form-check form-check-inline"><input class="form-check-input" type="radio" id="v_process_1" name="v_process" value="AND"<?php if ($payment_summary->process->AdvancedSearch->SearchCondition <> "OR") echo " checked" ?>><label class="form-check-label" for="v_process_1"><?php echo $Language->phrase("AND") ?></label></div><div class="form-check form-check-inline"><input class="form-check-input" type="radio" id="v_process_2" name="v_process" value="OR"<?php if ($payment_summary->process->AdvancedSearch->SearchCondition == "OR") echo " checked" ?>><label class="form-check-label" for="v_process_2"><?php echo $Language->phrase("OR") ?></label></div></span>
		<span class="ew-search-operator btw0_process"><?php echo $Language->phrase("=") ?><input type="hidden" name="w_process" id="w_process" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$payment_summary->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment_summary->process->EditAttrs["onchange"] = "";
?>
<span id="as_y_process" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_y_process" id="sv_y_process" value="<?php echo RemoveHtml($payment_summary->process->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($payment_summary->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment_summary->process->getPlaceHolder()) ?>"<?php echo $payment_summary->process->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_summary->process->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'y_process',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($payment_summary->process->ReadOnly || $payment_summary->process->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment_summary" data-field="x_process" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment_summary->process->displayValueSeparatorAttribute() ?>" name="y_process" id="y_process" value="<?php echo HtmlEncode($payment_summary->process->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fpayment_summarylistsrch.createAutoSuggest({"id":"y_process","forceSelect":false});
</script>
<?php echo $payment_summary->process->Lookup->getParamTag("p_y_process") ?>
</span>
	</div>
<?php } ?>
<?php if ($payment_summary->payment->Visible) { // payment ?>
	<div id="xsc_payment" class="ew-cell form-group">
		<label for="x_payment" class="ew-search-caption ew-label"><?php echo $payment_summary->payment->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment" id="z_payment" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_summary" data-field="x_payment" data-value-separator="<?php echo $payment_summary->payment->displayValueSeparatorAttribute() ?>" id="x_payment" name="x_payment"<?php echo $payment_summary->payment->editAttributes() ?>>
		<?php echo $payment_summary->payment->selectOptionListHtml("x_payment") ?>
	</select>
</div>
<?php echo $payment_summary->payment->Lookup->getParamTag("p_x_payment") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_summary_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_summary_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_summary_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_summary_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_summary_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_summary_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_summary_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_summary_list->showPageHeader(); ?>
<?php
$payment_summary_list->showMessage();
?>
<?php if ($payment_summary_list->TotalRecs > 0 || $payment_summary->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_summary_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment_summary">
<?php if (!$payment_summary->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment_summary->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_summary_list->Pager)) $payment_summary_list->Pager = new PrevNextPager($payment_summary_list->StartRec, $payment_summary_list->DisplayRecs, $payment_summary_list->TotalRecs, $payment_summary_list->AutoHidePager) ?>
<?php if ($payment_summary_list->Pager->RecordCount > 0 && $payment_summary_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_summary_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_summary_list->pageUrl() ?>start=<?php echo $payment_summary_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_summary_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_summary_list->pageUrl() ?>start=<?php echo $payment_summary_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_summary_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_summary_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_summary_list->pageUrl() ?>start=<?php echo $payment_summary_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_summary_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_summary_list->pageUrl() ?>start=<?php echo $payment_summary_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_summary_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_summary_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_summary_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_summary_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_summary_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_summary_list->TotalRecs > 0 && (!$payment_summary_list->AutoHidePageSizeSelector || $payment_summary_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_summary">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_summary_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_summary_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_summary_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_summary_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_summary_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_summary->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_summary_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayment_summarylist" id="fpayment_summarylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_summary_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_summary_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_summary">
<div id="gmp_payment_summary" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_summary_list->TotalRecs > 0 || $payment_summary->isGridEdit()) { ?>
<table id="tbl_payment_summarylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_summary_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_summary_list->renderListOptions();

// Render list options (header, left)
$payment_summary_list->ListOptions->render("header", "left");
?>
<?php if ($payment_summary->emp_id->Visible) { // emp_id ?>
	<?php if ($payment_summary->sortUrl($payment_summary->emp_id) == "") { ?>
		<th data-name="emp_id" class="<?php echo $payment_summary->emp_id->headerCellClass() ?>"><div id="elh_payment_summary_emp_id" class="payment_summary_emp_id"><div class="ew-table-header-caption"><?php echo $payment_summary->emp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_id" class="<?php echo $payment_summary->emp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->emp_id) ?>',2);"><div id="elh_payment_summary_emp_id" class="payment_summary_emp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->emp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->emp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->emp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->emp_grp->Visible) { // emp_grp ?>
	<?php if ($payment_summary->sortUrl($payment_summary->emp_grp) == "") { ?>
		<th data-name="emp_grp" class="<?php echo $payment_summary->emp_grp->headerCellClass() ?>"><div id="elh_payment_summary_emp_grp" class="payment_summary_emp_grp"><div class="ew-table-header-caption"><?php echo $payment_summary->emp_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_grp" class="<?php echo $payment_summary->emp_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->emp_grp) ?>',2);"><div id="elh_payment_summary_emp_grp" class="payment_summary_emp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->emp_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->emp_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->emp_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->ref->Visible) { // ref ?>
	<?php if ($payment_summary->sortUrl($payment_summary->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $payment_summary->ref->headerCellClass() ?>"><div id="elh_payment_summary_ref" class="payment_summary_ref"><div class="ew-table-header-caption"><?php echo $payment_summary->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $payment_summary->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->ref) ?>',2);"><div id="elh_payment_summary_ref" class="payment_summary_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->size_wl->Visible) { // size_wl ?>
	<?php if ($payment_summary->sortUrl($payment_summary->size_wl) == "") { ?>
		<th data-name="size_wl" class="<?php echo $payment_summary->size_wl->headerCellClass() ?>"><div id="elh_payment_summary_size_wl" class="payment_summary_size_wl"><div class="ew-table-header-caption"><?php echo $payment_summary->size_wl->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_wl" class="<?php echo $payment_summary->size_wl->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->size_wl) ?>',2);"><div id="elh_payment_summary_size_wl" class="payment_summary_size_wl">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->size_wl->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->size_wl->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->size_wl->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->count->Visible) { // count ?>
	<?php if ($payment_summary->sortUrl($payment_summary->count) == "") { ?>
		<th data-name="count" class="<?php echo $payment_summary->count->headerCellClass() ?>"><div id="elh_payment_summary_count" class="payment_summary_count"><div class="ew-table-header-caption"><?php echo $payment_summary->count->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count" class="<?php echo $payment_summary->count->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->count) ?>',2);"><div id="elh_payment_summary_count" class="payment_summary_count">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->count->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->count->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->count->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->sqm->Visible) { // sqm ?>
	<?php if ($payment_summary->sortUrl($payment_summary->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $payment_summary->sqm->headerCellClass() ?>"><div id="elh_payment_summary_sqm" class="payment_summary_sqm"><div class="ew-table-header-caption"><?php echo $payment_summary->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $payment_summary->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->sqm) ?>',2);"><div id="elh_payment_summary_sqm" class="payment_summary_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->amount->Visible) { // amount ?>
	<?php if ($payment_summary->sortUrl($payment_summary->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $payment_summary->amount->headerCellClass() ?>"><div id="elh_payment_summary_amount" class="payment_summary_amount"><div class="ew-table-header-caption"><?php echo $payment_summary->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $payment_summary->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->amount) ?>',2);"><div id="elh_payment_summary_amount" class="payment_summary_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->tamount->Visible) { // tamount ?>
	<?php if ($payment_summary->sortUrl($payment_summary->tamount) == "") { ?>
		<th data-name="tamount" class="<?php echo $payment_summary->tamount->headerCellClass() ?>"><div id="elh_payment_summary_tamount" class="payment_summary_tamount"><div class="ew-table-header-caption"><?php echo $payment_summary->tamount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tamount" class="<?php echo $payment_summary->tamount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->tamount) ?>',2);"><div id="elh_payment_summary_tamount" class="payment_summary_tamount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->tamount->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->tamount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->tamount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->location->Visible) { // location ?>
	<?php if ($payment_summary->sortUrl($payment_summary->location) == "") { ?>
		<th data-name="location" class="<?php echo $payment_summary->location->headerCellClass() ?>"><div id="elh_payment_summary_location" class="payment_summary_location"><div class="ew-table-header-caption"><?php echo $payment_summary->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $payment_summary->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->location) ?>',2);"><div id="elh_payment_summary_location" class="payment_summary_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->process->Visible) { // process ?>
	<?php if ($payment_summary->sortUrl($payment_summary->process) == "") { ?>
		<th data-name="process" class="<?php echo $payment_summary->process->headerCellClass() ?>"><div id="elh_payment_summary_process" class="payment_summary_process"><div class="ew-table-header-caption"><?php echo $payment_summary->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $payment_summary->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->process) ?>',2);"><div id="elh_payment_summary_process" class="payment_summary_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment_summary->payment->Visible) { // payment ?>
	<?php if ($payment_summary->sortUrl($payment_summary->payment) == "") { ?>
		<th data-name="payment" class="<?php echo $payment_summary->payment->headerCellClass() ?>"><div id="elh_payment_summary_payment" class="payment_summary_payment"><div class="ew-table-header-caption"><?php echo $payment_summary->payment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment" class="<?php echo $payment_summary->payment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment_summary->SortUrl($payment_summary->payment) ?>',2);"><div id="elh_payment_summary_payment" class="payment_summary_payment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment_summary->payment->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment_summary->payment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment_summary->payment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_summary_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment_summary->ExportAll && $payment_summary->isExport()) {
	$payment_summary_list->StopRec = $payment_summary_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_summary_list->TotalRecs > $payment_summary_list->StartRec + $payment_summary_list->DisplayRecs - 1)
		$payment_summary_list->StopRec = $payment_summary_list->StartRec + $payment_summary_list->DisplayRecs - 1;
	else
		$payment_summary_list->StopRec = $payment_summary_list->TotalRecs;
}
$payment_summary_list->RecCnt = $payment_summary_list->StartRec - 1;
if ($payment_summary_list->Recordset && !$payment_summary_list->Recordset->EOF) {
	$payment_summary_list->Recordset->moveFirst();
	$selectLimit = $payment_summary_list->UseSelectLimit;
	if (!$selectLimit && $payment_summary_list->StartRec > 1)
		$payment_summary_list->Recordset->move($payment_summary_list->StartRec - 1);
} elseif (!$payment_summary->AllowAddDeleteRow && $payment_summary_list->StopRec == 0) {
	$payment_summary_list->StopRec = $payment_summary->GridAddRowCount;
}

// Initialize aggregate
$payment_summary->RowType = ROWTYPE_AGGREGATEINIT;
$payment_summary->resetAttributes();
$payment_summary_list->renderRow();
while ($payment_summary_list->RecCnt < $payment_summary_list->StopRec) {
	$payment_summary_list->RecCnt++;
	if ($payment_summary_list->RecCnt >= $payment_summary_list->StartRec) {
		$payment_summary_list->RowCnt++;

		// Set up key count
		$payment_summary_list->KeyCount = $payment_summary_list->RowIndex;

		// Init row class and style
		$payment_summary->resetAttributes();
		$payment_summary->CssClass = "";
		if ($payment_summary->isGridAdd()) {
		} else {
			$payment_summary_list->loadRowValues($payment_summary_list->Recordset); // Load row values
		}
		$payment_summary->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment_summary->RowAttrs = array_merge($payment_summary->RowAttrs, array('data-rowindex'=>$payment_summary_list->RowCnt, 'id'=>'r' . $payment_summary_list->RowCnt . '_payment_summary', 'data-rowtype'=>$payment_summary->RowType));

		// Render row
		$payment_summary_list->renderRow();

		// Render list options
		$payment_summary_list->renderListOptions();
?>
	<tr<?php echo $payment_summary->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_summary_list->ListOptions->render("body", "left", $payment_summary_list->RowCnt);
?>
	<?php if ($payment_summary->emp_id->Visible) { // emp_id ?>
		<td data-name="emp_id"<?php echo $payment_summary->emp_id->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_emp_id" class="payment_summary_emp_id">
<span<?php echo $payment_summary->emp_id->viewAttributes() ?>>
<?php echo $payment_summary->emp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->emp_grp->Visible) { // emp_grp ?>
		<td data-name="emp_grp"<?php echo $payment_summary->emp_grp->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_emp_grp" class="payment_summary_emp_grp">
<span<?php echo $payment_summary->emp_grp->viewAttributes() ?>>
<?php echo $payment_summary->emp_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $payment_summary->ref->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_ref" class="payment_summary_ref">
<span<?php echo $payment_summary->ref->viewAttributes() ?>>
<?php echo $payment_summary->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->size_wl->Visible) { // size_wl ?>
		<td data-name="size_wl"<?php echo $payment_summary->size_wl->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_size_wl" class="payment_summary_size_wl">
<span<?php echo $payment_summary->size_wl->viewAttributes() ?>>
<?php echo $payment_summary->size_wl->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->count->Visible) { // count ?>
		<td data-name="count"<?php echo $payment_summary->count->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_count" class="payment_summary_count">
<span<?php echo $payment_summary->count->viewAttributes() ?>>
<?php echo $payment_summary->count->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $payment_summary->sqm->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_sqm" class="payment_summary_sqm">
<span<?php echo $payment_summary->sqm->viewAttributes() ?>>
<?php echo $payment_summary->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $payment_summary->amount->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_amount" class="payment_summary_amount">
<span<?php echo $payment_summary->amount->viewAttributes() ?>>
<?php echo $payment_summary->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->tamount->Visible) { // tamount ?>
		<td data-name="tamount"<?php echo $payment_summary->tamount->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_tamount" class="payment_summary_tamount">
<span<?php echo $payment_summary->tamount->viewAttributes() ?>>
<?php echo $payment_summary->tamount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->location->Visible) { // location ?>
		<td data-name="location"<?php echo $payment_summary->location->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_location" class="payment_summary_location">
<span<?php echo $payment_summary->location->viewAttributes() ?>>
<?php echo $payment_summary->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->process->Visible) { // process ?>
		<td data-name="process"<?php echo $payment_summary->process->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_process" class="payment_summary_process">
<span<?php echo $payment_summary->process->viewAttributes() ?>>
<?php echo $payment_summary->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment_summary->payment->Visible) { // payment ?>
		<td data-name="payment"<?php echo $payment_summary->payment->cellAttributes() ?>>
<span id="el<?php echo $payment_summary_list->RowCnt ?>_payment_summary_payment" class="payment_summary_payment">
<span<?php echo $payment_summary->payment->viewAttributes() ?>>
<?php echo $payment_summary->payment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_summary_list->ListOptions->render("body", "right", $payment_summary_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment_summary->isGridAdd())
		$payment_summary_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment_summary->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_summary_list->Recordset)
	$payment_summary_list->Recordset->Close();
?>
<?php if (!$payment_summary->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment_summary->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_summary_list->Pager)) $payment_summary_list->Pager = new PrevNextPager($payment_summary_list->StartRec, $payment_summary_list->DisplayRecs, $payment_summary_list->TotalRecs, $payment_summary_list->AutoHidePager) ?>
<?php if ($payment_summary_list->Pager->RecordCount > 0 && $payment_summary_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_summary_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_summary_list->pageUrl() ?>start=<?php echo $payment_summary_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_summary_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_summary_list->pageUrl() ?>start=<?php echo $payment_summary_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_summary_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_summary_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_summary_list->pageUrl() ?>start=<?php echo $payment_summary_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_summary_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_summary_list->pageUrl() ?>start=<?php echo $payment_summary_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_summary_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_summary_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_summary_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_summary_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_summary_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_summary_list->TotalRecs > 0 && (!$payment_summary_list->AutoHidePageSizeSelector || $payment_summary_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment_summary">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_summary_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_summary_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_summary_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_summary_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_summary_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment_summary->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_summary_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_summary_list->TotalRecs == 0 && !$payment_summary->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_summary_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_summary_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment_summary->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment_summary->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment_summary", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_summary_list->terminate();
?>