<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_summary_search = new payment_summary_search();

// Run the page
$payment_summary_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_summary_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($payment_summary_search->IsModal) { ?>
var fpayment_summarysearch = currentAdvancedSearchForm = new ew.Form("fpayment_summarysearch", "search");
<?php } else { ?>
var fpayment_summarysearch = currentForm = new ew.Form("fpayment_summarysearch", "search");
<?php } ?>

// Form_CustomValidate event
fpayment_summarysearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayment_summarysearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayment_summarysearch.lists["x_emp_id"] = <?php echo $payment_summary_search->emp_id->Lookup->toClientList() ?>;
fpayment_summarysearch.lists["x_emp_id"].options = <?php echo JsonEncode($payment_summary_search->emp_id->lookupOptions()) ?>;
fpayment_summarysearch.lists["x_ref"] = <?php echo $payment_summary_search->ref->Lookup->toClientList() ?>;
fpayment_summarysearch.lists["x_ref"].options = <?php echo JsonEncode($payment_summary_search->ref->lookupOptions()) ?>;
fpayment_summarysearch.lists["x_location"] = <?php echo $payment_summary_search->location->Lookup->toClientList() ?>;
fpayment_summarysearch.lists["x_location"].options = <?php echo JsonEncode($payment_summary_search->location->lookupOptions()) ?>;
fpayment_summarysearch.lists["x_process"] = <?php echo $payment_summary_search->process->Lookup->toClientList() ?>;
fpayment_summarysearch.lists["x_process"].options = <?php echo JsonEncode($payment_summary_search->process->lookupOptions()) ?>;
fpayment_summarysearch.autoSuggests["x_process"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpayment_summarysearch.lists["x_payment"] = <?php echo $payment_summary_search->payment->Lookup->toClientList() ?>;
fpayment_summarysearch.lists["x_payment"].options = <?php echo JsonEncode($payment_summary_search->payment->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpayment_summarysearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_size_wl");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_summary->size_wl->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_count");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_summary->count->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_summary->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_summary->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tamount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment_summary->tamount->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_summary_search->showPageHeader(); ?>
<?php
$payment_summary_search->showMessage();
?>
<form name="fpayment_summarysearch" id="fpayment_summarysearch" class="<?php echo $payment_summary_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_summary_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_summary_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment_summary">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$payment_summary_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($payment_summary->emp_id->Visible) { // emp_id ?>
	<div id="r_emp_id" class="form-group row">
		<label for="x_emp_id" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_emp_id"><?php echo $payment_summary->emp_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emp_id" id="z_emp_id" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->emp_id->cellAttributes() ?>>
			<span id="el_payment_summary_emp_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_summary" data-field="x_emp_id" data-value-separator="<?php echo $payment_summary->emp_id->displayValueSeparatorAttribute() ?>" id="x_emp_id" name="x_emp_id"<?php echo $payment_summary->emp_id->editAttributes() ?>>
		<?php echo $payment_summary->emp_id->selectOptionListHtml("x_emp_id") ?>
	</select>
</div>
<?php echo $payment_summary->emp_id->Lookup->getParamTag("p_x_emp_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_ref"><?php echo $payment_summary->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref" id="z_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->ref->cellAttributes() ?>>
			<span id="el_payment_summary_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_summary" data-field="x_ref" data-value-separator="<?php echo $payment_summary->ref->displayValueSeparatorAttribute() ?>" id="x_ref" name="x_ref"<?php echo $payment_summary->ref->editAttributes() ?>>
		<?php echo $payment_summary->ref->selectOptionListHtml("x_ref") ?>
	</select>
</div>
<?php echo $payment_summary->ref->Lookup->getParamTag("p_x_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->size_wl->Visible) { // size_wl ?>
	<div id="r_size_wl" class="form-group row">
		<label for="x_size_wl" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_size_wl"><?php echo $payment_summary->size_wl->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_size_wl" id="z_size_wl" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->size_wl->cellAttributes() ?>>
			<span id="el_payment_summary_size_wl">
<input type="text" data-table="payment_summary" data-field="x_size_wl" name="x_size_wl" id="x_size_wl" size="30" placeholder="<?php echo HtmlEncode($payment_summary->size_wl->getPlaceHolder()) ?>" value="<?php echo $payment_summary->size_wl->EditValue ?>"<?php echo $payment_summary->size_wl->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->count->Visible) { // count ?>
	<div id="r_count" class="form-group row">
		<label for="x_count" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_count"><?php echo $payment_summary->count->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_count" id="z_count" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->count->cellAttributes() ?>>
			<span id="el_payment_summary_count">
<input type="text" data-table="payment_summary" data-field="x_count" name="x_count" id="x_count" size="30" placeholder="<?php echo HtmlEncode($payment_summary->count->getPlaceHolder()) ?>" value="<?php echo $payment_summary->count->EditValue ?>"<?php echo $payment_summary->count->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_sqm"><?php echo $payment_summary->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->sqm->cellAttributes() ?>>
			<span id="el_payment_summary_sqm">
<input type="text" data-table="payment_summary" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($payment_summary->sqm->getPlaceHolder()) ?>" value="<?php echo $payment_summary->sqm->EditValue ?>"<?php echo $payment_summary->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_amount"><?php echo $payment_summary->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->amount->cellAttributes() ?>>
			<span id="el_payment_summary_amount">
<input type="text" data-table="payment_summary" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($payment_summary->amount->getPlaceHolder()) ?>" value="<?php echo $payment_summary->amount->EditValue ?>"<?php echo $payment_summary->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->tamount->Visible) { // tamount ?>
	<div id="r_tamount" class="form-group row">
		<label for="x_tamount" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_tamount"><?php echo $payment_summary->tamount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tamount" id="z_tamount" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->tamount->cellAttributes() ?>>
			<span id="el_payment_summary_tamount">
<input type="text" data-table="payment_summary" data-field="x_tamount" name="x_tamount" id="x_tamount" size="30" placeholder="<?php echo HtmlEncode($payment_summary->tamount->getPlaceHolder()) ?>" value="<?php echo $payment_summary->tamount->EditValue ?>"<?php echo $payment_summary->tamount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_location"><?php echo $payment_summary->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->location->cellAttributes() ?>>
			<span id="el_payment_summary_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_summary" data-field="x_location" data-value-separator="<?php echo $payment_summary->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $payment_summary->location->editAttributes() ?>>
		<?php echo $payment_summary->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $payment_summary->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_process"><?php echo $payment_summary->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->process->cellAttributes() ?>>
			<span id="el_payment_summary_process">
<?php
$wrkonchange = "" . trim(@$payment_summary->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment_summary->process->EditAttrs["onchange"] = "";
?>
<span id="as_x_process" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_process" id="sv_x_process" value="<?php echo RemoveHtml($payment_summary->process->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($payment_summary->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment_summary->process->getPlaceHolder()) ?>"<?php echo $payment_summary->process->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_summary->process->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_process',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($payment_summary->process->ReadOnly || $payment_summary->process->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment_summary" data-field="x_process" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment_summary->process->displayValueSeparatorAttribute() ?>" name="x_process" id="x_process" value="<?php echo HtmlEncode($payment_summary->process->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpayment_summarysearch.createAutoSuggest({"id":"x_process","forceSelect":false});
</script>
<?php echo $payment_summary->process->Lookup->getParamTag("p_x_process") ?>
</span>
			<span class="ew-search-cond btw0_process"><div class="form-check form-check-inline"><input class="form-check-input" type="radio" id="v_process_1" name="v_process" value="AND"<?php if ($payment_summary->process->AdvancedSearch->SearchCondition <> "OR") echo " checked" ?>><label class="form-check-label" for="v_process_1"><?php echo $Language->phrase("AND") ?></label></div><div class="form-check form-check-inline"><input class="form-check-input" type="radio" id="v_process_2" name="v_process" value="OR"<?php if ($payment_summary->process->AdvancedSearch->SearchCondition == "OR") echo " checked" ?>><label class="form-check-label" for="v_process_2"><?php echo $Language->phrase("OR") ?></label></div></span>
			<span class="ew-search-operator btw0_process"><?php echo $Language->phrase("=") ?><input type="hidden" name="w_process" id="w_process" value="="></span>
			<span id="e2_payment_summary_process" class="">
<?php
$wrkonchange = "" . trim(@$payment_summary->process->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment_summary->process->EditAttrs["onchange"] = "";
?>
<span id="as_y_process" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_y_process" id="sv_y_process" value="<?php echo RemoveHtml($payment_summary->process->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($payment_summary->process->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment_summary->process->getPlaceHolder()) ?>"<?php echo $payment_summary->process->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment_summary->process->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'y_process',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($payment_summary->process->ReadOnly || $payment_summary->process->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment_summary" data-field="x_process" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment_summary->process->displayValueSeparatorAttribute() ?>" name="y_process" id="y_process" value="<?php echo HtmlEncode($payment_summary->process->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fpayment_summarysearch.createAutoSuggest({"id":"y_process","forceSelect":false});
</script>
<?php echo $payment_summary->process->Lookup->getParamTag("p_y_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment_summary->payment->Visible) { // payment ?>
	<div id="r_payment" class="form-group row">
		<label for="x_payment" class="<?php echo $payment_summary_search->LeftColumnClass ?>"><span id="elh_payment_summary_payment"><?php echo $payment_summary->payment->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_payment" id="z_payment" value="="></span>
		</label>
		<div class="<?php echo $payment_summary_search->RightColumnClass ?>"><div<?php echo $payment_summary->payment->cellAttributes() ?>>
			<span id="el_payment_summary_payment">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="payment_summary" data-field="x_payment" data-value-separator="<?php echo $payment_summary->payment->displayValueSeparatorAttribute() ?>" id="x_payment" name="x_payment"<?php echo $payment_summary->payment->editAttributes() ?>>
		<?php echo $payment_summary->payment->selectOptionListHtml("x_payment") ?>
	</select>
</div>
<?php echo $payment_summary->payment->Lookup->getParamTag("p_x_payment") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_summary_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_summary_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_summary_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_summary_search->terminate();
?>