<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_delete = new payment_delete();

// Run the page
$payment_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fpaymentdelete = currentForm = new ew.Form("fpaymentdelete", "delete");

// Form_CustomValidate event
fpaymentdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpaymentdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpaymentdelete.lists["x_type"] = <?php echo $payment_delete->type->Lookup->toClientList() ?>;
fpaymentdelete.lists["x_type"].options = <?php echo JsonEncode($payment_delete->type->options(FALSE, TRUE)) ?>;
fpaymentdelete.lists["x_from_account"] = <?php echo $payment_delete->from_account->Lookup->toClientList() ?>;
fpaymentdelete.lists["x_from_account"].options = <?php echo JsonEncode($payment_delete->from_account->lookupOptions()) ?>;
fpaymentdelete.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpaymentdelete.lists["x_to_account"] = <?php echo $payment_delete->to_account->Lookup->toClientList() ?>;
fpaymentdelete.lists["x_to_account"].options = <?php echo JsonEncode($payment_delete->to_account->lookupOptions()) ?>;
fpaymentdelete.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_delete->showPageHeader(); ?>
<?php
$payment_delete->showMessage();
?>
<form name="fpaymentdelete" id="fpaymentdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($payment_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($payment->id->Visible) { // id ?>
		<th class="<?php echo $payment->id->headerCellClass() ?>"><span id="elh_payment_id" class="payment_id"><?php echo $payment->id->caption() ?></span></th>
<?php } ?>
<?php if ($payment->type->Visible) { // type ?>
		<th class="<?php echo $payment->type->headerCellClass() ?>"><span id="elh_payment_type" class="payment_type"><?php echo $payment->type->caption() ?></span></th>
<?php } ?>
<?php if ($payment->from_account->Visible) { // from_account ?>
		<th class="<?php echo $payment->from_account->headerCellClass() ?>"><span id="elh_payment_from_account" class="payment_from_account"><?php echo $payment->from_account->caption() ?></span></th>
<?php } ?>
<?php if ($payment->to_account->Visible) { // to_account ?>
		<th class="<?php echo $payment->to_account->headerCellClass() ?>"><span id="elh_payment_to_account" class="payment_to_account"><?php echo $payment->to_account->caption() ?></span></th>
<?php } ?>
<?php if ($payment->reference->Visible) { // reference ?>
		<th class="<?php echo $payment->reference->headerCellClass() ?>"><span id="elh_payment_reference" class="payment_reference"><?php echo $payment->reference->caption() ?></span></th>
<?php } ?>
<?php if ($payment->amount->Visible) { // amount ?>
		<th class="<?php echo $payment->amount->headerCellClass() ?>"><span id="elh_payment_amount" class="payment_amount"><?php echo $payment->amount->caption() ?></span></th>
<?php } ?>
<?php if ($payment->dated->Visible) { // dated ?>
		<th class="<?php echo $payment->dated->headerCellClass() ?>"><span id="elh_payment_dated" class="payment_dated"><?php echo $payment->dated->caption() ?></span></th>
<?php } ?>
<?php if ($payment->remarks->Visible) { // remarks ?>
		<th class="<?php echo $payment->remarks->headerCellClass() ?>"><span id="elh_payment_remarks" class="payment_remarks"><?php echo $payment->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($payment->uploads->Visible) { // uploads ?>
		<th class="<?php echo $payment->uploads->headerCellClass() ?>"><span id="elh_payment_uploads" class="payment_uploads"><?php echo $payment->uploads->caption() ?></span></th>
<?php } ?>
<?php if ($payment->operator->Visible) { // operator ?>
		<th class="<?php echo $payment->operator->headerCellClass() ?>"><span id="elh_payment_operator" class="payment_operator"><?php echo $payment->operator->caption() ?></span></th>
<?php } ?>
<?php if ($payment->datetime->Visible) { // datetime ?>
		<th class="<?php echo $payment->datetime->headerCellClass() ?>"><span id="elh_payment_datetime" class="payment_datetime"><?php echo $payment->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$payment_delete->RecCnt = 0;
$i = 0;
while (!$payment_delete->Recordset->EOF) {
	$payment_delete->RecCnt++;
	$payment_delete->RowCnt++;

	// Set row properties
	$payment->resetAttributes();
	$payment->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$payment_delete->loadRowValues($payment_delete->Recordset);

	// Render row
	$payment_delete->renderRow();
?>
	<tr<?php echo $payment->rowAttributes() ?>>
<?php if ($payment->id->Visible) { // id ?>
		<td<?php echo $payment->id->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_id" class="payment_id">
<span<?php echo $payment->id->viewAttributes() ?>>
<?php echo $payment->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->type->Visible) { // type ?>
		<td<?php echo $payment->type->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_type" class="payment_type">
<span<?php echo $payment->type->viewAttributes() ?>>
<?php echo $payment->type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->from_account->Visible) { // from_account ?>
		<td<?php echo $payment->from_account->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_from_account" class="payment_from_account">
<span<?php echo $payment->from_account->viewAttributes() ?>>
<?php echo $payment->from_account->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->to_account->Visible) { // to_account ?>
		<td<?php echo $payment->to_account->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_to_account" class="payment_to_account">
<span<?php echo $payment->to_account->viewAttributes() ?>>
<?php echo $payment->to_account->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->reference->Visible) { // reference ?>
		<td<?php echo $payment->reference->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_reference" class="payment_reference">
<span<?php echo $payment->reference->viewAttributes() ?>>
<?php echo $payment->reference->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->amount->Visible) { // amount ?>
		<td<?php echo $payment->amount->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_amount" class="payment_amount">
<span<?php echo $payment->amount->viewAttributes() ?>>
<?php echo $payment->amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->dated->Visible) { // dated ?>
		<td<?php echo $payment->dated->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_dated" class="payment_dated">
<span<?php echo $payment->dated->viewAttributes() ?>>
<?php echo $payment->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->remarks->Visible) { // remarks ?>
		<td<?php echo $payment->remarks->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_remarks" class="payment_remarks">
<span<?php echo $payment->remarks->viewAttributes() ?>>
<?php echo $payment->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->uploads->Visible) { // uploads ?>
		<td<?php echo $payment->uploads->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_uploads" class="payment_uploads">
<span>
<?php echo GetFileViewTag($payment->uploads, $payment->uploads->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($payment->operator->Visible) { // operator ?>
		<td<?php echo $payment->operator->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_operator" class="payment_operator">
<span<?php echo $payment->operator->viewAttributes() ?>>
<?php echo $payment->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payment->datetime->Visible) { // datetime ?>
		<td<?php echo $payment->datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_delete->RowCnt ?>_payment_datetime" class="payment_datetime">
<span<?php echo $payment->datetime->viewAttributes() ?>>
<?php echo $payment->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$payment_delete->Recordset->moveNext();
}
$payment_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payment_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$payment_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_delete->terminate();
?>