<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_edit = new payment_edit();

// Run the page
$payment_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpaymentedit = currentForm = new ew.Form("fpaymentedit", "edit");

// Validate form
fpaymentedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($payment_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->id->caption(), $payment->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->type->caption(), $payment->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_edit->from_account->Required) { ?>
			elm = this.getElements("x" + infix + "_from_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->from_account->caption(), $payment->from_account->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_from_account");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment->from_account->errorMessage()) ?>");
		<?php if ($payment_edit->to_account->Required) { ?>
			elm = this.getElements("x" + infix + "_to_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->to_account->caption(), $payment->to_account->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_to_account");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment->to_account->errorMessage()) ?>");
		<?php if ($payment_edit->reference->Required) { ?>
			elm = this.getElements("x" + infix + "_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->reference->caption(), $payment->reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->amount->caption(), $payment->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment->amount->errorMessage()) ?>");
		<?php if ($payment_edit->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->dated->caption(), $payment->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($payment->dated->errorMessage()) ?>");
		<?php if ($payment_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->remarks->caption(), $payment->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $payment->uploads->caption(), $payment->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->operator->caption(), $payment->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($payment_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payment->datetime->caption(), $payment->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpaymentedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpaymentedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpaymentedit.lists["x_type"] = <?php echo $payment_edit->type->Lookup->toClientList() ?>;
fpaymentedit.lists["x_type"].options = <?php echo JsonEncode($payment_edit->type->options(FALSE, TRUE)) ?>;
fpaymentedit.lists["x_from_account"] = <?php echo $payment_edit->from_account->Lookup->toClientList() ?>;
fpaymentedit.lists["x_from_account"].options = <?php echo JsonEncode($payment_edit->from_account->lookupOptions()) ?>;
fpaymentedit.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpaymentedit.lists["x_to_account"] = <?php echo $payment_edit->to_account->Lookup->toClientList() ?>;
fpaymentedit.lists["x_to_account"].options = <?php echo JsonEncode($payment_edit->to_account->lookupOptions()) ?>;
fpaymentedit.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_edit->showPageHeader(); ?>
<?php
$payment_edit->showMessage();
?>
<form name="fpaymentedit" id="fpaymentedit" class="<?php echo $payment_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$payment_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($payment->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_payment_id" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->id->caption() ?><?php echo ($payment->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->id->cellAttributes() ?>>
<span id="el_payment_id">
<span<?php echo $payment->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($payment->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="payment" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($payment->id->CurrentValue) ?>">
<?php echo $payment->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_payment_type" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->type->caption() ?><?php echo ($payment->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->type->cellAttributes() ?>>
<span id="el_payment_type">
<?php $payment->type->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$payment->type->EditAttrs["onclick"]; ?>
<div id="tp_x_type" class="ew-template"><input type="radio" class="form-check-input" data-table="payment" data-field="x_type" data-value-separator="<?php echo $payment->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="{value}"<?php echo $payment->type->editAttributes() ?>></div>
<div id="dsl_x_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payment->type->radioButtonListHtml(FALSE, "x_type") ?>
</div></div>
</span>
<?php echo $payment->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label id="elh_payment_from_account" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->from_account->caption() ?><?php echo ($payment->from_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->from_account->cellAttributes() ?>>
<span id="el_payment_from_account">
<?php
$wrkonchange = "" . trim(@$payment->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($payment->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($payment->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment->from_account->getPlaceHolder()) ?>"<?php echo $payment->from_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment->from_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_from_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($payment->from_account->ReadOnly || $payment->from_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment" data-field="x_from_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($payment->from_account->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpaymentedit.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $payment->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
<?php echo $payment->from_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label id="elh_payment_to_account" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->to_account->caption() ?><?php echo ($payment->to_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->to_account->cellAttributes() ?>>
<span id="el_payment_to_account">
<?php
$wrkonchange = "" . trim(@$payment->to_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment->to_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_to_account" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_to_account" id="sv_x_to_account" value="<?php echo RemoveHtml($payment->to_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($payment->to_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment->to_account->getPlaceHolder()) ?>"<?php echo $payment->to_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment->to_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_to_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($payment->to_account->ReadOnly || $payment->to_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment" data-field="x_to_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment->to_account->displayValueSeparatorAttribute() ?>" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($payment->to_account->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpaymentedit.createAutoSuggest({"id":"x_to_account","forceSelect":true});
</script>
<?php echo $payment->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
<?php echo $payment->to_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_payment_reference" for="x_reference" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->reference->caption() ?><?php echo ($payment->reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->reference->cellAttributes() ?>>
<span id="el_payment_reference">
<input type="text" data-table="payment" data-field="x_reference" name="x_reference" id="x_reference" size="30" placeholder="<?php echo HtmlEncode($payment->reference->getPlaceHolder()) ?>" value="<?php echo $payment->reference->EditValue ?>"<?php echo $payment->reference->editAttributes() ?>>
</span>
<?php echo $payment->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_payment_amount" for="x_amount" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->amount->caption() ?><?php echo ($payment->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->amount->cellAttributes() ?>>
<span id="el_payment_amount">
<input type="text" data-table="payment" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($payment->amount->getPlaceHolder()) ?>" value="<?php echo $payment->amount->EditValue ?>"<?php echo $payment->amount->editAttributes() ?>>
</span>
<?php echo $payment->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_payment_dated" for="x_dated" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->dated->caption() ?><?php echo ($payment->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->dated->cellAttributes() ?>>
<span id="el_payment_dated">
<input type="text" data-table="payment" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($payment->dated->getPlaceHolder()) ?>" value="<?php echo $payment->dated->EditValue ?>"<?php echo $payment->dated->editAttributes() ?>>
<?php if (!$payment->dated->ReadOnly && !$payment->dated->Disabled && !isset($payment->dated->EditAttrs["readonly"]) && !isset($payment->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpaymentedit", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $payment->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_payment_remarks" for="x_remarks" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->remarks->caption() ?><?php echo ($payment->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->remarks->cellAttributes() ?>>
<span id="el_payment_remarks">
<input type="text" data-table="payment" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($payment->remarks->getPlaceHolder()) ?>" value="<?php echo $payment->remarks->EditValue ?>"<?php echo $payment->remarks->editAttributes() ?>>
</span>
<?php echo $payment->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payment->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_payment_uploads" class="<?php echo $payment_edit->LeftColumnClass ?>"><?php echo $payment->uploads->caption() ?><?php echo ($payment->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payment_edit->RightColumnClass ?>"><div<?php echo $payment->uploads->cellAttributes() ?>>
<span id="el_payment_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $payment->uploads->title() ? $payment->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($payment->uploads->ReadOnly || $payment->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="payment" data-field="x_uploads" name="x_uploads" id="x_uploads"<?php echo $payment->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $payment->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="255">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $payment->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $payment->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $payment->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payment_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_edit->terminate();
?>