<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_list = new payment_list();

// Run the page
$payment_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpaymentlist = currentForm = new ew.Form("fpaymentlist", "list");
fpaymentlist.formKeyCountName = '<?php echo $payment_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpaymentlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpaymentlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpaymentlist.lists["x_type"] = <?php echo $payment_list->type->Lookup->toClientList() ?>;
fpaymentlist.lists["x_type"].options = <?php echo JsonEncode($payment_list->type->options(FALSE, TRUE)) ?>;
fpaymentlist.lists["x_from_account"] = <?php echo $payment_list->from_account->Lookup->toClientList() ?>;
fpaymentlist.lists["x_from_account"].options = <?php echo JsonEncode($payment_list->from_account->lookupOptions()) ?>;
fpaymentlist.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpaymentlist.lists["x_to_account"] = <?php echo $payment_list->to_account->Lookup->toClientList() ?>;
fpaymentlist.lists["x_to_account"].options = <?php echo JsonEncode($payment_list->to_account->lookupOptions()) ?>;
fpaymentlist.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fpaymentlistsrch = currentSearchForm = new ew.Form("fpaymentlistsrch");

// Filters
fpaymentlistsrch.filterList = <?php echo $payment_list->getFilterList() ?>;

// Init search panel as collapsed
fpaymentlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payment_list->TotalRecs > 0 && $payment_list->ExportOptions->visible()) { ?>
<?php $payment_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_list->ImportOptions->visible()) { ?>
<?php $payment_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payment_list->SearchOptions->visible()) { ?>
<?php $payment_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payment_list->FilterOptions->visible()) { ?>
<?php $payment_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payment_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payment->isExport() && !$payment->CurrentAction) { ?>
<form name="fpaymentlistsrch" id="fpaymentlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payment_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpaymentlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payment">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payment_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payment_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payment_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payment_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payment_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payment_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payment_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payment_list->showPageHeader(); ?>
<?php
$payment_list->showMessage();
?>
<?php if ($payment_list->TotalRecs > 0 || $payment->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payment_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payment">
<?php if (!$payment->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_list->Pager)) $payment_list->Pager = new PrevNextPager($payment_list->StartRec, $payment_list->DisplayRecs, $payment_list->TotalRecs, $payment_list->AutoHidePager) ?>
<?php if ($payment_list->Pager->RecordCount > 0 && $payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_list->pageUrl() ?>start=<?php echo $payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_list->pageUrl() ?>start=<?php echo $payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_list->pageUrl() ?>start=<?php echo $payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_list->pageUrl() ?>start=<?php echo $payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_list->TotalRecs > 0 && (!$payment_list->AutoHidePageSizeSelector || $payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpaymentlist" id="fpaymentlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment">
<div id="gmp_payment" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payment_list->TotalRecs > 0 || $payment->isGridEdit()) { ?>
<table id="tbl_paymentlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payment_list->RowType = ROWTYPE_HEADER;

// Render list options
$payment_list->renderListOptions();

// Render list options (header, left)
$payment_list->ListOptions->render("header", "left");
?>
<?php if ($payment->id->Visible) { // id ?>
	<?php if ($payment->sortUrl($payment->id) == "") { ?>
		<th data-name="id" class="<?php echo $payment->id->headerCellClass() ?>"><div id="elh_payment_id" class="payment_id"><div class="ew-table-header-caption"><?php echo $payment->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payment->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->id) ?>',2);"><div id="elh_payment_id" class="payment_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->type->Visible) { // type ?>
	<?php if ($payment->sortUrl($payment->type) == "") { ?>
		<th data-name="type" class="<?php echo $payment->type->headerCellClass() ?>"><div id="elh_payment_type" class="payment_type"><div class="ew-table-header-caption"><?php echo $payment->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $payment->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->type) ?>',2);"><div id="elh_payment_type" class="payment_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($payment->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->from_account->Visible) { // from_account ?>
	<?php if ($payment->sortUrl($payment->from_account) == "") { ?>
		<th data-name="from_account" class="<?php echo $payment->from_account->headerCellClass() ?>"><div id="elh_payment_from_account" class="payment_from_account"><div class="ew-table-header-caption"><?php echo $payment->from_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from_account" class="<?php echo $payment->from_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->from_account) ?>',2);"><div id="elh_payment_from_account" class="payment_from_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->from_account->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->from_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->from_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->to_account->Visible) { // to_account ?>
	<?php if ($payment->sortUrl($payment->to_account) == "") { ?>
		<th data-name="to_account" class="<?php echo $payment->to_account->headerCellClass() ?>"><div id="elh_payment_to_account" class="payment_to_account"><div class="ew-table-header-caption"><?php echo $payment->to_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_account" class="<?php echo $payment->to_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->to_account) ?>',2);"><div id="elh_payment_to_account" class="payment_to_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->to_account->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->to_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->to_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->reference->Visible) { // reference ?>
	<?php if ($payment->sortUrl($payment->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $payment->reference->headerCellClass() ?>"><div id="elh_payment_reference" class="payment_reference"><div class="ew-table-header-caption"><?php echo $payment->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $payment->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->reference) ?>',2);"><div id="elh_payment_reference" class="payment_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->reference->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->amount->Visible) { // amount ?>
	<?php if ($payment->sortUrl($payment->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $payment->amount->headerCellClass() ?>"><div id="elh_payment_amount" class="payment_amount"><div class="ew-table-header-caption"><?php echo $payment->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $payment->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->amount) ?>',2);"><div id="elh_payment_amount" class="payment_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->dated->Visible) { // dated ?>
	<?php if ($payment->sortUrl($payment->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $payment->dated->headerCellClass() ?>"><div id="elh_payment_dated" class="payment_dated"><div class="ew-table-header-caption"><?php echo $payment->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $payment->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->dated) ?>',2);"><div id="elh_payment_dated" class="payment_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->remarks->Visible) { // remarks ?>
	<?php if ($payment->sortUrl($payment->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $payment->remarks->headerCellClass() ?>"><div id="elh_payment_remarks" class="payment_remarks"><div class="ew-table-header-caption"><?php echo $payment->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $payment->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->remarks) ?>',2);"><div id="elh_payment_remarks" class="payment_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->uploads->Visible) { // uploads ?>
	<?php if ($payment->sortUrl($payment->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $payment->uploads->headerCellClass() ?>"><div id="elh_payment_uploads" class="payment_uploads"><div class="ew-table-header-caption"><?php echo $payment->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $payment->uploads->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->uploads) ?>',2);"><div id="elh_payment_uploads" class="payment_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->operator->Visible) { // operator ?>
	<?php if ($payment->sortUrl($payment->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $payment->operator->headerCellClass() ?>"><div id="elh_payment_operator" class="payment_operator"><div class="ew-table-header-caption"><?php echo $payment->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $payment->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->operator) ?>',2);"><div id="elh_payment_operator" class="payment_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->operator->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payment->datetime->Visible) { // datetime ?>
	<?php if ($payment->sortUrl($payment->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payment->datetime->headerCellClass() ?>"><div id="elh_payment_datetime" class="payment_datetime"><div class="ew-table-header-caption"><?php echo $payment->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payment->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payment->SortUrl($payment->datetime) ?>',2);"><div id="elh_payment_datetime" class="payment_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payment->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payment->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payment->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payment_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payment->ExportAll && $payment->isExport()) {
	$payment_list->StopRec = $payment_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payment_list->TotalRecs > $payment_list->StartRec + $payment_list->DisplayRecs - 1)
		$payment_list->StopRec = $payment_list->StartRec + $payment_list->DisplayRecs - 1;
	else
		$payment_list->StopRec = $payment_list->TotalRecs;
}
$payment_list->RecCnt = $payment_list->StartRec - 1;
if ($payment_list->Recordset && !$payment_list->Recordset->EOF) {
	$payment_list->Recordset->moveFirst();
	$selectLimit = $payment_list->UseSelectLimit;
	if (!$selectLimit && $payment_list->StartRec > 1)
		$payment_list->Recordset->move($payment_list->StartRec - 1);
} elseif (!$payment->AllowAddDeleteRow && $payment_list->StopRec == 0) {
	$payment_list->StopRec = $payment->GridAddRowCount;
}

// Initialize aggregate
$payment->RowType = ROWTYPE_AGGREGATEINIT;
$payment->resetAttributes();
$payment_list->renderRow();
while ($payment_list->RecCnt < $payment_list->StopRec) {
	$payment_list->RecCnt++;
	if ($payment_list->RecCnt >= $payment_list->StartRec) {
		$payment_list->RowCnt++;

		// Set up key count
		$payment_list->KeyCount = $payment_list->RowIndex;

		// Init row class and style
		$payment->resetAttributes();
		$payment->CssClass = "";
		if ($payment->isGridAdd()) {
		} else {
			$payment_list->loadRowValues($payment_list->Recordset); // Load row values
		}
		$payment->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payment->RowAttrs = array_merge($payment->RowAttrs, array('data-rowindex'=>$payment_list->RowCnt, 'id'=>'r' . $payment_list->RowCnt . '_payment', 'data-rowtype'=>$payment->RowType));

		// Render row
		$payment_list->renderRow();

		// Render list options
		$payment_list->renderListOptions();
?>
	<tr<?php echo $payment->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payment_list->ListOptions->render("body", "left", $payment_list->RowCnt);
?>
	<?php if ($payment->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payment->id->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_id" class="payment_id">
<span<?php echo $payment->id->viewAttributes() ?>>
<?php echo $payment->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->type->Visible) { // type ?>
		<td data-name="type"<?php echo $payment->type->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_type" class="payment_type">
<span<?php echo $payment->type->viewAttributes() ?>>
<?php echo $payment->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->from_account->Visible) { // from_account ?>
		<td data-name="from_account"<?php echo $payment->from_account->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_from_account" class="payment_from_account">
<span<?php echo $payment->from_account->viewAttributes() ?>>
<?php echo $payment->from_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->to_account->Visible) { // to_account ?>
		<td data-name="to_account"<?php echo $payment->to_account->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_to_account" class="payment_to_account">
<span<?php echo $payment->to_account->viewAttributes() ?>>
<?php echo $payment->to_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $payment->reference->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_reference" class="payment_reference">
<span<?php echo $payment->reference->viewAttributes() ?>>
<?php echo $payment->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $payment->amount->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_amount" class="payment_amount">
<span<?php echo $payment->amount->viewAttributes() ?>>
<?php echo $payment->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $payment->dated->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_dated" class="payment_dated">
<span<?php echo $payment->dated->viewAttributes() ?>>
<?php echo $payment->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $payment->remarks->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_remarks" class="payment_remarks">
<span<?php echo $payment->remarks->viewAttributes() ?>>
<?php echo $payment->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $payment->uploads->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_uploads" class="payment_uploads">
<span>
<?php echo GetFileViewTag($payment->uploads, $payment->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $payment->operator->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_operator" class="payment_operator">
<span<?php echo $payment->operator->viewAttributes() ?>>
<?php echo $payment->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payment->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payment->datetime->cellAttributes() ?>>
<span id="el<?php echo $payment_list->RowCnt ?>_payment_datetime" class="payment_datetime">
<span<?php echo $payment->datetime->viewAttributes() ?>>
<?php echo $payment->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payment_list->ListOptions->render("body", "right", $payment_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payment->isGridAdd())
		$payment_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payment->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payment_list->Recordset)
	$payment_list->Recordset->Close();
?>
<?php if (!$payment->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payment->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payment_list->Pager)) $payment_list->Pager = new PrevNextPager($payment_list->StartRec, $payment_list->DisplayRecs, $payment_list->TotalRecs, $payment_list->AutoHidePager) ?>
<?php if ($payment_list->Pager->RecordCount > 0 && $payment_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payment_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payment_list->pageUrl() ?>start=<?php echo $payment_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payment_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payment_list->pageUrl() ?>start=<?php echo $payment_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payment_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payment_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payment_list->pageUrl() ?>start=<?php echo $payment_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payment_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payment_list->pageUrl() ?>start=<?php echo $payment_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payment_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payment_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payment_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payment_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payment_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payment_list->TotalRecs > 0 && (!$payment_list->AutoHidePageSizeSelector || $payment_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payment">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payment_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payment_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payment_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payment_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payment_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payment->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payment_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payment_list->TotalRecs == 0 && !$payment->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payment_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payment_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$payment->isExport()) { ?>
<script>
ew.scrollableTable("gmp_payment", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_list->terminate();
?>