<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_search = new payment_search();

// Run the page
$payment_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($payment_search->IsModal) { ?>
var fpaymentsearch = currentAdvancedSearchForm = new ew.Form("fpaymentsearch", "search");
<?php } else { ?>
var fpaymentsearch = currentForm = new ew.Form("fpaymentsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpaymentsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpaymentsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpaymentsearch.lists["x_type"] = <?php echo $payment_search->type->Lookup->toClientList() ?>;
fpaymentsearch.lists["x_type"].options = <?php echo JsonEncode($payment_search->type->options(FALSE, TRUE)) ?>;
fpaymentsearch.lists["x_from_account"] = <?php echo $payment_search->from_account->Lookup->toClientList() ?>;
fpaymentsearch.lists["x_from_account"].options = <?php echo JsonEncode($payment_search->from_account->lookupOptions()) ?>;
fpaymentsearch.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpaymentsearch.lists["x_to_account"] = <?php echo $payment_search->to_account->Lookup->toClientList() ?>;
fpaymentsearch.lists["x_to_account"].options = <?php echo JsonEncode($payment_search->to_account->lookupOptions()) ?>;
fpaymentsearch.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fpaymentsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment->from_account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_to_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment->to_account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($payment->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $payment_search->showPageHeader(); ?>
<?php
$payment_search->showMessage();
?>
<form name="fpaymentsearch" id="fpaymentsearch" class="<?php echo $payment_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$payment_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($payment->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_id"><?php echo $payment->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->id->cellAttributes() ?>>
			<span id="el_payment_id">
<input type="text" data-table="payment" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($payment->id->getPlaceHolder()) ?>" value="<?php echo $payment->id->EditValue ?>"<?php echo $payment->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_type"><?php echo $payment->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->type->cellAttributes() ?>>
			<span id="el_payment_type">
<?php $payment->type->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$payment->type->EditAttrs["onclick"]; ?>
<div id="tp_x_type" class="ew-template"><input type="radio" class="form-check-input" data-table="payment" data-field="x_type" data-value-separator="<?php echo $payment->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="{value}"<?php echo $payment->type->editAttributes() ?>></div>
<div id="dsl_x_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payment->type->radioButtonListHtml(FALSE, "x_type") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_from_account"><?php echo $payment->from_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_account" id="z_from_account" value="="></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->from_account->cellAttributes() ?>>
			<span id="el_payment_from_account">
<?php
$wrkonchange = "" . trim(@$payment->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($payment->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($payment->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment->from_account->getPlaceHolder()) ?>"<?php echo $payment->from_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment->from_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_from_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($payment->from_account->ReadOnly || $payment->from_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment" data-field="x_from_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($payment->from_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpaymentsearch.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $payment->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_to_account"><?php echo $payment->to_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_account" id="z_to_account" value="="></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->to_account->cellAttributes() ?>>
			<span id="el_payment_to_account">
<?php
$wrkonchange = "" . trim(@$payment->to_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$payment->to_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_to_account" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_to_account" id="sv_x_to_account" value="<?php echo RemoveHtml($payment->to_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($payment->to_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($payment->to_account->getPlaceHolder()) ?>"<?php echo $payment->to_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($payment->to_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_to_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($payment->to_account->ReadOnly || $payment->to_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="payment" data-field="x_to_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $payment->to_account->displayValueSeparatorAttribute() ?>" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($payment->to_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpaymentsearch.createAutoSuggest({"id":"x_to_account","forceSelect":true});
</script>
<?php echo $payment->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_reference"><?php echo $payment->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reference" id="z_reference" value="="></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->reference->cellAttributes() ?>>
			<span id="el_payment_reference">
<input type="text" data-table="payment" data-field="x_reference" name="x_reference" id="x_reference" size="30" placeholder="<?php echo HtmlEncode($payment->reference->getPlaceHolder()) ?>" value="<?php echo $payment->reference->EditValue ?>"<?php echo $payment->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_amount"><?php echo $payment->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->amount->cellAttributes() ?>>
			<span id="el_payment_amount">
<input type="text" data-table="payment" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($payment->amount->getPlaceHolder()) ?>" value="<?php echo $payment->amount->EditValue ?>"<?php echo $payment->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_dated"><?php echo $payment->dated->caption() ?></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($payment->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($payment->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($payment->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($payment->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($payment->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($payment->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($payment->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_payment_dated">
<input type="text" data-table="payment" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($payment->dated->getPlaceHolder()) ?>" value="<?php echo $payment->dated->EditValue ?>"<?php echo $payment->dated->editAttributes() ?>>
<?php if (!$payment->dated->ReadOnly && !$payment->dated->Disabled && !isset($payment->dated->EditAttrs["readonly"]) && !isset($payment->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpaymentsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_payment_dated" class="btw1_dated d-none">
<input type="text" data-table="payment" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($payment->dated->getPlaceHolder()) ?>" value="<?php echo $payment->dated->EditValue2 ?>"<?php echo $payment->dated->editAttributes() ?>>
<?php if (!$payment->dated->ReadOnly && !$payment->dated->Disabled && !isset($payment->dated->EditAttrs["readonly"]) && !isset($payment->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpaymentsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_remarks"><?php echo $payment->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->remarks->cellAttributes() ?>>
			<span id="el_payment_remarks">
<input type="text" data-table="payment" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($payment->remarks->getPlaceHolder()) ?>" value="<?php echo $payment->remarks->EditValue ?>"<?php echo $payment->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_uploads"><?php echo $payment->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->uploads->cellAttributes() ?>>
			<span id="el_payment_uploads">
<input type="text" data-table="payment" data-field="x_uploads" name="x_uploads" id="x_uploads" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($payment->uploads->getPlaceHolder()) ?>" value="<?php echo $payment->uploads->EditValue ?>"<?php echo $payment->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_operator"><?php echo $payment->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->operator->cellAttributes() ?>>
			<span id="el_payment_operator">
<input type="text" data-table="payment" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($payment->operator->getPlaceHolder()) ?>" value="<?php echo $payment->operator->EditValue ?>"<?php echo $payment->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($payment->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $payment_search->LeftColumnClass ?>"><span id="elh_payment_datetime"><?php echo $payment->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $payment_search->RightColumnClass ?>"><div<?php echo $payment->datetime->cellAttributes() ?>>
			<span id="el_payment_datetime">
<input type="text" data-table="payment" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($payment->datetime->getPlaceHolder()) ?>" value="<?php echo $payment->datetime->EditValue ?>"<?php echo $payment->datetime->editAttributes() ?>>
<?php if (!$payment->datetime->ReadOnly && !$payment->datetime->Disabled && !isset($payment->datetime->EditAttrs["readonly"]) && !isset($payment->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpaymentsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$payment_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payment_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payment_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$payment_search->terminate();
?>