<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payment_view = new payment_view();

// Run the page
$payment_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payment_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payment->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpaymentview = currentForm = new ew.Form("fpaymentview", "view");

// Form_CustomValidate event
fpaymentview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpaymentview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpaymentview.lists["x_type"] = <?php echo $payment_view->type->Lookup->toClientList() ?>;
fpaymentview.lists["x_type"].options = <?php echo JsonEncode($payment_view->type->options(FALSE, TRUE)) ?>;
fpaymentview.lists["x_from_account"] = <?php echo $payment_view->from_account->Lookup->toClientList() ?>;
fpaymentview.lists["x_from_account"].options = <?php echo JsonEncode($payment_view->from_account->lookupOptions()) ?>;
fpaymentview.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpaymentview.lists["x_to_account"] = <?php echo $payment_view->to_account->Lookup->toClientList() ?>;
fpaymentview.lists["x_to_account"].options = <?php echo JsonEncode($payment_view->to_account->lookupOptions()) ?>;
fpaymentview.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payment->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $payment_view->ExportOptions->render("body") ?>
<?php $payment_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $payment_view->showPageHeader(); ?>
<?php
$payment_view->showMessage();
?>
<form name="fpaymentview" id="fpaymentview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payment_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payment_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payment">
<input type="hidden" name="modal" value="<?php echo (int)$payment_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($payment->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_id"><?php echo $payment->id->caption() ?></span></td>
		<td data-name="id"<?php echo $payment->id->cellAttributes() ?>>
<span id="el_payment_id">
<span<?php echo $payment->id->viewAttributes() ?>>
<?php echo $payment->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_type"><?php echo $payment->type->caption() ?></span></td>
		<td data-name="type"<?php echo $payment->type->cellAttributes() ?>>
<span id="el_payment_type">
<span<?php echo $payment->type->viewAttributes() ?>>
<?php echo $payment->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->from_account->Visible) { // from_account ?>
	<tr id="r_from_account">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_from_account"><?php echo $payment->from_account->caption() ?></span></td>
		<td data-name="from_account"<?php echo $payment->from_account->cellAttributes() ?>>
<span id="el_payment_from_account">
<span<?php echo $payment->from_account->viewAttributes() ?>>
<?php echo $payment->from_account->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->to_account->Visible) { // to_account ?>
	<tr id="r_to_account">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_to_account"><?php echo $payment->to_account->caption() ?></span></td>
		<td data-name="to_account"<?php echo $payment->to_account->cellAttributes() ?>>
<span id="el_payment_to_account">
<span<?php echo $payment->to_account->viewAttributes() ?>>
<?php echo $payment->to_account->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_amount"><?php echo $payment->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $payment->amount->cellAttributes() ?>>
<span id="el_payment_amount">
<span<?php echo $payment->amount->viewAttributes() ?>>
<?php echo $payment->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->dated->Visible) { // dated ?>
	<tr id="r_dated">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_dated"><?php echo $payment->dated->caption() ?></span></td>
		<td data-name="dated"<?php echo $payment->dated->cellAttributes() ?>>
<span id="el_payment_dated">
<span<?php echo $payment->dated->viewAttributes() ?>>
<?php echo $payment->dated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_remarks"><?php echo $payment->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $payment->remarks->cellAttributes() ?>>
<span id="el_payment_remarks">
<span<?php echo $payment->remarks->viewAttributes() ?>>
<?php echo $payment->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_uploads"><?php echo $payment->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $payment->uploads->cellAttributes() ?>>
<span id="el_payment_uploads">
<span>
<?php echo GetFileViewTag($payment->uploads, $payment->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_operator"><?php echo $payment->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $payment->operator->cellAttributes() ?>>
<span id="el_payment_operator">
<span<?php echo $payment->operator->viewAttributes() ?>>
<?php echo $payment->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payment->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $payment_view->TableLeftColumnClass ?>"><span id="elh_payment_datetime"><?php echo $payment->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $payment->datetime->cellAttributes() ?>>
<span id="el_payment_datetime">
<span<?php echo $payment->datetime->viewAttributes() ?>>
<?php echo $payment->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$payment_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payment->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payment_view->terminate();
?>