<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_details_list = new payroll_details_list();

// Run the page
$payroll_details_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_details_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payroll_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayroll_detailslist = currentForm = new ew.Form("fpayroll_detailslist", "list");
fpayroll_detailslist.formKeyCountName = '<?php echo $payroll_details_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayroll_detailslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayroll_detailslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fpayroll_detailslistsrch = currentSearchForm = new ew.Form("fpayroll_detailslistsrch");

// Filters
fpayroll_detailslistsrch.filterList = <?php echo $payroll_details_list->getFilterList() ?>;

// Init search panel as collapsed
fpayroll_detailslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payroll_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payroll_details_list->TotalRecs > 0 && $payroll_details_list->ExportOptions->visible()) { ?>
<?php $payroll_details_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_details_list->ImportOptions->visible()) { ?>
<?php $payroll_details_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_details_list->SearchOptions->visible()) { ?>
<?php $payroll_details_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_details_list->FilterOptions->visible()) { ?>
<?php $payroll_details_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payroll_details_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payroll_details->isExport() && !$payroll_details->CurrentAction) { ?>
<form name="fpayroll_detailslistsrch" id="fpayroll_detailslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payroll_details_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayroll_detailslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payroll_details">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payroll_details_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payroll_details_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payroll_details_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payroll_details_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payroll_details_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payroll_details_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payroll_details_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payroll_details_list->showPageHeader(); ?>
<?php
$payroll_details_list->showMessage();
?>
<?php if ($payroll_details_list->TotalRecs > 0 || $payroll_details->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payroll_details_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payroll_details">
<?php if (!$payroll_details->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payroll_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payroll_details_list->Pager)) $payroll_details_list->Pager = new PrevNextPager($payroll_details_list->StartRec, $payroll_details_list->DisplayRecs, $payroll_details_list->TotalRecs, $payroll_details_list->AutoHidePager) ?>
<?php if ($payroll_details_list->Pager->RecordCount > 0 && $payroll_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payroll_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payroll_details_list->pageUrl() ?>start=<?php echo $payroll_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payroll_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payroll_details_list->pageUrl() ?>start=<?php echo $payroll_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payroll_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payroll_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payroll_details_list->pageUrl() ?>start=<?php echo $payroll_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payroll_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payroll_details_list->pageUrl() ?>start=<?php echo $payroll_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payroll_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payroll_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payroll_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payroll_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payroll_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payroll_details_list->TotalRecs > 0 && (!$payroll_details_list->AutoHidePageSizeSelector || $payroll_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payroll_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payroll_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payroll_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payroll_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payroll_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payroll_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payroll_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payroll_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayroll_detailslist" id="fpayroll_detailslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payroll_details_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payroll_details_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll_details">
<div id="gmp_payroll_details" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payroll_details_list->TotalRecs > 0 || $payroll_details->isGridEdit()) { ?>
<table id="tbl_payroll_detailslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payroll_details_list->RowType = ROWTYPE_HEADER;

// Render list options
$payroll_details_list->renderListOptions();

// Render list options (header, left)
$payroll_details_list->ListOptions->render("header", "left");
?>
<?php if ($payroll_details->id->Visible) { // id ?>
	<?php if ($payroll_details->sortUrl($payroll_details->id) == "") { ?>
		<th data-name="id" class="<?php echo $payroll_details->id->headerCellClass() ?>"><div id="elh_payroll_details_id" class="payroll_details_id"><div class="ew-table-header-caption"><?php echo $payroll_details->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payroll_details->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->id) ?>',2);"><div id="elh_payroll_details_id" class="payroll_details_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->employee_id->Visible) { // employee_id ?>
	<?php if ($payroll_details->sortUrl($payroll_details->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $payroll_details->employee_id->headerCellClass() ?>"><div id="elh_payroll_details_employee_id" class="payroll_details_employee_id"><div class="ew-table-header-caption"><?php echo $payroll_details->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $payroll_details->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->employee_id) ?>',2);"><div id="elh_payroll_details_employee_id" class="payroll_details_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->month->Visible) { // month ?>
	<?php if ($payroll_details->sortUrl($payroll_details->month) == "") { ?>
		<th data-name="month" class="<?php echo $payroll_details->month->headerCellClass() ?>"><div id="elh_payroll_details_month" class="payroll_details_month"><div class="ew-table-header-caption"><?php echo $payroll_details->month->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month" class="<?php echo $payroll_details->month->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->month) ?>',2);"><div id="elh_payroll_details_month" class="payroll_details_month">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->month->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->month->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->month->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->default_min->Visible) { // default_min ?>
	<?php if ($payroll_details->sortUrl($payroll_details->default_min) == "") { ?>
		<th data-name="default_min" class="<?php echo $payroll_details->default_min->headerCellClass() ?>"><div id="elh_payroll_details_default_min" class="payroll_details_default_min"><div class="ew-table-header-caption"><?php echo $payroll_details->default_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="default_min" class="<?php echo $payroll_details->default_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->default_min) ?>',2);"><div id="elh_payroll_details_default_min" class="payroll_details_default_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->default_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->default_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->default_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->month_min->Visible) { // month_min ?>
	<?php if ($payroll_details->sortUrl($payroll_details->month_min) == "") { ?>
		<th data-name="month_min" class="<?php echo $payroll_details->month_min->headerCellClass() ?>"><div id="elh_payroll_details_month_min" class="payroll_details_month_min"><div class="ew-table-header-caption"><?php echo $payroll_details->month_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month_min" class="<?php echo $payroll_details->month_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->month_min) ?>',2);"><div id="elh_payroll_details_month_min" class="payroll_details_month_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->month_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->month_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->month_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->offsets_benifit_min->Visible) { // offsets_benifit_min ?>
	<?php if ($payroll_details->sortUrl($payroll_details->offsets_benifit_min) == "") { ?>
		<th data-name="offsets_benifit_min" class="<?php echo $payroll_details->offsets_benifit_min->headerCellClass() ?>"><div id="elh_payroll_details_offsets_benifit_min" class="payroll_details_offsets_benifit_min"><div class="ew-table-header-caption"><?php echo $payroll_details->offsets_benifit_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="offsets_benifit_min" class="<?php echo $payroll_details->offsets_benifit_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->offsets_benifit_min) ?>',2);"><div id="elh_payroll_details_offsets_benifit_min" class="payroll_details_offsets_benifit_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->offsets_benifit_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->offsets_benifit_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->offsets_benifit_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->office_holidays_min->Visible) { // office_holidays_min ?>
	<?php if ($payroll_details->sortUrl($payroll_details->office_holidays_min) == "") { ?>
		<th data-name="office_holidays_min" class="<?php echo $payroll_details->office_holidays_min->headerCellClass() ?>"><div id="elh_payroll_details_office_holidays_min" class="payroll_details_office_holidays_min"><div class="ew-table-header-caption"><?php echo $payroll_details->office_holidays_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="office_holidays_min" class="<?php echo $payroll_details->office_holidays_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->office_holidays_min) ?>',2);"><div id="elh_payroll_details_office_holidays_min" class="payroll_details_office_holidays_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->office_holidays_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->office_holidays_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->office_holidays_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->paid_leave_adj_min->Visible) { // paid_leave_adj_min ?>
	<?php if ($payroll_details->sortUrl($payroll_details->paid_leave_adj_min) == "") { ?>
		<th data-name="paid_leave_adj_min" class="<?php echo $payroll_details->paid_leave_adj_min->headerCellClass() ?>"><div id="elh_payroll_details_paid_leave_adj_min" class="payroll_details_paid_leave_adj_min"><div class="ew-table-header-caption"><?php echo $payroll_details->paid_leave_adj_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="paid_leave_adj_min" class="<?php echo $payroll_details->paid_leave_adj_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->paid_leave_adj_min) ?>',2);"><div id="elh_payroll_details_paid_leave_adj_min" class="payroll_details_paid_leave_adj_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->paid_leave_adj_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->paid_leave_adj_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->paid_leave_adj_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->overtime->Visible) { // overtime ?>
	<?php if ($payroll_details->sortUrl($payroll_details->overtime) == "") { ?>
		<th data-name="overtime" class="<?php echo $payroll_details->overtime->headerCellClass() ?>"><div id="elh_payroll_details_overtime" class="payroll_details_overtime"><div class="ew-table-header-caption"><?php echo $payroll_details->overtime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="overtime" class="<?php echo $payroll_details->overtime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->overtime) ?>',2);"><div id="elh_payroll_details_overtime" class="payroll_details_overtime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->overtime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->overtime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->overtime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->total_min->Visible) { // total_min ?>
	<?php if ($payroll_details->sortUrl($payroll_details->total_min) == "") { ?>
		<th data-name="total_min" class="<?php echo $payroll_details->total_min->headerCellClass() ?>"><div id="elh_payroll_details_total_min" class="payroll_details_total_min"><div class="ew-table-header-caption"><?php echo $payroll_details->total_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_min" class="<?php echo $payroll_details->total_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->total_min) ?>',2);"><div id="elh_payroll_details_total_min" class="payroll_details_total_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->total_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->total_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->total_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->remarks->Visible) { // remarks ?>
	<?php if ($payroll_details->sortUrl($payroll_details->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $payroll_details->remarks->headerCellClass() ?>"><div id="elh_payroll_details_remarks" class="payroll_details_remarks"><div class="ew-table-header-caption"><?php echo $payroll_details->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $payroll_details->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->remarks) ?>',2);"><div id="elh_payroll_details_remarks" class="payroll_details_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->base_salary->Visible) { // base_salary ?>
	<?php if ($payroll_details->sortUrl($payroll_details->base_salary) == "") { ?>
		<th data-name="base_salary" class="<?php echo $payroll_details->base_salary->headerCellClass() ?>"><div id="elh_payroll_details_base_salary" class="payroll_details_base_salary"><div class="ew-table-header-caption"><?php echo $payroll_details->base_salary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="base_salary" class="<?php echo $payroll_details->base_salary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->base_salary) ?>',2);"><div id="elh_payroll_details_base_salary" class="payroll_details_base_salary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->base_salary->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->base_salary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->base_salary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->additional_benefits->Visible) { // additional_benefits ?>
	<?php if ($payroll_details->sortUrl($payroll_details->additional_benefits) == "") { ?>
		<th data-name="additional_benefits" class="<?php echo $payroll_details->additional_benefits->headerCellClass() ?>"><div id="elh_payroll_details_additional_benefits" class="payroll_details_additional_benefits"><div class="ew-table-header-caption"><?php echo $payroll_details->additional_benefits->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="additional_benefits" class="<?php echo $payroll_details->additional_benefits->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->additional_benefits) ?>',2);"><div id="elh_payroll_details_additional_benefits" class="payroll_details_additional_benefits">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->additional_benefits->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->additional_benefits->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->additional_benefits->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->employee_pf->Visible) { // employee_pf ?>
	<?php if ($payroll_details->sortUrl($payroll_details->employee_pf) == "") { ?>
		<th data-name="employee_pf" class="<?php echo $payroll_details->employee_pf->headerCellClass() ?>"><div id="elh_payroll_details_employee_pf" class="payroll_details_employee_pf"><div class="ew-table-header-caption"><?php echo $payroll_details->employee_pf->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_pf" class="<?php echo $payroll_details->employee_pf->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->employee_pf) ?>',2);"><div id="elh_payroll_details_employee_pf" class="payroll_details_employee_pf">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->employee_pf->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->employee_pf->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->employee_pf->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->operator->Visible) { // operator ?>
	<?php if ($payroll_details->sortUrl($payroll_details->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $payroll_details->operator->headerCellClass() ?>"><div id="elh_payroll_details_operator" class="payroll_details_operator"><div class="ew-table-header-caption"><?php echo $payroll_details->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $payroll_details->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->operator) ?>',2);"><div id="elh_payroll_details_operator" class="payroll_details_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->datetime->Visible) { // datetime ?>
	<?php if ($payroll_details->sortUrl($payroll_details->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payroll_details->datetime->headerCellClass() ?>"><div id="elh_payroll_details_datetime" class="payroll_details_datetime"><div class="ew-table-header-caption"><?php echo $payroll_details->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payroll_details->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->datetime) ?>',2);"><div id="elh_payroll_details_datetime" class="payroll_details_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->weekly_off_min->Visible) { // weekly_off_min ?>
	<?php if ($payroll_details->sortUrl($payroll_details->weekly_off_min) == "") { ?>
		<th data-name="weekly_off_min" class="<?php echo $payroll_details->weekly_off_min->headerCellClass() ?>"><div id="elh_payroll_details_weekly_off_min" class="payroll_details_weekly_off_min"><div class="ew-table-header-caption"><?php echo $payroll_details->weekly_off_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weekly_off_min" class="<?php echo $payroll_details->weekly_off_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->weekly_off_min) ?>',2);"><div id="elh_payroll_details_weekly_off_min" class="payroll_details_weekly_off_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->weekly_off_min->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->weekly_off_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->weekly_off_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->employee_am_id->Visible) { // employee_am_id ?>
	<?php if ($payroll_details->sortUrl($payroll_details->employee_am_id) == "") { ?>
		<th data-name="employee_am_id" class="<?php echo $payroll_details->employee_am_id->headerCellClass() ?>"><div id="elh_payroll_details_employee_am_id" class="payroll_details_employee_am_id"><div class="ew-table-header-caption"><?php echo $payroll_details->employee_am_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_am_id" class="<?php echo $payroll_details->employee_am_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->employee_am_id) ?>',2);"><div id="elh_payroll_details_employee_am_id" class="payroll_details_employee_am_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->employee_am_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->employee_am_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->employee_am_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->salary_earned->Visible) { // salary_earned ?>
	<?php if ($payroll_details->sortUrl($payroll_details->salary_earned) == "") { ?>
		<th data-name="salary_earned" class="<?php echo $payroll_details->salary_earned->headerCellClass() ?>"><div id="elh_payroll_details_salary_earned" class="payroll_details_salary_earned"><div class="ew-table-header-caption"><?php echo $payroll_details->salary_earned->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="salary_earned" class="<?php echo $payroll_details->salary_earned->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->salary_earned) ?>',2);"><div id="elh_payroll_details_salary_earned" class="payroll_details_salary_earned">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->salary_earned->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->salary_earned->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->salary_earned->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_details->uid->Visible) { // uid ?>
	<?php if ($payroll_details->sortUrl($payroll_details->uid) == "") { ?>
		<th data-name="uid" class="<?php echo $payroll_details->uid->headerCellClass() ?>"><div id="elh_payroll_details_uid" class="payroll_details_uid"><div class="ew-table-header-caption"><?php echo $payroll_details->uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uid" class="<?php echo $payroll_details->uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_details->SortUrl($payroll_details->uid) ?>',2);"><div id="elh_payroll_details_uid" class="payroll_details_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_details->uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payroll_details->uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_details->uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payroll_details_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payroll_details->ExportAll && $payroll_details->isExport()) {
	$payroll_details_list->StopRec = $payroll_details_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payroll_details_list->TotalRecs > $payroll_details_list->StartRec + $payroll_details_list->DisplayRecs - 1)
		$payroll_details_list->StopRec = $payroll_details_list->StartRec + $payroll_details_list->DisplayRecs - 1;
	else
		$payroll_details_list->StopRec = $payroll_details_list->TotalRecs;
}
$payroll_details_list->RecCnt = $payroll_details_list->StartRec - 1;
if ($payroll_details_list->Recordset && !$payroll_details_list->Recordset->EOF) {
	$payroll_details_list->Recordset->moveFirst();
	$selectLimit = $payroll_details_list->UseSelectLimit;
	if (!$selectLimit && $payroll_details_list->StartRec > 1)
		$payroll_details_list->Recordset->move($payroll_details_list->StartRec - 1);
} elseif (!$payroll_details->AllowAddDeleteRow && $payroll_details_list->StopRec == 0) {
	$payroll_details_list->StopRec = $payroll_details->GridAddRowCount;
}

// Initialize aggregate
$payroll_details->RowType = ROWTYPE_AGGREGATEINIT;
$payroll_details->resetAttributes();
$payroll_details_list->renderRow();
while ($payroll_details_list->RecCnt < $payroll_details_list->StopRec) {
	$payroll_details_list->RecCnt++;
	if ($payroll_details_list->RecCnt >= $payroll_details_list->StartRec) {
		$payroll_details_list->RowCnt++;

		// Set up key count
		$payroll_details_list->KeyCount = $payroll_details_list->RowIndex;

		// Init row class and style
		$payroll_details->resetAttributes();
		$payroll_details->CssClass = "";
		if ($payroll_details->isGridAdd()) {
		} else {
			$payroll_details_list->loadRowValues($payroll_details_list->Recordset); // Load row values
		}
		$payroll_details->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payroll_details->RowAttrs = array_merge($payroll_details->RowAttrs, array('data-rowindex'=>$payroll_details_list->RowCnt, 'id'=>'r' . $payroll_details_list->RowCnt . '_payroll_details', 'data-rowtype'=>$payroll_details->RowType));

		// Render row
		$payroll_details_list->renderRow();

		// Render list options
		$payroll_details_list->renderListOptions();
?>
	<tr<?php echo $payroll_details->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payroll_details_list->ListOptions->render("body", "left", $payroll_details_list->RowCnt);
?>
	<?php if ($payroll_details->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payroll_details->id->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_id" class="payroll_details_id">
<span<?php echo $payroll_details->id->viewAttributes() ?>>
<?php echo $payroll_details->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $payroll_details->employee_id->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_employee_id" class="payroll_details_employee_id">
<span<?php echo $payroll_details->employee_id->viewAttributes() ?>>
<?php echo $payroll_details->employee_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->month->Visible) { // month ?>
		<td data-name="month"<?php echo $payroll_details->month->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_month" class="payroll_details_month">
<span<?php echo $payroll_details->month->viewAttributes() ?>>
<?php echo $payroll_details->month->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->default_min->Visible) { // default_min ?>
		<td data-name="default_min"<?php echo $payroll_details->default_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_default_min" class="payroll_details_default_min">
<span<?php echo $payroll_details->default_min->viewAttributes() ?>>
<?php echo $payroll_details->default_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->month_min->Visible) { // month_min ?>
		<td data-name="month_min"<?php echo $payroll_details->month_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_month_min" class="payroll_details_month_min">
<span<?php echo $payroll_details->month_min->viewAttributes() ?>>
<?php echo $payroll_details->month_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->offsets_benifit_min->Visible) { // offsets_benifit_min ?>
		<td data-name="offsets_benifit_min"<?php echo $payroll_details->offsets_benifit_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_offsets_benifit_min" class="payroll_details_offsets_benifit_min">
<span<?php echo $payroll_details->offsets_benifit_min->viewAttributes() ?>>
<?php echo $payroll_details->offsets_benifit_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->office_holidays_min->Visible) { // office_holidays_min ?>
		<td data-name="office_holidays_min"<?php echo $payroll_details->office_holidays_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_office_holidays_min" class="payroll_details_office_holidays_min">
<span<?php echo $payroll_details->office_holidays_min->viewAttributes() ?>>
<?php echo $payroll_details->office_holidays_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->paid_leave_adj_min->Visible) { // paid_leave_adj_min ?>
		<td data-name="paid_leave_adj_min"<?php echo $payroll_details->paid_leave_adj_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_paid_leave_adj_min" class="payroll_details_paid_leave_adj_min">
<span<?php echo $payroll_details->paid_leave_adj_min->viewAttributes() ?>>
<?php echo $payroll_details->paid_leave_adj_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->overtime->Visible) { // overtime ?>
		<td data-name="overtime"<?php echo $payroll_details->overtime->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_overtime" class="payroll_details_overtime">
<span<?php echo $payroll_details->overtime->viewAttributes() ?>>
<?php echo $payroll_details->overtime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->total_min->Visible) { // total_min ?>
		<td data-name="total_min"<?php echo $payroll_details->total_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_total_min" class="payroll_details_total_min">
<span<?php echo $payroll_details->total_min->viewAttributes() ?>>
<?php echo $payroll_details->total_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $payroll_details->remarks->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_remarks" class="payroll_details_remarks">
<span<?php echo $payroll_details->remarks->viewAttributes() ?>>
<?php echo $payroll_details->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->base_salary->Visible) { // base_salary ?>
		<td data-name="base_salary"<?php echo $payroll_details->base_salary->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_base_salary" class="payroll_details_base_salary">
<span<?php echo $payroll_details->base_salary->viewAttributes() ?>>
<?php echo $payroll_details->base_salary->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->additional_benefits->Visible) { // additional_benefits ?>
		<td data-name="additional_benefits"<?php echo $payroll_details->additional_benefits->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_additional_benefits" class="payroll_details_additional_benefits">
<span<?php echo $payroll_details->additional_benefits->viewAttributes() ?>>
<?php echo $payroll_details->additional_benefits->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->employee_pf->Visible) { // employee_pf ?>
		<td data-name="employee_pf"<?php echo $payroll_details->employee_pf->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_employee_pf" class="payroll_details_employee_pf">
<span<?php echo $payroll_details->employee_pf->viewAttributes() ?>>
<?php echo $payroll_details->employee_pf->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $payroll_details->operator->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_operator" class="payroll_details_operator">
<span<?php echo $payroll_details->operator->viewAttributes() ?>>
<?php echo $payroll_details->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payroll_details->datetime->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_datetime" class="payroll_details_datetime">
<span<?php echo $payroll_details->datetime->viewAttributes() ?>>
<?php echo $payroll_details->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->weekly_off_min->Visible) { // weekly_off_min ?>
		<td data-name="weekly_off_min"<?php echo $payroll_details->weekly_off_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_weekly_off_min" class="payroll_details_weekly_off_min">
<span<?php echo $payroll_details->weekly_off_min->viewAttributes() ?>>
<?php echo $payroll_details->weekly_off_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->employee_am_id->Visible) { // employee_am_id ?>
		<td data-name="employee_am_id"<?php echo $payroll_details->employee_am_id->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_employee_am_id" class="payroll_details_employee_am_id">
<span<?php echo $payroll_details->employee_am_id->viewAttributes() ?>>
<?php echo $payroll_details->employee_am_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->salary_earned->Visible) { // salary_earned ?>
		<td data-name="salary_earned"<?php echo $payroll_details->salary_earned->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_salary_earned" class="payroll_details_salary_earned">
<span<?php echo $payroll_details->salary_earned->viewAttributes() ?>>
<?php echo $payroll_details->salary_earned->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_details->uid->Visible) { // uid ?>
		<td data-name="uid"<?php echo $payroll_details->uid->cellAttributes() ?>>
<span id="el<?php echo $payroll_details_list->RowCnt ?>_payroll_details_uid" class="payroll_details_uid">
<span<?php echo $payroll_details->uid->viewAttributes() ?>>
<?php echo $payroll_details->uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payroll_details_list->ListOptions->render("body", "right", $payroll_details_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payroll_details->isGridAdd())
		$payroll_details_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payroll_details->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payroll_details_list->Recordset)
	$payroll_details_list->Recordset->Close();
?>
<?php if (!$payroll_details->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payroll_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payroll_details_list->Pager)) $payroll_details_list->Pager = new PrevNextPager($payroll_details_list->StartRec, $payroll_details_list->DisplayRecs, $payroll_details_list->TotalRecs, $payroll_details_list->AutoHidePager) ?>
<?php if ($payroll_details_list->Pager->RecordCount > 0 && $payroll_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payroll_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payroll_details_list->pageUrl() ?>start=<?php echo $payroll_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payroll_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payroll_details_list->pageUrl() ?>start=<?php echo $payroll_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payroll_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payroll_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payroll_details_list->pageUrl() ?>start=<?php echo $payroll_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payroll_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payroll_details_list->pageUrl() ?>start=<?php echo $payroll_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payroll_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payroll_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payroll_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payroll_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payroll_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payroll_details_list->TotalRecs > 0 && (!$payroll_details_list->AutoHidePageSizeSelector || $payroll_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payroll_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payroll_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payroll_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payroll_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payroll_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payroll_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payroll_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payroll_details_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payroll_details_list->TotalRecs == 0 && !$payroll_details->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payroll_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payroll_details_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payroll_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payroll_details_list->terminate();
?>