<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_fix_details_list = new payroll_fix_details_list();

// Run the page
$payroll_fix_details_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_fix_details_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$payroll_fix_details->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpayroll_fix_detailslist = currentForm = new ew.Form("fpayroll_fix_detailslist", "list");
fpayroll_fix_detailslist.formKeyCountName = '<?php echo $payroll_fix_details_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpayroll_fix_detailslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpayroll_fix_detailslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpayroll_fix_detailslist.lists["x_weekly_off"] = <?php echo $payroll_fix_details_list->weekly_off->Lookup->toClientList() ?>;
fpayroll_fix_detailslist.lists["x_weekly_off"].options = <?php echo JsonEncode($payroll_fix_details_list->weekly_off->options(FALSE, TRUE)) ?>;
fpayroll_fix_detailslist.lists["x_extra_min_plan"] = <?php echo $payroll_fix_details_list->extra_min_plan->Lookup->toClientList() ?>;
fpayroll_fix_detailslist.lists["x_extra_min_plan"].options = <?php echo JsonEncode($payroll_fix_details_list->extra_min_plan->options(FALSE, TRUE)) ?>;
fpayroll_fix_detailslist.lists["x_office_holidays"] = <?php echo $payroll_fix_details_list->office_holidays->Lookup->toClientList() ?>;
fpayroll_fix_detailslist.lists["x_office_holidays"].options = <?php echo JsonEncode($payroll_fix_details_list->office_holidays->options(FALSE, TRUE)) ?>;
fpayroll_fix_detailslist.lists["x_employee_pf"] = <?php echo $payroll_fix_details_list->employee_pf->Lookup->toClientList() ?>;
fpayroll_fix_detailslist.lists["x_employee_pf"].options = <?php echo JsonEncode($payroll_fix_details_list->employee_pf->options(FALSE, TRUE)) ?>;
fpayroll_fix_detailslist.lists["x_operator"] = <?php echo $payroll_fix_details_list->operator->Lookup->toClientList() ?>;
fpayroll_fix_detailslist.lists["x_operator"].options = <?php echo JsonEncode($payroll_fix_details_list->operator->lookupOptions()) ?>;

// Form object for search
var fpayroll_fix_detailslistsrch = currentSearchForm = new ew.Form("fpayroll_fix_detailslistsrch");

// Filters
fpayroll_fix_detailslistsrch.filterList = <?php echo $payroll_fix_details_list->getFilterList() ?>;

// Init search panel as collapsed
fpayroll_fix_detailslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$payroll_fix_details->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($payroll_fix_details_list->TotalRecs > 0 && $payroll_fix_details_list->ExportOptions->visible()) { ?>
<?php $payroll_fix_details_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_fix_details_list->ImportOptions->visible()) { ?>
<?php $payroll_fix_details_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_fix_details_list->SearchOptions->visible()) { ?>
<?php $payroll_fix_details_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($payroll_fix_details_list->FilterOptions->visible()) { ?>
<?php $payroll_fix_details_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$payroll_fix_details_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$payroll_fix_details->isExport() && !$payroll_fix_details->CurrentAction) { ?>
<form name="fpayroll_fix_detailslistsrch" id="fpayroll_fix_detailslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($payroll_fix_details_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpayroll_fix_detailslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="payroll_fix_details">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($payroll_fix_details_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($payroll_fix_details_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $payroll_fix_details_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($payroll_fix_details_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($payroll_fix_details_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($payroll_fix_details_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($payroll_fix_details_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $payroll_fix_details_list->showPageHeader(); ?>
<?php
$payroll_fix_details_list->showMessage();
?>
<?php if ($payroll_fix_details_list->TotalRecs > 0 || $payroll_fix_details->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($payroll_fix_details_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> payroll_fix_details">
<?php if (!$payroll_fix_details->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$payroll_fix_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payroll_fix_details_list->Pager)) $payroll_fix_details_list->Pager = new PrevNextPager($payroll_fix_details_list->StartRec, $payroll_fix_details_list->DisplayRecs, $payroll_fix_details_list->TotalRecs, $payroll_fix_details_list->AutoHidePager) ?>
<?php if ($payroll_fix_details_list->Pager->RecordCount > 0 && $payroll_fix_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payroll_fix_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payroll_fix_details_list->pageUrl() ?>start=<?php echo $payroll_fix_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payroll_fix_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payroll_fix_details_list->pageUrl() ?>start=<?php echo $payroll_fix_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payroll_fix_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payroll_fix_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payroll_fix_details_list->pageUrl() ?>start=<?php echo $payroll_fix_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payroll_fix_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payroll_fix_details_list->pageUrl() ?>start=<?php echo $payroll_fix_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payroll_fix_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payroll_fix_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payroll_fix_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payroll_fix_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payroll_fix_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payroll_fix_details_list->TotalRecs > 0 && (!$payroll_fix_details_list->AutoHidePageSizeSelector || $payroll_fix_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payroll_fix_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payroll_fix_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payroll_fix_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payroll_fix_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payroll_fix_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payroll_fix_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payroll_fix_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payroll_fix_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpayroll_fix_detailslist" id="fpayroll_fix_detailslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($payroll_fix_details_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $payroll_fix_details_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll_fix_details">
<div id="gmp_payroll_fix_details" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($payroll_fix_details_list->TotalRecs > 0 || $payroll_fix_details->isGridEdit()) { ?>
<table id="tbl_payroll_fix_detailslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$payroll_fix_details_list->RowType = ROWTYPE_HEADER;

// Render list options
$payroll_fix_details_list->renderListOptions();

// Render list options (header, left)
$payroll_fix_details_list->ListOptions->render("header", "left");
?>
<?php if ($payroll_fix_details->id->Visible) { // id ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->id) == "") { ?>
		<th data-name="id" class="<?php echo $payroll_fix_details->id->headerCellClass() ?>"><div id="elh_payroll_fix_details_id" class="payroll_fix_details_id"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $payroll_fix_details->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->id) ?>',2);"><div id="elh_payroll_fix_details_id" class="payroll_fix_details_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->employee_id->Visible) { // employee_id ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $payroll_fix_details->employee_id->headerCellClass() ?>"><div id="elh_payroll_fix_details_employee_id" class="payroll_fix_details_employee_id"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $payroll_fix_details->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->employee_id) ?>',2);"><div id="elh_payroll_fix_details_employee_id" class="payroll_fix_details_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->remarks->Visible) { // remarks ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $payroll_fix_details->remarks->headerCellClass() ?>"><div id="elh_payroll_fix_details_remarks" class="payroll_fix_details_remarks"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $payroll_fix_details->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->remarks) ?>',2);"><div id="elh_payroll_fix_details_remarks" class="payroll_fix_details_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->daily_in->Visible) { // daily_in ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->daily_in) == "") { ?>
		<th data-name="daily_in" class="<?php echo $payroll_fix_details->daily_in->headerCellClass() ?>"><div id="elh_payroll_fix_details_daily_in" class="payroll_fix_details_daily_in"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->daily_in->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="daily_in" class="<?php echo $payroll_fix_details->daily_in->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->daily_in) ?>',2);"><div id="elh_payroll_fix_details_daily_in" class="payroll_fix_details_daily_in">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->daily_in->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->daily_in->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->daily_in->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->daily_out->Visible) { // daily_out ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->daily_out) == "") { ?>
		<th data-name="daily_out" class="<?php echo $payroll_fix_details->daily_out->headerCellClass() ?>"><div id="elh_payroll_fix_details_daily_out" class="payroll_fix_details_daily_out"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->daily_out->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="daily_out" class="<?php echo $payroll_fix_details->daily_out->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->daily_out) ?>',2);"><div id="elh_payroll_fix_details_daily_out" class="payroll_fix_details_daily_out">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->daily_out->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->daily_out->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->daily_out->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->lunch_break_min->Visible) { // lunch_break_min ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->lunch_break_min) == "") { ?>
		<th data-name="lunch_break_min" class="<?php echo $payroll_fix_details->lunch_break_min->headerCellClass() ?>"><div id="elh_payroll_fix_details_lunch_break_min" class="payroll_fix_details_lunch_break_min"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->lunch_break_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lunch_break_min" class="<?php echo $payroll_fix_details->lunch_break_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->lunch_break_min) ?>',2);"><div id="elh_payroll_fix_details_lunch_break_min" class="payroll_fix_details_lunch_break_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->lunch_break_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->lunch_break_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->lunch_break_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->daily_min->Visible) { // daily_min ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->daily_min) == "") { ?>
		<th data-name="daily_min" class="<?php echo $payroll_fix_details->daily_min->headerCellClass() ?>"><div id="elh_payroll_fix_details_daily_min" class="payroll_fix_details_daily_min"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->daily_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="daily_min" class="<?php echo $payroll_fix_details->daily_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->daily_min) ?>',2);"><div id="elh_payroll_fix_details_daily_min" class="payroll_fix_details_daily_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->daily_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->daily_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->daily_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->weekly_off->Visible) { // weekly_off ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->weekly_off) == "") { ?>
		<th data-name="weekly_off" class="<?php echo $payroll_fix_details->weekly_off->headerCellClass() ?>"><div id="elh_payroll_fix_details_weekly_off" class="payroll_fix_details_weekly_off"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->weekly_off->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weekly_off" class="<?php echo $payroll_fix_details->weekly_off->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->weekly_off) ?>',2);"><div id="elh_payroll_fix_details_weekly_off" class="payroll_fix_details_weekly_off">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->weekly_off->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->weekly_off->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->weekly_off->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->offsets_benifit_min->Visible) { // offsets_benifit_min ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->offsets_benifit_min) == "") { ?>
		<th data-name="offsets_benifit_min" class="<?php echo $payroll_fix_details->offsets_benifit_min->headerCellClass() ?>"><div id="elh_payroll_fix_details_offsets_benifit_min" class="payroll_fix_details_offsets_benifit_min"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->offsets_benifit_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="offsets_benifit_min" class="<?php echo $payroll_fix_details->offsets_benifit_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->offsets_benifit_min) ?>',2);"><div id="elh_payroll_fix_details_offsets_benifit_min" class="payroll_fix_details_offsets_benifit_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->offsets_benifit_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->offsets_benifit_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->offsets_benifit_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->next_increment->Visible) { // next_increment ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->next_increment) == "") { ?>
		<th data-name="next_increment" class="<?php echo $payroll_fix_details->next_increment->headerCellClass() ?>"><div id="elh_payroll_fix_details_next_increment" class="payroll_fix_details_next_increment"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->next_increment->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_increment" class="<?php echo $payroll_fix_details->next_increment->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->next_increment) ?>',2);"><div id="elh_payroll_fix_details_next_increment" class="payroll_fix_details_next_increment">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->next_increment->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->next_increment->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->next_increment->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->current_payroll_startdate->Visible) { // current_payroll_startdate ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->current_payroll_startdate) == "") { ?>
		<th data-name="current_payroll_startdate" class="<?php echo $payroll_fix_details->current_payroll_startdate->headerCellClass() ?>"><div id="elh_payroll_fix_details_current_payroll_startdate" class="payroll_fix_details_current_payroll_startdate"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->current_payroll_startdate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_payroll_startdate" class="<?php echo $payroll_fix_details->current_payroll_startdate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->current_payroll_startdate) ?>',2);"><div id="elh_payroll_fix_details_current_payroll_startdate" class="payroll_fix_details_current_payroll_startdate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->current_payroll_startdate->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->current_payroll_startdate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->current_payroll_startdate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->base_salary->Visible) { // base_salary ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->base_salary) == "") { ?>
		<th data-name="base_salary" class="<?php echo $payroll_fix_details->base_salary->headerCellClass() ?>"><div id="elh_payroll_fix_details_base_salary" class="payroll_fix_details_base_salary"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->base_salary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="base_salary" class="<?php echo $payroll_fix_details->base_salary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->base_salary) ?>',2);"><div id="elh_payroll_fix_details_base_salary" class="payroll_fix_details_base_salary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->base_salary->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->base_salary->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->base_salary->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->additional_benefits->Visible) { // additional_benefits ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->additional_benefits) == "") { ?>
		<th data-name="additional_benefits" class="<?php echo $payroll_fix_details->additional_benefits->headerCellClass() ?>"><div id="elh_payroll_fix_details_additional_benefits" class="payroll_fix_details_additional_benefits"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->additional_benefits->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="additional_benefits" class="<?php echo $payroll_fix_details->additional_benefits->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->additional_benefits) ?>',2);"><div id="elh_payroll_fix_details_additional_benefits" class="payroll_fix_details_additional_benefits">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->additional_benefits->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->additional_benefits->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->additional_benefits->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->extra_min_plan->Visible) { // extra_min_plan ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->extra_min_plan) == "") { ?>
		<th data-name="extra_min_plan" class="<?php echo $payroll_fix_details->extra_min_plan->headerCellClass() ?>"><div id="elh_payroll_fix_details_extra_min_plan" class="payroll_fix_details_extra_min_plan"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->extra_min_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="extra_min_plan" class="<?php echo $payroll_fix_details->extra_min_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->extra_min_plan) ?>',2);"><div id="elh_payroll_fix_details_extra_min_plan" class="payroll_fix_details_extra_min_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->extra_min_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->extra_min_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->extra_min_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->office_holidays->Visible) { // office_holidays ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->office_holidays) == "") { ?>
		<th data-name="office_holidays" class="<?php echo $payroll_fix_details->office_holidays->headerCellClass() ?>"><div id="elh_payroll_fix_details_office_holidays" class="payroll_fix_details_office_holidays"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->office_holidays->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="office_holidays" class="<?php echo $payroll_fix_details->office_holidays->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->office_holidays) ?>',2);"><div id="elh_payroll_fix_details_office_holidays" class="payroll_fix_details_office_holidays">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->office_holidays->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->office_holidays->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->office_holidays->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->paid_annual_leave->Visible) { // paid_annual_leave ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->paid_annual_leave) == "") { ?>
		<th data-name="paid_annual_leave" class="<?php echo $payroll_fix_details->paid_annual_leave->headerCellClass() ?>"><div id="elh_payroll_fix_details_paid_annual_leave" class="payroll_fix_details_paid_annual_leave"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->paid_annual_leave->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="paid_annual_leave" class="<?php echo $payroll_fix_details->paid_annual_leave->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->paid_annual_leave) ?>',2);"><div id="elh_payroll_fix_details_paid_annual_leave" class="payroll_fix_details_paid_annual_leave">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->paid_annual_leave->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->paid_annual_leave->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->paid_annual_leave->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->employee_pf->Visible) { // employee_pf ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->employee_pf) == "") { ?>
		<th data-name="employee_pf" class="<?php echo $payroll_fix_details->employee_pf->headerCellClass() ?>"><div id="elh_payroll_fix_details_employee_pf" class="payroll_fix_details_employee_pf"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->employee_pf->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_pf" class="<?php echo $payroll_fix_details->employee_pf->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->employee_pf) ?>',2);"><div id="elh_payroll_fix_details_employee_pf" class="payroll_fix_details_employee_pf">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->employee_pf->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->employee_pf->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->employee_pf->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->operator->Visible) { // operator ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $payroll_fix_details->operator->headerCellClass() ?>"><div id="elh_payroll_fix_details_operator" class="payroll_fix_details_operator"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $payroll_fix_details->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->operator) ?>',2);"><div id="elh_payroll_fix_details_operator" class="payroll_fix_details_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->datetime->Visible) { // datetime ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $payroll_fix_details->datetime->headerCellClass() ?>"><div id="elh_payroll_fix_details_datetime" class="payroll_fix_details_datetime"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $payroll_fix_details->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->datetime) ?>',2);"><div id="elh_payroll_fix_details_datetime" class="payroll_fix_details_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->employee_am_id->Visible) { // employee_am_id ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->employee_am_id) == "") { ?>
		<th data-name="employee_am_id" class="<?php echo $payroll_fix_details->employee_am_id->headerCellClass() ?>"><div id="elh_payroll_fix_details_employee_am_id" class="payroll_fix_details_employee_am_id"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->employee_am_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_am_id" class="<?php echo $payroll_fix_details->employee_am_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->employee_am_id) ?>',2);"><div id="elh_payroll_fix_details_employee_am_id" class="payroll_fix_details_employee_am_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->employee_am_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->employee_am_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->employee_am_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->job_title->Visible) { // job_title ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->job_title) == "") { ?>
		<th data-name="job_title" class="<?php echo $payroll_fix_details->job_title->headerCellClass() ?>"><div id="elh_payroll_fix_details_job_title" class="payroll_fix_details_job_title"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->job_title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="job_title" class="<?php echo $payroll_fix_details->job_title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->job_title) ?>',2);"><div id="elh_payroll_fix_details_job_title" class="payroll_fix_details_job_title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->job_title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->job_title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->job_title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->month_min->Visible) { // month_min ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->month_min) == "") { ?>
		<th data-name="month_min" class="<?php echo $payroll_fix_details->month_min->headerCellClass() ?>"><div id="elh_payroll_fix_details_month_min" class="payroll_fix_details_month_min"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->month_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month_min" class="<?php echo $payroll_fix_details->month_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->month_min) ?>',2);"><div id="elh_payroll_fix_details_month_min" class="payroll_fix_details_month_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->month_min->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->month_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->month_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->calculation_plan->Visible) { // calculation_plan ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->calculation_plan) == "") { ?>
		<th data-name="calculation_plan" class="<?php echo $payroll_fix_details->calculation_plan->headerCellClass() ?>"><div id="elh_payroll_fix_details_calculation_plan" class="payroll_fix_details_calculation_plan"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->calculation_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="calculation_plan" class="<?php echo $payroll_fix_details->calculation_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->calculation_plan) ?>',2);"><div id="elh_payroll_fix_details_calculation_plan" class="payroll_fix_details_calculation_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->calculation_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->calculation_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->calculation_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($payroll_fix_details->status->Visible) { // status ?>
	<?php if ($payroll_fix_details->sortUrl($payroll_fix_details->status) == "") { ?>
		<th data-name="status" class="<?php echo $payroll_fix_details->status->headerCellClass() ?>"><div id="elh_payroll_fix_details_status" class="payroll_fix_details_status"><div class="ew-table-header-caption"><?php echo $payroll_fix_details->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $payroll_fix_details->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $payroll_fix_details->SortUrl($payroll_fix_details->status) ?>',2);"><div id="elh_payroll_fix_details_status" class="payroll_fix_details_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $payroll_fix_details->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($payroll_fix_details->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($payroll_fix_details->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$payroll_fix_details_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($payroll_fix_details->ExportAll && $payroll_fix_details->isExport()) {
	$payroll_fix_details_list->StopRec = $payroll_fix_details_list->TotalRecs;
} else {

	// Set the last record to display
	if ($payroll_fix_details_list->TotalRecs > $payroll_fix_details_list->StartRec + $payroll_fix_details_list->DisplayRecs - 1)
		$payroll_fix_details_list->StopRec = $payroll_fix_details_list->StartRec + $payroll_fix_details_list->DisplayRecs - 1;
	else
		$payroll_fix_details_list->StopRec = $payroll_fix_details_list->TotalRecs;
}
$payroll_fix_details_list->RecCnt = $payroll_fix_details_list->StartRec - 1;
if ($payroll_fix_details_list->Recordset && !$payroll_fix_details_list->Recordset->EOF) {
	$payroll_fix_details_list->Recordset->moveFirst();
	$selectLimit = $payroll_fix_details_list->UseSelectLimit;
	if (!$selectLimit && $payroll_fix_details_list->StartRec > 1)
		$payroll_fix_details_list->Recordset->move($payroll_fix_details_list->StartRec - 1);
} elseif (!$payroll_fix_details->AllowAddDeleteRow && $payroll_fix_details_list->StopRec == 0) {
	$payroll_fix_details_list->StopRec = $payroll_fix_details->GridAddRowCount;
}

// Initialize aggregate
$payroll_fix_details->RowType = ROWTYPE_AGGREGATEINIT;
$payroll_fix_details->resetAttributes();
$payroll_fix_details_list->renderRow();
while ($payroll_fix_details_list->RecCnt < $payroll_fix_details_list->StopRec) {
	$payroll_fix_details_list->RecCnt++;
	if ($payroll_fix_details_list->RecCnt >= $payroll_fix_details_list->StartRec) {
		$payroll_fix_details_list->RowCnt++;

		// Set up key count
		$payroll_fix_details_list->KeyCount = $payroll_fix_details_list->RowIndex;

		// Init row class and style
		$payroll_fix_details->resetAttributes();
		$payroll_fix_details->CssClass = "";
		if ($payroll_fix_details->isGridAdd()) {
		} else {
			$payroll_fix_details_list->loadRowValues($payroll_fix_details_list->Recordset); // Load row values
		}
		$payroll_fix_details->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$payroll_fix_details->RowAttrs = array_merge($payroll_fix_details->RowAttrs, array('data-rowindex'=>$payroll_fix_details_list->RowCnt, 'id'=>'r' . $payroll_fix_details_list->RowCnt . '_payroll_fix_details', 'data-rowtype'=>$payroll_fix_details->RowType));

		// Render row
		$payroll_fix_details_list->renderRow();

		// Render list options
		$payroll_fix_details_list->renderListOptions();
?>
	<tr<?php echo $payroll_fix_details->rowAttributes() ?>>
<?php

// Render list options (body, left)
$payroll_fix_details_list->ListOptions->render("body", "left", $payroll_fix_details_list->RowCnt);
?>
	<?php if ($payroll_fix_details->id->Visible) { // id ?>
		<td data-name="id"<?php echo $payroll_fix_details->id->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_id" class="payroll_fix_details_id">
<span<?php echo $payroll_fix_details->id->viewAttributes() ?>>
<?php echo $payroll_fix_details->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $payroll_fix_details->employee_id->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_employee_id" class="payroll_fix_details_employee_id">
<span<?php echo $payroll_fix_details->employee_id->viewAttributes() ?>>
<?php echo $payroll_fix_details->employee_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $payroll_fix_details->remarks->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_remarks" class="payroll_fix_details_remarks">
<span<?php echo $payroll_fix_details->remarks->viewAttributes() ?>>
<?php echo $payroll_fix_details->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->daily_in->Visible) { // daily_in ?>
		<td data-name="daily_in"<?php echo $payroll_fix_details->daily_in->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_daily_in" class="payroll_fix_details_daily_in">
<span<?php echo $payroll_fix_details->daily_in->viewAttributes() ?>>
<?php echo $payroll_fix_details->daily_in->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->daily_out->Visible) { // daily_out ?>
		<td data-name="daily_out"<?php echo $payroll_fix_details->daily_out->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_daily_out" class="payroll_fix_details_daily_out">
<span<?php echo $payroll_fix_details->daily_out->viewAttributes() ?>>
<?php echo $payroll_fix_details->daily_out->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->lunch_break_min->Visible) { // lunch_break_min ?>
		<td data-name="lunch_break_min"<?php echo $payroll_fix_details->lunch_break_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_lunch_break_min" class="payroll_fix_details_lunch_break_min">
<span<?php echo $payroll_fix_details->lunch_break_min->viewAttributes() ?>>
<?php echo $payroll_fix_details->lunch_break_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->daily_min->Visible) { // daily_min ?>
		<td data-name="daily_min"<?php echo $payroll_fix_details->daily_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_daily_min" class="payroll_fix_details_daily_min">
<span<?php echo $payroll_fix_details->daily_min->viewAttributes() ?>>
<?php echo $payroll_fix_details->daily_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->weekly_off->Visible) { // weekly_off ?>
		<td data-name="weekly_off"<?php echo $payroll_fix_details->weekly_off->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_weekly_off" class="payroll_fix_details_weekly_off">
<span<?php echo $payroll_fix_details->weekly_off->viewAttributes() ?>>
<?php echo $payroll_fix_details->weekly_off->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->offsets_benifit_min->Visible) { // offsets_benifit_min ?>
		<td data-name="offsets_benifit_min"<?php echo $payroll_fix_details->offsets_benifit_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_offsets_benifit_min" class="payroll_fix_details_offsets_benifit_min">
<span<?php echo $payroll_fix_details->offsets_benifit_min->viewAttributes() ?>>
<?php echo $payroll_fix_details->offsets_benifit_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->next_increment->Visible) { // next_increment ?>
		<td data-name="next_increment"<?php echo $payroll_fix_details->next_increment->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_next_increment" class="payroll_fix_details_next_increment">
<span<?php echo $payroll_fix_details->next_increment->viewAttributes() ?>>
<?php echo $payroll_fix_details->next_increment->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->current_payroll_startdate->Visible) { // current_payroll_startdate ?>
		<td data-name="current_payroll_startdate"<?php echo $payroll_fix_details->current_payroll_startdate->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_current_payroll_startdate" class="payroll_fix_details_current_payroll_startdate">
<span<?php echo $payroll_fix_details->current_payroll_startdate->viewAttributes() ?>>
<?php echo $payroll_fix_details->current_payroll_startdate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->base_salary->Visible) { // base_salary ?>
		<td data-name="base_salary"<?php echo $payroll_fix_details->base_salary->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_base_salary" class="payroll_fix_details_base_salary">
<span<?php echo $payroll_fix_details->base_salary->viewAttributes() ?>>
<?php echo $payroll_fix_details->base_salary->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->additional_benefits->Visible) { // additional_benefits ?>
		<td data-name="additional_benefits"<?php echo $payroll_fix_details->additional_benefits->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_additional_benefits" class="payroll_fix_details_additional_benefits">
<span<?php echo $payroll_fix_details->additional_benefits->viewAttributes() ?>>
<?php echo $payroll_fix_details->additional_benefits->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->extra_min_plan->Visible) { // extra_min_plan ?>
		<td data-name="extra_min_plan"<?php echo $payroll_fix_details->extra_min_plan->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_extra_min_plan" class="payroll_fix_details_extra_min_plan">
<span<?php echo $payroll_fix_details->extra_min_plan->viewAttributes() ?>>
<?php echo $payroll_fix_details->extra_min_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->office_holidays->Visible) { // office_holidays ?>
		<td data-name="office_holidays"<?php echo $payroll_fix_details->office_holidays->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_office_holidays" class="payroll_fix_details_office_holidays">
<span<?php echo $payroll_fix_details->office_holidays->viewAttributes() ?>>
<?php echo $payroll_fix_details->office_holidays->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->paid_annual_leave->Visible) { // paid_annual_leave ?>
		<td data-name="paid_annual_leave"<?php echo $payroll_fix_details->paid_annual_leave->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_paid_annual_leave" class="payroll_fix_details_paid_annual_leave">
<span<?php echo $payroll_fix_details->paid_annual_leave->viewAttributes() ?>>
<?php echo $payroll_fix_details->paid_annual_leave->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->employee_pf->Visible) { // employee_pf ?>
		<td data-name="employee_pf"<?php echo $payroll_fix_details->employee_pf->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_employee_pf" class="payroll_fix_details_employee_pf">
<span<?php echo $payroll_fix_details->employee_pf->viewAttributes() ?>>
<?php echo $payroll_fix_details->employee_pf->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $payroll_fix_details->operator->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_operator" class="payroll_fix_details_operator">
<span<?php echo $payroll_fix_details->operator->viewAttributes() ?>>
<?php echo $payroll_fix_details->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $payroll_fix_details->datetime->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_datetime" class="payroll_fix_details_datetime">
<span<?php echo $payroll_fix_details->datetime->viewAttributes() ?>>
<?php echo $payroll_fix_details->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->employee_am_id->Visible) { // employee_am_id ?>
		<td data-name="employee_am_id"<?php echo $payroll_fix_details->employee_am_id->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_employee_am_id" class="payroll_fix_details_employee_am_id">
<span<?php echo $payroll_fix_details->employee_am_id->viewAttributes() ?>>
<?php echo $payroll_fix_details->employee_am_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->job_title->Visible) { // job_title ?>
		<td data-name="job_title"<?php echo $payroll_fix_details->job_title->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_job_title" class="payroll_fix_details_job_title">
<span<?php echo $payroll_fix_details->job_title->viewAttributes() ?>>
<?php echo $payroll_fix_details->job_title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->month_min->Visible) { // month_min ?>
		<td data-name="month_min"<?php echo $payroll_fix_details->month_min->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_month_min" class="payroll_fix_details_month_min">
<span<?php echo $payroll_fix_details->month_min->viewAttributes() ?>>
<?php echo $payroll_fix_details->month_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->calculation_plan->Visible) { // calculation_plan ?>
		<td data-name="calculation_plan"<?php echo $payroll_fix_details->calculation_plan->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_calculation_plan" class="payroll_fix_details_calculation_plan">
<span<?php echo $payroll_fix_details->calculation_plan->viewAttributes() ?>>
<?php echo $payroll_fix_details->calculation_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($payroll_fix_details->status->Visible) { // status ?>
		<td data-name="status"<?php echo $payroll_fix_details->status->cellAttributes() ?>>
<span id="el<?php echo $payroll_fix_details_list->RowCnt ?>_payroll_fix_details_status" class="payroll_fix_details_status">
<span<?php echo $payroll_fix_details->status->viewAttributes() ?>>
<?php echo $payroll_fix_details->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$payroll_fix_details_list->ListOptions->render("body", "right", $payroll_fix_details_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$payroll_fix_details->isGridAdd())
		$payroll_fix_details_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$payroll_fix_details->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($payroll_fix_details_list->Recordset)
	$payroll_fix_details_list->Recordset->Close();
?>
<?php if (!$payroll_fix_details->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$payroll_fix_details->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($payroll_fix_details_list->Pager)) $payroll_fix_details_list->Pager = new PrevNextPager($payroll_fix_details_list->StartRec, $payroll_fix_details_list->DisplayRecs, $payroll_fix_details_list->TotalRecs, $payroll_fix_details_list->AutoHidePager) ?>
<?php if ($payroll_fix_details_list->Pager->RecordCount > 0 && $payroll_fix_details_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($payroll_fix_details_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $payroll_fix_details_list->pageUrl() ?>start=<?php echo $payroll_fix_details_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($payroll_fix_details_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $payroll_fix_details_list->pageUrl() ?>start=<?php echo $payroll_fix_details_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $payroll_fix_details_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($payroll_fix_details_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $payroll_fix_details_list->pageUrl() ?>start=<?php echo $payroll_fix_details_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($payroll_fix_details_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $payroll_fix_details_list->pageUrl() ?>start=<?php echo $payroll_fix_details_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $payroll_fix_details_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($payroll_fix_details_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $payroll_fix_details_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $payroll_fix_details_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $payroll_fix_details_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($payroll_fix_details_list->TotalRecs > 0 && (!$payroll_fix_details_list->AutoHidePageSizeSelector || $payroll_fix_details_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="payroll_fix_details">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($payroll_fix_details_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($payroll_fix_details_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($payroll_fix_details_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($payroll_fix_details_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($payroll_fix_details_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($payroll_fix_details->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $payroll_fix_details_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($payroll_fix_details_list->TotalRecs == 0 && !$payroll_fix_details->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $payroll_fix_details_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$payroll_fix_details_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$payroll_fix_details->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$payroll_fix_details_list->terminate();
?>