<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$personal_info_add = new personal_info_add();

// Run the page
$personal_info_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$personal_info_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpersonal_infoadd = currentForm = new ew.Form("fpersonal_infoadd", "add");

// Validate form
fpersonal_infoadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($personal_info_add->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->id->caption(), $personal_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->formal_name->caption(), $personal_info->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->gender->Required) { ?>
			elm = this.getElements("x" + infix + "_gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->gender->caption(), $personal_info->gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile->caption(), $personal_info->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->mobile->errorMessage()) ?>");
		<?php if ($personal_info_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->_email->caption(), $personal_info->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->_email->errorMessage()) ?>");
		<?php if ($personal_info_add->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->address->caption(), $personal_info->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->country->caption(), $personal_info->country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->state->Required) { ?>
			elm = this.getElements("x" + infix + "_state");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->state->caption(), $personal_info->state->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->city->caption(), $personal_info->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->city_name->Required) { ?>
			elm = this.getElements("x" + infix + "_city_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->city_name->caption(), $personal_info->city_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->dob->caption(), $personal_info->dob->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->dob->errorMessage()) ?>");
		<?php if ($personal_info_add->dom->Required) { ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->dom->caption(), $personal_info->dom->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->dom->errorMessage()) ?>");
		<?php if ($personal_info_add->marital_status->Required) { ?>
			elm = this.getElements("x" + infix + "_marital_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->marital_status->caption(), $personal_info->marital_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->spouse_details->Required) { ?>
			elm = this.getElements("x" + infix + "_spouse_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->spouse_details->caption(), $personal_info->spouse_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->father_name->Required) { ?>
			elm = this.getElements("x" + infix + "_father_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->father_name->caption(), $personal_info->father_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->mother_name->Required) { ?>
			elm = this.getElements("x" + infix + "_mother_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mother_name->caption(), $personal_info->mother_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->permanent_address->Required) { ?>
			elm = this.getElements("x" + infix + "_permanent_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->permanent_address->caption(), $personal_info->permanent_address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->mobile_other->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile_other->caption(), $personal_info->mobile_other->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->mobile_family->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_family");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile_family->caption(), $personal_info->mobile_family->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->emergency_details->Required) { ?>
			elm = this.getElements("x" + infix + "_emergency_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->emergency_details->caption(), $personal_info->emergency_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->annual_income->Required) { ?>
			elm = this.getElements("x" + infix + "_annual_income");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->annual_income->caption(), $personal_info->annual_income->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_annual_income");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->annual_income->errorMessage()) ?>");
		<?php if ($personal_info_add->work_details->Required) { ?>
			elm = this.getElements("x" + infix + "_work_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->work_details->caption(), $personal_info->work_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->status->caption(), $personal_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->gst->Required) { ?>
			elm = this.getElements("x" + infix + "_gst");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->gst->caption(), $personal_info->gst->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->aadhaar_no->caption(), $personal_info->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.checkByRegEx(elm.value, /^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/))
				return this.onError(elm, "<?php echo JsEncode($personal_info->aadhaar_no->errorMessage()) ?>");
		<?php if ($personal_info_add->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->pan_no->caption(), $personal_info->pan_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
				return this.onError(elm, "<?php echo JsEncode($personal_info->pan_no->errorMessage()) ?>");
		<?php if ($personal_info_add->reference_details->Required) { ?>
			elm = this.getElements("x" + infix + "_reference_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->reference_details->caption(), $personal_info->reference_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->other_details->caption(), $personal_info->other_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->bank_name->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_name->caption(), $personal_info->bank_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->bank_ifsc_code->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_ifsc_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_ifsc_code->caption(), $personal_info->bank_ifsc_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->bank_account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_account_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_account_no->caption(), $personal_info->bank_account_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->operator->caption(), $personal_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->datetime->caption(), $personal_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpersonal_infoadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpersonal_infoadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpersonal_infoadd.lists["x_gender"] = <?php echo $personal_info_add->gender->Lookup->toClientList() ?>;
fpersonal_infoadd.lists["x_gender"].options = <?php echo JsonEncode($personal_info_add->gender->options(FALSE, TRUE)) ?>;
fpersonal_infoadd.lists["x_country"] = <?php echo $personal_info_add->country->Lookup->toClientList() ?>;
fpersonal_infoadd.lists["x_country"].options = <?php echo JsonEncode($personal_info_add->country->lookupOptions()) ?>;
fpersonal_infoadd.lists["x_state"] = <?php echo $personal_info_add->state->Lookup->toClientList() ?>;
fpersonal_infoadd.lists["x_state"].options = <?php echo JsonEncode($personal_info_add->state->lookupOptions()) ?>;
fpersonal_infoadd.lists["x_city"] = <?php echo $personal_info_add->city->Lookup->toClientList() ?>;
fpersonal_infoadd.lists["x_city"].options = <?php echo JsonEncode($personal_info_add->city->lookupOptions()) ?>;
fpersonal_infoadd.lists["x_marital_status"] = <?php echo $personal_info_add->marital_status->Lookup->toClientList() ?>;
fpersonal_infoadd.lists["x_marital_status"].options = <?php echo JsonEncode($personal_info_add->marital_status->options(FALSE, TRUE)) ?>;
fpersonal_infoadd.lists["x_status"] = <?php echo $personal_info_add->status->Lookup->toClientList() ?>;
fpersonal_infoadd.lists["x_status"].options = <?php echo JsonEncode($personal_info_add->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $personal_info_add->showPageHeader(); ?>
<?php
$personal_info_add->showMessage();
?>
<form name="fpersonal_infoadd" id="fpersonal_infoadd" class="<?php echo $personal_info_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($personal_info_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $personal_info_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$personal_info_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($personal_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_personal_info_id" for="x_id" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->id->caption() ?><?php echo ($personal_info->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->id->cellAttributes() ?>><?php echo $personal_info->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label id="elh_personal_info_formal_name" for="x_formal_name" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->formal_name->caption() ?><?php echo ($personal_info->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->formal_name->cellAttributes() ?>>
<span id="el_personal_info_formal_name">
<input type="text" data-table="personal_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($personal_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->formal_name->EditValue ?>"<?php echo $personal_info->formal_name->editAttributes() ?>>
</span>
<?php echo $personal_info->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label id="elh_personal_info_gender" for="x_gender" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->gender->caption() ?><?php echo ($personal_info->gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->gender->cellAttributes() ?>>
<span id="el_personal_info_gender">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_gender" data-value-separator="<?php echo $personal_info->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $personal_info->gender->editAttributes() ?>>
		<?php echo $personal_info->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
</span>
<?php echo $personal_info->gender->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_personal_info_mobile" for="x_mobile" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->mobile->caption() ?><?php echo ($personal_info->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->mobile->cellAttributes() ?>>
<span id="el_personal_info_mobile">
<input type="text" data-table="personal_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($personal_info->mobile->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile->EditValue ?>"<?php echo $personal_info->mobile->editAttributes() ?>>
</span>
<?php echo $personal_info->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_personal_info__email" for="x__email" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->_email->caption() ?><?php echo ($personal_info->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->_email->cellAttributes() ?>>
<span id="el_personal_info__email">
<input type="text" data-table="personal_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($personal_info->_email->getPlaceHolder()) ?>" value="<?php echo $personal_info->_email->EditValue ?>"<?php echo $personal_info->_email->editAttributes() ?>>
</span>
<?php echo $personal_info->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_personal_info_address" for="x_address" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->address->caption() ?><?php echo ($personal_info->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->address->cellAttributes() ?>>
<span id="el_personal_info_address">
<input type="text" data-table="personal_info" data-field="x_address" name="x_address" id="x_address" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->address->getPlaceHolder()) ?>" value="<?php echo $personal_info->address->EditValue ?>"<?php echo $personal_info->address->editAttributes() ?>>
</span>
<?php echo $personal_info->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->country->Visible) { // country ?>
	<div id="r_country" class="form-group row">
		<label id="elh_personal_info_country" for="x_country" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->country->caption() ?><?php echo ($personal_info->country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->country->cellAttributes() ?>>
<span id="el_personal_info_country">
<?php $personal_info->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$personal_info->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_country" data-value-separator="<?php echo $personal_info->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $personal_info->country->editAttributes() ?>>
		<?php echo $personal_info->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $personal_info->country->Lookup->getParamTag("p_x_country") ?>
</span>
<?php echo $personal_info->country->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->state->Visible) { // state ?>
	<div id="r_state" class="form-group row">
		<label id="elh_personal_info_state" for="x_state" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->state->caption() ?><?php echo ($personal_info->state->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->state->cellAttributes() ?>>
<span id="el_personal_info_state">
<?php $personal_info->state->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$personal_info->state->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_state" data-value-separator="<?php echo $personal_info->state->displayValueSeparatorAttribute() ?>" id="x_state" name="x_state"<?php echo $personal_info->state->editAttributes() ?>>
		<?php echo $personal_info->state->selectOptionListHtml("x_state") ?>
	</select>
</div>
<?php echo $personal_info->state->Lookup->getParamTag("p_x_state") ?>
</span>
<?php echo $personal_info->state->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label id="elh_personal_info_city" for="x_city" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->city->caption() ?><?php echo ($personal_info->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->city->cellAttributes() ?>>
<span id="el_personal_info_city">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_city" data-value-separator="<?php echo $personal_info->city->displayValueSeparatorAttribute() ?>" id="x_city" name="x_city"<?php echo $personal_info->city->editAttributes() ?>>
		<?php echo $personal_info->city->selectOptionListHtml("x_city") ?>
	</select>
</div>
<?php echo $personal_info->city->Lookup->getParamTag("p_x_city") ?>
</span>
<?php echo $personal_info->city->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->city_name->Visible) { // city_name ?>
	<div id="r_city_name" class="form-group row">
		<label id="elh_personal_info_city_name" for="x_city_name" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->city_name->caption() ?><?php echo ($personal_info->city_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->city_name->cellAttributes() ?>>
<span id="el_personal_info_city_name">
<input type="text" data-table="personal_info" data-field="x_city_name" name="x_city_name" id="x_city_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->city_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->city_name->EditValue ?>"<?php echo $personal_info->city_name->editAttributes() ?>>
</span>
<?php echo $personal_info->city_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label id="elh_personal_info_dob" for="x_dob" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->dob->caption() ?><?php echo ($personal_info->dob->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->dob->cellAttributes() ?>>
<span id="el_personal_info_dob">
<input type="text" data-table="personal_info" data-field="x_dob" data-format="2" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($personal_info->dob->getPlaceHolder()) ?>" value="<?php echo $personal_info->dob->EditValue ?>"<?php echo $personal_info->dob->editAttributes() ?>>
<?php if (!$personal_info->dob->ReadOnly && !$personal_info->dob->Disabled && !isset($personal_info->dob->EditAttrs["readonly"]) && !isset($personal_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infoadd", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $personal_info->dob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->dom->Visible) { // dom ?>
	<div id="r_dom" class="form-group row">
		<label id="elh_personal_info_dom" for="x_dom" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->dom->caption() ?><?php echo ($personal_info->dom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->dom->cellAttributes() ?>>
<span id="el_personal_info_dom">
<input type="text" data-table="personal_info" data-field="x_dom" data-format="2" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($personal_info->dom->getPlaceHolder()) ?>" value="<?php echo $personal_info->dom->EditValue ?>"<?php echo $personal_info->dom->editAttributes() ?>>
<?php if (!$personal_info->dom->ReadOnly && !$personal_info->dom->Disabled && !isset($personal_info->dom->EditAttrs["readonly"]) && !isset($personal_info->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infoadd", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $personal_info->dom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->marital_status->Visible) { // marital_status ?>
	<div id="r_marital_status" class="form-group row">
		<label id="elh_personal_info_marital_status" for="x_marital_status" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->marital_status->caption() ?><?php echo ($personal_info->marital_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->marital_status->cellAttributes() ?>>
<span id="el_personal_info_marital_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_marital_status" data-value-separator="<?php echo $personal_info->marital_status->displayValueSeparatorAttribute() ?>" id="x_marital_status" name="x_marital_status"<?php echo $personal_info->marital_status->editAttributes() ?>>
		<?php echo $personal_info->marital_status->selectOptionListHtml("x_marital_status") ?>
	</select>
</div>
</span>
<?php echo $personal_info->marital_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->spouse_details->Visible) { // spouse_details ?>
	<div id="r_spouse_details" class="form-group row">
		<label id="elh_personal_info_spouse_details" for="x_spouse_details" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->spouse_details->caption() ?><?php echo ($personal_info->spouse_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->spouse_details->cellAttributes() ?>>
<span id="el_personal_info_spouse_details">
<input type="text" data-table="personal_info" data-field="x_spouse_details" name="x_spouse_details" id="x_spouse_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->spouse_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->spouse_details->EditValue ?>"<?php echo $personal_info->spouse_details->editAttributes() ?>>
</span>
<?php echo $personal_info->spouse_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->father_name->Visible) { // father_name ?>
	<div id="r_father_name" class="form-group row">
		<label id="elh_personal_info_father_name" for="x_father_name" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->father_name->caption() ?><?php echo ($personal_info->father_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->father_name->cellAttributes() ?>>
<span id="el_personal_info_father_name">
<input type="text" data-table="personal_info" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->father_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->father_name->EditValue ?>"<?php echo $personal_info->father_name->editAttributes() ?>>
</span>
<?php echo $personal_info->father_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mother_name->Visible) { // mother_name ?>
	<div id="r_mother_name" class="form-group row">
		<label id="elh_personal_info_mother_name" for="x_mother_name" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->mother_name->caption() ?><?php echo ($personal_info->mother_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->mother_name->cellAttributes() ?>>
<span id="el_personal_info_mother_name">
<input type="text" data-table="personal_info" data-field="x_mother_name" name="x_mother_name" id="x_mother_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->mother_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->mother_name->EditValue ?>"<?php echo $personal_info->mother_name->editAttributes() ?>>
</span>
<?php echo $personal_info->mother_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->permanent_address->Visible) { // permanent_address ?>
	<div id="r_permanent_address" class="form-group row">
		<label id="elh_personal_info_permanent_address" for="x_permanent_address" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->permanent_address->caption() ?><?php echo ($personal_info->permanent_address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->permanent_address->cellAttributes() ?>>
<span id="el_personal_info_permanent_address">
<input type="text" data-table="personal_info" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->permanent_address->getPlaceHolder()) ?>" value="<?php echo $personal_info->permanent_address->EditValue ?>"<?php echo $personal_info->permanent_address->editAttributes() ?>>
</span>
<?php echo $personal_info->permanent_address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile_other->Visible) { // mobile_other ?>
	<div id="r_mobile_other" class="form-group row">
		<label id="elh_personal_info_mobile_other" for="x_mobile_other" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->mobile_other->caption() ?><?php echo ($personal_info->mobile_other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->mobile_other->cellAttributes() ?>>
<span id="el_personal_info_mobile_other">
<input type="text" data-table="personal_info" data-field="x_mobile_other" name="x_mobile_other" id="x_mobile_other" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($personal_info->mobile_other->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile_other->EditValue ?>"<?php echo $personal_info->mobile_other->editAttributes() ?>>
</span>
<?php echo $personal_info->mobile_other->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile_family->Visible) { // mobile_family ?>
	<div id="r_mobile_family" class="form-group row">
		<label id="elh_personal_info_mobile_family" for="x_mobile_family" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->mobile_family->caption() ?><?php echo ($personal_info->mobile_family->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->mobile_family->cellAttributes() ?>>
<span id="el_personal_info_mobile_family">
<input type="text" data-table="personal_info" data-field="x_mobile_family" name="x_mobile_family" id="x_mobile_family" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->mobile_family->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile_family->EditValue ?>"<?php echo $personal_info->mobile_family->editAttributes() ?>>
</span>
<?php echo $personal_info->mobile_family->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->emergency_details->Visible) { // emergency_details ?>
	<div id="r_emergency_details" class="form-group row">
		<label id="elh_personal_info_emergency_details" for="x_emergency_details" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->emergency_details->caption() ?><?php echo ($personal_info->emergency_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->emergency_details->cellAttributes() ?>>
<span id="el_personal_info_emergency_details">
<input type="text" data-table="personal_info" data-field="x_emergency_details" name="x_emergency_details" id="x_emergency_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->emergency_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->emergency_details->EditValue ?>"<?php echo $personal_info->emergency_details->editAttributes() ?>>
</span>
<?php echo $personal_info->emergency_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->annual_income->Visible) { // annual_income ?>
	<div id="r_annual_income" class="form-group row">
		<label id="elh_personal_info_annual_income" for="x_annual_income" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->annual_income->caption() ?><?php echo ($personal_info->annual_income->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->annual_income->cellAttributes() ?>>
<span id="el_personal_info_annual_income">
<input type="text" data-table="personal_info" data-field="x_annual_income" name="x_annual_income" id="x_annual_income" size="30" placeholder="<?php echo HtmlEncode($personal_info->annual_income->getPlaceHolder()) ?>" value="<?php echo $personal_info->annual_income->EditValue ?>"<?php echo $personal_info->annual_income->editAttributes() ?>>
</span>
<?php echo $personal_info->annual_income->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->work_details->Visible) { // work_details ?>
	<div id="r_work_details" class="form-group row">
		<label id="elh_personal_info_work_details" for="x_work_details" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->work_details->caption() ?><?php echo ($personal_info->work_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->work_details->cellAttributes() ?>>
<span id="el_personal_info_work_details">
<input type="text" data-table="personal_info" data-field="x_work_details" name="x_work_details" id="x_work_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->work_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->work_details->EditValue ?>"<?php echo $personal_info->work_details->editAttributes() ?>>
</span>
<?php echo $personal_info->work_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_personal_info_status" for="x_status" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->status->caption() ?><?php echo ($personal_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->status->cellAttributes() ?>>
<span id="el_personal_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_status" data-value-separator="<?php echo $personal_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $personal_info->status->editAttributes() ?>>
		<?php echo $personal_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $personal_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label id="elh_personal_info_gst" for="x_gst" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->gst->caption() ?><?php echo ($personal_info->gst->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->gst->cellAttributes() ?>>
<span id="el_personal_info_gst">
<input type="text" data-table="personal_info" data-field="x_gst" name="x_gst" id="x_gst" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($personal_info->gst->getPlaceHolder()) ?>" value="<?php echo $personal_info->gst->EditValue ?>"<?php echo $personal_info->gst->editAttributes() ?>>
</span>
<?php echo $personal_info->gst->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label id="elh_personal_info_aadhaar_no" for="x_aadhaar_no" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->aadhaar_no->caption() ?><?php echo ($personal_info->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->aadhaar_no->cellAttributes() ?>>
<span id="el_personal_info_aadhaar_no">
<input type="text" data-table="personal_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($personal_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->aadhaar_no->EditValue ?>"<?php echo $personal_info->aadhaar_no->editAttributes() ?>>
</span>
<?php echo $personal_info->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label id="elh_personal_info_pan_no" for="x_pan_no" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->pan_no->caption() ?><?php echo ($personal_info->pan_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->pan_no->cellAttributes() ?>>
<span id="el_personal_info_pan_no">
<input type="text" data-table="personal_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($personal_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->pan_no->EditValue ?>"<?php echo $personal_info->pan_no->editAttributes() ?>>
</span>
<?php echo $personal_info->pan_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->reference_details->Visible) { // reference_details ?>
	<div id="r_reference_details" class="form-group row">
		<label id="elh_personal_info_reference_details" for="x_reference_details" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->reference_details->caption() ?><?php echo ($personal_info->reference_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->reference_details->cellAttributes() ?>>
<span id="el_personal_info_reference_details">
<input type="text" data-table="personal_info" data-field="x_reference_details" name="x_reference_details" id="x_reference_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->reference_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->reference_details->EditValue ?>"<?php echo $personal_info->reference_details->editAttributes() ?>>
</span>
<?php echo $personal_info->reference_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label id="elh_personal_info_other_details" for="x_other_details" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->other_details->caption() ?><?php echo ($personal_info->other_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->other_details->cellAttributes() ?>>
<span id="el_personal_info_other_details">
<textarea data-table="personal_info" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($personal_info->other_details->getPlaceHolder()) ?>"<?php echo $personal_info->other_details->editAttributes() ?>><?php echo $personal_info->other_details->EditValue ?></textarea>
</span>
<?php echo $personal_info->other_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_name->Visible) { // bank_name ?>
	<div id="r_bank_name" class="form-group row">
		<label id="elh_personal_info_bank_name" for="x_bank_name" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->bank_name->caption() ?><?php echo ($personal_info->bank_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->bank_name->cellAttributes() ?>>
<span id="el_personal_info_bank_name">
<input type="text" data-table="personal_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->bank_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_name->EditValue ?>"<?php echo $personal_info->bank_name->editAttributes() ?>>
</span>
<?php echo $personal_info->bank_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div id="r_bank_ifsc_code" class="form-group row">
		<label id="elh_personal_info_bank_ifsc_code" for="x_bank_ifsc_code" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->bank_ifsc_code->caption() ?><?php echo ($personal_info->bank_ifsc_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->bank_ifsc_code->cellAttributes() ?>>
<span id="el_personal_info_bank_ifsc_code">
<input type="text" data-table="personal_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($personal_info->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_ifsc_code->EditValue ?>"<?php echo $personal_info->bank_ifsc_code->editAttributes() ?>>
</span>
<?php echo $personal_info->bank_ifsc_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_account_no->Visible) { // bank_account_no ?>
	<div id="r_bank_account_no" class="form-group row">
		<label id="elh_personal_info_bank_account_no" for="x_bank_account_no" class="<?php echo $personal_info_add->LeftColumnClass ?>"><?php echo $personal_info->bank_account_no->caption() ?><?php echo ($personal_info->bank_account_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $personal_info_add->RightColumnClass ?>"><div<?php echo $personal_info->bank_account_no->cellAttributes() ?>>
<span id="el_personal_info_bank_account_no">
<input type="text" data-table="personal_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($personal_info->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_account_no->EditValue ?>"<?php echo $personal_info->bank_account_no->editAttributes() ?>>
</span>
<?php echo $personal_info->bank_account_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$personal_info_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $personal_info_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $personal_info_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$personal_info_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$personal_info_add->terminate();
?>