<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$personal_info_addopt = new personal_info_addopt();

// Run the page
$personal_info_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$personal_info_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fpersonal_infoaddopt = currentForm = new ew.Form("fpersonal_infoaddopt", "addopt");

// Validate form
fpersonal_infoaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($personal_info_addopt->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->formal_name->caption(), $personal_info->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->gender->Required) { ?>
			elm = this.getElements("x" + infix + "_gender");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->gender->caption(), $personal_info->gender->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile->caption(), $personal_info->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->mobile->errorMessage()) ?>");
		<?php if ($personal_info_addopt->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->_email->caption(), $personal_info->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->_email->errorMessage()) ?>");
		<?php if ($personal_info_addopt->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->address->caption(), $personal_info->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->country->caption(), $personal_info->country->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->state->Required) { ?>
			elm = this.getElements("x" + infix + "_state");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->state->caption(), $personal_info->state->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->city->caption(), $personal_info->city->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->city_name->Required) { ?>
			elm = this.getElements("x" + infix + "_city_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->city_name->caption(), $personal_info->city_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->dob->caption(), $personal_info->dob->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dob");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->dob->errorMessage()) ?>");
		<?php if ($personal_info_addopt->dom->Required) { ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->dom->caption(), $personal_info->dom->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dom");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->dom->errorMessage()) ?>");
		<?php if ($personal_info_addopt->marital_status->Required) { ?>
			elm = this.getElements("x" + infix + "_marital_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->marital_status->caption(), $personal_info->marital_status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->spouse_details->Required) { ?>
			elm = this.getElements("x" + infix + "_spouse_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->spouse_details->caption(), $personal_info->spouse_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $personal_info->image->caption(), $personal_info->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->father_name->Required) { ?>
			elm = this.getElements("x" + infix + "_father_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->father_name->caption(), $personal_info->father_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->mother_name->Required) { ?>
			elm = this.getElements("x" + infix + "_mother_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mother_name->caption(), $personal_info->mother_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->permanent_address->Required) { ?>
			elm = this.getElements("x" + infix + "_permanent_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->permanent_address->caption(), $personal_info->permanent_address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->mobile_other->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_other");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile_other->caption(), $personal_info->mobile_other->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->mobile_family->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_family");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile_family->caption(), $personal_info->mobile_family->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->emergency_details->Required) { ?>
			elm = this.getElements("x" + infix + "_emergency_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->emergency_details->caption(), $personal_info->emergency_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->annual_income->Required) { ?>
			elm = this.getElements("x" + infix + "_annual_income");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->annual_income->caption(), $personal_info->annual_income->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_annual_income");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->annual_income->errorMessage()) ?>");
		<?php if ($personal_info_addopt->work_details->Required) { ?>
			elm = this.getElements("x" + infix + "_work_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->work_details->caption(), $personal_info->work_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->status->caption(), $personal_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->gst->Required) { ?>
			elm = this.getElements("x" + infix + "_gst");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->gst->caption(), $personal_info->gst->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->aadhaar_no->caption(), $personal_info->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.checkByRegEx(elm.value, /^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/))
				return this.onError(elm, "<?php echo JsEncode($personal_info->aadhaar_no->errorMessage()) ?>");
		<?php if ($personal_info_addopt->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->pan_no->caption(), $personal_info->pan_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
				return this.onError(elm, "<?php echo JsEncode($personal_info->pan_no->errorMessage()) ?>");
		<?php if ($personal_info_addopt->id_proof->Required) { ?>
			felm = this.getElements("x" + infix + "_id_proof");
			elm = this.getElements("fn_x" + infix + "_id_proof");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $personal_info->id_proof->caption(), $personal_info->id_proof->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->reference_details->Required) { ?>
			elm = this.getElements("x" + infix + "_reference_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->reference_details->caption(), $personal_info->reference_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->other_details->caption(), $personal_info->other_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->bank_name->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_name->caption(), $personal_info->bank_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->bank_ifsc_code->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_ifsc_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_ifsc_code->caption(), $personal_info->bank_ifsc_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->bank_account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_account_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_account_no->caption(), $personal_info->bank_account_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->operator->caption(), $personal_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($personal_info_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->datetime->caption(), $personal_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpersonal_infoaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpersonal_infoaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpersonal_infoaddopt.lists["x_gender"] = <?php echo $personal_info_addopt->gender->Lookup->toClientList() ?>;
fpersonal_infoaddopt.lists["x_gender"].options = <?php echo JsonEncode($personal_info_addopt->gender->options(FALSE, TRUE)) ?>;
fpersonal_infoaddopt.lists["x_country"] = <?php echo $personal_info_addopt->country->Lookup->toClientList() ?>;
fpersonal_infoaddopt.lists["x_country"].options = <?php echo JsonEncode($personal_info_addopt->country->lookupOptions()) ?>;
fpersonal_infoaddopt.lists["x_state"] = <?php echo $personal_info_addopt->state->Lookup->toClientList() ?>;
fpersonal_infoaddopt.lists["x_state"].options = <?php echo JsonEncode($personal_info_addopt->state->lookupOptions()) ?>;
fpersonal_infoaddopt.lists["x_city"] = <?php echo $personal_info_addopt->city->Lookup->toClientList() ?>;
fpersonal_infoaddopt.lists["x_city"].options = <?php echo JsonEncode($personal_info_addopt->city->lookupOptions()) ?>;
fpersonal_infoaddopt.lists["x_marital_status"] = <?php echo $personal_info_addopt->marital_status->Lookup->toClientList() ?>;
fpersonal_infoaddopt.lists["x_marital_status"].options = <?php echo JsonEncode($personal_info_addopt->marital_status->options(FALSE, TRUE)) ?>;
fpersonal_infoaddopt.lists["x_status"] = <?php echo $personal_info_addopt->status->Lookup->toClientList() ?>;
fpersonal_infoaddopt.lists["x_status"].options = <?php echo JsonEncode($personal_info_addopt->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $personal_info_addopt->showPageHeader(); ?>
<?php
$personal_info_addopt->showMessage();
?>
<form name="fpersonal_infoaddopt" id="fpersonal_infoaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($personal_info_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $personal_info_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $personal_info_addopt->TableVar ?>">
<?php if ($personal_info->formal_name->Visible) { // formal_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_formal_name"><?php echo $personal_info->formal_name->caption() ?><?php echo ($personal_info->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($personal_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->formal_name->EditValue ?>"<?php echo $personal_info->formal_name->editAttributes() ?>>
<?php echo $personal_info->formal_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->gender->Visible) { // gender ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_gender"><?php echo $personal_info->gender->caption() ?><?php echo ($personal_info->gender->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_gender" data-value-separator="<?php echo $personal_info->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $personal_info->gender->editAttributes() ?>>
		<?php echo $personal_info->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
<?php echo $personal_info->gender->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile->Visible) { // mobile ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile"><?php echo $personal_info->mobile->caption() ?><?php echo ($personal_info->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($personal_info->mobile->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile->EditValue ?>"<?php echo $personal_info->mobile->editAttributes() ?>>
<?php echo $personal_info->mobile->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->_email->Visible) { // email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__email"><?php echo $personal_info->_email->caption() ?><?php echo ($personal_info->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($personal_info->_email->getPlaceHolder()) ?>" value="<?php echo $personal_info->_email->EditValue ?>"<?php echo $personal_info->_email->editAttributes() ?>>
<?php echo $personal_info->_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->address->Visible) { // address ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_address"><?php echo $personal_info->address->caption() ?><?php echo ($personal_info->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_address" name="x_address" id="x_address" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->address->getPlaceHolder()) ?>" value="<?php echo $personal_info->address->EditValue ?>"<?php echo $personal_info->address->editAttributes() ?>>
<?php echo $personal_info->address->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->country->Visible) { // country ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_country"><?php echo $personal_info->country->caption() ?><?php echo ($personal_info->country->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $personal_info->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$personal_info->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_country" data-value-separator="<?php echo $personal_info->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $personal_info->country->editAttributes() ?>>
		<?php echo $personal_info->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $personal_info->country->Lookup->getParamTag("p_x_country") ?>
<?php echo $personal_info->country->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->state->Visible) { // state ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_state"><?php echo $personal_info->state->caption() ?><?php echo ($personal_info->state->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<?php $personal_info->state->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$personal_info->state->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_state" data-value-separator="<?php echo $personal_info->state->displayValueSeparatorAttribute() ?>" id="x_state" name="x_state"<?php echo $personal_info->state->editAttributes() ?>>
		<?php echo $personal_info->state->selectOptionListHtml("x_state") ?>
	</select>
</div>
<?php echo $personal_info->state->Lookup->getParamTag("p_x_state") ?>
<?php echo $personal_info->state->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->city->Visible) { // city ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_city"><?php echo $personal_info->city->caption() ?><?php echo ($personal_info->city->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_city" data-value-separator="<?php echo $personal_info->city->displayValueSeparatorAttribute() ?>" id="x_city" name="x_city"<?php echo $personal_info->city->editAttributes() ?>>
		<?php echo $personal_info->city->selectOptionListHtml("x_city") ?>
	</select>
</div>
<?php echo $personal_info->city->Lookup->getParamTag("p_x_city") ?>
<?php echo $personal_info->city->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->city_name->Visible) { // city_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_city_name"><?php echo $personal_info->city_name->caption() ?><?php echo ($personal_info->city_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_city_name" name="x_city_name" id="x_city_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->city_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->city_name->EditValue ?>"<?php echo $personal_info->city_name->editAttributes() ?>>
<?php echo $personal_info->city_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->dob->Visible) { // dob ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_dob"><?php echo $personal_info->dob->caption() ?><?php echo ($personal_info->dob->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_dob" data-format="2" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($personal_info->dob->getPlaceHolder()) ?>" value="<?php echo $personal_info->dob->EditValue ?>"<?php echo $personal_info->dob->editAttributes() ?>>
<?php if (!$personal_info->dob->ReadOnly && !$personal_info->dob->Disabled && !isset($personal_info->dob->EditAttrs["readonly"]) && !isset($personal_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infoaddopt", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
<?php echo $personal_info->dob->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->dom->Visible) { // dom ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_dom"><?php echo $personal_info->dom->caption() ?><?php echo ($personal_info->dom->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_dom" data-format="2" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($personal_info->dom->getPlaceHolder()) ?>" value="<?php echo $personal_info->dom->EditValue ?>"<?php echo $personal_info->dom->editAttributes() ?>>
<?php if (!$personal_info->dom->ReadOnly && !$personal_info->dom->Disabled && !isset($personal_info->dom->EditAttrs["readonly"]) && !isset($personal_info->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infoaddopt", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
<?php echo $personal_info->dom->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->marital_status->Visible) { // marital_status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_marital_status"><?php echo $personal_info->marital_status->caption() ?><?php echo ($personal_info->marital_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_marital_status" data-value-separator="<?php echo $personal_info->marital_status->displayValueSeparatorAttribute() ?>" id="x_marital_status" name="x_marital_status"<?php echo $personal_info->marital_status->editAttributes() ?>>
		<?php echo $personal_info->marital_status->selectOptionListHtml("x_marital_status") ?>
	</select>
</div>
<?php echo $personal_info->marital_status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->spouse_details->Visible) { // spouse_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_spouse_details"><?php echo $personal_info->spouse_details->caption() ?><?php echo ($personal_info->spouse_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_spouse_details" name="x_spouse_details" id="x_spouse_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->spouse_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->spouse_details->EditValue ?>"<?php echo $personal_info->spouse_details->editAttributes() ?>>
<?php echo $personal_info->spouse_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->image->Visible) { // image ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $personal_info->image->caption() ?><?php echo ($personal_info->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_image">
<span title="<?php echo $personal_info->image->title() ? $personal_info->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($personal_info->image->ReadOnly || $personal_info->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="personal_info" data-field="x_image" name="x_image" id="x_image"<?php echo $personal_info->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $personal_info->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="48">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $personal_info->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $personal_info->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $personal_info->image->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->father_name->Visible) { // father_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_father_name"><?php echo $personal_info->father_name->caption() ?><?php echo ($personal_info->father_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->father_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->father_name->EditValue ?>"<?php echo $personal_info->father_name->editAttributes() ?>>
<?php echo $personal_info->father_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->mother_name->Visible) { // mother_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mother_name"><?php echo $personal_info->mother_name->caption() ?><?php echo ($personal_info->mother_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_mother_name" name="x_mother_name" id="x_mother_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->mother_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->mother_name->EditValue ?>"<?php echo $personal_info->mother_name->editAttributes() ?>>
<?php echo $personal_info->mother_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->permanent_address->Visible) { // permanent_address ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_permanent_address"><?php echo $personal_info->permanent_address->caption() ?><?php echo ($personal_info->permanent_address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->permanent_address->getPlaceHolder()) ?>" value="<?php echo $personal_info->permanent_address->EditValue ?>"<?php echo $personal_info->permanent_address->editAttributes() ?>>
<?php echo $personal_info->permanent_address->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile_other->Visible) { // mobile_other ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile_other"><?php echo $personal_info->mobile_other->caption() ?><?php echo ($personal_info->mobile_other->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_mobile_other" name="x_mobile_other" id="x_mobile_other" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($personal_info->mobile_other->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile_other->EditValue ?>"<?php echo $personal_info->mobile_other->editAttributes() ?>>
<?php echo $personal_info->mobile_other->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile_family->Visible) { // mobile_family ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile_family"><?php echo $personal_info->mobile_family->caption() ?><?php echo ($personal_info->mobile_family->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_mobile_family" name="x_mobile_family" id="x_mobile_family" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->mobile_family->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile_family->EditValue ?>"<?php echo $personal_info->mobile_family->editAttributes() ?>>
<?php echo $personal_info->mobile_family->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->emergency_details->Visible) { // emergency_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_emergency_details"><?php echo $personal_info->emergency_details->caption() ?><?php echo ($personal_info->emergency_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_emergency_details" name="x_emergency_details" id="x_emergency_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->emergency_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->emergency_details->EditValue ?>"<?php echo $personal_info->emergency_details->editAttributes() ?>>
<?php echo $personal_info->emergency_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->annual_income->Visible) { // annual_income ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_annual_income"><?php echo $personal_info->annual_income->caption() ?><?php echo ($personal_info->annual_income->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_annual_income" name="x_annual_income" id="x_annual_income" size="30" placeholder="<?php echo HtmlEncode($personal_info->annual_income->getPlaceHolder()) ?>" value="<?php echo $personal_info->annual_income->EditValue ?>"<?php echo $personal_info->annual_income->editAttributes() ?>>
<?php echo $personal_info->annual_income->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->work_details->Visible) { // work_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_work_details"><?php echo $personal_info->work_details->caption() ?><?php echo ($personal_info->work_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_work_details" name="x_work_details" id="x_work_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->work_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->work_details->EditValue ?>"<?php echo $personal_info->work_details->editAttributes() ?>>
<?php echo $personal_info->work_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $personal_info->status->caption() ?><?php echo ($personal_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_status" data-value-separator="<?php echo $personal_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $personal_info->status->editAttributes() ?>>
		<?php echo $personal_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $personal_info->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->gst->Visible) { // gst ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_gst"><?php echo $personal_info->gst->caption() ?><?php echo ($personal_info->gst->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_gst" name="x_gst" id="x_gst" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($personal_info->gst->getPlaceHolder()) ?>" value="<?php echo $personal_info->gst->EditValue ?>"<?php echo $personal_info->gst->editAttributes() ?>>
<?php echo $personal_info->gst->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_aadhaar_no"><?php echo $personal_info->aadhaar_no->caption() ?><?php echo ($personal_info->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($personal_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->aadhaar_no->EditValue ?>"<?php echo $personal_info->aadhaar_no->editAttributes() ?>>
<?php echo $personal_info->aadhaar_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->pan_no->Visible) { // pan_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_pan_no"><?php echo $personal_info->pan_no->caption() ?><?php echo ($personal_info->pan_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($personal_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->pan_no->EditValue ?>"<?php echo $personal_info->pan_no->editAttributes() ?>>
<?php echo $personal_info->pan_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->id_proof->Visible) { // id_proof ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $personal_info->id_proof->caption() ?><?php echo ($personal_info->id_proof->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="fd_x_id_proof">
<span title="<?php echo $personal_info->id_proof->title() ? $personal_info->id_proof->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($personal_info->id_proof->ReadOnly || $personal_info->id_proof->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="personal_info" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" multiple="multiple"<?php echo $personal_info->id_proof->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?php echo $personal_info->id_proof->Upload->FileName ?>">
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="0">
<input type="hidden" name="fs_x_id_proof" id= "fs_x_id_proof" value="255">
<input type="hidden" name="fx_x_id_proof" id= "fx_x_id_proof" value="<?php echo $personal_info->id_proof->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_id_proof" id= "fm_x_id_proof" value="<?php echo $personal_info->id_proof->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_id_proof" id= "fc_x_id_proof" value="<?php echo $personal_info->id_proof->UploadMaxFileCount ?>">
</div>
<table id="ft_x_id_proof" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
<?php echo $personal_info->id_proof->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->reference_details->Visible) { // reference_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_reference_details"><?php echo $personal_info->reference_details->caption() ?><?php echo ($personal_info->reference_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_reference_details" name="x_reference_details" id="x_reference_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->reference_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->reference_details->EditValue ?>"<?php echo $personal_info->reference_details->editAttributes() ?>>
<?php echo $personal_info->reference_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->other_details->Visible) { // other_details ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_other_details"><?php echo $personal_info->other_details->caption() ?><?php echo ($personal_info->other_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="personal_info" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($personal_info->other_details->getPlaceHolder()) ?>"<?php echo $personal_info->other_details->editAttributes() ?>><?php echo $personal_info->other_details->EditValue ?></textarea>
<?php echo $personal_info->other_details->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_name->Visible) { // bank_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_bank_name"><?php echo $personal_info->bank_name->caption() ?><?php echo ($personal_info->bank_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->bank_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_name->EditValue ?>"<?php echo $personal_info->bank_name->editAttributes() ?>>
<?php echo $personal_info->bank_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_bank_ifsc_code"><?php echo $personal_info->bank_ifsc_code->caption() ?><?php echo ($personal_info->bank_ifsc_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($personal_info->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_ifsc_code->EditValue ?>"<?php echo $personal_info->bank_ifsc_code->editAttributes() ?>>
<?php echo $personal_info->bank_ifsc_code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_account_no->Visible) { // bank_account_no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_bank_account_no"><?php echo $personal_info->bank_account_no->caption() ?><?php echo ($personal_info->bank_account_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="personal_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($personal_info->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_account_no->EditValue ?>"<?php echo $personal_info->bank_account_no->editAttributes() ?>>
<?php echo $personal_info->bank_account_no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($personal_info->operator->Visible) { // operator ?>
	<input type="hidden" data-table="personal_info" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($personal_info->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($personal_info->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="personal_info" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($personal_info->datetime->CurrentValue) ?>">
	<?php if (!$personal_info->datetime->ReadOnly && !$personal_info->datetime->Disabled && !isset($personal_info->datetime->EditAttrs["readonly"]) && !isset($personal_info->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fpersonal_infoaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$personal_info_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$personal_info_addopt->terminate();
?>