<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$personal_info_list = new personal_info_list();

// Run the page
$personal_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$personal_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$personal_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpersonal_infolist = currentForm = new ew.Form("fpersonal_infolist", "list");
fpersonal_infolist.formKeyCountName = '<?php echo $personal_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpersonal_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpersonal_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpersonal_infolist.lists["x_gender"] = <?php echo $personal_info_list->gender->Lookup->toClientList() ?>;
fpersonal_infolist.lists["x_gender"].options = <?php echo JsonEncode($personal_info_list->gender->options(FALSE, TRUE)) ?>;
fpersonal_infolist.lists["x_country"] = <?php echo $personal_info_list->country->Lookup->toClientList() ?>;
fpersonal_infolist.lists["x_country"].options = <?php echo JsonEncode($personal_info_list->country->lookupOptions()) ?>;
fpersonal_infolist.lists["x_state"] = <?php echo $personal_info_list->state->Lookup->toClientList() ?>;
fpersonal_infolist.lists["x_state"].options = <?php echo JsonEncode($personal_info_list->state->lookupOptions()) ?>;
fpersonal_infolist.lists["x_city"] = <?php echo $personal_info_list->city->Lookup->toClientList() ?>;
fpersonal_infolist.lists["x_city"].options = <?php echo JsonEncode($personal_info_list->city->lookupOptions()) ?>;
fpersonal_infolist.lists["x_marital_status"] = <?php echo $personal_info_list->marital_status->Lookup->toClientList() ?>;
fpersonal_infolist.lists["x_marital_status"].options = <?php echo JsonEncode($personal_info_list->marital_status->options(FALSE, TRUE)) ?>;

// Form object for search
var fpersonal_infolistsrch = currentSearchForm = new ew.Form("fpersonal_infolistsrch");

// Filters
fpersonal_infolistsrch.filterList = <?php echo $personal_info_list->getFilterList() ?>;

// Init search panel as collapsed
fpersonal_infolistsrch.initSearchPanel = true;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$personal_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($personal_info_list->TotalRecs > 0 && $personal_info_list->ExportOptions->visible()) { ?>
<?php $personal_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($personal_info_list->ImportOptions->visible()) { ?>
<?php $personal_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($personal_info_list->SearchOptions->visible()) { ?>
<?php $personal_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($personal_info_list->FilterOptions->visible()) { ?>
<?php $personal_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$personal_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$personal_info->isExport() && !$personal_info->CurrentAction) { ?>
<form name="fpersonal_infolistsrch" id="fpersonal_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($personal_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpersonal_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="personal_info">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($personal_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($personal_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $personal_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($personal_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($personal_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($personal_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($personal_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $personal_info_list->showPageHeader(); ?>
<?php
$personal_info_list->showMessage();
?>
<?php if ($personal_info_list->TotalRecs > 0 || $personal_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($personal_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> personal_info">
<?php if (!$personal_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$personal_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($personal_info_list->Pager)) $personal_info_list->Pager = new PrevNextPager($personal_info_list->StartRec, $personal_info_list->DisplayRecs, $personal_info_list->TotalRecs, $personal_info_list->AutoHidePager) ?>
<?php if ($personal_info_list->Pager->RecordCount > 0 && $personal_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($personal_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $personal_info_list->pageUrl() ?>start=<?php echo $personal_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($personal_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $personal_info_list->pageUrl() ?>start=<?php echo $personal_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $personal_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($personal_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $personal_info_list->pageUrl() ?>start=<?php echo $personal_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($personal_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $personal_info_list->pageUrl() ?>start=<?php echo $personal_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $personal_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($personal_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $personal_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $personal_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $personal_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($personal_info_list->TotalRecs > 0 && (!$personal_info_list->AutoHidePageSizeSelector || $personal_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="personal_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($personal_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($personal_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($personal_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($personal_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $personal_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpersonal_infolist" id="fpersonal_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($personal_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $personal_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_personal_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($personal_info_list->TotalRecs > 0 || $personal_info->isGridEdit()) { ?>
<table id="tbl_personal_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$personal_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$personal_info_list->renderListOptions();

// Render list options (header, left)
$personal_info_list->ListOptions->render("header", "left");
?>
<?php if ($personal_info->id->Visible) { // id ?>
	<?php if ($personal_info->sortUrl($personal_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $personal_info->id->headerCellClass() ?>"><div id="elh_personal_info_id" class="personal_info_id"><div class="ew-table-header-caption"><?php echo $personal_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $personal_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->id) ?>',1);"><div id="elh_personal_info_id" class="personal_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->formal_name->Visible) { // formal_name ?>
	<?php if ($personal_info->sortUrl($personal_info->formal_name) == "") { ?>
		<th data-name="formal_name" class="<?php echo $personal_info->formal_name->headerCellClass() ?>"><div id="elh_personal_info_formal_name" class="personal_info_formal_name"><div class="ew-table-header-caption"><?php echo $personal_info->formal_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="formal_name" class="<?php echo $personal_info->formal_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->formal_name) ?>',1);"><div id="elh_personal_info_formal_name" class="personal_info_formal_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->formal_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->formal_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->formal_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->gender->Visible) { // gender ?>
	<?php if ($personal_info->sortUrl($personal_info->gender) == "") { ?>
		<th data-name="gender" class="<?php echo $personal_info->gender->headerCellClass() ?>"><div id="elh_personal_info_gender" class="personal_info_gender"><div class="ew-table-header-caption"><?php echo $personal_info->gender->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gender" class="<?php echo $personal_info->gender->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->gender) ?>',1);"><div id="elh_personal_info_gender" class="personal_info_gender">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->gender->caption() ?></span><span class="ew-table-header-sort"><?php if ($personal_info->gender->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->gender->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->address->Visible) { // address ?>
	<?php if ($personal_info->sortUrl($personal_info->address) == "") { ?>
		<th data-name="address" class="<?php echo $personal_info->address->headerCellClass() ?>"><div id="elh_personal_info_address" class="personal_info_address"><div class="ew-table-header-caption"><?php echo $personal_info->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $personal_info->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->address) ?>',1);"><div id="elh_personal_info_address" class="personal_info_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->country->Visible) { // country ?>
	<?php if ($personal_info->sortUrl($personal_info->country) == "") { ?>
		<th data-name="country" class="<?php echo $personal_info->country->headerCellClass() ?>"><div id="elh_personal_info_country" class="personal_info_country"><div class="ew-table-header-caption"><?php echo $personal_info->country->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="country" class="<?php echo $personal_info->country->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->country) ?>',1);"><div id="elh_personal_info_country" class="personal_info_country">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->country->caption() ?></span><span class="ew-table-header-sort"><?php if ($personal_info->country->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->country->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->state->Visible) { // state ?>
	<?php if ($personal_info->sortUrl($personal_info->state) == "") { ?>
		<th data-name="state" class="<?php echo $personal_info->state->headerCellClass() ?>"><div id="elh_personal_info_state" class="personal_info_state"><div class="ew-table-header-caption"><?php echo $personal_info->state->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="state" class="<?php echo $personal_info->state->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->state) ?>',1);"><div id="elh_personal_info_state" class="personal_info_state">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->state->caption() ?></span><span class="ew-table-header-sort"><?php if ($personal_info->state->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->state->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->city->Visible) { // city ?>
	<?php if ($personal_info->sortUrl($personal_info->city) == "") { ?>
		<th data-name="city" class="<?php echo $personal_info->city->headerCellClass() ?>"><div id="elh_personal_info_city" class="personal_info_city"><div class="ew-table-header-caption"><?php echo $personal_info->city->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city" class="<?php echo $personal_info->city->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->city) ?>',1);"><div id="elh_personal_info_city" class="personal_info_city">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->city->caption() ?></span><span class="ew-table-header-sort"><?php if ($personal_info->city->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->city->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->city_name->Visible) { // city_name ?>
	<?php if ($personal_info->sortUrl($personal_info->city_name) == "") { ?>
		<th data-name="city_name" class="<?php echo $personal_info->city_name->headerCellClass() ?>"><div id="elh_personal_info_city_name" class="personal_info_city_name"><div class="ew-table-header-caption"><?php echo $personal_info->city_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="city_name" class="<?php echo $personal_info->city_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->city_name) ?>',1);"><div id="elh_personal_info_city_name" class="personal_info_city_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->city_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->city_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->city_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->dob->Visible) { // dob ?>
	<?php if ($personal_info->sortUrl($personal_info->dob) == "") { ?>
		<th data-name="dob" class="<?php echo $personal_info->dob->headerCellClass() ?>"><div id="elh_personal_info_dob" class="personal_info_dob"><div class="ew-table-header-caption"><?php echo $personal_info->dob->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dob" class="<?php echo $personal_info->dob->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->dob) ?>',1);"><div id="elh_personal_info_dob" class="personal_info_dob">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->dob->caption() ?></span><span class="ew-table-header-sort"><?php if ($personal_info->dob->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->dob->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->dom->Visible) { // dom ?>
	<?php if ($personal_info->sortUrl($personal_info->dom) == "") { ?>
		<th data-name="dom" class="<?php echo $personal_info->dom->headerCellClass() ?>"><div id="elh_personal_info_dom" class="personal_info_dom"><div class="ew-table-header-caption"><?php echo $personal_info->dom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dom" class="<?php echo $personal_info->dom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->dom) ?>',1);"><div id="elh_personal_info_dom" class="personal_info_dom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->dom->caption() ?></span><span class="ew-table-header-sort"><?php if ($personal_info->dom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->dom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->marital_status->Visible) { // marital_status ?>
	<?php if ($personal_info->sortUrl($personal_info->marital_status) == "") { ?>
		<th data-name="marital_status" class="<?php echo $personal_info->marital_status->headerCellClass() ?>"><div id="elh_personal_info_marital_status" class="personal_info_marital_status"><div class="ew-table-header-caption"><?php echo $personal_info->marital_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="marital_status" class="<?php echo $personal_info->marital_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->marital_status) ?>',1);"><div id="elh_personal_info_marital_status" class="personal_info_marital_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->marital_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($personal_info->marital_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->marital_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->spouse_details->Visible) { // spouse_details ?>
	<?php if ($personal_info->sortUrl($personal_info->spouse_details) == "") { ?>
		<th data-name="spouse_details" class="<?php echo $personal_info->spouse_details->headerCellClass() ?>"><div id="elh_personal_info_spouse_details" class="personal_info_spouse_details"><div class="ew-table-header-caption"><?php echo $personal_info->spouse_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="spouse_details" class="<?php echo $personal_info->spouse_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->spouse_details) ?>',1);"><div id="elh_personal_info_spouse_details" class="personal_info_spouse_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->spouse_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->spouse_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->spouse_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->father_name->Visible) { // father_name ?>
	<?php if ($personal_info->sortUrl($personal_info->father_name) == "") { ?>
		<th data-name="father_name" class="<?php echo $personal_info->father_name->headerCellClass() ?>"><div id="elh_personal_info_father_name" class="personal_info_father_name"><div class="ew-table-header-caption"><?php echo $personal_info->father_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="father_name" class="<?php echo $personal_info->father_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->father_name) ?>',1);"><div id="elh_personal_info_father_name" class="personal_info_father_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->father_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->father_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->father_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->mother_name->Visible) { // mother_name ?>
	<?php if ($personal_info->sortUrl($personal_info->mother_name) == "") { ?>
		<th data-name="mother_name" class="<?php echo $personal_info->mother_name->headerCellClass() ?>"><div id="elh_personal_info_mother_name" class="personal_info_mother_name"><div class="ew-table-header-caption"><?php echo $personal_info->mother_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mother_name" class="<?php echo $personal_info->mother_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->mother_name) ?>',1);"><div id="elh_personal_info_mother_name" class="personal_info_mother_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->mother_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->mother_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->mother_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->permanent_address->Visible) { // permanent_address ?>
	<?php if ($personal_info->sortUrl($personal_info->permanent_address) == "") { ?>
		<th data-name="permanent_address" class="<?php echo $personal_info->permanent_address->headerCellClass() ?>"><div id="elh_personal_info_permanent_address" class="personal_info_permanent_address"><div class="ew-table-header-caption"><?php echo $personal_info->permanent_address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="permanent_address" class="<?php echo $personal_info->permanent_address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->permanent_address) ?>',1);"><div id="elh_personal_info_permanent_address" class="personal_info_permanent_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->permanent_address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->permanent_address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->permanent_address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->mobile_other->Visible) { // mobile_other ?>
	<?php if ($personal_info->sortUrl($personal_info->mobile_other) == "") { ?>
		<th data-name="mobile_other" class="<?php echo $personal_info->mobile_other->headerCellClass() ?>"><div id="elh_personal_info_mobile_other" class="personal_info_mobile_other"><div class="ew-table-header-caption"><?php echo $personal_info->mobile_other->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile_other" class="<?php echo $personal_info->mobile_other->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->mobile_other) ?>',1);"><div id="elh_personal_info_mobile_other" class="personal_info_mobile_other">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->mobile_other->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->mobile_other->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->mobile_other->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->mobile_family->Visible) { // mobile_family ?>
	<?php if ($personal_info->sortUrl($personal_info->mobile_family) == "") { ?>
		<th data-name="mobile_family" class="<?php echo $personal_info->mobile_family->headerCellClass() ?>"><div id="elh_personal_info_mobile_family" class="personal_info_mobile_family"><div class="ew-table-header-caption"><?php echo $personal_info->mobile_family->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile_family" class="<?php echo $personal_info->mobile_family->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->mobile_family) ?>',1);"><div id="elh_personal_info_mobile_family" class="personal_info_mobile_family">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->mobile_family->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->mobile_family->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->mobile_family->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->emergency_details->Visible) { // emergency_details ?>
	<?php if ($personal_info->sortUrl($personal_info->emergency_details) == "") { ?>
		<th data-name="emergency_details" class="<?php echo $personal_info->emergency_details->headerCellClass() ?>"><div id="elh_personal_info_emergency_details" class="personal_info_emergency_details"><div class="ew-table-header-caption"><?php echo $personal_info->emergency_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emergency_details" class="<?php echo $personal_info->emergency_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->emergency_details) ?>',1);"><div id="elh_personal_info_emergency_details" class="personal_info_emergency_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->emergency_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->emergency_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->emergency_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->annual_income->Visible) { // annual_income ?>
	<?php if ($personal_info->sortUrl($personal_info->annual_income) == "") { ?>
		<th data-name="annual_income" class="<?php echo $personal_info->annual_income->headerCellClass() ?>"><div id="elh_personal_info_annual_income" class="personal_info_annual_income"><div class="ew-table-header-caption"><?php echo $personal_info->annual_income->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="annual_income" class="<?php echo $personal_info->annual_income->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->annual_income) ?>',1);"><div id="elh_personal_info_annual_income" class="personal_info_annual_income">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->annual_income->caption() ?></span><span class="ew-table-header-sort"><?php if ($personal_info->annual_income->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->annual_income->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->work_details->Visible) { // work_details ?>
	<?php if ($personal_info->sortUrl($personal_info->work_details) == "") { ?>
		<th data-name="work_details" class="<?php echo $personal_info->work_details->headerCellClass() ?>"><div id="elh_personal_info_work_details" class="personal_info_work_details"><div class="ew-table-header-caption"><?php echo $personal_info->work_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="work_details" class="<?php echo $personal_info->work_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->work_details) ?>',1);"><div id="elh_personal_info_work_details" class="personal_info_work_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->work_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->work_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->work_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($personal_info->gst->Visible) { // gst ?>
	<?php if ($personal_info->sortUrl($personal_info->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $personal_info->gst->headerCellClass() ?>"><div id="elh_personal_info_gst" class="personal_info_gst"><div class="ew-table-header-caption"><?php echo $personal_info->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $personal_info->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $personal_info->SortUrl($personal_info->gst) ?>',1);"><div id="elh_personal_info_gst" class="personal_info_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $personal_info->gst->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($personal_info->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($personal_info->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$personal_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($personal_info->ExportAll && $personal_info->isExport()) {
	$personal_info_list->StopRec = $personal_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($personal_info_list->TotalRecs > $personal_info_list->StartRec + $personal_info_list->DisplayRecs - 1)
		$personal_info_list->StopRec = $personal_info_list->StartRec + $personal_info_list->DisplayRecs - 1;
	else
		$personal_info_list->StopRec = $personal_info_list->TotalRecs;
}
$personal_info_list->RecCnt = $personal_info_list->StartRec - 1;
if ($personal_info_list->Recordset && !$personal_info_list->Recordset->EOF) {
	$personal_info_list->Recordset->moveFirst();
	$selectLimit = $personal_info_list->UseSelectLimit;
	if (!$selectLimit && $personal_info_list->StartRec > 1)
		$personal_info_list->Recordset->move($personal_info_list->StartRec - 1);
} elseif (!$personal_info->AllowAddDeleteRow && $personal_info_list->StopRec == 0) {
	$personal_info_list->StopRec = $personal_info->GridAddRowCount;
}

// Initialize aggregate
$personal_info->RowType = ROWTYPE_AGGREGATEINIT;
$personal_info->resetAttributes();
$personal_info_list->renderRow();
while ($personal_info_list->RecCnt < $personal_info_list->StopRec) {
	$personal_info_list->RecCnt++;
	if ($personal_info_list->RecCnt >= $personal_info_list->StartRec) {
		$personal_info_list->RowCnt++;

		// Set up key count
		$personal_info_list->KeyCount = $personal_info_list->RowIndex;

		// Init row class and style
		$personal_info->resetAttributes();
		$personal_info->CssClass = "";
		if ($personal_info->isGridAdd()) {
		} else {
			$personal_info_list->loadRowValues($personal_info_list->Recordset); // Load row values
		}
		$personal_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$personal_info->RowAttrs = array_merge($personal_info->RowAttrs, array('data-rowindex'=>$personal_info_list->RowCnt, 'id'=>'r' . $personal_info_list->RowCnt . '_personal_info', 'data-rowtype'=>$personal_info->RowType));

		// Render row
		$personal_info_list->renderRow();

		// Render list options
		$personal_info_list->renderListOptions();
?>
	<tr<?php echo $personal_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$personal_info_list->ListOptions->render("body", "left", $personal_info_list->RowCnt);
?>
	<?php if ($personal_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $personal_info->id->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_id" class="personal_info_id">
<span<?php echo $personal_info->id->viewAttributes() ?>>
<?php echo $personal_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name"<?php echo $personal_info->formal_name->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_formal_name" class="personal_info_formal_name">
<span<?php echo $personal_info->formal_name->viewAttributes() ?>>
<?php echo $personal_info->formal_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->gender->Visible) { // gender ?>
		<td data-name="gender"<?php echo $personal_info->gender->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_gender" class="personal_info_gender">
<span<?php echo $personal_info->gender->viewAttributes() ?>>
<?php echo $personal_info->gender->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->address->Visible) { // address ?>
		<td data-name="address"<?php echo $personal_info->address->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_address" class="personal_info_address">
<span<?php echo $personal_info->address->viewAttributes() ?>>
<?php echo $personal_info->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->country->Visible) { // country ?>
		<td data-name="country"<?php echo $personal_info->country->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_country" class="personal_info_country">
<span<?php echo $personal_info->country->viewAttributes() ?>>
<?php echo $personal_info->country->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->state->Visible) { // state ?>
		<td data-name="state"<?php echo $personal_info->state->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_state" class="personal_info_state">
<span<?php echo $personal_info->state->viewAttributes() ?>>
<?php echo $personal_info->state->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->city->Visible) { // city ?>
		<td data-name="city"<?php echo $personal_info->city->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_city" class="personal_info_city">
<span<?php echo $personal_info->city->viewAttributes() ?>>
<?php echo $personal_info->city->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->city_name->Visible) { // city_name ?>
		<td data-name="city_name"<?php echo $personal_info->city_name->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_city_name" class="personal_info_city_name">
<span<?php echo $personal_info->city_name->viewAttributes() ?>>
<?php echo $personal_info->city_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->dob->Visible) { // dob ?>
		<td data-name="dob"<?php echo $personal_info->dob->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_dob" class="personal_info_dob">
<span<?php echo $personal_info->dob->viewAttributes() ?>>
<?php echo $personal_info->dob->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->dom->Visible) { // dom ?>
		<td data-name="dom"<?php echo $personal_info->dom->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_dom" class="personal_info_dom">
<span<?php echo $personal_info->dom->viewAttributes() ?>>
<?php echo $personal_info->dom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->marital_status->Visible) { // marital_status ?>
		<td data-name="marital_status"<?php echo $personal_info->marital_status->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_marital_status" class="personal_info_marital_status">
<span<?php echo $personal_info->marital_status->viewAttributes() ?>>
<?php echo $personal_info->marital_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->spouse_details->Visible) { // spouse_details ?>
		<td data-name="spouse_details"<?php echo $personal_info->spouse_details->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_spouse_details" class="personal_info_spouse_details">
<span<?php echo $personal_info->spouse_details->viewAttributes() ?>>
<?php echo $personal_info->spouse_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->father_name->Visible) { // father_name ?>
		<td data-name="father_name"<?php echo $personal_info->father_name->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_father_name" class="personal_info_father_name">
<span<?php echo $personal_info->father_name->viewAttributes() ?>>
<?php echo $personal_info->father_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->mother_name->Visible) { // mother_name ?>
		<td data-name="mother_name"<?php echo $personal_info->mother_name->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_mother_name" class="personal_info_mother_name">
<span<?php echo $personal_info->mother_name->viewAttributes() ?>>
<?php echo $personal_info->mother_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->permanent_address->Visible) { // permanent_address ?>
		<td data-name="permanent_address"<?php echo $personal_info->permanent_address->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_permanent_address" class="personal_info_permanent_address">
<span<?php echo $personal_info->permanent_address->viewAttributes() ?>>
<?php echo $personal_info->permanent_address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->mobile_other->Visible) { // mobile_other ?>
		<td data-name="mobile_other"<?php echo $personal_info->mobile_other->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_mobile_other" class="personal_info_mobile_other">
<span<?php echo $personal_info->mobile_other->viewAttributes() ?>>
<?php echo $personal_info->mobile_other->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->mobile_family->Visible) { // mobile_family ?>
		<td data-name="mobile_family"<?php echo $personal_info->mobile_family->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_mobile_family" class="personal_info_mobile_family">
<span<?php echo $personal_info->mobile_family->viewAttributes() ?>>
<?php echo $personal_info->mobile_family->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->emergency_details->Visible) { // emergency_details ?>
		<td data-name="emergency_details"<?php echo $personal_info->emergency_details->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_emergency_details" class="personal_info_emergency_details">
<span<?php echo $personal_info->emergency_details->viewAttributes() ?>>
<?php echo $personal_info->emergency_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->annual_income->Visible) { // annual_income ?>
		<td data-name="annual_income"<?php echo $personal_info->annual_income->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_annual_income" class="personal_info_annual_income">
<span<?php echo $personal_info->annual_income->viewAttributes() ?>>
<?php echo $personal_info->annual_income->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->work_details->Visible) { // work_details ?>
		<td data-name="work_details"<?php echo $personal_info->work_details->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_work_details" class="personal_info_work_details">
<span<?php echo $personal_info->work_details->viewAttributes() ?>>
<?php echo $personal_info->work_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($personal_info->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $personal_info->gst->cellAttributes() ?>>
<span id="el<?php echo $personal_info_list->RowCnt ?>_personal_info_gst" class="personal_info_gst">
<span<?php echo $personal_info->gst->viewAttributes() ?>>
<?php echo $personal_info->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$personal_info_list->ListOptions->render("body", "right", $personal_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$personal_info->isGridAdd())
		$personal_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$personal_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($personal_info_list->Recordset)
	$personal_info_list->Recordset->Close();
?>
<?php if (!$personal_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$personal_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($personal_info_list->Pager)) $personal_info_list->Pager = new PrevNextPager($personal_info_list->StartRec, $personal_info_list->DisplayRecs, $personal_info_list->TotalRecs, $personal_info_list->AutoHidePager) ?>
<?php if ($personal_info_list->Pager->RecordCount > 0 && $personal_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($personal_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $personal_info_list->pageUrl() ?>start=<?php echo $personal_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($personal_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $personal_info_list->pageUrl() ?>start=<?php echo $personal_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $personal_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($personal_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $personal_info_list->pageUrl() ?>start=<?php echo $personal_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($personal_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $personal_info_list->pageUrl() ?>start=<?php echo $personal_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $personal_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($personal_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $personal_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $personal_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $personal_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($personal_info_list->TotalRecs > 0 && (!$personal_info_list->AutoHidePageSizeSelector || $personal_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="personal_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($personal_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($personal_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($personal_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($personal_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $personal_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($personal_info_list->TotalRecs == 0 && !$personal_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $personal_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$personal_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$personal_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$personal_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_personal_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$personal_info_list->terminate();
?>