<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$personal_info_search = new personal_info_search();

// Run the page
$personal_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$personal_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($personal_info_search->IsModal) { ?>
var fpersonal_infosearch = currentAdvancedSearchForm = new ew.Form("fpersonal_infosearch", "search");
<?php } else { ?>
var fpersonal_infosearch = currentForm = new ew.Form("fpersonal_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
fpersonal_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpersonal_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpersonal_infosearch.lists["x_gender"] = <?php echo $personal_info_search->gender->Lookup->toClientList() ?>;
fpersonal_infosearch.lists["x_gender"].options = <?php echo JsonEncode($personal_info_search->gender->options(FALSE, TRUE)) ?>;
fpersonal_infosearch.lists["x_country"] = <?php echo $personal_info_search->country->Lookup->toClientList() ?>;
fpersonal_infosearch.lists["x_country"].options = <?php echo JsonEncode($personal_info_search->country->lookupOptions()) ?>;
fpersonal_infosearch.lists["x_state"] = <?php echo $personal_info_search->state->Lookup->toClientList() ?>;
fpersonal_infosearch.lists["x_state"].options = <?php echo JsonEncode($personal_info_search->state->lookupOptions()) ?>;
fpersonal_infosearch.lists["x_city"] = <?php echo $personal_info_search->city->Lookup->toClientList() ?>;
fpersonal_infosearch.lists["x_city"].options = <?php echo JsonEncode($personal_info_search->city->lookupOptions()) ?>;
fpersonal_infosearch.lists["x_marital_status"] = <?php echo $personal_info_search->marital_status->Lookup->toClientList() ?>;
fpersonal_infosearch.lists["x_marital_status"].options = <?php echo JsonEncode($personal_info_search->marital_status->options(FALSE, TRUE)) ?>;
fpersonal_infosearch.lists["x_status"] = <?php echo $personal_info_search->status->Lookup->toClientList() ?>;
fpersonal_infosearch.lists["x_status"].options = <?php echo JsonEncode($personal_info_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fpersonal_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_mobile");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($personal_info->mobile->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dob");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($personal_info->dob->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dom");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($personal_info->dom->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_annual_income");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($personal_info->annual_income->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_aadhaar_no");
	if (elm && !ew.checkByRegEx(elm.value, /^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/))
		return this.onError(elm, "<?php echo JsEncode($personal_info->aadhaar_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pan_no");
	if (elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
		return this.onError(elm, "<?php echo JsEncode($personal_info->pan_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($personal_info->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($personal_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $personal_info_search->showPageHeader(); ?>
<?php
$personal_info_search->showMessage();
?>
<form name="fpersonal_infosearch" id="fpersonal_infosearch" class="<?php echo $personal_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($personal_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $personal_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$personal_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($personal_info->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label for="x_formal_name" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_formal_name"><?php echo $personal_info->formal_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->formal_name->cellAttributes() ?>>
			<span id="el_personal_info_formal_name">
<input type="text" data-table="personal_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($personal_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->formal_name->EditValue ?>"<?php echo $personal_info->formal_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label for="x_gender" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_gender"><?php echo $personal_info->gender->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gender" id="z_gender" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->gender->cellAttributes() ?>>
			<span id="el_personal_info_gender">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_gender" data-value-separator="<?php echo $personal_info->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $personal_info->gender->editAttributes() ?>>
		<?php echo $personal_info->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_mobile"><?php echo $personal_info->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mobile" id="z_mobile" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->mobile->cellAttributes() ?>>
			<span id="el_personal_info_mobile">
<input type="text" data-table="personal_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($personal_info->mobile->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile->EditValue ?>"<?php echo $personal_info->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info__email"><?php echo $personal_info->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->_email->cellAttributes() ?>>
			<span id="el_personal_info__email">
<input type="text" data-table="personal_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($personal_info->_email->getPlaceHolder()) ?>" value="<?php echo $personal_info->_email->EditValue ?>"<?php echo $personal_info->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_address"><?php echo $personal_info->address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_address" id="z_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->address->cellAttributes() ?>>
			<span id="el_personal_info_address">
<input type="text" data-table="personal_info" data-field="x_address" name="x_address" id="x_address" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->address->getPlaceHolder()) ?>" value="<?php echo $personal_info->address->EditValue ?>"<?php echo $personal_info->address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->country->Visible) { // country ?>
	<div id="r_country" class="form-group row">
		<label for="x_country" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_country"><?php echo $personal_info->country->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_country" id="z_country" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->country->cellAttributes() ?>>
			<span id="el_personal_info_country">
<?php $personal_info->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$personal_info->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_country" data-value-separator="<?php echo $personal_info->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $personal_info->country->editAttributes() ?>>
		<?php echo $personal_info->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $personal_info->country->Lookup->getParamTag("p_x_country") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->state->Visible) { // state ?>
	<div id="r_state" class="form-group row">
		<label for="x_state" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_state"><?php echo $personal_info->state->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_state" id="z_state" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->state->cellAttributes() ?>>
			<span id="el_personal_info_state">
<?php $personal_info->state->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$personal_info->state->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_state" data-value-separator="<?php echo $personal_info->state->displayValueSeparatorAttribute() ?>" id="x_state" name="x_state"<?php echo $personal_info->state->editAttributes() ?>>
		<?php echo $personal_info->state->selectOptionListHtml("x_state") ?>
	</select>
</div>
<?php echo $personal_info->state->Lookup->getParamTag("p_x_state") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label for="x_city" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_city"><?php echo $personal_info->city->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_city" id="z_city" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->city->cellAttributes() ?>>
			<span id="el_personal_info_city">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_city" data-value-separator="<?php echo $personal_info->city->displayValueSeparatorAttribute() ?>" id="x_city" name="x_city"<?php echo $personal_info->city->editAttributes() ?>>
		<?php echo $personal_info->city->selectOptionListHtml("x_city") ?>
	</select>
</div>
<?php echo $personal_info->city->Lookup->getParamTag("p_x_city") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->city_name->Visible) { // city_name ?>
	<div id="r_city_name" class="form-group row">
		<label for="x_city_name" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_city_name"><?php echo $personal_info->city_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_city_name" id="z_city_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->city_name->cellAttributes() ?>>
			<span id="el_personal_info_city_name">
<input type="text" data-table="personal_info" data-field="x_city_name" name="x_city_name" id="x_city_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->city_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->city_name->EditValue ?>"<?php echo $personal_info->city_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label for="x_dob" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_dob"><?php echo $personal_info->dob->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dob" id="z_dob" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->dob->cellAttributes() ?>>
			<span id="el_personal_info_dob">
<input type="text" data-table="personal_info" data-field="x_dob" data-format="2" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($personal_info->dob->getPlaceHolder()) ?>" value="<?php echo $personal_info->dob->EditValue ?>"<?php echo $personal_info->dob->editAttributes() ?>>
<?php if (!$personal_info->dob->ReadOnly && !$personal_info->dob->Disabled && !isset($personal_info->dob->EditAttrs["readonly"]) && !isset($personal_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infosearch", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->dom->Visible) { // dom ?>
	<div id="r_dom" class="form-group row">
		<label for="x_dom" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_dom"><?php echo $personal_info->dom->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dom" id="z_dom" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->dom->cellAttributes() ?>>
			<span id="el_personal_info_dom">
<input type="text" data-table="personal_info" data-field="x_dom" data-format="2" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($personal_info->dom->getPlaceHolder()) ?>" value="<?php echo $personal_info->dom->EditValue ?>"<?php echo $personal_info->dom->editAttributes() ?>>
<?php if (!$personal_info->dom->ReadOnly && !$personal_info->dom->Disabled && !isset($personal_info->dom->EditAttrs["readonly"]) && !isset($personal_info->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infosearch", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->marital_status->Visible) { // marital_status ?>
	<div id="r_marital_status" class="form-group row">
		<label for="x_marital_status" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_marital_status"><?php echo $personal_info->marital_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_marital_status" id="z_marital_status" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->marital_status->cellAttributes() ?>>
			<span id="el_personal_info_marital_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_marital_status" data-value-separator="<?php echo $personal_info->marital_status->displayValueSeparatorAttribute() ?>" id="x_marital_status" name="x_marital_status"<?php echo $personal_info->marital_status->editAttributes() ?>>
		<?php echo $personal_info->marital_status->selectOptionListHtml("x_marital_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->spouse_details->Visible) { // spouse_details ?>
	<div id="r_spouse_details" class="form-group row">
		<label for="x_spouse_details" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_spouse_details"><?php echo $personal_info->spouse_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_spouse_details" id="z_spouse_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->spouse_details->cellAttributes() ?>>
			<span id="el_personal_info_spouse_details">
<input type="text" data-table="personal_info" data-field="x_spouse_details" name="x_spouse_details" id="x_spouse_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->spouse_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->spouse_details->EditValue ?>"<?php echo $personal_info->spouse_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_image"><?php echo $personal_info->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->image->cellAttributes() ?>>
			<span id="el_personal_info_image">
<input type="text" data-table="personal_info" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->image->getPlaceHolder()) ?>" value="<?php echo $personal_info->image->EditValue ?>"<?php echo $personal_info->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->father_name->Visible) { // father_name ?>
	<div id="r_father_name" class="form-group row">
		<label for="x_father_name" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_father_name"><?php echo $personal_info->father_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_father_name" id="z_father_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->father_name->cellAttributes() ?>>
			<span id="el_personal_info_father_name">
<input type="text" data-table="personal_info" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->father_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->father_name->EditValue ?>"<?php echo $personal_info->father_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mother_name->Visible) { // mother_name ?>
	<div id="r_mother_name" class="form-group row">
		<label for="x_mother_name" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_mother_name"><?php echo $personal_info->mother_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mother_name" id="z_mother_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->mother_name->cellAttributes() ?>>
			<span id="el_personal_info_mother_name">
<input type="text" data-table="personal_info" data-field="x_mother_name" name="x_mother_name" id="x_mother_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->mother_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->mother_name->EditValue ?>"<?php echo $personal_info->mother_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->permanent_address->Visible) { // permanent_address ?>
	<div id="r_permanent_address" class="form-group row">
		<label for="x_permanent_address" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_permanent_address"><?php echo $personal_info->permanent_address->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_permanent_address" id="z_permanent_address" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->permanent_address->cellAttributes() ?>>
			<span id="el_personal_info_permanent_address">
<input type="text" data-table="personal_info" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->permanent_address->getPlaceHolder()) ?>" value="<?php echo $personal_info->permanent_address->EditValue ?>"<?php echo $personal_info->permanent_address->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile_other->Visible) { // mobile_other ?>
	<div id="r_mobile_other" class="form-group row">
		<label for="x_mobile_other" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_mobile_other"><?php echo $personal_info->mobile_other->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile_other" id="z_mobile_other" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->mobile_other->cellAttributes() ?>>
			<span id="el_personal_info_mobile_other">
<input type="text" data-table="personal_info" data-field="x_mobile_other" name="x_mobile_other" id="x_mobile_other" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($personal_info->mobile_other->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile_other->EditValue ?>"<?php echo $personal_info->mobile_other->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile_family->Visible) { // mobile_family ?>
	<div id="r_mobile_family" class="form-group row">
		<label for="x_mobile_family" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_mobile_family"><?php echo $personal_info->mobile_family->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile_family" id="z_mobile_family" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->mobile_family->cellAttributes() ?>>
			<span id="el_personal_info_mobile_family">
<input type="text" data-table="personal_info" data-field="x_mobile_family" name="x_mobile_family" id="x_mobile_family" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->mobile_family->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile_family->EditValue ?>"<?php echo $personal_info->mobile_family->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->emergency_details->Visible) { // emergency_details ?>
	<div id="r_emergency_details" class="form-group row">
		<label for="x_emergency_details" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_emergency_details"><?php echo $personal_info->emergency_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_emergency_details" id="z_emergency_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->emergency_details->cellAttributes() ?>>
			<span id="el_personal_info_emergency_details">
<input type="text" data-table="personal_info" data-field="x_emergency_details" name="x_emergency_details" id="x_emergency_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->emergency_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->emergency_details->EditValue ?>"<?php echo $personal_info->emergency_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->annual_income->Visible) { // annual_income ?>
	<div id="r_annual_income" class="form-group row">
		<label for="x_annual_income" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_annual_income"><?php echo $personal_info->annual_income->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_annual_income" id="z_annual_income" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->annual_income->cellAttributes() ?>>
			<span id="el_personal_info_annual_income">
<input type="text" data-table="personal_info" data-field="x_annual_income" name="x_annual_income" id="x_annual_income" size="30" placeholder="<?php echo HtmlEncode($personal_info->annual_income->getPlaceHolder()) ?>" value="<?php echo $personal_info->annual_income->EditValue ?>"<?php echo $personal_info->annual_income->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->work_details->Visible) { // work_details ?>
	<div id="r_work_details" class="form-group row">
		<label for="x_work_details" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_work_details"><?php echo $personal_info->work_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_work_details" id="z_work_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->work_details->cellAttributes() ?>>
			<span id="el_personal_info_work_details">
<input type="text" data-table="personal_info" data-field="x_work_details" name="x_work_details" id="x_work_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->work_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->work_details->EditValue ?>"<?php echo $personal_info->work_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_status"><?php echo $personal_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->status->cellAttributes() ?>>
			<span id="el_personal_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_status" data-value-separator="<?php echo $personal_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $personal_info->status->editAttributes() ?>>
		<?php echo $personal_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label for="x_gst" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_gst"><?php echo $personal_info->gst->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gst" id="z_gst" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->gst->cellAttributes() ?>>
			<span id="el_personal_info_gst">
<input type="text" data-table="personal_info" data-field="x_gst" name="x_gst" id="x_gst" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($personal_info->gst->getPlaceHolder()) ?>" value="<?php echo $personal_info->gst->EditValue ?>"<?php echo $personal_info->gst->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label for="x_aadhaar_no" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_aadhaar_no"><?php echo $personal_info->aadhaar_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_aadhaar_no" id="z_aadhaar_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->aadhaar_no->cellAttributes() ?>>
			<span id="el_personal_info_aadhaar_no">
<input type="text" data-table="personal_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($personal_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->aadhaar_no->EditValue ?>"<?php echo $personal_info->aadhaar_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label for="x_pan_no" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_pan_no"><?php echo $personal_info->pan_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pan_no" id="z_pan_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->pan_no->cellAttributes() ?>>
			<span id="el_personal_info_pan_no">
<input type="text" data-table="personal_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($personal_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->pan_no->EditValue ?>"<?php echo $personal_info->pan_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_id_proof"><?php echo $personal_info->id_proof->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_id_proof" id="z_id_proof" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->id_proof->cellAttributes() ?>>
			<span id="el_personal_info_id_proof">
<input type="text" data-table="personal_info" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->id_proof->getPlaceHolder()) ?>" value="<?php echo $personal_info->id_proof->EditValue ?>"<?php echo $personal_info->id_proof->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->reference_details->Visible) { // reference_details ?>
	<div id="r_reference_details" class="form-group row">
		<label for="x_reference_details" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_reference_details"><?php echo $personal_info->reference_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_reference_details" id="z_reference_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->reference_details->cellAttributes() ?>>
			<span id="el_personal_info_reference_details">
<input type="text" data-table="personal_info" data-field="x_reference_details" name="x_reference_details" id="x_reference_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->reference_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->reference_details->EditValue ?>"<?php echo $personal_info->reference_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label for="x_other_details" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_other_details"><?php echo $personal_info->other_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_other_details" id="z_other_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->other_details->cellAttributes() ?>>
			<span id="el_personal_info_other_details">
<input type="text" data-table="personal_info" data-field="x_other_details" name="x_other_details" id="x_other_details" size="35" placeholder="<?php echo HtmlEncode($personal_info->other_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->other_details->EditValue ?>"<?php echo $personal_info->other_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_name->Visible) { // bank_name ?>
	<div id="r_bank_name" class="form-group row">
		<label for="x_bank_name" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_bank_name"><?php echo $personal_info->bank_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bank_name" id="z_bank_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->bank_name->cellAttributes() ?>>
			<span id="el_personal_info_bank_name">
<input type="text" data-table="personal_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->bank_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_name->EditValue ?>"<?php echo $personal_info->bank_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div id="r_bank_ifsc_code" class="form-group row">
		<label for="x_bank_ifsc_code" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_bank_ifsc_code"><?php echo $personal_info->bank_ifsc_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bank_ifsc_code" id="z_bank_ifsc_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->bank_ifsc_code->cellAttributes() ?>>
			<span id="el_personal_info_bank_ifsc_code">
<input type="text" data-table="personal_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($personal_info->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_ifsc_code->EditValue ?>"<?php echo $personal_info->bank_ifsc_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_account_no->Visible) { // bank_account_no ?>
	<div id="r_bank_account_no" class="form-group row">
		<label for="x_bank_account_no" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_bank_account_no"><?php echo $personal_info->bank_account_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_bank_account_no" id="z_bank_account_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->bank_account_no->cellAttributes() ?>>
			<span id="el_personal_info_bank_account_no">
<input type="text" data-table="personal_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($personal_info->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_account_no->EditValue ?>"<?php echo $personal_info->bank_account_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_operator"><?php echo $personal_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->operator->cellAttributes() ?>>
			<span id="el_personal_info_operator">
<input type="text" data-table="personal_info" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($personal_info->operator->getPlaceHolder()) ?>" value="<?php echo $personal_info->operator->EditValue ?>"<?php echo $personal_info->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($personal_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $personal_info_search->LeftColumnClass ?>"><span id="elh_personal_info_datetime"><?php echo $personal_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $personal_info_search->RightColumnClass ?>"><div<?php echo $personal_info->datetime->cellAttributes() ?>>
			<span id="el_personal_info_datetime">
<input type="text" data-table="personal_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($personal_info->datetime->getPlaceHolder()) ?>" value="<?php echo $personal_info->datetime->EditValue ?>"<?php echo $personal_info->datetime->editAttributes() ?>>
<?php if (!$personal_info->datetime->ReadOnly && !$personal_info->datetime->Disabled && !isset($personal_info->datetime->EditAttrs["readonly"]) && !isset($personal_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$personal_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $personal_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$personal_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$personal_info_search->terminate();
?>