<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$personal_info_update = new personal_info_update();

// Run the page
$personal_info_update->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$personal_info_update->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "update";
var fpersonal_infoupdate = currentForm = new ew.Form("fpersonal_infoupdate", "update");

// Validate form
fpersonal_infoupdate.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	if (!ew.updateSelected(fobj)) {
		ew.alert(ew.language.phrase("NoFieldSelected"));
		return false;
	}
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($personal_info_update->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			uelm = this.getElements("u" + infix + "_formal_name");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->formal_name->caption(), $personal_info->formal_name->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->gender->Required) { ?>
			elm = this.getElements("x" + infix + "_gender");
			uelm = this.getElements("u" + infix + "_gender");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->gender->caption(), $personal_info->gender->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			uelm = this.getElements("u" + infix + "_mobile");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile->caption(), $personal_info->mobile->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			uelm = this.getElements("u" + infix + "_mobile");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->mobile->errorMessage()) ?>");
		<?php if ($personal_info_update->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			uelm = this.getElements("u" + infix + "__email");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->_email->caption(), $personal_info->_email->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			uelm = this.getElements("u" + infix + "__email");
			if (uelm && uelm.checked && elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->_email->errorMessage()) ?>");
		<?php if ($personal_info_update->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			uelm = this.getElements("u" + infix + "_address");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->address->caption(), $personal_info->address->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->country->Required) { ?>
			elm = this.getElements("x" + infix + "_country");
			uelm = this.getElements("u" + infix + "_country");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->country->caption(), $personal_info->country->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->state->Required) { ?>
			elm = this.getElements("x" + infix + "_state");
			uelm = this.getElements("u" + infix + "_state");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->state->caption(), $personal_info->state->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->city->Required) { ?>
			elm = this.getElements("x" + infix + "_city");
			uelm = this.getElements("u" + infix + "_city");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->city->caption(), $personal_info->city->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->city_name->Required) { ?>
			elm = this.getElements("x" + infix + "_city_name");
			uelm = this.getElements("u" + infix + "_city_name");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->city_name->caption(), $personal_info->city_name->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->dob->Required) { ?>
			elm = this.getElements("x" + infix + "_dob");
			uelm = this.getElements("u" + infix + "_dob");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->dob->caption(), $personal_info->dob->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_dob");
			uelm = this.getElements("u" + infix + "_dob");
			if (uelm && uelm.checked && elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->dob->errorMessage()) ?>");
		<?php if ($personal_info_update->dom->Required) { ?>
			elm = this.getElements("x" + infix + "_dom");
			uelm = this.getElements("u" + infix + "_dom");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->dom->caption(), $personal_info->dom->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_dom");
			uelm = this.getElements("u" + infix + "_dom");
			if (uelm && uelm.checked && elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->dom->errorMessage()) ?>");
		<?php if ($personal_info_update->marital_status->Required) { ?>
			elm = this.getElements("x" + infix + "_marital_status");
			uelm = this.getElements("u" + infix + "_marital_status");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->marital_status->caption(), $personal_info->marital_status->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->spouse_details->Required) { ?>
			elm = this.getElements("x" + infix + "_spouse_details");
			uelm = this.getElements("u" + infix + "_spouse_details");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->spouse_details->caption(), $personal_info->spouse_details->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			uelm = this.getElements("u" + infix + "_image");
			if (uelm && uelm.checked) {
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $personal_info->image->caption(), $personal_info->image->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->father_name->Required) { ?>
			elm = this.getElements("x" + infix + "_father_name");
			uelm = this.getElements("u" + infix + "_father_name");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->father_name->caption(), $personal_info->father_name->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->mother_name->Required) { ?>
			elm = this.getElements("x" + infix + "_mother_name");
			uelm = this.getElements("u" + infix + "_mother_name");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mother_name->caption(), $personal_info->mother_name->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->permanent_address->Required) { ?>
			elm = this.getElements("x" + infix + "_permanent_address");
			uelm = this.getElements("u" + infix + "_permanent_address");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->permanent_address->caption(), $personal_info->permanent_address->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->mobile_other->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_other");
			uelm = this.getElements("u" + infix + "_mobile_other");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile_other->caption(), $personal_info->mobile_other->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->mobile_family->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_family");
			uelm = this.getElements("u" + infix + "_mobile_family");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->mobile_family->caption(), $personal_info->mobile_family->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->emergency_details->Required) { ?>
			elm = this.getElements("x" + infix + "_emergency_details");
			uelm = this.getElements("u" + infix + "_emergency_details");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->emergency_details->caption(), $personal_info->emergency_details->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->annual_income->Required) { ?>
			elm = this.getElements("x" + infix + "_annual_income");
			uelm = this.getElements("u" + infix + "_annual_income");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->annual_income->caption(), $personal_info->annual_income->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_annual_income");
			uelm = this.getElements("u" + infix + "_annual_income");
			if (uelm && uelm.checked && elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($personal_info->annual_income->errorMessage()) ?>");
		<?php if ($personal_info_update->work_details->Required) { ?>
			elm = this.getElements("x" + infix + "_work_details");
			uelm = this.getElements("u" + infix + "_work_details");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->work_details->caption(), $personal_info->work_details->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			uelm = this.getElements("u" + infix + "_status");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->status->caption(), $personal_info->status->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->gst->Required) { ?>
			elm = this.getElements("x" + infix + "_gst");
			uelm = this.getElements("u" + infix + "_gst");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->gst->caption(), $personal_info->gst->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			uelm = this.getElements("u" + infix + "_aadhaar_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->aadhaar_no->caption(), $personal_info->aadhaar_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			uelm = this.getElements("u" + infix + "_aadhaar_no");
			if (uelm && uelm.checked && elm && !ew.checkByRegEx(elm.value, /^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/))
				return this.onError(elm, "<?php echo JsEncode($personal_info->aadhaar_no->errorMessage()) ?>");
		<?php if ($personal_info_update->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			uelm = this.getElements("u" + infix + "_pan_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->pan_no->caption(), $personal_info->pan_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
			elm = this.getElements("x" + infix + "_pan_no");
			uelm = this.getElements("u" + infix + "_pan_no");
			if (uelm && uelm.checked && elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
				return this.onError(elm, "<?php echo JsEncode($personal_info->pan_no->errorMessage()) ?>");
		<?php if ($personal_info_update->id_proof->Required) { ?>
			felm = this.getElements("x" + infix + "_id_proof");
			elm = this.getElements("fn_x" + infix + "_id_proof");
			uelm = this.getElements("u" + infix + "_id_proof");
			if (uelm && uelm.checked) {
				if (felm && elm && !ew.hasValue(elm))
					return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $personal_info->id_proof->caption(), $personal_info->id_proof->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->reference_details->Required) { ?>
			elm = this.getElements("x" + infix + "_reference_details");
			uelm = this.getElements("u" + infix + "_reference_details");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->reference_details->caption(), $personal_info->reference_details->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			uelm = this.getElements("u" + infix + "_other_details");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->other_details->caption(), $personal_info->other_details->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->bank_name->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_name");
			uelm = this.getElements("u" + infix + "_bank_name");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_name->caption(), $personal_info->bank_name->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->bank_ifsc_code->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_ifsc_code");
			uelm = this.getElements("u" + infix + "_bank_ifsc_code");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_ifsc_code->caption(), $personal_info->bank_ifsc_code->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->bank_account_no->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_account_no");
			uelm = this.getElements("u" + infix + "_bank_account_no");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->bank_account_no->caption(), $personal_info->bank_account_no->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			uelm = this.getElements("u" + infix + "_operator");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->operator->caption(), $personal_info->operator->RequiredErrorMessage)) ?>");
			}
		<?php } ?>
		<?php if ($personal_info_update->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			uelm = this.getElements("u" + infix + "_datetime");
			if (uelm && uelm.checked) {
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $personal_info->datetime->caption(), $personal_info->datetime->RequiredErrorMessage)) ?>");
			}
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpersonal_infoupdate.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpersonal_infoupdate.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpersonal_infoupdate.lists["x_gender"] = <?php echo $personal_info_update->gender->Lookup->toClientList() ?>;
fpersonal_infoupdate.lists["x_gender"].options = <?php echo JsonEncode($personal_info_update->gender->options(FALSE, TRUE)) ?>;
fpersonal_infoupdate.lists["x_country"] = <?php echo $personal_info_update->country->Lookup->toClientList() ?>;
fpersonal_infoupdate.lists["x_country"].options = <?php echo JsonEncode($personal_info_update->country->lookupOptions()) ?>;
fpersonal_infoupdate.lists["x_state"] = <?php echo $personal_info_update->state->Lookup->toClientList() ?>;
fpersonal_infoupdate.lists["x_state"].options = <?php echo JsonEncode($personal_info_update->state->lookupOptions()) ?>;
fpersonal_infoupdate.lists["x_city"] = <?php echo $personal_info_update->city->Lookup->toClientList() ?>;
fpersonal_infoupdate.lists["x_city"].options = <?php echo JsonEncode($personal_info_update->city->lookupOptions()) ?>;
fpersonal_infoupdate.lists["x_marital_status"] = <?php echo $personal_info_update->marital_status->Lookup->toClientList() ?>;
fpersonal_infoupdate.lists["x_marital_status"].options = <?php echo JsonEncode($personal_info_update->marital_status->options(FALSE, TRUE)) ?>;
fpersonal_infoupdate.lists["x_status"] = <?php echo $personal_info_update->status->Lookup->toClientList() ?>;
fpersonal_infoupdate.lists["x_status"].options = <?php echo JsonEncode($personal_info_update->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $personal_info_update->showPageHeader(); ?>
<?php
$personal_info_update->showMessage();
?>
<form name="fpersonal_infoupdate" id="fpersonal_infoupdate" class="<?php echo $personal_info_update->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($personal_info_update->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $personal_info_update->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<?php if ($personal_info->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$personal_info_update->IsModal ?>">
<?php foreach ($personal_info_update->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_personal_infoupdate" class="ew-update-div"><!-- page -->
	<div class="form-check">
		<input type="checkbox" class="form-check-input" name="u" id="u" onclick="ew.selectAll(this);"<?php echo $personal_info_update->Disabled ?>><label class="form-check-label" for="u"><?php echo $Language->Phrase("UpdateSelectAll") ?></label>
	</div>
<?php if ($personal_info->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label for="x_formal_name" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_formal_name" id="u_formal_name" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->formal_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_formal_name" id="u_formal_name" value="<?php echo $personal_info->formal_name->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->formal_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_formal_name"><?php echo $personal_info->formal_name->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->formal_name->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_formal_name">
<input type="text" data-table="personal_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($personal_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->formal_name->EditValue ?>"<?php echo $personal_info->formal_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_formal_name">
<span<?php echo $personal_info->formal_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->formal_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" value="<?php echo HtmlEncode($personal_info->formal_name->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label for="x_gender" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_gender" id="u_gender" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->gender->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_gender" id="u_gender" value="<?php echo $personal_info->gender->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->gender->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_gender"><?php echo $personal_info->gender->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->gender->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_gender">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_gender" data-value-separator="<?php echo $personal_info->gender->displayValueSeparatorAttribute() ?>" id="x_gender" name="x_gender"<?php echo $personal_info->gender->editAttributes() ?>>
		<?php echo $personal_info->gender->selectOptionListHtml("x_gender") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_personal_info_gender">
<span<?php echo $personal_info->gender->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->gender->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_gender" name="x_gender" id="x_gender" value="<?php echo HtmlEncode($personal_info->gender->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->gender->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_mobile" id="u_mobile" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->mobile->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_mobile" id="u_mobile" value="<?php echo $personal_info->mobile->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->mobile->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_mobile"><?php echo $personal_info->mobile->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->mobile->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_mobile">
<input type="text" data-table="personal_info" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($personal_info->mobile->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile->EditValue ?>"<?php echo $personal_info->mobile->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_mobile">
<span<?php echo $personal_info->mobile->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->mobile->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_mobile" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($personal_info->mobile->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u__email" id="u__email" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->_email->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u__email" id="u__email" value="<?php echo $personal_info->_email->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->_email->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u__email"><?php echo $personal_info->_email->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->_email->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info__email">
<input type="text" data-table="personal_info" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($personal_info->_email->getPlaceHolder()) ?>" value="<?php echo $personal_info->_email->EditValue ?>"<?php echo $personal_info->_email->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info__email">
<span<?php echo $personal_info->_email->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->_email->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x__email" name="x__email" id="x__email" value="<?php echo HtmlEncode($personal_info->_email->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label for="x_address" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_address" id="u_address" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->address->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_address" id="u_address" value="<?php echo $personal_info->address->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->address->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_address"><?php echo $personal_info->address->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->address->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_address">
<input type="text" data-table="personal_info" data-field="x_address" name="x_address" id="x_address" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->address->getPlaceHolder()) ?>" value="<?php echo $personal_info->address->EditValue ?>"<?php echo $personal_info->address->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_address">
<span<?php echo $personal_info->address->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->address->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_address" name="x_address" id="x_address" value="<?php echo HtmlEncode($personal_info->address->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->country->Visible) { // country ?>
	<div id="r_country" class="form-group row">
		<label for="x_country" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_country" id="u_country" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->country->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_country" id="u_country" value="<?php echo $personal_info->country->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->country->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_country"><?php echo $personal_info->country->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->country->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_country">
<?php $personal_info->country->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$personal_info->country->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_country" data-value-separator="<?php echo $personal_info->country->displayValueSeparatorAttribute() ?>" id="x_country" name="x_country"<?php echo $personal_info->country->editAttributes() ?>>
		<?php echo $personal_info->country->selectOptionListHtml("x_country") ?>
	</select>
</div>
<?php echo $personal_info->country->Lookup->getParamTag("p_x_country") ?>
</span>
<?php } else { ?>
<span id="el_personal_info_country">
<span<?php echo $personal_info->country->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->country->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_country" name="x_country" id="x_country" value="<?php echo HtmlEncode($personal_info->country->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->country->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->state->Visible) { // state ?>
	<div id="r_state" class="form-group row">
		<label for="x_state" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_state" id="u_state" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->state->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_state" id="u_state" value="<?php echo $personal_info->state->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->state->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_state"><?php echo $personal_info->state->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->state->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_state">
<?php $personal_info->state->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$personal_info->state->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_state" data-value-separator="<?php echo $personal_info->state->displayValueSeparatorAttribute() ?>" id="x_state" name="x_state"<?php echo $personal_info->state->editAttributes() ?>>
		<?php echo $personal_info->state->selectOptionListHtml("x_state") ?>
	</select>
</div>
<?php echo $personal_info->state->Lookup->getParamTag("p_x_state") ?>
</span>
<?php } else { ?>
<span id="el_personal_info_state">
<span<?php echo $personal_info->state->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->state->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_state" name="x_state" id="x_state" value="<?php echo HtmlEncode($personal_info->state->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->state->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->city->Visible) { // city ?>
	<div id="r_city" class="form-group row">
		<label for="x_city" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_city" id="u_city" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->city->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_city" id="u_city" value="<?php echo $personal_info->city->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->city->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_city"><?php echo $personal_info->city->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->city->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_city">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_city" data-value-separator="<?php echo $personal_info->city->displayValueSeparatorAttribute() ?>" id="x_city" name="x_city"<?php echo $personal_info->city->editAttributes() ?>>
		<?php echo $personal_info->city->selectOptionListHtml("x_city") ?>
	</select>
</div>
<?php echo $personal_info->city->Lookup->getParamTag("p_x_city") ?>
</span>
<?php } else { ?>
<span id="el_personal_info_city">
<span<?php echo $personal_info->city->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->city->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_city" name="x_city" id="x_city" value="<?php echo HtmlEncode($personal_info->city->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->city->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->city_name->Visible) { // city_name ?>
	<div id="r_city_name" class="form-group row">
		<label for="x_city_name" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_city_name" id="u_city_name" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->city_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_city_name" id="u_city_name" value="<?php echo $personal_info->city_name->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->city_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_city_name"><?php echo $personal_info->city_name->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->city_name->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_city_name">
<input type="text" data-table="personal_info" data-field="x_city_name" name="x_city_name" id="x_city_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->city_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->city_name->EditValue ?>"<?php echo $personal_info->city_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_city_name">
<span<?php echo $personal_info->city_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->city_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_city_name" name="x_city_name" id="x_city_name" value="<?php echo HtmlEncode($personal_info->city_name->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->city_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->dob->Visible) { // dob ?>
	<div id="r_dob" class="form-group row">
		<label for="x_dob" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_dob" id="u_dob" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->dob->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_dob" id="u_dob" value="<?php echo $personal_info->dob->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->dob->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_dob"><?php echo $personal_info->dob->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->dob->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_dob">
<input type="text" data-table="personal_info" data-field="x_dob" data-format="2" name="x_dob" id="x_dob" placeholder="<?php echo HtmlEncode($personal_info->dob->getPlaceHolder()) ?>" value="<?php echo $personal_info->dob->EditValue ?>"<?php echo $personal_info->dob->editAttributes() ?>>
<?php if (!$personal_info->dob->ReadOnly && !$personal_info->dob->Disabled && !isset($personal_info->dob->EditAttrs["readonly"]) && !isset($personal_info->dob->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infoupdate", "x_dob", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_personal_info_dob">
<span<?php echo $personal_info->dob->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->dob->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_dob" name="x_dob" id="x_dob" value="<?php echo HtmlEncode($personal_info->dob->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->dob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->dom->Visible) { // dom ?>
	<div id="r_dom" class="form-group row">
		<label for="x_dom" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_dom" id="u_dom" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->dom->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_dom" id="u_dom" value="<?php echo $personal_info->dom->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->dom->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_dom"><?php echo $personal_info->dom->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->dom->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_dom">
<input type="text" data-table="personal_info" data-field="x_dom" data-format="2" name="x_dom" id="x_dom" placeholder="<?php echo HtmlEncode($personal_info->dom->getPlaceHolder()) ?>" value="<?php echo $personal_info->dom->EditValue ?>"<?php echo $personal_info->dom->editAttributes() ?>>
<?php if (!$personal_info->dom->ReadOnly && !$personal_info->dom->Disabled && !isset($personal_info->dom->EditAttrs["readonly"]) && !isset($personal_info->dom->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpersonal_infoupdate", "x_dom", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_personal_info_dom">
<span<?php echo $personal_info->dom->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->dom->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_dom" name="x_dom" id="x_dom" value="<?php echo HtmlEncode($personal_info->dom->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->dom->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->marital_status->Visible) { // marital_status ?>
	<div id="r_marital_status" class="form-group row">
		<label for="x_marital_status" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_marital_status" id="u_marital_status" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->marital_status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_marital_status" id="u_marital_status" value="<?php echo $personal_info->marital_status->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->marital_status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_marital_status"><?php echo $personal_info->marital_status->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->marital_status->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_marital_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_marital_status" data-value-separator="<?php echo $personal_info->marital_status->displayValueSeparatorAttribute() ?>" id="x_marital_status" name="x_marital_status"<?php echo $personal_info->marital_status->editAttributes() ?>>
		<?php echo $personal_info->marital_status->selectOptionListHtml("x_marital_status") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_personal_info_marital_status">
<span<?php echo $personal_info->marital_status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->marital_status->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_marital_status" name="x_marital_status" id="x_marital_status" value="<?php echo HtmlEncode($personal_info->marital_status->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->marital_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->spouse_details->Visible) { // spouse_details ?>
	<div id="r_spouse_details" class="form-group row">
		<label for="x_spouse_details" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_spouse_details" id="u_spouse_details" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->spouse_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_spouse_details" id="u_spouse_details" value="<?php echo $personal_info->spouse_details->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->spouse_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_spouse_details"><?php echo $personal_info->spouse_details->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->spouse_details->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_spouse_details">
<input type="text" data-table="personal_info" data-field="x_spouse_details" name="x_spouse_details" id="x_spouse_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->spouse_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->spouse_details->EditValue ?>"<?php echo $personal_info->spouse_details->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_spouse_details">
<span<?php echo $personal_info->spouse_details->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->spouse_details->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_spouse_details" name="x_spouse_details" id="x_spouse_details" value="<?php echo HtmlEncode($personal_info->spouse_details->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->spouse_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_image" id="u_image" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->image->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_image" id="u_image" value="<?php echo $personal_info->image->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->image->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_image"><?php echo $personal_info->image->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->image->cellAttributes() ?>>
<span id="el_personal_info_image">
<div id="fd_x_image">
<span title="<?php echo $personal_info->image->title() ? $personal_info->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($personal_info->image->ReadOnly || $personal_info->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="personal_info" data-field="x_image" name="x_image" id="x_image"<?php echo $personal_info->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $personal_info->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="48">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $personal_info->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $personal_info->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $personal_info->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->father_name->Visible) { // father_name ?>
	<div id="r_father_name" class="form-group row">
		<label for="x_father_name" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_father_name" id="u_father_name" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->father_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_father_name" id="u_father_name" value="<?php echo $personal_info->father_name->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->father_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_father_name"><?php echo $personal_info->father_name->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->father_name->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_father_name">
<input type="text" data-table="personal_info" data-field="x_father_name" name="x_father_name" id="x_father_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->father_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->father_name->EditValue ?>"<?php echo $personal_info->father_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_father_name">
<span<?php echo $personal_info->father_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->father_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_father_name" name="x_father_name" id="x_father_name" value="<?php echo HtmlEncode($personal_info->father_name->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->father_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mother_name->Visible) { // mother_name ?>
	<div id="r_mother_name" class="form-group row">
		<label for="x_mother_name" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_mother_name" id="u_mother_name" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->mother_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_mother_name" id="u_mother_name" value="<?php echo $personal_info->mother_name->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->mother_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_mother_name"><?php echo $personal_info->mother_name->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->mother_name->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_mother_name">
<input type="text" data-table="personal_info" data-field="x_mother_name" name="x_mother_name" id="x_mother_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($personal_info->mother_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->mother_name->EditValue ?>"<?php echo $personal_info->mother_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_mother_name">
<span<?php echo $personal_info->mother_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->mother_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_mother_name" name="x_mother_name" id="x_mother_name" value="<?php echo HtmlEncode($personal_info->mother_name->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->mother_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->permanent_address->Visible) { // permanent_address ?>
	<div id="r_permanent_address" class="form-group row">
		<label for="x_permanent_address" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_permanent_address" id="u_permanent_address" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->permanent_address->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_permanent_address" id="u_permanent_address" value="<?php echo $personal_info->permanent_address->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->permanent_address->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_permanent_address"><?php echo $personal_info->permanent_address->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->permanent_address->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_permanent_address">
<input type="text" data-table="personal_info" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->permanent_address->getPlaceHolder()) ?>" value="<?php echo $personal_info->permanent_address->EditValue ?>"<?php echo $personal_info->permanent_address->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_permanent_address">
<span<?php echo $personal_info->permanent_address->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->permanent_address->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" value="<?php echo HtmlEncode($personal_info->permanent_address->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->permanent_address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile_other->Visible) { // mobile_other ?>
	<div id="r_mobile_other" class="form-group row">
		<label for="x_mobile_other" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_mobile_other" id="u_mobile_other" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->mobile_other->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_mobile_other" id="u_mobile_other" value="<?php echo $personal_info->mobile_other->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->mobile_other->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_mobile_other"><?php echo $personal_info->mobile_other->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->mobile_other->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_mobile_other">
<input type="text" data-table="personal_info" data-field="x_mobile_other" name="x_mobile_other" id="x_mobile_other" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($personal_info->mobile_other->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile_other->EditValue ?>"<?php echo $personal_info->mobile_other->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_mobile_other">
<span<?php echo $personal_info->mobile_other->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->mobile_other->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_mobile_other" name="x_mobile_other" id="x_mobile_other" value="<?php echo HtmlEncode($personal_info->mobile_other->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->mobile_other->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->mobile_family->Visible) { // mobile_family ?>
	<div id="r_mobile_family" class="form-group row">
		<label for="x_mobile_family" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_mobile_family" id="u_mobile_family" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->mobile_family->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_mobile_family" id="u_mobile_family" value="<?php echo $personal_info->mobile_family->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->mobile_family->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_mobile_family"><?php echo $personal_info->mobile_family->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->mobile_family->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_mobile_family">
<input type="text" data-table="personal_info" data-field="x_mobile_family" name="x_mobile_family" id="x_mobile_family" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->mobile_family->getPlaceHolder()) ?>" value="<?php echo $personal_info->mobile_family->EditValue ?>"<?php echo $personal_info->mobile_family->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_mobile_family">
<span<?php echo $personal_info->mobile_family->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->mobile_family->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_mobile_family" name="x_mobile_family" id="x_mobile_family" value="<?php echo HtmlEncode($personal_info->mobile_family->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->mobile_family->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->emergency_details->Visible) { // emergency_details ?>
	<div id="r_emergency_details" class="form-group row">
		<label for="x_emergency_details" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_emergency_details" id="u_emergency_details" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->emergency_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_emergency_details" id="u_emergency_details" value="<?php echo $personal_info->emergency_details->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->emergency_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_emergency_details"><?php echo $personal_info->emergency_details->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->emergency_details->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_emergency_details">
<input type="text" data-table="personal_info" data-field="x_emergency_details" name="x_emergency_details" id="x_emergency_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->emergency_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->emergency_details->EditValue ?>"<?php echo $personal_info->emergency_details->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_emergency_details">
<span<?php echo $personal_info->emergency_details->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->emergency_details->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_emergency_details" name="x_emergency_details" id="x_emergency_details" value="<?php echo HtmlEncode($personal_info->emergency_details->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->emergency_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->annual_income->Visible) { // annual_income ?>
	<div id="r_annual_income" class="form-group row">
		<label for="x_annual_income" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_annual_income" id="u_annual_income" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->annual_income->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_annual_income" id="u_annual_income" value="<?php echo $personal_info->annual_income->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->annual_income->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_annual_income"><?php echo $personal_info->annual_income->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->annual_income->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_annual_income">
<input type="text" data-table="personal_info" data-field="x_annual_income" name="x_annual_income" id="x_annual_income" size="30" placeholder="<?php echo HtmlEncode($personal_info->annual_income->getPlaceHolder()) ?>" value="<?php echo $personal_info->annual_income->EditValue ?>"<?php echo $personal_info->annual_income->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_annual_income">
<span<?php echo $personal_info->annual_income->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->annual_income->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_annual_income" name="x_annual_income" id="x_annual_income" value="<?php echo HtmlEncode($personal_info->annual_income->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->annual_income->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->work_details->Visible) { // work_details ?>
	<div id="r_work_details" class="form-group row">
		<label for="x_work_details" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_work_details" id="u_work_details" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->work_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_work_details" id="u_work_details" value="<?php echo $personal_info->work_details->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->work_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_work_details"><?php echo $personal_info->work_details->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->work_details->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_work_details">
<input type="text" data-table="personal_info" data-field="x_work_details" name="x_work_details" id="x_work_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->work_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->work_details->EditValue ?>"<?php echo $personal_info->work_details->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_work_details">
<span<?php echo $personal_info->work_details->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->work_details->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_work_details" name="x_work_details" id="x_work_details" value="<?php echo HtmlEncode($personal_info->work_details->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->work_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_status" id="u_status" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_status" id="u_status" value="<?php echo $personal_info->status->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->status->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_status"><?php echo $personal_info->status->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->status->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="personal_info" data-field="x_status" data-value-separator="<?php echo $personal_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $personal_info->status->editAttributes() ?>>
		<?php echo $personal_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php } else { ?>
<span id="el_personal_info_status">
<span<?php echo $personal_info->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->status->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_status" name="x_status" id="x_status" value="<?php echo HtmlEncode($personal_info->status->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label for="x_gst" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_gst" id="u_gst" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->gst->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_gst" id="u_gst" value="<?php echo $personal_info->gst->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->gst->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_gst"><?php echo $personal_info->gst->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->gst->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_gst">
<input type="text" data-table="personal_info" data-field="x_gst" name="x_gst" id="x_gst" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($personal_info->gst->getPlaceHolder()) ?>" value="<?php echo $personal_info->gst->EditValue ?>"<?php echo $personal_info->gst->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_gst">
<span<?php echo $personal_info->gst->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->gst->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_gst" name="x_gst" id="x_gst" value="<?php echo HtmlEncode($personal_info->gst->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->gst->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label for="x_aadhaar_no" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_aadhaar_no" id="u_aadhaar_no" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->aadhaar_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_aadhaar_no" id="u_aadhaar_no" value="<?php echo $personal_info->aadhaar_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->aadhaar_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_aadhaar_no"><?php echo $personal_info->aadhaar_no->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->aadhaar_no->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_aadhaar_no">
<input type="text" data-table="personal_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($personal_info->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->aadhaar_no->EditValue ?>"<?php echo $personal_info->aadhaar_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_aadhaar_no">
<span<?php echo $personal_info->aadhaar_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->aadhaar_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" value="<?php echo HtmlEncode($personal_info->aadhaar_no->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label for="x_pan_no" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_pan_no" id="u_pan_no" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->pan_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_pan_no" id="u_pan_no" value="<?php echo $personal_info->pan_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->pan_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_pan_no"><?php echo $personal_info->pan_no->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->pan_no->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_pan_no">
<input type="text" data-table="personal_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($personal_info->pan_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->pan_no->EditValue ?>"<?php echo $personal_info->pan_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_pan_no">
<span<?php echo $personal_info->pan_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->pan_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" value="<?php echo HtmlEncode($personal_info->pan_no->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->pan_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->id_proof->Visible) { // id_proof ?>
	<div id="r_id_proof" class="form-group row">
		<label class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_id_proof" id="u_id_proof" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->id_proof->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_id_proof" id="u_id_proof" value="<?php echo $personal_info->id_proof->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->id_proof->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_id_proof"><?php echo $personal_info->id_proof->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->id_proof->cellAttributes() ?>>
<span id="el_personal_info_id_proof">
<div id="fd_x_id_proof">
<span title="<?php echo $personal_info->id_proof->title() ? $personal_info->id_proof->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($personal_info->id_proof->ReadOnly || $personal_info->id_proof->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="personal_info" data-field="x_id_proof" name="x_id_proof" id="x_id_proof" multiple="multiple"<?php echo $personal_info->id_proof->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?php echo $personal_info->id_proof->Upload->FileName ?>">
<?php if (Post("fa_x_id_proof") == "0") { ?>
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="1">
<?php } ?>
<input type="hidden" name="fs_x_id_proof" id= "fs_x_id_proof" value="255">
<input type="hidden" name="fx_x_id_proof" id= "fx_x_id_proof" value="<?php echo $personal_info->id_proof->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_id_proof" id= "fm_x_id_proof" value="<?php echo $personal_info->id_proof->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_id_proof" id= "fc_x_id_proof" value="<?php echo $personal_info->id_proof->UploadMaxFileCount ?>">
</div>
<table id="ft_x_id_proof" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $personal_info->id_proof->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->reference_details->Visible) { // reference_details ?>
	<div id="r_reference_details" class="form-group row">
		<label for="x_reference_details" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_reference_details" id="u_reference_details" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->reference_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_reference_details" id="u_reference_details" value="<?php echo $personal_info->reference_details->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->reference_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_reference_details"><?php echo $personal_info->reference_details->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->reference_details->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_reference_details">
<input type="text" data-table="personal_info" data-field="x_reference_details" name="x_reference_details" id="x_reference_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->reference_details->getPlaceHolder()) ?>" value="<?php echo $personal_info->reference_details->EditValue ?>"<?php echo $personal_info->reference_details->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_reference_details">
<span<?php echo $personal_info->reference_details->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->reference_details->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_reference_details" name="x_reference_details" id="x_reference_details" value="<?php echo HtmlEncode($personal_info->reference_details->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->reference_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label for="x_other_details" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_other_details" id="u_other_details" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->other_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_other_details" id="u_other_details" value="<?php echo $personal_info->other_details->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->other_details->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_other_details"><?php echo $personal_info->other_details->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->other_details->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_other_details">
<textarea data-table="personal_info" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($personal_info->other_details->getPlaceHolder()) ?>"<?php echo $personal_info->other_details->editAttributes() ?>><?php echo $personal_info->other_details->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el_personal_info_other_details">
<span<?php echo $personal_info->other_details->viewAttributes() ?>>
<?php echo $personal_info->other_details->ViewValue ?></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_other_details" name="x_other_details" id="x_other_details" value="<?php echo HtmlEncode($personal_info->other_details->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->other_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_name->Visible) { // bank_name ?>
	<div id="r_bank_name" class="form-group row">
		<label for="x_bank_name" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_bank_name" id="u_bank_name" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->bank_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_bank_name" id="u_bank_name" value="<?php echo $personal_info->bank_name->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->bank_name->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_bank_name"><?php echo $personal_info->bank_name->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->bank_name->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_bank_name">
<input type="text" data-table="personal_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($personal_info->bank_name->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_name->EditValue ?>"<?php echo $personal_info->bank_name->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_bank_name">
<span<?php echo $personal_info->bank_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->bank_name->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_bank_name" name="x_bank_name" id="x_bank_name" value="<?php echo HtmlEncode($personal_info->bank_name->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->bank_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<div id="r_bank_ifsc_code" class="form-group row">
		<label for="x_bank_ifsc_code" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_bank_ifsc_code" id="u_bank_ifsc_code" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->bank_ifsc_code->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_bank_ifsc_code" id="u_bank_ifsc_code" value="<?php echo $personal_info->bank_ifsc_code->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->bank_ifsc_code->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_bank_ifsc_code"><?php echo $personal_info->bank_ifsc_code->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->bank_ifsc_code->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_bank_ifsc_code">
<input type="text" data-table="personal_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($personal_info->bank_ifsc_code->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_ifsc_code->EditValue ?>"<?php echo $personal_info->bank_ifsc_code->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_bank_ifsc_code">
<span<?php echo $personal_info->bank_ifsc_code->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->bank_ifsc_code->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_bank_ifsc_code" name="x_bank_ifsc_code" id="x_bank_ifsc_code" value="<?php echo HtmlEncode($personal_info->bank_ifsc_code->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->bank_ifsc_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->bank_account_no->Visible) { // bank_account_no ?>
	<div id="r_bank_account_no" class="form-group row">
		<label for="x_bank_account_no" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_bank_account_no" id="u_bank_account_no" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->bank_account_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_bank_account_no" id="u_bank_account_no" value="<?php echo $personal_info->bank_account_no->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->bank_account_no->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_bank_account_no"><?php echo $personal_info->bank_account_no->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->bank_account_no->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<span id="el_personal_info_bank_account_no">
<input type="text" data-table="personal_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($personal_info->bank_account_no->getPlaceHolder()) ?>" value="<?php echo $personal_info->bank_account_no->EditValue ?>"<?php echo $personal_info->bank_account_no->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_personal_info_bank_account_no">
<span<?php echo $personal_info->bank_account_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->bank_account_no->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_bank_account_no" name="x_bank_account_no" id="x_bank_account_no" value="<?php echo HtmlEncode($personal_info->bank_account_no->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->bank_account_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_operator" id="u_operator" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->operator->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_operator" id="u_operator" value="<?php echo $personal_info->operator->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->operator->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_operator"><?php echo $personal_info->operator->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->operator->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el_personal_info_operator">
<span<?php echo $personal_info->operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($personal_info->operator->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($personal_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $personal_info_update->LeftColumnClass ?>"><div class="form-check">
<?php if (!$personal_info->isConfirm()) { ?>
<input type="checkbox" name="u_datetime" id="u_datetime" class="form-check-input ew-multi-select" value="1"<?php echo ($personal_info->datetime->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } else { ?>
<input type="hidden" name="u_datetime" id="u_datetime" value="<?php echo $personal_info->datetime->MultiUpdate ?>">
<input type="checkbox" class="form-check-input" disabled<?php echo ($personal_info->datetime->MultiUpdate == "1") ? " checked" : "" ?>>
<?php } ?>
<label class="form-check-label" for="u_datetime"><?php echo $personal_info->datetime->caption() ?></label></div></label>
		<div class="<?php echo $personal_info_update->RightColumnClass ?>"><div<?php echo $personal_info->datetime->cellAttributes() ?>>
<?php if (!$personal_info->isConfirm()) { ?>
<?php } else { ?>
<span id="el_personal_info_datetime">
<span<?php echo $personal_info->datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($personal_info->datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="personal_info" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($personal_info->datetime->FormValue) ?>">
<?php } ?>
<?php echo $personal_info->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page -->
<?php if (!$personal_info_update->IsModal) { ?>
	<div class="form-group row"><!-- buttons .form-group -->
		<div class="<?php echo $personal_info_update->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$personal_info->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $personal_info_update->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
		</div><!-- /buttons offset -->
	</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$personal_info_update->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$personal_info_update->terminate();
?>