<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$personal_info_view = new personal_info_view();

// Run the page
$personal_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$personal_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$personal_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpersonal_infoview = currentForm = new ew.Form("fpersonal_infoview", "view");

// Form_CustomValidate event
fpersonal_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpersonal_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpersonal_infoview.lists["x_gender"] = <?php echo $personal_info_view->gender->Lookup->toClientList() ?>;
fpersonal_infoview.lists["x_gender"].options = <?php echo JsonEncode($personal_info_view->gender->options(FALSE, TRUE)) ?>;
fpersonal_infoview.lists["x_country"] = <?php echo $personal_info_view->country->Lookup->toClientList() ?>;
fpersonal_infoview.lists["x_country"].options = <?php echo JsonEncode($personal_info_view->country->lookupOptions()) ?>;
fpersonal_infoview.lists["x_state"] = <?php echo $personal_info_view->state->Lookup->toClientList() ?>;
fpersonal_infoview.lists["x_state"].options = <?php echo JsonEncode($personal_info_view->state->lookupOptions()) ?>;
fpersonal_infoview.lists["x_city"] = <?php echo $personal_info_view->city->Lookup->toClientList() ?>;
fpersonal_infoview.lists["x_city"].options = <?php echo JsonEncode($personal_info_view->city->lookupOptions()) ?>;
fpersonal_infoview.lists["x_marital_status"] = <?php echo $personal_info_view->marital_status->Lookup->toClientList() ?>;
fpersonal_infoview.lists["x_marital_status"].options = <?php echo JsonEncode($personal_info_view->marital_status->options(FALSE, TRUE)) ?>;
fpersonal_infoview.lists["x_status"] = <?php echo $personal_info_view->status->Lookup->toClientList() ?>;
fpersonal_infoview.lists["x_status"].options = <?php echo JsonEncode($personal_info_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$personal_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $personal_info_view->ExportOptions->render("body") ?>
<?php $personal_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $personal_info_view->showPageHeader(); ?>
<?php
$personal_info_view->showMessage();
?>
<form name="fpersonal_infoview" id="fpersonal_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($personal_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $personal_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="personal_info">
<input type="hidden" name="modal" value="<?php echo (int)$personal_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($personal_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_id"><?php echo $personal_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $personal_info->id->cellAttributes() ?>>
<span id="el_personal_info_id">
<span<?php echo $personal_info->id->viewAttributes() ?>>
<?php echo $personal_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->formal_name->Visible) { // formal_name ?>
	<tr id="r_formal_name">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_formal_name"><?php echo $personal_info->formal_name->caption() ?></span></td>
		<td data-name="formal_name"<?php echo $personal_info->formal_name->cellAttributes() ?>>
<span id="el_personal_info_formal_name">
<span<?php echo $personal_info->formal_name->viewAttributes() ?>>
<?php echo $personal_info->formal_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->gender->Visible) { // gender ?>
	<tr id="r_gender">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_gender"><?php echo $personal_info->gender->caption() ?></span></td>
		<td data-name="gender"<?php echo $personal_info->gender->cellAttributes() ?>>
<span id="el_personal_info_gender">
<span<?php echo $personal_info->gender->viewAttributes() ?>>
<?php echo $personal_info->gender->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_mobile"><?php echo $personal_info->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $personal_info->mobile->cellAttributes() ?>>
<span id="el_personal_info_mobile">
<span<?php echo $personal_info->mobile->viewAttributes() ?>>
<?php echo $personal_info->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info__email"><?php echo $personal_info->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $personal_info->_email->cellAttributes() ?>>
<span id="el_personal_info__email">
<span<?php echo $personal_info->_email->viewAttributes() ?>>
<?php echo $personal_info->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->address->Visible) { // address ?>
	<tr id="r_address">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_address"><?php echo $personal_info->address->caption() ?></span></td>
		<td data-name="address"<?php echo $personal_info->address->cellAttributes() ?>>
<span id="el_personal_info_address">
<span<?php echo $personal_info->address->viewAttributes() ?>>
<?php echo $personal_info->address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->country->Visible) { // country ?>
	<tr id="r_country">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_country"><?php echo $personal_info->country->caption() ?></span></td>
		<td data-name="country"<?php echo $personal_info->country->cellAttributes() ?>>
<span id="el_personal_info_country">
<span<?php echo $personal_info->country->viewAttributes() ?>>
<?php echo $personal_info->country->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->state->Visible) { // state ?>
	<tr id="r_state">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_state"><?php echo $personal_info->state->caption() ?></span></td>
		<td data-name="state"<?php echo $personal_info->state->cellAttributes() ?>>
<span id="el_personal_info_state">
<span<?php echo $personal_info->state->viewAttributes() ?>>
<?php echo $personal_info->state->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->city->Visible) { // city ?>
	<tr id="r_city">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_city"><?php echo $personal_info->city->caption() ?></span></td>
		<td data-name="city"<?php echo $personal_info->city->cellAttributes() ?>>
<span id="el_personal_info_city">
<span<?php echo $personal_info->city->viewAttributes() ?>>
<?php echo $personal_info->city->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->city_name->Visible) { // city_name ?>
	<tr id="r_city_name">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_city_name"><?php echo $personal_info->city_name->caption() ?></span></td>
		<td data-name="city_name"<?php echo $personal_info->city_name->cellAttributes() ?>>
<span id="el_personal_info_city_name">
<span<?php echo $personal_info->city_name->viewAttributes() ?>>
<?php echo $personal_info->city_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->dob->Visible) { // dob ?>
	<tr id="r_dob">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_dob"><?php echo $personal_info->dob->caption() ?></span></td>
		<td data-name="dob"<?php echo $personal_info->dob->cellAttributes() ?>>
<span id="el_personal_info_dob">
<span<?php echo $personal_info->dob->viewAttributes() ?>>
<?php echo $personal_info->dob->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->dom->Visible) { // dom ?>
	<tr id="r_dom">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_dom"><?php echo $personal_info->dom->caption() ?></span></td>
		<td data-name="dom"<?php echo $personal_info->dom->cellAttributes() ?>>
<span id="el_personal_info_dom">
<span<?php echo $personal_info->dom->viewAttributes() ?>>
<?php echo $personal_info->dom->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->marital_status->Visible) { // marital_status ?>
	<tr id="r_marital_status">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_marital_status"><?php echo $personal_info->marital_status->caption() ?></span></td>
		<td data-name="marital_status"<?php echo $personal_info->marital_status->cellAttributes() ?>>
<span id="el_personal_info_marital_status">
<span<?php echo $personal_info->marital_status->viewAttributes() ?>>
<?php echo $personal_info->marital_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->spouse_details->Visible) { // spouse_details ?>
	<tr id="r_spouse_details">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_spouse_details"><?php echo $personal_info->spouse_details->caption() ?></span></td>
		<td data-name="spouse_details"<?php echo $personal_info->spouse_details->cellAttributes() ?>>
<span id="el_personal_info_spouse_details">
<span<?php echo $personal_info->spouse_details->viewAttributes() ?>>
<?php echo $personal_info->spouse_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_image"><?php echo $personal_info->image->caption() ?></span></td>
		<td data-name="image"<?php echo $personal_info->image->cellAttributes() ?>>
<span id="el_personal_info_image">
<span<?php echo $personal_info->image->viewAttributes() ?>>
<?php echo GetFileViewTag($personal_info->image, $personal_info->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->father_name->Visible) { // father_name ?>
	<tr id="r_father_name">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_father_name"><?php echo $personal_info->father_name->caption() ?></span></td>
		<td data-name="father_name"<?php echo $personal_info->father_name->cellAttributes() ?>>
<span id="el_personal_info_father_name">
<span<?php echo $personal_info->father_name->viewAttributes() ?>>
<?php echo $personal_info->father_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->mother_name->Visible) { // mother_name ?>
	<tr id="r_mother_name">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_mother_name"><?php echo $personal_info->mother_name->caption() ?></span></td>
		<td data-name="mother_name"<?php echo $personal_info->mother_name->cellAttributes() ?>>
<span id="el_personal_info_mother_name">
<span<?php echo $personal_info->mother_name->viewAttributes() ?>>
<?php echo $personal_info->mother_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->permanent_address->Visible) { // permanent_address ?>
	<tr id="r_permanent_address">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_permanent_address"><?php echo $personal_info->permanent_address->caption() ?></span></td>
		<td data-name="permanent_address"<?php echo $personal_info->permanent_address->cellAttributes() ?>>
<span id="el_personal_info_permanent_address">
<span<?php echo $personal_info->permanent_address->viewAttributes() ?>>
<?php echo $personal_info->permanent_address->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->mobile_other->Visible) { // mobile_other ?>
	<tr id="r_mobile_other">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_mobile_other"><?php echo $personal_info->mobile_other->caption() ?></span></td>
		<td data-name="mobile_other"<?php echo $personal_info->mobile_other->cellAttributes() ?>>
<span id="el_personal_info_mobile_other">
<span<?php echo $personal_info->mobile_other->viewAttributes() ?>>
<?php echo $personal_info->mobile_other->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->mobile_family->Visible) { // mobile_family ?>
	<tr id="r_mobile_family">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_mobile_family"><?php echo $personal_info->mobile_family->caption() ?></span></td>
		<td data-name="mobile_family"<?php echo $personal_info->mobile_family->cellAttributes() ?>>
<span id="el_personal_info_mobile_family">
<span<?php echo $personal_info->mobile_family->viewAttributes() ?>>
<?php echo $personal_info->mobile_family->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->emergency_details->Visible) { // emergency_details ?>
	<tr id="r_emergency_details">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_emergency_details"><?php echo $personal_info->emergency_details->caption() ?></span></td>
		<td data-name="emergency_details"<?php echo $personal_info->emergency_details->cellAttributes() ?>>
<span id="el_personal_info_emergency_details">
<span<?php echo $personal_info->emergency_details->viewAttributes() ?>>
<?php echo $personal_info->emergency_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->annual_income->Visible) { // annual_income ?>
	<tr id="r_annual_income">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_annual_income"><?php echo $personal_info->annual_income->caption() ?></span></td>
		<td data-name="annual_income"<?php echo $personal_info->annual_income->cellAttributes() ?>>
<span id="el_personal_info_annual_income">
<span<?php echo $personal_info->annual_income->viewAttributes() ?>>
<?php echo $personal_info->annual_income->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->work_details->Visible) { // work_details ?>
	<tr id="r_work_details">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_work_details"><?php echo $personal_info->work_details->caption() ?></span></td>
		<td data-name="work_details"<?php echo $personal_info->work_details->cellAttributes() ?>>
<span id="el_personal_info_work_details">
<span<?php echo $personal_info->work_details->viewAttributes() ?>>
<?php echo $personal_info->work_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_status"><?php echo $personal_info->status->caption() ?></span></td>
		<td data-name="status"<?php echo $personal_info->status->cellAttributes() ?>>
<span id="el_personal_info_status">
<span<?php echo $personal_info->status->viewAttributes() ?>>
<?php echo $personal_info->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->gst->Visible) { // gst ?>
	<tr id="r_gst">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_gst"><?php echo $personal_info->gst->caption() ?></span></td>
		<td data-name="gst"<?php echo $personal_info->gst->cellAttributes() ?>>
<span id="el_personal_info_gst">
<span<?php echo $personal_info->gst->viewAttributes() ?>>
<?php echo $personal_info->gst->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->aadhaar_no->Visible) { // aadhaar_no ?>
	<tr id="r_aadhaar_no">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_aadhaar_no"><?php echo $personal_info->aadhaar_no->caption() ?></span></td>
		<td data-name="aadhaar_no"<?php echo $personal_info->aadhaar_no->cellAttributes() ?>>
<span id="el_personal_info_aadhaar_no">
<span<?php echo $personal_info->aadhaar_no->viewAttributes() ?>>
<?php echo $personal_info->aadhaar_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->pan_no->Visible) { // pan_no ?>
	<tr id="r_pan_no">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_pan_no"><?php echo $personal_info->pan_no->caption() ?></span></td>
		<td data-name="pan_no"<?php echo $personal_info->pan_no->cellAttributes() ?>>
<span id="el_personal_info_pan_no">
<span<?php echo $personal_info->pan_no->viewAttributes() ?>>
<?php echo $personal_info->pan_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->id_proof->Visible) { // id_proof ?>
	<tr id="r_id_proof">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_id_proof"><?php echo $personal_info->id_proof->caption() ?></span></td>
		<td data-name="id_proof"<?php echo $personal_info->id_proof->cellAttributes() ?>>
<span id="el_personal_info_id_proof">
<span<?php echo $personal_info->id_proof->viewAttributes() ?>>
<?php echo GetFileViewTag($personal_info->id_proof, $personal_info->id_proof->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->reference_details->Visible) { // reference_details ?>
	<tr id="r_reference_details">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_reference_details"><?php echo $personal_info->reference_details->caption() ?></span></td>
		<td data-name="reference_details"<?php echo $personal_info->reference_details->cellAttributes() ?>>
<span id="el_personal_info_reference_details">
<span<?php echo $personal_info->reference_details->viewAttributes() ?>>
<?php echo $personal_info->reference_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->other_details->Visible) { // other_details ?>
	<tr id="r_other_details">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_other_details"><?php echo $personal_info->other_details->caption() ?></span></td>
		<td data-name="other_details"<?php echo $personal_info->other_details->cellAttributes() ?>>
<span id="el_personal_info_other_details">
<span<?php echo $personal_info->other_details->viewAttributes() ?>>
<?php echo $personal_info->other_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->bank_name->Visible) { // bank_name ?>
	<tr id="r_bank_name">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_bank_name"><?php echo $personal_info->bank_name->caption() ?></span></td>
		<td data-name="bank_name"<?php echo $personal_info->bank_name->cellAttributes() ?>>
<span id="el_personal_info_bank_name">
<span<?php echo $personal_info->bank_name->viewAttributes() ?>>
<?php echo $personal_info->bank_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
	<tr id="r_bank_ifsc_code">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_bank_ifsc_code"><?php echo $personal_info->bank_ifsc_code->caption() ?></span></td>
		<td data-name="bank_ifsc_code"<?php echo $personal_info->bank_ifsc_code->cellAttributes() ?>>
<span id="el_personal_info_bank_ifsc_code">
<span<?php echo $personal_info->bank_ifsc_code->viewAttributes() ?>>
<?php echo $personal_info->bank_ifsc_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->bank_account_no->Visible) { // bank_account_no ?>
	<tr id="r_bank_account_no">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_bank_account_no"><?php echo $personal_info->bank_account_no->caption() ?></span></td>
		<td data-name="bank_account_no"<?php echo $personal_info->bank_account_no->cellAttributes() ?>>
<span id="el_personal_info_bank_account_no">
<span<?php echo $personal_info->bank_account_no->viewAttributes() ?>>
<?php echo $personal_info->bank_account_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_operator"><?php echo $personal_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $personal_info->operator->cellAttributes() ?>>
<span id="el_personal_info_operator">
<span<?php echo $personal_info->operator->viewAttributes() ?>>
<?php echo $personal_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($personal_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $personal_info_view->TableLeftColumnClass ?>"><span id="elh_personal_info_datetime"><?php echo $personal_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $personal_info->datetime->cellAttributes() ?>>
<span id="el_personal_info_datetime">
<span<?php echo $personal_info->datetime->viewAttributes() ?>>
<?php echo $personal_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$personal_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$personal_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$personal_info_view->terminate();
?>