<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_b_app_search = new po_b_app_search();

// Run the page
$po_b_app_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_b_app_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_b_app_search->IsModal) { ?>
var fpo_b_appsearch = currentAdvancedSearchForm = new ew.Form("fpo_b_appsearch", "search");
<?php } else { ?>
var fpo_b_appsearch = currentForm = new ew.Form("fpo_b_appsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_b_appsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_b_appsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_b_appsearch.lists["x_company_id"] = <?php echo $po_b_app_search->company_id->Lookup->toClientList() ?>;
fpo_b_appsearch.lists["x_company_id"].options = <?php echo JsonEncode($po_b_app_search->company_id->lookupOptions()) ?>;
fpo_b_appsearch.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_b_appsearch.lists["x_partner_id"] = <?php echo $po_b_app_search->partner_id->Lookup->toClientList() ?>;
fpo_b_appsearch.lists["x_partner_id"].options = <?php echo JsonEncode($po_b_app_search->partner_id->lookupOptions()) ?>;
fpo_b_appsearch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fpo_b_appsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_app->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_datetime");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_app->a_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_app->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_company_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_app->company_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_partner_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_app->partner_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_app->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_app->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_app->cbm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_b_app_search->showPageHeader(); ?>
<?php
$po_b_app_search->showMessage();
?>
<form name="fpo_b_appsearch" id="fpo_b_appsearch" class="<?php echo $po_b_app_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_b_app_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_b_app_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_b_app">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_b_app_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($po_b_app->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_id"><?php echo $po_b_app->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->id->cellAttributes() ?>>
			<span id="el_po_b_app_id">
<input type="text" data-table="po_b_app" data-field="x_id" data-page="1" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($po_b_app->id->getPlaceHolder()) ?>" value="<?php echo $po_b_app->id->EditValue ?>"<?php echo $po_b_app->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_app->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_a_datetime"><?php echo $po_b_app->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->a_datetime->cellAttributes() ?>>
			<span id="el_po_b_app_a_datetime">
<input type="text" data-table="po_b_app" data-field="x_a_datetime" data-page="1" data-format="7" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($po_b_app->a_datetime->getPlaceHolder()) ?>" value="<?php echo $po_b_app->a_datetime->EditValue ?>"<?php echo $po_b_app->a_datetime->editAttributes() ?>>
<?php if (!$po_b_app->a_datetime->ReadOnly && !$po_b_app->a_datetime->Disabled && !isset($po_b_app->a_datetime->EditAttrs["readonly"]) && !isset($po_b_app->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_b_appsearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":7});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_app->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_po"><?php echo $po_b_app->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->po->cellAttributes() ?>>
			<span id="el_po_b_app_po">
<input type="text" data-table="po_b_app" data-field="x_po" data-page="1" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($po_b_app->po->getPlaceHolder()) ?>" value="<?php echo $po_b_app->po->EditValue ?>"<?php echo $po_b_app->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_app->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_company_id"><?php echo $po_b_app->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->company_id->cellAttributes() ?>>
			<span id="el_po_b_app_company_id">
<?php
$wrkonchange = "" . trim(@$po_b_app->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_b_app->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($po_b_app->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_b_app->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_b_app->company_id->getPlaceHolder()) ?>"<?php echo $po_b_app->company_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_b_app" data-field="x_company_id" data-page="1" data-value-separator="<?php echo $po_b_app->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($po_b_app->company_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_b_appsearch.createAutoSuggest({"id":"x_company_id","forceSelect":false});
</script>
<?php echo $po_b_app->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_app->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_partner_id"><?php echo $po_b_app->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->partner_id->cellAttributes() ?>>
			<span id="el_po_b_app_partner_id">
<?php
$wrkonchange = "" . trim(@$po_b_app->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_b_app->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8950">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_b_app->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_b_app->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_b_app->partner_id->getPlaceHolder()) ?>"<?php echo $po_b_app->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_b_app" data-field="x_partner_id" data-page="1" data-value-separator="<?php echo $po_b_app->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_b_app->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_b_appsearch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $po_b_app->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_app->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_quantity"><?php echo $po_b_app->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->quantity->cellAttributes() ?>>
			<span id="el_po_b_app_quantity">
<input type="text" data-table="po_b_app" data-field="x_quantity" data-page="1" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_b_app->quantity->getPlaceHolder()) ?>" value="<?php echo $po_b_app->quantity->EditValue ?>"<?php echo $po_b_app->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_app->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_sqm"><?php echo $po_b_app->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->sqm->cellAttributes() ?>>
			<span id="el_po_b_app_sqm">
<input type="text" data-table="po_b_app" data-field="x_sqm" data-page="1" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_b_app->sqm->getPlaceHolder()) ?>" value="<?php echo $po_b_app->sqm->EditValue ?>"<?php echo $po_b_app->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_app->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_cbm"><?php echo $po_b_app->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->cbm->cellAttributes() ?>>
			<span id="el_po_b_app_cbm">
<input type="text" data-table="po_b_app" data-field="x_cbm" data-page="1" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($po_b_app->cbm->getPlaceHolder()) ?>" value="<?php echo $po_b_app->cbm->EditValue ?>"<?php echo $po_b_app->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_app->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $po_b_app_search->LeftColumnClass ?>"><span id="elh_po_b_app_amount"><?php echo $po_b_app->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $po_b_app_search->RightColumnClass ?>"><div<?php echo $po_b_app->amount->cellAttributes() ?>>
			<span id="el_po_b_app_amount">
<input type="text" data-table="po_b_app" data-field="x_amount" data-page="1" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($po_b_app->amount->getPlaceHolder()) ?>" value="<?php echo $po_b_app->amount->EditValue ?>"<?php echo $po_b_app->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_b_app_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_b_app_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_b_app_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_b_app_search->terminate();
?>