<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_b_wbc_edit = new po_b_wbc_edit();

// Run the page
$po_b_wbc_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_b_wbc_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpo_b_wbcedit = currentForm = new ew.Form("fpo_b_wbcedit", "edit");

// Validate form
fpo_b_wbcedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_b_wbc_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->id->caption(), $po_b_wbc->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->company_id->caption(), $po_b_wbc->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->grp->caption(), $po_b_wbc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->location->caption(), $po_b_wbc->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->po->caption(), $po_b_wbc->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->partner_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->partner_id->caption(), $po_b_wbc->partner_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->cart_id->Required) { ?>
			elm = this.getElements("x" + infix + "_cart_id[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->cart_id->caption(), $po_b_wbc->cart_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->sqm->caption(), $po_b_wbc->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_b_wbc->sqm->errorMessage()) ?>");
		<?php if ($po_b_wbc_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->quantity->caption(), $po_b_wbc->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->amount->caption(), $po_b_wbc->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->cbm->Required) { ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->cbm->caption(), $po_b_wbc->cbm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cbm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_b_wbc->cbm->errorMessage()) ?>");
		<?php if ($po_b_wbc_edit->gst->Required) { ?>
			elm = this.getElements("x" + infix + "_gst");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->gst->caption(), $po_b_wbc->gst->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->partner_order_no->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_order_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->partner_order_no->caption(), $po_b_wbc->partner_order_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->partner_order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_order_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->partner_order_date->caption(), $po_b_wbc->partner_order_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_partner_order_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_b_wbc->partner_order_date->errorMessage()) ?>");
		<?php if ($po_b_wbc_edit->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->despatch_date->caption(), $po_b_wbc->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_b_wbc->despatch_date->errorMessage()) ?>");
		<?php if ($po_b_wbc_edit->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->despatch_week->caption(), $po_b_wbc->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->fob_date->Required) { ?>
			elm = this.getElements("x" + infix + "_fob_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->fob_date->caption(), $po_b_wbc->fob_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_fob_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_b_wbc->fob_date->errorMessage()) ?>");
		<?php if ($po_b_wbc_edit->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->production_plan->caption(), $po_b_wbc->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->part_dispatch->Required) { ?>
			elm = this.getElements("x" + infix + "_part_dispatch");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->part_dispatch->caption(), $po_b_wbc->part_dispatch->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->payment_terms->Required) { ?>
			elm = this.getElements("x" + infix + "_payment_terms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->payment_terms->caption(), $po_b_wbc->payment_terms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->transport_type->Required) { ?>
			elm = this.getElements("x" + infix + "_transport_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->transport_type->caption(), $po_b_wbc->transport_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->partner_shipping_id->Required) { ?>
			elm = this.getElements("x" + infix + "_partner_shipping_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->partner_shipping_id->caption(), $po_b_wbc->partner_shipping_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->remarks->caption(), $po_b_wbc->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->buyer_instruction->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_instruction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->buyer_instruction->caption(), $po_b_wbc->buyer_instruction->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->uploads->caption(), $po_b_wbc->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->d_09_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_09_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->d_09_head->caption(), $po_b_wbc->d_09_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->description_09->Required) { ?>
			elm = this.getElements("x" + infix + "_description_09");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->description_09->caption(), $po_b_wbc->description_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->d_10_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_10_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->d_10_head->caption(), $po_b_wbc->d_10_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->description_10->Required) { ?>
			elm = this.getElements("x" + infix + "_description_10");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->description_10->caption(), $po_b_wbc->description_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->d_11_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_11_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->d_11_head->caption(), $po_b_wbc->d_11_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->description_11->Required) { ?>
			elm = this.getElements("x" + infix + "_description_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->description_11->caption(), $po_b_wbc->description_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->d_12_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_12_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->d_12_head->caption(), $po_b_wbc->d_12_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->description_12->Required) { ?>
			elm = this.getElements("x" + infix + "_description_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->description_12->caption(), $po_b_wbc->description_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->production_site->Required) { ?>
			elm = this.getElements("x" + infix + "_production_site");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->production_site->caption(), $po_b_wbc->production_site->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->jc_no->Required) { ?>
			elm = this.getElements("x" + infix + "_jc_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->jc_no->caption(), $po_b_wbc->jc_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->balance_quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_balance_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->balance_quantity->caption(), $po_b_wbc->balance_quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->operator->caption(), $po_b_wbc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->e_mail->Required) { ?>
			elm = this.getElements("x" + infix + "_e_mail");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->e_mail->caption(), $po_b_wbc->e_mail->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->billing_address_id->Required) { ?>
			elm = this.getElements("x" + infix + "_billing_address_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->billing_address_id->caption(), $po_b_wbc->billing_address_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->shipping_address_id->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_address_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->shipping_address_id->caption(), $po_b_wbc->shipping_address_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->status->caption(), $po_b_wbc->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_b_wbc_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_b_wbc->datetime->caption(), $po_b_wbc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_b_wbcedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_b_wbcedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_b_wbcedit.multiPage = new ew.MultiPage("fpo_b_wbcedit");

// Dynamic selection lists
fpo_b_wbcedit.lists["x_company_id"] = <?php echo $po_b_wbc_edit->company_id->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_company_id"].options = <?php echo JsonEncode($po_b_wbc_edit->company_id->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_grp"] = <?php echo $po_b_wbc_edit->grp->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_grp"].options = <?php echo JsonEncode($po_b_wbc_edit->grp->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_location"] = <?php echo $po_b_wbc_edit->location->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_location"].options = <?php echo JsonEncode($po_b_wbc_edit->location->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_partner_id"] = <?php echo $po_b_wbc_edit->partner_id->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_partner_id"].options = <?php echo JsonEncode($po_b_wbc_edit->partner_id->lookupOptions()) ?>;
fpo_b_wbcedit.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_b_wbcedit.lists["x_cart_id[]"] = <?php echo $po_b_wbc_edit->cart_id->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_cart_id[]"].options = <?php echo JsonEncode($po_b_wbc_edit->cart_id->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_gst"] = <?php echo $po_b_wbc_edit->gst->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_gst"].options = <?php echo JsonEncode($po_b_wbc_edit->gst->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_despatch_week"] = <?php echo $po_b_wbc_edit->despatch_week->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_despatch_week"].options = <?php echo JsonEncode($po_b_wbc_edit->despatch_week->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_production_plan"] = <?php echo $po_b_wbc_edit->production_plan->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_production_plan"].options = <?php echo JsonEncode($po_b_wbc_edit->production_plan->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_part_dispatch"] = <?php echo $po_b_wbc_edit->part_dispatch->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_part_dispatch"].options = <?php echo JsonEncode($po_b_wbc_edit->part_dispatch->options(FALSE, TRUE)) ?>;
fpo_b_wbcedit.lists["x_payment_terms"] = <?php echo $po_b_wbc_edit->payment_terms->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_payment_terms"].options = <?php echo JsonEncode($po_b_wbc_edit->payment_terms->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_transport_type"] = <?php echo $po_b_wbc_edit->transport_type->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_transport_type"].options = <?php echo JsonEncode($po_b_wbc_edit->transport_type->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_partner_shipping_id"] = <?php echo $po_b_wbc_edit->partner_shipping_id->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_partner_shipping_id"].options = <?php echo JsonEncode($po_b_wbc_edit->partner_shipping_id->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_d_09_head"] = <?php echo $po_b_wbc_edit->d_09_head->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_d_09_head"].options = <?php echo JsonEncode($po_b_wbc_edit->d_09_head->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_d_10_head"] = <?php echo $po_b_wbc_edit->d_10_head->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_d_10_head"].options = <?php echo JsonEncode($po_b_wbc_edit->d_10_head->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_d_11_head"] = <?php echo $po_b_wbc_edit->d_11_head->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_d_11_head"].options = <?php echo JsonEncode($po_b_wbc_edit->d_11_head->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_d_12_head"] = <?php echo $po_b_wbc_edit->d_12_head->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_d_12_head"].options = <?php echo JsonEncode($po_b_wbc_edit->d_12_head->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_production_site"] = <?php echo $po_b_wbc_edit->production_site->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_production_site"].options = <?php echo JsonEncode($po_b_wbc_edit->production_site->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_operator"] = <?php echo $po_b_wbc_edit->operator->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_operator"].options = <?php echo JsonEncode($po_b_wbc_edit->operator->lookupOptions()) ?>;
fpo_b_wbcedit.lists["x_status"] = <?php echo $po_b_wbc_edit->status->Lookup->toClientList() ?>;
fpo_b_wbcedit.lists["x_status"].options = <?php echo JsonEncode($po_b_wbc_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_b_wbc_edit->showPageHeader(); ?>
<?php
$po_b_wbc_edit->showMessage();
?>
<form name="fpo_b_wbcedit" id="fpo_b_wbcedit" class="<?php echo $po_b_wbc_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_b_wbc_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_b_wbc_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_b_wbc">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$po_b_wbc_edit->IsModal ?>">
<?php if ($po_b_wbc_edit->MultiPages->Items[0]->Visible) { ?>
<div class="ew-edit-div"><!-- page0 -->
<?php if ($po_b_wbc->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_po_b_wbc_id" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->id->caption() ?><?php echo ($po_b_wbc->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->id->cellAttributes() ?>>
<span id="el_po_b_wbc_id">
<span<?php echo $po_b_wbc->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_id" data-page="0" name="x_id" id="x_id" value="<?php echo HtmlEncode($po_b_wbc->id->CurrentValue) ?>">
<?php echo $po_b_wbc->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_po_b_wbc_company_id" for="x_company_id" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->company_id->caption() ?><?php echo ($po_b_wbc->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->company_id->cellAttributes() ?>>
<span id="el_po_b_wbc_company_id">
<?php $po_b_wbc->company_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_b_wbc->company_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_company_id" data-page="0" data-value-separator="<?php echo $po_b_wbc->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_b_wbc->company_id->editAttributes() ?>>
		<?php echo $po_b_wbc->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_b_wbc->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $po_b_wbc->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_po_b_wbc_grp" for="x_grp" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->grp->caption() ?><?php echo ($po_b_wbc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->grp->cellAttributes() ?>>
<span id="el_po_b_wbc_grp">
<?php $po_b_wbc->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_b_wbc->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_grp" data-page="0" data-value-separator="<?php echo $po_b_wbc->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_b_wbc->grp->editAttributes() ?>>
		<?php echo $po_b_wbc->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $po_b_wbc->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $po_b_wbc->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_po_b_wbc_location" for="x_location" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->location->caption() ?><?php echo ($po_b_wbc->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->location->cellAttributes() ?>>
<span id="el_po_b_wbc_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_location" data-page="0" data-value-separator="<?php echo $po_b_wbc->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $po_b_wbc->location->editAttributes() ?>>
		<?php echo $po_b_wbc->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $po_b_wbc->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $po_b_wbc->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_po_b_wbc_po" for="x_po" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->po->caption() ?><?php echo ($po_b_wbc->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->po->cellAttributes() ?>>
<span id="el_po_b_wbc_po">
<span<?php echo $po_b_wbc->po->viewAttributes() ?>>
<?php if ((!EmptyString($po_b_wbc->po->EditValue)) && $po_b_wbc->po->linkAttributes() <> "") { ?>
<a<?php echo $po_b_wbc->po->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->po->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->po->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_po" data-page="0" name="x_po" id="x_po" value="<?php echo HtmlEncode($po_b_wbc->po->CurrentValue) ?>">
<?php echo $po_b_wbc->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label id="elh_po_b_wbc_partner_id" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->partner_id->caption() ?><?php echo ($po_b_wbc->partner_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->partner_id->cellAttributes() ?>>
<span id="el_po_b_wbc_partner_id">
<?php
$wrkonchange = "" . trim(@$po_b_wbc->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_b_wbc->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_b_wbc->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_b_wbc->partner_id->getPlaceHolder()) ?>"<?php echo $po_b_wbc->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_partner_id" data-page="0" data-value-separator="<?php echo $po_b_wbc->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_b_wbc->partner_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_b_wbcedit.createAutoSuggest({"id":"x_partner_id","forceSelect":true});
</script>
<?php echo $po_b_wbc->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
<?php echo $po_b_wbc->partner_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->cart_id->Visible) { // cart_id ?>
	<div id="r_cart_id" class="form-group row">
		<label id="elh_po_b_wbc_cart_id" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->cart_id->caption() ?><?php echo ($po_b_wbc->cart_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->cart_id->cellAttributes() ?>>
<span id="el_po_b_wbc_cart_id">
<div id="tp_x_cart_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="po_b_wbc" data-field="x_cart_id" data-page="0" data-value-separator="<?php echo $po_b_wbc->cart_id->displayValueSeparatorAttribute() ?>" name="x_cart_id[]" id="x_cart_id[]" value="{value}"<?php echo $po_b_wbc->cart_id->editAttributes() ?>></div>
<div id="dsl_x_cart_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $po_b_wbc->cart_id->checkBoxListHtml(FALSE, "x_cart_id[]", 0) ?>
</div></div>
<?php echo $po_b_wbc->cart_id->Lookup->getParamTag("p_x_cart_id") ?>
</span>
<?php echo $po_b_wbc->cart_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="po_b_wbc_edit"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $po_b_wbc_edit->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_b_wbc_edit->MultiPages->isActive("1")) ?>" href="#tab_po_b_wbc1"><?php echo $po_b_wbc->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_b_wbc_edit->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $po_b_wbc_edit->MultiPages->Parent ?>" id="tab_po_b_wbc1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_b_wbc->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_po_b_wbc_sqm" for="x_sqm" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->sqm->caption() ?><?php echo ($po_b_wbc->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->sqm->cellAttributes() ?>>
<span id="el_po_b_wbc_sqm">
<input type="text" data-table="po_b_wbc" data-field="x_sqm" data-page="1" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->sqm->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->sqm->EditValue ?>"<?php echo $po_b_wbc->sqm->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_po_b_wbc_quantity" for="x_quantity" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->quantity->caption() ?><?php echo ($po_b_wbc->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->quantity->cellAttributes() ?>>
<span id="el_po_b_wbc_quantity">
<input type="text" data-table="po_b_wbc" data-field="x_quantity" data-page="1" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->quantity->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->quantity->EditValue ?>"<?php echo $po_b_wbc->quantity->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_po_b_wbc_amount" for="x_amount" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->amount->caption() ?><?php echo ($po_b_wbc->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->amount->cellAttributes() ?>>
<span id="el_po_b_wbc_amount">
<input type="text" data-table="po_b_wbc" data-field="x_amount" data-page="1" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->amount->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->amount->EditValue ?>"<?php echo $po_b_wbc->amount->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label id="elh_po_b_wbc_cbm" for="x_cbm" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->cbm->caption() ?><?php echo ($po_b_wbc->cbm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->cbm->cellAttributes() ?>>
<span id="el_po_b_wbc_cbm">
<input type="text" data-table="po_b_wbc" data-field="x_cbm" data-page="1" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->cbm->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->cbm->EditValue ?>"<?php echo $po_b_wbc->cbm->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->cbm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label id="elh_po_b_wbc_gst" for="x_gst" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->gst->caption() ?><?php echo ($po_b_wbc->gst->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->gst->cellAttributes() ?>>
<span id="el_po_b_wbc_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_gst" data-page="1" data-value-separator="<?php echo $po_b_wbc->gst->displayValueSeparatorAttribute() ?>" id="x_gst" name="x_gst"<?php echo $po_b_wbc->gst->editAttributes() ?>>
		<?php echo $po_b_wbc->gst->selectOptionListHtml("x_gst") ?>
	</select>
</div>
<?php echo $po_b_wbc->gst->Lookup->getParamTag("p_x_gst") ?>
</span>
<?php echo $po_b_wbc->gst->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $po_b_wbc_edit->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_b_wbc_edit->MultiPages->isActive("2")) ?>" href="#tab_po_b_wbc2"><?php echo $po_b_wbc->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_b_wbc_edit->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $po_b_wbc_edit->MultiPages->Parent ?>" id="tab_po_b_wbc2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_b_wbc->partner_order_no->Visible) { // partner_order_no ?>
	<div id="r_partner_order_no" class="form-group row">
		<label id="elh_po_b_wbc_partner_order_no" for="x_partner_order_no" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->partner_order_no->caption() ?><?php echo ($po_b_wbc->partner_order_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->partner_order_no->cellAttributes() ?>>
<span id="el_po_b_wbc_partner_order_no">
<input type="text" data-table="po_b_wbc" data-field="x_partner_order_no" data-page="2" name="x_partner_order_no" id="x_partner_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_b_wbc->partner_order_no->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->partner_order_no->EditValue ?>"<?php echo $po_b_wbc->partner_order_no->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->partner_order_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->partner_order_date->Visible) { // partner_order_date ?>
	<div id="r_partner_order_date" class="form-group row">
		<label id="elh_po_b_wbc_partner_order_date" for="x_partner_order_date" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->partner_order_date->caption() ?><?php echo ($po_b_wbc->partner_order_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->partner_order_date->cellAttributes() ?>>
<span id="el_po_b_wbc_partner_order_date">
<input type="text" data-table="po_b_wbc" data-field="x_partner_order_date" data-page="2" name="x_partner_order_date" id="x_partner_order_date" placeholder="<?php echo HtmlEncode($po_b_wbc->partner_order_date->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->partner_order_date->EditValue ?>"<?php echo $po_b_wbc->partner_order_date->editAttributes() ?>>
<?php if (!$po_b_wbc->partner_order_date->ReadOnly && !$po_b_wbc->partner_order_date->Disabled && !isset($po_b_wbc->partner_order_date->EditAttrs["readonly"]) && !isset($po_b_wbc->partner_order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_b_wbcedit", "x_partner_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_b_wbc->partner_order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_po_b_wbc_despatch_date" for="x_despatch_date" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->despatch_date->caption() ?><?php echo ($po_b_wbc->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->despatch_date->cellAttributes() ?>>
<span id="el_po_b_wbc_despatch_date">
<input type="text" data-table="po_b_wbc" data-field="x_despatch_date" data-page="2" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($po_b_wbc->despatch_date->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->despatch_date->EditValue ?>"<?php echo $po_b_wbc->despatch_date->editAttributes() ?>>
<?php if (!$po_b_wbc->despatch_date->ReadOnly && !$po_b_wbc->despatch_date->Disabled && !isset($po_b_wbc->despatch_date->EditAttrs["readonly"]) && !isset($po_b_wbc->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_b_wbcedit", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_b_wbc->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_po_b_wbc_despatch_week" for="x_despatch_week" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->despatch_week->caption() ?><?php echo ($po_b_wbc->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->despatch_week->cellAttributes() ?>>
<span id="el_po_b_wbc_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_despatch_week" data-page="2" data-value-separator="<?php echo $po_b_wbc->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $po_b_wbc->despatch_week->editAttributes() ?>>
		<?php echo $po_b_wbc->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $po_b_wbc->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
<?php echo $po_b_wbc->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->fob_date->Visible) { // fob_date ?>
	<div id="r_fob_date" class="form-group row">
		<label id="elh_po_b_wbc_fob_date" for="x_fob_date" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->fob_date->caption() ?><?php echo ($po_b_wbc->fob_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->fob_date->cellAttributes() ?>>
<span id="el_po_b_wbc_fob_date">
<input type="text" data-table="po_b_wbc" data-field="x_fob_date" data-page="2" name="x_fob_date" id="x_fob_date" placeholder="<?php echo HtmlEncode($po_b_wbc->fob_date->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->fob_date->EditValue ?>"<?php echo $po_b_wbc->fob_date->editAttributes() ?>>
<?php if (!$po_b_wbc->fob_date->ReadOnly && !$po_b_wbc->fob_date->Disabled && !isset($po_b_wbc->fob_date->EditAttrs["readonly"]) && !isset($po_b_wbc->fob_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_b_wbcedit", "x_fob_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_b_wbc->fob_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_po_b_wbc_production_plan" for="x_production_plan" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->production_plan->caption() ?><?php echo ($po_b_wbc->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->production_plan->cellAttributes() ?>>
<span id="el_po_b_wbc_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_production_plan" data-page="2" data-value-separator="<?php echo $po_b_wbc->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $po_b_wbc->production_plan->editAttributes() ?>>
		<?php echo $po_b_wbc->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
<?php echo $po_b_wbc->production_plan->Lookup->getParamTag("p_x_production_plan") ?>
</span>
<?php echo $po_b_wbc->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->part_dispatch->Visible) { // part_dispatch ?>
	<div id="r_part_dispatch" class="form-group row">
		<label id="elh_po_b_wbc_part_dispatch" for="x_part_dispatch" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->part_dispatch->caption() ?><?php echo ($po_b_wbc->part_dispatch->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->part_dispatch->cellAttributes() ?>>
<span id="el_po_b_wbc_part_dispatch">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_part_dispatch" data-page="2" data-value-separator="<?php echo $po_b_wbc->part_dispatch->displayValueSeparatorAttribute() ?>" id="x_part_dispatch" name="x_part_dispatch"<?php echo $po_b_wbc->part_dispatch->editAttributes() ?>>
		<?php echo $po_b_wbc->part_dispatch->selectOptionListHtml("x_part_dispatch") ?>
	</select>
</div>
</span>
<?php echo $po_b_wbc->part_dispatch->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label id="elh_po_b_wbc_payment_terms" for="x_payment_terms" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->payment_terms->caption() ?><?php echo ($po_b_wbc->payment_terms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->payment_terms->cellAttributes() ?>>
<span id="el_po_b_wbc_payment_terms">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_payment_terms" data-page="2" data-value-separator="<?php echo $po_b_wbc->payment_terms->displayValueSeparatorAttribute() ?>" id="x_payment_terms" name="x_payment_terms"<?php echo $po_b_wbc->payment_terms->editAttributes() ?>>
		<?php echo $po_b_wbc->payment_terms->selectOptionListHtml("x_payment_terms") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "misc") && !$po_b_wbc->payment_terms->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_payment_terms" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_b_wbc->payment_terms->caption() ?>" data-title="<?php echo $po_b_wbc->payment_terms->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_payment_terms',url:'miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_b_wbc->payment_terms->Lookup->getParamTag("p_x_payment_terms") ?>
</span>
<?php echo $po_b_wbc->payment_terms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->transport_type->Visible) { // transport_type ?>
	<div id="r_transport_type" class="form-group row">
		<label id="elh_po_b_wbc_transport_type" for="x_transport_type" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->transport_type->caption() ?><?php echo ($po_b_wbc->transport_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->transport_type->cellAttributes() ?>>
<span id="el_po_b_wbc_transport_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_transport_type" data-page="2" data-value-separator="<?php echo $po_b_wbc->transport_type->displayValueSeparatorAttribute() ?>" id="x_transport_type" name="x_transport_type"<?php echo $po_b_wbc->transport_type->editAttributes() ?>>
		<?php echo $po_b_wbc->transport_type->selectOptionListHtml("x_transport_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "misc") && !$po_b_wbc->transport_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_transport_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_b_wbc->transport_type->caption() ?>" data-title="<?php echo $po_b_wbc->transport_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_transport_type',url:'miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_b_wbc->transport_type->Lookup->getParamTag("p_x_transport_type") ?>
</span>
<?php echo $po_b_wbc->transport_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->partner_shipping_id->Visible) { // partner_shipping_id ?>
	<div id="r_partner_shipping_id" class="form-group row">
		<label id="elh_po_b_wbc_partner_shipping_id" for="x_partner_shipping_id" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->partner_shipping_id->caption() ?><?php echo ($po_b_wbc->partner_shipping_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->partner_shipping_id->cellAttributes() ?>>
<span id="el_po_b_wbc_partner_shipping_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_partner_shipping_id" data-page="2" data-value-separator="<?php echo $po_b_wbc->partner_shipping_id->displayValueSeparatorAttribute() ?>" id="x_partner_shipping_id" name="x_partner_shipping_id"<?php echo $po_b_wbc->partner_shipping_id->editAttributes() ?>>
		<?php echo $po_b_wbc->partner_shipping_id->selectOptionListHtml("x_partner_shipping_id") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "shipping_address") && !$po_b_wbc->partner_shipping_id->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_partner_shipping_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_b_wbc->partner_shipping_id->caption() ?>" data-title="<?php echo $po_b_wbc->partner_shipping_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_partner_shipping_id',url:'shipping_addressaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_b_wbc->partner_shipping_id->Lookup->getParamTag("p_x_partner_shipping_id") ?>
</span>
<?php echo $po_b_wbc->partner_shipping_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_po_b_wbc_remarks" for="x_remarks" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->remarks->caption() ?><?php echo ($po_b_wbc->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->remarks->cellAttributes() ?>>
<span id="el_po_b_wbc_remarks">
<textarea data-table="po_b_wbc" data-field="x_remarks" data-page="2" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po_b_wbc->remarks->getPlaceHolder()) ?>"<?php echo $po_b_wbc->remarks->editAttributes() ?>><?php echo $po_b_wbc->remarks->EditValue ?></textarea>
</span>
<?php echo $po_b_wbc->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label id="elh_po_b_wbc_buyer_instruction" for="x_buyer_instruction" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->buyer_instruction->caption() ?><?php echo ($po_b_wbc->buyer_instruction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->buyer_instruction->cellAttributes() ?>>
<span id="el_po_b_wbc_buyer_instruction">
<textarea data-table="po_b_wbc" data-field="x_buyer_instruction" data-page="2" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po_b_wbc->buyer_instruction->getPlaceHolder()) ?>"<?php echo $po_b_wbc->buyer_instruction->editAttributes() ?>><?php echo $po_b_wbc->buyer_instruction->EditValue ?></textarea>
</span>
<?php echo $po_b_wbc->buyer_instruction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_po_b_wbc_uploads" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->uploads->caption() ?><?php echo ($po_b_wbc->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->uploads->cellAttributes() ?>>
<span id="el_po_b_wbc_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $po_b_wbc->uploads->title() ? $po_b_wbc->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($po_b_wbc->uploads->ReadOnly || $po_b_wbc->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="po_b_wbc" data-field="x_uploads" data-page="2" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $po_b_wbc->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $po_b_wbc->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="500">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $po_b_wbc->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $po_b_wbc->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $po_b_wbc->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $po_b_wbc->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->d_09_head->Visible) { // d_09_head ?>
	<div id="r_d_09_head" class="form-group row">
		<label id="elh_po_b_wbc_d_09_head" for="x_d_09_head" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->d_09_head->caption() ?><?php echo ($po_b_wbc->d_09_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->d_09_head->cellAttributes() ?>>
<span id="el_po_b_wbc_d_09_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_d_09_head" data-page="2" data-value-separator="<?php echo $po_b_wbc->d_09_head->displayValueSeparatorAttribute() ?>" id="x_d_09_head" name="x_d_09_head"<?php echo $po_b_wbc->d_09_head->editAttributes() ?>>
		<?php echo $po_b_wbc->d_09_head->selectOptionListHtml("x_d_09_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_b_wbc->d_09_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_09_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_b_wbc->d_09_head->caption() ?>" data-title="<?php echo $po_b_wbc->d_09_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_09_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_b_wbc->d_09_head->Lookup->getParamTag("p_x_d_09_head") ?>
</span>
<?php echo $po_b_wbc->d_09_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label id="elh_po_b_wbc_description_09" for="x_description_09" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->description_09->caption() ?><?php echo ($po_b_wbc->description_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->description_09->cellAttributes() ?>>
<span id="el_po_b_wbc_description_09">
<input type="text" data-table="po_b_wbc" data-field="x_description_09" data-page="2" name="x_description_09" id="x_description_09" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_b_wbc->description_09->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->description_09->EditValue ?>"<?php echo $po_b_wbc->description_09->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->description_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->d_10_head->Visible) { // d_10_head ?>
	<div id="r_d_10_head" class="form-group row">
		<label id="elh_po_b_wbc_d_10_head" for="x_d_10_head" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->d_10_head->caption() ?><?php echo ($po_b_wbc->d_10_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->d_10_head->cellAttributes() ?>>
<span id="el_po_b_wbc_d_10_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_d_10_head" data-page="2" data-value-separator="<?php echo $po_b_wbc->d_10_head->displayValueSeparatorAttribute() ?>" id="x_d_10_head" name="x_d_10_head"<?php echo $po_b_wbc->d_10_head->editAttributes() ?>>
		<?php echo $po_b_wbc->d_10_head->selectOptionListHtml("x_d_10_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_b_wbc->d_10_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_10_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_b_wbc->d_10_head->caption() ?>" data-title="<?php echo $po_b_wbc->d_10_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_10_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_b_wbc->d_10_head->Lookup->getParamTag("p_x_d_10_head") ?>
</span>
<?php echo $po_b_wbc->d_10_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label id="elh_po_b_wbc_description_10" for="x_description_10" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->description_10->caption() ?><?php echo ($po_b_wbc->description_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->description_10->cellAttributes() ?>>
<span id="el_po_b_wbc_description_10">
<input type="text" data-table="po_b_wbc" data-field="x_description_10" data-page="2" name="x_description_10" id="x_description_10" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_b_wbc->description_10->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->description_10->EditValue ?>"<?php echo $po_b_wbc->description_10->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->description_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->d_11_head->Visible) { // d_11_head ?>
	<div id="r_d_11_head" class="form-group row">
		<label id="elh_po_b_wbc_d_11_head" for="x_d_11_head" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->d_11_head->caption() ?><?php echo ($po_b_wbc->d_11_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->d_11_head->cellAttributes() ?>>
<span id="el_po_b_wbc_d_11_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_d_11_head" data-page="2" data-value-separator="<?php echo $po_b_wbc->d_11_head->displayValueSeparatorAttribute() ?>" id="x_d_11_head" name="x_d_11_head"<?php echo $po_b_wbc->d_11_head->editAttributes() ?>>
		<?php echo $po_b_wbc->d_11_head->selectOptionListHtml("x_d_11_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_b_wbc->d_11_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_11_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_b_wbc->d_11_head->caption() ?>" data-title="<?php echo $po_b_wbc->d_11_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_11_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_b_wbc->d_11_head->Lookup->getParamTag("p_x_d_11_head") ?>
</span>
<?php echo $po_b_wbc->d_11_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label id="elh_po_b_wbc_description_11" for="x_description_11" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->description_11->caption() ?><?php echo ($po_b_wbc->description_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->description_11->cellAttributes() ?>>
<span id="el_po_b_wbc_description_11">
<input type="text" data-table="po_b_wbc" data-field="x_description_11" data-page="2" name="x_description_11" id="x_description_11" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_b_wbc->description_11->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->description_11->EditValue ?>"<?php echo $po_b_wbc->description_11->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->description_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->d_12_head->Visible) { // d_12_head ?>
	<div id="r_d_12_head" class="form-group row">
		<label id="elh_po_b_wbc_d_12_head" for="x_d_12_head" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->d_12_head->caption() ?><?php echo ($po_b_wbc->d_12_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->d_12_head->cellAttributes() ?>>
<span id="el_po_b_wbc_d_12_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_d_12_head" data-page="2" data-value-separator="<?php echo $po_b_wbc->d_12_head->displayValueSeparatorAttribute() ?>" id="x_d_12_head" name="x_d_12_head"<?php echo $po_b_wbc->d_12_head->editAttributes() ?>>
		<?php echo $po_b_wbc->d_12_head->selectOptionListHtml("x_d_12_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_b_wbc->d_12_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_12_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_b_wbc->d_12_head->caption() ?>" data-title="<?php echo $po_b_wbc->d_12_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_12_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_b_wbc->d_12_head->Lookup->getParamTag("p_x_d_12_head") ?>
</span>
<?php echo $po_b_wbc->d_12_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->description_12->Visible) { // description_12 ?>
	<div id="r_description_12" class="form-group row">
		<label id="elh_po_b_wbc_description_12" for="x_description_12" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->description_12->caption() ?><?php echo ($po_b_wbc->description_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->description_12->cellAttributes() ?>>
<span id="el_po_b_wbc_description_12">
<input type="text" data-table="po_b_wbc" data-field="x_description_12" data-page="2" name="x_description_12" id="x_description_12" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_b_wbc->description_12->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->description_12->EditValue ?>"<?php echo $po_b_wbc->description_12->editAttributes() ?>>
</span>
<?php echo $po_b_wbc->description_12->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $po_b_wbc_edit->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_b_wbc_edit->MultiPages->isActive("3")) ?>" href="#tab_po_b_wbc3"><?php echo $po_b_wbc->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_b_wbc_edit->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $po_b_wbc_edit->MultiPages->Parent ?>" id="tab_po_b_wbc3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_b_wbc->production_site->Visible) { // production_site ?>
	<div id="r_production_site" class="form-group row">
		<label id="elh_po_b_wbc_production_site" for="x_production_site" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->production_site->caption() ?><?php echo ($po_b_wbc->production_site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->production_site->cellAttributes() ?>>
<span id="el_po_b_wbc_production_site">
<span<?php echo $po_b_wbc->production_site->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->production_site->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_production_site" data-page="3" name="x_production_site" id="x_production_site" value="<?php echo HtmlEncode($po_b_wbc->production_site->CurrentValue) ?>">
<?php echo $po_b_wbc->production_site->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label id="elh_po_b_wbc_jc_no" for="x_jc_no" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->jc_no->caption() ?><?php echo ($po_b_wbc->jc_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->jc_no->cellAttributes() ?>>
<span id="el_po_b_wbc_jc_no">
<span<?php echo $po_b_wbc->jc_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->jc_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_jc_no" data-page="3" name="x_jc_no" id="x_jc_no" value="<?php echo HtmlEncode($po_b_wbc->jc_no->CurrentValue) ?>">
<?php echo $po_b_wbc->jc_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->balance_quantity->Visible) { // balance_quantity ?>
	<div id="r_balance_quantity" class="form-group row">
		<label id="elh_po_b_wbc_balance_quantity" for="x_balance_quantity" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->balance_quantity->caption() ?><?php echo ($po_b_wbc->balance_quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->balance_quantity->cellAttributes() ?>>
<span id="el_po_b_wbc_balance_quantity">
<span<?php echo $po_b_wbc->balance_quantity->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->balance_quantity->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_balance_quantity" data-page="3" name="x_balance_quantity" id="x_balance_quantity" value="<?php echo HtmlEncode($po_b_wbc->balance_quantity->CurrentValue) ?>">
<?php echo $po_b_wbc->balance_quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->e_mail->Visible) { // e_mail ?>
	<div id="r_e_mail" class="form-group row">
		<label id="elh_po_b_wbc_e_mail" for="x_e_mail" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->e_mail->caption() ?><?php echo ($po_b_wbc->e_mail->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->e_mail->cellAttributes() ?>>
<span id="el_po_b_wbc_e_mail">
<span<?php echo $po_b_wbc->e_mail->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->e_mail->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_e_mail" data-page="3" name="x_e_mail" id="x_e_mail" value="<?php echo HtmlEncode($po_b_wbc->e_mail->CurrentValue) ?>">
<?php echo $po_b_wbc->e_mail->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->billing_address_id->Visible) { // billing_address_id ?>
	<div id="r_billing_address_id" class="form-group row">
		<label id="elh_po_b_wbc_billing_address_id" for="x_billing_address_id" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->billing_address_id->caption() ?><?php echo ($po_b_wbc->billing_address_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->billing_address_id->cellAttributes() ?>>
<span id="el_po_b_wbc_billing_address_id">
<span<?php echo $po_b_wbc->billing_address_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->billing_address_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_billing_address_id" data-page="3" name="x_billing_address_id" id="x_billing_address_id" value="<?php echo HtmlEncode($po_b_wbc->billing_address_id->CurrentValue) ?>">
<?php echo $po_b_wbc->billing_address_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->shipping_address_id->Visible) { // shipping_address_id ?>
	<div id="r_shipping_address_id" class="form-group row">
		<label id="elh_po_b_wbc_shipping_address_id" for="x_shipping_address_id" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->shipping_address_id->caption() ?><?php echo ($po_b_wbc->shipping_address_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->shipping_address_id->cellAttributes() ?>>
<span id="el_po_b_wbc_shipping_address_id">
<span<?php echo $po_b_wbc->shipping_address_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->shipping_address_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_shipping_address_id" data-page="3" name="x_shipping_address_id" id="x_shipping_address_id" value="<?php echo HtmlEncode($po_b_wbc->shipping_address_id->CurrentValue) ?>">
<?php echo $po_b_wbc->shipping_address_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_po_b_wbc_status" for="x_status" class="<?php echo $po_b_wbc_edit->LeftColumnClass ?>"><?php echo $po_b_wbc->status->caption() ?><?php echo ($po_b_wbc->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_b_wbc_edit->RightColumnClass ?>"><div<?php echo $po_b_wbc->status->cellAttributes() ?>>
<span id="el_po_b_wbc_status">
<span<?php echo $po_b_wbc->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_b_wbc->status->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_status" data-page="3" name="x_status" id="x_status" value="<?php echo HtmlEncode($po_b_wbc->status->CurrentValue) ?>">
<?php echo $po_b_wbc->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$po_b_wbc_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_b_wbc_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_b_wbc_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_b_wbc_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_b_wbc_edit->terminate();
?>