<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_b_wbc_list = new po_b_wbc_list();

// Run the page
$po_b_wbc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_b_wbc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_b_wbc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_b_wbclist = currentForm = new ew.Form("fpo_b_wbclist", "list");
fpo_b_wbclist.formKeyCountName = '<?php echo $po_b_wbc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_b_wbclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_b_wbclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_b_wbclist.lists["x_company_id"] = <?php echo $po_b_wbc_list->company_id->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_company_id"].options = <?php echo JsonEncode($po_b_wbc_list->company_id->lookupOptions()) ?>;
fpo_b_wbclist.lists["x_partner_id"] = <?php echo $po_b_wbc_list->partner_id->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_partner_id"].options = <?php echo JsonEncode($po_b_wbc_list->partner_id->lookupOptions()) ?>;
fpo_b_wbclist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_b_wbclist.lists["x_gst"] = <?php echo $po_b_wbc_list->gst->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_gst"].options = <?php echo JsonEncode($po_b_wbc_list->gst->lookupOptions()) ?>;
fpo_b_wbclist.lists["x_despatch_week"] = <?php echo $po_b_wbc_list->despatch_week->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_despatch_week"].options = <?php echo JsonEncode($po_b_wbc_list->despatch_week->lookupOptions()) ?>;
fpo_b_wbclist.lists["x_payment_terms"] = <?php echo $po_b_wbc_list->payment_terms->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_payment_terms"].options = <?php echo JsonEncode($po_b_wbc_list->payment_terms->lookupOptions()) ?>;
fpo_b_wbclist.lists["x_transport_type"] = <?php echo $po_b_wbc_list->transport_type->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_transport_type"].options = <?php echo JsonEncode($po_b_wbc_list->transport_type->lookupOptions()) ?>;
fpo_b_wbclist.lists["x_partner_shipping_id"] = <?php echo $po_b_wbc_list->partner_shipping_id->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_partner_shipping_id"].options = <?php echo JsonEncode($po_b_wbc_list->partner_shipping_id->lookupOptions()) ?>;
fpo_b_wbclist.lists["x_operator"] = <?php echo $po_b_wbc_list->operator->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_operator"].options = <?php echo JsonEncode($po_b_wbc_list->operator->lookupOptions()) ?>;
fpo_b_wbclist.lists["x_a_operator"] = <?php echo $po_b_wbc_list->a_operator->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_a_operator"].options = <?php echo JsonEncode($po_b_wbc_list->a_operator->lookupOptions()) ?>;
fpo_b_wbclist.lists["x_app_operator"] = <?php echo $po_b_wbc_list->app_operator->Lookup->toClientList() ?>;
fpo_b_wbclist.lists["x_app_operator"].options = <?php echo JsonEncode($po_b_wbc_list->app_operator->lookupOptions()) ?>;

// Form object for search
var fpo_b_wbclistsrch = currentSearchForm = new ew.Form("fpo_b_wbclistsrch");

// Validate function for search
fpo_b_wbclistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_wbc->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_b_wbclistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_b_wbclistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_b_wbclistsrch.lists["x_company_id"] = <?php echo $po_b_wbc_list->company_id->Lookup->toClientList() ?>;
fpo_b_wbclistsrch.lists["x_company_id"].options = <?php echo JsonEncode($po_b_wbc_list->company_id->lookupOptions()) ?>;
fpo_b_wbclistsrch.lists["x_partner_id"] = <?php echo $po_b_wbc_list->partner_id->Lookup->toClientList() ?>;
fpo_b_wbclistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($po_b_wbc_list->partner_id->lookupOptions()) ?>;
fpo_b_wbclistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpo_b_wbclistsrch.filterList = <?php echo $po_b_wbc_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_b_wbclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_b_wbc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_b_wbc_list->TotalRecs > 0 && $po_b_wbc_list->ExportOptions->visible()) { ?>
<?php $po_b_wbc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_b_wbc_list->ImportOptions->visible()) { ?>
<?php $po_b_wbc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_b_wbc_list->SearchOptions->visible()) { ?>
<?php $po_b_wbc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_b_wbc_list->FilterOptions->visible()) { ?>
<?php $po_b_wbc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_b_wbc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_b_wbc->isExport() && !$po_b_wbc->CurrentAction) { ?>
<form name="fpo_b_wbclistsrch" id="fpo_b_wbclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_b_wbc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_b_wbclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_b_wbc">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_b_wbc_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_b_wbc->RowType = ROWTYPE_SEARCH;

// Render row
$po_b_wbc->resetAttributes();
$po_b_wbc_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_b_wbc->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label for="x_company_id" class="ew-search-caption ew-label"><?php echo $po_b_wbc->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_company_id" data-value-separator="<?php echo $po_b_wbc->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_b_wbc->company_id->editAttributes() ?>>
		<?php echo $po_b_wbc->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_b_wbc->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_b_wbc->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $po_b_wbc->po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="po_b_wbc" data-field="x_po" name="x_po" id="x_po" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($po_b_wbc->po->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->po->EditValue ?>"<?php echo $po_b_wbc->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($po_b_wbc->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $po_b_wbc->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$po_b_wbc->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_b_wbc->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_b_wbc->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_b_wbc->partner_id->getPlaceHolder()) ?>"<?php echo $po_b_wbc->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_partner_id" data-value-separator="<?php echo $po_b_wbc->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_b_wbc->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_b_wbclistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $po_b_wbc->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_b_wbc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_b_wbc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_b_wbc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_b_wbc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_b_wbc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_b_wbc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_b_wbc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_b_wbc_list->showPageHeader(); ?>
<?php
$po_b_wbc_list->showMessage();
?>
<?php if ($po_b_wbc_list->TotalRecs > 0 || $po_b_wbc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_b_wbc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_b_wbc">
<?php if (!$po_b_wbc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_b_wbc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_b_wbc_list->Pager)) $po_b_wbc_list->Pager = new PrevNextPager($po_b_wbc_list->StartRec, $po_b_wbc_list->DisplayRecs, $po_b_wbc_list->TotalRecs, $po_b_wbc_list->AutoHidePager) ?>
<?php if ($po_b_wbc_list->Pager->RecordCount > 0 && $po_b_wbc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_b_wbc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_b_wbc_list->pageUrl() ?>start=<?php echo $po_b_wbc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_b_wbc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_b_wbc_list->pageUrl() ?>start=<?php echo $po_b_wbc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_b_wbc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_b_wbc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_b_wbc_list->pageUrl() ?>start=<?php echo $po_b_wbc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_b_wbc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_b_wbc_list->pageUrl() ?>start=<?php echo $po_b_wbc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_b_wbc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_b_wbc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_b_wbc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_b_wbc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_b_wbc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_b_wbc_list->TotalRecs > 0 && (!$po_b_wbc_list->AutoHidePageSizeSelector || $po_b_wbc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_b_wbc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_b_wbc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_b_wbc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_b_wbc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_b_wbc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_b_wbc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_b_wbc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_b_wbc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_b_wbclist" id="fpo_b_wbclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_b_wbc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_b_wbc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_b_wbc">
<div id="gmp_po_b_wbc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_b_wbc_list->TotalRecs > 0 || $po_b_wbc->isGridEdit()) { ?>
<table id="tbl_po_b_wbclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_b_wbc_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_b_wbc_list->renderListOptions();

// Render list options (header, left)
$po_b_wbc_list->ListOptions->render("header", "left");
?>
<?php if ($po_b_wbc->id->Visible) { // id ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_b_wbc->id->headerCellClass() ?>"><div id="elh_po_b_wbc_id" class="po_b_wbc_id"><div class="ew-table-header-caption"><?php echo $po_b_wbc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_b_wbc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->id) ?>',2);"><div id="elh_po_b_wbc_id" class="po_b_wbc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->company_id->Visible) { // company_id ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $po_b_wbc->company_id->headerCellClass() ?>"><div id="elh_po_b_wbc_company_id" class="po_b_wbc_company_id"><div class="ew-table-header-caption"><?php echo $po_b_wbc->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $po_b_wbc->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->company_id) ?>',2);"><div id="elh_po_b_wbc_company_id" class="po_b_wbc_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->po->Visible) { // po ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->po) == "") { ?>
		<th data-name="po" class="<?php echo $po_b_wbc->po->headerCellClass() ?>"><div id="elh_po_b_wbc_po" class="po_b_wbc_po"><div class="ew-table-header-caption"><?php echo $po_b_wbc->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $po_b_wbc->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->po) ?>',2);"><div id="elh_po_b_wbc_po" class="po_b_wbc_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->partner_id->Visible) { // partner_id ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $po_b_wbc->partner_id->headerCellClass() ?>"><div id="elh_po_b_wbc_partner_id" class="po_b_wbc_partner_id"><div class="ew-table-header-caption"><?php echo $po_b_wbc->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $po_b_wbc->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->partner_id) ?>',2);"><div id="elh_po_b_wbc_partner_id" class="po_b_wbc_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->partner_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->sqm->Visible) { // sqm ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $po_b_wbc->sqm->headerCellClass() ?>"><div id="elh_po_b_wbc_sqm" class="po_b_wbc_sqm"><div class="ew-table-header-caption"><?php echo $po_b_wbc->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $po_b_wbc->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->sqm) ?>',2);"><div id="elh_po_b_wbc_sqm" class="po_b_wbc_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->quantity->Visible) { // quantity ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $po_b_wbc->quantity->headerCellClass() ?>"><div id="elh_po_b_wbc_quantity" class="po_b_wbc_quantity"><div class="ew-table-header-caption"><?php echo $po_b_wbc->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $po_b_wbc->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->quantity) ?>',2);"><div id="elh_po_b_wbc_quantity" class="po_b_wbc_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->amount->Visible) { // amount ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $po_b_wbc->amount->headerCellClass() ?>"><div id="elh_po_b_wbc_amount" class="po_b_wbc_amount"><div class="ew-table-header-caption"><?php echo $po_b_wbc->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $po_b_wbc->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->amount) ?>',2);"><div id="elh_po_b_wbc_amount" class="po_b_wbc_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->cbm->Visible) { // cbm ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $po_b_wbc->cbm->headerCellClass() ?>"><div id="elh_po_b_wbc_cbm" class="po_b_wbc_cbm"><div class="ew-table-header-caption"><?php echo $po_b_wbc->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $po_b_wbc->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->cbm) ?>',2);"><div id="elh_po_b_wbc_cbm" class="po_b_wbc_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->gst->Visible) { // gst ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $po_b_wbc->gst->headerCellClass() ?>"><div id="elh_po_b_wbc_gst" class="po_b_wbc_gst"><div class="ew-table-header-caption"><?php echo $po_b_wbc->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $po_b_wbc->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->gst) ?>',2);"><div id="elh_po_b_wbc_gst" class="po_b_wbc_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->gst->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->partner_order_no->Visible) { // partner_order_no ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->partner_order_no) == "") { ?>
		<th data-name="partner_order_no" class="<?php echo $po_b_wbc->partner_order_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_po_b_wbc_partner_order_no" class="po_b_wbc_partner_order_no"><div class="ew-table-header-caption"><?php echo $po_b_wbc->partner_order_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_order_no" class="<?php echo $po_b_wbc->partner_order_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->partner_order_no) ?>',2);"><div id="elh_po_b_wbc_partner_order_no" class="po_b_wbc_partner_order_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->partner_order_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->partner_order_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->partner_order_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->despatch_date->Visible) { // despatch_date ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $po_b_wbc->despatch_date->headerCellClass() ?>"><div id="elh_po_b_wbc_despatch_date" class="po_b_wbc_despatch_date"><div class="ew-table-header-caption"><?php echo $po_b_wbc->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $po_b_wbc->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->despatch_date) ?>',2);"><div id="elh_po_b_wbc_despatch_date" class="po_b_wbc_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->despatch_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->despatch_week->Visible) { // despatch_week ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $po_b_wbc->despatch_week->headerCellClass() ?>"><div id="elh_po_b_wbc_despatch_week" class="po_b_wbc_despatch_week"><div class="ew-table-header-caption"><?php echo $po_b_wbc->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $po_b_wbc->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->despatch_week) ?>',2);"><div id="elh_po_b_wbc_despatch_week" class="po_b_wbc_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->fob_date->Visible) { // fob_date ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->fob_date) == "") { ?>
		<th data-name="fob_date" class="<?php echo $po_b_wbc->fob_date->headerCellClass() ?>"><div id="elh_po_b_wbc_fob_date" class="po_b_wbc_fob_date"><div class="ew-table-header-caption"><?php echo $po_b_wbc->fob_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fob_date" class="<?php echo $po_b_wbc->fob_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->fob_date) ?>',2);"><div id="elh_po_b_wbc_fob_date" class="po_b_wbc_fob_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->fob_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->fob_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->fob_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->payment_terms->Visible) { // payment_terms ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->payment_terms) == "") { ?>
		<th data-name="payment_terms" class="<?php echo $po_b_wbc->payment_terms->headerCellClass() ?>"><div id="elh_po_b_wbc_payment_terms" class="po_b_wbc_payment_terms"><div class="ew-table-header-caption"><?php echo $po_b_wbc->payment_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_terms" class="<?php echo $po_b_wbc->payment_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->payment_terms) ?>',2);"><div id="elh_po_b_wbc_payment_terms" class="po_b_wbc_payment_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->payment_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->payment_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->payment_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->transport_type->Visible) { // transport_type ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->transport_type) == "") { ?>
		<th data-name="transport_type" class="<?php echo $po_b_wbc->transport_type->headerCellClass() ?>"><div id="elh_po_b_wbc_transport_type" class="po_b_wbc_transport_type"><div class="ew-table-header-caption"><?php echo $po_b_wbc->transport_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transport_type" class="<?php echo $po_b_wbc->transport_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->transport_type) ?>',2);"><div id="elh_po_b_wbc_transport_type" class="po_b_wbc_transport_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->transport_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->transport_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->transport_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->partner_shipping_id->Visible) { // partner_shipping_id ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->partner_shipping_id) == "") { ?>
		<th data-name="partner_shipping_id" class="<?php echo $po_b_wbc->partner_shipping_id->headerCellClass() ?>"><div id="elh_po_b_wbc_partner_shipping_id" class="po_b_wbc_partner_shipping_id"><div class="ew-table-header-caption"><?php echo $po_b_wbc->partner_shipping_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_shipping_id" class="<?php echo $po_b_wbc->partner_shipping_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->partner_shipping_id) ?>',2);"><div id="elh_po_b_wbc_partner_shipping_id" class="po_b_wbc_partner_shipping_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->partner_shipping_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->partner_shipping_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->partner_shipping_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->uploads->Visible) { // uploads ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $po_b_wbc->uploads->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_po_b_wbc_uploads" class="po_b_wbc_uploads"><div class="ew-table-header-caption"><?php echo $po_b_wbc->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $po_b_wbc->uploads->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->uploads) ?>',2);"><div id="elh_po_b_wbc_uploads" class="po_b_wbc_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->operator->Visible) { // operator ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $po_b_wbc->operator->headerCellClass() ?>"><div id="elh_po_b_wbc_operator" class="po_b_wbc_operator"><div class="ew-table-header-caption"><?php echo $po_b_wbc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $po_b_wbc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->operator) ?>',2);"><div id="elh_po_b_wbc_operator" class="po_b_wbc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->datetime->Visible) { // datetime ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $po_b_wbc->datetime->headerCellClass() ?>"><div id="elh_po_b_wbc_datetime" class="po_b_wbc_datetime"><div class="ew-table-header-caption"><?php echo $po_b_wbc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $po_b_wbc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->datetime) ?>',2);"><div id="elh_po_b_wbc_datetime" class="po_b_wbc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->a_operator->Visible) { // a_operator ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $po_b_wbc->a_operator->headerCellClass() ?>"><div id="elh_po_b_wbc_a_operator" class="po_b_wbc_a_operator"><div class="ew-table-header-caption"><?php echo $po_b_wbc->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $po_b_wbc->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->a_operator) ?>',2);"><div id="elh_po_b_wbc_a_operator" class="po_b_wbc_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->a_datetime->Visible) { // a_datetime ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $po_b_wbc->a_datetime->headerCellClass() ?>"><div id="elh_po_b_wbc_a_datetime" class="po_b_wbc_a_datetime"><div class="ew-table-header-caption"><?php echo $po_b_wbc->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $po_b_wbc->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->a_datetime) ?>',2);"><div id="elh_po_b_wbc_a_datetime" class="po_b_wbc_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->a_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->app_operator->Visible) { // app_operator ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->app_operator) == "") { ?>
		<th data-name="app_operator" class="<?php echo $po_b_wbc->app_operator->headerCellClass() ?>"><div id="elh_po_b_wbc_app_operator" class="po_b_wbc_app_operator"><div class="ew-table-header-caption"><?php echo $po_b_wbc->app_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="app_operator" class="<?php echo $po_b_wbc->app_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->app_operator) ?>',2);"><div id="elh_po_b_wbc_app_operator" class="po_b_wbc_app_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->app_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->app_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->app_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b_wbc->app_datetime->Visible) { // app_datetime ?>
	<?php if ($po_b_wbc->sortUrl($po_b_wbc->app_datetime) == "") { ?>
		<th data-name="app_datetime" class="<?php echo $po_b_wbc->app_datetime->headerCellClass() ?>"><div id="elh_po_b_wbc_app_datetime" class="po_b_wbc_app_datetime"><div class="ew-table-header-caption"><?php echo $po_b_wbc->app_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="app_datetime" class="<?php echo $po_b_wbc->app_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b_wbc->SortUrl($po_b_wbc->app_datetime) ?>',2);"><div id="elh_po_b_wbc_app_datetime" class="po_b_wbc_app_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b_wbc->app_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b_wbc->app_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b_wbc->app_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_b_wbc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_b_wbc->ExportAll && $po_b_wbc->isExport()) {
	$po_b_wbc_list->StopRec = $po_b_wbc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_b_wbc_list->TotalRecs > $po_b_wbc_list->StartRec + $po_b_wbc_list->DisplayRecs - 1)
		$po_b_wbc_list->StopRec = $po_b_wbc_list->StartRec + $po_b_wbc_list->DisplayRecs - 1;
	else
		$po_b_wbc_list->StopRec = $po_b_wbc_list->TotalRecs;
}
$po_b_wbc_list->RecCnt = $po_b_wbc_list->StartRec - 1;
if ($po_b_wbc_list->Recordset && !$po_b_wbc_list->Recordset->EOF) {
	$po_b_wbc_list->Recordset->moveFirst();
	$selectLimit = $po_b_wbc_list->UseSelectLimit;
	if (!$selectLimit && $po_b_wbc_list->StartRec > 1)
		$po_b_wbc_list->Recordset->move($po_b_wbc_list->StartRec - 1);
} elseif (!$po_b_wbc->AllowAddDeleteRow && $po_b_wbc_list->StopRec == 0) {
	$po_b_wbc_list->StopRec = $po_b_wbc->GridAddRowCount;
}

// Initialize aggregate
$po_b_wbc->RowType = ROWTYPE_AGGREGATEINIT;
$po_b_wbc->resetAttributes();
$po_b_wbc_list->renderRow();
while ($po_b_wbc_list->RecCnt < $po_b_wbc_list->StopRec) {
	$po_b_wbc_list->RecCnt++;
	if ($po_b_wbc_list->RecCnt >= $po_b_wbc_list->StartRec) {
		$po_b_wbc_list->RowCnt++;

		// Set up key count
		$po_b_wbc_list->KeyCount = $po_b_wbc_list->RowIndex;

		// Init row class and style
		$po_b_wbc->resetAttributes();
		$po_b_wbc->CssClass = "";
		if ($po_b_wbc->isGridAdd()) {
		} else {
			$po_b_wbc_list->loadRowValues($po_b_wbc_list->Recordset); // Load row values
		}
		$po_b_wbc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_b_wbc->RowAttrs = array_merge($po_b_wbc->RowAttrs, array('data-rowindex'=>$po_b_wbc_list->RowCnt, 'id'=>'r' . $po_b_wbc_list->RowCnt . '_po_b_wbc', 'data-rowtype'=>$po_b_wbc->RowType));

		// Render row
		$po_b_wbc_list->renderRow();

		// Render list options
		$po_b_wbc_list->renderListOptions();
?>
	<tr<?php echo $po_b_wbc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_b_wbc_list->ListOptions->render("body", "left", $po_b_wbc_list->RowCnt);
?>
	<?php if ($po_b_wbc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_b_wbc->id->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_id" class="po_b_wbc_id">
<span<?php echo $po_b_wbc->id->viewAttributes() ?>>
<?php echo $po_b_wbc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $po_b_wbc->company_id->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_company_id" class="po_b_wbc_company_id">
<span<?php echo $po_b_wbc->company_id->viewAttributes() ?>>
<?php echo $po_b_wbc->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->po->Visible) { // po ?>
		<td data-name="po"<?php echo $po_b_wbc->po->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_po" class="po_b_wbc_po">
<span<?php echo $po_b_wbc->po->viewAttributes() ?>>
<?php if ((!EmptyString($po_b_wbc->po->getViewValue())) && $po_b_wbc->po->linkAttributes() <> "") { ?>
<a<?php echo $po_b_wbc->po->linkAttributes() ?>><?php echo $po_b_wbc->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_b_wbc->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $po_b_wbc->partner_id->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_partner_id" class="po_b_wbc_partner_id">
<span<?php echo $po_b_wbc->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_b_wbc->partner_id->getViewValue())) && $po_b_wbc->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $po_b_wbc->partner_id->linkAttributes() ?>><?php echo $po_b_wbc->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_b_wbc->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $po_b_wbc->sqm->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_sqm" class="po_b_wbc_sqm">
<span<?php echo $po_b_wbc->sqm->viewAttributes() ?>>
<?php echo $po_b_wbc->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $po_b_wbc->quantity->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_quantity" class="po_b_wbc_quantity">
<span<?php echo $po_b_wbc->quantity->viewAttributes() ?>>
<?php echo $po_b_wbc->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $po_b_wbc->amount->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_amount" class="po_b_wbc_amount">
<span<?php echo $po_b_wbc->amount->viewAttributes() ?>>
<?php echo $po_b_wbc->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $po_b_wbc->cbm->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_cbm" class="po_b_wbc_cbm">
<span<?php echo $po_b_wbc->cbm->viewAttributes() ?>>
<?php echo $po_b_wbc->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $po_b_wbc->gst->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_gst" class="po_b_wbc_gst">
<span<?php echo $po_b_wbc->gst->viewAttributes() ?>>
<?php echo $po_b_wbc->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->partner_order_no->Visible) { // partner_order_no ?>
		<td data-name="partner_order_no"<?php echo $po_b_wbc->partner_order_no->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_partner_order_no" class="po_b_wbc_partner_order_no">
<span<?php echo $po_b_wbc->partner_order_no->viewAttributes() ?>>
<?php echo $po_b_wbc->partner_order_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $po_b_wbc->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_despatch_date" class="po_b_wbc_despatch_date">
<span<?php echo $po_b_wbc->despatch_date->viewAttributes() ?>>
<?php echo $po_b_wbc->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $po_b_wbc->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_despatch_week" class="po_b_wbc_despatch_week">
<span<?php echo $po_b_wbc->despatch_week->viewAttributes() ?>>
<?php echo $po_b_wbc->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->fob_date->Visible) { // fob_date ?>
		<td data-name="fob_date"<?php echo $po_b_wbc->fob_date->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_fob_date" class="po_b_wbc_fob_date">
<span<?php echo $po_b_wbc->fob_date->viewAttributes() ?>>
<?php echo $po_b_wbc->fob_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->payment_terms->Visible) { // payment_terms ?>
		<td data-name="payment_terms"<?php echo $po_b_wbc->payment_terms->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_payment_terms" class="po_b_wbc_payment_terms">
<span<?php echo $po_b_wbc->payment_terms->viewAttributes() ?>>
<?php if ((!EmptyString($po_b_wbc->payment_terms->getViewValue())) && $po_b_wbc->payment_terms->linkAttributes() <> "") { ?>
<a<?php echo $po_b_wbc->payment_terms->linkAttributes() ?>><?php echo $po_b_wbc->payment_terms->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_b_wbc->payment_terms->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->transport_type->Visible) { // transport_type ?>
		<td data-name="transport_type"<?php echo $po_b_wbc->transport_type->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_transport_type" class="po_b_wbc_transport_type">
<span<?php echo $po_b_wbc->transport_type->viewAttributes() ?>>
<?php if ((!EmptyString($po_b_wbc->transport_type->getViewValue())) && $po_b_wbc->transport_type->linkAttributes() <> "") { ?>
<a<?php echo $po_b_wbc->transport_type->linkAttributes() ?>><?php echo $po_b_wbc->transport_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_b_wbc->transport_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->partner_shipping_id->Visible) { // partner_shipping_id ?>
		<td data-name="partner_shipping_id"<?php echo $po_b_wbc->partner_shipping_id->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_partner_shipping_id" class="po_b_wbc_partner_shipping_id">
<span<?php echo $po_b_wbc->partner_shipping_id->viewAttributes() ?>>
<?php echo $po_b_wbc->partner_shipping_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $po_b_wbc->uploads->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_uploads" class="po_b_wbc_uploads">
<span>
<?php echo GetFileViewTag($po_b_wbc->uploads, $po_b_wbc->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $po_b_wbc->operator->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_operator" class="po_b_wbc_operator">
<span<?php echo $po_b_wbc->operator->viewAttributes() ?>>
<?php echo $po_b_wbc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $po_b_wbc->datetime->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_datetime" class="po_b_wbc_datetime">
<span<?php echo $po_b_wbc->datetime->viewAttributes() ?>>
<?php echo $po_b_wbc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $po_b_wbc->a_operator->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_a_operator" class="po_b_wbc_a_operator">
<span<?php echo $po_b_wbc->a_operator->viewAttributes() ?>>
<?php echo $po_b_wbc->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $po_b_wbc->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_a_datetime" class="po_b_wbc_a_datetime">
<span<?php echo $po_b_wbc->a_datetime->viewAttributes() ?>>
<?php echo $po_b_wbc->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->app_operator->Visible) { // app_operator ?>
		<td data-name="app_operator"<?php echo $po_b_wbc->app_operator->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_app_operator" class="po_b_wbc_app_operator">
<span<?php echo $po_b_wbc->app_operator->viewAttributes() ?>>
<?php echo $po_b_wbc->app_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b_wbc->app_datetime->Visible) { // app_datetime ?>
		<td data-name="app_datetime"<?php echo $po_b_wbc->app_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_b_wbc_list->RowCnt ?>_po_b_wbc_app_datetime" class="po_b_wbc_app_datetime">
<span<?php echo $po_b_wbc->app_datetime->viewAttributes() ?>>
<?php echo $po_b_wbc->app_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_b_wbc_list->ListOptions->render("body", "right", $po_b_wbc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_b_wbc->isGridAdd())
		$po_b_wbc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_b_wbc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_b_wbc_list->Recordset)
	$po_b_wbc_list->Recordset->Close();
?>
<?php if (!$po_b_wbc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_b_wbc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_b_wbc_list->Pager)) $po_b_wbc_list->Pager = new PrevNextPager($po_b_wbc_list->StartRec, $po_b_wbc_list->DisplayRecs, $po_b_wbc_list->TotalRecs, $po_b_wbc_list->AutoHidePager) ?>
<?php if ($po_b_wbc_list->Pager->RecordCount > 0 && $po_b_wbc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_b_wbc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_b_wbc_list->pageUrl() ?>start=<?php echo $po_b_wbc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_b_wbc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_b_wbc_list->pageUrl() ?>start=<?php echo $po_b_wbc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_b_wbc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_b_wbc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_b_wbc_list->pageUrl() ?>start=<?php echo $po_b_wbc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_b_wbc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_b_wbc_list->pageUrl() ?>start=<?php echo $po_b_wbc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_b_wbc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_b_wbc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_b_wbc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_b_wbc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_b_wbc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_b_wbc_list->TotalRecs > 0 && (!$po_b_wbc_list->AutoHidePageSizeSelector || $po_b_wbc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_b_wbc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_b_wbc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_b_wbc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_b_wbc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_b_wbc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_b_wbc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_b_wbc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_b_wbc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_b_wbc_list->TotalRecs == 0 && !$po_b_wbc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_b_wbc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_b_wbc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_b_wbc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_b_wbc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_b_wbc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_b_wbc_list->terminate();
?>