<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_b_wbc_search = new po_b_wbc_search();

// Run the page
$po_b_wbc_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_b_wbc_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_b_wbc_search->IsModal) { ?>
var fpo_b_wbcsearch = currentAdvancedSearchForm = new ew.Form("fpo_b_wbcsearch", "search");
<?php } else { ?>
var fpo_b_wbcsearch = currentForm = new ew.Form("fpo_b_wbcsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_b_wbcsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_b_wbcsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_b_wbcsearch.multiPage = new ew.MultiPage("fpo_b_wbcsearch");

// Dynamic selection lists
fpo_b_wbcsearch.lists["x_company_id"] = <?php echo $po_b_wbc_search->company_id->Lookup->toClientList() ?>;
fpo_b_wbcsearch.lists["x_company_id"].options = <?php echo JsonEncode($po_b_wbc_search->company_id->lookupOptions()) ?>;
fpo_b_wbcsearch.lists["x_partner_id"] = <?php echo $po_b_wbc_search->partner_id->Lookup->toClientList() ?>;
fpo_b_wbcsearch.lists["x_partner_id"].options = <?php echo JsonEncode($po_b_wbc_search->partner_id->lookupOptions()) ?>;
fpo_b_wbcsearch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_b_wbcsearch.lists["x_cart_id[]"] = <?php echo $po_b_wbc_search->cart_id->Lookup->toClientList() ?>;
fpo_b_wbcsearch.lists["x_cart_id[]"].options = <?php echo JsonEncode($po_b_wbc_search->cart_id->lookupOptions()) ?>;
fpo_b_wbcsearch.lists["x_gst"] = <?php echo $po_b_wbc_search->gst->Lookup->toClientList() ?>;
fpo_b_wbcsearch.lists["x_gst"].options = <?php echo JsonEncode($po_b_wbc_search->gst->lookupOptions()) ?>;
fpo_b_wbcsearch.lists["x_despatch_week"] = <?php echo $po_b_wbc_search->despatch_week->Lookup->toClientList() ?>;
fpo_b_wbcsearch.lists["x_despatch_week"].options = <?php echo JsonEncode($po_b_wbc_search->despatch_week->lookupOptions()) ?>;
fpo_b_wbcsearch.lists["x_payment_terms"] = <?php echo $po_b_wbc_search->payment_terms->Lookup->toClientList() ?>;
fpo_b_wbcsearch.lists["x_payment_terms"].options = <?php echo JsonEncode($po_b_wbc_search->payment_terms->lookupOptions()) ?>;
fpo_b_wbcsearch.lists["x_transport_type"] = <?php echo $po_b_wbc_search->transport_type->Lookup->toClientList() ?>;
fpo_b_wbcsearch.lists["x_transport_type"].options = <?php echo JsonEncode($po_b_wbc_search->transport_type->lookupOptions()) ?>;
fpo_b_wbcsearch.lists["x_partner_shipping_id"] = <?php echo $po_b_wbc_search->partner_shipping_id->Lookup->toClientList() ?>;
fpo_b_wbcsearch.lists["x_partner_shipping_id"].options = <?php echo JsonEncode($po_b_wbc_search->partner_shipping_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpo_b_wbcsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_wbc->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_wbc->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_wbc->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cbm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b_wbc->cbm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_b_wbc_search->showPageHeader(); ?>
<?php
$po_b_wbc_search->showMessage();
?>
<form name="fpo_b_wbcsearch" id="fpo_b_wbcsearch" class="<?php echo $po_b_wbc_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_b_wbc_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_b_wbc_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_b_wbc">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_b_wbc_search->IsModal ?>">
<?php if ($po_b_wbc_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($po_b_wbc->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_id"><?php echo $po_b_wbc->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->id->cellAttributes() ?>>
			<span id="el_po_b_wbc_id">
<input type="text" data-table="po_b_wbc" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($po_b_wbc->id->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->id->EditValue ?>"<?php echo $po_b_wbc->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_company_id"><?php echo $po_b_wbc->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->company_id->cellAttributes() ?>>
			<span id="el_po_b_wbc_company_id">
<?php $po_b_wbc->company_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_b_wbc->company_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_company_id" data-page="0" data-value-separator="<?php echo $po_b_wbc->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_b_wbc->company_id->editAttributes() ?>>
		<?php echo $po_b_wbc->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_b_wbc->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_po"><?php echo $po_b_wbc->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->po->cellAttributes() ?>>
			<span id="el_po_b_wbc_po">
<input type="text" data-table="po_b_wbc" data-field="x_po" data-page="0" name="x_po" id="x_po" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($po_b_wbc->po->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->po->EditValue ?>"<?php echo $po_b_wbc->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_partner_id"><?php echo $po_b_wbc->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->partner_id->cellAttributes() ?>>
			<span id="el_po_b_wbc_partner_id">
<?php
$wrkonchange = "" . trim(@$po_b_wbc->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_b_wbc->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8920">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_b_wbc->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_b_wbc->partner_id->getPlaceHolder()) ?>"<?php echo $po_b_wbc->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_b_wbc" data-field="x_partner_id" data-page="0" data-value-separator="<?php echo $po_b_wbc->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_b_wbc->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_b_wbcsearch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $po_b_wbc->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->cart_id->Visible) { // cart_id ?>
	<div id="r_cart_id" class="form-group row">
		<label class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_cart_id"><?php echo $po_b_wbc->cart_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cart_id" id="z_cart_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->cart_id->cellAttributes() ?>>
			<span id="el_po_b_wbc_cart_id">
<div id="tp_x_cart_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="po_b_wbc" data-field="x_cart_id" data-page="0" data-value-separator="<?php echo $po_b_wbc->cart_id->displayValueSeparatorAttribute() ?>" name="x_cart_id[]" id="x_cart_id[]" value="{value}"<?php echo $po_b_wbc->cart_id->editAttributes() ?>></div>
<div id="dsl_x_cart_id" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $po_b_wbc->cart_id->checkBoxListHtml(FALSE, "x_cart_id[]", 0) ?>
</div></div>
<?php echo $po_b_wbc->cart_id->Lookup->getParamTag("p_x_cart_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="po_b_wbc_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $po_b_wbc_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_b_wbc_search->MultiPages->isActive("1")) ?>" href="#tab_po_b_wbc1"><?php echo $po_b_wbc->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_b_wbc_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $po_b_wbc_search->MultiPages->Parent ?>" id="tab_po_b_wbc1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_b_wbc->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_sqm"><?php echo $po_b_wbc->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->sqm->cellAttributes() ?>>
			<span id="el_po_b_wbc_sqm">
<input type="text" data-table="po_b_wbc" data-field="x_sqm" data-page="1" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->sqm->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->sqm->EditValue ?>"<?php echo $po_b_wbc->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_quantity"><?php echo $po_b_wbc->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->quantity->cellAttributes() ?>>
			<span id="el_po_b_wbc_quantity">
<input type="text" data-table="po_b_wbc" data-field="x_quantity" data-page="1" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->quantity->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->quantity->EditValue ?>"<?php echo $po_b_wbc->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_amount"><?php echo $po_b_wbc->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->amount->cellAttributes() ?>>
			<span id="el_po_b_wbc_amount">
<input type="text" data-table="po_b_wbc" data-field="x_amount" data-page="1" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->amount->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->amount->EditValue ?>"<?php echo $po_b_wbc->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_cbm"><?php echo $po_b_wbc->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cbm" id="z_cbm" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->cbm->cellAttributes() ?>>
			<span id="el_po_b_wbc_cbm">
<input type="text" data-table="po_b_wbc" data-field="x_cbm" data-page="1" name="x_cbm" id="x_cbm" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->cbm->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->cbm->EditValue ?>"<?php echo $po_b_wbc->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->gst->Visible) { // gst ?>
	<div id="r_gst" class="form-group row">
		<label for="x_gst" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_gst"><?php echo $po_b_wbc->gst->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gst" id="z_gst" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->gst->cellAttributes() ?>>
			<span id="el_po_b_wbc_gst">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_gst" data-page="1" data-value-separator="<?php echo $po_b_wbc->gst->displayValueSeparatorAttribute() ?>" id="x_gst" name="x_gst"<?php echo $po_b_wbc->gst->editAttributes() ?>>
		<?php echo $po_b_wbc->gst->selectOptionListHtml("x_gst") ?>
	</select>
</div>
<?php echo $po_b_wbc->gst->Lookup->getParamTag("p_x_gst") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $po_b_wbc_search->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($po_b_wbc_search->MultiPages->isActive("2")) ?>" href="#tab_po_b_wbc2"><?php echo $po_b_wbc->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $po_b_wbc_search->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $po_b_wbc_search->MultiPages->Parent ?>" id="tab_po_b_wbc2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_b_wbc->partner_order_no->Visible) { // partner_order_no ?>
	<div id="r_partner_order_no" class="form-group row">
		<label for="x_partner_order_no" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_partner_order_no"><?php echo $po_b_wbc->partner_order_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->partner_order_no->cellAttributes() ?>>
			<span id="el_po_b_wbc_partner_order_no">
<input type="text" data-table="po_b_wbc" data-field="x_partner_order_no" data-page="2" name="x_partner_order_no" id="x_partner_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_b_wbc->partner_order_no->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->partner_order_no->EditValue ?>"<?php echo $po_b_wbc->partner_order_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_despatch_week"><?php echo $po_b_wbc->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->despatch_week->cellAttributes() ?>>
			<span id="el_po_b_wbc_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_despatch_week" data-page="2" data-value-separator="<?php echo $po_b_wbc->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $po_b_wbc->despatch_week->editAttributes() ?>>
		<?php echo $po_b_wbc->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $po_b_wbc->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->payment_terms->Visible) { // payment_terms ?>
	<div id="r_payment_terms" class="form-group row">
		<label for="x_payment_terms" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_payment_terms"><?php echo $po_b_wbc->payment_terms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_payment_terms" id="z_payment_terms" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->payment_terms->cellAttributes() ?>>
			<span id="el_po_b_wbc_payment_terms">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_payment_terms" data-page="2" data-value-separator="<?php echo $po_b_wbc->payment_terms->displayValueSeparatorAttribute() ?>" id="x_payment_terms" name="x_payment_terms"<?php echo $po_b_wbc->payment_terms->editAttributes() ?>>
		<?php echo $po_b_wbc->payment_terms->selectOptionListHtml("x_payment_terms") ?>
	</select>
</div>
<?php echo $po_b_wbc->payment_terms->Lookup->getParamTag("p_x_payment_terms") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->transport_type->Visible) { // transport_type ?>
	<div id="r_transport_type" class="form-group row">
		<label for="x_transport_type" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_transport_type"><?php echo $po_b_wbc->transport_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_transport_type" id="z_transport_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->transport_type->cellAttributes() ?>>
			<span id="el_po_b_wbc_transport_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_transport_type" data-page="2" data-value-separator="<?php echo $po_b_wbc->transport_type->displayValueSeparatorAttribute() ?>" id="x_transport_type" name="x_transport_type"<?php echo $po_b_wbc->transport_type->editAttributes() ?>>
		<?php echo $po_b_wbc->transport_type->selectOptionListHtml("x_transport_type") ?>
	</select>
</div>
<?php echo $po_b_wbc->transport_type->Lookup->getParamTag("p_x_transport_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->partner_shipping_id->Visible) { // partner_shipping_id ?>
	<div id="r_partner_shipping_id" class="form-group row">
		<label for="x_partner_shipping_id" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_partner_shipping_id"><?php echo $po_b_wbc->partner_shipping_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_shipping_id" id="z_partner_shipping_id" value="="></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->partner_shipping_id->cellAttributes() ?>>
			<span id="el_po_b_wbc_partner_shipping_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b_wbc" data-field="x_partner_shipping_id" data-page="2" data-value-separator="<?php echo $po_b_wbc->partner_shipping_id->displayValueSeparatorAttribute() ?>" id="x_partner_shipping_id" name="x_partner_shipping_id"<?php echo $po_b_wbc->partner_shipping_id->editAttributes() ?>>
		<?php echo $po_b_wbc->partner_shipping_id->selectOptionListHtml("x_partner_shipping_id") ?>
	</select>
</div>
<?php echo $po_b_wbc->partner_shipping_id->Lookup->getParamTag("p_x_partner_shipping_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_remarks"><?php echo $po_b_wbc->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->remarks->cellAttributes() ?>>
			<span id="el_po_b_wbc_remarks">
<input type="text" data-table="po_b_wbc" data-field="x_remarks" data-page="2" name="x_remarks" id="x_remarks" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->remarks->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->remarks->EditValue ?>"<?php echo $po_b_wbc->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_b_wbc->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label for="x_buyer_instruction" class="<?php echo $po_b_wbc_search->LeftColumnClass ?>"><span id="elh_po_b_wbc_buyer_instruction"><?php echo $po_b_wbc->buyer_instruction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_b_wbc_search->RightColumnClass ?>"><div<?php echo $po_b_wbc->buyer_instruction->cellAttributes() ?>>
			<span id="el_po_b_wbc_buyer_instruction">
<input type="text" data-table="po_b_wbc" data-field="x_buyer_instruction" data-page="2" name="x_buyer_instruction" id="x_buyer_instruction" size="30" placeholder="<?php echo HtmlEncode($po_b_wbc->buyer_instruction->getPlaceHolder()) ?>" value="<?php echo $po_b_wbc->buyer_instruction->EditValue ?>"<?php echo $po_b_wbc->buyer_instruction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$po_b_wbc_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_b_wbc_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_b_wbc_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_b_wbc_search->terminate();
?>