<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_b_list = new po_b_list();

// Run the page
$po_b_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_b_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_b->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_blist = currentForm = new ew.Form("fpo_blist", "list");
fpo_blist.formKeyCountName = '<?php echo $po_b_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_blist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_blist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_blist.lists["x_company_id"] = <?php echo $po_b_list->company_id->Lookup->toClientList() ?>;
fpo_blist.lists["x_company_id"].options = <?php echo JsonEncode($po_b_list->company_id->lookupOptions()) ?>;
fpo_blist.lists["x_partner_id"] = <?php echo $po_b_list->partner_id->Lookup->toClientList() ?>;
fpo_blist.lists["x_partner_id"].options = <?php echo JsonEncode($po_b_list->partner_id->lookupOptions()) ?>;
fpo_blist.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_blist.lists["x_gst"] = <?php echo $po_b_list->gst->Lookup->toClientList() ?>;
fpo_blist.lists["x_gst"].options = <?php echo JsonEncode($po_b_list->gst->lookupOptions()) ?>;
fpo_blist.lists["x_despatch_week"] = <?php echo $po_b_list->despatch_week->Lookup->toClientList() ?>;
fpo_blist.lists["x_despatch_week"].options = <?php echo JsonEncode($po_b_list->despatch_week->lookupOptions()) ?>;
fpo_blist.lists["x_payment_terms"] = <?php echo $po_b_list->payment_terms->Lookup->toClientList() ?>;
fpo_blist.lists["x_payment_terms"].options = <?php echo JsonEncode($po_b_list->payment_terms->lookupOptions()) ?>;
fpo_blist.lists["x_transport_type"] = <?php echo $po_b_list->transport_type->Lookup->toClientList() ?>;
fpo_blist.lists["x_transport_type"].options = <?php echo JsonEncode($po_b_list->transport_type->lookupOptions()) ?>;
fpo_blist.lists["x_partner_shipping_id"] = <?php echo $po_b_list->partner_shipping_id->Lookup->toClientList() ?>;
fpo_blist.lists["x_partner_shipping_id"].options = <?php echo JsonEncode($po_b_list->partner_shipping_id->lookupOptions()) ?>;
fpo_blist.lists["x_operator"] = <?php echo $po_b_list->operator->Lookup->toClientList() ?>;
fpo_blist.lists["x_operator"].options = <?php echo JsonEncode($po_b_list->operator->lookupOptions()) ?>;
fpo_blist.lists["x_a_operator"] = <?php echo $po_b_list->a_operator->Lookup->toClientList() ?>;
fpo_blist.lists["x_a_operator"].options = <?php echo JsonEncode($po_b_list->a_operator->lookupOptions()) ?>;
fpo_blist.lists["x_app_operator"] = <?php echo $po_b_list->app_operator->Lookup->toClientList() ?>;
fpo_blist.lists["x_app_operator"].options = <?php echo JsonEncode($po_b_list->app_operator->lookupOptions()) ?>;

// Form object for search
var fpo_blistsrch = currentSearchForm = new ew.Form("fpo_blistsrch");

// Validate function for search
fpo_blistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_b->po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_blistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_blistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_blistsrch.lists["x_company_id"] = <?php echo $po_b_list->company_id->Lookup->toClientList() ?>;
fpo_blistsrch.lists["x_company_id"].options = <?php echo JsonEncode($po_b_list->company_id->lookupOptions()) ?>;
fpo_blistsrch.lists["x_partner_id"] = <?php echo $po_b_list->partner_id->Lookup->toClientList() ?>;
fpo_blistsrch.lists["x_partner_id"].options = <?php echo JsonEncode($po_b_list->partner_id->lookupOptions()) ?>;
fpo_blistsrch.autoSuggests["x_partner_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpo_blistsrch.filterList = <?php echo $po_b_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_blistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_b->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_b_list->TotalRecs > 0 && $po_b_list->ExportOptions->visible()) { ?>
<?php $po_b_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_b_list->ImportOptions->visible()) { ?>
<?php $po_b_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_b_list->SearchOptions->visible()) { ?>
<?php $po_b_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_b_list->FilterOptions->visible()) { ?>
<?php $po_b_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_b_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_b->isExport() && !$po_b->CurrentAction) { ?>
<form name="fpo_blistsrch" id="fpo_blistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_b_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_blistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_b">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_b_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_b->RowType = ROWTYPE_SEARCH;

// Render row
$po_b->resetAttributes();
$po_b_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_b->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $po_b->po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="po_b" data-field="x_po" name="x_po" id="x_po" size="30" maxlength="5" placeholder="<?php echo HtmlEncode($po_b->po->getPlaceHolder()) ?>" value="<?php echo $po_b->po->EditValue ?>"<?php echo $po_b->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($po_b->company_id->Visible) { // company_id ?>
	<div id="xsc_company_id" class="ew-cell form-group">
		<label for="x_company_id" class="ew-search-caption ew-label"><?php echo $po_b->company_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_b" data-field="x_company_id" data-value-separator="<?php echo $po_b->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_b->company_id->editAttributes() ?>>
		<?php echo $po_b->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_b->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_b->partner_id->Visible) { // partner_id ?>
	<div id="xsc_partner_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $po_b->partner_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$po_b->partner_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_b->partner_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_partner_id" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?php echo RemoveHtml($po_b->partner_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_b->partner_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_b->partner_id->getPlaceHolder()) ?>"<?php echo $po_b->partner_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_b" data-field="x_partner_id" data-value-separator="<?php echo $po_b->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?php echo HtmlEncode($po_b->partner_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_blistsrch.createAutoSuggest({"id":"x_partner_id","forceSelect":false});
</script>
<?php echo $po_b->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_b_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_b_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_b_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_b_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_b_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_b_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_b_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_b_list->showPageHeader(); ?>
<?php
$po_b_list->showMessage();
?>
<?php if ($po_b_list->TotalRecs > 0 || $po_b->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_b_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_b">
<?php if (!$po_b->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_b->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_b_list->Pager)) $po_b_list->Pager = new PrevNextPager($po_b_list->StartRec, $po_b_list->DisplayRecs, $po_b_list->TotalRecs, $po_b_list->AutoHidePager) ?>
<?php if ($po_b_list->Pager->RecordCount > 0 && $po_b_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_b_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_b_list->pageUrl() ?>start=<?php echo $po_b_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_b_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_b_list->pageUrl() ?>start=<?php echo $po_b_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_b_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_b_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_b_list->pageUrl() ?>start=<?php echo $po_b_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_b_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_b_list->pageUrl() ?>start=<?php echo $po_b_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_b_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_b_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_b_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_b_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_b_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_b_list->TotalRecs > 0 && (!$po_b_list->AutoHidePageSizeSelector || $po_b_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_b">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_b_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_b_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_b_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_b_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_b_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_b->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_b_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_blist" id="fpo_blist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_b_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_b_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_b">
<div id="gmp_po_b" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_b_list->TotalRecs > 0 || $po_b->isGridEdit()) { ?>
<table id="tbl_po_blist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_b_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_b_list->renderListOptions();

// Render list options (header, left)
$po_b_list->ListOptions->render("header", "left");
?>
<?php if ($po_b->id->Visible) { // id ?>
	<?php if ($po_b->sortUrl($po_b->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_b->id->headerCellClass() ?>"><div id="elh_po_b_id" class="po_b_id"><div class="ew-table-header-caption"><?php echo $po_b->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_b->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->id) ?>',2);"><div id="elh_po_b_id" class="po_b_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->po->Visible) { // po ?>
	<?php if ($po_b->sortUrl($po_b->po) == "") { ?>
		<th data-name="po" class="<?php echo $po_b->po->headerCellClass() ?>"><div id="elh_po_b_po" class="po_b_po"><div class="ew-table-header-caption"><?php echo $po_b->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $po_b->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->po) ?>',2);"><div id="elh_po_b_po" class="po_b_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->company_id->Visible) { // company_id ?>
	<?php if ($po_b->sortUrl($po_b->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $po_b->company_id->headerCellClass() ?>"><div id="elh_po_b_company_id" class="po_b_company_id"><div class="ew-table-header-caption"><?php echo $po_b->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $po_b->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->company_id) ?>',2);"><div id="elh_po_b_company_id" class="po_b_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->partner_id->Visible) { // partner_id ?>
	<?php if ($po_b->sortUrl($po_b->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $po_b->partner_id->headerCellClass() ?>"><div id="elh_po_b_partner_id" class="po_b_partner_id"><div class="ew-table-header-caption"><?php echo $po_b->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $po_b->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->partner_id) ?>',2);"><div id="elh_po_b_partner_id" class="po_b_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->partner_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->quantity->Visible) { // quantity ?>
	<?php if ($po_b->sortUrl($po_b->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $po_b->quantity->headerCellClass() ?>"><div id="elh_po_b_quantity" class="po_b_quantity"><div class="ew-table-header-caption"><?php echo $po_b->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $po_b->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->quantity) ?>',2);"><div id="elh_po_b_quantity" class="po_b_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->sqm->Visible) { // sqm ?>
	<?php if ($po_b->sortUrl($po_b->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $po_b->sqm->headerCellClass() ?>"><div id="elh_po_b_sqm" class="po_b_sqm"><div class="ew-table-header-caption"><?php echo $po_b->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $po_b->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->sqm) ?>',2);"><div id="elh_po_b_sqm" class="po_b_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->amount->Visible) { // amount ?>
	<?php if ($po_b->sortUrl($po_b->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $po_b->amount->headerCellClass() ?>"><div id="elh_po_b_amount" class="po_b_amount"><div class="ew-table-header-caption"><?php echo $po_b->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $po_b->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->amount) ?>',2);"><div id="elh_po_b_amount" class="po_b_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->cbm->Visible) { // cbm ?>
	<?php if ($po_b->sortUrl($po_b->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $po_b->cbm->headerCellClass() ?>"><div id="elh_po_b_cbm" class="po_b_cbm"><div class="ew-table-header-caption"><?php echo $po_b->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $po_b->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->cbm) ?>',2);"><div id="elh_po_b_cbm" class="po_b_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->gst->Visible) { // gst ?>
	<?php if ($po_b->sortUrl($po_b->gst) == "") { ?>
		<th data-name="gst" class="<?php echo $po_b->gst->headerCellClass() ?>"><div id="elh_po_b_gst" class="po_b_gst"><div class="ew-table-header-caption"><?php echo $po_b->gst->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst" class="<?php echo $po_b->gst->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->gst) ?>',2);"><div id="elh_po_b_gst" class="po_b_gst">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->gst->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->gst->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->gst->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->partner_order_no->Visible) { // partner_order_no ?>
	<?php if ($po_b->sortUrl($po_b->partner_order_no) == "") { ?>
		<th data-name="partner_order_no" class="<?php echo $po_b->partner_order_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_po_b_partner_order_no" class="po_b_partner_order_no"><div class="ew-table-header-caption"><?php echo $po_b->partner_order_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_order_no" class="<?php echo $po_b->partner_order_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->partner_order_no) ?>',2);"><div id="elh_po_b_partner_order_no" class="po_b_partner_order_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->partner_order_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->partner_order_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->partner_order_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->despatch_date->Visible) { // despatch_date ?>
	<?php if ($po_b->sortUrl($po_b->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $po_b->despatch_date->headerCellClass() ?>"><div id="elh_po_b_despatch_date" class="po_b_despatch_date"><div class="ew-table-header-caption"><?php echo $po_b->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $po_b->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->despatch_date) ?>',2);"><div id="elh_po_b_despatch_date" class="po_b_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->despatch_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->despatch_week->Visible) { // despatch_week ?>
	<?php if ($po_b->sortUrl($po_b->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $po_b->despatch_week->headerCellClass() ?>"><div id="elh_po_b_despatch_week" class="po_b_despatch_week"><div class="ew-table-header-caption"><?php echo $po_b->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $po_b->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->despatch_week) ?>',2);"><div id="elh_po_b_despatch_week" class="po_b_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->fob_date->Visible) { // fob_date ?>
	<?php if ($po_b->sortUrl($po_b->fob_date) == "") { ?>
		<th data-name="fob_date" class="<?php echo $po_b->fob_date->headerCellClass() ?>"><div id="elh_po_b_fob_date" class="po_b_fob_date"><div class="ew-table-header-caption"><?php echo $po_b->fob_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fob_date" class="<?php echo $po_b->fob_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->fob_date) ?>',2);"><div id="elh_po_b_fob_date" class="po_b_fob_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->fob_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->fob_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->fob_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->payment_terms->Visible) { // payment_terms ?>
	<?php if ($po_b->sortUrl($po_b->payment_terms) == "") { ?>
		<th data-name="payment_terms" class="<?php echo $po_b->payment_terms->headerCellClass() ?>"><div id="elh_po_b_payment_terms" class="po_b_payment_terms"><div class="ew-table-header-caption"><?php echo $po_b->payment_terms->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="payment_terms" class="<?php echo $po_b->payment_terms->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->payment_terms) ?>',2);"><div id="elh_po_b_payment_terms" class="po_b_payment_terms">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->payment_terms->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->payment_terms->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->payment_terms->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->transport_type->Visible) { // transport_type ?>
	<?php if ($po_b->sortUrl($po_b->transport_type) == "") { ?>
		<th data-name="transport_type" class="<?php echo $po_b->transport_type->headerCellClass() ?>"><div id="elh_po_b_transport_type" class="po_b_transport_type"><div class="ew-table-header-caption"><?php echo $po_b->transport_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transport_type" class="<?php echo $po_b->transport_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->transport_type) ?>',2);"><div id="elh_po_b_transport_type" class="po_b_transport_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->transport_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->transport_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->transport_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->partner_shipping_id->Visible) { // partner_shipping_id ?>
	<?php if ($po_b->sortUrl($po_b->partner_shipping_id) == "") { ?>
		<th data-name="partner_shipping_id" class="<?php echo $po_b->partner_shipping_id->headerCellClass() ?>"><div id="elh_po_b_partner_shipping_id" class="po_b_partner_shipping_id"><div class="ew-table-header-caption"><?php echo $po_b->partner_shipping_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_shipping_id" class="<?php echo $po_b->partner_shipping_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->partner_shipping_id) ?>',2);"><div id="elh_po_b_partner_shipping_id" class="po_b_partner_shipping_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->partner_shipping_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->partner_shipping_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->partner_shipping_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->uploads->Visible) { // uploads ?>
	<?php if ($po_b->sortUrl($po_b->uploads) == "") { ?>
		<th data-name="uploads" class="<?php echo $po_b->uploads->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_po_b_uploads" class="po_b_uploads"><div class="ew-table-header-caption"><?php echo $po_b->uploads->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uploads" class="<?php echo $po_b->uploads->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->uploads) ?>',2);"><div id="elh_po_b_uploads" class="po_b_uploads">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->uploads->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->uploads->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->uploads->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->operator->Visible) { // operator ?>
	<?php if ($po_b->sortUrl($po_b->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $po_b->operator->headerCellClass() ?>"><div id="elh_po_b_operator" class="po_b_operator"><div class="ew-table-header-caption"><?php echo $po_b->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $po_b->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->operator) ?>',2);"><div id="elh_po_b_operator" class="po_b_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->datetime->Visible) { // datetime ?>
	<?php if ($po_b->sortUrl($po_b->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $po_b->datetime->headerCellClass() ?>"><div id="elh_po_b_datetime" class="po_b_datetime"><div class="ew-table-header-caption"><?php echo $po_b->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $po_b->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->datetime) ?>',2);"><div id="elh_po_b_datetime" class="po_b_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->a_operator->Visible) { // a_operator ?>
	<?php if ($po_b->sortUrl($po_b->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $po_b->a_operator->headerCellClass() ?>"><div id="elh_po_b_a_operator" class="po_b_a_operator"><div class="ew-table-header-caption"><?php echo $po_b->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $po_b->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->a_operator) ?>',2);"><div id="elh_po_b_a_operator" class="po_b_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->a_datetime->Visible) { // a_datetime ?>
	<?php if ($po_b->sortUrl($po_b->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $po_b->a_datetime->headerCellClass() ?>"><div id="elh_po_b_a_datetime" class="po_b_a_datetime"><div class="ew-table-header-caption"><?php echo $po_b->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $po_b->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->a_datetime) ?>',2);"><div id="elh_po_b_a_datetime" class="po_b_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->a_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->app_operator->Visible) { // app_operator ?>
	<?php if ($po_b->sortUrl($po_b->app_operator) == "") { ?>
		<th data-name="app_operator" class="<?php echo $po_b->app_operator->headerCellClass() ?>"><div id="elh_po_b_app_operator" class="po_b_app_operator"><div class="ew-table-header-caption"><?php echo $po_b->app_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="app_operator" class="<?php echo $po_b->app_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->app_operator) ?>',2);"><div id="elh_po_b_app_operator" class="po_b_app_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->app_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_b->app_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->app_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->app_datetime->Visible) { // app_datetime ?>
	<?php if ($po_b->sortUrl($po_b->app_datetime) == "") { ?>
		<th data-name="app_datetime" class="<?php echo $po_b->app_datetime->headerCellClass() ?>"><div id="elh_po_b_app_datetime" class="po_b_app_datetime"><div class="ew-table-header-caption"><?php echo $po_b->app_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="app_datetime" class="<?php echo $po_b->app_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->app_datetime) ?>',2);"><div id="elh_po_b_app_datetime" class="po_b_app_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->app_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->app_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->app_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_b->order_file->Visible) { // order_file ?>
	<?php if ($po_b->sortUrl($po_b->order_file) == "") { ?>
		<th data-name="order_file" class="<?php echo $po_b->order_file->headerCellClass() ?>"><div id="elh_po_b_order_file" class="po_b_order_file"><div class="ew-table-header-caption"><?php echo $po_b->order_file->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_file" class="<?php echo $po_b->order_file->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_b->SortUrl($po_b->order_file) ?>',2);"><div id="elh_po_b_order_file" class="po_b_order_file">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_b->order_file->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_b->order_file->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_b->order_file->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_b_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_b->ExportAll && $po_b->isExport()) {
	$po_b_list->StopRec = $po_b_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_b_list->TotalRecs > $po_b_list->StartRec + $po_b_list->DisplayRecs - 1)
		$po_b_list->StopRec = $po_b_list->StartRec + $po_b_list->DisplayRecs - 1;
	else
		$po_b_list->StopRec = $po_b_list->TotalRecs;
}
$po_b_list->RecCnt = $po_b_list->StartRec - 1;
if ($po_b_list->Recordset && !$po_b_list->Recordset->EOF) {
	$po_b_list->Recordset->moveFirst();
	$selectLimit = $po_b_list->UseSelectLimit;
	if (!$selectLimit && $po_b_list->StartRec > 1)
		$po_b_list->Recordset->move($po_b_list->StartRec - 1);
} elseif (!$po_b->AllowAddDeleteRow && $po_b_list->StopRec == 0) {
	$po_b_list->StopRec = $po_b->GridAddRowCount;
}

// Initialize aggregate
$po_b->RowType = ROWTYPE_AGGREGATEINIT;
$po_b->resetAttributes();
$po_b_list->renderRow();
while ($po_b_list->RecCnt < $po_b_list->StopRec) {
	$po_b_list->RecCnt++;
	if ($po_b_list->RecCnt >= $po_b_list->StartRec) {
		$po_b_list->RowCnt++;

		// Set up key count
		$po_b_list->KeyCount = $po_b_list->RowIndex;

		// Init row class and style
		$po_b->resetAttributes();
		$po_b->CssClass = "";
		if ($po_b->isGridAdd()) {
		} else {
			$po_b_list->loadRowValues($po_b_list->Recordset); // Load row values
		}
		$po_b->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_b->RowAttrs = array_merge($po_b->RowAttrs, array('data-rowindex'=>$po_b_list->RowCnt, 'id'=>'r' . $po_b_list->RowCnt . '_po_b', 'data-rowtype'=>$po_b->RowType));

		// Render row
		$po_b_list->renderRow();

		// Render list options
		$po_b_list->renderListOptions();
?>
	<tr<?php echo $po_b->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_b_list->ListOptions->render("body", "left", $po_b_list->RowCnt);
?>
	<?php if ($po_b->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_b->id->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_id" class="po_b_id">
<span<?php echo $po_b->id->viewAttributes() ?>>
<?php echo $po_b->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->po->Visible) { // po ?>
		<td data-name="po"<?php echo $po_b->po->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_po" class="po_b_po">
<span<?php echo $po_b->po->viewAttributes() ?>>
<?php if ((!EmptyString($po_b->po->getViewValue())) && $po_b->po->linkAttributes() <> "") { ?>
<a<?php echo $po_b->po->linkAttributes() ?>><?php echo $po_b->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_b->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $po_b->company_id->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_company_id" class="po_b_company_id">
<span<?php echo $po_b->company_id->viewAttributes() ?>>
<?php echo $po_b->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $po_b->partner_id->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_partner_id" class="po_b_partner_id">
<span<?php echo $po_b->partner_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_b->partner_id->getViewValue())) && $po_b->partner_id->linkAttributes() <> "") { ?>
<a<?php echo $po_b->partner_id->linkAttributes() ?>><?php echo $po_b->partner_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_b->partner_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $po_b->quantity->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_quantity" class="po_b_quantity">
<span<?php echo $po_b->quantity->viewAttributes() ?>>
<?php echo $po_b->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $po_b->sqm->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_sqm" class="po_b_sqm">
<span<?php echo $po_b->sqm->viewAttributes() ?>>
<?php echo $po_b->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $po_b->amount->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_amount" class="po_b_amount">
<span<?php echo $po_b->amount->viewAttributes() ?>>
<?php echo $po_b->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $po_b->cbm->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_cbm" class="po_b_cbm">
<span<?php echo $po_b->cbm->viewAttributes() ?>>
<?php echo $po_b->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->gst->Visible) { // gst ?>
		<td data-name="gst"<?php echo $po_b->gst->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_gst" class="po_b_gst">
<span<?php echo $po_b->gst->viewAttributes() ?>>
<?php echo $po_b->gst->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->partner_order_no->Visible) { // partner_order_no ?>
		<td data-name="partner_order_no"<?php echo $po_b->partner_order_no->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_partner_order_no" class="po_b_partner_order_no">
<span<?php echo $po_b->partner_order_no->viewAttributes() ?>>
<?php echo $po_b->partner_order_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $po_b->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_despatch_date" class="po_b_despatch_date">
<span<?php echo $po_b->despatch_date->viewAttributes() ?>>
<?php echo $po_b->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $po_b->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_despatch_week" class="po_b_despatch_week">
<span<?php echo $po_b->despatch_week->viewAttributes() ?>>
<?php echo $po_b->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->fob_date->Visible) { // fob_date ?>
		<td data-name="fob_date"<?php echo $po_b->fob_date->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_fob_date" class="po_b_fob_date">
<span<?php echo $po_b->fob_date->viewAttributes() ?>>
<?php echo $po_b->fob_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->payment_terms->Visible) { // payment_terms ?>
		<td data-name="payment_terms"<?php echo $po_b->payment_terms->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_payment_terms" class="po_b_payment_terms">
<span<?php echo $po_b->payment_terms->viewAttributes() ?>>
<?php if ((!EmptyString($po_b->payment_terms->getViewValue())) && $po_b->payment_terms->linkAttributes() <> "") { ?>
<a<?php echo $po_b->payment_terms->linkAttributes() ?>><?php echo $po_b->payment_terms->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_b->payment_terms->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->transport_type->Visible) { // transport_type ?>
		<td data-name="transport_type"<?php echo $po_b->transport_type->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_transport_type" class="po_b_transport_type">
<span<?php echo $po_b->transport_type->viewAttributes() ?>>
<?php if ((!EmptyString($po_b->transport_type->getViewValue())) && $po_b->transport_type->linkAttributes() <> "") { ?>
<a<?php echo $po_b->transport_type->linkAttributes() ?>><?php echo $po_b->transport_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_b->transport_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->partner_shipping_id->Visible) { // partner_shipping_id ?>
		<td data-name="partner_shipping_id"<?php echo $po_b->partner_shipping_id->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_partner_shipping_id" class="po_b_partner_shipping_id">
<span<?php echo $po_b->partner_shipping_id->viewAttributes() ?>>
<?php echo $po_b->partner_shipping_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->uploads->Visible) { // uploads ?>
		<td data-name="uploads"<?php echo $po_b->uploads->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_uploads" class="po_b_uploads">
<span>
<?php echo GetFileViewTag($po_b->uploads, $po_b->uploads->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $po_b->operator->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_operator" class="po_b_operator">
<span<?php echo $po_b->operator->viewAttributes() ?>>
<?php echo $po_b->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $po_b->datetime->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_datetime" class="po_b_datetime">
<span<?php echo $po_b->datetime->viewAttributes() ?>>
<?php echo $po_b->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $po_b->a_operator->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_a_operator" class="po_b_a_operator">
<span<?php echo $po_b->a_operator->viewAttributes() ?>>
<?php echo $po_b->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $po_b->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_a_datetime" class="po_b_a_datetime">
<span<?php echo $po_b->a_datetime->viewAttributes() ?>>
<?php echo $po_b->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->app_operator->Visible) { // app_operator ?>
		<td data-name="app_operator"<?php echo $po_b->app_operator->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_app_operator" class="po_b_app_operator">
<span<?php echo $po_b->app_operator->viewAttributes() ?>>
<?php echo $po_b->app_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->app_datetime->Visible) { // app_datetime ?>
		<td data-name="app_datetime"<?php echo $po_b->app_datetime->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_app_datetime" class="po_b_app_datetime">
<span<?php echo $po_b->app_datetime->viewAttributes() ?>>
<?php echo $po_b->app_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_b->order_file->Visible) { // order_file ?>
		<td data-name="order_file"<?php echo $po_b->order_file->cellAttributes() ?>>
<span id="el<?php echo $po_b_list->RowCnt ?>_po_b_order_file" class="po_b_order_file">
<span<?php echo $po_b->order_file->viewAttributes() ?>>
<?php echo $po_b->order_file->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_b_list->ListOptions->render("body", "right", $po_b_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_b->isGridAdd())
		$po_b_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_b->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_b_list->Recordset)
	$po_b_list->Recordset->Close();
?>
<?php if (!$po_b->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_b->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_b_list->Pager)) $po_b_list->Pager = new PrevNextPager($po_b_list->StartRec, $po_b_list->DisplayRecs, $po_b_list->TotalRecs, $po_b_list->AutoHidePager) ?>
<?php if ($po_b_list->Pager->RecordCount > 0 && $po_b_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_b_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_b_list->pageUrl() ?>start=<?php echo $po_b_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_b_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_b_list->pageUrl() ?>start=<?php echo $po_b_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_b_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_b_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_b_list->pageUrl() ?>start=<?php echo $po_b_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_b_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_b_list->pageUrl() ?>start=<?php echo $po_b_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_b_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_b_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_b_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_b_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_b_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_b_list->TotalRecs > 0 && (!$po_b_list->AutoHidePageSizeSelector || $po_b_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_b">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_b_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_b_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_b_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_b_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_b_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_b->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_b_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_b_list->TotalRecs == 0 && !$po_b->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_b_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_b_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_b->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_b->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_b", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_b_list->terminate();
?>