<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_desc_addopt = new po_desc_addopt();

// Run the page
$po_desc_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_desc_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fpo_descaddopt = currentForm = new ew.Form("fpo_descaddopt", "addopt");

// Validate form
fpo_descaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_desc_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->grp->caption(), $po_desc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_desc_addopt->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->description->caption(), $po_desc->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_desc_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->operator->caption(), $po_desc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_desc_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->datetime->caption(), $po_desc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_descaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_descaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_descaddopt.lists["x_grp"] = <?php echo $po_desc_addopt->grp->Lookup->toClientList() ?>;
fpo_descaddopt.lists["x_grp"].options = <?php echo JsonEncode($po_desc_addopt->grp->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_desc_addopt->showPageHeader(); ?>
<?php
$po_desc_addopt->showMessage();
?>
<form name="fpo_descaddopt" id="fpo_descaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($po_desc_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_desc_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $po_desc_addopt->TableVar ?>">
<?php if ($po_desc->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $po_desc->grp->caption() ?><?php echo ($po_desc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_desc" data-field="x_grp" data-value-separator="<?php echo $po_desc->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_desc->grp->editAttributes() ?>>
		<?php echo $po_desc->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $po_desc->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $po_desc->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($po_desc->description->Visible) { // description ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_description"><?php echo $po_desc->description->caption() ?><?php echo ($po_desc->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="po_desc" data-field="x_description" name="x_description" id="x_description" size="30" placeholder="<?php echo HtmlEncode($po_desc->description->getPlaceHolder()) ?>" value="<?php echo $po_desc->description->EditValue ?>"<?php echo $po_desc->description->editAttributes() ?>>
<?php echo $po_desc->description->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($po_desc->operator->Visible) { // operator ?>
	<input type="hidden" data-table="po_desc" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($po_desc->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($po_desc->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="po_desc" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($po_desc->datetime->CurrentValue) ?>">
<?php } ?>
</form>
<?php
$po_desc_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$po_desc_addopt->terminate();
?>