<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_desc_edit = new po_desc_edit();

// Run the page
$po_desc_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_desc_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpo_descedit = currentForm = new ew.Form("fpo_descedit", "edit");

// Validate form
fpo_descedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_desc_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->id->caption(), $po_desc->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_desc_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->grp->caption(), $po_desc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_desc_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->description->caption(), $po_desc->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_desc_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->operator->caption(), $po_desc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_desc_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_desc->datetime->caption(), $po_desc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_descedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_descedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_descedit.lists["x_grp"] = <?php echo $po_desc_edit->grp->Lookup->toClientList() ?>;
fpo_descedit.lists["x_grp"].options = <?php echo JsonEncode($po_desc_edit->grp->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_desc_edit->showPageHeader(); ?>
<?php
$po_desc_edit->showMessage();
?>
<form name="fpo_descedit" id="fpo_descedit" class="<?php echo $po_desc_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_desc_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_desc_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_desc">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$po_desc_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_desc->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_po_desc_id" class="<?php echo $po_desc_edit->LeftColumnClass ?>"><?php echo $po_desc->id->caption() ?><?php echo ($po_desc->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_desc_edit->RightColumnClass ?>"><div<?php echo $po_desc->id->cellAttributes() ?>>
<span id="el_po_desc_id">
<span<?php echo $po_desc->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_desc->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_desc" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($po_desc->id->CurrentValue) ?>">
<?php echo $po_desc->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_desc->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_po_desc_grp" for="x_grp" class="<?php echo $po_desc_edit->LeftColumnClass ?>"><?php echo $po_desc->grp->caption() ?><?php echo ($po_desc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_desc_edit->RightColumnClass ?>"><div<?php echo $po_desc->grp->cellAttributes() ?>>
<span id="el_po_desc_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_desc" data-field="x_grp" data-value-separator="<?php echo $po_desc->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_desc->grp->editAttributes() ?>>
		<?php echo $po_desc->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $po_desc->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $po_desc->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_desc->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_po_desc_description" for="x_description" class="<?php echo $po_desc_edit->LeftColumnClass ?>"><?php echo $po_desc->description->caption() ?><?php echo ($po_desc->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_desc_edit->RightColumnClass ?>"><div<?php echo $po_desc->description->cellAttributes() ?>>
<span id="el_po_desc_description">
<input type="text" data-table="po_desc" data-field="x_description" name="x_description" id="x_description" size="30" placeholder="<?php echo HtmlEncode($po_desc->description->getPlaceHolder()) ?>" value="<?php echo $po_desc->description->EditValue ?>"<?php echo $po_desc->description->editAttributes() ?>>
</span>
<?php echo $po_desc->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_desc_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_desc_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_desc_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_desc_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_desc_edit->terminate();
?>