<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_desc_view = new po_desc_view();

// Run the page
$po_desc_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_desc_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_desc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpo_descview = currentForm = new ew.Form("fpo_descview", "view");

// Form_CustomValidate event
fpo_descview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_descview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_descview.lists["x_grp"] = <?php echo $po_desc_view->grp->Lookup->toClientList() ?>;
fpo_descview.lists["x_grp"].options = <?php echo JsonEncode($po_desc_view->grp->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_desc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $po_desc_view->ExportOptions->render("body") ?>
<?php $po_desc_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $po_desc_view->showPageHeader(); ?>
<?php
$po_desc_view->showMessage();
?>
<form name="fpo_descview" id="fpo_descview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_desc_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_desc_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_desc">
<input type="hidden" name="modal" value="<?php echo (int)$po_desc_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_desc->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $po_desc_view->TableLeftColumnClass ?>"><span id="elh_po_desc_id"><?php echo $po_desc->id->caption() ?></span></td>
		<td data-name="id"<?php echo $po_desc->id->cellAttributes() ?>>
<span id="el_po_desc_id">
<span<?php echo $po_desc->id->viewAttributes() ?>>
<?php echo $po_desc->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_desc->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $po_desc_view->TableLeftColumnClass ?>"><span id="elh_po_desc_grp"><?php echo $po_desc->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $po_desc->grp->cellAttributes() ?>>
<span id="el_po_desc_grp">
<span<?php echo $po_desc->grp->viewAttributes() ?>>
<?php echo $po_desc->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_desc->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $po_desc_view->TableLeftColumnClass ?>"><span id="elh_po_desc_description"><?php echo $po_desc->description->caption() ?></span></td>
		<td data-name="description"<?php echo $po_desc->description->cellAttributes() ?>>
<span id="el_po_desc_description">
<span<?php echo $po_desc->description->viewAttributes() ?>>
<?php echo $po_desc->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_desc->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $po_desc_view->TableLeftColumnClass ?>"><span id="elh_po_desc_operator"><?php echo $po_desc->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $po_desc->operator->cellAttributes() ?>>
<span id="el_po_desc_operator">
<span<?php echo $po_desc->operator->viewAttributes() ?>>
<?php echo $po_desc->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_desc->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $po_desc_view->TableLeftColumnClass ?>"><span id="elh_po_desc_datetime"><?php echo $po_desc->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $po_desc->datetime->cellAttributes() ?>>
<span id="el_po_desc_datetime">
<span<?php echo $po_desc->datetime->viewAttributes() ?>>
<?php echo $po_desc->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$po_desc_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_desc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_desc_view->terminate();
?>