<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_f_edit = new po_f_edit();

// Run the page
$po_f_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_f_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpo_fedit = currentForm = new ew.Form("fpo_fedit", "edit");

// Validate form
fpo_fedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_f_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->id->caption(), $po_f->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->grp->caption(), $po_f->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->po->caption(), $po_f->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->buyer_id->caption(), $po_f->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->buyer_product_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_product_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->buyer_product_ref->caption(), $po_f->buyer_product_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->s_grp->caption(), $po_f->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->product->caption(), $po_f->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->rid->caption(), $po_f->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->batch_no->caption(), $po_f->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->quantity->caption(), $po_f->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->price->caption(), $po_f->price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->buyer_order_no->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_order_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->buyer_order_no->caption(), $po_f->buyer_order_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->buyer_order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_order_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->buyer_order_date->caption(), $po_f->buyer_order_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer_order_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_f->buyer_order_date->errorMessage()) ?>");
		<?php if ($po_f_edit->buyer_instruction->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_instruction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->buyer_instruction->caption(), $po_f->buyer_instruction->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->despatch_week->caption(), $po_f->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->production_plan->caption(), $po_f->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->lot_no->caption(), $po_f->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_description_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->description_01->caption(), $po_f->description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_f->description_01->errorMessage()) ?>");
		<?php if ($po_f_edit->description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_description_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->description_02->caption(), $po_f->description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_02");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_f->description_02->errorMessage()) ?>");
		<?php if ($po_f_edit->description_03->Required) { ?>
			elm = this.getElements("x" + infix + "_description_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->description_03->caption(), $po_f->description_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->description_04->Required) { ?>
			elm = this.getElements("x" + infix + "_description_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->description_04->caption(), $po_f->description_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->description_05->Required) { ?>
			elm = this.getElements("x" + infix + "_description_05");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->description_05->caption(), $po_f->description_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->description_06->Required) { ?>
			elm = this.getElements("x" + infix + "_description_06");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->description_06->caption(), $po_f->description_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->description_07->Required) { ?>
			elm = this.getElements("x" + infix + "_description_07");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->description_07->caption(), $po_f->description_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->description_08->Required) { ?>
			elm = this.getElements("x" + infix + "_description_08");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->description_08->caption(), $po_f->description_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->remarks->caption(), $po_f->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->operator->caption(), $po_f->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->datetime->caption(), $po_f->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_f_edit->production_site->Required) { ?>
			elm = this.getElements("x" + infix + "_production_site");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_f->production_site->caption(), $po_f->production_site->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_production_site");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_f->production_site->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_fedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_fedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_fedit.multiPage = new ew.MultiPage("fpo_fedit");

// Dynamic selection lists
fpo_fedit.lists["x_grp"] = <?php echo $po_f_edit->grp->Lookup->toClientList() ?>;
fpo_fedit.lists["x_grp"].options = <?php echo JsonEncode($po_f_edit->grp->options(FALSE, TRUE)) ?>;
fpo_fedit.lists["x_buyer_id"] = <?php echo $po_f_edit->buyer_id->Lookup->toClientList() ?>;
fpo_fedit.lists["x_buyer_id"].options = <?php echo JsonEncode($po_f_edit->buyer_id->lookupOptions()) ?>;
fpo_fedit.lists["x_s_grp"] = <?php echo $po_f_edit->s_grp->Lookup->toClientList() ?>;
fpo_fedit.lists["x_s_grp"].options = <?php echo JsonEncode($po_f_edit->s_grp->lookupOptions()) ?>;
fpo_fedit.lists["x_product"] = <?php echo $po_f_edit->product->Lookup->toClientList() ?>;
fpo_fedit.lists["x_product"].options = <?php echo JsonEncode($po_f_edit->product->lookupOptions()) ?>;
fpo_fedit.lists["x_rid"] = <?php echo $po_f_edit->rid->Lookup->toClientList() ?>;
fpo_fedit.lists["x_rid"].options = <?php echo JsonEncode($po_f_edit->rid->lookupOptions()) ?>;
fpo_fedit.lists["x_despatch_week"] = <?php echo $po_f_edit->despatch_week->Lookup->toClientList() ?>;
fpo_fedit.lists["x_despatch_week"].options = <?php echo JsonEncode($po_f_edit->despatch_week->lookupOptions()) ?>;
fpo_fedit.lists["x_production_plan"] = <?php echo $po_f_edit->production_plan->Lookup->toClientList() ?>;
fpo_fedit.lists["x_production_plan"].options = <?php echo JsonEncode($po_f_edit->production_plan->options(FALSE, TRUE)) ?>;
fpo_fedit.lists["x_description_01"] = <?php echo $po_f_edit->description_01->Lookup->toClientList() ?>;
fpo_fedit.lists["x_description_01"].options = <?php echo JsonEncode($po_f_edit->description_01->lookupOptions()) ?>;
fpo_fedit.autoSuggests["x_description_01"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fedit.lists["x_description_02"] = <?php echo $po_f_edit->description_02->Lookup->toClientList() ?>;
fpo_fedit.lists["x_description_02"].options = <?php echo JsonEncode($po_f_edit->description_02->lookupOptions()) ?>;
fpo_fedit.autoSuggests["x_description_02"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fedit.lists["x_description_03"] = <?php echo $po_f_edit->description_03->Lookup->toClientList() ?>;
fpo_fedit.lists["x_description_03"].options = <?php echo JsonEncode($po_f_edit->description_03->lookupOptions()) ?>;
fpo_fedit.lists["x_description_04"] = <?php echo $po_f_edit->description_04->Lookup->toClientList() ?>;
fpo_fedit.lists["x_description_04"].options = <?php echo JsonEncode($po_f_edit->description_04->lookupOptions()) ?>;
fpo_fedit.lists["x_description_05"] = <?php echo $po_f_edit->description_05->Lookup->toClientList() ?>;
fpo_fedit.lists["x_description_05"].options = <?php echo JsonEncode($po_f_edit->description_05->lookupOptions()) ?>;
fpo_fedit.lists["x_description_06"] = <?php echo $po_f_edit->description_06->Lookup->toClientList() ?>;
fpo_fedit.lists["x_description_06"].options = <?php echo JsonEncode($po_f_edit->description_06->lookupOptions()) ?>;
fpo_fedit.lists["x_description_07"] = <?php echo $po_f_edit->description_07->Lookup->toClientList() ?>;
fpo_fedit.lists["x_description_07"].options = <?php echo JsonEncode($po_f_edit->description_07->lookupOptions()) ?>;
fpo_fedit.autoSuggests["x_description_07"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fedit.lists["x_description_08"] = <?php echo $po_f_edit->description_08->Lookup->toClientList() ?>;
fpo_fedit.lists["x_description_08"].options = <?php echo JsonEncode($po_f_edit->description_08->lookupOptions()) ?>;
fpo_fedit.autoSuggests["x_description_08"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fedit.lists["x_operator"] = <?php echo $po_f_edit->operator->Lookup->toClientList() ?>;
fpo_fedit.lists["x_operator"].options = <?php echo JsonEncode($po_f_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_f_edit->showPageHeader(); ?>
<?php
$po_f_edit->showMessage();
?>
<form name="fpo_fedit" id="fpo_fedit" class="<?php echo $po_f_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_f_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_f_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_f">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$po_f_edit->IsModal ?>">
<?php if ($po_f_edit->MultiPages->Items[0]->Visible) { ?>
<div class="ew-edit-div"><!-- page0 -->
<?php if ($po_f->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_po_f_grp" for="x_grp" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->grp->caption() ?><?php echo ($po_f->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->grp->cellAttributes() ?>>
<span id="el_po_f_grp">
<span<?php echo $po_f->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_f->grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_f" data-field="x_grp" data-page="0" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($po_f->grp->CurrentValue) ?>">
<?php echo $po_f->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_po_f_po" for="x_po" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->po->caption() ?><?php echo ($po_f->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->po->cellAttributes() ?>>
<span id="el_po_f_po">
<span<?php echo $po_f->po->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_f->po->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_f" data-field="x_po" data-page="0" name="x_po" id="x_po" value="<?php echo HtmlEncode($po_f->po->CurrentValue) ?>">
<?php echo $po_f->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_po_f_s_grp" for="x_s_grp" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->s_grp->caption() ?><?php echo ($po_f->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->s_grp->cellAttributes() ?>>
<span id="el_po_f_s_grp">
<?php $po_f->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_f->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_s_grp" data-page="0" data-value-separator="<?php echo $po_f->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $po_f->s_grp->editAttributes() ?>>
		<?php echo $po_f->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $po_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $po_f->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_po_f_product" for="x_product" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->product->caption() ?><?php echo ($po_f->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->product->cellAttributes() ?>>
<span id="el_po_f_product">
<?php $po_f->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_f->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_product" data-page="0" data-value-separator="<?php echo $po_f->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $po_f->product->editAttributes() ?>>
		<?php echo $po_f->product->selectOptionListHtml("x_product") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "product_f") && !$po_f->product->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_f->product->caption() ?>" data-title="<?php echo $po_f->product->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_product',url:'product_faddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $po_f->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_po_f_rid" for="x_rid" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->rid->caption() ?><?php echo ($po_f->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->rid->cellAttributes() ?>>
<span id="el_po_f_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_rid" data-page="0" data-value-separator="<?php echo $po_f->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $po_f->rid->editAttributes() ?>>
		<?php echo $po_f->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $po_f->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $po_f->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_po_f_batch_no" for="x_batch_no" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->batch_no->caption() ?><?php echo ($po_f->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->batch_no->cellAttributes() ?>>
<span id="el_po_f_batch_no">
<span<?php echo $po_f->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($po_f->batch_no->EditValue)) && $po_f->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $po_f->batch_no->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_f->batch_no->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_f->batch_no->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="po_f" data-field="x_batch_no" data-page="0" name="x_batch_no" id="x_batch_no" value="<?php echo HtmlEncode($po_f->batch_no->CurrentValue) ?>">
<?php echo $po_f->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav-tabs" id="po_f_edit"><!-- multi-page tabs -->
	<ul class="<?php echo $po_f_edit->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $po_f_edit->MultiPages->pageStyle("1") ?>" href="#tab_po_f1" data-toggle="tab"><?php echo $po_f->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_f_edit->MultiPages->pageStyle("2") ?>" href="#tab_po_f2" data-toggle="tab"><?php echo $po_f->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_f_edit->MultiPages->pageStyle("3") ?>" href="#tab_po_f3" data-toggle="tab"><?php echo $po_f->pageCaption(3) ?></a></li>
		<li class="nav-item d-none"><a class="nav-link" href="#tab_po_f4" data-toggle="tab"></a></li>
		<li class="nav-item d-none"><a class="nav-link" href="#tab_po_f5" data-toggle="tab"></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_f_edit->MultiPages->pageStyle("6") ?>" href="#tab_po_f6" data-toggle="tab"><?php echo $po_f->pageCaption(6) ?></a></li>
	</ul>
	<div class="tab-content"><!-- multi-page tabs .tab-content -->
		<div class="tab-pane<?php echo $po_f_edit->MultiPages->pageStyle("1") ?>" id="tab_po_f1"><!-- multi-page .tab-pane -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_f->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_po_f_id" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->id->caption() ?><?php echo ($po_f->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->id->cellAttributes() ?>>
<span id="el_po_f_id">
<span<?php echo $po_f->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_f->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_f" data-field="x_id" data-page="1" name="x_id" id="x_id" value="<?php echo HtmlEncode($po_f->id->CurrentValue) ?>">
<?php echo $po_f->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_po_f_buyer_id" for="x_buyer_id" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->buyer_id->caption() ?><?php echo ($po_f->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->buyer_id->cellAttributes() ?>>
<span id="el_po_f_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_buyer_id" data-page="1" data-value-separator="<?php echo $po_f->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po_f->buyer_id->editAttributes() ?>>
		<?php echo $po_f->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$po_f->buyer_id->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_f->buyer_id->caption() ?>" data-title="<?php echo $po_f->buyer_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_buyer_id',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_f->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
<?php echo $po_f->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_product_ref->Visible) { // buyer_product_ref ?>
	<div id="r_buyer_product_ref" class="form-group row">
		<label id="elh_po_f_buyer_product_ref" for="x_buyer_product_ref" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->buyer_product_ref->caption() ?><?php echo ($po_f->buyer_product_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->buyer_product_ref->cellAttributes() ?>>
<span id="el_po_f_buyer_product_ref">
<input type="text" data-table="po_f" data-field="x_buyer_product_ref" data-page="1" name="x_buyer_product_ref" id="x_buyer_product_ref" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_f->buyer_product_ref->getPlaceHolder()) ?>" value="<?php echo $po_f->buyer_product_ref->EditValue ?>"<?php echo $po_f->buyer_product_ref->editAttributes() ?>>
</span>
<?php echo $po_f->buyer_product_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_order_no->Visible) { // buyer_order_no ?>
	<div id="r_buyer_order_no" class="form-group row">
		<label id="elh_po_f_buyer_order_no" for="x_buyer_order_no" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->buyer_order_no->caption() ?><?php echo ($po_f->buyer_order_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->buyer_order_no->cellAttributes() ?>>
<span id="el_po_f_buyer_order_no">
<input type="text" data-table="po_f" data-field="x_buyer_order_no" data-page="1" name="x_buyer_order_no" id="x_buyer_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_f->buyer_order_no->getPlaceHolder()) ?>" value="<?php echo $po_f->buyer_order_no->EditValue ?>"<?php echo $po_f->buyer_order_no->editAttributes() ?>>
</span>
<?php echo $po_f->buyer_order_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_order_date->Visible) { // buyer_order_date ?>
	<div id="r_buyer_order_date" class="form-group row">
		<label id="elh_po_f_buyer_order_date" for="x_buyer_order_date" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->buyer_order_date->caption() ?><?php echo ($po_f->buyer_order_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->buyer_order_date->cellAttributes() ?>>
<span id="el_po_f_buyer_order_date">
<input type="text" data-table="po_f" data-field="x_buyer_order_date" data-page="1" name="x_buyer_order_date" id="x_buyer_order_date" placeholder="<?php echo HtmlEncode($po_f->buyer_order_date->getPlaceHolder()) ?>" value="<?php echo $po_f->buyer_order_date->EditValue ?>"<?php echo $po_f->buyer_order_date->editAttributes() ?>>
<?php if (!$po_f->buyer_order_date->ReadOnly && !$po_f->buyer_order_date->Disabled && !isset($po_f->buyer_order_date->EditAttrs["readonly"]) && !isset($po_f->buyer_order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fedit", "x_buyer_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_f->buyer_order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label id="elh_po_f_buyer_instruction" for="x_buyer_instruction" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->buyer_instruction->caption() ?><?php echo ($po_f->buyer_instruction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->buyer_instruction->cellAttributes() ?>>
<span id="el_po_f_buyer_instruction">
<textarea data-table="po_f" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po_f->buyer_instruction->getPlaceHolder()) ?>"<?php echo $po_f->buyer_instruction->editAttributes() ?>><?php echo $po_f->buyer_instruction->EditValue ?></textarea>
</span>
<?php echo $po_f->buyer_instruction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->production_site->Visible) { // production_site ?>
	<div id="r_production_site" class="form-group row">
		<label id="elh_po_f_production_site" for="x_production_site" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->production_site->caption() ?><?php echo ($po_f->production_site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->production_site->cellAttributes() ?>>
<span id="el_po_f_production_site">
<input type="text" data-table="po_f" data-field="x_production_site" data-page="1" name="x_production_site" id="x_production_site" size="30" placeholder="<?php echo HtmlEncode($po_f->production_site->getPlaceHolder()) ?>" value="<?php echo $po_f->production_site->EditValue ?>"<?php echo $po_f->production_site->editAttributes() ?>>
</span>
<?php echo $po_f->production_site->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_edit->MultiPages->pageStyle("2") ?>" id="tab_po_f2"><!-- multi-page .tab-pane -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_f->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_po_f_quantity" for="x_quantity" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->quantity->caption() ?><?php echo ($po_f->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->quantity->cellAttributes() ?>>
<span id="el_po_f_quantity">
<input type="text" data-table="po_f" data-field="x_quantity" data-page="2" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_f->quantity->getPlaceHolder()) ?>" value="<?php echo $po_f->quantity->EditValue ?>"<?php echo $po_f->quantity->editAttributes() ?>>
</span>
<?php echo $po_f->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_po_f_price" for="x_price" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->price->caption() ?><?php echo ($po_f->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->price->cellAttributes() ?>>
<span id="el_po_f_price">
<input type="text" data-table="po_f" data-field="x_price" data-page="2" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($po_f->price->getPlaceHolder()) ?>" value="<?php echo $po_f->price->EditValue ?>"<?php echo $po_f->price->editAttributes() ?>>
</span>
<?php echo $po_f->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_po_f_despatch_week" for="x_despatch_week" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->despatch_week->caption() ?><?php echo ($po_f->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->despatch_week->cellAttributes() ?>>
<span id="el_po_f_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_despatch_week" data-page="2" data-value-separator="<?php echo $po_f->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $po_f->despatch_week->editAttributes() ?>>
		<?php echo $po_f->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $po_f->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
<?php echo $po_f->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_po_f_production_plan" for="x_production_plan" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->production_plan->caption() ?><?php echo ($po_f->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->production_plan->cellAttributes() ?>>
<span id="el_po_f_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_production_plan" data-page="2" data-value-separator="<?php echo $po_f->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $po_f->production_plan->editAttributes() ?>>
		<?php echo $po_f->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
<?php echo $po_f->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_po_f_lot_no" for="x_lot_no" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->lot_no->caption() ?><?php echo ($po_f->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->lot_no->cellAttributes() ?>>
<span id="el_po_f_lot_no">
<input type="text" data-table="po_f" data-field="x_lot_no" data-page="2" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($po_f->lot_no->getPlaceHolder()) ?>" value="<?php echo $po_f->lot_no->EditValue ?>"<?php echo $po_f->lot_no->editAttributes() ?>>
</span>
<?php echo $po_f->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_edit->MultiPages->pageStyle("3") ?>" id="tab_po_f3"><!-- multi-page .tab-pane -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_f->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label id="elh_po_f_description_01" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->description_01->caption() ?><?php echo ($po_f->description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->description_01->cellAttributes() ?>>
<span id="el_po_f_description_01">
<?php
$wrkonchange = "" . trim(@$po_f->description_01->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_01->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_01" class="text-nowrap" style="z-index: 8790">
	<input type="text" class="form-control" name="sv_x_description_01" id="sv_x_description_01" value="<?php echo RemoveHtml($po_f->description_01->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_f->description_01->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_01->getPlaceHolder()) ?>"<?php echo $po_f->description_01->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_01" data-page="3" data-value-separator="<?php echo $po_f->description_01->displayValueSeparatorAttribute() ?>" name="x_description_01" id="x_description_01" value="<?php echo HtmlEncode($po_f->description_01->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fedit.createAutoSuggest({"id":"x_description_01","forceSelect":false});
</script>
<?php echo $po_f->description_01->Lookup->getParamTag("p_x_description_01") ?>
</span>
<?php echo $po_f->description_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label id="elh_po_f_description_02" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->description_02->caption() ?><?php echo ($po_f->description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->description_02->cellAttributes() ?>>
<span id="el_po_f_description_02">
<?php
$wrkonchange = "" . trim(@$po_f->description_02->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_02->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_02" class="text-nowrap" style="z-index: 8770">
	<input type="text" class="form-control" name="sv_x_description_02" id="sv_x_description_02" value="<?php echo RemoveHtml($po_f->description_02->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_f->description_02->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_02->getPlaceHolder()) ?>"<?php echo $po_f->description_02->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_02" data-page="3" data-value-separator="<?php echo $po_f->description_02->displayValueSeparatorAttribute() ?>" name="x_description_02" id="x_description_02" value="<?php echo HtmlEncode($po_f->description_02->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fedit.createAutoSuggest({"id":"x_description_02","forceSelect":false});
</script>
<?php echo $po_f->description_02->Lookup->getParamTag("p_x_description_02") ?>
</span>
<?php echo $po_f->description_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label id="elh_po_f_description_03" for="x_description_03" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->description_03->caption() ?><?php echo ($po_f->description_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->description_03->cellAttributes() ?>>
<span id="el_po_f_description_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_description_03" data-page="3" data-value-separator="<?php echo $po_f->description_03->displayValueSeparatorAttribute() ?>" id="x_description_03" name="x_description_03"<?php echo $po_f->description_03->editAttributes() ?>>
		<?php echo $po_f->description_03->selectOptionListHtml("x_description_03") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_03") && !$po_f->description_03->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_03" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_f->description_03->caption() ?>" data-title="<?php echo $po_f->description_03->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_03',url:'d_03addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_f->description_03->Lookup->getParamTag("p_x_description_03") ?>
</span>
<?php echo $po_f->description_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label id="elh_po_f_description_04" for="x_description_04" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->description_04->caption() ?><?php echo ($po_f->description_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->description_04->cellAttributes() ?>>
<span id="el_po_f_description_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_description_04" data-page="3" data-value-separator="<?php echo $po_f->description_04->displayValueSeparatorAttribute() ?>" id="x_description_04" name="x_description_04"<?php echo $po_f->description_04->editAttributes() ?>>
		<?php echo $po_f->description_04->selectOptionListHtml("x_description_04") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_04") && !$po_f->description_04->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_04" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_f->description_04->caption() ?>" data-title="<?php echo $po_f->description_04->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_04',url:'d_04addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_f->description_04->Lookup->getParamTag("p_x_description_04") ?>
</span>
<?php echo $po_f->description_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label id="elh_po_f_description_05" for="x_description_05" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->description_05->caption() ?><?php echo ($po_f->description_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->description_05->cellAttributes() ?>>
<span id="el_po_f_description_05">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_description_05" data-page="3" data-value-separator="<?php echo $po_f->description_05->displayValueSeparatorAttribute() ?>" id="x_description_05" name="x_description_05"<?php echo $po_f->description_05->editAttributes() ?>>
		<?php echo $po_f->description_05->selectOptionListHtml("x_description_05") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_05") && !$po_f->description_05->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_05" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_f->description_05->caption() ?>" data-title="<?php echo $po_f->description_05->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_05',url:'d_05addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_f->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
<?php echo $po_f->description_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label id="elh_po_f_description_06" for="x_description_06" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->description_06->caption() ?><?php echo ($po_f->description_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->description_06->cellAttributes() ?>>
<span id="el_po_f_description_06">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_description_06" data-page="3" data-value-separator="<?php echo $po_f->description_06->displayValueSeparatorAttribute() ?>" id="x_description_06" name="x_description_06"<?php echo $po_f->description_06->editAttributes() ?>>
		<?php echo $po_f->description_06->selectOptionListHtml("x_description_06") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_06") && !$po_f->description_06->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_06" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_f->description_06->caption() ?>" data-title="<?php echo $po_f->description_06->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_06',url:'d_06addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_f->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
<?php echo $po_f->description_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label id="elh_po_f_description_07" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->description_07->caption() ?><?php echo ($po_f->description_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->description_07->cellAttributes() ?>>
<span id="el_po_f_description_07">
<?php
$wrkonchange = "" . trim(@$po_f->description_07->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_07->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_07" class="text-nowrap" style="z-index: 8670">
	<input type="text" class="form-control" name="sv_x_description_07" id="sv_x_description_07" value="<?php echo RemoveHtml($po_f->description_07->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_f->description_07->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_07->getPlaceHolder()) ?>"<?php echo $po_f->description_07->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_07" data-page="3" data-value-separator="<?php echo $po_f->description_07->displayValueSeparatorAttribute() ?>" name="x_description_07" id="x_description_07" value="<?php echo HtmlEncode($po_f->description_07->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fedit.createAutoSuggest({"id":"x_description_07","forceSelect":false});
</script>
<?php echo $po_f->description_07->Lookup->getParamTag("p_x_description_07") ?>
</span>
<?php echo $po_f->description_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label id="elh_po_f_description_08" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->description_08->caption() ?><?php echo ($po_f->description_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->description_08->cellAttributes() ?>>
<span id="el_po_f_description_08">
<?php
$wrkonchange = "" . trim(@$po_f->description_08->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_08->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_08" class="text-nowrap" style="z-index: 8650">
	<input type="text" class="form-control" name="sv_x_description_08" id="sv_x_description_08" value="<?php echo RemoveHtml($po_f->description_08->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_f->description_08->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_08->getPlaceHolder()) ?>"<?php echo $po_f->description_08->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_08" data-page="3" data-value-separator="<?php echo $po_f->description_08->displayValueSeparatorAttribute() ?>" name="x_description_08" id="x_description_08" value="<?php echo HtmlEncode($po_f->description_08->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fedit.createAutoSuggest({"id":"x_description_08","forceSelect":false});
</script>
<?php echo $po_f->description_08->Lookup->getParamTag("p_x_description_08") ?>
</span>
<?php echo $po_f->description_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_edit->MultiPages->pageStyle("4") ?>" id="tab_po_f4"><!-- multi-page .tab-pane -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_edit->MultiPages->pageStyle("5") ?>" id="tab_po_f5"><!-- multi-page .tab-pane -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_edit->MultiPages->pageStyle("6") ?>" id="tab_po_f6"><!-- multi-page .tab-pane -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($po_f->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_po_f_remarks" for="x_remarks" class="<?php echo $po_f_edit->LeftColumnClass ?>"><?php echo $po_f->remarks->caption() ?><?php echo ($po_f->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_f_edit->RightColumnClass ?>"><div<?php echo $po_f->remarks->cellAttributes() ?>>
<span id="el_po_f_remarks">
<textarea data-table="po_f" data-field="x_remarks" data-page="6" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po_f->remarks->getPlaceHolder()) ?>"<?php echo $po_f->remarks->editAttributes() ?>><?php echo $po_f->remarks->EditValue ?></textarea>
</span>
<?php echo $po_f->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
	</div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?php if (!$po_f_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_f_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_f_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_f_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

/*var s_grp_id=$("#x_s_grp").val();
		if(s_grp_id==11)
		{
			alert(s_grp_id);
			$("#elh_po_f_description_01").html("<?php echo PageDesc(11,'d_01_head')['d_01_head'] ?>");
			$("#elh_po_f_description_02").html("<?php echo PageDesc(11,'d_02_head')['d_02_head'] ?>");
			$("#elh_po_f_description_03").html("<?php echo PageDesc(11,'d_03_head')['d_03_head'] ?>");
			$("#elh_po_f_description_04").html("<?php echo PageDesc(11,'d_04_head')['d_04_head'] ?>");
			$("#elh_po_f_description_05").html("<?php echo PageDesc(11,'d_05_head')['d_05_head'] ?>");
			$("#elh_po_f_description_06").html("<?php echo PageDesc(11,'d_06_head')['d_06_head'] ?>");
			$("#elh_po_f_description_07").html("<?php echo PageDesc(11,'d_07_head')['d_07_head'] ?>");
			$("#elh_po_f_description_08").html("<?php echo PageDesc(11,'d_08_head')['d_08_head'] ?>");
		}
			if(s_grp_id==12){
			alert(s_grp_id);
			$("#elh_po_f_description_01").html("<?php echo PageDesc(12,'d_01_head')['d_01_head'] ?>");
			$("#elh_po_f_description_02").html("<?php echo PageDesc(12,'d_02_head')['d_02_head'] ?>");
			$("#elh_po_f_description_03").html("<?php echo PageDesc(12,'d_03_head')['d_03_head'] ?>");
			$("#elh_po_f_description_04").html("<?php echo PageDesc(12,'d_04_head')['d_04_head'] ?>");
			$("#elh_po_f_description_05").html("<?php echo PageDesc(12,'d_05_head')['d_05_head'] ?>");
			$("#elh_po_f_description_06").html("<?php echo PageDesc(12,'d_06_head')['d_06_head'] ?>");
			$("#elh_po_f_description_07").html("<?php echo PageDesc(12,'d_07_head')['d_07_head'] ?>");
			$("#elh_po_f_description_08").html("<?php echo PageDesc(12,'d_08_head')['d_08_head'] ?>");
		}*/
		var SGrp = $("#x_s_grp").val();
		$.getJSON("apcajax.php?getDesc="+SGrp,function(data){
			console.log(data);
			$("#elh_po_f_description_01").html(data.d_01_head);
			 $("#elh_po_f_description_02").html(data.d_02_head);
			 $("#elh_po_f_description_03").html(data.d_03_head);
			 $("#elh_po_f_description_04").html(data.d_04_head);
			 $("#elh_po_f_description_05").html(data.d_05_head);
			 $("#elh_po_f_description_06").html(data.d_06_head);
			 $("#elh_po_f_description_07").html(data.d_07_head);
			 $("#elh_po_f_description_08").html(data.d_08_head);
		});
</script>
<?php include_once "footer.php" ?>
<?php
$po_f_edit->terminate();
?>