<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_f_list = new po_f_list();

// Run the page
$po_f_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_f_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_f->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_flist = currentForm = new ew.Form("fpo_flist", "list");
fpo_flist.formKeyCountName = '<?php echo $po_f_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_flist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_flist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_flist.lists["x_grp"] = <?php echo $po_f_list->grp->Lookup->toClientList() ?>;
fpo_flist.lists["x_grp"].options = <?php echo JsonEncode($po_f_list->grp->options(FALSE, TRUE)) ?>;
fpo_flist.lists["x_buyer_id"] = <?php echo $po_f_list->buyer_id->Lookup->toClientList() ?>;
fpo_flist.lists["x_buyer_id"].options = <?php echo JsonEncode($po_f_list->buyer_id->lookupOptions()) ?>;
fpo_flist.lists["x_s_grp"] = <?php echo $po_f_list->s_grp->Lookup->toClientList() ?>;
fpo_flist.lists["x_s_grp"].options = <?php echo JsonEncode($po_f_list->s_grp->lookupOptions()) ?>;
fpo_flist.lists["x_product"] = <?php echo $po_f_list->product->Lookup->toClientList() ?>;
fpo_flist.lists["x_product"].options = <?php echo JsonEncode($po_f_list->product->lookupOptions()) ?>;
fpo_flist.lists["x_rid"] = <?php echo $po_f_list->rid->Lookup->toClientList() ?>;
fpo_flist.lists["x_rid"].options = <?php echo JsonEncode($po_f_list->rid->lookupOptions()) ?>;
fpo_flist.lists["x_despatch_week"] = <?php echo $po_f_list->despatch_week->Lookup->toClientList() ?>;
fpo_flist.lists["x_despatch_week"].options = <?php echo JsonEncode($po_f_list->despatch_week->lookupOptions()) ?>;
fpo_flist.lists["x_production_plan"] = <?php echo $po_f_list->production_plan->Lookup->toClientList() ?>;
fpo_flist.lists["x_production_plan"].options = <?php echo JsonEncode($po_f_list->production_plan->options(FALSE, TRUE)) ?>;
fpo_flist.lists["x_description_01"] = <?php echo $po_f_list->description_01->Lookup->toClientList() ?>;
fpo_flist.lists["x_description_01"].options = <?php echo JsonEncode($po_f_list->description_01->lookupOptions()) ?>;
fpo_flist.autoSuggests["x_description_01"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_flist.lists["x_a_operator"] = <?php echo $po_f_list->a_operator->Lookup->toClientList() ?>;
fpo_flist.lists["x_a_operator"].options = <?php echo JsonEncode($po_f_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fpo_flistsrch = currentSearchForm = new ew.Form("fpo_flistsrch");

// Validate function for search
fpo_flistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_description_01");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_f->description_01->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_flistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_flistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_flistsrch.lists["x_description_01"] = <?php echo $po_f_list->description_01->Lookup->toClientList() ?>;
fpo_flistsrch.lists["x_description_01"].options = <?php echo JsonEncode($po_f_list->description_01->lookupOptions()) ?>;
fpo_flistsrch.autoSuggests["x_description_01"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpo_flistsrch.filterList = <?php echo $po_f_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_flistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_f->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_f_list->TotalRecs > 0 && $po_f_list->ExportOptions->visible()) { ?>
<?php $po_f_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_f_list->ImportOptions->visible()) { ?>
<?php $po_f_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_f_list->SearchOptions->visible()) { ?>
<?php $po_f_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_f_list->FilterOptions->visible()) { ?>
<?php $po_f_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_f_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_f->isExport() && !$po_f->CurrentAction) { ?>
<form name="fpo_flistsrch" id="fpo_flistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_f_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_flistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_f">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_f_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_f->RowType = ROWTYPE_SEARCH;

// Render row
$po_f->resetAttributes();
$po_f_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_f->description_01->Visible) { // description_01 ?>
	<div id="xsc_description_01" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $po_f->description_01->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_01" id="z_description_01" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$po_f->description_01->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_01->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_01" class="text-nowrap" style="z-index: 8790">
	<input type="text" class="form-control" name="sv_x_description_01" id="sv_x_description_01" value="<?php echo RemoveHtml($po_f->description_01->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_f->description_01->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_01->getPlaceHolder()) ?>"<?php echo $po_f->description_01->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_01" data-value-separator="<?php echo $po_f->description_01->displayValueSeparatorAttribute() ?>" name="x_description_01" id="x_description_01" value="<?php echo HtmlEncode($po_f->description_01->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_flistsrch.createAutoSuggest({"id":"x_description_01","forceSelect":false});
</script>
<?php echo $po_f->description_01->Lookup->getParamTag("p_x_description_01") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_f_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_f_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_f_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_f_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_f_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_f_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_f_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_f_list->showPageHeader(); ?>
<?php
$po_f_list->showMessage();
?>
<?php if ($po_f_list->TotalRecs > 0 || $po_f->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_f_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_f">
<?php if (!$po_f->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_f_list->Pager)) $po_f_list->Pager = new PrevNextPager($po_f_list->StartRec, $po_f_list->DisplayRecs, $po_f_list->TotalRecs, $po_f_list->AutoHidePager) ?>
<?php if ($po_f_list->Pager->RecordCount > 0 && $po_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_f_list->pageUrl() ?>start=<?php echo $po_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_f_list->pageUrl() ?>start=<?php echo $po_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_f_list->pageUrl() ?>start=<?php echo $po_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_f_list->pageUrl() ?>start=<?php echo $po_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_f_list->TotalRecs > 0 && (!$po_f_list->AutoHidePageSizeSelector || $po_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_flist" id="fpo_flist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_f_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_f_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_f">
<div id="gmp_po_f" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_f_list->TotalRecs > 0 || $po_f->isGridEdit()) { ?>
<table id="tbl_po_flist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_f_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_f_list->renderListOptions();

// Render list options (header, left)
$po_f_list->ListOptions->render("header", "left");
?>
<?php if ($po_f->id->Visible) { // id ?>
	<?php if ($po_f->sortUrl($po_f->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_f->id->headerCellClass() ?>"><div id="elh_po_f_id" class="po_f_id"><div class="ew-table-header-caption"><?php echo $po_f->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_f->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->id) ?>',2);"><div id="elh_po_f_id" class="po_f_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->grp->Visible) { // grp ?>
	<?php if ($po_f->sortUrl($po_f->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $po_f->grp->headerCellClass() ?>"><div id="elh_po_f_grp" class="po_f_grp"><div class="ew-table-header-caption"><?php echo $po_f->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $po_f->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->grp) ?>',2);"><div id="elh_po_f_grp" class="po_f_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->po->Visible) { // po ?>
	<?php if ($po_f->sortUrl($po_f->po) == "") { ?>
		<th data-name="po" class="<?php echo $po_f->po->headerCellClass() ?>"><div id="elh_po_f_po" class="po_f_po"><div class="ew-table-header-caption"><?php echo $po_f->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $po_f->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->po) ?>',2);"><div id="elh_po_f_po" class="po_f_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->buyer_id->Visible) { // buyer_id ?>
	<?php if ($po_f->sortUrl($po_f->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $po_f->buyer_id->headerCellClass() ?>"><div id="elh_po_f_buyer_id" class="po_f_buyer_id"><div class="ew-table-header-caption"><?php echo $po_f->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $po_f->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->buyer_id) ?>',2);"><div id="elh_po_f_buyer_id" class="po_f_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->s_grp->Visible) { // s_grp ?>
	<?php if ($po_f->sortUrl($po_f->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $po_f->s_grp->headerCellClass() ?>"><div id="elh_po_f_s_grp" class="po_f_s_grp"><div class="ew-table-header-caption"><?php echo $po_f->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $po_f->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->s_grp) ?>',2);"><div id="elh_po_f_s_grp" class="po_f_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->product->Visible) { // product ?>
	<?php if ($po_f->sortUrl($po_f->product) == "") { ?>
		<th data-name="product" class="<?php echo $po_f->product->headerCellClass() ?>"><div id="elh_po_f_product" class="po_f_product"><div class="ew-table-header-caption"><?php echo $po_f->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $po_f->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->product) ?>',2);"><div id="elh_po_f_product" class="po_f_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->rid->Visible) { // rid ?>
	<?php if ($po_f->sortUrl($po_f->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $po_f->rid->headerCellClass() ?>"><div id="elh_po_f_rid" class="po_f_rid"><div class="ew-table-header-caption"><?php echo $po_f->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $po_f->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->rid) ?>',2);"><div id="elh_po_f_rid" class="po_f_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->batch_no->Visible) { // batch_no ?>
	<?php if ($po_f->sortUrl($po_f->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $po_f->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_po_f_batch_no" class="po_f_batch_no"><div class="ew-table-header-caption"><?php echo $po_f->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $po_f->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->batch_no) ?>',2);"><div id="elh_po_f_batch_no" class="po_f_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->quantity->Visible) { // quantity ?>
	<?php if ($po_f->sortUrl($po_f->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $po_f->quantity->headerCellClass() ?>"><div id="elh_po_f_quantity" class="po_f_quantity"><div class="ew-table-header-caption"><?php echo $po_f->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $po_f->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->quantity) ?>',2);"><div id="elh_po_f_quantity" class="po_f_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->price->Visible) { // price ?>
	<?php if ($po_f->sortUrl($po_f->price) == "") { ?>
		<th data-name="price" class="<?php echo $po_f->price->headerCellClass() ?>"><div id="elh_po_f_price" class="po_f_price"><div class="ew-table-header-caption"><?php echo $po_f->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $po_f->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->price) ?>',2);"><div id="elh_po_f_price" class="po_f_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->despatch_week->Visible) { // despatch_week ?>
	<?php if ($po_f->sortUrl($po_f->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $po_f->despatch_week->headerCellClass() ?>"><div id="elh_po_f_despatch_week" class="po_f_despatch_week"><div class="ew-table-header-caption"><?php echo $po_f->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $po_f->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->despatch_week) ?>',2);"><div id="elh_po_f_despatch_week" class="po_f_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->production_plan->Visible) { // production_plan ?>
	<?php if ($po_f->sortUrl($po_f->production_plan) == "") { ?>
		<th data-name="production_plan" class="<?php echo $po_f->production_plan->headerCellClass() ?>"><div id="elh_po_f_production_plan" class="po_f_production_plan"><div class="ew-table-header-caption"><?php echo $po_f->production_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_plan" class="<?php echo $po_f->production_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->production_plan) ?>',2);"><div id="elh_po_f_production_plan" class="po_f_production_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->production_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->production_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->production_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->description_01->Visible) { // description_01 ?>
	<?php if ($po_f->sortUrl($po_f->description_01) == "") { ?>
		<th data-name="description_01" class="<?php echo $po_f->description_01->headerCellClass() ?>"><div id="elh_po_f_description_01" class="po_f_description_01"><div class="ew-table-header-caption"><?php echo $po_f->description_01->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description_01" class="<?php echo $po_f->description_01->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->description_01) ?>',2);"><div id="elh_po_f_description_01" class="po_f_description_01">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->description_01->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_f->description_01->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->description_01->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->a_operator->Visible) { // a_operator ?>
	<?php if ($po_f->sortUrl($po_f->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $po_f->a_operator->headerCellClass() ?>"><div id="elh_po_f_a_operator" class="po_f_a_operator"><div class="ew-table-header-caption"><?php echo $po_f->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $po_f->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->a_operator) ?>',2);"><div id="elh_po_f_a_operator" class="po_f_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_f->production_site->Visible) { // production_site ?>
	<?php if ($po_f->sortUrl($po_f->production_site) == "") { ?>
		<th data-name="production_site" class="<?php echo $po_f->production_site->headerCellClass() ?>"><div id="elh_po_f_production_site" class="po_f_production_site"><div class="ew-table-header-caption"><?php echo $po_f->production_site->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_site" class="<?php echo $po_f->production_site->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_f->SortUrl($po_f->production_site) ?>',2);"><div id="elh_po_f_production_site" class="po_f_production_site">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_f->production_site->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_f->production_site->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_f->production_site->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_f_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_f->ExportAll && $po_f->isExport()) {
	$po_f_list->StopRec = $po_f_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_f_list->TotalRecs > $po_f_list->StartRec + $po_f_list->DisplayRecs - 1)
		$po_f_list->StopRec = $po_f_list->StartRec + $po_f_list->DisplayRecs - 1;
	else
		$po_f_list->StopRec = $po_f_list->TotalRecs;
}
$po_f_list->RecCnt = $po_f_list->StartRec - 1;
if ($po_f_list->Recordset && !$po_f_list->Recordset->EOF) {
	$po_f_list->Recordset->moveFirst();
	$selectLimit = $po_f_list->UseSelectLimit;
	if (!$selectLimit && $po_f_list->StartRec > 1)
		$po_f_list->Recordset->move($po_f_list->StartRec - 1);
} elseif (!$po_f->AllowAddDeleteRow && $po_f_list->StopRec == 0) {
	$po_f_list->StopRec = $po_f->GridAddRowCount;
}

// Initialize aggregate
$po_f->RowType = ROWTYPE_AGGREGATEINIT;
$po_f->resetAttributes();
$po_f_list->renderRow();
while ($po_f_list->RecCnt < $po_f_list->StopRec) {
	$po_f_list->RecCnt++;
	if ($po_f_list->RecCnt >= $po_f_list->StartRec) {
		$po_f_list->RowCnt++;

		// Set up key count
		$po_f_list->KeyCount = $po_f_list->RowIndex;

		// Init row class and style
		$po_f->resetAttributes();
		$po_f->CssClass = "";
		if ($po_f->isGridAdd()) {
		} else {
			$po_f_list->loadRowValues($po_f_list->Recordset); // Load row values
		}
		$po_f->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_f->RowAttrs = array_merge($po_f->RowAttrs, array('data-rowindex'=>$po_f_list->RowCnt, 'id'=>'r' . $po_f_list->RowCnt . '_po_f', 'data-rowtype'=>$po_f->RowType));

		// Render row
		$po_f_list->renderRow();

		// Render list options
		$po_f_list->renderListOptions();
?>
	<tr<?php echo $po_f->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_f_list->ListOptions->render("body", "left", $po_f_list->RowCnt);
?>
	<?php if ($po_f->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_f->id->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_id" class="po_f_id">
<span<?php echo $po_f->id->viewAttributes() ?>>
<?php echo $po_f->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $po_f->grp->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_grp" class="po_f_grp">
<span<?php echo $po_f->grp->viewAttributes() ?>>
<?php echo $po_f->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->po->Visible) { // po ?>
		<td data-name="po"<?php echo $po_f->po->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_po" class="po_f_po">
<span<?php echo $po_f->po->viewAttributes() ?>>
<?php echo $po_f->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $po_f->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_buyer_id" class="po_f_buyer_id">
<span<?php echo $po_f->buyer_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_f->buyer_id->getViewValue())) && $po_f->buyer_id->linkAttributes() <> "") { ?>
<a<?php echo $po_f->buyer_id->linkAttributes() ?>><?php echo $po_f->buyer_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_f->buyer_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $po_f->s_grp->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_s_grp" class="po_f_s_grp">
<span<?php echo $po_f->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($po_f->s_grp->getViewValue())) && $po_f->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $po_f->s_grp->linkAttributes() ?>><?php echo $po_f->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_f->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->product->Visible) { // product ?>
		<td data-name="product"<?php echo $po_f->product->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_product" class="po_f_product">
<span<?php echo $po_f->product->viewAttributes() ?>>
<?php if ((!EmptyString($po_f->product->getViewValue())) && $po_f->product->linkAttributes() <> "") { ?>
<a<?php echo $po_f->product->linkAttributes() ?>><?php echo $po_f->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_f->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $po_f->rid->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_rid" class="po_f_rid">
<span<?php echo $po_f->rid->viewAttributes() ?>>
<?php if ((!EmptyString($po_f->rid->getViewValue())) && $po_f->rid->linkAttributes() <> "") { ?>
<a<?php echo $po_f->rid->linkAttributes() ?>><?php echo $po_f->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_f->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $po_f->batch_no->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_batch_no" class="po_f_batch_no">
<span<?php echo $po_f->batch_no->viewAttributes() ?>>
<?php if ((!EmptyString($po_f->batch_no->getViewValue())) && $po_f->batch_no->linkAttributes() <> "") { ?>
<a<?php echo $po_f->batch_no->linkAttributes() ?>><?php echo $po_f->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_f->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $po_f->quantity->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_quantity" class="po_f_quantity">
<span<?php echo $po_f->quantity->viewAttributes() ?>>
<?php echo $po_f->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->price->Visible) { // price ?>
		<td data-name="price"<?php echo $po_f->price->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_price" class="po_f_price">
<span<?php echo $po_f->price->viewAttributes() ?>>
<?php echo $po_f->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $po_f->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_despatch_week" class="po_f_despatch_week">
<span<?php echo $po_f->despatch_week->viewAttributes() ?>>
<?php echo $po_f->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->production_plan->Visible) { // production_plan ?>
		<td data-name="production_plan"<?php echo $po_f->production_plan->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_production_plan" class="po_f_production_plan">
<span<?php echo $po_f->production_plan->viewAttributes() ?>>
<?php echo $po_f->production_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->description_01->Visible) { // description_01 ?>
		<td data-name="description_01"<?php echo $po_f->description_01->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_description_01" class="po_f_description_01">
<span<?php echo $po_f->description_01->viewAttributes() ?>>
<?php echo $po_f->description_01->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $po_f->a_operator->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_a_operator" class="po_f_a_operator">
<span<?php echo $po_f->a_operator->viewAttributes() ?>>
<?php echo $po_f->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_f->production_site->Visible) { // production_site ?>
		<td data-name="production_site"<?php echo $po_f->production_site->cellAttributes() ?>>
<span id="el<?php echo $po_f_list->RowCnt ?>_po_f_production_site" class="po_f_production_site">
<span<?php echo $po_f->production_site->viewAttributes() ?>>
<?php echo $po_f->production_site->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_f_list->ListOptions->render("body", "right", $po_f_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_f->isGridAdd())
		$po_f_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_f->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_f_list->Recordset)
	$po_f_list->Recordset->Close();
?>
<?php if (!$po_f->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_f->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_f_list->Pager)) $po_f_list->Pager = new PrevNextPager($po_f_list->StartRec, $po_f_list->DisplayRecs, $po_f_list->TotalRecs, $po_f_list->AutoHidePager) ?>
<?php if ($po_f_list->Pager->RecordCount > 0 && $po_f_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_f_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_f_list->pageUrl() ?>start=<?php echo $po_f_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_f_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_f_list->pageUrl() ?>start=<?php echo $po_f_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_f_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_f_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_f_list->pageUrl() ?>start=<?php echo $po_f_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_f_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_f_list->pageUrl() ?>start=<?php echo $po_f_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_f_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_f_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_f_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_f_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_f_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_f_list->TotalRecs > 0 && (!$po_f_list->AutoHidePageSizeSelector || $po_f_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_f">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_f_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_f_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_f_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_f_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_f_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_f->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_f_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_f_list->TotalRecs == 0 && !$po_f->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_f_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_f_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_f->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var SGrp = $("#x_s_grp").val();
		$.getJSON("apcajax.php?getDesc="+SGrp,function(data){
			console.log(data);
			$("#elh_po_f_description_01").html(data.d_01_head);
			 $("#elh_po_f_description_02").html(data.d_02_head);
			 $("#elh_po_f_description_03").html(data.d_03_head);
			 $("#elh_po_f_description_04").html(data.d_04_head);
			 $("#elh_po_f_description_05").html(data.d_05_head);
			 $("#elh_po_f_description_06").html(data.d_06_head);
			 $("#elh_po_f_description_07").html(data.d_07_head);
			 $("#elh_po_f_description_08").html(data.d_08_head);
		});
</script>
<?php if (!$po_f->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_f", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_f_list->terminate();
?>