<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_fp_add = new po_fp_add();

// Run the page
$po_fp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_fp_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpo_fpadd = currentForm = new ew.Form("fpo_fpadd", "add");

// Validate form
fpo_fpadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_fp_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->grp->caption(), $po_fp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->po->caption(), $po_fp->po->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.checkByRegEx(elm.value, /^[0-9]{4,4}$/))
				return this.onError(elm, "<?php echo JsEncode($po_fp->po->errorMessage()) ?>");
		<?php if ($po_fp_add->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->buyer_id->caption(), $po_fp->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->buyer_product_ref->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_product_ref");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->buyer_product_ref->caption(), $po_fp->buyer_product_ref->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->s_grp->caption(), $po_fp->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->s_grp->errorMessage()) ?>");
		<?php if ($po_fp_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->product->caption(), $po_fp->product->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->product->errorMessage()) ?>");
		<?php if ($po_fp_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->rid->caption(), $po_fp->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->rid->errorMessage()) ?>");
		<?php if ($po_fp_add->product_gcode->Required) { ?>
			elm = this.getElements("x" + infix + "_product_gcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->product_gcode->caption(), $po_fp->product_gcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->batch_no->Required) { ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->batch_no->caption(), $po_fp->batch_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_batch_no");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->batch_no->errorMessage()) ?>");
		<?php if ($po_fp_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->quantity->caption(), $po_fp->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->price->Required) { ?>
			elm = this.getElements("x" + infix + "_price");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->price->caption(), $po_fp->price->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->buyer_order_no->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_order_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->buyer_order_no->caption(), $po_fp->buyer_order_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->buyer_order_date->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_order_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->buyer_order_date->caption(), $po_fp->buyer_order_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer_order_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->buyer_order_date->errorMessage()) ?>");
		<?php if ($po_fp_add->buyer_instruction->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_instruction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->buyer_instruction->caption(), $po_fp->buyer_instruction->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->despatch_date->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->despatch_date->caption(), $po_fp->despatch_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->despatch_date->errorMessage()) ?>");
		<?php if ($po_fp_add->despatch_week->Required) { ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->despatch_week->caption(), $po_fp->despatch_week->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_despatch_week");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->despatch_week->errorMessage()) ?>");
		<?php if ($po_fp_add->production_plan->Required) { ?>
			elm = this.getElements("x" + infix + "_production_plan");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->production_plan->caption(), $po_fp->production_plan->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->lot_no->caption(), $po_fp->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_01_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_01_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_01_head->caption(), $po_fp->d_01_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_01->Required) { ?>
			elm = this.getElements("x" + infix + "_description_01");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_01->caption(), $po_fp->description_01->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_01");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->description_01->errorMessage()) ?>");
		<?php if ($po_fp_add->d_02_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_02_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_02_head->caption(), $po_fp->d_02_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_02->Required) { ?>
			elm = this.getElements("x" + infix + "_description_02");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_02->caption(), $po_fp->description_02->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_description_02");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->description_02->errorMessage()) ?>");
		<?php if ($po_fp_add->d_03_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_03_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_03_head->caption(), $po_fp->d_03_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_03->Required) { ?>
			elm = this.getElements("x" + infix + "_description_03");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_03->caption(), $po_fp->description_03->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_04_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_04_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_04_head->caption(), $po_fp->d_04_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_04->Required) { ?>
			elm = this.getElements("x" + infix + "_description_04");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_04->caption(), $po_fp->description_04->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_05_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_05_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_05_head->caption(), $po_fp->d_05_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_05->Required) { ?>
			elm = this.getElements("x" + infix + "_description_05");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_05->caption(), $po_fp->description_05->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_06_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_06_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_06_head->caption(), $po_fp->d_06_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_06->Required) { ?>
			elm = this.getElements("x" + infix + "_description_06");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_06->caption(), $po_fp->description_06->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_07_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_07_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_07_head->caption(), $po_fp->d_07_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_07->Required) { ?>
			elm = this.getElements("x" + infix + "_description_07");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_07->caption(), $po_fp->description_07->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_08_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_08_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_08_head->caption(), $po_fp->d_08_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_08->Required) { ?>
			elm = this.getElements("x" + infix + "_description_08");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_08->caption(), $po_fp->description_08->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_09_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_09_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_09_head->caption(), $po_fp->d_09_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_09->Required) { ?>
			elm = this.getElements("x" + infix + "_description_09");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_09->caption(), $po_fp->description_09->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_10_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_10_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_10_head->caption(), $po_fp->d_10_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_10->Required) { ?>
			elm = this.getElements("x" + infix + "_description_10");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_10->caption(), $po_fp->description_10->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_11_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_11_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_11_head->caption(), $po_fp->d_11_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_11->Required) { ?>
			elm = this.getElements("x" + infix + "_description_11");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_11->caption(), $po_fp->description_11->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->d_12_head->Required) { ?>
			elm = this.getElements("x" + infix + "_d_12_head");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->d_12_head->caption(), $po_fp->d_12_head->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->description_12->Required) { ?>
			elm = this.getElements("x" + infix + "_description_12");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->description_12->caption(), $po_fp->description_12->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->remarks->caption(), $po_fp->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->operator->caption(), $po_fp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->datetime->caption(), $po_fp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_fp_add->production_site->Required) { ?>
			elm = this.getElements("x" + infix + "_production_site");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_fp->production_site->caption(), $po_fp->production_site->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_production_site");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_fp->production_site->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_fpadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_fpadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_fpadd.multiPage = new ew.MultiPage("fpo_fpadd");

// Dynamic selection lists
fpo_fpadd.lists["x_grp"] = <?php echo $po_fp_add->grp->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_grp"].options = <?php echo JsonEncode($po_fp_add->grp->options(FALSE, TRUE)) ?>;
fpo_fpadd.lists["x_buyer_id"] = <?php echo $po_fp_add->buyer_id->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_buyer_id"].options = <?php echo JsonEncode($po_fp_add->buyer_id->lookupOptions()) ?>;
fpo_fpadd.lists["x_buyer_product_ref"] = <?php echo $po_fp_add->buyer_product_ref->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_buyer_product_ref"].options = <?php echo JsonEncode($po_fp_add->buyer_product_ref->lookupOptions()) ?>;
fpo_fpadd.lists["x_s_grp"] = <?php echo $po_fp_add->s_grp->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_s_grp"].options = <?php echo JsonEncode($po_fp_add->s_grp->lookupOptions()) ?>;
fpo_fpadd.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpadd.lists["x_product"] = <?php echo $po_fp_add->product->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_product"].options = <?php echo JsonEncode($po_fp_add->product->lookupOptions()) ?>;
fpo_fpadd.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpadd.lists["x_rid"] = <?php echo $po_fp_add->rid->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_rid"].options = <?php echo JsonEncode($po_fp_add->rid->lookupOptions()) ?>;
fpo_fpadd.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpadd.lists["x_product_gcode"] = <?php echo $po_fp_add->product_gcode->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_product_gcode"].options = <?php echo JsonEncode($po_fp_add->product_gcode->lookupOptions()) ?>;
fpo_fpadd.lists["x_production_plan"] = <?php echo $po_fp_add->production_plan->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_production_plan"].options = <?php echo JsonEncode($po_fp_add->production_plan->options(FALSE, TRUE)) ?>;
fpo_fpadd.lists["x_d_01_head"] = <?php echo $po_fp_add->d_01_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_01_head"].options = <?php echo JsonEncode($po_fp_add->d_01_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_02_head"] = <?php echo $po_fp_add->d_02_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_02_head"].options = <?php echo JsonEncode($po_fp_add->d_02_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_03_head"] = <?php echo $po_fp_add->d_03_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_03_head"].options = <?php echo JsonEncode($po_fp_add->d_03_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_description_03"] = <?php echo $po_fp_add->description_03->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_description_03"].options = <?php echo JsonEncode($po_fp_add->description_03->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_04_head"] = <?php echo $po_fp_add->d_04_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_04_head"].options = <?php echo JsonEncode($po_fp_add->d_04_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_description_04"] = <?php echo $po_fp_add->description_04->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_description_04"].options = <?php echo JsonEncode($po_fp_add->description_04->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_05_head"] = <?php echo $po_fp_add->d_05_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_05_head"].options = <?php echo JsonEncode($po_fp_add->d_05_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_description_05"] = <?php echo $po_fp_add->description_05->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_description_05"].options = <?php echo JsonEncode($po_fp_add->description_05->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_06_head"] = <?php echo $po_fp_add->d_06_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_06_head"].options = <?php echo JsonEncode($po_fp_add->d_06_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_description_06"] = <?php echo $po_fp_add->description_06->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_description_06"].options = <?php echo JsonEncode($po_fp_add->description_06->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_07_head"] = <?php echo $po_fp_add->d_07_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_07_head"].options = <?php echo JsonEncode($po_fp_add->d_07_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_08_head"] = <?php echo $po_fp_add->d_08_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_08_head"].options = <?php echo JsonEncode($po_fp_add->d_08_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_09_head"] = <?php echo $po_fp_add->d_09_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_09_head"].options = <?php echo JsonEncode($po_fp_add->d_09_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_10_head"] = <?php echo $po_fp_add->d_10_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_10_head"].options = <?php echo JsonEncode($po_fp_add->d_10_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_11_head"] = <?php echo $po_fp_add->d_11_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_11_head"].options = <?php echo JsonEncode($po_fp_add->d_11_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_d_12_head"] = <?php echo $po_fp_add->d_12_head->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_d_12_head"].options = <?php echo JsonEncode($po_fp_add->d_12_head->lookupOptions()) ?>;
fpo_fpadd.lists["x_operator"] = <?php echo $po_fp_add->operator->Lookup->toClientList() ?>;
fpo_fpadd.lists["x_operator"].options = <?php echo JsonEncode($po_fp_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_fp_add->showPageHeader(); ?>
<?php
$po_fp_add->showMessage();
?>
<form name="fpo_fpadd" id="fpo_fpadd" class="<?php echo $po_fp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_fp_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_fp_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_fp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$po_fp_add->IsModal ?>">
<?php if ($po_fp_add->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($po_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_po_fp_grp" for="x_grp" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->grp->caption() ?><?php echo ($po_fp->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->grp->cellAttributes() ?>>
<span id="el_po_fp_grp">
<?php $po_fp->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_fp->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_grp" data-page="0" data-value-separator="<?php echo $po_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_fp->grp->editAttributes() ?>>
		<?php echo $po_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $po_fp->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_po_fp_po" for="x_po" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->po->caption() ?><?php echo ($po_fp->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->po->cellAttributes() ?>>
<span id="el_po_fp_po">
<input type="text" data-table="po_fp" data-field="x_po" data-page="0" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($po_fp->po->getPlaceHolder()) ?>" value="<?php echo $po_fp->po->EditValue ?>"<?php echo $po_fp->po->editAttributes() ?>>
</span>
<?php echo $po_fp->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_po_fp_buyer_id" for="x_buyer_id" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->buyer_id->caption() ?><?php echo ($po_fp->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->buyer_id->cellAttributes() ?>>
<span id="el_po_fp_buyer_id">
<?php $po_fp->buyer_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_fp->buyer_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_buyer_id" data-page="0" data-value-separator="<?php echo $po_fp->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po_fp->buyer_id->editAttributes() ?>>
		<?php echo $po_fp->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$po_fp->buyer_id->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer_id" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->buyer_id->caption() ?>" data-title="<?php echo $po_fp->buyer_id->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_buyer_id',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
<?php echo $po_fp->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_product_ref->Visible) { // buyer_product_ref ?>
	<div id="r_buyer_product_ref" class="form-group row">
		<label id="elh_po_fp_buyer_product_ref" for="x_buyer_product_ref" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->buyer_product_ref->caption() ?><?php echo ($po_fp->buyer_product_ref->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->buyer_product_ref->cellAttributes() ?>>
<span id="el_po_fp_buyer_product_ref">
<?php $po_fp->buyer_product_ref->EditAttrs["onchange"] = "ew.autoFill(this);" . @$po_fp->buyer_product_ref->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_buyer_product_ref" data-page="0" data-value-separator="<?php echo $po_fp->buyer_product_ref->displayValueSeparatorAttribute() ?>" id="x_buyer_product_ref" name="x_buyer_product_ref"<?php echo $po_fp->buyer_product_ref->editAttributes() ?>>
		<?php echo $po_fp->buyer_product_ref->selectOptionListHtml("x_buyer_product_ref") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "partner_product_ref") && !$po_fp->buyer_product_ref->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer_product_ref" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->buyer_product_ref->caption() ?>" data-title="<?php echo $po_fp->buyer_product_ref->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_buyer_product_ref',url:'partner_product_refaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->buyer_product_ref->Lookup->getParamTag("p_x_buyer_product_ref") ?>
</span>
<?php echo $po_fp->buyer_product_ref->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_po_fp_s_grp" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->s_grp->caption() ?><?php echo ($po_fp->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->s_grp->cellAttributes() ?>>
<span id="el_po_fp_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$po_fp->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_fp->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_s_grp" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_s_grp" id="sv_x_s_grp" value="<?php echo RemoveHtml($po_fp->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_fp->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_fp->s_grp->getPlaceHolder()) ?>"<?php echo $po_fp->s_grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_fp->s_grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_s_grp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($po_fp->s_grp->ReadOnly || $po_fp->s_grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_fp" data-field="x_s_grp" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_fp->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($po_fp->s_grp->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fpadd.createAutoSuggest({"id":"x_s_grp","forceSelect":true});
</script>
<?php echo $po_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $po_fp->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_po_fp_product" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->product->caption() ?><?php echo ($po_fp->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->product->cellAttributes() ?>>
<span id="el_po_fp_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$po_fp->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_fp->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($po_fp->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_fp->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_fp->product->getPlaceHolder()) ?>"<?php echo $po_fp->product->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_fp->product->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_product',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($po_fp->product->ReadOnly || $po_fp->product->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_fp" data-field="x_product" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_fp->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($po_fp->product->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fpadd.createAutoSuggest({"id":"x_product","forceSelect":true});
</script>
<?php echo $po_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $po_fp->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_po_fp_rid" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->rid->caption() ?><?php echo ($po_fp->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->rid->cellAttributes() ?>>
<span id="el_po_fp_rid">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$po_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($po_fp->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_fp->rid->getPlaceHolder()) ?>"<?php echo $po_fp->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_fp->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($po_fp->rid->ReadOnly || $po_fp->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_fp" data-field="x_rid" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_fp->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($po_fp->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fpadd.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $po_fp->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $po_fp->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->product_gcode->Visible) { // product_gcode ?>
	<div id="r_product_gcode" class="form-group row">
		<label id="elh_po_fp_product_gcode" for="x_product_gcode" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->product_gcode->caption() ?><?php echo ($po_fp->product_gcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->product_gcode->cellAttributes() ?>>
<span id="el_po_fp_product_gcode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_product_gcode" data-page="0" data-value-separator="<?php echo $po_fp->product_gcode->displayValueSeparatorAttribute() ?>" id="x_product_gcode" name="x_product_gcode"<?php echo $po_fp->product_gcode->editAttributes() ?>>
		<?php echo $po_fp->product_gcode->selectOptionListHtml("x_product_gcode") ?>
	</select>
</div>
<?php echo $po_fp->product_gcode->Lookup->getParamTag("p_x_product_gcode") ?>
</span>
<?php echo $po_fp->product_gcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label id="elh_po_fp_batch_no" for="x_batch_no" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->batch_no->caption() ?><?php echo ($po_fp->batch_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->batch_no->cellAttributes() ?>>
<span id="el_po_fp_batch_no">
<input type="text" data-table="po_fp" data-field="x_batch_no" data-page="0" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($po_fp->batch_no->getPlaceHolder()) ?>" value="<?php echo $po_fp->batch_no->EditValue ?>"<?php echo $po_fp->batch_no->editAttributes() ?>>
</span>
<?php echo $po_fp->batch_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav-tabs" id="po_fp_add"><!-- multi-page tabs -->
	<ul class="<?php echo $po_fp_add->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_add->MultiPages->pageStyle("1") ?>" href="#tab_po_fp1" data-toggle="tab"><?php echo $po_fp->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_add->MultiPages->pageStyle("2") ?>" href="#tab_po_fp2" data-toggle="tab"><?php echo $po_fp->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_add->MultiPages->pageStyle("3") ?>" href="#tab_po_fp3" data-toggle="tab"><?php echo $po_fp->pageCaption(3) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_add->MultiPages->pageStyle("4") ?>" href="#tab_po_fp4" data-toggle="tab"><?php echo $po_fp->pageCaption(4) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_add->MultiPages->pageStyle("5") ?>" href="#tab_po_fp5" data-toggle="tab"><?php echo $po_fp->pageCaption(5) ?></a></li>
	</ul>
	<div class="tab-content"><!-- multi-page tabs .tab-content -->
		<div class="tab-pane<?php echo $po_fp_add->MultiPages->pageStyle("1") ?>" id="tab_po_fp1"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po_fp->buyer_order_no->Visible) { // buyer_order_no ?>
	<div id="r_buyer_order_no" class="form-group row">
		<label id="elh_po_fp_buyer_order_no" for="x_buyer_order_no" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->buyer_order_no->caption() ?><?php echo ($po_fp->buyer_order_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->buyer_order_no->cellAttributes() ?>>
<span id="el_po_fp_buyer_order_no">
<input type="text" data-table="po_fp" data-field="x_buyer_order_no" data-page="1" name="x_buyer_order_no" id="x_buyer_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->buyer_order_no->getPlaceHolder()) ?>" value="<?php echo $po_fp->buyer_order_no->EditValue ?>"<?php echo $po_fp->buyer_order_no->editAttributes() ?>>
</span>
<?php echo $po_fp->buyer_order_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_order_date->Visible) { // buyer_order_date ?>
	<div id="r_buyer_order_date" class="form-group row">
		<label id="elh_po_fp_buyer_order_date" for="x_buyer_order_date" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->buyer_order_date->caption() ?><?php echo ($po_fp->buyer_order_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->buyer_order_date->cellAttributes() ?>>
<span id="el_po_fp_buyer_order_date">
<input type="text" data-table="po_fp" data-field="x_buyer_order_date" data-page="1" name="x_buyer_order_date" id="x_buyer_order_date" placeholder="<?php echo HtmlEncode($po_fp->buyer_order_date->getPlaceHolder()) ?>" value="<?php echo $po_fp->buyer_order_date->EditValue ?>"<?php echo $po_fp->buyer_order_date->editAttributes() ?>>
<?php if (!$po_fp->buyer_order_date->ReadOnly && !$po_fp->buyer_order_date->Disabled && !isset($po_fp->buyer_order_date->EditAttrs["readonly"]) && !isset($po_fp->buyer_order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fpadd", "x_buyer_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_fp->buyer_order_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label id="elh_po_fp_buyer_instruction" for="x_buyer_instruction" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->buyer_instruction->caption() ?><?php echo ($po_fp->buyer_instruction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->buyer_instruction->cellAttributes() ?>>
<span id="el_po_fp_buyer_instruction">
<textarea data-table="po_fp" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po_fp->buyer_instruction->getPlaceHolder()) ?>"<?php echo $po_fp->buyer_instruction->editAttributes() ?>><?php echo $po_fp->buyer_instruction->EditValue ?></textarea>
</span>
<?php echo $po_fp->buyer_instruction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_po_fp_remarks" for="x_remarks" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->remarks->caption() ?><?php echo ($po_fp->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->remarks->cellAttributes() ?>>
<span id="el_po_fp_remarks">
<textarea data-table="po_fp" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($po_fp->remarks->getPlaceHolder()) ?>"<?php echo $po_fp->remarks->editAttributes() ?>><?php echo $po_fp->remarks->EditValue ?></textarea>
</span>
<?php echo $po_fp->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->production_site->Visible) { // production_site ?>
	<div id="r_production_site" class="form-group row">
		<label id="elh_po_fp_production_site" for="x_production_site" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->production_site->caption() ?><?php echo ($po_fp->production_site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->production_site->cellAttributes() ?>>
<span id="el_po_fp_production_site">
<input type="text" data-table="po_fp" data-field="x_production_site" data-page="1" name="x_production_site" id="x_production_site" size="30" placeholder="<?php echo HtmlEncode($po_fp->production_site->getPlaceHolder()) ?>" value="<?php echo $po_fp->production_site->EditValue ?>"<?php echo $po_fp->production_site->editAttributes() ?>>
</span>
<?php echo $po_fp->production_site->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_add->MultiPages->pageStyle("2") ?>" id="tab_po_fp2"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_po_fp_quantity" for="x_quantity" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->quantity->caption() ?><?php echo ($po_fp->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->quantity->cellAttributes() ?>>
<span id="el_po_fp_quantity">
<input type="text" data-table="po_fp" data-field="x_quantity" data-page="2" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $po_fp->quantity->EditValue ?>"<?php echo $po_fp->quantity->editAttributes() ?>>
</span>
<?php echo $po_fp->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label id="elh_po_fp_price" for="x_price" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->price->caption() ?><?php echo ($po_fp->price->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->price->cellAttributes() ?>>
<span id="el_po_fp_price">
<input type="text" data-table="po_fp" data-field="x_price" data-page="2" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($po_fp->price->getPlaceHolder()) ?>" value="<?php echo $po_fp->price->EditValue ?>"<?php echo $po_fp->price->editAttributes() ?>>
</span>
<?php echo $po_fp->price->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label id="elh_po_fp_despatch_date" for="x_despatch_date" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->despatch_date->caption() ?><?php echo ($po_fp->despatch_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->despatch_date->cellAttributes() ?>>
<span id="el_po_fp_despatch_date">
<input type="text" data-table="po_fp" data-field="x_despatch_date" data-page="2" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($po_fp->despatch_date->getPlaceHolder()) ?>" value="<?php echo $po_fp->despatch_date->EditValue ?>"<?php echo $po_fp->despatch_date->editAttributes() ?>>
<?php if (!$po_fp->despatch_date->ReadOnly && !$po_fp->despatch_date->Disabled && !isset($po_fp->despatch_date->EditAttrs["readonly"]) && !isset($po_fp->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fpadd", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_fp->despatch_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label id="elh_po_fp_despatch_week" for="x_despatch_week" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->despatch_week->caption() ?><?php echo ($po_fp->despatch_week->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->despatch_week->cellAttributes() ?>>
<span id="el_po_fp_despatch_week">
<input type="text" data-table="po_fp" data-field="x_despatch_week" data-page="2" name="x_despatch_week" id="x_despatch_week" placeholder="<?php echo HtmlEncode($po_fp->despatch_week->getPlaceHolder()) ?>" value="<?php echo $po_fp->despatch_week->EditValue ?>"<?php echo $po_fp->despatch_week->editAttributes() ?>>
<?php if (!$po_fp->despatch_week->ReadOnly && !$po_fp->despatch_week->Disabled && !isset($po_fp->despatch_week->EditAttrs["readonly"]) && !isset($po_fp->despatch_week->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fpadd", "x_despatch_week", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $po_fp->despatch_week->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label id="elh_po_fp_production_plan" for="x_production_plan" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->production_plan->caption() ?><?php echo ($po_fp->production_plan->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->production_plan->cellAttributes() ?>>
<span id="el_po_fp_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_production_plan" data-page="2" data-value-separator="<?php echo $po_fp->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $po_fp->production_plan->editAttributes() ?>>
		<?php echo $po_fp->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
<?php echo $po_fp->production_plan->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_po_fp_lot_no" for="x_lot_no" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->lot_no->caption() ?><?php echo ($po_fp->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->lot_no->cellAttributes() ?>>
<span id="el_po_fp_lot_no">
<input type="text" data-table="po_fp" data-field="x_lot_no" data-page="2" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($po_fp->lot_no->getPlaceHolder()) ?>" value="<?php echo $po_fp->lot_no->EditValue ?>"<?php echo $po_fp->lot_no->editAttributes() ?>>
</span>
<?php echo $po_fp->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_add->MultiPages->pageStyle("3") ?>" id="tab_po_fp3"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po_fp->d_01_head->Visible) { // d_01_head ?>
	<div id="r_d_01_head" class="form-group row">
		<label id="elh_po_fp_d_01_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_01_head->caption() ?><?php echo ($po_fp->d_01_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_01_head->cellAttributes() ?>>
<span id="el_po_fp_d_01_head">
<div id="tp_x_d_01_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_01_head" data-page="3" data-value-separator="<?php echo $po_fp->d_01_head->displayValueSeparatorAttribute() ?>" name="x_d_01_head" id="x_d_01_head" value="{value}"<?php echo $po_fp->d_01_head->editAttributes() ?>></div>
<div id="dsl_x_d_01_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_01_head->radioButtonListHtml(FALSE, "x_d_01_head", 3) ?>
</div></div>
<?php echo $po_fp->d_01_head->Lookup->getParamTag("p_x_d_01_head") ?>
</span>
<?php echo $po_fp->d_01_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label id="elh_po_fp_description_01" for="x_description_01" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_01->caption() ?><?php echo ($po_fp->description_01->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_01->cellAttributes() ?>>
<span id="el_po_fp_description_01">
<input type="text" data-table="po_fp" data-field="x_description_01" data-page="3" name="x_description_01" id="x_description_01" size="30" placeholder="<?php echo HtmlEncode($po_fp->description_01->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_01->EditValue ?>"<?php echo $po_fp->description_01->editAttributes() ?>>
</span>
<?php echo $po_fp->description_01->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_02_head->Visible) { // d_02_head ?>
	<div id="r_d_02_head" class="form-group row">
		<label id="elh_po_fp_d_02_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_02_head->caption() ?><?php echo ($po_fp->d_02_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_02_head->cellAttributes() ?>>
<span id="el_po_fp_d_02_head">
<div id="tp_x_d_02_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_02_head" data-page="3" data-value-separator="<?php echo $po_fp->d_02_head->displayValueSeparatorAttribute() ?>" name="x_d_02_head" id="x_d_02_head" value="{value}"<?php echo $po_fp->d_02_head->editAttributes() ?>></div>
<div id="dsl_x_d_02_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_02_head->radioButtonListHtml(FALSE, "x_d_02_head", 3) ?>
</div></div>
<?php echo $po_fp->d_02_head->Lookup->getParamTag("p_x_d_02_head") ?>
</span>
<?php echo $po_fp->d_02_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label id="elh_po_fp_description_02" for="x_description_02" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_02->caption() ?><?php echo ($po_fp->description_02->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_02->cellAttributes() ?>>
<span id="el_po_fp_description_02">
<input type="text" data-table="po_fp" data-field="x_description_02" data-page="3" name="x_description_02" id="x_description_02" size="30" placeholder="<?php echo HtmlEncode($po_fp->description_02->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_02->EditValue ?>"<?php echo $po_fp->description_02->editAttributes() ?>>
</span>
<?php echo $po_fp->description_02->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_03_head->Visible) { // d_03_head ?>
	<div id="r_d_03_head" class="form-group row">
		<label id="elh_po_fp_d_03_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_03_head->caption() ?><?php echo ($po_fp->d_03_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_03_head->cellAttributes() ?>>
<span id="el_po_fp_d_03_head">
<div id="tp_x_d_03_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_03_head" data-page="3" data-value-separator="<?php echo $po_fp->d_03_head->displayValueSeparatorAttribute() ?>" name="x_d_03_head" id="x_d_03_head" value="{value}"<?php echo $po_fp->d_03_head->editAttributes() ?>></div>
<div id="dsl_x_d_03_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_03_head->radioButtonListHtml(FALSE, "x_d_03_head", 3) ?>
</div></div>
<?php echo $po_fp->d_03_head->Lookup->getParamTag("p_x_d_03_head") ?>
</span>
<?php echo $po_fp->d_03_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label id="elh_po_fp_description_03" for="x_description_03" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_03->caption() ?><?php echo ($po_fp->description_03->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_03->cellAttributes() ?>>
<span id="el_po_fp_description_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_description_03" data-page="3" data-value-separator="<?php echo $po_fp->description_03->displayValueSeparatorAttribute() ?>" id="x_description_03" name="x_description_03"<?php echo $po_fp->description_03->editAttributes() ?>>
		<?php echo $po_fp->description_03->selectOptionListHtml("x_description_03") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_03") && !$po_fp->description_03->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_03" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->description_03->caption() ?>" data-title="<?php echo $po_fp->description_03->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_03',url:'d_03addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->description_03->Lookup->getParamTag("p_x_description_03") ?>
</span>
<?php echo $po_fp->description_03->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_04_head->Visible) { // d_04_head ?>
	<div id="r_d_04_head" class="form-group row">
		<label id="elh_po_fp_d_04_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_04_head->caption() ?><?php echo ($po_fp->d_04_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_04_head->cellAttributes() ?>>
<span id="el_po_fp_d_04_head">
<div id="tp_x_d_04_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_04_head" data-page="3" data-value-separator="<?php echo $po_fp->d_04_head->displayValueSeparatorAttribute() ?>" name="x_d_04_head" id="x_d_04_head" value="{value}"<?php echo $po_fp->d_04_head->editAttributes() ?>></div>
<div id="dsl_x_d_04_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_04_head->radioButtonListHtml(FALSE, "x_d_04_head", 3) ?>
</div></div>
<?php echo $po_fp->d_04_head->Lookup->getParamTag("p_x_d_04_head") ?>
</span>
<?php echo $po_fp->d_04_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label id="elh_po_fp_description_04" for="x_description_04" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_04->caption() ?><?php echo ($po_fp->description_04->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_04->cellAttributes() ?>>
<span id="el_po_fp_description_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_description_04" data-page="3" data-value-separator="<?php echo $po_fp->description_04->displayValueSeparatorAttribute() ?>" id="x_description_04" name="x_description_04"<?php echo $po_fp->description_04->editAttributes() ?>>
		<?php echo $po_fp->description_04->selectOptionListHtml("x_description_04") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_04") && !$po_fp->description_04->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_04" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->description_04->caption() ?>" data-title="<?php echo $po_fp->description_04->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_04',url:'d_04addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->description_04->Lookup->getParamTag("p_x_description_04") ?>
</span>
<?php echo $po_fp->description_04->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_add->MultiPages->pageStyle("4") ?>" id="tab_po_fp4"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po_fp->d_05_head->Visible) { // d_05_head ?>
	<div id="r_d_05_head" class="form-group row">
		<label id="elh_po_fp_d_05_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_05_head->caption() ?><?php echo ($po_fp->d_05_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_05_head->cellAttributes() ?>>
<span id="el_po_fp_d_05_head">
<div id="tp_x_d_05_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_05_head" data-page="4" data-value-separator="<?php echo $po_fp->d_05_head->displayValueSeparatorAttribute() ?>" name="x_d_05_head" id="x_d_05_head" value="{value}"<?php echo $po_fp->d_05_head->editAttributes() ?>></div>
<div id="dsl_x_d_05_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_05_head->radioButtonListHtml(FALSE, "x_d_05_head", 4) ?>
</div></div>
<?php echo $po_fp->d_05_head->Lookup->getParamTag("p_x_d_05_head") ?>
</span>
<?php echo $po_fp->d_05_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label id="elh_po_fp_description_05" for="x_description_05" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_05->caption() ?><?php echo ($po_fp->description_05->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_05->cellAttributes() ?>>
<span id="el_po_fp_description_05">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_description_05" data-page="4" data-value-separator="<?php echo $po_fp->description_05->displayValueSeparatorAttribute() ?>" id="x_description_05" name="x_description_05"<?php echo $po_fp->description_05->editAttributes() ?>>
		<?php echo $po_fp->description_05->selectOptionListHtml("x_description_05") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_05") && !$po_fp->description_05->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_05" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->description_05->caption() ?>" data-title="<?php echo $po_fp->description_05->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_05',url:'d_05addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
<?php echo $po_fp->description_05->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_06_head->Visible) { // d_06_head ?>
	<div id="r_d_06_head" class="form-group row">
		<label id="elh_po_fp_d_06_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_06_head->caption() ?><?php echo ($po_fp->d_06_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_06_head->cellAttributes() ?>>
<span id="el_po_fp_d_06_head">
<div id="tp_x_d_06_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_06_head" data-page="4" data-value-separator="<?php echo $po_fp->d_06_head->displayValueSeparatorAttribute() ?>" name="x_d_06_head" id="x_d_06_head" value="{value}"<?php echo $po_fp->d_06_head->editAttributes() ?>></div>
<div id="dsl_x_d_06_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_06_head->radioButtonListHtml(FALSE, "x_d_06_head", 4) ?>
</div></div>
<?php echo $po_fp->d_06_head->Lookup->getParamTag("p_x_d_06_head") ?>
</span>
<?php echo $po_fp->d_06_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label id="elh_po_fp_description_06" for="x_description_06" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_06->caption() ?><?php echo ($po_fp->description_06->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_06->cellAttributes() ?>>
<span id="el_po_fp_description_06">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_description_06" data-page="4" data-value-separator="<?php echo $po_fp->description_06->displayValueSeparatorAttribute() ?>" id="x_description_06" name="x_description_06"<?php echo $po_fp->description_06->editAttributes() ?>>
		<?php echo $po_fp->description_06->selectOptionListHtml("x_description_06") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "d_06") && !$po_fp->description_06->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_description_06" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->description_06->caption() ?>" data-title="<?php echo $po_fp->description_06->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_description_06',url:'d_06addopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
<?php echo $po_fp->description_06->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_07_head->Visible) { // d_07_head ?>
	<div id="r_d_07_head" class="form-group row">
		<label id="elh_po_fp_d_07_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_07_head->caption() ?><?php echo ($po_fp->d_07_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_07_head->cellAttributes() ?>>
<span id="el_po_fp_d_07_head">
<div id="tp_x_d_07_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_07_head" data-page="4" data-value-separator="<?php echo $po_fp->d_07_head->displayValueSeparatorAttribute() ?>" name="x_d_07_head" id="x_d_07_head" value="{value}"<?php echo $po_fp->d_07_head->editAttributes() ?>></div>
<div id="dsl_x_d_07_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_07_head->radioButtonListHtml(FALSE, "x_d_07_head", 4) ?>
</div></div>
<?php echo $po_fp->d_07_head->Lookup->getParamTag("p_x_d_07_head") ?>
</span>
<?php echo $po_fp->d_07_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label id="elh_po_fp_description_07" for="x_description_07" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_07->caption() ?><?php echo ($po_fp->description_07->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_07->cellAttributes() ?>>
<span id="el_po_fp_description_07">
<input type="text" data-table="po_fp" data-field="x_description_07" data-page="4" name="x_description_07" id="x_description_07" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_fp->description_07->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_07->EditValue ?>"<?php echo $po_fp->description_07->editAttributes() ?>>
</span>
<?php echo $po_fp->description_07->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_08_head->Visible) { // d_08_head ?>
	<div id="r_d_08_head" class="form-group row">
		<label id="elh_po_fp_d_08_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_08_head->caption() ?><?php echo ($po_fp->d_08_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_08_head->cellAttributes() ?>>
<span id="el_po_fp_d_08_head">
<div id="tp_x_d_08_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_08_head" data-page="4" data-value-separator="<?php echo $po_fp->d_08_head->displayValueSeparatorAttribute() ?>" name="x_d_08_head" id="x_d_08_head" value="{value}"<?php echo $po_fp->d_08_head->editAttributes() ?>></div>
<div id="dsl_x_d_08_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_08_head->radioButtonListHtml(FALSE, "x_d_08_head", 4) ?>
</div></div>
<?php echo $po_fp->d_08_head->Lookup->getParamTag("p_x_d_08_head") ?>
</span>
<?php echo $po_fp->d_08_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label id="elh_po_fp_description_08" for="x_description_08" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_08->caption() ?><?php echo ($po_fp->description_08->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_08->cellAttributes() ?>>
<span id="el_po_fp_description_08">
<input type="text" data-table="po_fp" data-field="x_description_08" data-page="4" name="x_description_08" id="x_description_08" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_fp->description_08->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_08->EditValue ?>"<?php echo $po_fp->description_08->editAttributes() ?>>
</span>
<?php echo $po_fp->description_08->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_add->MultiPages->pageStyle("5") ?>" id="tab_po_fp5"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($po_fp->d_09_head->Visible) { // d_09_head ?>
	<div id="r_d_09_head" class="form-group row">
		<label id="elh_po_fp_d_09_head" for="x_d_09_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_09_head->caption() ?><?php echo ($po_fp->d_09_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_09_head->cellAttributes() ?>>
<span id="el_po_fp_d_09_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_d_09_head" data-page="5" data-value-separator="<?php echo $po_fp->d_09_head->displayValueSeparatorAttribute() ?>" id="x_d_09_head" name="x_d_09_head"<?php echo $po_fp->d_09_head->editAttributes() ?>>
		<?php echo $po_fp->d_09_head->selectOptionListHtml("x_d_09_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_fp->d_09_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_09_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->d_09_head->caption() ?>" data-title="<?php echo $po_fp->d_09_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_09_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->d_09_head->Lookup->getParamTag("p_x_d_09_head") ?>
</span>
<?php echo $po_fp->d_09_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label id="elh_po_fp_description_09" for="x_description_09" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_09->caption() ?><?php echo ($po_fp->description_09->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_09->cellAttributes() ?>>
<span id="el_po_fp_description_09">
<input type="text" data-table="po_fp" data-field="x_description_09" data-page="5" name="x_description_09" id="x_description_09" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->description_09->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_09->EditValue ?>"<?php echo $po_fp->description_09->editAttributes() ?>>
</span>
<?php echo $po_fp->description_09->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_10_head->Visible) { // d_10_head ?>
	<div id="r_d_10_head" class="form-group row">
		<label id="elh_po_fp_d_10_head" for="x_d_10_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_10_head->caption() ?><?php echo ($po_fp->d_10_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_10_head->cellAttributes() ?>>
<span id="el_po_fp_d_10_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_d_10_head" data-page="5" data-value-separator="<?php echo $po_fp->d_10_head->displayValueSeparatorAttribute() ?>" id="x_d_10_head" name="x_d_10_head"<?php echo $po_fp->d_10_head->editAttributes() ?>>
		<?php echo $po_fp->d_10_head->selectOptionListHtml("x_d_10_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_fp->d_10_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_10_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->d_10_head->caption() ?>" data-title="<?php echo $po_fp->d_10_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_10_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->d_10_head->Lookup->getParamTag("p_x_d_10_head") ?>
</span>
<?php echo $po_fp->d_10_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label id="elh_po_fp_description_10" for="x_description_10" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_10->caption() ?><?php echo ($po_fp->description_10->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_10->cellAttributes() ?>>
<span id="el_po_fp_description_10">
<input type="text" data-table="po_fp" data-field="x_description_10" data-page="5" name="x_description_10" id="x_description_10" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->description_10->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_10->EditValue ?>"<?php echo $po_fp->description_10->editAttributes() ?>>
</span>
<?php echo $po_fp->description_10->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_11_head->Visible) { // d_11_head ?>
	<div id="r_d_11_head" class="form-group row">
		<label id="elh_po_fp_d_11_head" for="x_d_11_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_11_head->caption() ?><?php echo ($po_fp->d_11_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_11_head->cellAttributes() ?>>
<span id="el_po_fp_d_11_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_d_11_head" data-page="5" data-value-separator="<?php echo $po_fp->d_11_head->displayValueSeparatorAttribute() ?>" id="x_d_11_head" name="x_d_11_head"<?php echo $po_fp->d_11_head->editAttributes() ?>>
		<?php echo $po_fp->d_11_head->selectOptionListHtml("x_d_11_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_fp->d_11_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_11_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->d_11_head->caption() ?>" data-title="<?php echo $po_fp->d_11_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_11_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->d_11_head->Lookup->getParamTag("p_x_d_11_head") ?>
</span>
<?php echo $po_fp->d_11_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label id="elh_po_fp_description_11" for="x_description_11" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_11->caption() ?><?php echo ($po_fp->description_11->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_11->cellAttributes() ?>>
<span id="el_po_fp_description_11">
<input type="text" data-table="po_fp" data-field="x_description_11" data-page="5" name="x_description_11" id="x_description_11" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->description_11->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_11->EditValue ?>"<?php echo $po_fp->description_11->editAttributes() ?>>
</span>
<?php echo $po_fp->description_11->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_12_head->Visible) { // d_12_head ?>
	<div id="r_d_12_head" class="form-group row">
		<label id="elh_po_fp_d_12_head" for="x_d_12_head" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->d_12_head->caption() ?><?php echo ($po_fp->d_12_head->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->d_12_head->cellAttributes() ?>>
<span id="el_po_fp_d_12_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_d_12_head" data-page="5" data-value-separator="<?php echo $po_fp->d_12_head->displayValueSeparatorAttribute() ?>" id="x_d_12_head" name="x_d_12_head"<?php echo $po_fp->d_12_head->editAttributes() ?>>
		<?php echo $po_fp->d_12_head->selectOptionListHtml("x_d_12_head") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "po_desc") && !$po_fp->d_12_head->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_d_12_head" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $po_fp->d_12_head->caption() ?>" data-title="<?php echo $po_fp->d_12_head->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_d_12_head',url:'po_descaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $po_fp->d_12_head->Lookup->getParamTag("p_x_d_12_head") ?>
</span>
<?php echo $po_fp->d_12_head->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_12->Visible) { // description_12 ?>
	<div id="r_description_12" class="form-group row">
		<label id="elh_po_fp_description_12" for="x_description_12" class="<?php echo $po_fp_add->LeftColumnClass ?>"><?php echo $po_fp->description_12->caption() ?><?php echo ($po_fp->description_12->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_fp_add->RightColumnClass ?>"><div<?php echo $po_fp->description_12->cellAttributes() ?>>
<span id="el_po_fp_description_12">
<input type="text" data-table="po_fp" data-field="x_description_12" data-page="5" name="x_description_12" id="x_description_12" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->description_12->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_12->EditValue ?>"<?php echo $po_fp->description_12->editAttributes() ?>>
</span>
<?php echo $po_fp->description_12->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
	</div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?php if (!$po_fp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_fp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_fp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_fp_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$.getJSON('apcajax.php?POFPLN=POFPLN',function(data){
$('#r_po').append('<span id="error1">'+'<BR> Last PO : '+data+ '</span>');
});
</script>
<?php include_once "footer.php" ?>
<?php
$po_fp_add->terminate();
?>