<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_fp_list = new po_fp_list();

// Run the page
$po_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_fplist = currentForm = new ew.Form("fpo_fplist", "list");
fpo_fplist.formKeyCountName = '<?php echo $po_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_fplist.lists["x_buyer_id"] = <?php echo $po_fp_list->buyer_id->Lookup->toClientList() ?>;
fpo_fplist.lists["x_buyer_id"].options = <?php echo JsonEncode($po_fp_list->buyer_id->lookupOptions()) ?>;
fpo_fplist.lists["x_buyer_product_ref"] = <?php echo $po_fp_list->buyer_product_ref->Lookup->toClientList() ?>;
fpo_fplist.lists["x_buyer_product_ref"].options = <?php echo JsonEncode($po_fp_list->buyer_product_ref->lookupOptions()) ?>;
fpo_fplist.lists["x_rid"] = <?php echo $po_fp_list->rid->Lookup->toClientList() ?>;
fpo_fplist.lists["x_rid"].options = <?php echo JsonEncode($po_fp_list->rid->lookupOptions()) ?>;
fpo_fplist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fplist.lists["x_production_plan"] = <?php echo $po_fp_list->production_plan->Lookup->toClientList() ?>;
fpo_fplist.lists["x_production_plan"].options = <?php echo JsonEncode($po_fp_list->production_plan->options(FALSE, TRUE)) ?>;

// Form object for search
var fpo_fplistsrch = currentSearchForm = new ew.Form("fpo_fplistsrch");

// Filters
fpo_fplistsrch.filterList = <?php echo $po_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_fp_list->TotalRecs > 0 && $po_fp_list->ExportOptions->visible()) { ?>
<?php $po_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_fp_list->ImportOptions->visible()) { ?>
<?php $po_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_fp_list->SearchOptions->visible()) { ?>
<?php $po_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_fp_list->FilterOptions->visible()) { ?>
<?php $po_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_fp->isExport() && !$po_fp->CurrentAction) { ?>
<form name="fpo_fplistsrch" id="fpo_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_fp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_fp_list->showPageHeader(); ?>
<?php
$po_fp_list->showMessage();
?>
<?php if ($po_fp_list->TotalRecs > 0 || $po_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_fp">
<?php if (!$po_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_fp_list->Pager)) $po_fp_list->Pager = new PrevNextPager($po_fp_list->StartRec, $po_fp_list->DisplayRecs, $po_fp_list->TotalRecs, $po_fp_list->AutoHidePager) ?>
<?php if ($po_fp_list->Pager->RecordCount > 0 && $po_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_fp_list->pageUrl() ?>start=<?php echo $po_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_fp_list->pageUrl() ?>start=<?php echo $po_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_fp_list->pageUrl() ?>start=<?php echo $po_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_fp_list->pageUrl() ?>start=<?php echo $po_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_fp_list->TotalRecs > 0 && (!$po_fp_list->AutoHidePageSizeSelector || $po_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_fplist" id="fpo_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_fp">
<div id="gmp_po_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_fp_list->TotalRecs > 0 || $po_fp->isGridEdit()) { ?>
<table id="tbl_po_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_fp_list->renderListOptions();

// Render list options (header, left)
$po_fp_list->ListOptions->render("header", "left");
?>
<?php if ($po_fp->id->Visible) { // id ?>
	<?php if ($po_fp->sortUrl($po_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_fp->id->headerCellClass() ?>"><div id="elh_po_fp_id" class="po_fp_id"><div class="ew-table-header-caption"><?php echo $po_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->id) ?>',2);"><div id="elh_po_fp_id" class="po_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->po->Visible) { // po ?>
	<?php if ($po_fp->sortUrl($po_fp->po) == "") { ?>
		<th data-name="po" class="<?php echo $po_fp->po->headerCellClass() ?>"><div id="elh_po_fp_po" class="po_fp_po"><div class="ew-table-header-caption"><?php echo $po_fp->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $po_fp->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->po) ?>',2);"><div id="elh_po_fp_po" class="po_fp_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->buyer_id->Visible) { // buyer_id ?>
	<?php if ($po_fp->sortUrl($po_fp->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $po_fp->buyer_id->headerCellClass() ?>"><div id="elh_po_fp_buyer_id" class="po_fp_buyer_id"><div class="ew-table-header-caption"><?php echo $po_fp->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $po_fp->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->buyer_id) ?>',2);"><div id="elh_po_fp_buyer_id" class="po_fp_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->buyer_product_ref->Visible) { // buyer_product_ref ?>
	<?php if ($po_fp->sortUrl($po_fp->buyer_product_ref) == "") { ?>
		<th data-name="buyer_product_ref" class="<?php echo $po_fp->buyer_product_ref->headerCellClass() ?>"><div id="elh_po_fp_buyer_product_ref" class="po_fp_buyer_product_ref"><div class="ew-table-header-caption"><?php echo $po_fp->buyer_product_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_product_ref" class="<?php echo $po_fp->buyer_product_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->buyer_product_ref) ?>',2);"><div id="elh_po_fp_buyer_product_ref" class="po_fp_buyer_product_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->buyer_product_ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->buyer_product_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->buyer_product_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->rid->Visible) { // rid ?>
	<?php if ($po_fp->sortUrl($po_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $po_fp->rid->headerCellClass() ?>"><div id="elh_po_fp_rid" class="po_fp_rid"><div class="ew-table-header-caption"><?php echo $po_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $po_fp->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->rid) ?>',2);"><div id="elh_po_fp_rid" class="po_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->batch_no->Visible) { // batch_no ?>
	<?php if ($po_fp->sortUrl($po_fp->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $po_fp->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_po_fp_batch_no" class="po_fp_batch_no"><div class="ew-table-header-caption"><?php echo $po_fp->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $po_fp->batch_no->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->batch_no) ?>',2);"><div id="elh_po_fp_batch_no" class="po_fp_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->quantity->Visible) { // quantity ?>
	<?php if ($po_fp->sortUrl($po_fp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $po_fp->quantity->headerCellClass() ?>"><div id="elh_po_fp_quantity" class="po_fp_quantity"><div class="ew-table-header-caption"><?php echo $po_fp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $po_fp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->quantity) ?>',2);"><div id="elh_po_fp_quantity" class="po_fp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->balance_quantity->Visible) { // balance_quantity ?>
	<?php if ($po_fp->sortUrl($po_fp->balance_quantity) == "") { ?>
		<th data-name="balance_quantity" class="<?php echo $po_fp->balance_quantity->headerCellClass() ?>"><div id="elh_po_fp_balance_quantity" class="po_fp_balance_quantity"><div class="ew-table-header-caption"><?php echo $po_fp->balance_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance_quantity" class="<?php echo $po_fp->balance_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->balance_quantity) ?>',2);"><div id="elh_po_fp_balance_quantity" class="po_fp_balance_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->balance_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->balance_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->balance_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->price->Visible) { // price ?>
	<?php if ($po_fp->sortUrl($po_fp->price) == "") { ?>
		<th data-name="price" class="<?php echo $po_fp->price->headerCellClass() ?>"><div id="elh_po_fp_price" class="po_fp_price"><div class="ew-table-header-caption"><?php echo $po_fp->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $po_fp->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->price) ?>',2);"><div id="elh_po_fp_price" class="po_fp_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->buyer_order_no->Visible) { // buyer_order_no ?>
	<?php if ($po_fp->sortUrl($po_fp->buyer_order_no) == "") { ?>
		<th data-name="buyer_order_no" class="<?php echo $po_fp->buyer_order_no->headerCellClass() ?>"><div id="elh_po_fp_buyer_order_no" class="po_fp_buyer_order_no"><div class="ew-table-header-caption"><?php echo $po_fp->buyer_order_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_order_no" class="<?php echo $po_fp->buyer_order_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->buyer_order_no) ?>',2);"><div id="elh_po_fp_buyer_order_no" class="po_fp_buyer_order_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->buyer_order_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_fp->buyer_order_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->buyer_order_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->buyer_order_date->Visible) { // buyer_order_date ?>
	<?php if ($po_fp->sortUrl($po_fp->buyer_order_date) == "") { ?>
		<th data-name="buyer_order_date" class="<?php echo $po_fp->buyer_order_date->headerCellClass() ?>"><div id="elh_po_fp_buyer_order_date" class="po_fp_buyer_order_date"><div class="ew-table-header-caption"><?php echo $po_fp->buyer_order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_order_date" class="<?php echo $po_fp->buyer_order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->buyer_order_date) ?>',2);"><div id="elh_po_fp_buyer_order_date" class="po_fp_buyer_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->buyer_order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->buyer_order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->buyer_order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->despatch_date->Visible) { // despatch_date ?>
	<?php if ($po_fp->sortUrl($po_fp->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $po_fp->despatch_date->headerCellClass() ?>"><div id="elh_po_fp_despatch_date" class="po_fp_despatch_date"><div class="ew-table-header-caption"><?php echo $po_fp->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $po_fp->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->despatch_date) ?>',2);"><div id="elh_po_fp_despatch_date" class="po_fp_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->despatch_week->Visible) { // despatch_week ?>
	<?php if ($po_fp->sortUrl($po_fp->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $po_fp->despatch_week->headerCellClass() ?>"><div id="elh_po_fp_despatch_week" class="po_fp_despatch_week"><div class="ew-table-header-caption"><?php echo $po_fp->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $po_fp->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->despatch_week) ?>',2);"><div id="elh_po_fp_despatch_week" class="po_fp_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->production_plan->Visible) { // production_plan ?>
	<?php if ($po_fp->sortUrl($po_fp->production_plan) == "") { ?>
		<th data-name="production_plan" class="<?php echo $po_fp->production_plan->headerCellClass() ?>"><div id="elh_po_fp_production_plan" class="po_fp_production_plan"><div class="ew-table-header-caption"><?php echo $po_fp->production_plan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_plan" class="<?php echo $po_fp->production_plan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->production_plan) ?>',2);"><div id="elh_po_fp_production_plan" class="po_fp_production_plan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->production_plan->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->production_plan->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->production_plan->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->lot_no->Visible) { // lot_no ?>
	<?php if ($po_fp->sortUrl($po_fp->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $po_fp->lot_no->headerCellClass() ?>"><div id="elh_po_fp_lot_no" class="po_fp_lot_no"><div class="ew-table-header-caption"><?php echo $po_fp->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $po_fp->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->lot_no) ?>',2);"><div id="elh_po_fp_lot_no" class="po_fp_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_fp->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_fp->production_site->Visible) { // production_site ?>
	<?php if ($po_fp->sortUrl($po_fp->production_site) == "") { ?>
		<th data-name="production_site" class="<?php echo $po_fp->production_site->headerCellClass() ?>"><div id="elh_po_fp_production_site" class="po_fp_production_site"><div class="ew-table-header-caption"><?php echo $po_fp->production_site->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="production_site" class="<?php echo $po_fp->production_site->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_fp->SortUrl($po_fp->production_site) ?>',2);"><div id="elh_po_fp_production_site" class="po_fp_production_site">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_fp->production_site->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_fp->production_site->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_fp->production_site->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_fp->ExportAll && $po_fp->isExport()) {
	$po_fp_list->StopRec = $po_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_fp_list->TotalRecs > $po_fp_list->StartRec + $po_fp_list->DisplayRecs - 1)
		$po_fp_list->StopRec = $po_fp_list->StartRec + $po_fp_list->DisplayRecs - 1;
	else
		$po_fp_list->StopRec = $po_fp_list->TotalRecs;
}
$po_fp_list->RecCnt = $po_fp_list->StartRec - 1;
if ($po_fp_list->Recordset && !$po_fp_list->Recordset->EOF) {
	$po_fp_list->Recordset->moveFirst();
	$selectLimit = $po_fp_list->UseSelectLimit;
	if (!$selectLimit && $po_fp_list->StartRec > 1)
		$po_fp_list->Recordset->move($po_fp_list->StartRec - 1);
} elseif (!$po_fp->AllowAddDeleteRow && $po_fp_list->StopRec == 0) {
	$po_fp_list->StopRec = $po_fp->GridAddRowCount;
}

// Initialize aggregate
$po_fp->RowType = ROWTYPE_AGGREGATEINIT;
$po_fp->resetAttributes();
$po_fp_list->renderRow();
while ($po_fp_list->RecCnt < $po_fp_list->StopRec) {
	$po_fp_list->RecCnt++;
	if ($po_fp_list->RecCnt >= $po_fp_list->StartRec) {
		$po_fp_list->RowCnt++;

		// Set up key count
		$po_fp_list->KeyCount = $po_fp_list->RowIndex;

		// Init row class and style
		$po_fp->resetAttributes();
		$po_fp->CssClass = "";
		if ($po_fp->isGridAdd()) {
		} else {
			$po_fp_list->loadRowValues($po_fp_list->Recordset); // Load row values
		}
		$po_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_fp->RowAttrs = array_merge($po_fp->RowAttrs, array('data-rowindex'=>$po_fp_list->RowCnt, 'id'=>'r' . $po_fp_list->RowCnt . '_po_fp', 'data-rowtype'=>$po_fp->RowType));

		// Render row
		$po_fp_list->renderRow();

		// Render list options
		$po_fp_list->renderListOptions();
?>
	<tr<?php echo $po_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_fp_list->ListOptions->render("body", "left", $po_fp_list->RowCnt);
?>
	<?php if ($po_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_fp->id->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_id" class="po_fp_id">
<span<?php echo $po_fp->id->viewAttributes() ?>>
<?php echo $po_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->po->Visible) { // po ?>
		<td data-name="po"<?php echo $po_fp->po->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_po" class="po_fp_po">
<span<?php echo $po_fp->po->viewAttributes() ?>>
<?php echo $po_fp->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $po_fp->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_buyer_id" class="po_fp_buyer_id">
<span<?php echo $po_fp->buyer_id->viewAttributes() ?>>
<?php echo $po_fp->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->buyer_product_ref->Visible) { // buyer_product_ref ?>
		<td data-name="buyer_product_ref"<?php echo $po_fp->buyer_product_ref->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_buyer_product_ref" class="po_fp_buyer_product_ref">
<span<?php echo $po_fp->buyer_product_ref->viewAttributes() ?>>
<?php echo $po_fp->buyer_product_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $po_fp->rid->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_rid" class="po_fp_rid">
<span<?php echo $po_fp->rid->viewAttributes() ?>>
<?php if ((!EmptyString($po_fp->rid->getViewValue())) && $po_fp->rid->linkAttributes() <> "") { ?>
<a<?php echo $po_fp->rid->linkAttributes() ?>><?php echo $po_fp->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_fp->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $po_fp->batch_no->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_batch_no" class="po_fp_batch_no">
<span<?php echo $po_fp->batch_no->viewAttributes() ?>>
<?php echo $po_fp->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $po_fp->quantity->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_quantity" class="po_fp_quantity">
<span<?php echo $po_fp->quantity->viewAttributes() ?>>
<?php echo $po_fp->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->balance_quantity->Visible) { // balance_quantity ?>
		<td data-name="balance_quantity"<?php echo $po_fp->balance_quantity->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_balance_quantity" class="po_fp_balance_quantity">
<span<?php echo $po_fp->balance_quantity->viewAttributes() ?>>
<?php echo $po_fp->balance_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->price->Visible) { // price ?>
		<td data-name="price"<?php echo $po_fp->price->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_price" class="po_fp_price">
<span<?php echo $po_fp->price->viewAttributes() ?>>
<?php echo $po_fp->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->buyer_order_no->Visible) { // buyer_order_no ?>
		<td data-name="buyer_order_no"<?php echo $po_fp->buyer_order_no->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_buyer_order_no" class="po_fp_buyer_order_no">
<span<?php echo $po_fp->buyer_order_no->viewAttributes() ?>>
<?php echo $po_fp->buyer_order_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->buyer_order_date->Visible) { // buyer_order_date ?>
		<td data-name="buyer_order_date"<?php echo $po_fp->buyer_order_date->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_buyer_order_date" class="po_fp_buyer_order_date">
<span<?php echo $po_fp->buyer_order_date->viewAttributes() ?>>
<?php echo $po_fp->buyer_order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $po_fp->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_despatch_date" class="po_fp_despatch_date">
<span<?php echo $po_fp->despatch_date->viewAttributes() ?>>
<?php echo $po_fp->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $po_fp->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_despatch_week" class="po_fp_despatch_week">
<span<?php echo $po_fp->despatch_week->viewAttributes() ?>>
<?php echo $po_fp->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->production_plan->Visible) { // production_plan ?>
		<td data-name="production_plan"<?php echo $po_fp->production_plan->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_production_plan" class="po_fp_production_plan">
<span<?php echo $po_fp->production_plan->viewAttributes() ?>>
<?php echo $po_fp->production_plan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $po_fp->lot_no->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_lot_no" class="po_fp_lot_no">
<span<?php echo $po_fp->lot_no->viewAttributes() ?>>
<?php echo $po_fp->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_fp->production_site->Visible) { // production_site ?>
		<td data-name="production_site"<?php echo $po_fp->production_site->cellAttributes() ?>>
<span id="el<?php echo $po_fp_list->RowCnt ?>_po_fp_production_site" class="po_fp_production_site">
<span<?php echo $po_fp->production_site->viewAttributes() ?>>
<?php echo $po_fp->production_site->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_fp_list->ListOptions->render("body", "right", $po_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_fp->isGridAdd())
		$po_fp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_fp_list->Recordset)
	$po_fp_list->Recordset->Close();
?>
<?php if (!$po_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_fp_list->Pager)) $po_fp_list->Pager = new PrevNextPager($po_fp_list->StartRec, $po_fp_list->DisplayRecs, $po_fp_list->TotalRecs, $po_fp_list->AutoHidePager) ?>
<?php if ($po_fp_list->Pager->RecordCount > 0 && $po_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_fp_list->pageUrl() ?>start=<?php echo $po_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_fp_list->pageUrl() ?>start=<?php echo $po_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_fp_list->pageUrl() ?>start=<?php echo $po_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_fp_list->pageUrl() ?>start=<?php echo $po_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_fp_list->TotalRecs > 0 && (!$po_fp_list->AutoHidePageSizeSelector || $po_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_fp_list->TotalRecs == 0 && !$po_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_fp_list->terminate();
?>