<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_fp_search = new po_fp_search();

// Run the page
$po_fp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_fp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_fp_search->IsModal) { ?>
var fpo_fpsearch = currentAdvancedSearchForm = new ew.Form("fpo_fpsearch", "search");
<?php } else { ?>
var fpo_fpsearch = currentForm = new ew.Form("fpo_fpsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_fpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_fpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_fpsearch.multiPage = new ew.MultiPage("fpo_fpsearch");

// Dynamic selection lists
fpo_fpsearch.lists["x_grp"] = <?php echo $po_fp_search->grp->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_grp"].options = <?php echo JsonEncode($po_fp_search->grp->options(FALSE, TRUE)) ?>;
fpo_fpsearch.lists["x_buyer_id"] = <?php echo $po_fp_search->buyer_id->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($po_fp_search->buyer_id->lookupOptions()) ?>;
fpo_fpsearch.lists["x_buyer_product_ref"] = <?php echo $po_fp_search->buyer_product_ref->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_buyer_product_ref"].options = <?php echo JsonEncode($po_fp_search->buyer_product_ref->lookupOptions()) ?>;
fpo_fpsearch.lists["x_s_grp"] = <?php echo $po_fp_search->s_grp->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_s_grp"].options = <?php echo JsonEncode($po_fp_search->s_grp->lookupOptions()) ?>;
fpo_fpsearch.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpsearch.lists["x_product"] = <?php echo $po_fp_search->product->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_product"].options = <?php echo JsonEncode($po_fp_search->product->lookupOptions()) ?>;
fpo_fpsearch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpsearch.lists["x_rid"] = <?php echo $po_fp_search->rid->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_rid"].options = <?php echo JsonEncode($po_fp_search->rid->lookupOptions()) ?>;
fpo_fpsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpsearch.lists["x_product_gcode"] = <?php echo $po_fp_search->product_gcode->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_product_gcode"].options = <?php echo JsonEncode($po_fp_search->product_gcode->lookupOptions()) ?>;
fpo_fpsearch.lists["x_production_plan"] = <?php echo $po_fp_search->production_plan->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_production_plan"].options = <?php echo JsonEncode($po_fp_search->production_plan->options(FALSE, TRUE)) ?>;
fpo_fpsearch.lists["x_d_01_head"] = <?php echo $po_fp_search->d_01_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_01_head"].options = <?php echo JsonEncode($po_fp_search->d_01_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_02_head"] = <?php echo $po_fp_search->d_02_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_02_head"].options = <?php echo JsonEncode($po_fp_search->d_02_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_03_head"] = <?php echo $po_fp_search->d_03_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_03_head"].options = <?php echo JsonEncode($po_fp_search->d_03_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_description_03"] = <?php echo $po_fp_search->description_03->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_description_03"].options = <?php echo JsonEncode($po_fp_search->description_03->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_04_head"] = <?php echo $po_fp_search->d_04_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_04_head"].options = <?php echo JsonEncode($po_fp_search->d_04_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_description_04"] = <?php echo $po_fp_search->description_04->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_description_04"].options = <?php echo JsonEncode($po_fp_search->description_04->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_05_head"] = <?php echo $po_fp_search->d_05_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_05_head"].options = <?php echo JsonEncode($po_fp_search->d_05_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_description_05"] = <?php echo $po_fp_search->description_05->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_description_05"].options = <?php echo JsonEncode($po_fp_search->description_05->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_06_head"] = <?php echo $po_fp_search->d_06_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_06_head"].options = <?php echo JsonEncode($po_fp_search->d_06_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_description_06"] = <?php echo $po_fp_search->description_06->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_description_06"].options = <?php echo JsonEncode($po_fp_search->description_06->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_07_head"] = <?php echo $po_fp_search->d_07_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_07_head"].options = <?php echo JsonEncode($po_fp_search->d_07_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_08_head"] = <?php echo $po_fp_search->d_08_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_08_head"].options = <?php echo JsonEncode($po_fp_search->d_08_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_09_head"] = <?php echo $po_fp_search->d_09_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_09_head"].options = <?php echo JsonEncode($po_fp_search->d_09_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_10_head"] = <?php echo $po_fp_search->d_10_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_10_head"].options = <?php echo JsonEncode($po_fp_search->d_10_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_11_head"] = <?php echo $po_fp_search->d_11_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_11_head"].options = <?php echo JsonEncode($po_fp_search->d_11_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_d_12_head"] = <?php echo $po_fp_search->d_12_head->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_d_12_head"].options = <?php echo JsonEncode($po_fp_search->d_12_head->lookupOptions()) ?>;
fpo_fpsearch.lists["x_operator"] = <?php echo $po_fp_search->operator->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_operator"].options = <?php echo JsonEncode($po_fp_search->operator->lookupOptions()) ?>;
fpo_fpsearch.lists["x_a_operator"] = <?php echo $po_fp_search->a_operator->Lookup->toClientList() ?>;
fpo_fpsearch.lists["x_a_operator"].options = <?php echo JsonEncode($po_fp_search->a_operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpo_fpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkByRegEx(elm.value, /^[0-9]{4,4}$/))
		return this.onError(elm, "<?php echo JsEncode($po_fp->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_s_grp");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->s_grp->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->rid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->balance_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->buyer_order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->despatch_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_01");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->description_01->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_02");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->description_02->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_production_site");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_fp->production_site->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_fp_search->showPageHeader(); ?>
<?php
$po_fp_search->showMessage();
?>
<form name="fpo_fpsearch" id="fpo_fpsearch" class="<?php echo $po_fp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_fp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_fp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_fp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_fp_search->IsModal ?>">
<?php if ($po_fp_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($po_fp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_grp"><?php echo $po_fp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->grp->cellAttributes() ?>>
			<span id="el_po_fp_grp">
<?php $po_fp->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_fp->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_grp" data-page="0" data-value-separator="<?php echo $po_fp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_fp->grp->editAttributes() ?>>
		<?php echo $po_fp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_po"><?php echo $po_fp->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->po->cellAttributes() ?>>
			<span id="el_po_fp_po">
<input type="text" data-table="po_fp" data-field="x_po" data-page="0" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($po_fp->po->getPlaceHolder()) ?>" value="<?php echo $po_fp->po->EditValue ?>"<?php echo $po_fp->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_buyer_id"><?php echo $po_fp->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->buyer_id->cellAttributes() ?>>
			<span id="el_po_fp_buyer_id">
<?php $po_fp->buyer_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_fp->buyer_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_buyer_id" data-page="0" data-value-separator="<?php echo $po_fp->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po_fp->buyer_id->editAttributes() ?>>
		<?php echo $po_fp->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $po_fp->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_product_ref->Visible) { // buyer_product_ref ?>
	<div id="r_buyer_product_ref" class="form-group row">
		<label for="x_buyer_product_ref" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_buyer_product_ref"><?php echo $po_fp->buyer_product_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_product_ref" id="z_buyer_product_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->buyer_product_ref->cellAttributes() ?>>
			<span id="el_po_fp_buyer_product_ref">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_buyer_product_ref" data-page="0" data-value-separator="<?php echo $po_fp->buyer_product_ref->displayValueSeparatorAttribute() ?>" id="x_buyer_product_ref" name="x_buyer_product_ref"<?php echo $po_fp->buyer_product_ref->editAttributes() ?>>
		<?php echo $po_fp->buyer_product_ref->selectOptionListHtml("x_buyer_product_ref") ?>
	</select>
</div>
<?php echo $po_fp->buyer_product_ref->Lookup->getParamTag("p_x_buyer_product_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_s_grp"><?php echo $po_fp->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->s_grp->cellAttributes() ?>>
			<span id="el_po_fp_s_grp">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$po_fp->s_grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_fp->s_grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_s_grp" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_s_grp" id="sv_x_s_grp" value="<?php echo RemoveHtml($po_fp->s_grp->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_fp->s_grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_fp->s_grp->getPlaceHolder()) ?>"<?php echo $po_fp->s_grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_fp->s_grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_s_grp',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($po_fp->s_grp->ReadOnly || $po_fp->s_grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_fp" data-field="x_s_grp" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_fp->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp" id="x_s_grp" value="<?php echo HtmlEncode($po_fp->s_grp->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fpsearch.createAutoSuggest({"id":"x_s_grp","forceSelect":true});
</script>
<?php echo $po_fp->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_product"><?php echo $po_fp->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->product->cellAttributes() ?>>
			<span id="el_po_fp_product">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$po_fp->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_fp->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($po_fp->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_fp->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_fp->product->getPlaceHolder()) ?>"<?php echo $po_fp->product->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_fp->product->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_product',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($po_fp->product->ReadOnly || $po_fp->product->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_fp" data-field="x_product" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_fp->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($po_fp->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fpsearch.createAutoSuggest({"id":"x_product","forceSelect":true});
</script>
<?php echo $po_fp->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_rid"><?php echo $po_fp->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->rid->cellAttributes() ?>>
			<span id="el_po_fp_rid">
<?php
$wrkonchange = "" . trim(@$po_fp->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_fp->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($po_fp->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_fp->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_fp->rid->getPlaceHolder()) ?>"<?php echo $po_fp->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($po_fp->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($po_fp->rid->ReadOnly || $po_fp->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="po_fp" data-field="x_rid" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $po_fp->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($po_fp->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fpsearch.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $po_fp->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->product_gcode->Visible) { // product_gcode ?>
	<div id="r_product_gcode" class="form-group row">
		<label for="x_product_gcode" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_product_gcode"><?php echo $po_fp->product_gcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_gcode" id="z_product_gcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->product_gcode->cellAttributes() ?>>
			<span id="el_po_fp_product_gcode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_product_gcode" data-page="0" data-value-separator="<?php echo $po_fp->product_gcode->displayValueSeparatorAttribute() ?>" id="x_product_gcode" name="x_product_gcode"<?php echo $po_fp->product_gcode->editAttributes() ?>>
		<?php echo $po_fp->product_gcode->selectOptionListHtml("x_product_gcode") ?>
	</select>
</div>
<?php echo $po_fp->product_gcode->Lookup->getParamTag("p_x_product_gcode") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav-tabs" id="po_fp_search"><!-- multi-page tabs -->
	<ul class="<?php echo $po_fp_search->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_search->MultiPages->pageStyle("1") ?>" href="#tab_po_fp1" data-toggle="tab"><?php echo $po_fp->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_search->MultiPages->pageStyle("2") ?>" href="#tab_po_fp2" data-toggle="tab"><?php echo $po_fp->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_search->MultiPages->pageStyle("3") ?>" href="#tab_po_fp3" data-toggle="tab"><?php echo $po_fp->pageCaption(3) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_search->MultiPages->pageStyle("4") ?>" href="#tab_po_fp4" data-toggle="tab"><?php echo $po_fp->pageCaption(4) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_search->MultiPages->pageStyle("5") ?>" href="#tab_po_fp5" data-toggle="tab"><?php echo $po_fp->pageCaption(5) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_search->MultiPages->pageStyle("6") ?>" href="#tab_po_fp6" data-toggle="tab"><?php echo $po_fp->pageCaption(6) ?></a></li>
	</ul>
	<div class="tab-content"><!-- multi-page tabs .tab-content -->
		<div class="tab-pane<?php echo $po_fp_search->MultiPages->pageStyle("1") ?>" id="tab_po_fp1"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_fp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_id"><?php echo $po_fp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->id->cellAttributes() ?>>
			<span id="el_po_fp_id">
<input type="text" data-table="po_fp" data-field="x_id" data-page="1" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($po_fp->id->getPlaceHolder()) ?>" value="<?php echo $po_fp->id->EditValue ?>"<?php echo $po_fp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->balance_quantity->Visible) { // balance_quantity ?>
	<div id="r_balance_quantity" class="form-group row">
		<label for="x_balance_quantity" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_balance_quantity"><?php echo $po_fp->balance_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance_quantity" id="z_balance_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->balance_quantity->cellAttributes() ?>>
			<span id="el_po_fp_balance_quantity">
<input type="text" data-table="po_fp" data-field="x_balance_quantity" data-page="1" name="x_balance_quantity" id="x_balance_quantity" size="30" placeholder="<?php echo HtmlEncode($po_fp->balance_quantity->getPlaceHolder()) ?>" value="<?php echo $po_fp->balance_quantity->EditValue ?>"<?php echo $po_fp->balance_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_order_no->Visible) { // buyer_order_no ?>
	<div id="r_buyer_order_no" class="form-group row">
		<label for="x_buyer_order_no" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_buyer_order_no"><?php echo $po_fp->buyer_order_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order_no" id="z_buyer_order_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->buyer_order_no->cellAttributes() ?>>
			<span id="el_po_fp_buyer_order_no">
<input type="text" data-table="po_fp" data-field="x_buyer_order_no" data-page="1" name="x_buyer_order_no" id="x_buyer_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->buyer_order_no->getPlaceHolder()) ?>" value="<?php echo $po_fp->buyer_order_no->EditValue ?>"<?php echo $po_fp->buyer_order_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_order_date->Visible) { // buyer_order_date ?>
	<div id="r_buyer_order_date" class="form-group row">
		<label for="x_buyer_order_date" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_buyer_order_date"><?php echo $po_fp->buyer_order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_order_date" id="z_buyer_order_date" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->buyer_order_date->cellAttributes() ?>>
			<span id="el_po_fp_buyer_order_date">
<input type="text" data-table="po_fp" data-field="x_buyer_order_date" data-page="1" name="x_buyer_order_date" id="x_buyer_order_date" placeholder="<?php echo HtmlEncode($po_fp->buyer_order_date->getPlaceHolder()) ?>" value="<?php echo $po_fp->buyer_order_date->EditValue ?>"<?php echo $po_fp->buyer_order_date->editAttributes() ?>>
<?php if (!$po_fp->buyer_order_date->ReadOnly && !$po_fp->buyer_order_date->Disabled && !isset($po_fp->buyer_order_date->EditAttrs["readonly"]) && !isset($po_fp->buyer_order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fpsearch", "x_buyer_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label for="x_buyer_instruction" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_buyer_instruction"><?php echo $po_fp->buyer_instruction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->buyer_instruction->cellAttributes() ?>>
			<span id="el_po_fp_buyer_instruction">
<input type="text" data-table="po_fp" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" size="30" placeholder="<?php echo HtmlEncode($po_fp->buyer_instruction->getPlaceHolder()) ?>" value="<?php echo $po_fp->buyer_instruction->EditValue ?>"<?php echo $po_fp->buyer_instruction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_remarks"><?php echo $po_fp->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->remarks->cellAttributes() ?>>
			<span id="el_po_fp_remarks">
<input type="text" data-table="po_fp" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" size="30" placeholder="<?php echo HtmlEncode($po_fp->remarks->getPlaceHolder()) ?>" value="<?php echo $po_fp->remarks->EditValue ?>"<?php echo $po_fp->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->production_site->Visible) { // production_site ?>
	<div id="r_production_site" class="form-group row">
		<label for="x_production_site" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_production_site"><?php echo $po_fp->production_site->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_site" id="z_production_site" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->production_site->cellAttributes() ?>>
			<span id="el_po_fp_production_site">
<input type="text" data-table="po_fp" data-field="x_production_site" data-page="1" name="x_production_site" id="x_production_site" size="30" placeholder="<?php echo HtmlEncode($po_fp->production_site->getPlaceHolder()) ?>" value="<?php echo $po_fp->production_site->EditValue ?>"<?php echo $po_fp->production_site->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_search->MultiPages->pageStyle("2") ?>" id="tab_po_fp2"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_fp->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_quantity"><?php echo $po_fp->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->quantity->cellAttributes() ?>>
			<span id="el_po_fp_quantity">
<input type="text" data-table="po_fp" data-field="x_quantity" data-page="2" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_fp->quantity->getPlaceHolder()) ?>" value="<?php echo $po_fp->quantity->EditValue ?>"<?php echo $po_fp->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_price"><?php echo $po_fp->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->price->cellAttributes() ?>>
			<span id="el_po_fp_price">
<input type="text" data-table="po_fp" data-field="x_price" data-page="2" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($po_fp->price->getPlaceHolder()) ?>" value="<?php echo $po_fp->price->EditValue ?>"<?php echo $po_fp->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_despatch_date"><?php echo $po_fp->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->despatch_date->cellAttributes() ?>>
			<span id="el_po_fp_despatch_date">
<input type="text" data-table="po_fp" data-field="x_despatch_date" data-page="2" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($po_fp->despatch_date->getPlaceHolder()) ?>" value="<?php echo $po_fp->despatch_date->EditValue ?>"<?php echo $po_fp->despatch_date->editAttributes() ?>>
<?php if (!$po_fp->despatch_date->ReadOnly && !$po_fp->despatch_date->Disabled && !isset($po_fp->despatch_date->EditAttrs["readonly"]) && !isset($po_fp->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fpsearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_production_plan"><?php echo $po_fp->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->production_plan->cellAttributes() ?>>
			<span id="el_po_fp_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_production_plan" data-page="2" data-value-separator="<?php echo $po_fp->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $po_fp->production_plan->editAttributes() ?>>
		<?php echo $po_fp->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_lot_no"><?php echo $po_fp->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->lot_no->cellAttributes() ?>>
			<span id="el_po_fp_lot_no">
<input type="text" data-table="po_fp" data-field="x_lot_no" data-page="2" name="x_lot_no" id="x_lot_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($po_fp->lot_no->getPlaceHolder()) ?>" value="<?php echo $po_fp->lot_no->EditValue ?>"<?php echo $po_fp->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_search->MultiPages->pageStyle("3") ?>" id="tab_po_fp3"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_fp->d_01_head->Visible) { // d_01_head ?>
	<div id="r_d_01_head" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_01_head"><?php echo $po_fp->d_01_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_01_head" id="z_d_01_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_01_head->cellAttributes() ?>>
			<span id="el_po_fp_d_01_head">
<div id="tp_x_d_01_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_01_head" data-page="3" data-value-separator="<?php echo $po_fp->d_01_head->displayValueSeparatorAttribute() ?>" name="x_d_01_head" id="x_d_01_head" value="{value}"<?php echo $po_fp->d_01_head->editAttributes() ?>></div>
<div id="dsl_x_d_01_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_01_head->radioButtonListHtml(FALSE, "x_d_01_head", 3) ?>
</div></div>
<?php echo $po_fp->d_01_head->Lookup->getParamTag("p_x_d_01_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label for="x_description_01" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_01"><?php echo $po_fp->description_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_01" id="z_description_01" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_01->cellAttributes() ?>>
			<span id="el_po_fp_description_01">
<input type="text" data-table="po_fp" data-field="x_description_01" data-page="3" name="x_description_01" id="x_description_01" size="30" placeholder="<?php echo HtmlEncode($po_fp->description_01->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_01->EditValue ?>"<?php echo $po_fp->description_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_02_head->Visible) { // d_02_head ?>
	<div id="r_d_02_head" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_02_head"><?php echo $po_fp->d_02_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_02_head" id="z_d_02_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_02_head->cellAttributes() ?>>
			<span id="el_po_fp_d_02_head">
<div id="tp_x_d_02_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_02_head" data-page="3" data-value-separator="<?php echo $po_fp->d_02_head->displayValueSeparatorAttribute() ?>" name="x_d_02_head" id="x_d_02_head" value="{value}"<?php echo $po_fp->d_02_head->editAttributes() ?>></div>
<div id="dsl_x_d_02_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_02_head->radioButtonListHtml(FALSE, "x_d_02_head", 3) ?>
</div></div>
<?php echo $po_fp->d_02_head->Lookup->getParamTag("p_x_d_02_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label for="x_description_02" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_02"><?php echo $po_fp->description_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_02" id="z_description_02" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_02->cellAttributes() ?>>
			<span id="el_po_fp_description_02">
<input type="text" data-table="po_fp" data-field="x_description_02" data-page="3" name="x_description_02" id="x_description_02" size="30" placeholder="<?php echo HtmlEncode($po_fp->description_02->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_02->EditValue ?>"<?php echo $po_fp->description_02->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_03_head->Visible) { // d_03_head ?>
	<div id="r_d_03_head" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_03_head"><?php echo $po_fp->d_03_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_03_head" id="z_d_03_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_03_head->cellAttributes() ?>>
			<span id="el_po_fp_d_03_head">
<div id="tp_x_d_03_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_03_head" data-page="3" data-value-separator="<?php echo $po_fp->d_03_head->displayValueSeparatorAttribute() ?>" name="x_d_03_head" id="x_d_03_head" value="{value}"<?php echo $po_fp->d_03_head->editAttributes() ?>></div>
<div id="dsl_x_d_03_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_03_head->radioButtonListHtml(FALSE, "x_d_03_head", 3) ?>
</div></div>
<?php echo $po_fp->d_03_head->Lookup->getParamTag("p_x_d_03_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label for="x_description_03" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_03"><?php echo $po_fp->description_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_03" id="z_description_03" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_03->cellAttributes() ?>>
			<span id="el_po_fp_description_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_description_03" data-page="3" data-value-separator="<?php echo $po_fp->description_03->displayValueSeparatorAttribute() ?>" id="x_description_03" name="x_description_03"<?php echo $po_fp->description_03->editAttributes() ?>>
		<?php echo $po_fp->description_03->selectOptionListHtml("x_description_03") ?>
	</select>
</div>
<?php echo $po_fp->description_03->Lookup->getParamTag("p_x_description_03") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_04_head->Visible) { // d_04_head ?>
	<div id="r_d_04_head" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_04_head"><?php echo $po_fp->d_04_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_04_head" id="z_d_04_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_04_head->cellAttributes() ?>>
			<span id="el_po_fp_d_04_head">
<div id="tp_x_d_04_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_04_head" data-page="3" data-value-separator="<?php echo $po_fp->d_04_head->displayValueSeparatorAttribute() ?>" name="x_d_04_head" id="x_d_04_head" value="{value}"<?php echo $po_fp->d_04_head->editAttributes() ?>></div>
<div id="dsl_x_d_04_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_04_head->radioButtonListHtml(FALSE, "x_d_04_head", 3) ?>
</div></div>
<?php echo $po_fp->d_04_head->Lookup->getParamTag("p_x_d_04_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label for="x_description_04" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_04"><?php echo $po_fp->description_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_04" id="z_description_04" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_04->cellAttributes() ?>>
			<span id="el_po_fp_description_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_description_04" data-page="3" data-value-separator="<?php echo $po_fp->description_04->displayValueSeparatorAttribute() ?>" id="x_description_04" name="x_description_04"<?php echo $po_fp->description_04->editAttributes() ?>>
		<?php echo $po_fp->description_04->selectOptionListHtml("x_description_04") ?>
	</select>
</div>
<?php echo $po_fp->description_04->Lookup->getParamTag("p_x_description_04") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_search->MultiPages->pageStyle("4") ?>" id="tab_po_fp4"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_fp->d_05_head->Visible) { // d_05_head ?>
	<div id="r_d_05_head" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_05_head"><?php echo $po_fp->d_05_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_05_head" id="z_d_05_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_05_head->cellAttributes() ?>>
			<span id="el_po_fp_d_05_head">
<div id="tp_x_d_05_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_05_head" data-page="4" data-value-separator="<?php echo $po_fp->d_05_head->displayValueSeparatorAttribute() ?>" name="x_d_05_head" id="x_d_05_head" value="{value}"<?php echo $po_fp->d_05_head->editAttributes() ?>></div>
<div id="dsl_x_d_05_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_05_head->radioButtonListHtml(FALSE, "x_d_05_head", 4) ?>
</div></div>
<?php echo $po_fp->d_05_head->Lookup->getParamTag("p_x_d_05_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label for="x_description_05" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_05"><?php echo $po_fp->description_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_05" id="z_description_05" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_05->cellAttributes() ?>>
			<span id="el_po_fp_description_05">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_description_05" data-page="4" data-value-separator="<?php echo $po_fp->description_05->displayValueSeparatorAttribute() ?>" id="x_description_05" name="x_description_05"<?php echo $po_fp->description_05->editAttributes() ?>>
		<?php echo $po_fp->description_05->selectOptionListHtml("x_description_05") ?>
	</select>
</div>
<?php echo $po_fp->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_06_head->Visible) { // d_06_head ?>
	<div id="r_d_06_head" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_06_head"><?php echo $po_fp->d_06_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_06_head" id="z_d_06_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_06_head->cellAttributes() ?>>
			<span id="el_po_fp_d_06_head">
<div id="tp_x_d_06_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_06_head" data-page="4" data-value-separator="<?php echo $po_fp->d_06_head->displayValueSeparatorAttribute() ?>" name="x_d_06_head" id="x_d_06_head" value="{value}"<?php echo $po_fp->d_06_head->editAttributes() ?>></div>
<div id="dsl_x_d_06_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_06_head->radioButtonListHtml(FALSE, "x_d_06_head", 4) ?>
</div></div>
<?php echo $po_fp->d_06_head->Lookup->getParamTag("p_x_d_06_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label for="x_description_06" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_06"><?php echo $po_fp->description_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_06" id="z_description_06" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_06->cellAttributes() ?>>
			<span id="el_po_fp_description_06">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_description_06" data-page="4" data-value-separator="<?php echo $po_fp->description_06->displayValueSeparatorAttribute() ?>" id="x_description_06" name="x_description_06"<?php echo $po_fp->description_06->editAttributes() ?>>
		<?php echo $po_fp->description_06->selectOptionListHtml("x_description_06") ?>
	</select>
</div>
<?php echo $po_fp->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_07_head->Visible) { // d_07_head ?>
	<div id="r_d_07_head" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_07_head"><?php echo $po_fp->d_07_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_07_head" id="z_d_07_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_07_head->cellAttributes() ?>>
			<span id="el_po_fp_d_07_head">
<div id="tp_x_d_07_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_07_head" data-page="4" data-value-separator="<?php echo $po_fp->d_07_head->displayValueSeparatorAttribute() ?>" name="x_d_07_head" id="x_d_07_head" value="{value}"<?php echo $po_fp->d_07_head->editAttributes() ?>></div>
<div id="dsl_x_d_07_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_07_head->radioButtonListHtml(FALSE, "x_d_07_head", 4) ?>
</div></div>
<?php echo $po_fp->d_07_head->Lookup->getParamTag("p_x_d_07_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label for="x_description_07" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_07"><?php echo $po_fp->description_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_07" id="z_description_07" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_07->cellAttributes() ?>>
			<span id="el_po_fp_description_07">
<input type="text" data-table="po_fp" data-field="x_description_07" data-page="4" name="x_description_07" id="x_description_07" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_fp->description_07->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_07->EditValue ?>"<?php echo $po_fp->description_07->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_08_head->Visible) { // d_08_head ?>
	<div id="r_d_08_head" class="form-group row">
		<label class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_08_head"><?php echo $po_fp->d_08_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_08_head" id="z_d_08_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_08_head->cellAttributes() ?>>
			<span id="el_po_fp_d_08_head">
<div id="tp_x_d_08_head" class="ew-template"><input type="radio" class="form-check-input" data-table="po_fp" data-field="x_d_08_head" data-page="4" data-value-separator="<?php echo $po_fp->d_08_head->displayValueSeparatorAttribute() ?>" name="x_d_08_head" id="x_d_08_head" value="{value}"<?php echo $po_fp->d_08_head->editAttributes() ?>></div>
<div id="dsl_x_d_08_head" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $po_fp->d_08_head->radioButtonListHtml(FALSE, "x_d_08_head", 4) ?>
</div></div>
<?php echo $po_fp->d_08_head->Lookup->getParamTag("p_x_d_08_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label for="x_description_08" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_08"><?php echo $po_fp->description_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_08" id="z_description_08" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_08->cellAttributes() ?>>
			<span id="el_po_fp_description_08">
<input type="text" data-table="po_fp" data-field="x_description_08" data-page="4" name="x_description_08" id="x_description_08" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_fp->description_08->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_08->EditValue ?>"<?php echo $po_fp->description_08->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_search->MultiPages->pageStyle("5") ?>" id="tab_po_fp5"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_fp->d_09_head->Visible) { // d_09_head ?>
	<div id="r_d_09_head" class="form-group row">
		<label for="x_d_09_head" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_09_head"><?php echo $po_fp->d_09_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_09_head" id="z_d_09_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_09_head->cellAttributes() ?>>
			<span id="el_po_fp_d_09_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_d_09_head" data-page="5" data-value-separator="<?php echo $po_fp->d_09_head->displayValueSeparatorAttribute() ?>" id="x_d_09_head" name="x_d_09_head"<?php echo $po_fp->d_09_head->editAttributes() ?>>
		<?php echo $po_fp->d_09_head->selectOptionListHtml("x_d_09_head") ?>
	</select>
</div>
<?php echo $po_fp->d_09_head->Lookup->getParamTag("p_x_d_09_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_09->Visible) { // description_09 ?>
	<div id="r_description_09" class="form-group row">
		<label for="x_description_09" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_09"><?php echo $po_fp->description_09->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_09" id="z_description_09" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_09->cellAttributes() ?>>
			<span id="el_po_fp_description_09">
<input type="text" data-table="po_fp" data-field="x_description_09" data-page="5" name="x_description_09" id="x_description_09" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->description_09->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_09->EditValue ?>"<?php echo $po_fp->description_09->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_10_head->Visible) { // d_10_head ?>
	<div id="r_d_10_head" class="form-group row">
		<label for="x_d_10_head" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_10_head"><?php echo $po_fp->d_10_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_10_head" id="z_d_10_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_10_head->cellAttributes() ?>>
			<span id="el_po_fp_d_10_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_d_10_head" data-page="5" data-value-separator="<?php echo $po_fp->d_10_head->displayValueSeparatorAttribute() ?>" id="x_d_10_head" name="x_d_10_head"<?php echo $po_fp->d_10_head->editAttributes() ?>>
		<?php echo $po_fp->d_10_head->selectOptionListHtml("x_d_10_head") ?>
	</select>
</div>
<?php echo $po_fp->d_10_head->Lookup->getParamTag("p_x_d_10_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_10->Visible) { // description_10 ?>
	<div id="r_description_10" class="form-group row">
		<label for="x_description_10" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_10"><?php echo $po_fp->description_10->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_10" id="z_description_10" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_10->cellAttributes() ?>>
			<span id="el_po_fp_description_10">
<input type="text" data-table="po_fp" data-field="x_description_10" data-page="5" name="x_description_10" id="x_description_10" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->description_10->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_10->EditValue ?>"<?php echo $po_fp->description_10->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_11_head->Visible) { // d_11_head ?>
	<div id="r_d_11_head" class="form-group row">
		<label for="x_d_11_head" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_11_head"><?php echo $po_fp->d_11_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_11_head" id="z_d_11_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_11_head->cellAttributes() ?>>
			<span id="el_po_fp_d_11_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_d_11_head" data-page="5" data-value-separator="<?php echo $po_fp->d_11_head->displayValueSeparatorAttribute() ?>" id="x_d_11_head" name="x_d_11_head"<?php echo $po_fp->d_11_head->editAttributes() ?>>
		<?php echo $po_fp->d_11_head->selectOptionListHtml("x_d_11_head") ?>
	</select>
</div>
<?php echo $po_fp->d_11_head->Lookup->getParamTag("p_x_d_11_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_11->Visible) { // description_11 ?>
	<div id="r_description_11" class="form-group row">
		<label for="x_description_11" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_11"><?php echo $po_fp->description_11->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_11" id="z_description_11" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_11->cellAttributes() ?>>
			<span id="el_po_fp_description_11">
<input type="text" data-table="po_fp" data-field="x_description_11" data-page="5" name="x_description_11" id="x_description_11" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->description_11->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_11->EditValue ?>"<?php echo $po_fp->description_11->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->d_12_head->Visible) { // d_12_head ?>
	<div id="r_d_12_head" class="form-group row">
		<label for="x_d_12_head" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_d_12_head"><?php echo $po_fp->d_12_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_12_head" id="z_d_12_head" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->d_12_head->cellAttributes() ?>>
			<span id="el_po_fp_d_12_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_d_12_head" data-page="5" data-value-separator="<?php echo $po_fp->d_12_head->displayValueSeparatorAttribute() ?>" id="x_d_12_head" name="x_d_12_head"<?php echo $po_fp->d_12_head->editAttributes() ?>>
		<?php echo $po_fp->d_12_head->selectOptionListHtml("x_d_12_head") ?>
	</select>
</div>
<?php echo $po_fp->d_12_head->Lookup->getParamTag("p_x_d_12_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->description_12->Visible) { // description_12 ?>
	<div id="r_description_12" class="form-group row">
		<label for="x_description_12" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_description_12"><?php echo $po_fp->description_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_12" id="z_description_12" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->description_12->cellAttributes() ?>>
			<span id="el_po_fp_description_12">
<input type="text" data-table="po_fp" data-field="x_description_12" data-page="5" name="x_description_12" id="x_description_12" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_fp->description_12->getPlaceHolder()) ?>" value="<?php echo $po_fp->description_12->EditValue ?>"<?php echo $po_fp->description_12->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_fp_search->MultiPages->pageStyle("6") ?>" id="tab_po_fp6"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_fp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_operator"><?php echo $po_fp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->operator->cellAttributes() ?>>
			<span id="el_po_fp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_operator" data-page="6" data-value-separator="<?php echo $po_fp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $po_fp->operator->editAttributes() ?>>
		<?php echo $po_fp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $po_fp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_datetime"><?php echo $po_fp->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->datetime->cellAttributes() ?>>
			<span id="el_po_fp_datetime">
<input type="text" data-table="po_fp" data-field="x_datetime" data-page="6" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($po_fp->datetime->getPlaceHolder()) ?>" value="<?php echo $po_fp->datetime->EditValue ?>"<?php echo $po_fp->datetime->editAttributes() ?>>
<?php if (!$po_fp->datetime->ReadOnly && !$po_fp->datetime->Disabled && !isset($po_fp->datetime->EditAttrs["readonly"]) && !isset($po_fp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_a_operator"><?php echo $po_fp->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->a_operator->cellAttributes() ?>>
			<span id="el_po_fp_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_fp" data-field="x_a_operator" data-page="6" data-value-separator="<?php echo $po_fp->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $po_fp->a_operator->editAttributes() ?>>
		<?php echo $po_fp->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $po_fp->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_fp->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $po_fp_search->LeftColumnClass ?>"><span id="elh_po_fp_a_datetime"><?php echo $po_fp->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_fp_search->RightColumnClass ?>"><div<?php echo $po_fp->a_datetime->cellAttributes() ?>>
			<span id="el_po_fp_a_datetime">
<input type="text" data-table="po_fp" data-field="x_a_datetime" data-page="6" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($po_fp->a_datetime->getPlaceHolder()) ?>" value="<?php echo $po_fp->a_datetime->EditValue ?>"<?php echo $po_fp->a_datetime->editAttributes() ?>>
<?php if (!$po_fp->a_datetime->ReadOnly && !$po_fp->a_datetime->Disabled && !isset($po_fp->a_datetime->EditAttrs["readonly"]) && !isset($po_fp->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fpsearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
	</div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?php if (!$po_fp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_fp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_fp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_fp_search->terminate();
?>