<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_fp_view = new po_fp_view();

// Run the page
$po_fp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_fp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpo_fpview = currentForm = new ew.Form("fpo_fpview", "view");

// Form_CustomValidate event
fpo_fpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_fpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_fpview.multiPage = new ew.MultiPage("fpo_fpview");

// Dynamic selection lists
fpo_fpview.lists["x_grp"] = <?php echo $po_fp_view->grp->Lookup->toClientList() ?>;
fpo_fpview.lists["x_grp"].options = <?php echo JsonEncode($po_fp_view->grp->options(FALSE, TRUE)) ?>;
fpo_fpview.lists["x_buyer_id"] = <?php echo $po_fp_view->buyer_id->Lookup->toClientList() ?>;
fpo_fpview.lists["x_buyer_id"].options = <?php echo JsonEncode($po_fp_view->buyer_id->lookupOptions()) ?>;
fpo_fpview.lists["x_buyer_product_ref"] = <?php echo $po_fp_view->buyer_product_ref->Lookup->toClientList() ?>;
fpo_fpview.lists["x_buyer_product_ref"].options = <?php echo JsonEncode($po_fp_view->buyer_product_ref->lookupOptions()) ?>;
fpo_fpview.lists["x_s_grp"] = <?php echo $po_fp_view->s_grp->Lookup->toClientList() ?>;
fpo_fpview.lists["x_s_grp"].options = <?php echo JsonEncode($po_fp_view->s_grp->lookupOptions()) ?>;
fpo_fpview.autoSuggests["x_s_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpview.lists["x_product"] = <?php echo $po_fp_view->product->Lookup->toClientList() ?>;
fpo_fpview.lists["x_product"].options = <?php echo JsonEncode($po_fp_view->product->lookupOptions()) ?>;
fpo_fpview.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpview.lists["x_rid"] = <?php echo $po_fp_view->rid->Lookup->toClientList() ?>;
fpo_fpview.lists["x_rid"].options = <?php echo JsonEncode($po_fp_view->rid->lookupOptions()) ?>;
fpo_fpview.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fpview.lists["x_production_plan"] = <?php echo $po_fp_view->production_plan->Lookup->toClientList() ?>;
fpo_fpview.lists["x_production_plan"].options = <?php echo JsonEncode($po_fp_view->production_plan->options(FALSE, TRUE)) ?>;
fpo_fpview.lists["x_d_01_head"] = <?php echo $po_fp_view->d_01_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_01_head"].options = <?php echo JsonEncode($po_fp_view->d_01_head->lookupOptions()) ?>;
fpo_fpview.lists["x_d_02_head"] = <?php echo $po_fp_view->d_02_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_02_head"].options = <?php echo JsonEncode($po_fp_view->d_02_head->lookupOptions()) ?>;
fpo_fpview.lists["x_d_03_head"] = <?php echo $po_fp_view->d_03_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_03_head"].options = <?php echo JsonEncode($po_fp_view->d_03_head->lookupOptions()) ?>;
fpo_fpview.lists["x_description_03"] = <?php echo $po_fp_view->description_03->Lookup->toClientList() ?>;
fpo_fpview.lists["x_description_03"].options = <?php echo JsonEncode($po_fp_view->description_03->lookupOptions()) ?>;
fpo_fpview.lists["x_d_04_head"] = <?php echo $po_fp_view->d_04_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_04_head"].options = <?php echo JsonEncode($po_fp_view->d_04_head->lookupOptions()) ?>;
fpo_fpview.lists["x_description_04"] = <?php echo $po_fp_view->description_04->Lookup->toClientList() ?>;
fpo_fpview.lists["x_description_04"].options = <?php echo JsonEncode($po_fp_view->description_04->lookupOptions()) ?>;
fpo_fpview.lists["x_d_05_head"] = <?php echo $po_fp_view->d_05_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_05_head"].options = <?php echo JsonEncode($po_fp_view->d_05_head->lookupOptions()) ?>;
fpo_fpview.lists["x_description_05"] = <?php echo $po_fp_view->description_05->Lookup->toClientList() ?>;
fpo_fpview.lists["x_description_05"].options = <?php echo JsonEncode($po_fp_view->description_05->lookupOptions()) ?>;
fpo_fpview.lists["x_d_06_head"] = <?php echo $po_fp_view->d_06_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_06_head"].options = <?php echo JsonEncode($po_fp_view->d_06_head->lookupOptions()) ?>;
fpo_fpview.lists["x_description_06"] = <?php echo $po_fp_view->description_06->Lookup->toClientList() ?>;
fpo_fpview.lists["x_description_06"].options = <?php echo JsonEncode($po_fp_view->description_06->lookupOptions()) ?>;
fpo_fpview.lists["x_d_07_head"] = <?php echo $po_fp_view->d_07_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_07_head"].options = <?php echo JsonEncode($po_fp_view->d_07_head->lookupOptions()) ?>;
fpo_fpview.lists["x_d_08_head"] = <?php echo $po_fp_view->d_08_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_08_head"].options = <?php echo JsonEncode($po_fp_view->d_08_head->lookupOptions()) ?>;
fpo_fpview.lists["x_d_09_head"] = <?php echo $po_fp_view->d_09_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_09_head"].options = <?php echo JsonEncode($po_fp_view->d_09_head->lookupOptions()) ?>;
fpo_fpview.lists["x_d_10_head"] = <?php echo $po_fp_view->d_10_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_10_head"].options = <?php echo JsonEncode($po_fp_view->d_10_head->lookupOptions()) ?>;
fpo_fpview.lists["x_d_11_head"] = <?php echo $po_fp_view->d_11_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_11_head"].options = <?php echo JsonEncode($po_fp_view->d_11_head->lookupOptions()) ?>;
fpo_fpview.lists["x_d_12_head"] = <?php echo $po_fp_view->d_12_head->Lookup->toClientList() ?>;
fpo_fpview.lists["x_d_12_head"].options = <?php echo JsonEncode($po_fp_view->d_12_head->lookupOptions()) ?>;
fpo_fpview.lists["x_operator"] = <?php echo $po_fp_view->operator->Lookup->toClientList() ?>;
fpo_fpview.lists["x_operator"].options = <?php echo JsonEncode($po_fp_view->operator->lookupOptions()) ?>;
fpo_fpview.lists["x_a_operator"] = <?php echo $po_fp_view->a_operator->Lookup->toClientList() ?>;
fpo_fpview.lists["x_a_operator"].options = <?php echo JsonEncode($po_fp_view->a_operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $po_fp_view->ExportOptions->render("body") ?>
<?php $po_fp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $po_fp_view->showPageHeader(); ?>
<?php
$po_fp_view->showMessage();
?>
<form name="fpo_fpview" id="fpo_fpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_fp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_fp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_fp">
<input type="hidden" name="modal" value="<?php echo (int)$po_fp_view->IsModal ?>">
<?php if ($po_fp_view->MultiPages->Items[0]->Visible) { ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_fp->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_grp"><?php echo $po_fp->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $po_fp->grp->cellAttributes() ?>>
<span id="el_po_fp_grp" data-page="0">
<span<?php echo $po_fp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($po_fp->grp->getViewValue())) && $po_fp->grp->linkAttributes() <> "") { ?>
<a<?php echo $po_fp->grp->linkAttributes() ?>><?php echo $po_fp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_fp->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_po"><?php echo $po_fp->po->caption() ?></span></td>
		<td data-name="po"<?php echo $po_fp->po->cellAttributes() ?>>
<span id="el_po_fp_po" data-page="0">
<span<?php echo $po_fp->po->viewAttributes() ?>>
<?php echo $po_fp->po->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->buyer_id->Visible) { // buyer_id ?>
	<tr id="r_buyer_id">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_buyer_id"><?php echo $po_fp->buyer_id->caption() ?></span></td>
		<td data-name="buyer_id"<?php echo $po_fp->buyer_id->cellAttributes() ?>>
<span id="el_po_fp_buyer_id" data-page="0">
<span<?php echo $po_fp->buyer_id->viewAttributes() ?>>
<?php echo $po_fp->buyer_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->buyer_product_ref->Visible) { // buyer_product_ref ?>
	<tr id="r_buyer_product_ref">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_buyer_product_ref"><?php echo $po_fp->buyer_product_ref->caption() ?></span></td>
		<td data-name="buyer_product_ref"<?php echo $po_fp->buyer_product_ref->cellAttributes() ?>>
<span id="el_po_fp_buyer_product_ref" data-page="0">
<span<?php echo $po_fp->buyer_product_ref->viewAttributes() ?>>
<?php echo $po_fp->buyer_product_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_s_grp"><?php echo $po_fp->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $po_fp->s_grp->cellAttributes() ?>>
<span id="el_po_fp_s_grp" data-page="0">
<span<?php echo $po_fp->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($po_fp->s_grp->getViewValue())) && $po_fp->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $po_fp->s_grp->linkAttributes() ?>><?php echo $po_fp->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_fp->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_product"><?php echo $po_fp->product->caption() ?></span></td>
		<td data-name="product"<?php echo $po_fp->product->cellAttributes() ?>>
<span id="el_po_fp_product" data-page="0">
<span<?php echo $po_fp->product->viewAttributes() ?>>
<?php if ((!EmptyString($po_fp->product->getViewValue())) && $po_fp->product->linkAttributes() <> "") { ?>
<a<?php echo $po_fp->product->linkAttributes() ?>><?php echo $po_fp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_fp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->rid->Visible) { // rid ?>
	<tr id="r_rid">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_rid"><?php echo $po_fp->rid->caption() ?></span></td>
		<td data-name="rid"<?php echo $po_fp->rid->cellAttributes() ?>>
<span id="el_po_fp_rid" data-page="0">
<span<?php echo $po_fp->rid->viewAttributes() ?>>
<?php if ((!EmptyString($po_fp->rid->getViewValue())) && $po_fp->rid->linkAttributes() <> "") { ?>
<a<?php echo $po_fp->rid->linkAttributes() ?>><?php echo $po_fp->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_fp->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
<div class="ew-multi-page">
<div class="ew-nav-tabs" id="po_fp_view"><!-- multi-page tabs -->
	<ul class="<?php echo $po_fp_view->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_view->MultiPages->pageStyle("1") ?>" href="#tab_po_fp1" data-toggle="tab"><?php echo $po_fp->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_view->MultiPages->pageStyle("2") ?>" href="#tab_po_fp2" data-toggle="tab"><?php echo $po_fp->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_view->MultiPages->pageStyle("3") ?>" href="#tab_po_fp3" data-toggle="tab"><?php echo $po_fp->pageCaption(3) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_view->MultiPages->pageStyle("4") ?>" href="#tab_po_fp4" data-toggle="tab"><?php echo $po_fp->pageCaption(4) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_view->MultiPages->pageStyle("5") ?>" href="#tab_po_fp5" data-toggle="tab"><?php echo $po_fp->pageCaption(5) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_fp_view->MultiPages->pageStyle("6") ?>" href="#tab_po_fp6" data-toggle="tab"><?php echo $po_fp->pageCaption(6) ?></a></li>
	</ul>
	<div class="tab-content">
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
		<div class="tab-pane<?php echo $po_fp_view->MultiPages->pageStyle("1") ?>" id="tab_po_fp1"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_fp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_id"><?php echo $po_fp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $po_fp->id->cellAttributes() ?>>
<span id="el_po_fp_id" data-page="1">
<span<?php echo $po_fp->id->viewAttributes() ?>>
<?php echo $po_fp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->jc_no->Visible) { // jc_no ?>
	<tr id="r_jc_no">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_jc_no"><?php echo $po_fp->jc_no->caption() ?></span></td>
		<td data-name="jc_no"<?php echo $po_fp->jc_no->cellAttributes() ?>>
<span id="el_po_fp_jc_no" data-page="1">
<span<?php echo $po_fp->jc_no->viewAttributes() ?>>
<?php echo $po_fp->jc_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->balance_quantity->Visible) { // balance_quantity ?>
	<tr id="r_balance_quantity">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_balance_quantity"><?php echo $po_fp->balance_quantity->caption() ?></span></td>
		<td data-name="balance_quantity"<?php echo $po_fp->balance_quantity->cellAttributes() ?>>
<span id="el_po_fp_balance_quantity" data-page="1">
<span<?php echo $po_fp->balance_quantity->viewAttributes() ?>>
<?php echo $po_fp->balance_quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->buyer_order_no->Visible) { // buyer_order_no ?>
	<tr id="r_buyer_order_no">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_buyer_order_no"><?php echo $po_fp->buyer_order_no->caption() ?></span></td>
		<td data-name="buyer_order_no"<?php echo $po_fp->buyer_order_no->cellAttributes() ?>>
<span id="el_po_fp_buyer_order_no" data-page="1">
<span<?php echo $po_fp->buyer_order_no->viewAttributes() ?>>
<?php echo $po_fp->buyer_order_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->buyer_order_date->Visible) { // buyer_order_date ?>
	<tr id="r_buyer_order_date">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_buyer_order_date"><?php echo $po_fp->buyer_order_date->caption() ?></span></td>
		<td data-name="buyer_order_date"<?php echo $po_fp->buyer_order_date->cellAttributes() ?>>
<span id="el_po_fp_buyer_order_date" data-page="1">
<span<?php echo $po_fp->buyer_order_date->viewAttributes() ?>>
<?php echo $po_fp->buyer_order_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->buyer_instruction->Visible) { // buyer_instruction ?>
	<tr id="r_buyer_instruction">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_buyer_instruction"><?php echo $po_fp->buyer_instruction->caption() ?></span></td>
		<td data-name="buyer_instruction"<?php echo $po_fp->buyer_instruction->cellAttributes() ?>>
<span id="el_po_fp_buyer_instruction" data-page="1">
<span<?php echo $po_fp->buyer_instruction->viewAttributes() ?>>
<?php echo $po_fp->buyer_instruction->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_remarks"><?php echo $po_fp->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $po_fp->remarks->cellAttributes() ?>>
<span id="el_po_fp_remarks" data-page="1">
<span<?php echo $po_fp->remarks->viewAttributes() ?>>
<?php echo $po_fp->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->production_site->Visible) { // production_site ?>
	<tr id="r_production_site">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_production_site"><?php echo $po_fp->production_site->caption() ?></span></td>
		<td data-name="production_site"<?php echo $po_fp->production_site->cellAttributes() ?>>
<span id="el_po_fp_production_site" data-page="1">
<span<?php echo $po_fp->production_site->viewAttributes() ?>>
<?php echo $po_fp->production_site->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$po_fp->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
		<div class="tab-pane<?php echo $po_fp_view->MultiPages->pageStyle("2") ?>" id="tab_po_fp2"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_fp->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_quantity"><?php echo $po_fp->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $po_fp->quantity->cellAttributes() ?>>
<span id="el_po_fp_quantity" data-page="2">
<span<?php echo $po_fp->quantity->viewAttributes() ?>>
<?php echo $po_fp->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->price->Visible) { // price ?>
	<tr id="r_price">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_price"><?php echo $po_fp->price->caption() ?></span></td>
		<td data-name="price"<?php echo $po_fp->price->cellAttributes() ?>>
<span id="el_po_fp_price" data-page="2">
<span<?php echo $po_fp->price->viewAttributes() ?>>
<?php echo $po_fp->price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->despatch_date->Visible) { // despatch_date ?>
	<tr id="r_despatch_date">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_despatch_date"><?php echo $po_fp->despatch_date->caption() ?></span></td>
		<td data-name="despatch_date"<?php echo $po_fp->despatch_date->cellAttributes() ?>>
<span id="el_po_fp_despatch_date" data-page="2">
<span<?php echo $po_fp->despatch_date->viewAttributes() ?>>
<?php echo $po_fp->despatch_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->production_plan->Visible) { // production_plan ?>
	<tr id="r_production_plan">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_production_plan"><?php echo $po_fp->production_plan->caption() ?></span></td>
		<td data-name="production_plan"<?php echo $po_fp->production_plan->cellAttributes() ?>>
<span id="el_po_fp_production_plan" data-page="2">
<span<?php echo $po_fp->production_plan->viewAttributes() ?>>
<?php echo $po_fp->production_plan->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->lot_no->Visible) { // lot_no ?>
	<tr id="r_lot_no">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_lot_no"><?php echo $po_fp->lot_no->caption() ?></span></td>
		<td data-name="lot_no"<?php echo $po_fp->lot_no->cellAttributes() ?>>
<span id="el_po_fp_lot_no" data-page="2">
<span<?php echo $po_fp->lot_no->viewAttributes() ?>>
<?php echo $po_fp->lot_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$po_fp->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
		<div class="tab-pane<?php echo $po_fp_view->MultiPages->pageStyle("3") ?>" id="tab_po_fp3"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_fp->d_01_head->Visible) { // d_01_head ?>
	<tr id="r_d_01_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_01_head"><?php echo $po_fp->d_01_head->caption() ?></span></td>
		<td data-name="d_01_head"<?php echo $po_fp->d_01_head->cellAttributes() ?>>
<span id="el_po_fp_d_01_head" data-page="3">
<span<?php echo $po_fp->d_01_head->viewAttributes() ?>>
<?php echo $po_fp->d_01_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_01->Visible) { // description_01 ?>
	<tr id="r_description_01">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_01"><?php echo $po_fp->description_01->caption() ?></span></td>
		<td data-name="description_01"<?php echo $po_fp->description_01->cellAttributes() ?>>
<span id="el_po_fp_description_01" data-page="3">
<span<?php echo $po_fp->description_01->viewAttributes() ?>>
<?php echo $po_fp->description_01->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_02_head->Visible) { // d_02_head ?>
	<tr id="r_d_02_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_02_head"><?php echo $po_fp->d_02_head->caption() ?></span></td>
		<td data-name="d_02_head"<?php echo $po_fp->d_02_head->cellAttributes() ?>>
<span id="el_po_fp_d_02_head" data-page="3">
<span<?php echo $po_fp->d_02_head->viewAttributes() ?>>
<?php echo $po_fp->d_02_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_02->Visible) { // description_02 ?>
	<tr id="r_description_02">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_02"><?php echo $po_fp->description_02->caption() ?></span></td>
		<td data-name="description_02"<?php echo $po_fp->description_02->cellAttributes() ?>>
<span id="el_po_fp_description_02" data-page="3">
<span<?php echo $po_fp->description_02->viewAttributes() ?>>
<?php echo $po_fp->description_02->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_03_head->Visible) { // d_03_head ?>
	<tr id="r_d_03_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_03_head"><?php echo $po_fp->d_03_head->caption() ?></span></td>
		<td data-name="d_03_head"<?php echo $po_fp->d_03_head->cellAttributes() ?>>
<span id="el_po_fp_d_03_head" data-page="3">
<span<?php echo $po_fp->d_03_head->viewAttributes() ?>>
<?php echo $po_fp->d_03_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_03->Visible) { // description_03 ?>
	<tr id="r_description_03">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_03"><?php echo $po_fp->description_03->caption() ?></span></td>
		<td data-name="description_03"<?php echo $po_fp->description_03->cellAttributes() ?>>
<span id="el_po_fp_description_03" data-page="3">
<span<?php echo $po_fp->description_03->viewAttributes() ?>>
<?php echo $po_fp->description_03->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_04_head->Visible) { // d_04_head ?>
	<tr id="r_d_04_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_04_head"><?php echo $po_fp->d_04_head->caption() ?></span></td>
		<td data-name="d_04_head"<?php echo $po_fp->d_04_head->cellAttributes() ?>>
<span id="el_po_fp_d_04_head" data-page="3">
<span<?php echo $po_fp->d_04_head->viewAttributes() ?>>
<?php echo $po_fp->d_04_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_04->Visible) { // description_04 ?>
	<tr id="r_description_04">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_04"><?php echo $po_fp->description_04->caption() ?></span></td>
		<td data-name="description_04"<?php echo $po_fp->description_04->cellAttributes() ?>>
<span id="el_po_fp_description_04" data-page="3">
<span<?php echo $po_fp->description_04->viewAttributes() ?>>
<?php echo $po_fp->description_04->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$po_fp->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
		<div class="tab-pane<?php echo $po_fp_view->MultiPages->pageStyle("4") ?>" id="tab_po_fp4"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_fp->d_05_head->Visible) { // d_05_head ?>
	<tr id="r_d_05_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_05_head"><?php echo $po_fp->d_05_head->caption() ?></span></td>
		<td data-name="d_05_head"<?php echo $po_fp->d_05_head->cellAttributes() ?>>
<span id="el_po_fp_d_05_head" data-page="4">
<span<?php echo $po_fp->d_05_head->viewAttributes() ?>>
<?php echo $po_fp->d_05_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_05->Visible) { // description_05 ?>
	<tr id="r_description_05">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_05"><?php echo $po_fp->description_05->caption() ?></span></td>
		<td data-name="description_05"<?php echo $po_fp->description_05->cellAttributes() ?>>
<span id="el_po_fp_description_05" data-page="4">
<span<?php echo $po_fp->description_05->viewAttributes() ?>>
<?php echo $po_fp->description_05->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_06_head->Visible) { // d_06_head ?>
	<tr id="r_d_06_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_06_head"><?php echo $po_fp->d_06_head->caption() ?></span></td>
		<td data-name="d_06_head"<?php echo $po_fp->d_06_head->cellAttributes() ?>>
<span id="el_po_fp_d_06_head" data-page="4">
<span<?php echo $po_fp->d_06_head->viewAttributes() ?>>
<?php echo $po_fp->d_06_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_06->Visible) { // description_06 ?>
	<tr id="r_description_06">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_06"><?php echo $po_fp->description_06->caption() ?></span></td>
		<td data-name="description_06"<?php echo $po_fp->description_06->cellAttributes() ?>>
<span id="el_po_fp_description_06" data-page="4">
<span<?php echo $po_fp->description_06->viewAttributes() ?>>
<?php echo $po_fp->description_06->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_07_head->Visible) { // d_07_head ?>
	<tr id="r_d_07_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_07_head"><?php echo $po_fp->d_07_head->caption() ?></span></td>
		<td data-name="d_07_head"<?php echo $po_fp->d_07_head->cellAttributes() ?>>
<span id="el_po_fp_d_07_head" data-page="4">
<span<?php echo $po_fp->d_07_head->viewAttributes() ?>>
<?php echo $po_fp->d_07_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_07->Visible) { // description_07 ?>
	<tr id="r_description_07">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_07"><?php echo $po_fp->description_07->caption() ?></span></td>
		<td data-name="description_07"<?php echo $po_fp->description_07->cellAttributes() ?>>
<span id="el_po_fp_description_07" data-page="4">
<span<?php echo $po_fp->description_07->viewAttributes() ?>>
<?php echo $po_fp->description_07->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_08_head->Visible) { // d_08_head ?>
	<tr id="r_d_08_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_08_head"><?php echo $po_fp->d_08_head->caption() ?></span></td>
		<td data-name="d_08_head"<?php echo $po_fp->d_08_head->cellAttributes() ?>>
<span id="el_po_fp_d_08_head" data-page="4">
<span<?php echo $po_fp->d_08_head->viewAttributes() ?>>
<?php echo $po_fp->d_08_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_08->Visible) { // description_08 ?>
	<tr id="r_description_08">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_08"><?php echo $po_fp->description_08->caption() ?></span></td>
		<td data-name="description_08"<?php echo $po_fp->description_08->cellAttributes() ?>>
<span id="el_po_fp_description_08" data-page="4">
<span<?php echo $po_fp->description_08->viewAttributes() ?>>
<?php echo $po_fp->description_08->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$po_fp->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
		<div class="tab-pane<?php echo $po_fp_view->MultiPages->pageStyle("5") ?>" id="tab_po_fp5"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_fp->d_09_head->Visible) { // d_09_head ?>
	<tr id="r_d_09_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_09_head"><?php echo $po_fp->d_09_head->caption() ?></span></td>
		<td data-name="d_09_head"<?php echo $po_fp->d_09_head->cellAttributes() ?>>
<span id="el_po_fp_d_09_head" data-page="5">
<span<?php echo $po_fp->d_09_head->viewAttributes() ?>>
<?php echo $po_fp->d_09_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_09->Visible) { // description_09 ?>
	<tr id="r_description_09">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_09"><?php echo $po_fp->description_09->caption() ?></span></td>
		<td data-name="description_09"<?php echo $po_fp->description_09->cellAttributes() ?>>
<span id="el_po_fp_description_09" data-page="5">
<span<?php echo $po_fp->description_09->viewAttributes() ?>>
<?php echo $po_fp->description_09->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_10_head->Visible) { // d_10_head ?>
	<tr id="r_d_10_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_10_head"><?php echo $po_fp->d_10_head->caption() ?></span></td>
		<td data-name="d_10_head"<?php echo $po_fp->d_10_head->cellAttributes() ?>>
<span id="el_po_fp_d_10_head" data-page="5">
<span<?php echo $po_fp->d_10_head->viewAttributes() ?>>
<?php echo $po_fp->d_10_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_10->Visible) { // description_10 ?>
	<tr id="r_description_10">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_10"><?php echo $po_fp->description_10->caption() ?></span></td>
		<td data-name="description_10"<?php echo $po_fp->description_10->cellAttributes() ?>>
<span id="el_po_fp_description_10" data-page="5">
<span<?php echo $po_fp->description_10->viewAttributes() ?>>
<?php echo $po_fp->description_10->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_11_head->Visible) { // d_11_head ?>
	<tr id="r_d_11_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_11_head"><?php echo $po_fp->d_11_head->caption() ?></span></td>
		<td data-name="d_11_head"<?php echo $po_fp->d_11_head->cellAttributes() ?>>
<span id="el_po_fp_d_11_head" data-page="5">
<span<?php echo $po_fp->d_11_head->viewAttributes() ?>>
<?php echo $po_fp->d_11_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_11->Visible) { // description_11 ?>
	<tr id="r_description_11">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_11"><?php echo $po_fp->description_11->caption() ?></span></td>
		<td data-name="description_11"<?php echo $po_fp->description_11->cellAttributes() ?>>
<span id="el_po_fp_description_11" data-page="5">
<span<?php echo $po_fp->description_11->viewAttributes() ?>>
<?php echo $po_fp->description_11->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->d_12_head->Visible) { // d_12_head ?>
	<tr id="r_d_12_head">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_d_12_head"><?php echo $po_fp->d_12_head->caption() ?></span></td>
		<td data-name="d_12_head"<?php echo $po_fp->d_12_head->cellAttributes() ?>>
<span id="el_po_fp_d_12_head" data-page="5">
<span<?php echo $po_fp->d_12_head->viewAttributes() ?>>
<?php echo $po_fp->d_12_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->description_12->Visible) { // description_12 ?>
	<tr id="r_description_12">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_description_12"><?php echo $po_fp->description_12->caption() ?></span></td>
		<td data-name="description_12"<?php echo $po_fp->description_12->cellAttributes() ?>>
<span id="el_po_fp_description_12" data-page="5">
<span<?php echo $po_fp->description_12->viewAttributes() ?>>
<?php echo $po_fp->description_12->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$po_fp->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
		<div class="tab-pane<?php echo $po_fp_view->MultiPages->pageStyle("6") ?>" id="tab_po_fp6"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_fp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_operator"><?php echo $po_fp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $po_fp->operator->cellAttributes() ?>>
<span id="el_po_fp_operator" data-page="6">
<span<?php echo $po_fp->operator->viewAttributes() ?>>
<?php echo $po_fp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_datetime"><?php echo $po_fp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $po_fp->datetime->cellAttributes() ?>>
<span id="el_po_fp_datetime" data-page="6">
<span<?php echo $po_fp->datetime->viewAttributes() ?>>
<?php echo $po_fp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->a_operator->Visible) { // a_operator ?>
	<tr id="r_a_operator">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_a_operator"><?php echo $po_fp->a_operator->caption() ?></span></td>
		<td data-name="a_operator"<?php echo $po_fp->a_operator->cellAttributes() ?>>
<span id="el_po_fp_a_operator" data-page="6">
<span<?php echo $po_fp->a_operator->viewAttributes() ?>>
<?php echo $po_fp->a_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_fp->a_datetime->Visible) { // a_datetime ?>
	<tr id="r_a_datetime">
		<td class="<?php echo $po_fp_view->TableLeftColumnClass ?>"><span id="elh_po_fp_a_datetime"><?php echo $po_fp->a_datetime->caption() ?></span></td>
		<td data-name="a_datetime"<?php echo $po_fp->a_datetime->cellAttributes() ?>>
<span id="el_po_fp_a_datetime" data-page="6">
<span<?php echo $po_fp->a_datetime->viewAttributes() ?>>
<?php echo $po_fp->a_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$po_fp->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$po_fp->isExport()) { ?>
	</div>
</div>
</div>
<?php } ?>
</form>
<?php
$po_fp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_fp_view->terminate();
?>