<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_f_search = new po_f_search();

// Run the page
$po_f_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_f_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_f_search->IsModal) { ?>
var fpo_fsearch = currentAdvancedSearchForm = new ew.Form("fpo_fsearch", "search");
<?php } else { ?>
var fpo_fsearch = currentForm = new ew.Form("fpo_fsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_fsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_fsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
fpo_fsearch.multiPage = new ew.MultiPage("fpo_fsearch");

// Dynamic selection lists
fpo_fsearch.lists["x_grp"] = <?php echo $po_f_search->grp->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_grp"].options = <?php echo JsonEncode($po_f_search->grp->options(FALSE, TRUE)) ?>;
fpo_fsearch.lists["x_buyer_id"] = <?php echo $po_f_search->buyer_id->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($po_f_search->buyer_id->lookupOptions()) ?>;
fpo_fsearch.lists["x_s_grp"] = <?php echo $po_f_search->s_grp->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_s_grp"].options = <?php echo JsonEncode($po_f_search->s_grp->lookupOptions()) ?>;
fpo_fsearch.lists["x_product"] = <?php echo $po_f_search->product->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_product"].options = <?php echo JsonEncode($po_f_search->product->lookupOptions()) ?>;
fpo_fsearch.lists["x_rid"] = <?php echo $po_f_search->rid->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_rid"].options = <?php echo JsonEncode($po_f_search->rid->lookupOptions()) ?>;
fpo_fsearch.lists["x_despatch_week"] = <?php echo $po_f_search->despatch_week->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_despatch_week"].options = <?php echo JsonEncode($po_f_search->despatch_week->lookupOptions()) ?>;
fpo_fsearch.lists["x_production_plan"] = <?php echo $po_f_search->production_plan->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_production_plan"].options = <?php echo JsonEncode($po_f_search->production_plan->options(FALSE, TRUE)) ?>;
fpo_fsearch.lists["x_description_01"] = <?php echo $po_f_search->description_01->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_description_01"].options = <?php echo JsonEncode($po_f_search->description_01->lookupOptions()) ?>;
fpo_fsearch.autoSuggests["x_description_01"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fsearch.lists["x_description_02"] = <?php echo $po_f_search->description_02->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_description_02"].options = <?php echo JsonEncode($po_f_search->description_02->lookupOptions()) ?>;
fpo_fsearch.autoSuggests["x_description_02"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fsearch.lists["x_description_03"] = <?php echo $po_f_search->description_03->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_description_03"].options = <?php echo JsonEncode($po_f_search->description_03->lookupOptions()) ?>;
fpo_fsearch.lists["x_description_04"] = <?php echo $po_f_search->description_04->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_description_04"].options = <?php echo JsonEncode($po_f_search->description_04->lookupOptions()) ?>;
fpo_fsearch.lists["x_description_05"] = <?php echo $po_f_search->description_05->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_description_05"].options = <?php echo JsonEncode($po_f_search->description_05->lookupOptions()) ?>;
fpo_fsearch.lists["x_description_06"] = <?php echo $po_f_search->description_06->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_description_06"].options = <?php echo JsonEncode($po_f_search->description_06->lookupOptions()) ?>;
fpo_fsearch.lists["x_description_07"] = <?php echo $po_f_search->description_07->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_description_07"].options = <?php echo JsonEncode($po_f_search->description_07->lookupOptions()) ?>;
fpo_fsearch.autoSuggests["x_description_07"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fsearch.lists["x_description_08"] = <?php echo $po_f_search->description_08->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_description_08"].options = <?php echo JsonEncode($po_f_search->description_08->lookupOptions()) ?>;
fpo_fsearch.autoSuggests["x_description_08"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpo_fsearch.lists["x_operator"] = <?php echo $po_f_search->operator->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_operator"].options = <?php echo JsonEncode($po_f_search->operator->lookupOptions()) ?>;
fpo_fsearch.lists["x_a_operator"] = <?php echo $po_f_search->a_operator->Lookup->toClientList() ?>;
fpo_fsearch.lists["x_a_operator"].options = <?php echo JsonEncode($po_f_search->a_operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpo_fsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_f->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkByRegEx(elm.value, /^[0-9]{4,4}$/))
		return this.onError(elm, "<?php echo JsEncode($po_f->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_f->buyer_order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_01");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_f->description_01->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_description_02");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_f->description_02->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_production_site");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_f->production_site->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_f_search->showPageHeader(); ?>
<?php
$po_f_search->showMessage();
?>
<form name="fpo_fsearch" id="fpo_fsearch" class="<?php echo $po_f_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_f_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_f_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_f">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_f_search->IsModal ?>">
<?php if ($po_f_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($po_f->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_grp"><?php echo $po_f->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->grp->cellAttributes() ?>>
			<span id="el_po_f_grp">
<?php $po_f->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_f->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_grp" data-page="0" data-value-separator="<?php echo $po_f->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_f->grp->editAttributes() ?>>
		<?php echo $po_f->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_po"><?php echo $po_f->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->po->cellAttributes() ?>>
			<span id="el_po_f_po">
<input type="text" data-table="po_f" data-field="x_po" data-page="0" name="x_po" id="x_po" size="30" maxlength="4" placeholder="<?php echo HtmlEncode($po_f->po->getPlaceHolder()) ?>" value="<?php echo $po_f->po->EditValue ?>"<?php echo $po_f->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_s_grp"><?php echo $po_f->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->s_grp->cellAttributes() ?>>
			<span id="el_po_f_s_grp">
<?php $po_f->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_f->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_s_grp" data-page="0" data-value-separator="<?php echo $po_f->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $po_f->s_grp->editAttributes() ?>>
		<?php echo $po_f->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $po_f->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_product"><?php echo $po_f->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->product->cellAttributes() ?>>
			<span id="el_po_f_product">
<?php $po_f->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_f->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_product" data-page="0" data-value-separator="<?php echo $po_f->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $po_f->product->editAttributes() ?>>
		<?php echo $po_f->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $po_f->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_rid"><?php echo $po_f->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->rid->cellAttributes() ?>>
			<span id="el_po_f_rid">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_rid" data-page="0" data-value-separator="<?php echo $po_f->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $po_f->rid->editAttributes() ?>>
		<?php echo $po_f->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $po_f->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav-tabs" id="po_f_search"><!-- multi-page tabs -->
	<ul class="<?php echo $po_f_search->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $po_f_search->MultiPages->pageStyle("1") ?>" href="#tab_po_f1" data-toggle="tab"><?php echo $po_f->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_f_search->MultiPages->pageStyle("2") ?>" href="#tab_po_f2" data-toggle="tab"><?php echo $po_f->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_f_search->MultiPages->pageStyle("3") ?>" href="#tab_po_f3" data-toggle="tab"><?php echo $po_f->pageCaption(3) ?></a></li>
		<li class="nav-item d-none"><a class="nav-link" href="#tab_po_f4" data-toggle="tab"></a></li>
		<li class="nav-item d-none"><a class="nav-link" href="#tab_po_f5" data-toggle="tab"></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $po_f_search->MultiPages->pageStyle("6") ?>" href="#tab_po_f6" data-toggle="tab"><?php echo $po_f->pageCaption(6) ?></a></li>
	</ul>
	<div class="tab-content"><!-- multi-page tabs .tab-content -->
		<div class="tab-pane<?php echo $po_f_search->MultiPages->pageStyle("1") ?>" id="tab_po_f1"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_f->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_id"><?php echo $po_f->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->id->cellAttributes() ?>>
			<span id="el_po_f_id">
<input type="text" data-table="po_f" data-field="x_id" data-page="1" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($po_f->id->getPlaceHolder()) ?>" value="<?php echo $po_f->id->EditValue ?>"<?php echo $po_f->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_buyer_id"><?php echo $po_f->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->buyer_id->cellAttributes() ?>>
			<span id="el_po_f_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_buyer_id" data-page="1" data-value-separator="<?php echo $po_f->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po_f->buyer_id->editAttributes() ?>>
		<?php echo $po_f->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $po_f->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_product_ref->Visible) { // buyer_product_ref ?>
	<div id="r_buyer_product_ref" class="form-group row">
		<label for="x_buyer_product_ref" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_buyer_product_ref"><?php echo $po_f->buyer_product_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_product_ref" id="z_buyer_product_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->buyer_product_ref->cellAttributes() ?>>
			<span id="el_po_f_buyer_product_ref">
<input type="text" data-table="po_f" data-field="x_buyer_product_ref" data-page="1" name="x_buyer_product_ref" id="x_buyer_product_ref" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_f->buyer_product_ref->getPlaceHolder()) ?>" value="<?php echo $po_f->buyer_product_ref->EditValue ?>"<?php echo $po_f->buyer_product_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_order_no->Visible) { // buyer_order_no ?>
	<div id="r_buyer_order_no" class="form-group row">
		<label for="x_buyer_order_no" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_buyer_order_no"><?php echo $po_f->buyer_order_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order_no" id="z_buyer_order_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->buyer_order_no->cellAttributes() ?>>
			<span id="el_po_f_buyer_order_no">
<input type="text" data-table="po_f" data-field="x_buyer_order_no" data-page="1" name="x_buyer_order_no" id="x_buyer_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_f->buyer_order_no->getPlaceHolder()) ?>" value="<?php echo $po_f->buyer_order_no->EditValue ?>"<?php echo $po_f->buyer_order_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_order_date->Visible) { // buyer_order_date ?>
	<div id="r_buyer_order_date" class="form-group row">
		<label for="x_buyer_order_date" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_buyer_order_date"><?php echo $po_f->buyer_order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_order_date" id="z_buyer_order_date" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->buyer_order_date->cellAttributes() ?>>
			<span id="el_po_f_buyer_order_date">
<input type="text" data-table="po_f" data-field="x_buyer_order_date" data-page="1" name="x_buyer_order_date" id="x_buyer_order_date" placeholder="<?php echo HtmlEncode($po_f->buyer_order_date->getPlaceHolder()) ?>" value="<?php echo $po_f->buyer_order_date->EditValue ?>"<?php echo $po_f->buyer_order_date->editAttributes() ?>>
<?php if (!$po_f->buyer_order_date->ReadOnly && !$po_f->buyer_order_date->Disabled && !isset($po_f->buyer_order_date->EditAttrs["readonly"]) && !isset($po_f->buyer_order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fsearch", "x_buyer_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->buyer_instruction->Visible) { // buyer_instruction ?>
	<div id="r_buyer_instruction" class="form-group row">
		<label for="x_buyer_instruction" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_buyer_instruction"><?php echo $po_f->buyer_instruction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->buyer_instruction->cellAttributes() ?>>
			<span id="el_po_f_buyer_instruction">
<input type="text" data-table="po_f" data-field="x_buyer_instruction" data-page="1" name="x_buyer_instruction" id="x_buyer_instruction" size="30" placeholder="<?php echo HtmlEncode($po_f->buyer_instruction->getPlaceHolder()) ?>" value="<?php echo $po_f->buyer_instruction->EditValue ?>"<?php echo $po_f->buyer_instruction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->production_site->Visible) { // production_site ?>
	<div id="r_production_site" class="form-group row">
		<label for="x_production_site" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_production_site"><?php echo $po_f->production_site->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_site" id="z_production_site" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->production_site->cellAttributes() ?>>
			<span id="el_po_f_production_site">
<input type="text" data-table="po_f" data-field="x_production_site" data-page="1" name="x_production_site" id="x_production_site" size="30" placeholder="<?php echo HtmlEncode($po_f->production_site->getPlaceHolder()) ?>" value="<?php echo $po_f->production_site->EditValue ?>"<?php echo $po_f->production_site->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_search->MultiPages->pageStyle("2") ?>" id="tab_po_f2"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_f->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_quantity"><?php echo $po_f->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->quantity->cellAttributes() ?>>
			<span id="el_po_f_quantity">
<input type="text" data-table="po_f" data-field="x_quantity" data-page="2" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_f->quantity->getPlaceHolder()) ?>" value="<?php echo $po_f->quantity->EditValue ?>"<?php echo $po_f->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_price"><?php echo $po_f->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->price->cellAttributes() ?>>
			<span id="el_po_f_price">
<input type="text" data-table="po_f" data-field="x_price" data-page="2" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($po_f->price->getPlaceHolder()) ?>" value="<?php echo $po_f->price->EditValue ?>"<?php echo $po_f->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_despatch_week"><?php echo $po_f->despatch_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_week" id="z_despatch_week" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->despatch_week->cellAttributes() ?>>
			<span id="el_po_f_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_despatch_week" data-page="2" data-value-separator="<?php echo $po_f->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $po_f->despatch_week->editAttributes() ?>>
		<?php echo $po_f->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $po_f->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->production_plan->Visible) { // production_plan ?>
	<div id="r_production_plan" class="form-group row">
		<label for="x_production_plan" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_production_plan"><?php echo $po_f->production_plan->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_production_plan" id="z_production_plan" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->production_plan->cellAttributes() ?>>
			<span id="el_po_f_production_plan">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_production_plan" data-page="2" data-value-separator="<?php echo $po_f->production_plan->displayValueSeparatorAttribute() ?>" id="x_production_plan" name="x_production_plan"<?php echo $po_f->production_plan->editAttributes() ?>>
		<?php echo $po_f->production_plan->selectOptionListHtml("x_production_plan") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_search->MultiPages->pageStyle("3") ?>" id="tab_po_f3"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_f->description_01->Visible) { // description_01 ?>
	<div id="r_description_01" class="form-group row">
		<label class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_description_01"><?php echo $po_f->description_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_01" id="z_description_01" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->description_01->cellAttributes() ?>>
			<span id="el_po_f_description_01">
<?php
$wrkonchange = "" . trim(@$po_f->description_01->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_01->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_01" class="text-nowrap" style="z-index: 8790">
	<input type="text" class="form-control" name="sv_x_description_01" id="sv_x_description_01" value="<?php echo RemoveHtml($po_f->description_01->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_f->description_01->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_01->getPlaceHolder()) ?>"<?php echo $po_f->description_01->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_01" data-page="3" data-value-separator="<?php echo $po_f->description_01->displayValueSeparatorAttribute() ?>" name="x_description_01" id="x_description_01" value="<?php echo HtmlEncode($po_f->description_01->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fsearch.createAutoSuggest({"id":"x_description_01","forceSelect":false});
</script>
<?php echo $po_f->description_01->Lookup->getParamTag("p_x_description_01") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_02->Visible) { // description_02 ?>
	<div id="r_description_02" class="form-group row">
		<label class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_description_02"><?php echo $po_f->description_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_02" id="z_description_02" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->description_02->cellAttributes() ?>>
			<span id="el_po_f_description_02">
<?php
$wrkonchange = "" . trim(@$po_f->description_02->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_02->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_02" class="text-nowrap" style="z-index: 8770">
	<input type="text" class="form-control" name="sv_x_description_02" id="sv_x_description_02" value="<?php echo RemoveHtml($po_f->description_02->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($po_f->description_02->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_02->getPlaceHolder()) ?>"<?php echo $po_f->description_02->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_02" data-page="3" data-value-separator="<?php echo $po_f->description_02->displayValueSeparatorAttribute() ?>" name="x_description_02" id="x_description_02" value="<?php echo HtmlEncode($po_f->description_02->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fsearch.createAutoSuggest({"id":"x_description_02","forceSelect":false});
</script>
<?php echo $po_f->description_02->Lookup->getParamTag("p_x_description_02") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_03->Visible) { // description_03 ?>
	<div id="r_description_03" class="form-group row">
		<label for="x_description_03" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_description_03"><?php echo $po_f->description_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_03" id="z_description_03" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->description_03->cellAttributes() ?>>
			<span id="el_po_f_description_03">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_description_03" data-page="3" data-value-separator="<?php echo $po_f->description_03->displayValueSeparatorAttribute() ?>" id="x_description_03" name="x_description_03"<?php echo $po_f->description_03->editAttributes() ?>>
		<?php echo $po_f->description_03->selectOptionListHtml("x_description_03") ?>
	</select>
</div>
<?php echo $po_f->description_03->Lookup->getParamTag("p_x_description_03") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_04->Visible) { // description_04 ?>
	<div id="r_description_04" class="form-group row">
		<label for="x_description_04" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_description_04"><?php echo $po_f->description_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description_04" id="z_description_04" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->description_04->cellAttributes() ?>>
			<span id="el_po_f_description_04">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_description_04" data-page="3" data-value-separator="<?php echo $po_f->description_04->displayValueSeparatorAttribute() ?>" id="x_description_04" name="x_description_04"<?php echo $po_f->description_04->editAttributes() ?>>
		<?php echo $po_f->description_04->selectOptionListHtml("x_description_04") ?>
	</select>
</div>
<?php echo $po_f->description_04->Lookup->getParamTag("p_x_description_04") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_05->Visible) { // description_05 ?>
	<div id="r_description_05" class="form-group row">
		<label for="x_description_05" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_description_05"><?php echo $po_f->description_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_05" id="z_description_05" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->description_05->cellAttributes() ?>>
			<span id="el_po_f_description_05">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_description_05" data-page="3" data-value-separator="<?php echo $po_f->description_05->displayValueSeparatorAttribute() ?>" id="x_description_05" name="x_description_05"<?php echo $po_f->description_05->editAttributes() ?>>
		<?php echo $po_f->description_05->selectOptionListHtml("x_description_05") ?>
	</select>
</div>
<?php echo $po_f->description_05->Lookup->getParamTag("p_x_description_05") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_06->Visible) { // description_06 ?>
	<div id="r_description_06" class="form-group row">
		<label for="x_description_06" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_description_06"><?php echo $po_f->description_06->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_06" id="z_description_06" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->description_06->cellAttributes() ?>>
			<span id="el_po_f_description_06">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_description_06" data-page="3" data-value-separator="<?php echo $po_f->description_06->displayValueSeparatorAttribute() ?>" id="x_description_06" name="x_description_06"<?php echo $po_f->description_06->editAttributes() ?>>
		<?php echo $po_f->description_06->selectOptionListHtml("x_description_06") ?>
	</select>
</div>
<?php echo $po_f->description_06->Lookup->getParamTag("p_x_description_06") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_07->Visible) { // description_07 ?>
	<div id="r_description_07" class="form-group row">
		<label class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_description_07"><?php echo $po_f->description_07->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_07" id="z_description_07" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->description_07->cellAttributes() ?>>
			<span id="el_po_f_description_07">
<?php
$wrkonchange = "" . trim(@$po_f->description_07->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_07->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_07" class="text-nowrap" style="z-index: 8670">
	<input type="text" class="form-control" name="sv_x_description_07" id="sv_x_description_07" value="<?php echo RemoveHtml($po_f->description_07->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_f->description_07->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_07->getPlaceHolder()) ?>"<?php echo $po_f->description_07->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_07" data-page="3" data-value-separator="<?php echo $po_f->description_07->displayValueSeparatorAttribute() ?>" name="x_description_07" id="x_description_07" value="<?php echo HtmlEncode($po_f->description_07->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fsearch.createAutoSuggest({"id":"x_description_07","forceSelect":false});
</script>
<?php echo $po_f->description_07->Lookup->getParamTag("p_x_description_07") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->description_08->Visible) { // description_08 ?>
	<div id="r_description_08" class="form-group row">
		<label class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_description_08"><?php echo $po_f->description_08->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description_08" id="z_description_08" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->description_08->cellAttributes() ?>>
			<span id="el_po_f_description_08">
<?php
$wrkonchange = "" . trim(@$po_f->description_08->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$po_f->description_08->EditAttrs["onchange"] = "";
?>
<span id="as_x_description_08" class="text-nowrap" style="z-index: 8650">
	<input type="text" class="form-control" name="sv_x_description_08" id="sv_x_description_08" value="<?php echo RemoveHtml($po_f->description_08->EditValue) ?>" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_f->description_08->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($po_f->description_08->getPlaceHolder()) ?>"<?php echo $po_f->description_08->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_f" data-field="x_description_08" data-page="3" data-value-separator="<?php echo $po_f->description_08->displayValueSeparatorAttribute() ?>" name="x_description_08" id="x_description_08" value="<?php echo HtmlEncode($po_f->description_08->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpo_fsearch.createAutoSuggest({"id":"x_description_08","forceSelect":false});
</script>
<?php echo $po_f->description_08->Lookup->getParamTag("p_x_description_08") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_search->MultiPages->pageStyle("4") ?>" id="tab_po_f4"><!-- multi-page .tab-pane -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_search->MultiPages->pageStyle("5") ?>" id="tab_po_f5"><!-- multi-page .tab-pane -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $po_f_search->MultiPages->pageStyle("6") ?>" id="tab_po_f6"><!-- multi-page .tab-pane -->
<div class="ew-search-div"><!-- page* -->
<?php if ($po_f->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_remarks"><?php echo $po_f->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->remarks->cellAttributes() ?>>
			<span id="el_po_f_remarks">
<input type="text" data-table="po_f" data-field="x_remarks" data-page="6" name="x_remarks" id="x_remarks" size="30" placeholder="<?php echo HtmlEncode($po_f->remarks->getPlaceHolder()) ?>" value="<?php echo $po_f->remarks->EditValue ?>"<?php echo $po_f->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_operator"><?php echo $po_f->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->operator->cellAttributes() ?>>
			<span id="el_po_f_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_operator" data-page="6" data-value-separator="<?php echo $po_f->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $po_f->operator->editAttributes() ?>>
		<?php echo $po_f->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $po_f->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_datetime"><?php echo $po_f->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->datetime->cellAttributes() ?>>
			<span id="el_po_f_datetime">
<input type="text" data-table="po_f" data-field="x_datetime" data-page="6" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($po_f->datetime->getPlaceHolder()) ?>" value="<?php echo $po_f->datetime->EditValue ?>"<?php echo $po_f->datetime->editAttributes() ?>>
<?php if (!$po_f->datetime->ReadOnly && !$po_f->datetime->Disabled && !isset($po_f->datetime->EditAttrs["readonly"]) && !isset($po_f->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_a_operator"><?php echo $po_f->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->a_operator->cellAttributes() ?>>
			<span id="el_po_f_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_f" data-field="x_a_operator" data-page="6" data-value-separator="<?php echo $po_f->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $po_f->a_operator->editAttributes() ?>>
		<?php echo $po_f->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $po_f->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_f->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $po_f_search->LeftColumnClass ?>"><span id="elh_po_f_a_datetime"><?php echo $po_f->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_f_search->RightColumnClass ?>"><div<?php echo $po_f->a_datetime->cellAttributes() ?>>
			<span id="el_po_f_a_datetime">
<input type="text" data-table="po_f" data-field="x_a_datetime" data-page="6" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($po_f->a_datetime->getPlaceHolder()) ?>" value="<?php echo $po_f->a_datetime->EditValue ?>"<?php echo $po_f->a_datetime->editAttributes() ?>>
<?php if (!$po_f->a_datetime->ReadOnly && !$po_f->a_datetime->Disabled && !isset($po_f->a_datetime->EditAttrs["readonly"]) && !isset($po_f->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_fsearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
	</div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?php if (!$po_f_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_f_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_f_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

var SGrp = $("#x_s_grp").val();
		$.getJSON("apcajax.php?getDesc="+SGrp,function(data){
			console.log(data);
			$("#elh_po_f_description_01").html(data.d_01_head);
			 $("#elh_po_f_description_02").html(data.d_02_head);
			 $("#elh_po_f_description_03").html(data.d_03_head);
			 $("#elh_po_f_description_04").html(data.d_04_head);
			 $("#elh_po_f_description_05").html(data.d_05_head);
			 $("#elh_po_f_description_06").html(data.d_06_head);
			 $("#elh_po_f_description_07").html(data.d_07_head);
			 $("#elh_po_f_description_08").html(data.d_08_head);
		});
</script>
<?php include_once "footer.php" ?>
<?php
$po_f_search->terminate();
?>