<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_overall_compiled_add = new po_overall_compiled_add();

// Run the page
$po_overall_compiled_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_overall_compiled_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpo_overall_compiledadd = currentForm = new ew.Form("fpo_overall_compiledadd", "add");

// Validate form
fpo_overall_compiledadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($po_overall_compiled_add->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall_compiled->buyer_id->caption(), $po_overall_compiled->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_overall_compiled_add->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall_compiled->reports_to->caption(), $po_overall_compiled->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_overall_compiled_add->year->Required) { ?>
			elm = this.getElements("x" + infix + "_year");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall_compiled->year->caption(), $po_overall_compiled->year->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_year");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->year->errorMessage()) ?>");
		<?php if ($po_overall_compiled_add->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall_compiled->sqm->caption(), $po_overall_compiled->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->sqm->errorMessage()) ?>");
		<?php if ($po_overall_compiled_add->usd->Required) { ?>
			elm = this.getElements("x" + infix + "_usd");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall_compiled->usd->caption(), $po_overall_compiled->usd->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_usd");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->usd->errorMessage()) ?>");
		<?php if ($po_overall_compiled_add->euro->Required) { ?>
			elm = this.getElements("x" + infix + "_euro");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall_compiled->euro->caption(), $po_overall_compiled->euro->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_euro");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->euro->errorMessage()) ?>");
		<?php if ($po_overall_compiled_add->inr->Required) { ?>
			elm = this.getElements("x" + infix + "_inr");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall_compiled->inr->caption(), $po_overall_compiled->inr->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_inr");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->inr->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpo_overall_compiledadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overall_compiledadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overall_compiledadd.lists["x_buyer_id"] = <?php echo $po_overall_compiled_add->buyer_id->Lookup->toClientList() ?>;
fpo_overall_compiledadd.lists["x_buyer_id"].options = <?php echo JsonEncode($po_overall_compiled_add->buyer_id->lookupOptions()) ?>;
fpo_overall_compiledadd.lists["x_reports_to"] = <?php echo $po_overall_compiled_add->reports_to->Lookup->toClientList() ?>;
fpo_overall_compiledadd.lists["x_reports_to"].options = <?php echo JsonEncode($po_overall_compiled_add->reports_to->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_overall_compiled_add->showPageHeader(); ?>
<?php
$po_overall_compiled_add->showMessage();
?>
<form name="fpo_overall_compiledadd" id="fpo_overall_compiledadd" class="<?php echo $po_overall_compiled_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_overall_compiled_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_overall_compiled_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_overall_compiled">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$po_overall_compiled_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($po_overall_compiled->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label id="elh_po_overall_compiled_buyer_id" for="x_buyer_id" class="<?php echo $po_overall_compiled_add->LeftColumnClass ?>"><?php echo $po_overall_compiled->buyer_id->caption() ?><?php echo ($po_overall_compiled->buyer_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_overall_compiled_add->RightColumnClass ?>"><div<?php echo $po_overall_compiled->buyer_id->cellAttributes() ?>>
<span id="el_po_overall_compiled_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall_compiled" data-field="x_buyer_id" data-value-separator="<?php echo $po_overall_compiled->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po_overall_compiled->buyer_id->editAttributes() ?>>
		<?php echo $po_overall_compiled->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $po_overall_compiled->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
<?php echo $po_overall_compiled->buyer_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_po_overall_compiled_reports_to" for="x_reports_to" class="<?php echo $po_overall_compiled_add->LeftColumnClass ?>"><?php echo $po_overall_compiled->reports_to->caption() ?><?php echo ($po_overall_compiled->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_overall_compiled_add->RightColumnClass ?>"><div<?php echo $po_overall_compiled->reports_to->cellAttributes() ?>>
<span id="el_po_overall_compiled_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall_compiled" data-field="x_reports_to" data-value-separator="<?php echo $po_overall_compiled->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $po_overall_compiled->reports_to->editAttributes() ?>>
		<?php echo $po_overall_compiled->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $po_overall_compiled->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php echo $po_overall_compiled->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->year->Visible) { // year ?>
	<div id="r_year" class="form-group row">
		<label id="elh_po_overall_compiled_year" for="x_year" class="<?php echo $po_overall_compiled_add->LeftColumnClass ?>"><?php echo $po_overall_compiled->year->caption() ?><?php echo ($po_overall_compiled->year->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_overall_compiled_add->RightColumnClass ?>"><div<?php echo $po_overall_compiled->year->cellAttributes() ?>>
<span id="el_po_overall_compiled_year">
<input type="text" data-table="po_overall_compiled" data-field="x_year" name="x_year" id="x_year" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->year->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->year->EditValue ?>"<?php echo $po_overall_compiled->year->editAttributes() ?>>
</span>
<?php echo $po_overall_compiled->year->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label id="elh_po_overall_compiled_sqm" for="x_sqm" class="<?php echo $po_overall_compiled_add->LeftColumnClass ?>"><?php echo $po_overall_compiled->sqm->caption() ?><?php echo ($po_overall_compiled->sqm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_overall_compiled_add->RightColumnClass ?>"><div<?php echo $po_overall_compiled->sqm->cellAttributes() ?>>
<span id="el_po_overall_compiled_sqm">
<input type="text" data-table="po_overall_compiled" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->sqm->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->sqm->EditValue ?>"<?php echo $po_overall_compiled->sqm->editAttributes() ?>>
</span>
<?php echo $po_overall_compiled->sqm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->usd->Visible) { // usd ?>
	<div id="r_usd" class="form-group row">
		<label id="elh_po_overall_compiled_usd" for="x_usd" class="<?php echo $po_overall_compiled_add->LeftColumnClass ?>"><?php echo $po_overall_compiled->usd->caption() ?><?php echo ($po_overall_compiled->usd->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_overall_compiled_add->RightColumnClass ?>"><div<?php echo $po_overall_compiled->usd->cellAttributes() ?>>
<span id="el_po_overall_compiled_usd">
<input type="text" data-table="po_overall_compiled" data-field="x_usd" name="x_usd" id="x_usd" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->usd->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->usd->EditValue ?>"<?php echo $po_overall_compiled->usd->editAttributes() ?>>
</span>
<?php echo $po_overall_compiled->usd->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->euro->Visible) { // euro ?>
	<div id="r_euro" class="form-group row">
		<label id="elh_po_overall_compiled_euro" for="x_euro" class="<?php echo $po_overall_compiled_add->LeftColumnClass ?>"><?php echo $po_overall_compiled->euro->caption() ?><?php echo ($po_overall_compiled->euro->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_overall_compiled_add->RightColumnClass ?>"><div<?php echo $po_overall_compiled->euro->cellAttributes() ?>>
<span id="el_po_overall_compiled_euro">
<input type="text" data-table="po_overall_compiled" data-field="x_euro" name="x_euro" id="x_euro" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->euro->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->euro->EditValue ?>"<?php echo $po_overall_compiled->euro->editAttributes() ?>>
</span>
<?php echo $po_overall_compiled->euro->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->inr->Visible) { // inr ?>
	<div id="r_inr" class="form-group row">
		<label id="elh_po_overall_compiled_inr" for="x_inr" class="<?php echo $po_overall_compiled_add->LeftColumnClass ?>"><?php echo $po_overall_compiled->inr->caption() ?><?php echo ($po_overall_compiled->inr->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $po_overall_compiled_add->RightColumnClass ?>"><div<?php echo $po_overall_compiled->inr->cellAttributes() ?>>
<span id="el_po_overall_compiled_inr">
<input type="text" data-table="po_overall_compiled" data-field="x_inr" name="x_inr" id="x_inr" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->inr->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->inr->EditValue ?>"<?php echo $po_overall_compiled->inr->editAttributes() ?>>
</span>
<?php echo $po_overall_compiled->inr->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_overall_compiled_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_overall_compiled_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $po_overall_compiled_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_overall_compiled_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_overall_compiled_add->terminate();
?>