<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_overall_compiled_search = new po_overall_compiled_search();

// Run the page
$po_overall_compiled_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_overall_compiled_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_overall_compiled_search->IsModal) { ?>
var fpo_overall_compiledsearch = currentAdvancedSearchForm = new ew.Form("fpo_overall_compiledsearch", "search");
<?php } else { ?>
var fpo_overall_compiledsearch = currentForm = new ew.Form("fpo_overall_compiledsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_overall_compiledsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overall_compiledsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overall_compiledsearch.lists["x_buyer_id"] = <?php echo $po_overall_compiled_search->buyer_id->Lookup->toClientList() ?>;
fpo_overall_compiledsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($po_overall_compiled_search->buyer_id->lookupOptions()) ?>;
fpo_overall_compiledsearch.lists["x_reports_to"] = <?php echo $po_overall_compiled_search->reports_to->Lookup->toClientList() ?>;
fpo_overall_compiledsearch.lists["x_reports_to"].options = <?php echo JsonEncode($po_overall_compiled_search->reports_to->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpo_overall_compiledsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_year");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->year->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_usd");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->usd->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_euro");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->euro->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_inr");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall_compiled->inr->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_overall_compiled_search->showPageHeader(); ?>
<?php
$po_overall_compiled_search->showMessage();
?>
<form name="fpo_overall_compiledsearch" id="fpo_overall_compiledsearch" class="<?php echo $po_overall_compiled_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_overall_compiled_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_overall_compiled_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_overall_compiled">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_overall_compiled_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($po_overall_compiled->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $po_overall_compiled_search->LeftColumnClass ?>"><span id="elh_po_overall_compiled_buyer_id"><?php echo $po_overall_compiled->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $po_overall_compiled_search->RightColumnClass ?>"><div<?php echo $po_overall_compiled->buyer_id->cellAttributes() ?>>
			<span id="el_po_overall_compiled_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall_compiled" data-field="x_buyer_id" data-value-separator="<?php echo $po_overall_compiled->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po_overall_compiled->buyer_id->editAttributes() ?>>
		<?php echo $po_overall_compiled->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $po_overall_compiled->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $po_overall_compiled_search->LeftColumnClass ?>"><span id="elh_po_overall_compiled_reports_to"><?php echo $po_overall_compiled->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $po_overall_compiled_search->RightColumnClass ?>"><div<?php echo $po_overall_compiled->reports_to->cellAttributes() ?>>
			<span id="el_po_overall_compiled_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall_compiled" data-field="x_reports_to" data-value-separator="<?php echo $po_overall_compiled->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $po_overall_compiled->reports_to->editAttributes() ?>>
		<?php echo $po_overall_compiled->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $po_overall_compiled->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->year->Visible) { // year ?>
	<div id="r_year" class="form-group row">
		<label for="x_year" class="<?php echo $po_overall_compiled_search->LeftColumnClass ?>"><span id="elh_po_overall_compiled_year"><?php echo $po_overall_compiled->year->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_year" id="z_year" value="="></span>
		</label>
		<div class="<?php echo $po_overall_compiled_search->RightColumnClass ?>"><div<?php echo $po_overall_compiled->year->cellAttributes() ?>>
			<span id="el_po_overall_compiled_year">
<input type="text" data-table="po_overall_compiled" data-field="x_year" name="x_year" id="x_year" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->year->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->year->EditValue ?>"<?php echo $po_overall_compiled->year->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $po_overall_compiled_search->LeftColumnClass ?>"><span id="elh_po_overall_compiled_sqm"><?php echo $po_overall_compiled->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $po_overall_compiled_search->RightColumnClass ?>"><div<?php echo $po_overall_compiled->sqm->cellAttributes() ?>>
			<span id="el_po_overall_compiled_sqm">
<input type="text" data-table="po_overall_compiled" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->sqm->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->sqm->EditValue ?>"<?php echo $po_overall_compiled->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->usd->Visible) { // usd ?>
	<div id="r_usd" class="form-group row">
		<label for="x_usd" class="<?php echo $po_overall_compiled_search->LeftColumnClass ?>"><span id="elh_po_overall_compiled_usd"><?php echo $po_overall_compiled->usd->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_usd" id="z_usd" value="="></span>
		</label>
		<div class="<?php echo $po_overall_compiled_search->RightColumnClass ?>"><div<?php echo $po_overall_compiled->usd->cellAttributes() ?>>
			<span id="el_po_overall_compiled_usd">
<input type="text" data-table="po_overall_compiled" data-field="x_usd" name="x_usd" id="x_usd" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->usd->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->usd->EditValue ?>"<?php echo $po_overall_compiled->usd->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->euro->Visible) { // euro ?>
	<div id="r_euro" class="form-group row">
		<label for="x_euro" class="<?php echo $po_overall_compiled_search->LeftColumnClass ?>"><span id="elh_po_overall_compiled_euro"><?php echo $po_overall_compiled->euro->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_euro" id="z_euro" value="="></span>
		</label>
		<div class="<?php echo $po_overall_compiled_search->RightColumnClass ?>"><div<?php echo $po_overall_compiled->euro->cellAttributes() ?>>
			<span id="el_po_overall_compiled_euro">
<input type="text" data-table="po_overall_compiled" data-field="x_euro" name="x_euro" id="x_euro" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->euro->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->euro->EditValue ?>"<?php echo $po_overall_compiled->euro->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall_compiled->inr->Visible) { // inr ?>
	<div id="r_inr" class="form-group row">
		<label for="x_inr" class="<?php echo $po_overall_compiled_search->LeftColumnClass ?>"><span id="elh_po_overall_compiled_inr"><?php echo $po_overall_compiled->inr->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_inr" id="z_inr" value="="></span>
		</label>
		<div class="<?php echo $po_overall_compiled_search->RightColumnClass ?>"><div<?php echo $po_overall_compiled->inr->cellAttributes() ?>>
			<span id="el_po_overall_compiled_inr">
<input type="text" data-table="po_overall_compiled" data-field="x_inr" name="x_inr" id="x_inr" size="30" placeholder="<?php echo HtmlEncode($po_overall_compiled->inr->getPlaceHolder()) ?>" value="<?php echo $po_overall_compiled->inr->EditValue ?>"<?php echo $po_overall_compiled->inr->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_overall_compiled_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_overall_compiled_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_overall_compiled_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_overall_compiled_search->terminate();
?>