<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_overall_cross_list = new po_overall_cross_list();

// Run the page
$po_overall_cross_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_overall_cross_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_overall_cross->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_overall_crosslist = currentForm = new ew.Form("fpo_overall_crosslist", "list");
fpo_overall_crosslist.formKeyCountName = '<?php echo $po_overall_cross_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_overall_crosslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overall_crosslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overall_crosslist.lists["x_Buyer"] = <?php echo $po_overall_cross_list->Buyer->Lookup->toClientList() ?>;
fpo_overall_crosslist.lists["x_Buyer"].options = <?php echo JsonEncode($po_overall_cross_list->Buyer->lookupOptions()) ?>;

// Form object for search
var fpo_overall_crosslistsrch = currentSearchForm = new ew.Form("fpo_overall_crosslistsrch");

// Validate function for search
fpo_overall_crosslistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_overall_crosslistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overall_crosslistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overall_crosslistsrch.lists["x_Buyer"] = <?php echo $po_overall_cross_list->Buyer->Lookup->toClientList() ?>;
fpo_overall_crosslistsrch.lists["x_Buyer"].options = <?php echo JsonEncode($po_overall_cross_list->Buyer->lookupOptions()) ?>;

// Filters
fpo_overall_crosslistsrch.filterList = <?php echo $po_overall_cross_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_overall_crosslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_overall_cross->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_overall_cross_list->TotalRecs > 0 && $po_overall_cross_list->ExportOptions->visible()) { ?>
<?php $po_overall_cross_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_overall_cross_list->ImportOptions->visible()) { ?>
<?php $po_overall_cross_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_overall_cross_list->SearchOptions->visible()) { ?>
<?php $po_overall_cross_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_overall_cross_list->FilterOptions->visible()) { ?>
<?php $po_overall_cross_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_overall_cross_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_overall_cross->isExport() && !$po_overall_cross->CurrentAction) { ?>
<form name="fpo_overall_crosslistsrch" id="fpo_overall_crosslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_overall_cross_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_overall_crosslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_overall_cross">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_overall_cross_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_overall_cross->RowType = ROWTYPE_SEARCH;

// Render row
$po_overall_cross->resetAttributes();
$po_overall_cross_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_overall_cross->Buyer->Visible) { // Buyer ?>
	<div id="xsc_Buyer" class="ew-cell form-group">
		<label for="x_Buyer" class="ew-search-caption ew-label"><?php echo $po_overall_cross->Buyer->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Buyer" id="z_Buyer" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall_cross" data-field="x_Buyer" data-value-separator="<?php echo $po_overall_cross->Buyer->displayValueSeparatorAttribute() ?>" id="x_Buyer" name="x_Buyer"<?php echo $po_overall_cross->Buyer->editAttributes() ?>>
		<?php echo $po_overall_cross->Buyer->selectOptionListHtml("x_Buyer") ?>
	</select>
</div>
<?php echo $po_overall_cross->Buyer->Lookup->getParamTag("p_x_Buyer") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_overall_cross->Month->Visible) { // Month ?>
	<div id="xsc_Month" class="ew-cell form-group">
		<label for="x_Month" class="ew-search-caption ew-label"><?php echo $po_overall_cross->Month->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_Month" id="z_Month" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="po_overall_cross" data-field="x_Month" name="x_Month" id="x_Month" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_overall_cross->Month->getPlaceHolder()) ?>" value="<?php echo $po_overall_cross->Month->EditValue ?>"<?php echo $po_overall_cross->Month->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_overall_cross_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_overall_cross_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_overall_cross_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_overall_cross_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_overall_cross_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_overall_cross_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_overall_cross_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_overall_cross_list->showPageHeader(); ?>
<?php
$po_overall_cross_list->showMessage();
?>
<?php if ($po_overall_cross_list->TotalRecs > 0 || $po_overall_cross->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_overall_cross_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_overall_cross">
<?php if (!$po_overall_cross->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_overall_cross->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_overall_cross_list->Pager)) $po_overall_cross_list->Pager = new PrevNextPager($po_overall_cross_list->StartRec, $po_overall_cross_list->DisplayRecs, $po_overall_cross_list->TotalRecs, $po_overall_cross_list->AutoHidePager) ?>
<?php if ($po_overall_cross_list->Pager->RecordCount > 0 && $po_overall_cross_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_overall_cross_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_overall_cross_list->pageUrl() ?>start=<?php echo $po_overall_cross_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_overall_cross_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_overall_cross_list->pageUrl() ?>start=<?php echo $po_overall_cross_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_overall_cross_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_overall_cross_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_overall_cross_list->pageUrl() ?>start=<?php echo $po_overall_cross_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_overall_cross_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_overall_cross_list->pageUrl() ?>start=<?php echo $po_overall_cross_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_overall_cross_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_overall_cross_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_overall_cross_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_overall_cross_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_overall_cross_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_overall_cross_list->TotalRecs > 0 && (!$po_overall_cross_list->AutoHidePageSizeSelector || $po_overall_cross_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_overall_cross">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_overall_cross_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_overall_cross_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_overall_cross_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_overall_cross_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_overall_cross_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_overall_cross->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_overall_cross_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_overall_crosslist" id="fpo_overall_crosslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_overall_cross_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_overall_cross_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_overall_cross">
<div id="gmp_po_overall_cross" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_overall_cross_list->TotalRecs > 0 || $po_overall_cross->isGridEdit()) { ?>
<table id="tbl_po_overall_crosslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_overall_cross_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_overall_cross_list->renderListOptions();

// Render list options (header, left)
$po_overall_cross_list->ListOptions->render("header", "left");
?>
<?php if ($po_overall_cross->Buyer->Visible) { // Buyer ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->Buyer) == "") { ?>
		<th data-name="Buyer" class="<?php echo $po_overall_cross->Buyer->headerCellClass() ?>"><div id="elh_po_overall_cross_Buyer" class="po_overall_cross_Buyer"><div class="ew-table-header-caption"><?php echo $po_overall_cross->Buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Buyer" class="<?php echo $po_overall_cross->Buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->Buyer) ?>',2);"><div id="elh_po_overall_cross_Buyer" class="po_overall_cross_Buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->Buyer->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->Buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->Buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->Month->Visible) { // Month ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->Month) == "") { ?>
		<th data-name="Month" class="<?php echo $po_overall_cross->Month->headerCellClass() ?>"><div id="elh_po_overall_cross_Month" class="po_overall_cross_Month"><div class="ew-table-header-caption"><?php echo $po_overall_cross->Month->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Month" class="<?php echo $po_overall_cross->Month->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->Month) ?>',2);"><div id="elh_po_overall_cross_Month" class="po_overall_cross_Month">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->Month->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->Month->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->Month->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->SQM_CY->Visible) { // SQM_CY ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->SQM_CY) == "") { ?>
		<th data-name="SQM_CY" class="<?php echo $po_overall_cross->SQM_CY->headerCellClass() ?>"><div id="elh_po_overall_cross_SQM_CY" class="po_overall_cross_SQM_CY"><div class="ew-table-header-caption"><?php echo $po_overall_cross->SQM_CY->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SQM_CY" class="<?php echo $po_overall_cross->SQM_CY->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->SQM_CY) ?>',2);"><div id="elh_po_overall_cross_SQM_CY" class="po_overall_cross_SQM_CY">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->SQM_CY->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->SQM_CY->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->SQM_CY->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->Amount_CY->Visible) { // Amount_CY ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->Amount_CY) == "") { ?>
		<th data-name="Amount_CY" class="<?php echo $po_overall_cross->Amount_CY->headerCellClass() ?>"><div id="elh_po_overall_cross_Amount_CY" class="po_overall_cross_Amount_CY"><div class="ew-table-header-caption"><?php echo $po_overall_cross->Amount_CY->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Amount_CY" class="<?php echo $po_overall_cross->Amount_CY->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->Amount_CY) ?>',2);"><div id="elh_po_overall_cross_Amount_CY" class="po_overall_cross_Amount_CY">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->Amount_CY->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->Amount_CY->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->Amount_CY->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->SQM_PY->Visible) { // SQM_PY ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->SQM_PY) == "") { ?>
		<th data-name="SQM_PY" class="<?php echo $po_overall_cross->SQM_PY->headerCellClass() ?>"><div id="elh_po_overall_cross_SQM_PY" class="po_overall_cross_SQM_PY"><div class="ew-table-header-caption"><?php echo $po_overall_cross->SQM_PY->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SQM_PY" class="<?php echo $po_overall_cross->SQM_PY->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->SQM_PY) ?>',2);"><div id="elh_po_overall_cross_SQM_PY" class="po_overall_cross_SQM_PY">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->SQM_PY->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->SQM_PY->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->SQM_PY->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->Amount_PY->Visible) { // Amount_PY ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->Amount_PY) == "") { ?>
		<th data-name="Amount_PY" class="<?php echo $po_overall_cross->Amount_PY->headerCellClass() ?>"><div id="elh_po_overall_cross_Amount_PY" class="po_overall_cross_Amount_PY"><div class="ew-table-header-caption"><?php echo $po_overall_cross->Amount_PY->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Amount_PY" class="<?php echo $po_overall_cross->Amount_PY->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->Amount_PY) ?>',2);"><div id="elh_po_overall_cross_Amount_PY" class="po_overall_cross_Amount_PY">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->Amount_PY->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->Amount_PY->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->Amount_PY->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->SQM_BPY->Visible) { // SQM_BPY ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->SQM_BPY) == "") { ?>
		<th data-name="SQM_BPY" class="<?php echo $po_overall_cross->SQM_BPY->headerCellClass() ?>"><div id="elh_po_overall_cross_SQM_BPY" class="po_overall_cross_SQM_BPY"><div class="ew-table-header-caption"><?php echo $po_overall_cross->SQM_BPY->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SQM_BPY" class="<?php echo $po_overall_cross->SQM_BPY->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->SQM_BPY) ?>',2);"><div id="elh_po_overall_cross_SQM_BPY" class="po_overall_cross_SQM_BPY">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->SQM_BPY->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->SQM_BPY->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->SQM_BPY->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->Amount_BPY->Visible) { // Amount_BPY ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->Amount_BPY) == "") { ?>
		<th data-name="Amount_BPY" class="<?php echo $po_overall_cross->Amount_BPY->headerCellClass() ?>"><div id="elh_po_overall_cross_Amount_BPY" class="po_overall_cross_Amount_BPY"><div class="ew-table-header-caption"><?php echo $po_overall_cross->Amount_BPY->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Amount_BPY" class="<?php echo $po_overall_cross->Amount_BPY->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->Amount_BPY) ?>',2);"><div id="elh_po_overall_cross_Amount_BPY" class="po_overall_cross_Amount_BPY">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->Amount_BPY->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->Amount_BPY->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->Amount_BPY->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->SQM_BBPY->Visible) { // SQM_BBPY ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->SQM_BBPY) == "") { ?>
		<th data-name="SQM_BBPY" class="<?php echo $po_overall_cross->SQM_BBPY->headerCellClass() ?>"><div id="elh_po_overall_cross_SQM_BBPY" class="po_overall_cross_SQM_BBPY"><div class="ew-table-header-caption"><?php echo $po_overall_cross->SQM_BBPY->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SQM_BBPY" class="<?php echo $po_overall_cross->SQM_BBPY->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->SQM_BBPY) ?>',2);"><div id="elh_po_overall_cross_SQM_BBPY" class="po_overall_cross_SQM_BBPY">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->SQM_BBPY->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->SQM_BBPY->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->SQM_BBPY->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall_cross->Amount_BBPY->Visible) { // Amount_BBPY ?>
	<?php if ($po_overall_cross->sortUrl($po_overall_cross->Amount_BBPY) == "") { ?>
		<th data-name="Amount_BBPY" class="<?php echo $po_overall_cross->Amount_BBPY->headerCellClass() ?>"><div id="elh_po_overall_cross_Amount_BBPY" class="po_overall_cross_Amount_BBPY"><div class="ew-table-header-caption"><?php echo $po_overall_cross->Amount_BBPY->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Amount_BBPY" class="<?php echo $po_overall_cross->Amount_BBPY->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall_cross->SortUrl($po_overall_cross->Amount_BBPY) ?>',2);"><div id="elh_po_overall_cross_Amount_BBPY" class="po_overall_cross_Amount_BBPY">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall_cross->Amount_BBPY->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_overall_cross->Amount_BBPY->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_cross->Amount_BBPY->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_overall_cross_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_overall_cross->ExportAll && $po_overall_cross->isExport()) {
	$po_overall_cross_list->StopRec = $po_overall_cross_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_overall_cross_list->TotalRecs > $po_overall_cross_list->StartRec + $po_overall_cross_list->DisplayRecs - 1)
		$po_overall_cross_list->StopRec = $po_overall_cross_list->StartRec + $po_overall_cross_list->DisplayRecs - 1;
	else
		$po_overall_cross_list->StopRec = $po_overall_cross_list->TotalRecs;
}
$po_overall_cross_list->RecCnt = $po_overall_cross_list->StartRec - 1;
if ($po_overall_cross_list->Recordset && !$po_overall_cross_list->Recordset->EOF) {
	$po_overall_cross_list->Recordset->moveFirst();
	$selectLimit = $po_overall_cross_list->UseSelectLimit;
	if (!$selectLimit && $po_overall_cross_list->StartRec > 1)
		$po_overall_cross_list->Recordset->move($po_overall_cross_list->StartRec - 1);
} elseif (!$po_overall_cross->AllowAddDeleteRow && $po_overall_cross_list->StopRec == 0) {
	$po_overall_cross_list->StopRec = $po_overall_cross->GridAddRowCount;
}

// Initialize aggregate
$po_overall_cross->RowType = ROWTYPE_AGGREGATEINIT;
$po_overall_cross->resetAttributes();
$po_overall_cross_list->renderRow();
while ($po_overall_cross_list->RecCnt < $po_overall_cross_list->StopRec) {
	$po_overall_cross_list->RecCnt++;
	if ($po_overall_cross_list->RecCnt >= $po_overall_cross_list->StartRec) {
		$po_overall_cross_list->RowCnt++;

		// Set up key count
		$po_overall_cross_list->KeyCount = $po_overall_cross_list->RowIndex;

		// Init row class and style
		$po_overall_cross->resetAttributes();
		$po_overall_cross->CssClass = "";
		if ($po_overall_cross->isGridAdd()) {
		} else {
			$po_overall_cross_list->loadRowValues($po_overall_cross_list->Recordset); // Load row values
		}
		$po_overall_cross->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_overall_cross->RowAttrs = array_merge($po_overall_cross->RowAttrs, array('data-rowindex'=>$po_overall_cross_list->RowCnt, 'id'=>'r' . $po_overall_cross_list->RowCnt . '_po_overall_cross', 'data-rowtype'=>$po_overall_cross->RowType));

		// Render row
		$po_overall_cross_list->renderRow();

		// Render list options
		$po_overall_cross_list->renderListOptions();
?>
	<tr<?php echo $po_overall_cross->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_overall_cross_list->ListOptions->render("body", "left", $po_overall_cross_list->RowCnt);
?>
	<?php if ($po_overall_cross->Buyer->Visible) { // Buyer ?>
		<td data-name="Buyer"<?php echo $po_overall_cross->Buyer->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_Buyer" class="po_overall_cross_Buyer">
<span<?php echo $po_overall_cross->Buyer->viewAttributes() ?>>
<?php echo $po_overall_cross->Buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->Month->Visible) { // Month ?>
		<td data-name="Month"<?php echo $po_overall_cross->Month->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_Month" class="po_overall_cross_Month">
<span<?php echo $po_overall_cross->Month->viewAttributes() ?>>
<?php echo $po_overall_cross->Month->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->SQM_CY->Visible) { // SQM_CY ?>
		<td data-name="SQM_CY"<?php echo $po_overall_cross->SQM_CY->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_SQM_CY" class="po_overall_cross_SQM_CY">
<span<?php echo $po_overall_cross->SQM_CY->viewAttributes() ?>>
<?php echo $po_overall_cross->SQM_CY->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->Amount_CY->Visible) { // Amount_CY ?>
		<td data-name="Amount_CY"<?php echo $po_overall_cross->Amount_CY->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_Amount_CY" class="po_overall_cross_Amount_CY">
<span<?php echo $po_overall_cross->Amount_CY->viewAttributes() ?>>
<?php echo $po_overall_cross->Amount_CY->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->SQM_PY->Visible) { // SQM_PY ?>
		<td data-name="SQM_PY"<?php echo $po_overall_cross->SQM_PY->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_SQM_PY" class="po_overall_cross_SQM_PY">
<span<?php echo $po_overall_cross->SQM_PY->viewAttributes() ?>>
<?php echo $po_overall_cross->SQM_PY->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->Amount_PY->Visible) { // Amount_PY ?>
		<td data-name="Amount_PY"<?php echo $po_overall_cross->Amount_PY->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_Amount_PY" class="po_overall_cross_Amount_PY">
<span<?php echo $po_overall_cross->Amount_PY->viewAttributes() ?>>
<?php echo $po_overall_cross->Amount_PY->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->SQM_BPY->Visible) { // SQM_BPY ?>
		<td data-name="SQM_BPY"<?php echo $po_overall_cross->SQM_BPY->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_SQM_BPY" class="po_overall_cross_SQM_BPY">
<span<?php echo $po_overall_cross->SQM_BPY->viewAttributes() ?>>
<?php echo $po_overall_cross->SQM_BPY->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->Amount_BPY->Visible) { // Amount_BPY ?>
		<td data-name="Amount_BPY"<?php echo $po_overall_cross->Amount_BPY->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_Amount_BPY" class="po_overall_cross_Amount_BPY">
<span<?php echo $po_overall_cross->Amount_BPY->viewAttributes() ?>>
<?php echo $po_overall_cross->Amount_BPY->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->SQM_BBPY->Visible) { // SQM_BBPY ?>
		<td data-name="SQM_BBPY"<?php echo $po_overall_cross->SQM_BBPY->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_SQM_BBPY" class="po_overall_cross_SQM_BBPY">
<span<?php echo $po_overall_cross->SQM_BBPY->viewAttributes() ?>>
<?php echo $po_overall_cross->SQM_BBPY->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall_cross->Amount_BBPY->Visible) { // Amount_BBPY ?>
		<td data-name="Amount_BBPY"<?php echo $po_overall_cross->Amount_BBPY->cellAttributes() ?>>
<span id="el<?php echo $po_overall_cross_list->RowCnt ?>_po_overall_cross_Amount_BBPY" class="po_overall_cross_Amount_BBPY">
<span<?php echo $po_overall_cross->Amount_BBPY->viewAttributes() ?>>
<?php echo $po_overall_cross->Amount_BBPY->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_overall_cross_list->ListOptions->render("body", "right", $po_overall_cross_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_overall_cross->isGridAdd())
		$po_overall_cross_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_overall_cross->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_overall_cross_list->Recordset)
	$po_overall_cross_list->Recordset->Close();
?>
<?php if (!$po_overall_cross->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_overall_cross->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_overall_cross_list->Pager)) $po_overall_cross_list->Pager = new PrevNextPager($po_overall_cross_list->StartRec, $po_overall_cross_list->DisplayRecs, $po_overall_cross_list->TotalRecs, $po_overall_cross_list->AutoHidePager) ?>
<?php if ($po_overall_cross_list->Pager->RecordCount > 0 && $po_overall_cross_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_overall_cross_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_overall_cross_list->pageUrl() ?>start=<?php echo $po_overall_cross_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_overall_cross_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_overall_cross_list->pageUrl() ?>start=<?php echo $po_overall_cross_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_overall_cross_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_overall_cross_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_overall_cross_list->pageUrl() ?>start=<?php echo $po_overall_cross_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_overall_cross_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_overall_cross_list->pageUrl() ?>start=<?php echo $po_overall_cross_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_overall_cross_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_overall_cross_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_overall_cross_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_overall_cross_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_overall_cross_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_overall_cross_list->TotalRecs > 0 && (!$po_overall_cross_list->AutoHidePageSizeSelector || $po_overall_cross_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_overall_cross">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_overall_cross_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_overall_cross_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_overall_cross_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_overall_cross_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_overall_cross_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_overall_cross->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_overall_cross_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_overall_cross_list->TotalRecs == 0 && !$po_overall_cross->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_overall_cross_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_overall_cross_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_overall_cross->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_overall_cross->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_overall_cross", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_overall_cross_list->terminate();
?>