<?php
namespace PHPMaker2019\fibre;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($po_overall_grid))
	$po_overall_grid = new po_overall_grid();

// Run the page
$po_overall_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_overall_grid->Page_Render();
?>
<?php if (!$po_overall->isExport()) { ?>
<script>

// Form object
var fpo_overallgrid = new ew.Form("fpo_overallgrid", "grid");
fpo_overallgrid.formKeyCountName = '<?php echo $po_overall_grid->FormKeyCountName ?>';

// Validate form
fpo_overallgrid.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
		if (checkrow) {
			addcnt++;
		<?php if ($po_overall_grid->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->id->caption(), $po_overall->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_overall_grid->buyer_id->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->buyer_id->caption(), $po_overall->buyer_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_overall_grid->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->reports_to->caption(), $po_overall->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_overall_grid->year->Required) { ?>
			elm = this.getElements("x" + infix + "_year");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->year->caption(), $po_overall->year->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_year");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall->year->errorMessage()) ?>");
		<?php if ($po_overall_grid->month->Required) { ?>
			elm = this.getElements("x" + infix + "_month");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->month->caption(), $po_overall->month->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_overall_grid->sqm->Required) { ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->sqm->caption(), $po_overall->sqm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_sqm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall->sqm->errorMessage()) ?>");
		<?php if ($po_overall_grid->usd->Required) { ?>
			elm = this.getElements("x" + infix + "_usd");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->usd->caption(), $po_overall->usd->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_usd");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall->usd->errorMessage()) ?>");
		<?php if ($po_overall_grid->euro->Required) { ?>
			elm = this.getElements("x" + infix + "_euro");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->euro->caption(), $po_overall->euro->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_euro");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall->euro->errorMessage()) ?>");
		<?php if ($po_overall_grid->inr->Required) { ?>
			elm = this.getElements("x" + infix + "_inr");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->inr->caption(), $po_overall->inr->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_inr");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($po_overall->inr->errorMessage()) ?>");
		<?php if ($po_overall_grid->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->operator->caption(), $po_overall->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($po_overall_grid->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $po_overall->datetime->caption(), $po_overall->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
		} // End Grid Add checking
	}
	return true;
}

// Check empty row
fpo_overallgrid.emptyRow = function(infix) {
	var fobj = this._form;
	if (ew.valueChanged(fobj, infix, "buyer_id", false)) return false;
	if (ew.valueChanged(fobj, infix, "reports_to", false)) return false;
	if (ew.valueChanged(fobj, infix, "year", false)) return false;
	if (ew.valueChanged(fobj, infix, "month", false)) return false;
	if (ew.valueChanged(fobj, infix, "sqm", false)) return false;
	if (ew.valueChanged(fobj, infix, "usd", false)) return false;
	if (ew.valueChanged(fobj, infix, "euro", false)) return false;
	if (ew.valueChanged(fobj, infix, "inr", false)) return false;
	return true;
}

// Form_CustomValidate event
fpo_overallgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overallgrid.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overallgrid.lists["x_buyer_id"] = <?php echo $po_overall_grid->buyer_id->Lookup->toClientList() ?>;
fpo_overallgrid.lists["x_buyer_id"].options = <?php echo JsonEncode($po_overall_grid->buyer_id->lookupOptions()) ?>;
fpo_overallgrid.lists["x_reports_to"] = <?php echo $po_overall_grid->reports_to->Lookup->toClientList() ?>;
fpo_overallgrid.lists["x_reports_to"].options = <?php echo JsonEncode($po_overall_grid->reports_to->lookupOptions()) ?>;
fpo_overallgrid.lists["x_month"] = <?php echo $po_overall_grid->month->Lookup->toClientList() ?>;
fpo_overallgrid.lists["x_month"].options = <?php echo JsonEncode($po_overall_grid->month->lookupOptions()) ?>;
fpo_overallgrid.lists["x_operator"] = <?php echo $po_overall_grid->operator->Lookup->toClientList() ?>;
fpo_overallgrid.lists["x_operator"].options = <?php echo JsonEncode($po_overall_grid->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script src="phpjs/ewscrolltable.js"></script>
<?php } ?>
<?php
$po_overall_grid->renderOtherOptions();
?>
<?php $po_overall_grid->showPageHeader(); ?>
<?php
$po_overall_grid->showMessage();
?>
<?php if ($po_overall_grid->TotalRecs > 0 || $po_overall->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_overall_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_overall">
<?php if ($po_overall_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $po_overall_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fpo_overallgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_po_overall" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table id="tbl_po_overallgrid" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_overall_grid->RowType = ROWTYPE_HEADER;

// Render list options
$po_overall_grid->renderListOptions();

// Render list options (header, left)
$po_overall_grid->ListOptions->render("header", "left");
?>
<?php if ($po_overall->id->Visible) { // id ?>
	<?php if ($po_overall->sortUrl($po_overall->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_overall->id->headerCellClass() ?>"><div id="elh_po_overall_id" class="po_overall_id"><div class="ew-table-header-caption"><?php echo $po_overall->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_overall->id->headerCellClass() ?>"><div><div id="elh_po_overall_id" class="po_overall_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
	<?php if ($po_overall->sortUrl($po_overall->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $po_overall->buyer_id->headerCellClass() ?>"><div id="elh_po_overall_buyer_id" class="po_overall_buyer_id"><div class="ew-table-header-caption"><?php echo $po_overall->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $po_overall->buyer_id->headerCellClass() ?>"><div><div id="elh_po_overall_buyer_id" class="po_overall_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
	<?php if ($po_overall->sortUrl($po_overall->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $po_overall->reports_to->headerCellClass() ?>"><div id="elh_po_overall_reports_to" class="po_overall_reports_to"><div class="ew-table-header-caption"><?php echo $po_overall->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $po_overall->reports_to->headerCellClass() ?>"><div><div id="elh_po_overall_reports_to" class="po_overall_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->year->Visible) { // year ?>
	<?php if ($po_overall->sortUrl($po_overall->year) == "") { ?>
		<th data-name="year" class="<?php echo $po_overall->year->headerCellClass() ?>"><div id="elh_po_overall_year" class="po_overall_year"><div class="ew-table-header-caption"><?php echo $po_overall->year->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="year" class="<?php echo $po_overall->year->headerCellClass() ?>"><div><div id="elh_po_overall_year" class="po_overall_year">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->year->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->year->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->year->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->month->Visible) { // month ?>
	<?php if ($po_overall->sortUrl($po_overall->month) == "") { ?>
		<th data-name="month" class="<?php echo $po_overall->month->headerCellClass() ?>"><div id="elh_po_overall_month" class="po_overall_month"><div class="ew-table-header-caption"><?php echo $po_overall->month->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month" class="<?php echo $po_overall->month->headerCellClass() ?>"><div><div id="elh_po_overall_month" class="po_overall_month">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->month->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->month->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->month->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->sqm->Visible) { // sqm ?>
	<?php if ($po_overall->sortUrl($po_overall->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $po_overall->sqm->headerCellClass() ?>"><div id="elh_po_overall_sqm" class="po_overall_sqm"><div class="ew-table-header-caption"><?php echo $po_overall->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $po_overall->sqm->headerCellClass() ?>"><div><div id="elh_po_overall_sqm" class="po_overall_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->usd->Visible) { // usd ?>
	<?php if ($po_overall->sortUrl($po_overall->usd) == "") { ?>
		<th data-name="usd" class="<?php echo $po_overall->usd->headerCellClass() ?>"><div id="elh_po_overall_usd" class="po_overall_usd"><div class="ew-table-header-caption"><?php echo $po_overall->usd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="usd" class="<?php echo $po_overall->usd->headerCellClass() ?>"><div><div id="elh_po_overall_usd" class="po_overall_usd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->usd->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->usd->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->usd->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->euro->Visible) { // euro ?>
	<?php if ($po_overall->sortUrl($po_overall->euro) == "") { ?>
		<th data-name="euro" class="<?php echo $po_overall->euro->headerCellClass() ?>"><div id="elh_po_overall_euro" class="po_overall_euro"><div class="ew-table-header-caption"><?php echo $po_overall->euro->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="euro" class="<?php echo $po_overall->euro->headerCellClass() ?>"><div><div id="elh_po_overall_euro" class="po_overall_euro">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->euro->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->euro->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->euro->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->inr->Visible) { // inr ?>
	<?php if ($po_overall->sortUrl($po_overall->inr) == "") { ?>
		<th data-name="inr" class="<?php echo $po_overall->inr->headerCellClass() ?>"><div id="elh_po_overall_inr" class="po_overall_inr"><div class="ew-table-header-caption"><?php echo $po_overall->inr->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="inr" class="<?php echo $po_overall->inr->headerCellClass() ?>"><div><div id="elh_po_overall_inr" class="po_overall_inr">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->inr->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->inr->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->inr->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->operator->Visible) { // operator ?>
	<?php if ($po_overall->sortUrl($po_overall->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $po_overall->operator->headerCellClass() ?>"><div id="elh_po_overall_operator" class="po_overall_operator"><div class="ew-table-header-caption"><?php echo $po_overall->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $po_overall->operator->headerCellClass() ?>"><div><div id="elh_po_overall_operator" class="po_overall_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->datetime->Visible) { // datetime ?>
	<?php if ($po_overall->sortUrl($po_overall->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $po_overall->datetime->headerCellClass() ?>"><div id="elh_po_overall_datetime" class="po_overall_datetime"><div class="ew-table-header-caption"><?php echo $po_overall->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $po_overall->datetime->headerCellClass() ?>"><div><div id="elh_po_overall_datetime" class="po_overall_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_overall_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$po_overall_grid->StartRec = 1;
$po_overall_grid->StopRec = $po_overall_grid->TotalRecs; // Show all records

// Restore number of post back records
if ($CurrentForm && $po_overall_grid->EventCancelled) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($po_overall_grid->FormKeyCountName) && ($po_overall->isGridAdd() || $po_overall->isGridEdit() || $po_overall->isConfirm())) {
		$po_overall_grid->KeyCount = $CurrentForm->getValue($po_overall_grid->FormKeyCountName);
		$po_overall_grid->StopRec = $po_overall_grid->StartRec + $po_overall_grid->KeyCount - 1;
	}
}
$po_overall_grid->RecCnt = $po_overall_grid->StartRec - 1;
if ($po_overall_grid->Recordset && !$po_overall_grid->Recordset->EOF) {
	$po_overall_grid->Recordset->moveFirst();
	$selectLimit = $po_overall_grid->UseSelectLimit;
	if (!$selectLimit && $po_overall_grid->StartRec > 1)
		$po_overall_grid->Recordset->move($po_overall_grid->StartRec - 1);
} elseif (!$po_overall->AllowAddDeleteRow && $po_overall_grid->StopRec == 0) {
	$po_overall_grid->StopRec = $po_overall->GridAddRowCount;
}

// Initialize aggregate
$po_overall->RowType = ROWTYPE_AGGREGATEINIT;
$po_overall->resetAttributes();
$po_overall_grid->renderRow();
if ($po_overall->isGridAdd())
	$po_overall_grid->RowIndex = 0;
if ($po_overall->isGridEdit())
	$po_overall_grid->RowIndex = 0;
while ($po_overall_grid->RecCnt < $po_overall_grid->StopRec) {
	$po_overall_grid->RecCnt++;
	if ($po_overall_grid->RecCnt >= $po_overall_grid->StartRec) {
		$po_overall_grid->RowCnt++;
		if ($po_overall->isGridAdd() || $po_overall->isGridEdit() || $po_overall->isConfirm()) {
			$po_overall_grid->RowIndex++;
			$CurrentForm->Index = $po_overall_grid->RowIndex;
			if ($CurrentForm->hasValue($po_overall_grid->FormActionName) && $po_overall_grid->EventCancelled)
				$po_overall_grid->RowAction = strval($CurrentForm->getValue($po_overall_grid->FormActionName));
			elseif ($po_overall->isGridAdd())
				$po_overall_grid->RowAction = "insert";
			else
				$po_overall_grid->RowAction = "";
		}

		// Set up key count
		$po_overall_grid->KeyCount = $po_overall_grid->RowIndex;

		// Init row class and style
		$po_overall->resetAttributes();
		$po_overall->CssClass = "";
		if ($po_overall->isGridAdd()) {
			if ($po_overall->CurrentMode == "copy") {
				$po_overall_grid->loadRowValues($po_overall_grid->Recordset); // Load row values
				$po_overall_grid->setRecordKey($po_overall_grid->RowOldKey, $po_overall_grid->Recordset); // Set old record key
			} else {
				$po_overall_grid->loadRowValues(); // Load default values
				$po_overall_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$po_overall_grid->loadRowValues($po_overall_grid->Recordset); // Load row values
		}
		$po_overall->RowType = ROWTYPE_VIEW; // Render view
		if ($po_overall->isGridAdd()) // Grid add
			$po_overall->RowType = ROWTYPE_ADD; // Render add
		if ($po_overall->isGridAdd() && $po_overall->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$po_overall_grid->restoreCurrentRowFormValues($po_overall_grid->RowIndex); // Restore form values
		if ($po_overall->isGridEdit()) { // Grid edit
			if ($po_overall->EventCancelled)
				$po_overall_grid->restoreCurrentRowFormValues($po_overall_grid->RowIndex); // Restore form values
			if ($po_overall_grid->RowAction == "insert")
				$po_overall->RowType = ROWTYPE_ADD; // Render add
			else
				$po_overall->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($po_overall->isGridEdit() && ($po_overall->RowType == ROWTYPE_EDIT || $po_overall->RowType == ROWTYPE_ADD) && $po_overall->EventCancelled) // Update failed
			$po_overall_grid->restoreCurrentRowFormValues($po_overall_grid->RowIndex); // Restore form values
		if ($po_overall->RowType == ROWTYPE_EDIT) // Edit row
			$po_overall_grid->EditRowCnt++;
		if ($po_overall->isConfirm()) // Confirm row
			$po_overall_grid->restoreCurrentRowFormValues($po_overall_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$po_overall->RowAttrs = array_merge($po_overall->RowAttrs, array('data-rowindex'=>$po_overall_grid->RowCnt, 'id'=>'r' . $po_overall_grid->RowCnt . '_po_overall', 'data-rowtype'=>$po_overall->RowType));

		// Render row
		$po_overall_grid->renderRow();

		// Render list options
		$po_overall_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($po_overall_grid->RowAction <> "delete" && $po_overall_grid->RowAction <> "insertdelete" && !($po_overall_grid->RowAction == "insert" && $po_overall->isConfirm() && $po_overall_grid->emptyRow())) {
?>
	<tr<?php echo $po_overall->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_overall_grid->ListOptions->render("body", "left", $po_overall_grid->RowCnt);
?>
	<?php if ($po_overall->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_overall->id->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="po_overall" data-field="x_id" name="o<?php echo $po_overall_grid->RowIndex ?>_id" id="o<?php echo $po_overall_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($po_overall->id->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_id" class="form-group po_overall_id">
<span<?php echo $po_overall->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_id" name="x<?php echo $po_overall_grid->RowIndex ?>_id" id="x<?php echo $po_overall_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($po_overall->id->CurrentValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_id" class="po_overall_id">
<span<?php echo $po_overall->id->viewAttributes() ?>>
<?php echo $po_overall->id->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_id" name="x<?php echo $po_overall_grid->RowIndex ?>_id" id="x<?php echo $po_overall_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($po_overall->id->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_id" name="o<?php echo $po_overall_grid->RowIndex ?>_id" id="o<?php echo $po_overall_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($po_overall->id->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_id" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_id" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($po_overall->id->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_id" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_id" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($po_overall->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $po_overall->buyer_id->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($po_overall->buyer_id->getSessionValue() <> "") { ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_buyer_id" class="form-group po_overall_buyer_id">
<span<?php echo $po_overall->buyer_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->buyer_id->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" name="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_buyer_id" class="form-group po_overall_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_buyer_id" data-value-separator="<?php echo $po_overall->buyer_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" name="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id"<?php echo $po_overall->buyer_id->editAttributes() ?>>
		<?php echo $po_overall->buyer_id->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_buyer_id") ?>
	</select>
</div>
<?php echo $po_overall->buyer_id->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_buyer_id") ?>
</span>
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" name="o<?php echo $po_overall_grid->RowIndex ?>_buyer_id" id="o<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($po_overall->buyer_id->getSessionValue() <> "") { ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_buyer_id" class="form-group po_overall_buyer_id">
<span<?php echo $po_overall->buyer_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->buyer_id->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" name="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_buyer_id" class="form-group po_overall_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_buyer_id" data-value-separator="<?php echo $po_overall->buyer_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" name="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id"<?php echo $po_overall->buyer_id->editAttributes() ?>>
		<?php echo $po_overall->buyer_id->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_buyer_id") ?>
	</select>
</div>
<?php echo $po_overall->buyer_id->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_buyer_id") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_buyer_id" class="po_overall_buyer_id">
<span<?php echo $po_overall->buyer_id->viewAttributes() ?>>
<?php echo $po_overall->buyer_id->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" name="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" id="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" name="o<?php echo $po_overall_grid->RowIndex ?>_buyer_id" id="o<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_buyer_id" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $po_overall->reports_to->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_reports_to" class="form-group po_overall_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_reports_to" data-value-separator="<?php echo $po_overall->reports_to->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_reports_to" name="x<?php echo $po_overall_grid->RowIndex ?>_reports_to"<?php echo $po_overall->reports_to->editAttributes() ?>>
		<?php echo $po_overall->reports_to->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_reports_to") ?>
	</select>
</div>
<?php echo $po_overall->reports_to->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_reports_to") ?>
</span>
<input type="hidden" data-table="po_overall" data-field="x_reports_to" name="o<?php echo $po_overall_grid->RowIndex ?>_reports_to" id="o<?php echo $po_overall_grid->RowIndex ?>_reports_to" value="<?php echo HtmlEncode($po_overall->reports_to->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_reports_to" class="form-group po_overall_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_reports_to" data-value-separator="<?php echo $po_overall->reports_to->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_reports_to" name="x<?php echo $po_overall_grid->RowIndex ?>_reports_to"<?php echo $po_overall->reports_to->editAttributes() ?>>
		<?php echo $po_overall->reports_to->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_reports_to") ?>
	</select>
</div>
<?php echo $po_overall->reports_to->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_reports_to") ?>
</span>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_reports_to" class="po_overall_reports_to">
<span<?php echo $po_overall->reports_to->viewAttributes() ?>>
<?php echo $po_overall->reports_to->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_reports_to" name="x<?php echo $po_overall_grid->RowIndex ?>_reports_to" id="x<?php echo $po_overall_grid->RowIndex ?>_reports_to" value="<?php echo HtmlEncode($po_overall->reports_to->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_reports_to" name="o<?php echo $po_overall_grid->RowIndex ?>_reports_to" id="o<?php echo $po_overall_grid->RowIndex ?>_reports_to" value="<?php echo HtmlEncode($po_overall->reports_to->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_reports_to" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_reports_to" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_reports_to" value="<?php echo HtmlEncode($po_overall->reports_to->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_reports_to" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_reports_to" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_reports_to" value="<?php echo HtmlEncode($po_overall->reports_to->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->year->Visible) { // year ?>
		<td data-name="year"<?php echo $po_overall->year->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_year" class="form-group po_overall_year">
<input type="text" data-table="po_overall" data-field="x_year" name="x<?php echo $po_overall_grid->RowIndex ?>_year" id="x<?php echo $po_overall_grid->RowIndex ?>_year" size="30" placeholder="<?php echo HtmlEncode($po_overall->year->getPlaceHolder()) ?>" value="<?php echo $po_overall->year->EditValue ?>"<?php echo $po_overall->year->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_overall" data-field="x_year" name="o<?php echo $po_overall_grid->RowIndex ?>_year" id="o<?php echo $po_overall_grid->RowIndex ?>_year" value="<?php echo HtmlEncode($po_overall->year->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_year" class="form-group po_overall_year">
<input type="text" data-table="po_overall" data-field="x_year" name="x<?php echo $po_overall_grid->RowIndex ?>_year" id="x<?php echo $po_overall_grid->RowIndex ?>_year" size="30" placeholder="<?php echo HtmlEncode($po_overall->year->getPlaceHolder()) ?>" value="<?php echo $po_overall->year->EditValue ?>"<?php echo $po_overall->year->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_year" class="po_overall_year">
<span<?php echo $po_overall->year->viewAttributes() ?>>
<?php echo $po_overall->year->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_year" name="x<?php echo $po_overall_grid->RowIndex ?>_year" id="x<?php echo $po_overall_grid->RowIndex ?>_year" value="<?php echo HtmlEncode($po_overall->year->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_year" name="o<?php echo $po_overall_grid->RowIndex ?>_year" id="o<?php echo $po_overall_grid->RowIndex ?>_year" value="<?php echo HtmlEncode($po_overall->year->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_year" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_year" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_year" value="<?php echo HtmlEncode($po_overall->year->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_year" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_year" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_year" value="<?php echo HtmlEncode($po_overall->year->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->month->Visible) { // month ?>
		<td data-name="month"<?php echo $po_overall->month->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_month" class="form-group po_overall_month">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_month" data-value-separator="<?php echo $po_overall->month->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_month" name="x<?php echo $po_overall_grid->RowIndex ?>_month"<?php echo $po_overall->month->editAttributes() ?>>
		<?php echo $po_overall->month->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_month") ?>
	</select>
</div>
<?php echo $po_overall->month->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_month") ?>
</span>
<input type="hidden" data-table="po_overall" data-field="x_month" name="o<?php echo $po_overall_grid->RowIndex ?>_month" id="o<?php echo $po_overall_grid->RowIndex ?>_month" value="<?php echo HtmlEncode($po_overall->month->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_month" class="form-group po_overall_month">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_month" data-value-separator="<?php echo $po_overall->month->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_month" name="x<?php echo $po_overall_grid->RowIndex ?>_month"<?php echo $po_overall->month->editAttributes() ?>>
		<?php echo $po_overall->month->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_month") ?>
	</select>
</div>
<?php echo $po_overall->month->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_month") ?>
</span>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_month" class="po_overall_month">
<span<?php echo $po_overall->month->viewAttributes() ?>>
<?php echo $po_overall->month->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_month" name="x<?php echo $po_overall_grid->RowIndex ?>_month" id="x<?php echo $po_overall_grid->RowIndex ?>_month" value="<?php echo HtmlEncode($po_overall->month->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_month" name="o<?php echo $po_overall_grid->RowIndex ?>_month" id="o<?php echo $po_overall_grid->RowIndex ?>_month" value="<?php echo HtmlEncode($po_overall->month->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_month" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_month" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_month" value="<?php echo HtmlEncode($po_overall->month->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_month" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_month" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_month" value="<?php echo HtmlEncode($po_overall->month->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $po_overall->sqm->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_sqm" class="form-group po_overall_sqm">
<input type="text" data-table="po_overall" data-field="x_sqm" name="x<?php echo $po_overall_grid->RowIndex ?>_sqm" id="x<?php echo $po_overall_grid->RowIndex ?>_sqm" size="30" placeholder="<?php echo HtmlEncode($po_overall->sqm->getPlaceHolder()) ?>" value="<?php echo $po_overall->sqm->EditValue ?>"<?php echo $po_overall->sqm->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_overall" data-field="x_sqm" name="o<?php echo $po_overall_grid->RowIndex ?>_sqm" id="o<?php echo $po_overall_grid->RowIndex ?>_sqm" value="<?php echo HtmlEncode($po_overall->sqm->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_sqm" class="form-group po_overall_sqm">
<input type="text" data-table="po_overall" data-field="x_sqm" name="x<?php echo $po_overall_grid->RowIndex ?>_sqm" id="x<?php echo $po_overall_grid->RowIndex ?>_sqm" size="30" placeholder="<?php echo HtmlEncode($po_overall->sqm->getPlaceHolder()) ?>" value="<?php echo $po_overall->sqm->EditValue ?>"<?php echo $po_overall->sqm->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_sqm" class="po_overall_sqm">
<span<?php echo $po_overall->sqm->viewAttributes() ?>>
<?php echo $po_overall->sqm->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_sqm" name="x<?php echo $po_overall_grid->RowIndex ?>_sqm" id="x<?php echo $po_overall_grid->RowIndex ?>_sqm" value="<?php echo HtmlEncode($po_overall->sqm->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_sqm" name="o<?php echo $po_overall_grid->RowIndex ?>_sqm" id="o<?php echo $po_overall_grid->RowIndex ?>_sqm" value="<?php echo HtmlEncode($po_overall->sqm->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_sqm" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_sqm" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_sqm" value="<?php echo HtmlEncode($po_overall->sqm->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_sqm" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_sqm" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_sqm" value="<?php echo HtmlEncode($po_overall->sqm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->usd->Visible) { // usd ?>
		<td data-name="usd"<?php echo $po_overall->usd->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_usd" class="form-group po_overall_usd">
<input type="text" data-table="po_overall" data-field="x_usd" name="x<?php echo $po_overall_grid->RowIndex ?>_usd" id="x<?php echo $po_overall_grid->RowIndex ?>_usd" size="30" placeholder="<?php echo HtmlEncode($po_overall->usd->getPlaceHolder()) ?>" value="<?php echo $po_overall->usd->EditValue ?>"<?php echo $po_overall->usd->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_overall" data-field="x_usd" name="o<?php echo $po_overall_grid->RowIndex ?>_usd" id="o<?php echo $po_overall_grid->RowIndex ?>_usd" value="<?php echo HtmlEncode($po_overall->usd->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_usd" class="form-group po_overall_usd">
<input type="text" data-table="po_overall" data-field="x_usd" name="x<?php echo $po_overall_grid->RowIndex ?>_usd" id="x<?php echo $po_overall_grid->RowIndex ?>_usd" size="30" placeholder="<?php echo HtmlEncode($po_overall->usd->getPlaceHolder()) ?>" value="<?php echo $po_overall->usd->EditValue ?>"<?php echo $po_overall->usd->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_usd" class="po_overall_usd">
<span<?php echo $po_overall->usd->viewAttributes() ?>>
<?php echo $po_overall->usd->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_usd" name="x<?php echo $po_overall_grid->RowIndex ?>_usd" id="x<?php echo $po_overall_grid->RowIndex ?>_usd" value="<?php echo HtmlEncode($po_overall->usd->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_usd" name="o<?php echo $po_overall_grid->RowIndex ?>_usd" id="o<?php echo $po_overall_grid->RowIndex ?>_usd" value="<?php echo HtmlEncode($po_overall->usd->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_usd" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_usd" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_usd" value="<?php echo HtmlEncode($po_overall->usd->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_usd" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_usd" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_usd" value="<?php echo HtmlEncode($po_overall->usd->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->euro->Visible) { // euro ?>
		<td data-name="euro"<?php echo $po_overall->euro->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_euro" class="form-group po_overall_euro">
<input type="text" data-table="po_overall" data-field="x_euro" name="x<?php echo $po_overall_grid->RowIndex ?>_euro" id="x<?php echo $po_overall_grid->RowIndex ?>_euro" size="30" placeholder="<?php echo HtmlEncode($po_overall->euro->getPlaceHolder()) ?>" value="<?php echo $po_overall->euro->EditValue ?>"<?php echo $po_overall->euro->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_overall" data-field="x_euro" name="o<?php echo $po_overall_grid->RowIndex ?>_euro" id="o<?php echo $po_overall_grid->RowIndex ?>_euro" value="<?php echo HtmlEncode($po_overall->euro->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_euro" class="form-group po_overall_euro">
<input type="text" data-table="po_overall" data-field="x_euro" name="x<?php echo $po_overall_grid->RowIndex ?>_euro" id="x<?php echo $po_overall_grid->RowIndex ?>_euro" size="30" placeholder="<?php echo HtmlEncode($po_overall->euro->getPlaceHolder()) ?>" value="<?php echo $po_overall->euro->EditValue ?>"<?php echo $po_overall->euro->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_euro" class="po_overall_euro">
<span<?php echo $po_overall->euro->viewAttributes() ?>>
<?php echo $po_overall->euro->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_euro" name="x<?php echo $po_overall_grid->RowIndex ?>_euro" id="x<?php echo $po_overall_grid->RowIndex ?>_euro" value="<?php echo HtmlEncode($po_overall->euro->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_euro" name="o<?php echo $po_overall_grid->RowIndex ?>_euro" id="o<?php echo $po_overall_grid->RowIndex ?>_euro" value="<?php echo HtmlEncode($po_overall->euro->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_euro" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_euro" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_euro" value="<?php echo HtmlEncode($po_overall->euro->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_euro" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_euro" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_euro" value="<?php echo HtmlEncode($po_overall->euro->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->inr->Visible) { // inr ?>
		<td data-name="inr"<?php echo $po_overall->inr->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_inr" class="form-group po_overall_inr">
<input type="text" data-table="po_overall" data-field="x_inr" name="x<?php echo $po_overall_grid->RowIndex ?>_inr" id="x<?php echo $po_overall_grid->RowIndex ?>_inr" size="30" placeholder="<?php echo HtmlEncode($po_overall->inr->getPlaceHolder()) ?>" value="<?php echo $po_overall->inr->EditValue ?>"<?php echo $po_overall->inr->editAttributes() ?>>
</span>
<input type="hidden" data-table="po_overall" data-field="x_inr" name="o<?php echo $po_overall_grid->RowIndex ?>_inr" id="o<?php echo $po_overall_grid->RowIndex ?>_inr" value="<?php echo HtmlEncode($po_overall->inr->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_inr" class="form-group po_overall_inr">
<input type="text" data-table="po_overall" data-field="x_inr" name="x<?php echo $po_overall_grid->RowIndex ?>_inr" id="x<?php echo $po_overall_grid->RowIndex ?>_inr" size="30" placeholder="<?php echo HtmlEncode($po_overall->inr->getPlaceHolder()) ?>" value="<?php echo $po_overall->inr->EditValue ?>"<?php echo $po_overall->inr->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_inr" class="po_overall_inr">
<span<?php echo $po_overall->inr->viewAttributes() ?>>
<?php echo $po_overall->inr->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_inr" name="x<?php echo $po_overall_grid->RowIndex ?>_inr" id="x<?php echo $po_overall_grid->RowIndex ?>_inr" value="<?php echo HtmlEncode($po_overall->inr->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_inr" name="o<?php echo $po_overall_grid->RowIndex ?>_inr" id="o<?php echo $po_overall_grid->RowIndex ?>_inr" value="<?php echo HtmlEncode($po_overall->inr->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_inr" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_inr" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_inr" value="<?php echo HtmlEncode($po_overall->inr->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_inr" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_inr" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_inr" value="<?php echo HtmlEncode($po_overall->inr->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $po_overall->operator->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="po_overall" data-field="x_operator" name="o<?php echo $po_overall_grid->RowIndex ?>_operator" id="o<?php echo $po_overall_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($po_overall->operator->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_operator" class="po_overall_operator">
<span<?php echo $po_overall->operator->viewAttributes() ?>>
<?php echo $po_overall->operator->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_operator" name="x<?php echo $po_overall_grid->RowIndex ?>_operator" id="x<?php echo $po_overall_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($po_overall->operator->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_operator" name="o<?php echo $po_overall_grid->RowIndex ?>_operator" id="o<?php echo $po_overall_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($po_overall->operator->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_operator" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_operator" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($po_overall->operator->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_operator" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_operator" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($po_overall->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($po_overall->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $po_overall->datetime->cellAttributes() ?>>
<?php if ($po_overall->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="po_overall" data-field="x_datetime" name="o<?php echo $po_overall_grid->RowIndex ?>_datetime" id="o<?php echo $po_overall_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($po_overall->datetime->OldValue) ?>">
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php } ?>
<?php if ($po_overall->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $po_overall_grid->RowCnt ?>_po_overall_datetime" class="po_overall_datetime">
<span<?php echo $po_overall->datetime->viewAttributes() ?>>
<?php echo $po_overall->datetime->getViewValue() ?></span>
</span>
<?php if (!$po_overall->isConfirm()) { ?>
<input type="hidden" data-table="po_overall" data-field="x_datetime" name="x<?php echo $po_overall_grid->RowIndex ?>_datetime" id="x<?php echo $po_overall_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($po_overall->datetime->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_datetime" name="o<?php echo $po_overall_grid->RowIndex ?>_datetime" id="o<?php echo $po_overall_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($po_overall->datetime->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="po_overall" data-field="x_datetime" name="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_datetime" id="fpo_overallgrid$x<?php echo $po_overall_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($po_overall->datetime->FormValue) ?>">
<input type="hidden" data-table="po_overall" data-field="x_datetime" name="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_datetime" id="fpo_overallgrid$o<?php echo $po_overall_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($po_overall->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_overall_grid->ListOptions->render("body", "right", $po_overall_grid->RowCnt);
?>
	</tr>
<?php if ($po_overall->RowType == ROWTYPE_ADD || $po_overall->RowType == ROWTYPE_EDIT) { ?>
<script>
fpo_overallgrid.updateLists(<?php echo $po_overall_grid->RowIndex ?>);
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$po_overall->isGridAdd() || $po_overall->CurrentMode == "copy")
		if (!$po_overall_grid->Recordset->EOF)
			$po_overall_grid->Recordset->moveNext();
}
?>
<?php
	if ($po_overall->CurrentMode == "add" || $po_overall->CurrentMode == "copy" || $po_overall->CurrentMode == "edit") {
		$po_overall_grid->RowIndex = '$rowindex$';
		$po_overall_grid->loadRowValues();

		// Set row properties
		$po_overall->resetAttributes();
		$po_overall->RowAttrs = array_merge($po_overall->RowAttrs, array('data-rowindex'=>$po_overall_grid->RowIndex, 'id'=>'r0_po_overall', 'data-rowtype'=>ROWTYPE_ADD));
		AppendClass($po_overall->RowAttrs["class"], "ew-template");
		$po_overall->RowType = ROWTYPE_ADD;

		// Render row
		$po_overall_grid->renderRow();

		// Render list options
		$po_overall_grid->renderListOptions();
		$po_overall_grid->StartRowCnt = 0;
?>
	<tr<?php echo $po_overall->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_overall_grid->ListOptions->render("body", "left", $po_overall_grid->RowIndex);
?>
	<?php if ($po_overall->id->Visible) { // id ?>
		<td data-name="id">
<?php if (!$po_overall->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_po_overall_id" class="form-group po_overall_id">
<span<?php echo $po_overall->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->id->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_id" name="x<?php echo $po_overall_grid->RowIndex ?>_id" id="x<?php echo $po_overall_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($po_overall->id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_id" name="o<?php echo $po_overall_grid->RowIndex ?>_id" id="o<?php echo $po_overall_grid->RowIndex ?>_id" value="<?php echo HtmlEncode($po_overall->id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id">
<?php if (!$po_overall->isConfirm()) { ?>
<?php if ($po_overall->buyer_id->getSessionValue() <> "") { ?>
<span id="el$rowindex$_po_overall_buyer_id" class="form-group po_overall_buyer_id">
<span<?php echo $po_overall->buyer_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->buyer_id->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" name="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_po_overall_buyer_id" class="form-group po_overall_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_buyer_id" data-value-separator="<?php echo $po_overall->buyer_id->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" name="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id"<?php echo $po_overall->buyer_id->editAttributes() ?>>
		<?php echo $po_overall->buyer_id->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_buyer_id") ?>
	</select>
</div>
<?php echo $po_overall->buyer_id->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_buyer_id") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_po_overall_buyer_id" class="form-group po_overall_buyer_id">
<span<?php echo $po_overall->buyer_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->buyer_id->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" name="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" id="x<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_buyer_id" name="o<?php echo $po_overall_grid->RowIndex ?>_buyer_id" id="o<?php echo $po_overall_grid->RowIndex ?>_buyer_id" value="<?php echo HtmlEncode($po_overall->buyer_id->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to">
<?php if (!$po_overall->isConfirm()) { ?>
<span id="el$rowindex$_po_overall_reports_to" class="form-group po_overall_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_reports_to" data-value-separator="<?php echo $po_overall->reports_to->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_reports_to" name="x<?php echo $po_overall_grid->RowIndex ?>_reports_to"<?php echo $po_overall->reports_to->editAttributes() ?>>
		<?php echo $po_overall->reports_to->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_reports_to") ?>
	</select>
</div>
<?php echo $po_overall->reports_to->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_reports_to") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_po_overall_reports_to" class="form-group po_overall_reports_to">
<span<?php echo $po_overall->reports_to->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->reports_to->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_reports_to" name="x<?php echo $po_overall_grid->RowIndex ?>_reports_to" id="x<?php echo $po_overall_grid->RowIndex ?>_reports_to" value="<?php echo HtmlEncode($po_overall->reports_to->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_reports_to" name="o<?php echo $po_overall_grid->RowIndex ?>_reports_to" id="o<?php echo $po_overall_grid->RowIndex ?>_reports_to" value="<?php echo HtmlEncode($po_overall->reports_to->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->year->Visible) { // year ?>
		<td data-name="year">
<?php if (!$po_overall->isConfirm()) { ?>
<span id="el$rowindex$_po_overall_year" class="form-group po_overall_year">
<input type="text" data-table="po_overall" data-field="x_year" name="x<?php echo $po_overall_grid->RowIndex ?>_year" id="x<?php echo $po_overall_grid->RowIndex ?>_year" size="30" placeholder="<?php echo HtmlEncode($po_overall->year->getPlaceHolder()) ?>" value="<?php echo $po_overall->year->EditValue ?>"<?php echo $po_overall->year->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_po_overall_year" class="form-group po_overall_year">
<span<?php echo $po_overall->year->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->year->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_year" name="x<?php echo $po_overall_grid->RowIndex ?>_year" id="x<?php echo $po_overall_grid->RowIndex ?>_year" value="<?php echo HtmlEncode($po_overall->year->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_year" name="o<?php echo $po_overall_grid->RowIndex ?>_year" id="o<?php echo $po_overall_grid->RowIndex ?>_year" value="<?php echo HtmlEncode($po_overall->year->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->month->Visible) { // month ?>
		<td data-name="month">
<?php if (!$po_overall->isConfirm()) { ?>
<span id="el$rowindex$_po_overall_month" class="form-group po_overall_month">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_month" data-value-separator="<?php echo $po_overall->month->displayValueSeparatorAttribute() ?>" id="x<?php echo $po_overall_grid->RowIndex ?>_month" name="x<?php echo $po_overall_grid->RowIndex ?>_month"<?php echo $po_overall->month->editAttributes() ?>>
		<?php echo $po_overall->month->selectOptionListHtml("x<?php echo $po_overall_grid->RowIndex ?>_month") ?>
	</select>
</div>
<?php echo $po_overall->month->Lookup->getParamTag("p_x" . $po_overall_grid->RowIndex . "_month") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_po_overall_month" class="form-group po_overall_month">
<span<?php echo $po_overall->month->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->month->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_month" name="x<?php echo $po_overall_grid->RowIndex ?>_month" id="x<?php echo $po_overall_grid->RowIndex ?>_month" value="<?php echo HtmlEncode($po_overall->month->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_month" name="o<?php echo $po_overall_grid->RowIndex ?>_month" id="o<?php echo $po_overall_grid->RowIndex ?>_month" value="<?php echo HtmlEncode($po_overall->month->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->sqm->Visible) { // sqm ?>
		<td data-name="sqm">
<?php if (!$po_overall->isConfirm()) { ?>
<span id="el$rowindex$_po_overall_sqm" class="form-group po_overall_sqm">
<input type="text" data-table="po_overall" data-field="x_sqm" name="x<?php echo $po_overall_grid->RowIndex ?>_sqm" id="x<?php echo $po_overall_grid->RowIndex ?>_sqm" size="30" placeholder="<?php echo HtmlEncode($po_overall->sqm->getPlaceHolder()) ?>" value="<?php echo $po_overall->sqm->EditValue ?>"<?php echo $po_overall->sqm->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_po_overall_sqm" class="form-group po_overall_sqm">
<span<?php echo $po_overall->sqm->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->sqm->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_sqm" name="x<?php echo $po_overall_grid->RowIndex ?>_sqm" id="x<?php echo $po_overall_grid->RowIndex ?>_sqm" value="<?php echo HtmlEncode($po_overall->sqm->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_sqm" name="o<?php echo $po_overall_grid->RowIndex ?>_sqm" id="o<?php echo $po_overall_grid->RowIndex ?>_sqm" value="<?php echo HtmlEncode($po_overall->sqm->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->usd->Visible) { // usd ?>
		<td data-name="usd">
<?php if (!$po_overall->isConfirm()) { ?>
<span id="el$rowindex$_po_overall_usd" class="form-group po_overall_usd">
<input type="text" data-table="po_overall" data-field="x_usd" name="x<?php echo $po_overall_grid->RowIndex ?>_usd" id="x<?php echo $po_overall_grid->RowIndex ?>_usd" size="30" placeholder="<?php echo HtmlEncode($po_overall->usd->getPlaceHolder()) ?>" value="<?php echo $po_overall->usd->EditValue ?>"<?php echo $po_overall->usd->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_po_overall_usd" class="form-group po_overall_usd">
<span<?php echo $po_overall->usd->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->usd->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_usd" name="x<?php echo $po_overall_grid->RowIndex ?>_usd" id="x<?php echo $po_overall_grid->RowIndex ?>_usd" value="<?php echo HtmlEncode($po_overall->usd->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_usd" name="o<?php echo $po_overall_grid->RowIndex ?>_usd" id="o<?php echo $po_overall_grid->RowIndex ?>_usd" value="<?php echo HtmlEncode($po_overall->usd->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->euro->Visible) { // euro ?>
		<td data-name="euro">
<?php if (!$po_overall->isConfirm()) { ?>
<span id="el$rowindex$_po_overall_euro" class="form-group po_overall_euro">
<input type="text" data-table="po_overall" data-field="x_euro" name="x<?php echo $po_overall_grid->RowIndex ?>_euro" id="x<?php echo $po_overall_grid->RowIndex ?>_euro" size="30" placeholder="<?php echo HtmlEncode($po_overall->euro->getPlaceHolder()) ?>" value="<?php echo $po_overall->euro->EditValue ?>"<?php echo $po_overall->euro->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_po_overall_euro" class="form-group po_overall_euro">
<span<?php echo $po_overall->euro->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->euro->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_euro" name="x<?php echo $po_overall_grid->RowIndex ?>_euro" id="x<?php echo $po_overall_grid->RowIndex ?>_euro" value="<?php echo HtmlEncode($po_overall->euro->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_euro" name="o<?php echo $po_overall_grid->RowIndex ?>_euro" id="o<?php echo $po_overall_grid->RowIndex ?>_euro" value="<?php echo HtmlEncode($po_overall->euro->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->inr->Visible) { // inr ?>
		<td data-name="inr">
<?php if (!$po_overall->isConfirm()) { ?>
<span id="el$rowindex$_po_overall_inr" class="form-group po_overall_inr">
<input type="text" data-table="po_overall" data-field="x_inr" name="x<?php echo $po_overall_grid->RowIndex ?>_inr" id="x<?php echo $po_overall_grid->RowIndex ?>_inr" size="30" placeholder="<?php echo HtmlEncode($po_overall->inr->getPlaceHolder()) ?>" value="<?php echo $po_overall->inr->EditValue ?>"<?php echo $po_overall->inr->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_po_overall_inr" class="form-group po_overall_inr">
<span<?php echo $po_overall->inr->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->inr->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_inr" name="x<?php echo $po_overall_grid->RowIndex ?>_inr" id="x<?php echo $po_overall_grid->RowIndex ?>_inr" value="<?php echo HtmlEncode($po_overall->inr->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_inr" name="o<?php echo $po_overall_grid->RowIndex ?>_inr" id="o<?php echo $po_overall_grid->RowIndex ?>_inr" value="<?php echo HtmlEncode($po_overall->inr->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->operator->Visible) { // operator ?>
		<td data-name="operator">
<?php if (!$po_overall->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_po_overall_operator" class="form-group po_overall_operator">
<span<?php echo $po_overall->operator->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->operator->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_operator" name="x<?php echo $po_overall_grid->RowIndex ?>_operator" id="x<?php echo $po_overall_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($po_overall->operator->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_operator" name="o<?php echo $po_overall_grid->RowIndex ?>_operator" id="o<?php echo $po_overall_grid->RowIndex ?>_operator" value="<?php echo HtmlEncode($po_overall->operator->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($po_overall->datetime->Visible) { // datetime ?>
		<td data-name="datetime">
<?php if (!$po_overall->isConfirm()) { ?>
<?php } else { ?>
<span id="el$rowindex$_po_overall_datetime" class="form-group po_overall_datetime">
<span<?php echo $po_overall->datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($po_overall->datetime->ViewValue) ?>"></span>
</span>
<input type="hidden" data-table="po_overall" data-field="x_datetime" name="x<?php echo $po_overall_grid->RowIndex ?>_datetime" id="x<?php echo $po_overall_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($po_overall->datetime->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="po_overall" data-field="x_datetime" name="o<?php echo $po_overall_grid->RowIndex ?>_datetime" id="o<?php echo $po_overall_grid->RowIndex ?>_datetime" value="<?php echo HtmlEncode($po_overall->datetime->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_overall_grid->ListOptions->render("body", "right", $po_overall_grid->RowIndex);
?>
<script>
fpo_overallgrid.updateLists(<?php echo $po_overall_grid->RowIndex ?>);
</script>
	</tr>
<?php
}
?>
</tbody>
<?php

// Render aggregate row
$po_overall->RowType = ROWTYPE_AGGREGATE;
$po_overall->resetAttributes();
$po_overall_grid->renderRow();
?>
<?php if ($po_overall_grid->TotalRecs > 0 && $po_overall->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$po_overall_grid->renderListOptions();

// Render list options (footer, left)
$po_overall_grid->ListOptions->render("footer", "left");
?>
	<?php if ($po_overall->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $po_overall->id->footerCellClass() ?>"><span id="elf_po_overall_id" class="po_overall_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $po_overall->buyer_id->footerCellClass() ?>"><span id="elf_po_overall_buyer_id" class="po_overall_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to" class="<?php echo $po_overall->reports_to->footerCellClass() ?>"><span id="elf_po_overall_reports_to" class="po_overall_reports_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->year->Visible) { // year ?>
		<td data-name="year" class="<?php echo $po_overall->year->footerCellClass() ?>"><span id="elf_po_overall_year" class="po_overall_year">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->month->Visible) { // month ?>
		<td data-name="month" class="<?php echo $po_overall->month->footerCellClass() ?>"><span id="elf_po_overall_month" class="po_overall_month">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $po_overall->sqm->footerCellClass() ?>"><span id="elf_po_overall_sqm" class="po_overall_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_overall->usd->Visible) { // usd ?>
		<td data-name="usd" class="<?php echo $po_overall->usd->footerCellClass() ?>"><span id="elf_po_overall_usd" class="po_overall_usd">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->usd->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_overall->euro->Visible) { // euro ?>
		<td data-name="euro" class="<?php echo $po_overall->euro->footerCellClass() ?>"><span id="elf_po_overall_euro" class="po_overall_euro">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->euro->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_overall->inr->Visible) { // inr ?>
		<td data-name="inr" class="<?php echo $po_overall->inr->footerCellClass() ?>"><span id="elf_po_overall_inr" class="po_overall_inr">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->inr->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_overall->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $po_overall->operator->footerCellClass() ?>"><span id="elf_po_overall_operator" class="po_overall_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $po_overall->datetime->footerCellClass() ?>"><span id="elf_po_overall_datetime" class="po_overall_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$po_overall_grid->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($po_overall->CurrentMode == "add" || $po_overall->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $po_overall_grid->FormKeyCountName ?>" id="<?php echo $po_overall_grid->FormKeyCountName ?>" value="<?php echo $po_overall_grid->KeyCount ?>">
<?php echo $po_overall_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($po_overall->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $po_overall_grid->FormKeyCountName ?>" id="<?php echo $po_overall_grid->FormKeyCountName ?>" value="<?php echo $po_overall_grid->KeyCount ?>">
<?php echo $po_overall_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($po_overall->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpo_overallgrid">
</div><!-- /.ew-grid-middle-panel -->
<?php

// Close recordset
if ($po_overall_grid->Recordset)
	$po_overall_grid->Recordset->Close();
?>
</div>
<?php if ($po_overall_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $po_overall_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_overall_grid->TotalRecs == 0 && !$po_overall->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_overall_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_overall_grid->terminate();
?>
<?php if (!$po_overall->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_overall", "100%", "500px");
</script>
<?php } ?>