<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_overall_list = new po_overall_list();

// Run the page
$po_overall_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_overall_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_overall->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_overalllist = currentForm = new ew.Form("fpo_overalllist", "list");
fpo_overalllist.formKeyCountName = '<?php echo $po_overall_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_overalllist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overalllist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overalllist.lists["x_buyer_id"] = <?php echo $po_overall_list->buyer_id->Lookup->toClientList() ?>;
fpo_overalllist.lists["x_buyer_id"].options = <?php echo JsonEncode($po_overall_list->buyer_id->lookupOptions()) ?>;
fpo_overalllist.lists["x_reports_to"] = <?php echo $po_overall_list->reports_to->Lookup->toClientList() ?>;
fpo_overalllist.lists["x_reports_to"].options = <?php echo JsonEncode($po_overall_list->reports_to->lookupOptions()) ?>;
fpo_overalllist.lists["x_month"] = <?php echo $po_overall_list->month->Lookup->toClientList() ?>;
fpo_overalllist.lists["x_month"].options = <?php echo JsonEncode($po_overall_list->month->lookupOptions()) ?>;
fpo_overalllist.lists["x_operator"] = <?php echo $po_overall_list->operator->Lookup->toClientList() ?>;
fpo_overalllist.lists["x_operator"].options = <?php echo JsonEncode($po_overall_list->operator->lookupOptions()) ?>;

// Form object for search
var fpo_overalllistsrch = currentSearchForm = new ew.Form("fpo_overalllistsrch");

// Validate function for search
fpo_overalllistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_year");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall->year->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_overalllistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overalllistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overalllistsrch.lists["x_buyer_id"] = <?php echo $po_overall_list->buyer_id->Lookup->toClientList() ?>;
fpo_overalllistsrch.lists["x_buyer_id"].options = <?php echo JsonEncode($po_overall_list->buyer_id->lookupOptions()) ?>;
fpo_overalllistsrch.lists["x_reports_to"] = <?php echo $po_overall_list->reports_to->Lookup->toClientList() ?>;
fpo_overalllistsrch.lists["x_reports_to"].options = <?php echo JsonEncode($po_overall_list->reports_to->lookupOptions()) ?>;
fpo_overalllistsrch.lists["x_month"] = <?php echo $po_overall_list->month->Lookup->toClientList() ?>;
fpo_overalllistsrch.lists["x_month"].options = <?php echo JsonEncode($po_overall_list->month->lookupOptions()) ?>;

// Filters
fpo_overalllistsrch.filterList = <?php echo $po_overall_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_overalllistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_overall->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_overall_list->TotalRecs > 0 && $po_overall_list->ExportOptions->visible()) { ?>
<?php $po_overall_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_overall_list->ImportOptions->visible()) { ?>
<?php $po_overall_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_overall_list->SearchOptions->visible()) { ?>
<?php $po_overall_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_overall_list->FilterOptions->visible()) { ?>
<?php $po_overall_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$po_overall->isExport() || EXPORT_MASTER_RECORD && $po_overall->isExport("print")) { ?>
<?php
if ($po_overall_list->DbMasterFilter <> "" && $po_overall->getCurrentMasterTable() == "po_overall_compiled") {
	if ($po_overall_list->MasterRecordExists) {
		include_once "po_overall_compiledmaster.php";
	}
}
?>
<?php } ?>
<?php
$po_overall_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_overall->isExport() && !$po_overall->CurrentAction) { ?>
<form name="fpo_overalllistsrch" id="fpo_overalllistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_overall_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_overalllistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_overall">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_overall_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_overall->RowType = ROWTYPE_SEARCH;

// Render row
$po_overall->resetAttributes();
$po_overall_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
	<div id="xsc_buyer_id" class="ew-cell form-group">
		<label for="x_buyer_id" class="ew-search-caption ew-label"><?php echo $po_overall->buyer_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_buyer_id" data-value-separator="<?php echo $po_overall->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po_overall->buyer_id->editAttributes() ?>>
		<?php echo $po_overall->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $po_overall->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
	<div id="xsc_reports_to" class="ew-cell form-group">
		<label for="x_reports_to" class="ew-search-caption ew-label"><?php echo $po_overall->reports_to->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_reports_to" data-value-separator="<?php echo $po_overall->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $po_overall->reports_to->editAttributes() ?>>
		<?php echo $po_overall->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $po_overall->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_overall->year->Visible) { // year ?>
	<div id="xsc_year" class="ew-cell form-group">
		<label for="x_year" class="ew-search-caption ew-label"><?php echo $po_overall->year->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_year" id="z_year" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="po_overall" data-field="x_year" name="x_year" id="x_year" size="30" placeholder="<?php echo HtmlEncode($po_overall->year->getPlaceHolder()) ?>" value="<?php echo $po_overall->year->EditValue ?>"<?php echo $po_overall->year->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($po_overall->month->Visible) { // month ?>
	<div id="xsc_month" class="ew-cell form-group">
		<label for="x_month" class="ew-search-caption ew-label"><?php echo $po_overall->month->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_month" id="z_month" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="po_overall" data-field="x_month" name="x_month" id="x_month" size="30" placeholder="<?php echo HtmlEncode($po_overall->month->getPlaceHolder()) ?>" value="<?php echo $po_overall->month->EditValue ?>"<?php echo $po_overall->month->editAttributes() ?>>
<?php echo $po_overall->month->Lookup->getParamTag("p_x_month") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_overall_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_overall_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_overall_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_overall_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_overall_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_overall_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_overall_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_overall_list->showPageHeader(); ?>
<?php
$po_overall_list->showMessage();
?>
<?php if ($po_overall_list->TotalRecs > 0 || $po_overall->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_overall_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_overall">
<?php if (!$po_overall->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_overall->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_overall_list->Pager)) $po_overall_list->Pager = new PrevNextPager($po_overall_list->StartRec, $po_overall_list->DisplayRecs, $po_overall_list->TotalRecs, $po_overall_list->AutoHidePager) ?>
<?php if ($po_overall_list->Pager->RecordCount > 0 && $po_overall_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_overall_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_overall_list->pageUrl() ?>start=<?php echo $po_overall_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_overall_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_overall_list->pageUrl() ?>start=<?php echo $po_overall_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_overall_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_overall_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_overall_list->pageUrl() ?>start=<?php echo $po_overall_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_overall_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_overall_list->pageUrl() ?>start=<?php echo $po_overall_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_overall_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_overall_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_overall_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_overall_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_overall_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_overall_list->TotalRecs > 0 && (!$po_overall_list->AutoHidePageSizeSelector || $po_overall_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_overall">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_overall_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_overall_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_overall_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_overall_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_overall_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_overall->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_overall_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_overalllist" id="fpo_overalllist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_overall_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_overall_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_overall">
<?php if ($po_overall->getCurrentMasterTable() == "po_overall_compiled" && $po_overall->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="po_overall_compiled">
<input type="hidden" name="fk_buyer_id" value="<?php echo $po_overall->buyer_id->getSessionValue() ?>">
<?php } ?>
<div id="gmp_po_overall" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_overall_list->TotalRecs > 0 || $po_overall->isGridEdit()) { ?>
<table id="tbl_po_overalllist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_overall_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_overall_list->renderListOptions();

// Render list options (header, left)
$po_overall_list->ListOptions->render("header", "left");
?>
<?php if ($po_overall->id->Visible) { // id ?>
	<?php if ($po_overall->sortUrl($po_overall->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_overall->id->headerCellClass() ?>"><div id="elh_po_overall_id" class="po_overall_id"><div class="ew-table-header-caption"><?php echo $po_overall->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_overall->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->id) ?>',2);"><div id="elh_po_overall_id" class="po_overall_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
	<?php if ($po_overall->sortUrl($po_overall->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $po_overall->buyer_id->headerCellClass() ?>"><div id="elh_po_overall_buyer_id" class="po_overall_buyer_id"><div class="ew-table-header-caption"><?php echo $po_overall->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $po_overall->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->buyer_id) ?>',2);"><div id="elh_po_overall_buyer_id" class="po_overall_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
	<?php if ($po_overall->sortUrl($po_overall->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $po_overall->reports_to->headerCellClass() ?>"><div id="elh_po_overall_reports_to" class="po_overall_reports_to"><div class="ew-table-header-caption"><?php echo $po_overall->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $po_overall->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->reports_to) ?>',2);"><div id="elh_po_overall_reports_to" class="po_overall_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->year->Visible) { // year ?>
	<?php if ($po_overall->sortUrl($po_overall->year) == "") { ?>
		<th data-name="year" class="<?php echo $po_overall->year->headerCellClass() ?>"><div id="elh_po_overall_year" class="po_overall_year"><div class="ew-table-header-caption"><?php echo $po_overall->year->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="year" class="<?php echo $po_overall->year->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->year) ?>',2);"><div id="elh_po_overall_year" class="po_overall_year">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->year->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->year->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->year->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->month->Visible) { // month ?>
	<?php if ($po_overall->sortUrl($po_overall->month) == "") { ?>
		<th data-name="month" class="<?php echo $po_overall->month->headerCellClass() ?>"><div id="elh_po_overall_month" class="po_overall_month"><div class="ew-table-header-caption"><?php echo $po_overall->month->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="month" class="<?php echo $po_overall->month->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->month) ?>',2);"><div id="elh_po_overall_month" class="po_overall_month">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->month->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->month->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->month->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->sqm->Visible) { // sqm ?>
	<?php if ($po_overall->sortUrl($po_overall->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $po_overall->sqm->headerCellClass() ?>"><div id="elh_po_overall_sqm" class="po_overall_sqm"><div class="ew-table-header-caption"><?php echo $po_overall->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $po_overall->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->sqm) ?>',2);"><div id="elh_po_overall_sqm" class="po_overall_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->usd->Visible) { // usd ?>
	<?php if ($po_overall->sortUrl($po_overall->usd) == "") { ?>
		<th data-name="usd" class="<?php echo $po_overall->usd->headerCellClass() ?>"><div id="elh_po_overall_usd" class="po_overall_usd"><div class="ew-table-header-caption"><?php echo $po_overall->usd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="usd" class="<?php echo $po_overall->usd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->usd) ?>',2);"><div id="elh_po_overall_usd" class="po_overall_usd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->usd->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->usd->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->usd->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->euro->Visible) { // euro ?>
	<?php if ($po_overall->sortUrl($po_overall->euro) == "") { ?>
		<th data-name="euro" class="<?php echo $po_overall->euro->headerCellClass() ?>"><div id="elh_po_overall_euro" class="po_overall_euro"><div class="ew-table-header-caption"><?php echo $po_overall->euro->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="euro" class="<?php echo $po_overall->euro->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->euro) ?>',2);"><div id="elh_po_overall_euro" class="po_overall_euro">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->euro->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->euro->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->euro->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->inr->Visible) { // inr ?>
	<?php if ($po_overall->sortUrl($po_overall->inr) == "") { ?>
		<th data-name="inr" class="<?php echo $po_overall->inr->headerCellClass() ?>"><div id="elh_po_overall_inr" class="po_overall_inr"><div class="ew-table-header-caption"><?php echo $po_overall->inr->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="inr" class="<?php echo $po_overall->inr->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->inr) ?>',2);"><div id="elh_po_overall_inr" class="po_overall_inr">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->inr->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->inr->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->inr->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->operator->Visible) { // operator ?>
	<?php if ($po_overall->sortUrl($po_overall->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $po_overall->operator->headerCellClass() ?>"><div id="elh_po_overall_operator" class="po_overall_operator"><div class="ew-table-header-caption"><?php echo $po_overall->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $po_overall->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->operator) ?>',2);"><div id="elh_po_overall_operator" class="po_overall_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->datetime->Visible) { // datetime ?>
	<?php if ($po_overall->sortUrl($po_overall->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $po_overall->datetime->headerCellClass() ?>"><div id="elh_po_overall_datetime" class="po_overall_datetime"><div class="ew-table-header-caption"><?php echo $po_overall->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $po_overall->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_overall->SortUrl($po_overall->datetime) ?>',2);"><div id="elh_po_overall_datetime" class="po_overall_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_overall_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_overall->ExportAll && $po_overall->isExport()) {
	$po_overall_list->StopRec = $po_overall_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_overall_list->TotalRecs > $po_overall_list->StartRec + $po_overall_list->DisplayRecs - 1)
		$po_overall_list->StopRec = $po_overall_list->StartRec + $po_overall_list->DisplayRecs - 1;
	else
		$po_overall_list->StopRec = $po_overall_list->TotalRecs;
}
$po_overall_list->RecCnt = $po_overall_list->StartRec - 1;
if ($po_overall_list->Recordset && !$po_overall_list->Recordset->EOF) {
	$po_overall_list->Recordset->moveFirst();
	$selectLimit = $po_overall_list->UseSelectLimit;
	if (!$selectLimit && $po_overall_list->StartRec > 1)
		$po_overall_list->Recordset->move($po_overall_list->StartRec - 1);
} elseif (!$po_overall->AllowAddDeleteRow && $po_overall_list->StopRec == 0) {
	$po_overall_list->StopRec = $po_overall->GridAddRowCount;
}

// Initialize aggregate
$po_overall->RowType = ROWTYPE_AGGREGATEINIT;
$po_overall->resetAttributes();
$po_overall_list->renderRow();
while ($po_overall_list->RecCnt < $po_overall_list->StopRec) {
	$po_overall_list->RecCnt++;
	if ($po_overall_list->RecCnt >= $po_overall_list->StartRec) {
		$po_overall_list->RowCnt++;

		// Set up key count
		$po_overall_list->KeyCount = $po_overall_list->RowIndex;

		// Init row class and style
		$po_overall->resetAttributes();
		$po_overall->CssClass = "";
		if ($po_overall->isGridAdd()) {
		} else {
			$po_overall_list->loadRowValues($po_overall_list->Recordset); // Load row values
		}
		$po_overall->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_overall->RowAttrs = array_merge($po_overall->RowAttrs, array('data-rowindex'=>$po_overall_list->RowCnt, 'id'=>'r' . $po_overall_list->RowCnt . '_po_overall', 'data-rowtype'=>$po_overall->RowType));

		// Render row
		$po_overall_list->renderRow();

		// Render list options
		$po_overall_list->renderListOptions();
?>
	<tr<?php echo $po_overall->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_overall_list->ListOptions->render("body", "left", $po_overall_list->RowCnt);
?>
	<?php if ($po_overall->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_overall->id->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_id" class="po_overall_id">
<span<?php echo $po_overall->id->viewAttributes() ?>>
<?php echo $po_overall->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $po_overall->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_buyer_id" class="po_overall_buyer_id">
<span<?php echo $po_overall->buyer_id->viewAttributes() ?>>
<?php echo $po_overall->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $po_overall->reports_to->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_reports_to" class="po_overall_reports_to">
<span<?php echo $po_overall->reports_to->viewAttributes() ?>>
<?php echo $po_overall->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->year->Visible) { // year ?>
		<td data-name="year"<?php echo $po_overall->year->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_year" class="po_overall_year">
<span<?php echo $po_overall->year->viewAttributes() ?>>
<?php echo $po_overall->year->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->month->Visible) { // month ?>
		<td data-name="month"<?php echo $po_overall->month->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_month" class="po_overall_month">
<span<?php echo $po_overall->month->viewAttributes() ?>>
<?php echo $po_overall->month->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $po_overall->sqm->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_sqm" class="po_overall_sqm">
<span<?php echo $po_overall->sqm->viewAttributes() ?>>
<?php echo $po_overall->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->usd->Visible) { // usd ?>
		<td data-name="usd"<?php echo $po_overall->usd->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_usd" class="po_overall_usd">
<span<?php echo $po_overall->usd->viewAttributes() ?>>
<?php echo $po_overall->usd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->euro->Visible) { // euro ?>
		<td data-name="euro"<?php echo $po_overall->euro->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_euro" class="po_overall_euro">
<span<?php echo $po_overall->euro->viewAttributes() ?>>
<?php echo $po_overall->euro->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->inr->Visible) { // inr ?>
		<td data-name="inr"<?php echo $po_overall->inr->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_inr" class="po_overall_inr">
<span<?php echo $po_overall->inr->viewAttributes() ?>>
<?php echo $po_overall->inr->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $po_overall->operator->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_operator" class="po_overall_operator">
<span<?php echo $po_overall->operator->viewAttributes() ?>>
<?php echo $po_overall->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_overall->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $po_overall->datetime->cellAttributes() ?>>
<span id="el<?php echo $po_overall_list->RowCnt ?>_po_overall_datetime" class="po_overall_datetime">
<span<?php echo $po_overall->datetime->viewAttributes() ?>>
<?php echo $po_overall->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_overall_list->ListOptions->render("body", "right", $po_overall_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_overall->isGridAdd())
		$po_overall_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$po_overall->RowType = ROWTYPE_AGGREGATE;
$po_overall->resetAttributes();
$po_overall_list->renderRow();
?>
<?php if ($po_overall_list->TotalRecs > 0 && !$po_overall->isGridAdd() && !$po_overall->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$po_overall_list->renderListOptions();

// Render list options (footer, left)
$po_overall_list->ListOptions->render("footer", "left");
?>
	<?php if ($po_overall->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $po_overall->id->footerCellClass() ?>"><span id="elf_po_overall_id" class="po_overall_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $po_overall->buyer_id->footerCellClass() ?>"><span id="elf_po_overall_buyer_id" class="po_overall_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to" class="<?php echo $po_overall->reports_to->footerCellClass() ?>"><span id="elf_po_overall_reports_to" class="po_overall_reports_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->year->Visible) { // year ?>
		<td data-name="year" class="<?php echo $po_overall->year->footerCellClass() ?>"><span id="elf_po_overall_year" class="po_overall_year">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->month->Visible) { // month ?>
		<td data-name="month" class="<?php echo $po_overall->month->footerCellClass() ?>"><span id="elf_po_overall_month" class="po_overall_month">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $po_overall->sqm->footerCellClass() ?>"><span id="elf_po_overall_sqm" class="po_overall_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_overall->usd->Visible) { // usd ?>
		<td data-name="usd" class="<?php echo $po_overall->usd->footerCellClass() ?>"><span id="elf_po_overall_usd" class="po_overall_usd">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->usd->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_overall->euro->Visible) { // euro ?>
		<td data-name="euro" class="<?php echo $po_overall->euro->footerCellClass() ?>"><span id="elf_po_overall_euro" class="po_overall_euro">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->euro->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_overall->inr->Visible) { // inr ?>
		<td data-name="inr" class="<?php echo $po_overall->inr->footerCellClass() ?>"><span id="elf_po_overall_inr" class="po_overall_inr">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->inr->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_overall->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $po_overall->operator->footerCellClass() ?>"><span id="elf_po_overall_operator" class="po_overall_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_overall->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $po_overall->datetime->footerCellClass() ?>"><span id="elf_po_overall_datetime" class="po_overall_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$po_overall_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_overall->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_overall_list->Recordset)
	$po_overall_list->Recordset->Close();
?>
<?php if (!$po_overall->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_overall->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_overall_list->Pager)) $po_overall_list->Pager = new PrevNextPager($po_overall_list->StartRec, $po_overall_list->DisplayRecs, $po_overall_list->TotalRecs, $po_overall_list->AutoHidePager) ?>
<?php if ($po_overall_list->Pager->RecordCount > 0 && $po_overall_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_overall_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_overall_list->pageUrl() ?>start=<?php echo $po_overall_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_overall_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_overall_list->pageUrl() ?>start=<?php echo $po_overall_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_overall_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_overall_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_overall_list->pageUrl() ?>start=<?php echo $po_overall_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_overall_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_overall_list->pageUrl() ?>start=<?php echo $po_overall_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_overall_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_overall_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_overall_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_overall_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_overall_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_overall_list->TotalRecs > 0 && (!$po_overall_list->AutoHidePageSizeSelector || $po_overall_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_overall">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_overall_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_overall_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_overall_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_overall_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_overall_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_overall->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_overall_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_overall_list->TotalRecs == 0 && !$po_overall->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_overall_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_overall_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_overall->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_overall->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_overall", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_overall_list->terminate();
?>