<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$po_overall_preview = new po_overall_preview();

// Run the page
$po_overall_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_overall_preview->Page_Render();
?>
<?php $po_overall_preview->showPageHeader(); ?>
<div class="card ew-grid po_overall"><!-- .card -->
<?php if ($po_overall_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$po_overall_preview->renderListOptions();

// Render list options (header, left)
$po_overall_preview->ListOptions->render("header", "left");
?>
<?php if ($po_overall->id->Visible) { // id ?>
	<?php if ($po_overall->SortUrl($po_overall->id) == "") { ?>
		<th class="<?php echo $po_overall->id->headerCellClass() ?>"><?php echo $po_overall->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->id->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->id->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->id->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
	<?php if ($po_overall->SortUrl($po_overall->buyer_id) == "") { ?>
		<th class="<?php echo $po_overall->buyer_id->headerCellClass() ?>"><?php echo $po_overall->buyer_id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->buyer_id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->buyer_id->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->buyer_id->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->buyer_id->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
	<?php if ($po_overall->SortUrl($po_overall->reports_to) == "") { ?>
		<th class="<?php echo $po_overall->reports_to->headerCellClass() ?>"><?php echo $po_overall->reports_to->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->reports_to->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->reports_to->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->reports_to->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->reports_to->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->year->Visible) { // year ?>
	<?php if ($po_overall->SortUrl($po_overall->year) == "") { ?>
		<th class="<?php echo $po_overall->year->headerCellClass() ?>"><?php echo $po_overall->year->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->year->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->year->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->year->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->year->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->year->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->month->Visible) { // month ?>
	<?php if ($po_overall->SortUrl($po_overall->month) == "") { ?>
		<th class="<?php echo $po_overall->month->headerCellClass() ?>"><?php echo $po_overall->month->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->month->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->month->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->month->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->month->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->month->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->sqm->Visible) { // sqm ?>
	<?php if ($po_overall->SortUrl($po_overall->sqm) == "") { ?>
		<th class="<?php echo $po_overall->sqm->headerCellClass() ?>"><?php echo $po_overall->sqm->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->sqm->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->sqm->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->sqm->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->sqm->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->usd->Visible) { // usd ?>
	<?php if ($po_overall->SortUrl($po_overall->usd) == "") { ?>
		<th class="<?php echo $po_overall->usd->headerCellClass() ?>"><?php echo $po_overall->usd->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->usd->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->usd->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->usd->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->usd->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->usd->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->euro->Visible) { // euro ?>
	<?php if ($po_overall->SortUrl($po_overall->euro) == "") { ?>
		<th class="<?php echo $po_overall->euro->headerCellClass() ?>"><?php echo $po_overall->euro->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->euro->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->euro->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->euro->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->euro->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->euro->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->inr->Visible) { // inr ?>
	<?php if ($po_overall->SortUrl($po_overall->inr) == "") { ?>
		<th class="<?php echo $po_overall->inr->headerCellClass() ?>"><?php echo $po_overall->inr->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->inr->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->inr->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->inr->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->inr->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->inr->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->operator->Visible) { // operator ?>
	<?php if ($po_overall->SortUrl($po_overall->operator) == "") { ?>
		<th class="<?php echo $po_overall->operator->headerCellClass() ?>"><?php echo $po_overall->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->operator->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->operator->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->operator->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_overall->datetime->Visible) { // datetime ?>
	<?php if ($po_overall->SortUrl($po_overall->datetime) == "") { ?>
		<th class="<?php echo $po_overall->datetime->headerCellClass() ?>"><?php echo $po_overall->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $po_overall->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($po_overall->datetime->Name) ?>" data-sort-order="<?php echo $po_overall_preview->SortField == $po_overall->datetime->Name && $po_overall_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_overall->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_overall_preview->SortField == $po_overall->datetime->Name) { ?><?php if ($po_overall_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_overall_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_overall_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$po_overall_preview->RecCount = 0;
$po_overall_preview->RowCnt = 0;
while ($po_overall_preview->Recordset && !$po_overall_preview->Recordset->EOF) {

	// Init row class and style
	$po_overall_preview->RecCount++;
	$po_overall_preview->RowCnt++;
	$po_overall_preview->CssStyle = "";
	$po_overall_preview->loadListRowValues($po_overall_preview->Recordset);
	$po_overall_preview->aggregateListRowValues(); // Aggregate row values

	// Render row
	$po_overall_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$po_overall_preview->resetAttributes();
	$po_overall_preview->renderListRow();

	// Render list options
	$po_overall_preview->renderListOptions();
?>
	<tr<?php echo $po_overall_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_overall_preview->ListOptions->render("body", "left", $po_overall_preview->RowCnt);
?>
<?php if ($po_overall->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $po_overall->id->cellAttributes() ?>>
<span<?php echo $po_overall->id->viewAttributes() ?>>
<?php echo $po_overall->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
		<!-- buyer_id -->
		<td<?php echo $po_overall->buyer_id->cellAttributes() ?>>
<span<?php echo $po_overall->buyer_id->viewAttributes() ?>>
<?php echo $po_overall->buyer_id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
		<!-- reports_to -->
		<td<?php echo $po_overall->reports_to->cellAttributes() ?>>
<span<?php echo $po_overall->reports_to->viewAttributes() ?>>
<?php echo $po_overall->reports_to->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->year->Visible) { // year ?>
		<!-- year -->
		<td<?php echo $po_overall->year->cellAttributes() ?>>
<span<?php echo $po_overall->year->viewAttributes() ?>>
<?php echo $po_overall->year->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->month->Visible) { // month ?>
		<!-- month -->
		<td<?php echo $po_overall->month->cellAttributes() ?>>
<span<?php echo $po_overall->month->viewAttributes() ?>>
<?php echo $po_overall->month->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->sqm->Visible) { // sqm ?>
		<!-- sqm -->
		<td<?php echo $po_overall->sqm->cellAttributes() ?>>
<span<?php echo $po_overall->sqm->viewAttributes() ?>>
<?php echo $po_overall->sqm->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->usd->Visible) { // usd ?>
		<!-- usd -->
		<td<?php echo $po_overall->usd->cellAttributes() ?>>
<span<?php echo $po_overall->usd->viewAttributes() ?>>
<?php echo $po_overall->usd->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->euro->Visible) { // euro ?>
		<!-- euro -->
		<td<?php echo $po_overall->euro->cellAttributes() ?>>
<span<?php echo $po_overall->euro->viewAttributes() ?>>
<?php echo $po_overall->euro->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->inr->Visible) { // inr ?>
		<!-- inr -->
		<td<?php echo $po_overall->inr->cellAttributes() ?>>
<span<?php echo $po_overall->inr->viewAttributes() ?>>
<?php echo $po_overall->inr->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $po_overall->operator->cellAttributes() ?>>
<span<?php echo $po_overall->operator->viewAttributes() ?>>
<?php echo $po_overall->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($po_overall->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $po_overall->datetime->cellAttributes() ?>>
<span<?php echo $po_overall->datetime->viewAttributes() ?>>
<?php echo $po_overall->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$po_overall_preview->ListOptions->render("body", "right", $po_overall_preview->RowCnt);
?>
	</tr>
<?php
	$po_overall_preview->Recordset->MoveNext();
}
?>
	</tbody>
<?php

	// Render aggregate row
	$po_overall_preview->RowType = ROWTYPE_AGGREGATE; // Aggregate
	$po_overall_preview->aggregateListRow(); // Prepare aggregate row

	// Render list options
	$po_overall_preview->renderListOptions();
?>
	<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options (footer, left)
$po_overall_preview->ListOptions->render("footer", "left");
?>
<?php if ($po_overall->id->Visible) { // id ?>
		<!-- id -->
		<td class="<?php echo $po_overall->id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
		<!-- buyer_id -->
		<td class="<?php echo $po_overall->buyer_id->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
		<!-- reports_to -->
		<td class="<?php echo $po_overall->reports_to->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($po_overall->year->Visible) { // year ?>
		<!-- year -->
		<td class="<?php echo $po_overall->year->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($po_overall->month->Visible) { // month ?>
		<!-- month -->
		<td class="<?php echo $po_overall->month->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($po_overall->sqm->Visible) { // sqm ?>
		<!-- sqm -->
		<td class="<?php echo $po_overall->sqm->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->sqm->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($po_overall->usd->Visible) { // usd ?>
		<!-- usd -->
		<td class="<?php echo $po_overall->usd->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->usd->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($po_overall->euro->Visible) { // euro ?>
		<!-- euro -->
		<td class="<?php echo $po_overall->euro->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->euro->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($po_overall->inr->Visible) { // inr ?>
		<!-- inr -->
		<td class="<?php echo $po_overall->inr->footerCellClass() ?>">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_overall->inr->ViewValue ?></span>
		</td>
<?php } ?>
<?php if ($po_overall->operator->Visible) { // operator ?>
		<!-- operator -->
		<td class="<?php echo $po_overall->operator->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php if ($po_overall->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td class="<?php echo $po_overall->datetime->footerCellClass() ?>">
		&nbsp;
		</td>
<?php } ?>
<?php

// Render list options (footer, right)
$po_overall_preview->ListOptions->render("footer", "right");
?>
	</tr>
	</tfoot>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($po_overall_preview->TotalRecs > 0) { ?>
<?php if (!isset($po_overall_preview->Pager)) $po_overall_preview->Pager = new PrevNextPager($po_overall_preview->StartRec, $po_overall_preview->DisplayRecs, $po_overall_preview->TotalRecs) ?>
<?php if ($po_overall_preview->Pager->RecordCount > 0 && $po_overall_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($po_overall_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $po_overall_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($po_overall_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $po_overall_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($po_overall_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $po_overall_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($po_overall_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $po_overall_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $po_overall_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $po_overall_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $po_overall_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($po_overall_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$po_overall_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($po_overall_preview->Recordset)
	$po_overall_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$po_overall_preview->terminate();
?>