<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_overall_search = new po_overall_search();

// Run the page
$po_overall_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_overall_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_overall_search->IsModal) { ?>
var fpo_overallsearch = currentAdvancedSearchForm = new ew.Form("fpo_overallsearch", "search");
<?php } else { ?>
var fpo_overallsearch = currentForm = new ew.Form("fpo_overallsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_overallsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overallsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overallsearch.lists["x_buyer_id"] = <?php echo $po_overall_search->buyer_id->Lookup->toClientList() ?>;
fpo_overallsearch.lists["x_buyer_id"].options = <?php echo JsonEncode($po_overall_search->buyer_id->lookupOptions()) ?>;
fpo_overallsearch.lists["x_reports_to"] = <?php echo $po_overall_search->reports_to->Lookup->toClientList() ?>;
fpo_overallsearch.lists["x_reports_to"].options = <?php echo JsonEncode($po_overall_search->reports_to->lookupOptions()) ?>;
fpo_overallsearch.lists["x_month"] = <?php echo $po_overall_search->month->Lookup->toClientList() ?>;
fpo_overallsearch.lists["x_month"].options = <?php echo JsonEncode($po_overall_search->month->lookupOptions()) ?>;
fpo_overallsearch.lists["x_operator"] = <?php echo $po_overall_search->operator->Lookup->toClientList() ?>;
fpo_overallsearch.lists["x_operator"].options = <?php echo JsonEncode($po_overall_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpo_overallsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_year");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall->year->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_usd");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall->usd->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_euro");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall->euro->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_inr");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall->inr->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_overall->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_overall_search->showPageHeader(); ?>
<?php
$po_overall_search->showMessage();
?>
<form name="fpo_overallsearch" id="fpo_overallsearch" class="<?php echo $po_overall_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_overall_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_overall_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_overall">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_overall_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($po_overall->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_id"><?php echo $po_overall->id->caption() ?></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->id->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_id" id="z_id" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($po_overall->id->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_po_overall_id">
<input type="text" data-table="po_overall" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($po_overall->id->getPlaceHolder()) ?>" value="<?php echo $po_overall->id->EditValue ?>"<?php echo $po_overall->id->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_id d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_po_overall_id" class="btw1_id d-none">
<input type="text" data-table="po_overall" data-field="x_id" name="y_id" id="y_id" placeholder="<?php echo HtmlEncode($po_overall->id->getPlaceHolder()) ?>" value="<?php echo $po_overall->id->EditValue2 ?>"<?php echo $po_overall->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
	<div id="r_buyer_id" class="form-group row">
		<label for="x_buyer_id" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_buyer_id"><?php echo $po_overall->buyer_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer_id" id="z_buyer_id" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->buyer_id->cellAttributes() ?>>
			<span id="el_po_overall_buyer_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_buyer_id" data-value-separator="<?php echo $po_overall->buyer_id->displayValueSeparatorAttribute() ?>" id="x_buyer_id" name="x_buyer_id"<?php echo $po_overall->buyer_id->editAttributes() ?>>
		<?php echo $po_overall->buyer_id->selectOptionListHtml("x_buyer_id") ?>
	</select>
</div>
<?php echo $po_overall->buyer_id->Lookup->getParamTag("p_x_buyer_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_reports_to"><?php echo $po_overall->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->reports_to->cellAttributes() ?>>
			<span id="el_po_overall_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_reports_to" data-value-separator="<?php echo $po_overall->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $po_overall->reports_to->editAttributes() ?>>
		<?php echo $po_overall->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $po_overall->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->year->Visible) { // year ?>
	<div id="r_year" class="form-group row">
		<label for="x_year" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_year"><?php echo $po_overall->year->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_year" id="z_year" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->year->cellAttributes() ?>>
			<span id="el_po_overall_year">
<input type="text" data-table="po_overall" data-field="x_year" name="x_year" id="x_year" size="30" placeholder="<?php echo HtmlEncode($po_overall->year->getPlaceHolder()) ?>" value="<?php echo $po_overall->year->EditValue ?>"<?php echo $po_overall->year->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->month->Visible) { // month ?>
	<div id="r_month" class="form-group row">
		<label for="x_month" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_month"><?php echo $po_overall->month->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_month" id="z_month" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->month->cellAttributes() ?>>
			<span id="el_po_overall_month">
<input type="text" data-table="po_overall" data-field="x_month" name="x_month" id="x_month" size="30" placeholder="<?php echo HtmlEncode($po_overall->month->getPlaceHolder()) ?>" value="<?php echo $po_overall->month->EditValue ?>"<?php echo $po_overall->month->editAttributes() ?>>
<?php echo $po_overall->month->Lookup->getParamTag("p_x_month") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_sqm"><?php echo $po_overall->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->sqm->cellAttributes() ?>>
			<span id="el_po_overall_sqm">
<input type="text" data-table="po_overall" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($po_overall->sqm->getPlaceHolder()) ?>" value="<?php echo $po_overall->sqm->EditValue ?>"<?php echo $po_overall->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->usd->Visible) { // usd ?>
	<div id="r_usd" class="form-group row">
		<label for="x_usd" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_usd"><?php echo $po_overall->usd->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_usd" id="z_usd" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->usd->cellAttributes() ?>>
			<span id="el_po_overall_usd">
<input type="text" data-table="po_overall" data-field="x_usd" name="x_usd" id="x_usd" size="30" placeholder="<?php echo HtmlEncode($po_overall->usd->getPlaceHolder()) ?>" value="<?php echo $po_overall->usd->EditValue ?>"<?php echo $po_overall->usd->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->euro->Visible) { // euro ?>
	<div id="r_euro" class="form-group row">
		<label for="x_euro" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_euro"><?php echo $po_overall->euro->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_euro" id="z_euro" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->euro->cellAttributes() ?>>
			<span id="el_po_overall_euro">
<input type="text" data-table="po_overall" data-field="x_euro" name="x_euro" id="x_euro" size="30" placeholder="<?php echo HtmlEncode($po_overall->euro->getPlaceHolder()) ?>" value="<?php echo $po_overall->euro->EditValue ?>"<?php echo $po_overall->euro->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->inr->Visible) { // inr ?>
	<div id="r_inr" class="form-group row">
		<label for="x_inr" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_inr"><?php echo $po_overall->inr->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_inr" id="z_inr" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->inr->cellAttributes() ?>>
			<span id="el_po_overall_inr">
<input type="text" data-table="po_overall" data-field="x_inr" name="x_inr" id="x_inr" size="30" placeholder="<?php echo HtmlEncode($po_overall->inr->getPlaceHolder()) ?>" value="<?php echo $po_overall->inr->EditValue ?>"<?php echo $po_overall->inr->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_operator"><?php echo $po_overall->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->operator->cellAttributes() ?>>
			<span id="el_po_overall_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_overall" data-field="x_operator" data-value-separator="<?php echo $po_overall->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $po_overall->operator->editAttributes() ?>>
		<?php echo $po_overall->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $po_overall->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_overall->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $po_overall_search->LeftColumnClass ?>"><span id="elh_po_overall_datetime"><?php echo $po_overall->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $po_overall_search->RightColumnClass ?>"><div<?php echo $po_overall->datetime->cellAttributes() ?>>
			<span id="el_po_overall_datetime">
<input type="text" data-table="po_overall" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($po_overall->datetime->getPlaceHolder()) ?>" value="<?php echo $po_overall->datetime->EditValue ?>"<?php echo $po_overall->datetime->editAttributes() ?>>
<?php if (!$po_overall->datetime->ReadOnly && !$po_overall->datetime->Disabled && !isset($po_overall->datetime->EditAttrs["readonly"]) && !isset($po_overall->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_overallsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_overall_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_overall_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_overall_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_overall_search->terminate();
?>