<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_overall_view = new po_overall_view();

// Run the page
$po_overall_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_overall_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_overall->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpo_overallview = currentForm = new ew.Form("fpo_overallview", "view");

// Form_CustomValidate event
fpo_overallview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_overallview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_overallview.lists["x_buyer_id"] = <?php echo $po_overall_view->buyer_id->Lookup->toClientList() ?>;
fpo_overallview.lists["x_buyer_id"].options = <?php echo JsonEncode($po_overall_view->buyer_id->lookupOptions()) ?>;
fpo_overallview.lists["x_reports_to"] = <?php echo $po_overall_view->reports_to->Lookup->toClientList() ?>;
fpo_overallview.lists["x_reports_to"].options = <?php echo JsonEncode($po_overall_view->reports_to->lookupOptions()) ?>;
fpo_overallview.lists["x_month"] = <?php echo $po_overall_view->month->Lookup->toClientList() ?>;
fpo_overallview.lists["x_month"].options = <?php echo JsonEncode($po_overall_view->month->lookupOptions()) ?>;
fpo_overallview.lists["x_operator"] = <?php echo $po_overall_view->operator->Lookup->toClientList() ?>;
fpo_overallview.lists["x_operator"].options = <?php echo JsonEncode($po_overall_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_overall->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $po_overall_view->ExportOptions->render("body") ?>
<?php $po_overall_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $po_overall_view->showPageHeader(); ?>
<?php
$po_overall_view->showMessage();
?>
<form name="fpo_overallview" id="fpo_overallview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_overall_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_overall_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_overall">
<input type="hidden" name="modal" value="<?php echo (int)$po_overall_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_overall->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_id"><?php echo $po_overall->id->caption() ?></span></td>
		<td data-name="id"<?php echo $po_overall->id->cellAttributes() ?>>
<span id="el_po_overall_id">
<span<?php echo $po_overall->id->viewAttributes() ?>>
<?php echo $po_overall->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->buyer_id->Visible) { // buyer_id ?>
	<tr id="r_buyer_id">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_buyer_id"><?php echo $po_overall->buyer_id->caption() ?></span></td>
		<td data-name="buyer_id"<?php echo $po_overall->buyer_id->cellAttributes() ?>>
<span id="el_po_overall_buyer_id">
<span<?php echo $po_overall->buyer_id->viewAttributes() ?>>
<?php echo $po_overall->buyer_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->reports_to->Visible) { // reports_to ?>
	<tr id="r_reports_to">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_reports_to"><?php echo $po_overall->reports_to->caption() ?></span></td>
		<td data-name="reports_to"<?php echo $po_overall->reports_to->cellAttributes() ?>>
<span id="el_po_overall_reports_to">
<span<?php echo $po_overall->reports_to->viewAttributes() ?>>
<?php echo $po_overall->reports_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->year->Visible) { // year ?>
	<tr id="r_year">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_year"><?php echo $po_overall->year->caption() ?></span></td>
		<td data-name="year"<?php echo $po_overall->year->cellAttributes() ?>>
<span id="el_po_overall_year">
<span<?php echo $po_overall->year->viewAttributes() ?>>
<?php echo $po_overall->year->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->month->Visible) { // month ?>
	<tr id="r_month">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_month"><?php echo $po_overall->month->caption() ?></span></td>
		<td data-name="month"<?php echo $po_overall->month->cellAttributes() ?>>
<span id="el_po_overall_month">
<span<?php echo $po_overall->month->viewAttributes() ?>>
<?php echo $po_overall->month->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_sqm"><?php echo $po_overall->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $po_overall->sqm->cellAttributes() ?>>
<span id="el_po_overall_sqm">
<span<?php echo $po_overall->sqm->viewAttributes() ?>>
<?php echo $po_overall->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->usd->Visible) { // usd ?>
	<tr id="r_usd">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_usd"><?php echo $po_overall->usd->caption() ?></span></td>
		<td data-name="usd"<?php echo $po_overall->usd->cellAttributes() ?>>
<span id="el_po_overall_usd">
<span<?php echo $po_overall->usd->viewAttributes() ?>>
<?php echo $po_overall->usd->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->euro->Visible) { // euro ?>
	<tr id="r_euro">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_euro"><?php echo $po_overall->euro->caption() ?></span></td>
		<td data-name="euro"<?php echo $po_overall->euro->cellAttributes() ?>>
<span id="el_po_overall_euro">
<span<?php echo $po_overall->euro->viewAttributes() ?>>
<?php echo $po_overall->euro->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->inr->Visible) { // inr ?>
	<tr id="r_inr">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_inr"><?php echo $po_overall->inr->caption() ?></span></td>
		<td data-name="inr"<?php echo $po_overall->inr->cellAttributes() ?>>
<span id="el_po_overall_inr">
<span<?php echo $po_overall->inr->viewAttributes() ?>>
<?php echo $po_overall->inr->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_operator"><?php echo $po_overall->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $po_overall->operator->cellAttributes() ?>>
<span id="el_po_overall_operator">
<span<?php echo $po_overall->operator->viewAttributes() ?>>
<?php echo $po_overall->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_overall->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $po_overall_view->TableLeftColumnClass ?>"><span id="elh_po_overall_datetime"><?php echo $po_overall->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $po_overall->datetime->cellAttributes() ?>>
<span id="el_po_overall_datetime">
<span<?php echo $po_overall->datetime->viewAttributes() ?>>
<?php echo $po_overall->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$po_overall_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_overall->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_overall_view->terminate();
?>