<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_pending_wbc_list = new po_pending_wbc_list();

// Run the page
$po_pending_wbc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_pending_wbc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_pending_wbc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_pending_wbclist = currentForm = new ew.Form("fpo_pending_wbclist", "list");
fpo_pending_wbclist.formKeyCountName = '<?php echo $po_pending_wbc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_pending_wbclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_pending_wbclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_pending_wbclist.lists["x_cart_quantity"] = <?php echo $po_pending_wbc_list->cart_quantity->Lookup->toClientList() ?>;
fpo_pending_wbclist.lists["x_cart_quantity"].options = <?php echo JsonEncode($po_pending_wbc_list->cart_quantity->lookupOptions()) ?>;
fpo_pending_wbclist.lists["x_despatch_week"] = <?php echo $po_pending_wbc_list->despatch_week->Lookup->toClientList() ?>;
fpo_pending_wbclist.lists["x_despatch_week"].options = <?php echo JsonEncode($po_pending_wbc_list->despatch_week->lookupOptions()) ?>;
fpo_pending_wbclist.lists["x_packing_type"] = <?php echo $po_pending_wbc_list->packing_type->Lookup->toClientList() ?>;
fpo_pending_wbclist.lists["x_packing_type"].options = <?php echo JsonEncode($po_pending_wbc_list->packing_type->lookupOptions()) ?>;
fpo_pending_wbclist.lists["x_process"] = <?php echo $po_pending_wbc_list->process->Lookup->toClientList() ?>;
fpo_pending_wbclist.lists["x_process"].options = <?php echo JsonEncode($po_pending_wbc_list->process->lookupOptions()) ?>;
fpo_pending_wbclist.lists["x_issue_to"] = <?php echo $po_pending_wbc_list->issue_to->Lookup->toClientList() ?>;
fpo_pending_wbclist.lists["x_issue_to"].options = <?php echo JsonEncode($po_pending_wbc_list->issue_to->lookupOptions()) ?>;
fpo_pending_wbclist.lists["x_company_id"] = <?php echo $po_pending_wbc_list->company_id->Lookup->toClientList() ?>;
fpo_pending_wbclist.lists["x_company_id"].options = <?php echo JsonEncode($po_pending_wbc_list->company_id->lookupOptions()) ?>;

// Form object for search
var fpo_pending_wbclistsrch = currentSearchForm = new ew.Form("fpo_pending_wbclistsrch");

// Filters
fpo_pending_wbclistsrch.filterList = <?php echo $po_pending_wbc_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_pending_wbclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_pending_wbc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_pending_wbc_list->TotalRecs > 0 && $po_pending_wbc_list->ExportOptions->visible()) { ?>
<?php $po_pending_wbc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_pending_wbc_list->ImportOptions->visible()) { ?>
<?php $po_pending_wbc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_pending_wbc_list->SearchOptions->visible()) { ?>
<?php $po_pending_wbc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_pending_wbc_list->FilterOptions->visible()) { ?>
<?php $po_pending_wbc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_pending_wbc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_pending_wbc->isExport() && !$po_pending_wbc->CurrentAction) { ?>
<form name="fpo_pending_wbclistsrch" id="fpo_pending_wbclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_pending_wbc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_pending_wbclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_pending_wbc">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_pending_wbc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_pending_wbc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_pending_wbc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_pending_wbc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_pending_wbc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_pending_wbc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_pending_wbc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_pending_wbc_list->showPageHeader(); ?>
<?php
$po_pending_wbc_list->showMessage();
?>
<?php if ($po_pending_wbc_list->TotalRecs > 0 || $po_pending_wbc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_pending_wbc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_pending_wbc">
<?php if (!$po_pending_wbc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_pending_wbc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_pending_wbc_list->Pager)) $po_pending_wbc_list->Pager = new PrevNextPager($po_pending_wbc_list->StartRec, $po_pending_wbc_list->DisplayRecs, $po_pending_wbc_list->TotalRecs, $po_pending_wbc_list->AutoHidePager) ?>
<?php if ($po_pending_wbc_list->Pager->RecordCount > 0 && $po_pending_wbc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_pending_wbc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_pending_wbc_list->pageUrl() ?>start=<?php echo $po_pending_wbc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_pending_wbc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_pending_wbc_list->pageUrl() ?>start=<?php echo $po_pending_wbc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_pending_wbc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_pending_wbc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_pending_wbc_list->pageUrl() ?>start=<?php echo $po_pending_wbc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_pending_wbc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_pending_wbc_list->pageUrl() ?>start=<?php echo $po_pending_wbc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_pending_wbc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_pending_wbc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_pending_wbc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_pending_wbc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_pending_wbc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_pending_wbc_list->TotalRecs > 0 && (!$po_pending_wbc_list->AutoHidePageSizeSelector || $po_pending_wbc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_pending_wbc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_pending_wbc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_pending_wbc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_pending_wbc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_pending_wbc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_pending_wbc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_pending_wbc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_pending_wbc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_pending_wbclist" id="fpo_pending_wbclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_pending_wbc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_pending_wbc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_pending_wbc">
<div id="gmp_po_pending_wbc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_pending_wbc_list->TotalRecs > 0 || $po_pending_wbc->isGridEdit()) { ?>
<table id="tbl_po_pending_wbclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_pending_wbc_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_pending_wbc_list->renderListOptions();

// Render list options (header, left)
$po_pending_wbc_list->ListOptions->render("header", "left");
?>
<?php if ($po_pending_wbc->id->Visible) { // id ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->id) == "") { ?>
		<th data-name="id" class="<?php echo $po_pending_wbc->id->headerCellClass() ?>"><div id="elh_po_pending_wbc_id" class="po_pending_wbc_id"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $po_pending_wbc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->id) ?>',2);"><div id="elh_po_pending_wbc_id" class="po_pending_wbc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->pod->Visible) { // pod ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->pod) == "") { ?>
		<th data-name="pod" class="<?php echo $po_pending_wbc->pod->headerCellClass() ?>"><div id="elh_po_pending_wbc_pod" class="po_pending_wbc_pod"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->pod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pod" class="<?php echo $po_pending_wbc->pod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->pod) ?>',2);"><div id="elh_po_pending_wbc_pod" class="po_pending_wbc_pod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->pod->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->pod->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->pod->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->jc_no->Visible) { // jc_no ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $po_pending_wbc->jc_no->headerCellClass() ?>"><div id="elh_po_pending_wbc_jc_no" class="po_pending_wbc_jc_no"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $po_pending_wbc->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->jc_no) ?>',2);"><div id="elh_po_pending_wbc_jc_no" class="po_pending_wbc_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->product_code->Visible) { // product_code ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $po_pending_wbc->product_code->headerCellClass() ?>"><div id="elh_po_pending_wbc_product_code" class="po_pending_wbc_product_code"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $po_pending_wbc->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->product_code) ?>',2);"><div id="elh_po_pending_wbc_product_code" class="po_pending_wbc_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->batch_no->Visible) { // batch_no ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $po_pending_wbc->batch_no->headerCellClass() ?>"><div id="elh_po_pending_wbc_batch_no" class="po_pending_wbc_batch_no"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $po_pending_wbc->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->batch_no) ?>',2);"><div id="elh_po_pending_wbc_batch_no" class="po_pending_wbc_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->cart_quantity->Visible) { // cart_quantity ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->cart_quantity) == "") { ?>
		<th data-name="cart_quantity" class="<?php echo $po_pending_wbc->cart_quantity->headerCellClass() ?>"><div id="elh_po_pending_wbc_cart_quantity" class="po_pending_wbc_cart_quantity"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->cart_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cart_quantity" class="<?php echo $po_pending_wbc->cart_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->cart_quantity) ?>',2);"><div id="elh_po_pending_wbc_cart_quantity" class="po_pending_wbc_cart_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->cart_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->cart_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->cart_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->pam_qty->Visible) { // pam_qty ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->pam_qty) == "") { ?>
		<th data-name="pam_qty" class="<?php echo $po_pending_wbc->pam_qty->headerCellClass() ?>"><div id="elh_po_pending_wbc_pam_qty" class="po_pending_wbc_pam_qty"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->pam_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pam_qty" class="<?php echo $po_pending_wbc->pam_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->pam_qty) ?>',2);"><div id="elh_po_pending_wbc_pam_qty" class="po_pending_wbc_pam_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->pam_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->pam_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->pam_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->pending_qty->Visible) { // pending_qty ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->pending_qty) == "") { ?>
		<th data-name="pending_qty" class="<?php echo $po_pending_wbc->pending_qty->headerCellClass() ?>"><div id="elh_po_pending_wbc_pending_qty" class="po_pending_wbc_pending_qty"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->pending_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_qty" class="<?php echo $po_pending_wbc->pending_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->pending_qty) ?>',2);"><div id="elh_po_pending_wbc_pending_qty" class="po_pending_wbc_pending_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->pending_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->pending_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->pending_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->despatch_week->Visible) { // despatch_week ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $po_pending_wbc->despatch_week->headerCellClass() ?>"><div id="elh_po_pending_wbc_despatch_week" class="po_pending_wbc_despatch_week"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $po_pending_wbc->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->despatch_week) ?>',2);"><div id="elh_po_pending_wbc_despatch_week" class="po_pending_wbc_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->packing_type->Visible) { // packing_type ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $po_pending_wbc->packing_type->headerCellClass() ?>"><div id="elh_po_pending_wbc_packing_type" class="po_pending_wbc_packing_type"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $po_pending_wbc->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->packing_type) ?>',2);"><div id="elh_po_pending_wbc_packing_type" class="po_pending_wbc_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->process->Visible) { // process ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->process) == "") { ?>
		<th data-name="process" class="<?php echo $po_pending_wbc->process->headerCellClass() ?>"><div id="elh_po_pending_wbc_process" class="po_pending_wbc_process"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $po_pending_wbc->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->process) ?>',2);"><div id="elh_po_pending_wbc_process" class="po_pending_wbc_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->pam_id->Visible) { // pam_id ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->pam_id) == "") { ?>
		<th data-name="pam_id" class="<?php echo $po_pending_wbc->pam_id->headerCellClass() ?>"><div id="elh_po_pending_wbc_pam_id" class="po_pending_wbc_pam_id"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->pam_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pam_id" class="<?php echo $po_pending_wbc->pam_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->pam_id) ?>',2);"><div id="elh_po_pending_wbc_pam_id" class="po_pending_wbc_pam_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->pam_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->pam_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->pam_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->issue_to->Visible) { // issue_to ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $po_pending_wbc->issue_to->headerCellClass() ?>"><div id="elh_po_pending_wbc_issue_to" class="po_pending_wbc_issue_to"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $po_pending_wbc->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->issue_to) ?>',2);"><div id="elh_po_pending_wbc_issue_to" class="po_pending_wbc_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->pp_qty->Visible) { // pp_qty ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->pp_qty) == "") { ?>
		<th data-name="pp_qty" class="<?php echo $po_pending_wbc->pp_qty->headerCellClass() ?>"><div id="elh_po_pending_wbc_pp_qty" class="po_pending_wbc_pp_qty"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->pp_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_qty" class="<?php echo $po_pending_wbc->pp_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->pp_qty) ?>',2);"><div id="elh_po_pending_wbc_pp_qty" class="po_pending_wbc_pp_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->pp_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->pp_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->pp_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->company_id->Visible) { // company_id ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $po_pending_wbc->company_id->headerCellClass() ?>"><div id="elh_po_pending_wbc_company_id" class="po_pending_wbc_company_id"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $po_pending_wbc->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->company_id) ?>',2);"><div id="elh_po_pending_wbc_company_id" class="po_pending_wbc_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->jc_quantity->Visible) { // jc_quantity ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->jc_quantity) == "") { ?>
		<th data-name="jc_quantity" class="<?php echo $po_pending_wbc->jc_quantity->headerCellClass() ?>"><div id="elh_po_pending_wbc_jc_quantity" class="po_pending_wbc_jc_quantity"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->jc_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_quantity" class="<?php echo $po_pending_wbc->jc_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->jc_quantity) ?>',2);"><div id="elh_po_pending_wbc_jc_quantity" class="po_pending_wbc_jc_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->jc_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->jc_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->jc_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->status->Visible) { // status ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->status) == "") { ?>
		<th data-name="status" class="<?php echo $po_pending_wbc->status->headerCellClass() ?>"><div id="elh_po_pending_wbc_status" class="po_pending_wbc_status"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $po_pending_wbc->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->status) ?>',2);"><div id="elh_po_pending_wbc_status" class="po_pending_wbc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->level->Visible) { // level ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->level) == "") { ?>
		<th data-name="level" class="<?php echo $po_pending_wbc->level->headerCellClass() ?>"><div id="elh_po_pending_wbc_level" class="po_pending_wbc_level"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="level" class="<?php echo $po_pending_wbc->level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->level) ?>',2);"><div id="elh_po_pending_wbc_level" class="po_pending_wbc_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->level->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->buyer_id->Visible) { // buyer_id ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->buyer_id) == "") { ?>
		<th data-name="buyer_id" class="<?php echo $po_pending_wbc->buyer_id->headerCellClass() ?>"><div id="elh_po_pending_wbc_buyer_id" class="po_pending_wbc_buyer_id"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->buyer_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_id" class="<?php echo $po_pending_wbc->buyer_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->buyer_id) ?>',2);"><div id="elh_po_pending_wbc_buyer_id" class="po_pending_wbc_buyer_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->buyer_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->buyer_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->buyer_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending_wbc->balance->Visible) { // balance ?>
	<?php if ($po_pending_wbc->sortUrl($po_pending_wbc->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $po_pending_wbc->balance->headerCellClass() ?>"><div id="elh_po_pending_wbc_balance" class="po_pending_wbc_balance"><div class="ew-table-header-caption"><?php echo $po_pending_wbc->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $po_pending_wbc->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending_wbc->SortUrl($po_pending_wbc->balance) ?>',2);"><div id="elh_po_pending_wbc_balance" class="po_pending_wbc_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending_wbc->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending_wbc->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending_wbc->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_pending_wbc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_pending_wbc->ExportAll && $po_pending_wbc->isExport()) {
	$po_pending_wbc_list->StopRec = $po_pending_wbc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_pending_wbc_list->TotalRecs > $po_pending_wbc_list->StartRec + $po_pending_wbc_list->DisplayRecs - 1)
		$po_pending_wbc_list->StopRec = $po_pending_wbc_list->StartRec + $po_pending_wbc_list->DisplayRecs - 1;
	else
		$po_pending_wbc_list->StopRec = $po_pending_wbc_list->TotalRecs;
}
$po_pending_wbc_list->RecCnt = $po_pending_wbc_list->StartRec - 1;
if ($po_pending_wbc_list->Recordset && !$po_pending_wbc_list->Recordset->EOF) {
	$po_pending_wbc_list->Recordset->moveFirst();
	$selectLimit = $po_pending_wbc_list->UseSelectLimit;
	if (!$selectLimit && $po_pending_wbc_list->StartRec > 1)
		$po_pending_wbc_list->Recordset->move($po_pending_wbc_list->StartRec - 1);
} elseif (!$po_pending_wbc->AllowAddDeleteRow && $po_pending_wbc_list->StopRec == 0) {
	$po_pending_wbc_list->StopRec = $po_pending_wbc->GridAddRowCount;
}

// Initialize aggregate
$po_pending_wbc->RowType = ROWTYPE_AGGREGATEINIT;
$po_pending_wbc->resetAttributes();
$po_pending_wbc_list->renderRow();
while ($po_pending_wbc_list->RecCnt < $po_pending_wbc_list->StopRec) {
	$po_pending_wbc_list->RecCnt++;
	if ($po_pending_wbc_list->RecCnt >= $po_pending_wbc_list->StartRec) {
		$po_pending_wbc_list->RowCnt++;

		// Set up key count
		$po_pending_wbc_list->KeyCount = $po_pending_wbc_list->RowIndex;

		// Init row class and style
		$po_pending_wbc->resetAttributes();
		$po_pending_wbc->CssClass = "";
		if ($po_pending_wbc->isGridAdd()) {
		} else {
			$po_pending_wbc_list->loadRowValues($po_pending_wbc_list->Recordset); // Load row values
		}
		$po_pending_wbc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_pending_wbc->RowAttrs = array_merge($po_pending_wbc->RowAttrs, array('data-rowindex'=>$po_pending_wbc_list->RowCnt, 'id'=>'r' . $po_pending_wbc_list->RowCnt . '_po_pending_wbc', 'data-rowtype'=>$po_pending_wbc->RowType));

		// Render row
		$po_pending_wbc_list->renderRow();

		// Render list options
		$po_pending_wbc_list->renderListOptions();
?>
	<tr<?php echo $po_pending_wbc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_pending_wbc_list->ListOptions->render("body", "left", $po_pending_wbc_list->RowCnt);
?>
	<?php if ($po_pending_wbc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $po_pending_wbc->id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_id" class="po_pending_wbc_id">
<span<?php echo $po_pending_wbc->id->viewAttributes() ?>>
<?php echo $po_pending_wbc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->pod->Visible) { // pod ?>
		<td data-name="pod"<?php echo $po_pending_wbc->pod->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_pod" class="po_pending_wbc_pod">
<span<?php echo $po_pending_wbc->pod->viewAttributes() ?>>
<?php echo $po_pending_wbc->pod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $po_pending_wbc->jc_no->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_jc_no" class="po_pending_wbc_jc_no">
<span<?php echo $po_pending_wbc->jc_no->viewAttributes() ?>>
<?php echo $po_pending_wbc->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $po_pending_wbc->product_code->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_product_code" class="po_pending_wbc_product_code">
<span<?php echo $po_pending_wbc->product_code->viewAttributes() ?>>
<?php echo $po_pending_wbc->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $po_pending_wbc->batch_no->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_batch_no" class="po_pending_wbc_batch_no">
<span<?php echo $po_pending_wbc->batch_no->viewAttributes() ?>>
<?php echo $po_pending_wbc->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->cart_quantity->Visible) { // cart_quantity ?>
		<td data-name="cart_quantity"<?php echo $po_pending_wbc->cart_quantity->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_cart_quantity" class="po_pending_wbc_cart_quantity">
<span<?php echo $po_pending_wbc->cart_quantity->viewAttributes() ?>>
<?php echo $po_pending_wbc->cart_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->pam_qty->Visible) { // pam_qty ?>
		<td data-name="pam_qty"<?php echo $po_pending_wbc->pam_qty->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_pam_qty" class="po_pending_wbc_pam_qty">
<span<?php echo $po_pending_wbc->pam_qty->viewAttributes() ?>>
<?php echo $po_pending_wbc->pam_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->pending_qty->Visible) { // pending_qty ?>
		<td data-name="pending_qty"<?php echo $po_pending_wbc->pending_qty->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_pending_qty" class="po_pending_wbc_pending_qty">
<span<?php echo $po_pending_wbc->pending_qty->viewAttributes() ?>>
<?php echo $po_pending_wbc->pending_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $po_pending_wbc->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_despatch_week" class="po_pending_wbc_despatch_week">
<span<?php echo $po_pending_wbc->despatch_week->viewAttributes() ?>>
<?php echo $po_pending_wbc->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $po_pending_wbc->packing_type->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_packing_type" class="po_pending_wbc_packing_type">
<span<?php echo $po_pending_wbc->packing_type->viewAttributes() ?>>
<?php echo $po_pending_wbc->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->process->Visible) { // process ?>
		<td data-name="process"<?php echo $po_pending_wbc->process->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_process" class="po_pending_wbc_process">
<span<?php echo $po_pending_wbc->process->viewAttributes() ?>>
<?php echo $po_pending_wbc->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->pam_id->Visible) { // pam_id ?>
		<td data-name="pam_id"<?php echo $po_pending_wbc->pam_id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_pam_id" class="po_pending_wbc_pam_id">
<span<?php echo $po_pending_wbc->pam_id->viewAttributes() ?>>
<?php echo $po_pending_wbc->pam_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $po_pending_wbc->issue_to->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_issue_to" class="po_pending_wbc_issue_to">
<span<?php echo $po_pending_wbc->issue_to->viewAttributes() ?>>
<?php echo $po_pending_wbc->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->pp_qty->Visible) { // pp_qty ?>
		<td data-name="pp_qty"<?php echo $po_pending_wbc->pp_qty->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_pp_qty" class="po_pending_wbc_pp_qty">
<span<?php echo $po_pending_wbc->pp_qty->viewAttributes() ?>>
<?php echo $po_pending_wbc->pp_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $po_pending_wbc->company_id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_company_id" class="po_pending_wbc_company_id">
<span<?php echo $po_pending_wbc->company_id->viewAttributes() ?>>
<?php echo $po_pending_wbc->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->jc_quantity->Visible) { // jc_quantity ?>
		<td data-name="jc_quantity"<?php echo $po_pending_wbc->jc_quantity->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_jc_quantity" class="po_pending_wbc_jc_quantity">
<span<?php echo $po_pending_wbc->jc_quantity->viewAttributes() ?>>
<?php echo $po_pending_wbc->jc_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->status->Visible) { // status ?>
		<td data-name="status"<?php echo $po_pending_wbc->status->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_status" class="po_pending_wbc_status">
<span<?php echo $po_pending_wbc->status->viewAttributes() ?>>
<?php echo $po_pending_wbc->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->level->Visible) { // level ?>
		<td data-name="level"<?php echo $po_pending_wbc->level->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_level" class="po_pending_wbc_level">
<span<?php echo $po_pending_wbc->level->viewAttributes() ?>>
<?php echo $po_pending_wbc->level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id"<?php echo $po_pending_wbc->buyer_id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_buyer_id" class="po_pending_wbc_buyer_id">
<span<?php echo $po_pending_wbc->buyer_id->viewAttributes() ?>>
<?php echo $po_pending_wbc->buyer_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending_wbc->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $po_pending_wbc->balance->cellAttributes() ?>>
<span id="el<?php echo $po_pending_wbc_list->RowCnt ?>_po_pending_wbc_balance" class="po_pending_wbc_balance">
<span<?php echo $po_pending_wbc->balance->viewAttributes() ?>>
<?php echo $po_pending_wbc->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_pending_wbc_list->ListOptions->render("body", "right", $po_pending_wbc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_pending_wbc->isGridAdd())
		$po_pending_wbc_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$po_pending_wbc->RowType = ROWTYPE_AGGREGATE;
$po_pending_wbc->resetAttributes();
$po_pending_wbc_list->renderRow();
?>
<?php if ($po_pending_wbc_list->TotalRecs > 0 && !$po_pending_wbc->isGridAdd() && !$po_pending_wbc->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$po_pending_wbc_list->renderListOptions();

// Render list options (footer, left)
$po_pending_wbc_list->ListOptions->render("footer", "left");
?>
	<?php if ($po_pending_wbc->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $po_pending_wbc->id->footerCellClass() ?>"><span id="elf_po_pending_wbc_id" class="po_pending_wbc_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->pod->Visible) { // pod ?>
		<td data-name="pod" class="<?php echo $po_pending_wbc->pod->footerCellClass() ?>"><span id="elf_po_pending_wbc_pod" class="po_pending_wbc_pod">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $po_pending_wbc->jc_no->footerCellClass() ?>"><span id="elf_po_pending_wbc_jc_no" class="po_pending_wbc_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $po_pending_wbc->product_code->footerCellClass() ?>"><span id="elf_po_pending_wbc_product_code" class="po_pending_wbc_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $po_pending_wbc->batch_no->footerCellClass() ?>"><span id="elf_po_pending_wbc_batch_no" class="po_pending_wbc_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->cart_quantity->Visible) { // cart_quantity ?>
		<td data-name="cart_quantity" class="<?php echo $po_pending_wbc->cart_quantity->footerCellClass() ?>"><span id="elf_po_pending_wbc_cart_quantity" class="po_pending_wbc_cart_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_pending_wbc->cart_quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->pam_qty->Visible) { // pam_qty ?>
		<td data-name="pam_qty" class="<?php echo $po_pending_wbc->pam_qty->footerCellClass() ?>"><span id="elf_po_pending_wbc_pam_qty" class="po_pending_wbc_pam_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_pending_wbc->pam_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->pending_qty->Visible) { // pending_qty ?>
		<td data-name="pending_qty" class="<?php echo $po_pending_wbc->pending_qty->footerCellClass() ?>"><span id="elf_po_pending_wbc_pending_qty" class="po_pending_wbc_pending_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_pending_wbc->pending_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week" class="<?php echo $po_pending_wbc->despatch_week->footerCellClass() ?>"><span id="elf_po_pending_wbc_despatch_week" class="po_pending_wbc_despatch_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $po_pending_wbc->packing_type->footerCellClass() ?>"><span id="elf_po_pending_wbc_packing_type" class="po_pending_wbc_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $po_pending_wbc->process->footerCellClass() ?>"><span id="elf_po_pending_wbc_process" class="po_pending_wbc_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->pam_id->Visible) { // pam_id ?>
		<td data-name="pam_id" class="<?php echo $po_pending_wbc->pam_id->footerCellClass() ?>"><span id="elf_po_pending_wbc_pam_id" class="po_pending_wbc_pam_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $po_pending_wbc->issue_to->footerCellClass() ?>"><span id="elf_po_pending_wbc_issue_to" class="po_pending_wbc_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->pp_qty->Visible) { // pp_qty ?>
		<td data-name="pp_qty" class="<?php echo $po_pending_wbc->pp_qty->footerCellClass() ?>"><span id="elf_po_pending_wbc_pp_qty" class="po_pending_wbc_pp_qty">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $po_pending_wbc->pp_qty->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $po_pending_wbc->company_id->footerCellClass() ?>"><span id="elf_po_pending_wbc_company_id" class="po_pending_wbc_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->jc_quantity->Visible) { // jc_quantity ?>
		<td data-name="jc_quantity" class="<?php echo $po_pending_wbc->jc_quantity->footerCellClass() ?>"><span id="elf_po_pending_wbc_jc_quantity" class="po_pending_wbc_jc_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $po_pending_wbc->status->footerCellClass() ?>"><span id="elf_po_pending_wbc_status" class="po_pending_wbc_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->level->Visible) { // level ?>
		<td data-name="level" class="<?php echo $po_pending_wbc->level->footerCellClass() ?>"><span id="elf_po_pending_wbc_level" class="po_pending_wbc_level">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->buyer_id->Visible) { // buyer_id ?>
		<td data-name="buyer_id" class="<?php echo $po_pending_wbc->buyer_id->footerCellClass() ?>"><span id="elf_po_pending_wbc_buyer_id" class="po_pending_wbc_buyer_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($po_pending_wbc->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $po_pending_wbc->balance->footerCellClass() ?>"><span id="elf_po_pending_wbc_balance" class="po_pending_wbc_balance">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$po_pending_wbc_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_pending_wbc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_pending_wbc_list->Recordset)
	$po_pending_wbc_list->Recordset->Close();
?>
<?php if (!$po_pending_wbc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_pending_wbc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_pending_wbc_list->Pager)) $po_pending_wbc_list->Pager = new PrevNextPager($po_pending_wbc_list->StartRec, $po_pending_wbc_list->DisplayRecs, $po_pending_wbc_list->TotalRecs, $po_pending_wbc_list->AutoHidePager) ?>
<?php if ($po_pending_wbc_list->Pager->RecordCount > 0 && $po_pending_wbc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_pending_wbc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_pending_wbc_list->pageUrl() ?>start=<?php echo $po_pending_wbc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_pending_wbc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_pending_wbc_list->pageUrl() ?>start=<?php echo $po_pending_wbc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_pending_wbc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_pending_wbc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_pending_wbc_list->pageUrl() ?>start=<?php echo $po_pending_wbc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_pending_wbc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_pending_wbc_list->pageUrl() ?>start=<?php echo $po_pending_wbc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_pending_wbc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_pending_wbc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_pending_wbc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_pending_wbc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_pending_wbc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_pending_wbc_list->TotalRecs > 0 && (!$po_pending_wbc_list->AutoHidePageSizeSelector || $po_pending_wbc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_pending_wbc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_pending_wbc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_pending_wbc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_pending_wbc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_pending_wbc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_pending_wbc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_pending_wbc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_pending_wbc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_pending_wbc_list->TotalRecs == 0 && !$po_pending_wbc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_pending_wbc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_pending_wbc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_pending_wbc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_pending_wbc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_pending_wbc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_pending_wbc_list->terminate();
?>