<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_pending_list = new po_pending_list();

// Run the page
$po_pending_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_pending_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_pending->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpo_pendinglist = currentForm = new ew.Form("fpo_pendinglist", "list");
fpo_pendinglist.formKeyCountName = '<?php echo $po_pending_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpo_pendinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_pendinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_pendinglist.lists["x_status"] = <?php echo $po_pending_list->status->Lookup->toClientList() ?>;
fpo_pendinglist.lists["x_status"].options = <?php echo JsonEncode($po_pending_list->status->options(FALSE, TRUE)) ?>;
fpo_pendinglist.lists["x_company_id"] = <?php echo $po_pending_list->company_id->Lookup->toClientList() ?>;
fpo_pendinglist.lists["x_company_id"].options = <?php echo JsonEncode($po_pending_list->company_id->lookupOptions()) ?>;
fpo_pendinglist.lists["x_grp"] = <?php echo $po_pending_list->grp->Lookup->toClientList() ?>;
fpo_pendinglist.lists["x_grp"].options = <?php echo JsonEncode($po_pending_list->grp->lookupOptions()) ?>;
fpo_pendinglist.lists["x_product"] = <?php echo $po_pending_list->product->Lookup->toClientList() ?>;
fpo_pendinglist.lists["x_product"].options = <?php echo JsonEncode($po_pending_list->product->lookupOptions()) ?>;
fpo_pendinglist.lists["x_partner_id"] = <?php echo $po_pending_list->partner_id->Lookup->toClientList() ?>;
fpo_pendinglist.lists["x_partner_id"].options = <?php echo JsonEncode($po_pending_list->partner_id->lookupOptions()) ?>;

// Form object for search
var fpo_pendinglistsrch = currentSearchForm = new ew.Form("fpo_pendinglistsrch");

// Validate function for search
fpo_pendinglistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpo_pendinglistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_pendinglistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_pendinglistsrch.lists["x_grp"] = <?php echo $po_pending_list->grp->Lookup->toClientList() ?>;
fpo_pendinglistsrch.lists["x_grp"].options = <?php echo JsonEncode($po_pending_list->grp->lookupOptions()) ?>;
fpo_pendinglistsrch.lists["x_product"] = <?php echo $po_pending_list->product->Lookup->toClientList() ?>;
fpo_pendinglistsrch.lists["x_product"].options = <?php echo JsonEncode($po_pending_list->product->lookupOptions()) ?>;

// Filters
fpo_pendinglistsrch.filterList = <?php echo $po_pending_list->getFilterList() ?>;

// Init search panel as collapsed
fpo_pendinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_pending->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($po_pending_list->TotalRecs > 0 && $po_pending_list->ExportOptions->visible()) { ?>
<?php $po_pending_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($po_pending_list->ImportOptions->visible()) { ?>
<?php $po_pending_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($po_pending_list->SearchOptions->visible()) { ?>
<?php $po_pending_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($po_pending_list->FilterOptions->visible()) { ?>
<?php $po_pending_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$po_pending_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$po_pending->isExport() && !$po_pending->CurrentAction) { ?>
<form name="fpo_pendinglistsrch" id="fpo_pendinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($po_pending_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpo_pendinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="po_pending">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$po_pending_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$po_pending->RowType = ROWTYPE_SEARCH;

// Render row
$po_pending->resetAttributes();
$po_pending_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($po_pending->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $po_pending->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $po_pending->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_pending->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_pending" data-field="x_grp" data-value-separator="<?php echo $po_pending->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_pending->grp->editAttributes() ?>>
		<?php echo $po_pending->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $po_pending->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($po_pending->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $po_pending->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_pending" data-field="x_product" data-value-separator="<?php echo $po_pending->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $po_pending->product->editAttributes() ?>>
		<?php echo $po_pending->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $po_pending->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($po_pending_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($po_pending_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $po_pending_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($po_pending_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($po_pending_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($po_pending_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($po_pending_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $po_pending_list->showPageHeader(); ?>
<?php
$po_pending_list->showMessage();
?>
<?php if ($po_pending_list->TotalRecs > 0 || $po_pending->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($po_pending_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> po_pending">
<?php if (!$po_pending->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$po_pending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_pending_list->Pager)) $po_pending_list->Pager = new PrevNextPager($po_pending_list->StartRec, $po_pending_list->DisplayRecs, $po_pending_list->TotalRecs, $po_pending_list->AutoHidePager) ?>
<?php if ($po_pending_list->Pager->RecordCount > 0 && $po_pending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_pending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_pending_list->pageUrl() ?>start=<?php echo $po_pending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_pending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_pending_list->pageUrl() ?>start=<?php echo $po_pending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_pending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_pending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_pending_list->pageUrl() ?>start=<?php echo $po_pending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_pending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_pending_list->pageUrl() ?>start=<?php echo $po_pending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_pending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_pending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_pending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_pending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_pending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_pending_list->TotalRecs > 0 && (!$po_pending_list->AutoHidePageSizeSelector || $po_pending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_pending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_pending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_pending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_pending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_pending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_pending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_pending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_pending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpo_pendinglist" id="fpo_pendinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_pending_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_pending_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_pending">
<div id="gmp_po_pending" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($po_pending_list->TotalRecs > 0 || $po_pending->isGridEdit()) { ?>
<table id="tbl_po_pendinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$po_pending_list->RowType = ROWTYPE_HEADER;

// Render list options
$po_pending_list->renderListOptions();

// Render list options (header, left)
$po_pending_list->ListOptions->render("header", "left");
?>
<?php if ($po_pending->cart_id->Visible) { // cart_id ?>
	<?php if ($po_pending->sortUrl($po_pending->cart_id) == "") { ?>
		<th data-name="cart_id" class="<?php echo $po_pending->cart_id->headerCellClass() ?>"><div id="elh_po_pending_cart_id" class="po_pending_cart_id"><div class="ew-table-header-caption"><?php echo $po_pending->cart_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cart_id" class="<?php echo $po_pending->cart_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->cart_id) ?>',2);"><div id="elh_po_pending_cart_id" class="po_pending_cart_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->cart_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->cart_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->cart_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->po_id->Visible) { // po_id ?>
	<?php if ($po_pending->sortUrl($po_pending->po_id) == "") { ?>
		<th data-name="po_id" class="<?php echo $po_pending->po_id->headerCellClass() ?>"><div id="elh_po_pending_po_id" class="po_pending_po_id"><div class="ew-table-header-caption"><?php echo $po_pending->po_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po_id" class="<?php echo $po_pending->po_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->po_id) ?>',2);"><div id="elh_po_pending_po_id" class="po_pending_po_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->po_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->po_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->po_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->partner_order_no->Visible) { // partner_order_no ?>
	<?php if ($po_pending->sortUrl($po_pending->partner_order_no) == "") { ?>
		<th data-name="partner_order_no" class="<?php echo $po_pending->partner_order_no->headerCellClass() ?>"><div id="elh_po_pending_partner_order_no" class="po_pending_partner_order_no"><div class="ew-table-header-caption"><?php echo $po_pending->partner_order_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_order_no" class="<?php echo $po_pending->partner_order_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->partner_order_no) ?>',2);"><div id="elh_po_pending_partner_order_no" class="po_pending_partner_order_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->partner_order_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_pending->partner_order_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->partner_order_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->status->Visible) { // status ?>
	<?php if ($po_pending->sortUrl($po_pending->status) == "") { ?>
		<th data-name="status" class="<?php echo $po_pending->status->headerCellClass() ?>"><div id="elh_po_pending_status" class="po_pending_status"><div class="ew-table-header-caption"><?php echo $po_pending->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $po_pending->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->status) ?>',2);"><div id="elh_po_pending_status" class="po_pending_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->company_id->Visible) { // company_id ?>
	<?php if ($po_pending->sortUrl($po_pending->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $po_pending->company_id->headerCellClass() ?>"><div id="elh_po_pending_company_id" class="po_pending_company_id"><div class="ew-table-header-caption"><?php echo $po_pending->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $po_pending->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->company_id) ?>',2);"><div id="elh_po_pending_company_id" class="po_pending_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->product_code->Visible) { // product_code ?>
	<?php if ($po_pending->sortUrl($po_pending->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $po_pending->product_code->headerCellClass() ?>"><div id="elh_po_pending_product_code" class="po_pending_product_code"><div class="ew-table-header-caption"><?php echo $po_pending->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $po_pending->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->product_code) ?>',2);"><div id="elh_po_pending_product_code" class="po_pending_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_pending->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->quantity->Visible) { // quantity ?>
	<?php if ($po_pending->sortUrl($po_pending->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $po_pending->quantity->headerCellClass() ?>"><div id="elh_po_pending_quantity" class="po_pending_quantity"><div class="ew-table-header-caption"><?php echo $po_pending->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $po_pending->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->quantity) ?>',2);"><div id="elh_po_pending_quantity" class="po_pending_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->stock->Visible) { // stock ?>
	<?php if ($po_pending->sortUrl($po_pending->stock) == "") { ?>
		<th data-name="stock" class="<?php echo $po_pending->stock->headerCellClass() ?>"><div id="elh_po_pending_stock" class="po_pending_stock"><div class="ew-table-header-caption"><?php echo $po_pending->stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock" class="<?php echo $po_pending->stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->stock) ?>',2);"><div id="elh_po_pending_stock" class="po_pending_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->despatch_date->Visible) { // despatch_date ?>
	<?php if ($po_pending->sortUrl($po_pending->despatch_date) == "") { ?>
		<th data-name="despatch_date" class="<?php echo $po_pending->despatch_date->headerCellClass() ?>"><div id="elh_po_pending_despatch_date" class="po_pending_despatch_date"><div class="ew-table-header-caption"><?php echo $po_pending->despatch_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_date" class="<?php echo $po_pending->despatch_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->despatch_date) ?>',2);"><div id="elh_po_pending_despatch_date" class="po_pending_despatch_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->despatch_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->despatch_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->despatch_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->grp->Visible) { // grp ?>
	<?php if ($po_pending->sortUrl($po_pending->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $po_pending->grp->headerCellClass() ?>"><div id="elh_po_pending_grp" class="po_pending_grp"><div class="ew-table-header-caption"><?php echo $po_pending->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $po_pending->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->grp) ?>',2);"><div id="elh_po_pending_grp" class="po_pending_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->product->Visible) { // product ?>
	<?php if ($po_pending->sortUrl($po_pending->product) == "") { ?>
		<th data-name="product" class="<?php echo $po_pending->product->headerCellClass() ?>"><div id="elh_po_pending_product" class="po_pending_product"><div class="ew-table-header-caption"><?php echo $po_pending->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $po_pending->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->product) ?>',2);"><div id="elh_po_pending_product" class="po_pending_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->partner_id->Visible) { // partner_id ?>
	<?php if ($po_pending->sortUrl($po_pending->partner_id) == "") { ?>
		<th data-name="partner_id" class="<?php echo $po_pending->partner_id->headerCellClass() ?>"><div id="elh_po_pending_partner_id" class="po_pending_partner_id"><div class="ew-table-header-caption"><?php echo $po_pending->partner_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner_id" class="<?php echo $po_pending->partner_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->partner_id) ?>',2);"><div id="elh_po_pending_partner_id" class="po_pending_partner_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->partner_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($po_pending->partner_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->partner_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($po_pending->m_out_id->Visible) { // m_out_id ?>
	<?php if ($po_pending->sortUrl($po_pending->m_out_id) == "") { ?>
		<th data-name="m_out_id" class="<?php echo $po_pending->m_out_id->headerCellClass() ?>"><div id="elh_po_pending_m_out_id" class="po_pending_m_out_id"><div class="ew-table-header-caption"><?php echo $po_pending->m_out_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_out_id" class="<?php echo $po_pending->m_out_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $po_pending->SortUrl($po_pending->m_out_id) ?>',2);"><div id="elh_po_pending_m_out_id" class="po_pending_m_out_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $po_pending->m_out_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($po_pending->m_out_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($po_pending->m_out_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$po_pending_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($po_pending->ExportAll && $po_pending->isExport()) {
	$po_pending_list->StopRec = $po_pending_list->TotalRecs;
} else {

	// Set the last record to display
	if ($po_pending_list->TotalRecs > $po_pending_list->StartRec + $po_pending_list->DisplayRecs - 1)
		$po_pending_list->StopRec = $po_pending_list->StartRec + $po_pending_list->DisplayRecs - 1;
	else
		$po_pending_list->StopRec = $po_pending_list->TotalRecs;
}
$po_pending_list->RecCnt = $po_pending_list->StartRec - 1;
if ($po_pending_list->Recordset && !$po_pending_list->Recordset->EOF) {
	$po_pending_list->Recordset->moveFirst();
	$selectLimit = $po_pending_list->UseSelectLimit;
	if (!$selectLimit && $po_pending_list->StartRec > 1)
		$po_pending_list->Recordset->move($po_pending_list->StartRec - 1);
} elseif (!$po_pending->AllowAddDeleteRow && $po_pending_list->StopRec == 0) {
	$po_pending_list->StopRec = $po_pending->GridAddRowCount;
}

// Initialize aggregate
$po_pending->RowType = ROWTYPE_AGGREGATEINIT;
$po_pending->resetAttributes();
$po_pending_list->renderRow();
while ($po_pending_list->RecCnt < $po_pending_list->StopRec) {
	$po_pending_list->RecCnt++;
	if ($po_pending_list->RecCnt >= $po_pending_list->StartRec) {
		$po_pending_list->RowCnt++;

		// Set up key count
		$po_pending_list->KeyCount = $po_pending_list->RowIndex;

		// Init row class and style
		$po_pending->resetAttributes();
		$po_pending->CssClass = "";
		if ($po_pending->isGridAdd()) {
		} else {
			$po_pending_list->loadRowValues($po_pending_list->Recordset); // Load row values
		}
		$po_pending->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$po_pending->RowAttrs = array_merge($po_pending->RowAttrs, array('data-rowindex'=>$po_pending_list->RowCnt, 'id'=>'r' . $po_pending_list->RowCnt . '_po_pending', 'data-rowtype'=>$po_pending->RowType));

		// Render row
		$po_pending_list->renderRow();

		// Render list options
		$po_pending_list->renderListOptions();
?>
	<tr<?php echo $po_pending->rowAttributes() ?>>
<?php

// Render list options (body, left)
$po_pending_list->ListOptions->render("body", "left", $po_pending_list->RowCnt);
?>
	<?php if ($po_pending->cart_id->Visible) { // cart_id ?>
		<td data-name="cart_id"<?php echo $po_pending->cart_id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_cart_id" class="po_pending_cart_id">
<span<?php echo $po_pending->cart_id->viewAttributes() ?>>
<?php echo $po_pending->cart_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->po_id->Visible) { // po_id ?>
		<td data-name="po_id"<?php echo $po_pending->po_id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_po_id" class="po_pending_po_id">
<span<?php echo $po_pending->po_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->po_id->getViewValue())) && $po_pending->po_id->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->po_id->linkAttributes() ?>><?php echo $po_pending->po_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->po_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->partner_order_no->Visible) { // partner_order_no ?>
		<td data-name="partner_order_no"<?php echo $po_pending->partner_order_no->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_partner_order_no" class="po_pending_partner_order_no">
<span<?php echo $po_pending->partner_order_no->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->partner_order_no->getViewValue())) && $po_pending->partner_order_no->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->partner_order_no->linkAttributes() ?>><?php echo $po_pending->partner_order_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->partner_order_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->status->Visible) { // status ?>
		<td data-name="status"<?php echo $po_pending->status->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_status" class="po_pending_status">
<span<?php echo $po_pending->status->viewAttributes() ?>>
<?php echo $po_pending->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $po_pending->company_id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_company_id" class="po_pending_company_id">
<span<?php echo $po_pending->company_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->company_id->getViewValue())) && $po_pending->company_id->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->company_id->linkAttributes() ?>><?php echo $po_pending->company_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->company_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $po_pending->product_code->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_product_code" class="po_pending_product_code">
<span<?php echo $po_pending->product_code->viewAttributes() ?>>
<?php echo $po_pending->product_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $po_pending->quantity->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_quantity" class="po_pending_quantity">
<span<?php echo $po_pending->quantity->viewAttributes() ?>>
<?php echo $po_pending->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->stock->Visible) { // stock ?>
		<td data-name="stock"<?php echo $po_pending->stock->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_stock" class="po_pending_stock">
<span<?php echo $po_pending->stock->viewAttributes() ?>>
<?php echo $po_pending->stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->despatch_date->Visible) { // despatch_date ?>
		<td data-name="despatch_date"<?php echo $po_pending->despatch_date->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_despatch_date" class="po_pending_despatch_date">
<span<?php echo $po_pending->despatch_date->viewAttributes() ?>>
<?php echo $po_pending->despatch_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $po_pending->grp->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_grp" class="po_pending_grp">
<span<?php echo $po_pending->grp->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->grp->getViewValue())) && $po_pending->grp->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->grp->linkAttributes() ?>><?php echo $po_pending->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->product->Visible) { // product ?>
		<td data-name="product"<?php echo $po_pending->product->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_product" class="po_pending_product">
<span<?php echo $po_pending->product->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->product->getViewValue())) && $po_pending->product->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->product->linkAttributes() ?>><?php echo $po_pending->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->partner_id->Visible) { // partner_id ?>
		<td data-name="partner_id"<?php echo $po_pending->partner_id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_partner_id" class="po_pending_partner_id">
<span<?php echo $po_pending->partner_id->viewAttributes() ?>>
<?php echo $po_pending->partner_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($po_pending->m_out_id->Visible) { // m_out_id ?>
		<td data-name="m_out_id"<?php echo $po_pending->m_out_id->cellAttributes() ?>>
<span id="el<?php echo $po_pending_list->RowCnt ?>_po_pending_m_out_id" class="po_pending_m_out_id">
<span<?php echo $po_pending->m_out_id->viewAttributes() ?>>
<?php echo $po_pending->m_out_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$po_pending_list->ListOptions->render("body", "right", $po_pending_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$po_pending->isGridAdd())
		$po_pending_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$po_pending->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($po_pending_list->Recordset)
	$po_pending_list->Recordset->Close();
?>
<?php if (!$po_pending->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$po_pending->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($po_pending_list->Pager)) $po_pending_list->Pager = new PrevNextPager($po_pending_list->StartRec, $po_pending_list->DisplayRecs, $po_pending_list->TotalRecs, $po_pending_list->AutoHidePager) ?>
<?php if ($po_pending_list->Pager->RecordCount > 0 && $po_pending_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($po_pending_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $po_pending_list->pageUrl() ?>start=<?php echo $po_pending_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($po_pending_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $po_pending_list->pageUrl() ?>start=<?php echo $po_pending_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $po_pending_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($po_pending_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $po_pending_list->pageUrl() ?>start=<?php echo $po_pending_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($po_pending_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $po_pending_list->pageUrl() ?>start=<?php echo $po_pending_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $po_pending_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($po_pending_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $po_pending_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $po_pending_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $po_pending_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($po_pending_list->TotalRecs > 0 && (!$po_pending_list->AutoHidePageSizeSelector || $po_pending_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="po_pending">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($po_pending_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($po_pending_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($po_pending_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($po_pending_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($po_pending_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($po_pending->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $po_pending_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($po_pending_list->TotalRecs == 0 && !$po_pending->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $po_pending_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$po_pending_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_pending->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$po_pending->isExport()) { ?>
<script>
ew.scrollableTable("gmp_po_pending", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_pending_list->terminate();
?>