<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_pending_search = new po_pending_search();

// Run the page
$po_pending_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_pending_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($po_pending_search->IsModal) { ?>
var fpo_pendingsearch = currentAdvancedSearchForm = new ew.Form("fpo_pendingsearch", "search");
<?php } else { ?>
var fpo_pendingsearch = currentForm = new ew.Form("fpo_pendingsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpo_pendingsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_pendingsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_pendingsearch.lists["x_status"] = <?php echo $po_pending_search->status->Lookup->toClientList() ?>;
fpo_pendingsearch.lists["x_status"].options = <?php echo JsonEncode($po_pending_search->status->options(FALSE, TRUE)) ?>;
fpo_pendingsearch.lists["x_company_id"] = <?php echo $po_pending_search->company_id->Lookup->toClientList() ?>;
fpo_pendingsearch.lists["x_company_id"].options = <?php echo JsonEncode($po_pending_search->company_id->lookupOptions()) ?>;
fpo_pendingsearch.lists["x_grp"] = <?php echo $po_pending_search->grp->Lookup->toClientList() ?>;
fpo_pendingsearch.lists["x_grp"].options = <?php echo JsonEncode($po_pending_search->grp->lookupOptions()) ?>;
fpo_pendingsearch.lists["x_product"] = <?php echo $po_pending_search->product->Lookup->toClientList() ?>;
fpo_pendingsearch.lists["x_product"].options = <?php echo JsonEncode($po_pending_search->product->lookupOptions()) ?>;
fpo_pendingsearch.lists["x_partner_id"] = <?php echo $po_pending_search->partner_id->Lookup->toClientList() ?>;
fpo_pendingsearch.lists["x_partner_id"].options = <?php echo JsonEncode($po_pending_search->partner_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpo_pendingsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_cart_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_pending->cart_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_pending->po_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ref");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_pending->ref->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_quantity");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_pending->quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_pending->stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_despatch_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($po_pending->despatch_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $po_pending_search->showPageHeader(); ?>
<?php
$po_pending_search->showMessage();
?>
<form name="fpo_pendingsearch" id="fpo_pendingsearch" class="<?php echo $po_pending_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_pending_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_pending_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_pending">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$po_pending_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($po_pending->cart_id->Visible) { // cart_id ?>
	<div id="r_cart_id" class="form-group row">
		<label for="x_cart_id" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_cart_id"><?php echo $po_pending->cart_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cart_id" id="z_cart_id" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->cart_id->cellAttributes() ?>>
			<span id="el_po_pending_cart_id">
<input type="text" data-table="po_pending" data-field="x_cart_id" name="x_cart_id" id="x_cart_id" placeholder="<?php echo HtmlEncode($po_pending->cart_id->getPlaceHolder()) ?>" value="<?php echo $po_pending->cart_id->EditValue ?>"<?php echo $po_pending->cart_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->po_id->Visible) { // po_id ?>
	<div id="r_po_id" class="form-group row">
		<label for="x_po_id" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_po_id"><?php echo $po_pending->po_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_id" id="z_po_id" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->po_id->cellAttributes() ?>>
			<span id="el_po_pending_po_id">
<input type="text" data-table="po_pending" data-field="x_po_id" name="x_po_id" id="x_po_id" size="30" placeholder="<?php echo HtmlEncode($po_pending->po_id->getPlaceHolder()) ?>" value="<?php echo $po_pending->po_id->EditValue ?>"<?php echo $po_pending->po_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->partner_order_no->Visible) { // partner_order_no ?>
	<div id="r_partner_order_no" class="form-group row">
		<label for="x_partner_order_no" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_partner_order_no"><?php echo $po_pending->partner_order_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->partner_order_no->cellAttributes() ?>>
			<span id="el_po_pending_partner_order_no">
<input type="text" data-table="po_pending" data-field="x_partner_order_no" name="x_partner_order_no" id="x_partner_order_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($po_pending->partner_order_no->getPlaceHolder()) ?>" value="<?php echo $po_pending->partner_order_no->EditValue ?>"<?php echo $po_pending->partner_order_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_status"><?php echo $po_pending->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->status->cellAttributes() ?>>
			<span id="el_po_pending_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_pending" data-field="x_status" data-value-separator="<?php echo $po_pending->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $po_pending->status->editAttributes() ?>>
		<?php echo $po_pending->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_company_id"><?php echo $po_pending->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->company_id->cellAttributes() ?>>
			<span id="el_po_pending_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_pending" data-field="x_company_id" data-value-separator="<?php echo $po_pending->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $po_pending->company_id->editAttributes() ?>>
		<?php echo $po_pending->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $po_pending->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->ref->Visible) { // ref ?>
	<div id="r_ref" class="form-group row">
		<label for="x_ref" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_ref"><?php echo $po_pending->ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ref" id="z_ref" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->ref->cellAttributes() ?>>
			<span id="el_po_pending_ref">
<input type="text" data-table="po_pending" data-field="x_ref" name="x_ref" id="x_ref" placeholder="<?php echo HtmlEncode($po_pending->ref->getPlaceHolder()) ?>" value="<?php echo $po_pending->ref->EditValue ?>"<?php echo $po_pending->ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_product_code"><?php echo $po_pending->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->product_code->cellAttributes() ?>>
			<span id="el_po_pending_product_code">
<input type="text" data-table="po_pending" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($po_pending->product_code->getPlaceHolder()) ?>" value="<?php echo $po_pending->product_code->EditValue ?>"<?php echo $po_pending->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label for="x_quantity" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_quantity"><?php echo $po_pending->quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_quantity" id="z_quantity" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->quantity->cellAttributes() ?>>
			<span id="el_po_pending_quantity">
<input type="text" data-table="po_pending" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($po_pending->quantity->getPlaceHolder()) ?>" value="<?php echo $po_pending->quantity->EditValue ?>"<?php echo $po_pending->quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->stock->Visible) { // stock ?>
	<div id="r_stock" class="form-group row">
		<label for="x_stock" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_stock"><?php echo $po_pending->stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_stock" id="z_stock" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->stock->cellAttributes() ?>>
			<span id="el_po_pending_stock">
<input type="text" data-table="po_pending" data-field="x_stock" name="x_stock" id="x_stock" size="30" placeholder="<?php echo HtmlEncode($po_pending->stock->getPlaceHolder()) ?>" value="<?php echo $po_pending->stock->EditValue ?>"<?php echo $po_pending->stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->despatch_date->Visible) { // despatch_date ?>
	<div id="r_despatch_date" class="form-group row">
		<label for="x_despatch_date" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_despatch_date"><?php echo $po_pending->despatch_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_despatch_date" id="z_despatch_date" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->despatch_date->cellAttributes() ?>>
			<span id="el_po_pending_despatch_date">
<input type="text" data-table="po_pending" data-field="x_despatch_date" name="x_despatch_date" id="x_despatch_date" placeholder="<?php echo HtmlEncode($po_pending->despatch_date->getPlaceHolder()) ?>" value="<?php echo $po_pending->despatch_date->EditValue ?>"<?php echo $po_pending->despatch_date->editAttributes() ?>>
<?php if (!$po_pending->despatch_date->ReadOnly && !$po_pending->despatch_date->Disabled && !isset($po_pending->despatch_date->EditAttrs["readonly"]) && !isset($po_pending->despatch_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpo_pendingsearch", "x_despatch_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_grp"><?php echo $po_pending->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->grp->cellAttributes() ?>>
			<span id="el_po_pending_grp">
<?php $po_pending->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$po_pending->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_pending" data-field="x_grp" data-value-separator="<?php echo $po_pending->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $po_pending->grp->editAttributes() ?>>
		<?php echo $po_pending->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $po_pending->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_product"><?php echo $po_pending->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->product->cellAttributes() ?>>
			<span id="el_po_pending_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_pending" data-field="x_product" data-value-separator="<?php echo $po_pending->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $po_pending->product->editAttributes() ?>>
		<?php echo $po_pending->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $po_pending->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->partner_id->Visible) { // partner_id ?>
	<div id="r_partner_id" class="form-group row">
		<label for="x_partner_id" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_partner_id"><?php echo $po_pending->partner_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner_id" id="z_partner_id" value="="></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->partner_id->cellAttributes() ?>>
			<span id="el_po_pending_partner_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="po_pending" data-field="x_partner_id" data-value-separator="<?php echo $po_pending->partner_id->displayValueSeparatorAttribute() ?>" id="x_partner_id" name="x_partner_id"<?php echo $po_pending->partner_id->editAttributes() ?>>
		<?php echo $po_pending->partner_id->selectOptionListHtml("x_partner_id") ?>
	</select>
</div>
<?php echo $po_pending->partner_id->Lookup->getParamTag("p_x_partner_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($po_pending->m_out_id->Visible) { // m_out_id ?>
	<div id="r_m_out_id" class="form-group row">
		<label for="x_m_out_id" class="<?php echo $po_pending_search->LeftColumnClass ?>"><span id="elh_po_pending_m_out_id"><?php echo $po_pending->m_out_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_m_out_id" id="z_m_out_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $po_pending_search->RightColumnClass ?>"><div<?php echo $po_pending->m_out_id->cellAttributes() ?>>
			<span id="el_po_pending_m_out_id">
<input type="text" data-table="po_pending" data-field="x_m_out_id" name="x_m_out_id" id="x_m_out_id" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($po_pending->m_out_id->getPlaceHolder()) ?>" value="<?php echo $po_pending->m_out_id->EditValue ?>"<?php echo $po_pending->m_out_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$po_pending_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $po_pending_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$po_pending_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$po_pending_search->terminate();
?>