<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$po_pending_view = new po_pending_view();

// Run the page
$po_pending_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$po_pending_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$po_pending->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpo_pendingview = currentForm = new ew.Form("fpo_pendingview", "view");

// Form_CustomValidate event
fpo_pendingview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpo_pendingview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpo_pendingview.lists["x_status"] = <?php echo $po_pending_view->status->Lookup->toClientList() ?>;
fpo_pendingview.lists["x_status"].options = <?php echo JsonEncode($po_pending_view->status->options(FALSE, TRUE)) ?>;
fpo_pendingview.lists["x_company_id"] = <?php echo $po_pending_view->company_id->Lookup->toClientList() ?>;
fpo_pendingview.lists["x_company_id"].options = <?php echo JsonEncode($po_pending_view->company_id->lookupOptions()) ?>;
fpo_pendingview.lists["x_grp"] = <?php echo $po_pending_view->grp->Lookup->toClientList() ?>;
fpo_pendingview.lists["x_grp"].options = <?php echo JsonEncode($po_pending_view->grp->lookupOptions()) ?>;
fpo_pendingview.lists["x_product"] = <?php echo $po_pending_view->product->Lookup->toClientList() ?>;
fpo_pendingview.lists["x_product"].options = <?php echo JsonEncode($po_pending_view->product->lookupOptions()) ?>;
fpo_pendingview.lists["x_partner_id"] = <?php echo $po_pending_view->partner_id->Lookup->toClientList() ?>;
fpo_pendingview.lists["x_partner_id"].options = <?php echo JsonEncode($po_pending_view->partner_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$po_pending->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $po_pending_view->ExportOptions->render("body") ?>
<?php $po_pending_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $po_pending_view->showPageHeader(); ?>
<?php
$po_pending_view->showMessage();
?>
<form name="fpo_pendingview" id="fpo_pendingview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($po_pending_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $po_pending_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="po_pending">
<input type="hidden" name="modal" value="<?php echo (int)$po_pending_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($po_pending->cart_id->Visible) { // cart_id ?>
	<tr id="r_cart_id">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_cart_id"><?php echo $po_pending->cart_id->caption() ?></span></td>
		<td data-name="cart_id"<?php echo $po_pending->cart_id->cellAttributes() ?>>
<span id="el_po_pending_cart_id">
<span<?php echo $po_pending->cart_id->viewAttributes() ?>>
<?php echo $po_pending->cart_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->po_id->Visible) { // po_id ?>
	<tr id="r_po_id">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_po_id"><?php echo $po_pending->po_id->caption() ?></span></td>
		<td data-name="po_id"<?php echo $po_pending->po_id->cellAttributes() ?>>
<span id="el_po_pending_po_id">
<span<?php echo $po_pending->po_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->po_id->getViewValue())) && $po_pending->po_id->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->po_id->linkAttributes() ?>><?php echo $po_pending->po_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->po_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->partner_order_no->Visible) { // partner_order_no ?>
	<tr id="r_partner_order_no">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_partner_order_no"><?php echo $po_pending->partner_order_no->caption() ?></span></td>
		<td data-name="partner_order_no"<?php echo $po_pending->partner_order_no->cellAttributes() ?>>
<span id="el_po_pending_partner_order_no">
<span<?php echo $po_pending->partner_order_no->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->partner_order_no->getViewValue())) && $po_pending->partner_order_no->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->partner_order_no->linkAttributes() ?>><?php echo $po_pending->partner_order_no->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->partner_order_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_status"><?php echo $po_pending->status->caption() ?></span></td>
		<td data-name="status"<?php echo $po_pending->status->cellAttributes() ?>>
<span id="el_po_pending_status">
<span<?php echo $po_pending->status->viewAttributes() ?>>
<?php echo $po_pending->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_company_id"><?php echo $po_pending->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $po_pending->company_id->cellAttributes() ?>>
<span id="el_po_pending_company_id">
<span<?php echo $po_pending->company_id->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->company_id->getViewValue())) && $po_pending->company_id->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->company_id->linkAttributes() ?>><?php echo $po_pending->company_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->company_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->ref->Visible) { // ref ?>
	<tr id="r_ref">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_ref"><?php echo $po_pending->ref->caption() ?></span></td>
		<td data-name="ref"<?php echo $po_pending->ref->cellAttributes() ?>>
<span id="el_po_pending_ref">
<span<?php echo $po_pending->ref->viewAttributes() ?>>
<?php echo $po_pending->ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->product_code->Visible) { // product_code ?>
	<tr id="r_product_code">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_product_code"><?php echo $po_pending->product_code->caption() ?></span></td>
		<td data-name="product_code"<?php echo $po_pending->product_code->cellAttributes() ?>>
<span id="el_po_pending_product_code">
<span<?php echo $po_pending->product_code->viewAttributes() ?>>
<?php echo $po_pending->product_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_quantity"><?php echo $po_pending->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $po_pending->quantity->cellAttributes() ?>>
<span id="el_po_pending_quantity">
<span<?php echo $po_pending->quantity->viewAttributes() ?>>
<?php echo $po_pending->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->stock->Visible) { // stock ?>
	<tr id="r_stock">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_stock"><?php echo $po_pending->stock->caption() ?></span></td>
		<td data-name="stock"<?php echo $po_pending->stock->cellAttributes() ?>>
<span id="el_po_pending_stock">
<span<?php echo $po_pending->stock->viewAttributes() ?>>
<?php echo $po_pending->stock->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->despatch_date->Visible) { // despatch_date ?>
	<tr id="r_despatch_date">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_despatch_date"><?php echo $po_pending->despatch_date->caption() ?></span></td>
		<td data-name="despatch_date"<?php echo $po_pending->despatch_date->cellAttributes() ?>>
<span id="el_po_pending_despatch_date">
<span<?php echo $po_pending->despatch_date->viewAttributes() ?>>
<?php echo $po_pending->despatch_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_grp"><?php echo $po_pending->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $po_pending->grp->cellAttributes() ?>>
<span id="el_po_pending_grp">
<span<?php echo $po_pending->grp->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->grp->getViewValue())) && $po_pending->grp->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->grp->linkAttributes() ?>><?php echo $po_pending->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->product->Visible) { // product ?>
	<tr id="r_product">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_product"><?php echo $po_pending->product->caption() ?></span></td>
		<td data-name="product"<?php echo $po_pending->product->cellAttributes() ?>>
<span id="el_po_pending_product">
<span<?php echo $po_pending->product->viewAttributes() ?>>
<?php if ((!EmptyString($po_pending->product->getViewValue())) && $po_pending->product->linkAttributes() <> "") { ?>
<a<?php echo $po_pending->product->linkAttributes() ?>><?php echo $po_pending->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $po_pending->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->partner_id->Visible) { // partner_id ?>
	<tr id="r_partner_id">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_partner_id"><?php echo $po_pending->partner_id->caption() ?></span></td>
		<td data-name="partner_id"<?php echo $po_pending->partner_id->cellAttributes() ?>>
<span id="el_po_pending_partner_id">
<span<?php echo $po_pending->partner_id->viewAttributes() ?>>
<?php echo $po_pending->partner_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->avg_quantity->Visible) { // avg_quantity ?>
	<tr id="r_avg_quantity">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_avg_quantity"><?php echo $po_pending->avg_quantity->caption() ?></span></td>
		<td data-name="avg_quantity"<?php echo $po_pending->avg_quantity->cellAttributes() ?>>
<span id="el_po_pending_avg_quantity">
<span<?php echo $po_pending->avg_quantity->viewAttributes() ?>>
<?php echo $po_pending->avg_quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($po_pending->m_out_id->Visible) { // m_out_id ?>
	<tr id="r_m_out_id">
		<td class="<?php echo $po_pending_view->TableLeftColumnClass ?>"><span id="elh_po_pending_m_out_id"><?php echo $po_pending->m_out_id->caption() ?></span></td>
		<td data-name="m_out_id"<?php echo $po_pending->m_out_id->cellAttributes() ?>>
<span id="el_po_pending_m_out_id">
<span<?php echo $po_pending->m_out_id->viewAttributes() ?>>
<?php echo $po_pending->m_out_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$po_pending_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$po_pending->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$po_pending_view->terminate();
?>